#version 450

#define FONT_SIZE vec2(8., 16.)

layout(location = 0) in uint x12y12text8;

noperspective layout(location = 0) out vec2 TexCoord;
noperspective layout(location = 1) out vec4 VertexColor;

layout(set = 1, binding = 0) uniform Parameters {
    vec2 resolution;
} param;

layout(set = 1, binding = 1) uniform Layer {
    vec2 offset;
    vec4 color[4];
} layer;

void main() {
    uint x = x12y12text8 >> 20;
    uint y = x12y12text8 >> 8 & ((1u << 12) - 1);
    uint ascii = x12y12text8 & ((1u << 8) - 1);

    vec2 size = FONT_SIZE / param.resolution * vec2(2., -2.);
    vec2 ndc = vec2(float(x), float(y)) * size + vec2(-1., 1.) + layer.offset / param.resolution;

    vec2 quad[4] = vec2[4](
            vec2(0., 1.),
            vec2(0., 0.),
            vec2(1., 1.),
            vec2(1., 0.)
        );
    vec2 vert = quad[gl_VertexIndex];

    TexCoord = (vert + vec2(float(ascii), 0.)) * FONT_SIZE;
    VertexColor = layer.color[gl_VertexIndex];
    gl_Position = vec4(ndc + vert * size, 0., 1.);
}
