
Demo.prototype.sceneCar = function () {
  this.setScene('car');

  this.loader.addAnimation({ image: '_embedded/defaultWhite.png', color: [{ r: 0, g: 0, b: 0 }] });

  this.addSkysphere();

  this.addEffectStarfield(0,300, 300, "multiSceneEffects/tex_basicParticle.png", 450,450,500, 0.4, null, 0,0,0, 0.15);
  this.addTrailerText({ text: "200% Adrenaline", x: 0, y: .27, scale: 4.0, gray:true });
  this.loader.addAnimation({
    light: {
      type: 'Point',
      properties: {
        intensity: 8.0,
        distance: 55,
        decay: .1,
      },
      castShadow: false,
    },
    position: [{ x: () => window.camPos[0] + .15 * Math.sin(getSceneTimeFromStart()), y: () => window.camPos[1] + Sync.get('Light:Y'), z: () => window.camPos[2] + .2, }]
  });

  this.loader.addAnimation([{
    object: {
      "name": "3d_models/road.obj"
    }

    , position: [{
      x: 0,
      y: () => Sync.get('Chase:RoadY'),
      z: 0,
    }]
    , scale: [{ "uniform3d": 33.5 }]
    , angle: [{
      degreesX: 0,
      degreesY: -90,
      degreesZ: 0,
    }],
    shader: {
      fragmentShaderPrefix: `
          uniform float fakeTime;
        `,
      fragmentShaderSuffix: `
          vec2 coord=vMapUv.xy;
          coord.t=coord.t+fakeTime;
          gl_FragColor = texture2D(map, coord)*1.5;
        `,
      variable: [
        { name: 'fakeTime', value: [() => 5 * getSceneTimeFromStart()] }
      ]
    }
  }]);

    this.loader.addAnimation([{
    object: {
      "name": "3d_models/roadsand.obj"
    }

    , position: [{
      x: 0,
      y: () => Sync.get('Chase:RoadY'),
      z: 0,
    }]
    , scale: [{ "uniform3d": 33.5 }]
    , angle: [{
      degreesX: 0,
      degreesY: -90,
      degreesZ: 0,
    }],
    shader: {
      fragmentShaderPrefix: `
          uniform float fakeTime;
        `,
      fragmentShaderSuffix: `
          vec2 coord=vMapUv.xy;
          coord.t=coord.t+fakeTime;
          gl_FragColor = texture2D(map, coord)*2.5;
        `,
      variable: [
        { name: 'fakeTime', value: [() => 5 * getSceneTimeFromStart()] }
      ]
    }
  }]);

  this.loader.addAnimation([{
    object: {
      "name": "3d_models/obj_car.obj"
    }
    , position: [{
      x: () => Sync.get('Chase:Car1_X'),
      y: () => Sync.get('Chase:Car1_Y'),
      z: () => Sync.get('Chase:Car1_Z'),
    }]

    , scale: [{ "uniform3d": .25 }]
    , angle: [{
      degreesX: 0,
      degreesY: 0,
      degreesZ: 0,
    }]
  }]);

  this.loader.addAnimation([{
    object: {
      "name": "3d_models/obj_car.obj"
    }
    , position: [{
      x: () => Sync.get('Chase:Car2_X'),
      y: () => Sync.get('Chase:Car2_Y'),
      z: () => Sync.get('Chase:Car2_Z'),
    }]

    , scale: [{ "uniform3d": .25 }]
    , angle: [{
      degreesX: 0,
      degreesY: 0,
      degreesZ: 0,
    }]
  }]);



};