
Demo.prototype.sceneCatBattle = function () {
  this.setScene('catBattle');

  this.loader.addAnimation({ image: '_embedded/defaultWhite.png', color: [{ r: 0, g: 0, b: 0 }] });

  this.loader.addAnimation({
    light: {
      type: 'Point',
      properties: {
        intensity: 8.0,
        distance: 40,
        decay: .1,
      },
      castShadow: true,
    },
    position: [{ x: () => window.camPos[0] + .15 * Math.sin(getSceneTimeFromStart()), y: () => window.camPos[1] + Sync.get('Light:Y'), z: () => window.camPos[2] + .2, }]
  });

  Utils.setSeed(62);

  const explosionStartTimes = [
    window.tick*14,
    window.tick*59,
    window.tick*51,
    window.tick*42,
    window.tick*33];

  for (let i = 0; i < 5; i++) {

    let randomz = Utils.random();
    let randomy = Math.random();
    this.loader.addAnimation([{
          object: null,
      id: "kissa" + i,
      scale: [{ "uniform3d": .52 }],
      position: [{
      x: () => 2 - i * 1,
        y: () => -1.9 + .2 * Math.sin(10 * getSceneTimeFromStart()+randomy*5),
        z: () => -2.25 - randomz * 10
      }] 
    }]);

    this.loader.addAnimation([{
      duration:explosionStartTimes[i],
      parent:"kissa"+i,
      object: {
        "name": "3d_models/adan_kissa.obj"
      }
      , angle: [{
        degreesX: () => 0,
        degreesY: () => 0,
        degreesZ: () => 0,
      }]
    }]);

    this.addEffectExplosion(
      "multiSceneEffects/tex_bloodParticle.png",
      null,                   // model
      explosionStartTimes[i], 2,  // startTime, duration
      9, 55, .5,  // maxDist, amount, scale
      0, 2, 1,        // posX, posY, posZ
      0, 0, 0,        // startDim
      1, 1, .25,   // dimX, dimY, dimZ
      0, 0.1, 0,        // xOffset, yOffset, zOffset
      "AdditiveBlending", // blendmode
      "kissa" + i);

      this.addEffectExplosion(
      "multiSceneEffects/tex_basicParticle.png",
      null,                   // model
      explosionStartTimes[i], 2,  // startTime, duration
      9, 55, .5,  // maxDist, amount, scale
      0, 2, 1,        // posX, posY, posZ
      0, 0, 0,        // startDim
      1, 1, .25,   // dimX, dimY, dimZ
      0, 0.1, 0,        // xOffset, yOffset, zOffset
      "SubtractiveBlending", // blendmode
      "kissa" + i);

  }


  this.loader.addAnimation([{
    object: {
      "name": "3d_models/hall.obj"
    }
    , position: [{
      x: 0,
      y: 0,
      z: -35,
    }]

    , scale: [{ "uniform3d": 3.0 }]
    , angle: [{
      degreesX: 0,
      degreesY: 0,
      degreesZ: 0,
    }]
  }]);

  this.addTrailerText({ text: "Brutal Action", x: 0, y: .5, scale: 2.0 });
  this.loader.addAnimation([{
    id: "ak47_1",
    object: {
      "name": "3d_models/obj_ak.obj"
    }
    , position: [{
      x: () => window.camPos[0] + .3,
      y: () => window.camPos[1] - .3,
      z: () => window.camPos[2] - .5-.25*Math.sin(25*getSceneTimeFromStart())
    }]
    , scale: [{ "uniform3d": .32 }]
    , angle: [{
      degreesX: () => 0,
      degreesY: () => -90,
      degreesZ: () => 0,
    }]
  }]);

  this.addTrailerText({ text: "Brutal Action", x: 0, y: .5, scale: 2.0 });
  this.loader.addAnimation([{
    id: "ak47_2",
    object: {
      "name": "3d_models/obj_ak.obj"
    }
    , position: [{
      x: () => window.camPos[0] - .3,
      y: () => window.camPos[1] - .3,
      z: () => window.camPos[2] - .5+.25*Math.sin(25*getSceneTimeFromStart())
    }]
    , scale: [{ "uniform3d": .32 }]
    , angle: [{
      degreesX: () => 0,
      degreesY: () => -90,
      degreesZ: () => 0,
    }]
  }]);

  for (let i = 0; i < 2; i++) {
    const parentId = "ak47_" + (i + 1);
        const muzzleAlpha = ()=>{
          //return 1.0;
          const ak47BurstRate = 100./60.*25.;
          const fire = 1.0;
          const value = fire*((Math.sin(i*0.8+ak47BurstRate * (getSceneTimeFromStart() + 10.0))+1)/2);
          return value<0.95?0.0:1.0;
          //return 0.0;
        };
        const muzzleAdditive = true;

        this.loader.addAnimation({
          "parent":parentId
         ,"image":{
            "name":"sceneCatBattle/muzzle_flame.png"
          }
          ,"additive":muzzleAdditive
          ,"perspective":"3d"
          ,"position":[{
            "x":-3.25,
            "y":0.5,
            "z":0
          }]
          ,"color":[{"a":muzzleAlpha}]
          ,"angle":[{
            "degreesY":-90,
            }]
          ,"scale":[{"uniform3d":()=>2.0+Math.sin(i*getSceneTimeFromStart()*20.0)*0.1}]
          ,"shader":{"name":"sceneCatBattle/muzzle.fs"
            ,"variable": [
              {"name":"strength","value":[1.0]},
              {"name":"iteration","value":[Utils.random()*30.0]}
            ]
            }
        });  
        this.loader.addAnimation({
          "parent":parentId
         ,"image":{
            "name":"sceneCatBattle/tex_muzzle.png"
          }
          ,material:{side:'DoubleSide'}
          ,"additive":muzzleAdditive
          ,"perspective":"3d"
          ,"position":[{
            "x":-4.3,
            "y":0.4,
            "z":0
          }]
          ,"color":[{"a":muzzleAlpha}]
          ,"scale":[{"uniform3d":()=>1.0+Math.sin(i*getSceneTimeFromStart()*20.0)*0.1}]
          ,"shader":{"name":"sceneCatBattle/muzzle.fs"
            ,"variable": [
              {"name":"strength","value":[1.0]},
              {"name":"iteration","value":[Utils.random()*30.0]}
            ]
            }
        });  
        this.loader.addAnimation({
          "parent":parentId
         ,"image":{
            "name":"sceneCatBattle/tex_muzzle.png"
          }
          ,material:{side:'DoubleSide'}
          ,"additive":muzzleAdditive
          ,"perspective":"3d"
          ,"position":[{
            "x":-4.3,
            "y":0.4,
            "z":0
          }]
          ,"color":[{"a":muzzleAlpha}]
          ,"angle":[{
            "degreesX":-90,
            }]
          ,"scale":[{"uniform3d":()=>1.0+Math.sin(i*getSceneTimeFromStart()*20.0)*0.1}]
          ,"shader":{"name":"sceneCatBattle/muzzle.fs"
            ,"variable": [
              {"name":"strength","value":[1.0]},
              {"name":"iteration","value":[Utils.random()*30.0]}
            ]
            }
        });
      }
  
      this.addTrailerText({ text: "Brutal Action", x: 0, y: .15, scale: 3.0 });

};