
Demo.prototype.sceneDestruction = function () {
  this.setScene('destruction');

  this.loader.addAnimation({ image: '_embedded/defaultWhite.png', color: [{ r: 0, g: 0, b: 0 }] });


  const addPlasmaSkysphere = () => {
    const angle = -20.0;
  const skyColor = 0.4;
  this.loader.addAnimation({
    object: 'multiSceneEffects/tex_milky_way.png',
    shape: { type: 'SKYSPHERE' },
    color: [{ r: skyColor, g: skyColor, b: skyColor }],
    "angle":[{
      "degreesX":angle
      }],
    shader:{
      vertexShaderPrefix:`
        uniform float time;
      `,
      vertexShaderSuffix:`
        vMapUv.x = vMapUv.x - time * 0.002;
      `,
      fragmentShaderPrefix:`
        uniform float time;
        //uniform vec4 color;
void drawSphereEffect()
{
  vec2 uv = vMapUv.xy;

  vec2 uvWavy = uv;
  uvWavy.x += sin(uv.y * 10.0 + time * 0.1) * 0.05;
  uvWavy.y += cos(uv.x * 10.0 + time * 0.1) * 0.05;
  vec4 originalTexture = texture(map,uvWavy);

  vec2 uvWavy2 = uv*0.8;
  uvWavy2.x += sin(uv.x * 10.0 + time * 0.09) * 0.05;
  uvWavy2.y += cos(uv.y * 10.0 + time * 0.12) * 0.05;
  vec4 originalTexture2 = texture(map,uvWavy2);

  vec2 uvWavy3 = uv*0.6;
  uvWavy3.x += sin(uv.x * 10.0 + time * 0.08) * 0.05;
  uvWavy3.y += cos(uv.y * 10.0 + time * 0.13) * 0.05;
  vec4 originalTexture3 = texture(map,uvWavy3);

  vec3 textureBlend = min(originalTexture.rgb + originalTexture2.rgb + originalTexture3.rgb, vec3(1.0));

  uv *= 20.0;
  float plasma1 = sin(uv.x + time * 0.3);
  float plasma2 = sin(uv.y + time * 0.2);
  float plasma3 = sin((uv.x + uv.y) * 0.5 + time * 0.4);
  float plasma4 = sin(sqrt(uv.x * uv.x + uv.y * uv.y) + time * 0.5);
  float plasma = (plasma1 + plasma2 + plasma3 + plasma4) * 0.25;
  vec3 color1 = vec3(1.0, 0.2, 0.1);
  vec3 color2 = vec3(0.1, 0.3, 1.0);
  vec3 color3 = vec3(1.0, 0.8, 0.1);
  
  vec3 finalColor = mix(color1, color2, sin(plasma * 3.14159) * 0.5 + 0.5);
  finalColor = mix(finalColor, color3, cos(plasma * 2.0 + time * 0.001) * 0.3 + 0.3);
  float brightness = sin(plasma * 2.0 + time * 0.002) * 0.3 + 0.7;
  finalColor *= brightness;

  gl_FragColor = vec4(min(finalColor * (textureBlend*2.0), vec3(1.0)), 1.0);
  gl_FragColor.rgb *= ${skyColor};
}
      `,
      fragmentShaderSuffix:`

      drawSphereEffect();
      `
    }
  });
  };
  
  addPlasmaSkysphere();
  this.addTrailerText({text:"DESTROY THE ENEMIES OF MANKIND",x:0,y:.18,scale:1.50});
    this.addEffectStarfield(0,300, 300, "multiSceneEffects/tex_basicParticle.png", 450,450,500, 0.4, null, 0,0,0, 0.15);
    this.loader.addAnimation([{
      object:{
          "name":"3d_models/airhorn.obj"
        }
      ,position:[{
        x:()=>Sync.get('Airhorn:X1'),
        y:()=>Sync.get('Airhorn:Y1'),
        z:()=>Sync.get('Airhorn:Z1')
      }]
      ,scale:[{"uniform3d":()=>Sync.get('Airhorn:scale')}]
      ,angle:[{              
        degreesX:()=>Sync.get('Airhorn:rotX') ,      
        degreesY:()=>Sync.get('Airhorn:rotY') + 6*Math.sin(getSceneTimeFromStart()*3),    
        degreesZ:()=>Sync.get('Airhorn:rotZ') + 6*Math.sin(getSceneTimeFromStart()*4)             
      }]
    }]);

          this.loader.addAnimation([
      {
        object: {
          name: '3d_models/obj_allseeing.obj'
        },
        position: [
          {
            x: ()=>.25+.025*Math.sin(getSceneTimeFromStart()*Sync.get('Destr:shake')) ,
            y: ()=>.05*Math.sin(getSceneTimeFromStart()*3)+.1,
            z: 0
          }
        ],
        angle: [
          {
            degreesY: () => -200*getSceneTimeFromStart(),
          }
        ],
        scale: [{ uniform3d: ()=>Sync.get('Destr:allseeing')  }]
      }
    ]);

      this.loader.addAnimation([
      {
        image: {
          name: 'images/zeushead.png'
        },
        position: [
          {
            x: ()=>.2+.025*Math.sin(getSceneTimeFromStart()*Sync.get('Destr:shake')) ,
            y: ()=>.05*Math.sin(getSceneTimeFromStart()*3),
            z: 0
          }
        ],
        angle: [
          {
            degreesY: 0,
          }
        ],
        scale: [{ uniform3d: ()=>Sync.get('Destr:zeus')  }]
      }
    ]);

          this.loader.addAnimation([
      {
        image: {
          name: 'images/republican.png'
        },
        position: [
          {
            x: ()=>.2+.025*Math.sin(getSceneTimeFromStart()*Sync.get('Destr:shake')) ,
            y: ()=>.05*Math.sin(getSceneTimeFromStart()*3),
            z: 0
          }
        ],
        angle: [
          {
            degreesY: 0,
          }
        ],
        scale: [{ uniform3d: ()=>Sync.get('Destr:republican')  }]
      }
    ]);
    this.loader.addAnimation([{
      object:{
          "name":"3d_models/airhorn.obj"
        }
      ,position:[{
        x:()=>Sync.get('Airhorn2:X1')+.025*Math.sin(getSceneTimeFromStart()*Sync.get('Destr:shake')) ,
        y:()=>Sync.get('Airhorn2:Y1'),
        z:()=>Sync.get('Airhorn2:Z1')
      }]
      ,scale:[{"uniform3d":()=>Sync.get('Airhorn2:scale')}]
      ,angle:[{              
        degreesX:()=>Sync.get('Airhorn2:rotX') ,      
        degreesY:()=>Sync.get('Airhorn2:rotY') ,    
        degreesZ:()=>Sync.get('Airhorn2:rotZ') ,             
      }]
    }]);
    for(let i=0;i<4;i++)
   {
    this.addEffectExplosion(
      "multiSceneEffects/tex_basicParticle.png",
      null,                   // model
      .5*pattern+pattern*i, 2,  // startTime, duration
      9, 155, .15,  // maxDist, amount, scale
      0.28, -.04, 0,        // posX, posY, posZ
      0, 0, 0,        // startDim
      1, 1, .25,   // dimX, dimY, dimZ
      0, 0, 0,        // xOffset, yOffset, zOffset
      "AdditiveBlending", // blendmode
      null);
  }
};