Demo.prototype.backFromLevelEnd = function () {
    window.levelEnd = false;
    window.finalScore = 0;
    window.levelEndTime = 0;
    window.prevLevelEnd= false;
    this.updateBackButtonVisibility();
};

Demo.prototype.addLevelEnd = function ()
{    
    this.backFromLevelEnd();


    window.latestHighScores = new Array(5);
    for(let i = 0; i<window.latestHighScores.length;i++)
    {
        window.latestHighScores[i] = {
            playerName: ' ',
            score: '',
            blink: false
        };
        console.log(window.latestHighScores[0].name);
    }

    this.loader.addAnimation({
        levelEndDuration: 10,
        runFunction:(animation)=>{
            if(window.levelEnd == false)
                return;

            if(window.levelEnd == true && window.prevLevelEnd != true)
            {
                window.prevLevelEnd = true;
                window.levelEndTime = getSceneTimeFromStart() + animation.levelEndDuration;
            }
        
            if(window.levelEnd == true && getSceneTimeFromStart() > window.levelEndTime)
            {
          
                window.prevLevelEnd= false;
                window.levelEnd = false;
            }

            if(window.fire[0] && getSceneTimeFromStart() > window.levelEndTime-8)
            {
                window.prevLevelEnd = false;
                window.levelEnd = false;
            }
        }
    });


    this.loader.addAnimation({ image: '_embedded/defaultWhite.png', material:{depthWrite:()=>window.levelEnd},  color: [{ r: 0, g: 0, b: 0, a:()=>{return window.levelEnd ? 1.0 : 0.0;}}] });

    this.loader.addAnimation({
      image: 'multiSceneEffects/tex_nuke.png',
      color: [{r:1,g:1,b:1,a:()=>{return window.levelEnd ? 1.0 : 0.0;} }],
      perspective:"2d",
      position:[{x:()=>.02*Math.sin(Math.random()*360), y:()=>.02*Math.sin(Math.random()*360)}],
      scale: [{ uniform2d:6.0 }],
      material:{depthWrite:()=>window.levelEnd},
      runFunction:(animation)=>{
        animation.scale[0].x = 6 - .2*Math.abs(window.levelEndTime-getSceneTimeFromStart());
        animation.scale[0].y = 6 - .2*Math.abs(window.levelEndTime-getSceneTimeFromStart());
      }     
      
    });

    this.loader.addAnimation([{
        text:{string:()=>""+window.finalScore,name:'multiSceneEffects/monoSpace.ttf'},
        perspective:"2d", 
        color:[{"r":.0,"g":.0,"b":.0,"a":()=>{return window.levelEnd ? 1.0 : 0.0;}}],
        position:[{x:0, y:0}],
        scale: [{ uniform3d: 20 }],
        material:{depthWrite:()=>window.levelEnd},
        runFunction:(animation)=>{
            animation.scale[0].x = 15 + Math.abs(window.levelEndTime-getSceneTimeFromStart());
            animation.scale[0].y = 15 + Math.abs(window.levelEndTime-getSceneTimeFromStart());
        }     
    }]);
    
    
    this.loader.addAnimation({
        runFunction: (animation) => {
            if (!window.gameActive) {
                const highScoreDiv = document.getElementById('highScoreDiv');
                if (!highScoreDiv) return;
                
                const scale = 1.0 + 0.03 * Math.sin(4.5 * getSceneTimeFromStart());

                const scoreEntries = highScoreDiv.querySelectorAll('.score-entry');
                scoreEntries.forEach((entry, index) => {
                    const rotationAngle = 0.1 * Math.sin(getSceneTimeFromStart() * (6+index)) * 5;
                    entry.style.transform = `scale(${scale}) rotateZ(${rotationAngle}deg)`;
                });
            }
        }
    });

    /*const MAX_HIGH_SCORES_PER_LEVEL = 2;
    for(let i=0;i<MAX_HIGH_SCORES_PER_LEVEL;i++)
    {
        let y = .2-i*.1;
        let x = 0;

        this.addScoreText({
        text: ()=> window.levelEnd ? playerScore(window.latestHighScores[i]?.playerName||'???', window.latestHighScores[i]?.score||0, 23) : '',
        //text: 'test',
        x: x,
        y: y,
        x2: x+ 0.003,
        y2: y -0.003,
        x3: x -0.003,
        y3: y +0.003,
        rangle:0,
        wobble:false,
        iterator: i, //()=>window.latestHighScores[i].blink,
        scale:()=>2.0+.1*Math.sin(4.5*getSceneTimeFromStart()),
        r:1,g:1,b:1,
        monoSpace: true
        });
    }*/
};
/*
Demo.prototype.addScoreText = function (
  textData
) {

  let rangle = Math.random()*5-2.5;
  let fontti = "multiSceneEffects/trailertext1.ttf";
  if (textData.monoSpace == true)
    fontti = "multiSceneEffects/monoSpace.ttf";
  
  if(textData.wobble == true)
  {
    rangle = function () {return .1*Math.sin(getSceneTimeFromStart()*6)*15};
  }
    else rangle = 0;

  this.loader.addAnimation([{
    text:{string:textData.text,name:fontti},
    visible: ()=>window.levelEnd,
    cursor: textData.cursor,
    perspective:"2d", 
    color:[{"r":0,"g":0,"b":0,"a":1.0}],
    position:[{x:textData.x3, y:textData.y3}],
            material:{depthWrite:true},
    scale: [{ uniform3d: textData.scale }],
    angle: [{ degreesZ:rangle}]
    }]);

  this.loader.addAnimation([{
    text:{string:textData.text,name:fontti},
    visible: ()=>window.levelEnd,
    perspective:"2d", 
    color:[{"r":0,"g":0,"b":0,"a":1.0}],
    position:[{x:textData.x2, y:textData.y2}],
            material:{depthWrite:true},
    scale: [{ uniform3d: textData.scale }],
    angle: [{ degreesZ:rangle}]
    }]);

  this.loader.addAnimation([{
    text:{string:textData.text,name:fontti},
    visible: ()=>window.levelEnd,
    perspective:"2d", 
    color:[{"r":textData.r,"g":textData.g,"b":textData.b,"a":1.0}],
    position:[{x:textData.x, y:textData.y}],
            material:{depthWrite:true},
    scale: [{ uniform3d: textData.scale }],
    angle: [{ degreesZ:rangle}],
    nextTime:0,
    interval:.2,
    iterator: textData.iterator,
    runFunction:(animation)=>
    {
        if(window.levelEnd && window.latestHighScores[textData.iterator].blink == true)
        {
            if(getSceneTimeFromStart() >= animation.nextTime)
            {
                animation.color[0].r = Math.abs(Math.random());
                animation.color[0].g = Math.abs(Math.random());
                animation.color[0].b = Math.abs(Math.random());
                animation.nextTime = getSceneTimeFromStart()  + animation.interval;
            }
      }
    }
    }]);
    

};*/

function playerScore(name, score, totalLength = 20) {
  name = name.toString();
  score = ('00000'+score.toString()).slice(-5);
  const spaceCount = totalLength - name.length - score.length;
  const spacer = ' '.repeat(Math.max(spaceCount, 1));
  return name + spacer + score;

}

Demo.prototype.closeHighScoreDiv = function () {
    const existingDiv = document.getElementById('highScoreDiv');
    if (existingDiv) {
        existingDiv.remove();
        return true;
    }

    return false;
};

Demo.prototype.createHighScoreDiv = function () {
    this.closeHighScoreDiv();

    const bodyRect = document.body.getBoundingClientRect();    
    const maxWidth = bodyRect.width * 0.8;
    const maxHeight = bodyRect.height * 0.8;
    
    let divWidth, divHeight;
    const aspectRatio = 16 / 9;
    if (maxWidth / aspectRatio <= maxHeight) {
        divWidth = maxWidth;
        divHeight = maxWidth / aspectRatio;
    } else {
        divHeight = maxHeight;
        divWidth = maxHeight * aspectRatio;
    }
    
    const charWidth = divWidth / 30;
    const availableHeight = divHeight - 40; 
    const lineHeight = availableHeight / 5;
    const fontSize = Math.min(charWidth * 1.6, lineHeight * 0.9); 

    const highScoreDiv = document.createElement('div');
    highScoreDiv.onclick = () => {
      highScoreDiv.style.display = 'none';
    };
    highScoreDiv.id = 'highScoreDiv';
    highScoreDiv.style.position = 'fixed';
    highScoreDiv.style.top = '50%';
    highScoreDiv.style.left = '50%';
    highScoreDiv.style.transform = 'translate(-50%, -50%)';
    highScoreDiv.style.width = divWidth + 'px';
    highScoreDiv.style.height = divHeight + 'px';
    highScoreDiv.style.zIndex = '999999';
    highScoreDiv.style.pointerEvents = 'none';
    highScoreDiv.style.textAlign = 'center';
    highScoreDiv.style.color = 'white';
    highScoreDiv.style.textShadow = '2px 2px 4px rgba(0,0,0,0.8)';
    highScoreDiv.style.fontSize = fontSize + 'px';
    highScoreDiv.style.lineHeight = (lineHeight / fontSize).toFixed(2);
    highScoreDiv.style.userSelect = 'none';
    highScoreDiv.style.whiteSpace = 'pre';
    highScoreDiv.style.display = 'flex';
    highScoreDiv.style.flexDirection = 'column';
    highScoreDiv.style.justifyContent = 'center';
    highScoreDiv.style.alignItems = 'center';
    highScoreDiv.style.visibility = 'visible';
    highScoreDiv.style.opacity = '1';
    highScoreDiv.style.background = 'rgba(0, 0, 0, 0.7)';
    highScoreDiv.style.padding = '20px';
    highScoreDiv.style.border = '2px solid gray';
    highScoreDiv.style.borderRadius = '2px';
    highScoreDiv.style.boxSizing = 'border-box';
    highScoreDiv.style.overflow = 'hidden';

    highScoreDiv.style.fontFamily = 'monoSpace, monospace';
    const MAX_HIGH_SCORES_PER_LEVEL = 5;
    for(let i = 0; i < MAX_HIGH_SCORES_PER_LEVEL; i++) {
        const scoreEntry = document.createElement('div');
        scoreEntry.className = 'score-entry';
        scoreEntry.style.marginBottom = i < MAX_HIGH_SCORES_PER_LEVEL - 1 ? Math.max(2, lineHeight * 0.05) + 'px' : '0px';
        scoreEntry.style.fontSize = 'inherit';
        scoreEntry.style.lineHeight = 'inherit';
        scoreEntry.style.width = '100%';
        scoreEntry.style.overflow = 'hidden';
        scoreEntry.style.textOverflow = 'ellipsis';
        scoreEntry.style.textAlign = 'center';
        scoreEntry.style.flexShrink = '0';
        
        const playerScoreText = playerScore(
            window.latestHighScores[i]?.playerName || '???', 
            window.latestHighScores[i]?.score || 0, 
            28
        );
        
        scoreEntry.textContent = playerScoreText;
        
        if (window.latestHighScores[i]?.blink) {
            scoreEntry.classList.add('blink-score');
            scoreEntry.style.animation = 'colorBlink 1.0s infinite alternate';
        }
        
        highScoreDiv.appendChild(scoreEntry);
    }

    if (!document.getElementById('highScoreStyles')) {
        const style = document.createElement('style');
        style.id = 'highScoreStyles';
        style.textContent = `
            @keyframes colorBlink {
                0% { color: white; }
                33% { color: #ff0000; }
                66% { color: #00ff00; }
                100% { color: #0000ff; }
            }
        `;
        document.head.appendChild(style);
    }

    document.body.appendChild(highScoreDiv);
    
    return highScoreDiv;
};