Demo.prototype.sceneOutro = function () {
    this.setScene('outro');

    this.loader.addAnimation({
      image: ['sceneOutro/tex_bgnonsense1.png'],
      perspective: '3d',
      position: [
        {
          x: 0,
          y: 0,
          z: -16
        }
      ],
      textureProperties: [{ wrapS: 'RepeatWrapping', wrapT: 'RepeatWrapping' }],
      scale: [{ uniform3d: 81.0 }],
      shader: {
        name: 'multiSceneEffects/background.fs',
        variable: [
          // chainEffectN value = <baseeffect>.<mix amount = .0 (all), .999 (minimum)>
          { name: 'chainEffect0', value: [0] },
          { name: 'chainEffect1', value: [4] },
          { name: 'chainEffect2', value: [5] },
          { name: 'chainEffect2', value: [2] },
          // chaineffect base effect numbers:
          // 0: no-operation
          // 1: texcoordinate bias
          {
            name: 'coordBias',
            value: [
              () => -.25*getSceneTimeFromStart(),
              () => .25*getSceneTimeFromStart()
            ]
          },
          // 2: texcoordinate bias 2
          {
            name: 'coordBias2',
            value: [
              () => -2*Math.sin(getSceneTimeFromStart()*.13),
              () => 2*Math.sin(getSceneTimeFromStart()*.29),
            ]
          },
          // 3: kaleidoscope
          {
            name: 'kaleidoscopeXangle',
            value: [()=>1+Math.sin(getSceneTimeFromStart())]
          },
          // 4: funky deformation
          // 5: rotozoom
          { name: 'angle', value: [() => .25*getSceneTimeFromStart()] },
          { name: 'zoom', value: [() => .5+Math.abs(Math.sin(getSceneTimeFromStart()))] },
          // 6: tunnel
          // 7: plasma deformation
          {
            name: 'scale',
            value: [
              () => Math.sin(getSceneTimeFromStart()*15),
              () => Math.sin(getSceneTimeFromStart()*19),
            ]
          },
          { name: 'speed', value: [1.0] },
          // 8: mirror scroll
          {
            name: 'mirrorSpeed',
            value: [
              () => .1,
              () => .4
            ]
          }
        ]
      }
    });

  let headerY = .18;

    this.addMenuText({
      text: 'AIRHORN ANTI-HERO',
      x: 0,
      y:headerY,
      x2: 0.003,
      y2: headerY-0.003,
      x3: -0.003,
      y3: headerY+0.003,
      rangle:0,
      wobble:true,
      cycle:true,
      scale:()=>2.5+.2*Math.sin(4.5*getSceneTimeFromStart()),
      r:1,g:1,b:1
    });

  let jX = 0;
  let jY = -.15;

  this.addMenuText({
      text: 'AVAILABLE NOW',
      x: jX,
      y: jY,
      x2: jX+0.002,
      y2: jY+0.002,
      x3: jX-0.002,
      y3: jY-0.002,
      rangle:0,
      wobble:false,
      cycle:false,
      monoSpace: true,
      rangle: 0,
      scale:2.0,
      r:1,g:1,b:1
    });
  
  jY = jY-.05;
  this.addMenuText({
      text: `WWW.JUMALAUTA.ORG/AHAH`,
      x: jX,
      y: jY,
      x2: jX+0.001,
      y2: jY+0.001,
      x3: jX-0.001,
      y3: jY-0.001,
      rangle:0,
      wobble:false,
      cycle:false,
      monoSpace: true,
      rangle: 0,
      scale:1.8,
      r:1,g:1,b:1
    });  

    this.loader.addAnimation({ image: 'sceneOutro/qr.png',    angle:[{degreesZ:11.5}], position: [{ x: -0.0, y: -0.0 }], scale: [{ uniform3d: ()=>3.1+.1*Math.sin(2*getSceneTimeFromStart()) }] });
};

Demo.prototype.addMenuText = function (
  textData
) {

  let rangle = Math.random()*5-2.5;
  let fontti = "multiSceneEffects/trailertext1.ttf";
  if (textData.monoSpace == true)
    fontti = "multiSceneEffects/monoSpace.ttf";

  let startTime = 0;
  if (textData.startTime == undefined)
    startTime = 0;
  else
    startTime = textData.startTime;

  if(textData.wobble == true)
  {
    rangle = function () {return .1*Math.sin(getSceneTimeFromStart()*6)*15;};
  }
    else rangle = textData.rangle;

  this.loader.addAnimation([{
    start: startTime,
    text:{string:textData.text,name:fontti},
    cursor: textData.cursor,
    perspective:"2d", 
    color:[{"r":0,"g":0,"b":0,"a":1.0}],
    position:[{x:textData.x3, y:textData.y3}],
            material:{depthWrite:true},
    scale: [{ uniform3d: textData.scale }],
    angle: [{ degreesZ:rangle}],
    visible: textData.visible
    }]);

  this.loader.addAnimation([{
    start: startTime,
    text:{string:textData.text,name:fontti},
    perspective:"2d", 
    color:[{"r":0,"g":0,"b":0,"a":1.0}],
    position:[{x:textData.x2, y:textData.y2}],
            material:{depthWrite:true},
    scale: [{ uniform3d: textData.scale }],
    angle: [{ degreesZ:rangle}],
    visible: textData.visible
    }]);

  this.loader.addAnimation([{
    start: startTime,
    text:{string:textData.text,name:fontti},
    perspective:"2d", 
    color:[{"r":textData.r,"g":textData.g,"b":textData.b,"a":1.0}],
    position:[{x:textData.x, y:textData.y}],
            material:{depthWrite:true},
    scale: [{ uniform3d: textData.scale }],
    angle: [{ degreesZ:rangle}],
    visible: textData.visible,
    nextTime:0,
    interval:.1,
    runFunction:(animation)=>
    {
    if(textData.cycle == true)
      if(Math.abs(getSceneTimeFromStart()-animation.nextTime) > animation.interval)
      {
        animation.color[0].r = Math.abs(Math.random());
        animation.color[0].g = Math.abs(Math.random());
        animation.color[0].b = Math.abs(Math.random());
        animation.nextTime = getSceneTimeFromStart()  + animation.interval;
      }
    }
    }]);
    
};
