	;
	; TAKE SIN/COS SEGMENT VALUE
GSEG1:	ASL R0
	MOV SCTAB(R0),R1
	RET
GSEG2:	CALL GSEG4
	BR GSEGN
GSEG3:	CALL GSEG1
GSEGN:	NEG R1
	RET
GSEG4:	MOV #177,R1
	SUB R0,R1
	MOV R1,R0
	BR GSEG1
	; GET R1=COS(R0) R0=0..511
GCOS:	MOV R0,R1
	BIC #177600,R0
	BIC #177177,R1
	BEQ GSEG1
	CMP R1,#200
	BEQ GSEG2
	CMP R1,#400
	BEQ GSEG3
	BR GSEG4
	; GET R1=SIN(R0) R0=0..511
GSIN:	MOV R0,R1
	BIC #177600,R0
	BIC #177177,R1
	BEQ GSEG4
	CMP R1,#200
	BEQ GSEG1
	CMP R1,#400
	BEQ GSEG2
	BR GSEG3
	;
	; GET BOTH SIN AND COS FROM TABLE
	; INP: R0=ANGLE
	; OUT: R0=COS(ANGLE),R1=SIN(ANGLE)
GSNCS:	CALL GSNCS2
	BR GSNCS3
GSNCS2:	MOV R0,-(SP)
	CALL GCOS
	MOV (SP)+,R0
	MOV R1,-(SP)
	CALL GSIN
	MOV (SP)+,R0
	SWAB R0
	MOVB R0,R0
	SWAB R1
	MOVB R1,R1
GSNCS3:	ASR R1
	ASR R0
	RET
	;
	; R2=R0*R1 SIGNED
SPMULS:	MOV R0,R2
	BPL 1$
	NEG R0
1$:	XOR R1,R2
	TST R1
	BPL 2$
	NEG R1
2$:	MOV R2,-(SP)
	; OPTIMIZE
	CMP R0,R1
	BLOS 8$
	XOR R0,R1
	XOR R1,R0
	XOR R0,R1
	; UNSIGNED MUL LOOP
8$:	CLR R2
	BR 6$
4$:	BCC 5$
	ADD R1,R2
5$:	ASL R1
6$:	ROR R0
	BNE 4$
	BCC 7$
	ADD R1,R2
	; PUT SIGN
7$:	TST (SP)+
	BPL 3$
	NEG R2
3$:	RET
	;
	; THIS DIV CODE	FROM EIS DRIVER
	; BY MANWE/SANDS
	; R2=R2/R4
SPDVX:	CLR R1 ; DIVIDE	16384 BY R4
	MOV R1,R2
	MOV #15.,R3
	SEC
	BR 3$
SPDIV:	CLR R1
	MOV #16.,R3
1$:	ASL R2
	BCS 3$
	BEQ 5$ ; IF ZERO/SOME
	SOB R3,1$
2$:	ASL R2
3$:	ROL R1
	CMP R1,R4
	BLO 4$
	SUB R4,R1
	INC R2
4$:	SOB R3,2$
5$:	RET
	;
	; DIVIDE: R2=R4R3/R5
	; IN: R4(HI),R3(LO),R5
	; OUT: R1(REM),R2(DIVIDIEND)
OVRFL:	MOV #-1,R1
	MOV R1,R2
	RET
	;
DIV32:	TST R4
	BNE 1$
	TST R3
	BNE 1$
	CLR R1
	CLR R2
	RET
	;
1$:	CLR R2
	TST R5
	BEQ OVRFL
	BPL 3$
	NEG R5
	INC R2
3$:	TST R4
	BEQ DIV0
	BPL 4$
	COM R4
	NEG R3
	INC R2
	BIS #100000,R2
4$:	CMP R4,R5
	BGE OVRFL
	BR DIV1
	;
DIV0:	MOV R2,-(SP)
	CLR R1
	MOV #16.,R0
1$:	ASL R3
	BCS 21$
	SOB R0,1$
2$:	ASL R3
21$:	ROL R1
	CMP R1,R5
	BLO 3$
	SUB R5,R1
	INC R3
3$:	SOB R0,2$
	MOV R3,R2
	BR DIV2
	;
DIV1:	MOV R2,-(SP)
	CLR R1
	MOV #32.,R0
	MOV #177777,R2
1$:	ASL R3
	ROL R4
	ROL R1
	BNE 3$
	SOB R0,1$
2$:	ROL R1
3$:	CMP R1,R5
	BLO 4$
	SUB R5,R1
4$:	ROL R2
	ASL R3
	ROL R4
	SOB R0,2$
	;
	COM R2
	;
DIV2:	MOV (SP)+,R0
	BPL 1$
	NEG R1
1$:	ASR R0
	BCC 2$
	NEG R2
2$:	RET
	;
	.END
 