align	macro n
	org ($ + n - 1) / n * n
	endm
	
	org 0x6000

we_are_gathered
	incbin "we-are-gathered.bin"
crusty_cob
	incbin "crusty-cob.bin"

	org 0x8000

revealdelay	macro
	halt
	endm

; clear screen
	ld hl,0x4000
	ld de,0x4001
	ld bc,0x1800
	ld (hl),l
	ldir
	ld (hl),0x47  ; bright white
	ld bc,0x02ff
	ldir

	xor a
	out (254),a

	ld ix,sine
	call gen_sin

	ld hl,music
	call stc_init

	; interrupt table
	ld hl,inttable
	ld (hl),0xfd
	ld de,inttable+1
	ld bc,0x0100
	ldir
	ld a,0xc3 ; jp
	ld (0xfdfd),a
	ld hl,interrupt
	ld (0xfdfe),hl

	di
	ld a,high inttable
	ld i,a
	im 2
	ei

	ld b,60
	call pause

	ld bc,we_are_gathered
	ld d,0
	ld e,24
	call reveal
	ld b,200
	call pause
	ld bc,we_are_gathered
	ld d,24
	ld e,111
	call reveal

	ld b,240
	call pause
	ld b,120
	call pause

	ld bc,we_are_gathered
	ld d,0
	ld e,111
	call unreveal

	ld b,40
	call pause

	ld bc,crusty_cob
	ld d,0
	ld e,111
	call reveal

	ld b,240
	call pause

	ld bc,crusty_cob
	ld d,0
	ld e,111
	call unreveal

	ld bc,purveyors
	ld d,0
	ld e,28
	call reveal
	ld b,60
	call pause
	ld bc,purveyors
	ld d,28
	ld e,56
	call reveal
	ld b,60
	call pause
	ld bc,purveyors
	ld d,56
	ld e,85
	call reveal
	ld b,60
	call pause
	ld bc,purveyors
	ld d,85
	ld e,111
	call reveal

	ld b,240
	call pause

	ld bc,purveyors
	ld d,0
	ld e,111
	call unreveal

	ld bc,sugar_bomb
	ld d,0
	ld e,84
	call reveal
	ld b,200
	call pause
	ld bc,sugar_bomb
	ld d,84
	ld e,111
	call reveal

	ld b,200
	call pause

	ld bc,sugar_bomb
	ld d,0
	ld e,111
	call unreveal

	ld b,100
	call pause

	call halftone
	ld a,0xcd
	ld (firecall),a

	ld b,200
	call pause

	ld bc,ashes_to_ashes
	ld d,0
	ld e,24
	call reveal
	ld b,200
	call pause
	ld bc,ashes_to_ashes
	ld d,28
	ld e,55
	call reveal

	ld b,0
	call pause
	call pause
	call pause

	ld a,0x01
	ld (musiccall),a

fin
	halt
	jr fin


pause
	halt
	djnz pause
	ret

halftone
	ld hl,0x5980
	ld de,0x5981
	ld (hl),0x00
	ld bc,0x00df
	ldir

	ld l,0x60
halftone_lp
	ld h,high ypositions
	ld e,(hl)
	inc h
	ld d,(hl)
	ld b,32
	ld a,0x55
halftone_line_lp
	ld (de),a
	inc e
	djnz halftone_line_lp
	inc l
	inc l
	ld a,l
	cp 0x98
	jr c,halftone_lp
	ret

fire
	ld a,r
	ld h,0
	ld l,a
	ld de,0x5a60
	ld b,32
firebase_lp
	ld a,(hl)
	and 0x07
	ld (de),a
	inc hl
	inc e
	djnz firebase_lp

	ld b,7

	ld de,0x5980
	ld hl,0x59a0

fireiter_lp
	ld a,(hl)
	inc l
	add a,(hl)
	srl a
	srl a
	ld (de),a
	inc e
	dec l
	rept 30
	ld a,(hl)
	inc l
	add a,(hl)
	inc l
	add a,(hl)
	srl a
	srl a
	ld (de),a
	inc e
	dec l
	endm
	ld a,(hl)
	inc l
	add a,(hl)
	srl a
	srl a
	ld (de),a

	inc hl
	inc de

	dec b
	jp nz,fireiter_lp

	ret

unreveal
	ld ix,undither
	jr reveal_resume

; enter with bc = image address, d = from row, e = to row
reveal
	ld ix,dither
reveal_resume
	revealdelay
	push de
	ld a,d
	ld l,(ix+7)
	call textline
	pop de

	revealdelay
	push de
	ld a,d
	ld l,(ix+6)
	call textline
	inc a
	ld l,(ix+7)
	call textline
	pop de

	revealdelay
	push de
	ld a,d
	ld l,(ix+5)
	call textline
	inc a
	ld l,(ix+6)
	call textline
	inc a
	ld l,(ix+7)
	call textline
	pop de

	revealdelay
	push de
	ld a,d
	ld l,(ix+4)
	call textline
	inc a
	ld l,(ix+5)
	call textline
	inc a
	ld l,(ix+6)
	call textline
	inc a
	ld l,(ix+7)
	call textline
	pop de

	revealdelay
	push de
	ld a,d
	ld l,(ix+3)
	call textline
	inc a
	ld l,(ix+4)
	call textline
	inc a
	ld l,(ix+5)
	call textline
	inc a
	ld l,(ix+6)
	call textline
	inc a
	ld l,(ix+7)
	call textline
	pop de

	revealdelay
	push de
	ld a,d
	ld l,(ix+2)
	call textline
	inc a
	ld l,(ix+3)
	call textline
	inc a
	ld l,(ix+4)
	call textline
	inc a
	ld l,(ix+5)
	call textline
	inc a
	ld l,(ix+6)
	call textline
	inc a
	ld l,(ix+7)
	call textline
	pop de

	revealdelay
	push de
	ld a,d
	ld l,(ix+1)
	call textline
	inc a
	ld l,(ix+2)
	call textline
	inc a
	ld l,(ix+3)
	call textline
	inc a
	ld l,(ix+4)
	call textline
	inc a
	ld l,(ix+5)
	call textline
	inc a
	ld l,(ix+6)
	call textline
	inc a
	ld l,(ix+7)
	call textline
	pop de

reveal2_lp
	revealdelay
	push de
	ld a,d
	ld l,(ix+0)
	call textline
	inc a
	ld l,(ix+1)
	call textline
	inc a
	ld l,(ix+2)
	call textline
	inc a
	ld l,(ix+3)
	call textline
	inc a
	ld l,(ix+4)
	call textline
	inc a
	ld l,(ix+5)
	call textline
	inc a
	ld l,(ix+6)
	call textline
	inc a
	ld l,(ix+7)
	call textline
	pop de
	inc d
	cp e
	jr nz, reveal2_lp

	revealdelay
	push de
	ld a,d
	ld l,(ix+0)
	call textline
	inc a
	ld l,(ix+1)
	call textline
	inc a
	ld l,(ix+2)
	call textline
	inc a
	ld l,(ix+3)
	call textline
	inc a
	ld l,(ix+4)
	call textline
	inc a
	ld l,(ix+5)
	call textline
	inc a
	ld l,(ix+6)
	call textline
	pop de
	inc d

	revealdelay
	push de
	ld a,d
	ld l,(ix+0)
	call textline
	inc a
	ld l,(ix+1)
	call textline
	inc a
	ld l,(ix+2)
	call textline
	inc a
	ld l,(ix+3)
	call textline
	inc a
	ld l,(ix+4)
	call textline
	inc a
	ld l,(ix+5)
	call textline
	pop de
	inc d

	revealdelay
	push de
	ld a,d
	ld l,(ix+0)
	call textline
	inc a
	ld l,(ix+1)
	call textline
	inc a
	ld l,(ix+2)
	call textline
	inc a
	ld l,(ix+3)
	call textline
	inc a
	ld l,(ix+4)
	call textline
	pop de
	inc d

	revealdelay
	push de
	ld a,d
	ld l,(ix+0)
	call textline
	inc a
	ld l,(ix+1)
	call textline
	inc a
	ld l,(ix+2)
	call textline
	inc a
	ld l,(ix+3)
	call textline
	pop de
	inc d

	revealdelay
	push de
	ld a,d
	ld l,(ix+0)
	call textline
	inc a
	ld l,(ix+1)
	call textline
	inc a
	ld l,(ix+2)
	call textline
	pop de
	inc d

	revealdelay
	push de
	ld a,d
	ld l,(ix+0)
	call textline
	inc a
	ld l,(ix+1)
	call textline
	pop de
	inc d

	halt
	halt
	ld a,d
	ld l,(ix+0)
	call textline

	ret

; enter with a = row number, bc = image address, l = mask
; preserves a, bc
textline
	push af
	push bc

	push hl

	add a,40
	ld l,a
	ld h,high ypositions
	ld e,(hl)
	inc h
	ld d,(hl)

	sub 40
	ld h,0
	ld l,a
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,bc

	pop bc

	rept 32
	ld a,(hl)
	and c
	ld (de),a
	inc l
	inc e
	endm

	pop bc
	pop af

	ret

plotstuff
	ld ix,plotbuffer
	ld b,64
ysinepos	ld hl,sine
	inc l
	inc l
	ld (ysinepos+1),hl

xsinepos	ld de,sine+32
	inc e
;	inc e
;	inc e
	ld (xsinepos+1),de

plotlp
	push bc
	rlc b
	rlc b

	ld a,e
	add a,15
	ld e,a

	ld a,(de)
	sra a
	sra a
	add a,b
	ld c,a

	ld a,l
	add a,16
	ld l,a
	ld a,(hl)
	sra a
	sra a
	sra a
	add a,16
	ld b,a

	push hl
	push de

	ld l,(ix)
	ld h,(ix+1)
	ld a,(ix+2)
	xor (hl)
	ld (hl),a
	; 0x4000 -> 0x5080
	set 4,h
	set 7,l
	ld (hl),a

	; enter with b = y coord, c = x coord
plot	ld h,high ypositions
	ld l,b
	ld a,(hl)
	inc h
	ld d,(hl)
	inc h
	ld l,c
	or (hl)
	ld e,a
	inc h
	ld a,(hl)
	ex de,hl

	ld (ix),l
	ld (ix+1),h
	ld (ix+2),a
	inc ixl
	inc ixl
	inc ixl

	xor (hl)
	ld (hl),a
	; 0x4000 -> 0x5080
	set 4,h
	set 7,l
	ld (hl),a

	pop de
	pop hl
	pop bc
	djnz plotlp
	ret

interrupt
	push af
	push bc
	push de
	push hl
	push ix
;frame_count
;	ld hl,0
;	inc hl
;	ld (frame_count+1),hl

musiccall
	call stc_play
	call plotstuff
firecall
	ld bc,fire

	pop ix
	pop hl
	pop de
	pop bc
	pop af
	ei
	ret

; in:  IX = addr of 256b buffer
; out: generated sin table
gen_sin
	ld   de, #7fbc
	ld   hl, #ff7f
.g0	ld   a, d
	;xor  #80 ; uncomment for unsigned
	ld   (ix), a
	;xor  #80 ; uncomment for unsigned
	rla
	sbc  a, a
	ld   b, a
	ld   c, d
	adc  hl, bc
	rr   c
	rrca
	rr   c
	add  hl, bc
	ld   b, h
	ld   a, l
	ex   de, hl
	sra b
	rra
	sra b
	rra
	sra b
	rra
	ld   c, a
	;or   a
	sbc  hl, bc
	ex   de, hl
	inc  ixl
	jr   nz, .g0
	ret

	include "stc_player.asm"
music	incbin "sarabande.stc"

	align 0x100
ypositions
	rept 256, n
	db (n & 0x38)<<2
	endm
	rept 256, n
	db 0x40|(n & 0x07)|(n & 0xc0)>>3
	endm
xpositions
	rept 256, n
	db n>>3
	endm
	rept 32
	db 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01
	endm

dither	db 0xff, 0x55, 0xff, 0x55, 0xaa, 0x55, 0x00, 0x55
undither	db 0x00, 0xaa, 0x00, 0xaa, 0x55, 0xaa, 0xff, 0xaa

	align 0x100
purveyors
	incbin "purveyors.bin"
sugar_bomb
	incbin "sugar-bomb.bin"
ashes_to_ashes
	incbin "ashes-to-ashes.bin"

plotbuffer	equ 0xfb00

sine	equ 0xfc00
inttable	equ 0xfe00
