/*

 TITLE_BG_TILES_LOW.C

 Tile Source File.

 Info:
  Form                 : All tiles as one unit.
  Format               : Gameboy 4 color.
  Compression          : GB-Compress.
  Counter              : None.
  Tile size            : 8 x 8
  Tiles                : 0 to 255

  Palette colors       : Included.
  SGB Palette          : None.
  CGB Palette          : None.

  Convert to metatiles : No.

 This file was generated by GBTD v2.2

*/
#include <gb/gb.h>
#include <gb/gbdecompress.h>

#pragma bank 255
BANKREF(title_bg_tiles_low)

#include <gb/cgb.h>

// Palette
const palette_color_t* const title_bg_tiles_lowCGBPal[] = {
  4,
  18917,
  18218,
  32766,
  0,
  10398,
  29670,
  5054,
};

/* Start of tile array. */
const unsigned char title_bg_tiles_low[] =
{
  0x0F,0x00,0x42,0x01,0x00,0x89,0xEA,0xFF,
  0xCE,0x8C,0x00,0x86,0x00,0x84,0x00,0x86,
  0x00,0x87,0x00,0xC3,0x00,0x43,0x00,0x43,
  0x8E,0xD1,0xFF,0xC4,0x88,0x00,0x7F,0x00,
  0x3F,0x83,0xFC,0xFF,0xFF,0x00,0x3E,0x01,
  0x3B,0x04,0x1E,0x01,0x1F,0x00,0xC2,0x00,
  0xE2,0x00,0xC3,0x00,0xE1,0x00,0xE1,0x00,
  0xC0,0x00,0xC1,0x00,0xC0,0x00,0x87,0x00,
  0x83,0x00,0x43,0x00,0x41,0x00,0x83,0x00,
  0xC1,0x00,0x41,0x00,0xC0,0x00,0xD2,0x00,
  0x59,0x00,0xD5,0x00,0x55,0x00,0xB5,0x00,
  0xAA,0x00,0xED,0x00,0x75,0x00,0x00,0x00,
  0x55,0x00,0x00,0x00,0x6A,0xCF,0x00,0x08,
  0x00,0xE2,0x00,0x28,0x00,0xAA,0x00,0x00,
  0x00,0x50,0x00,0x00,0x00,0xA8,0x83,0xFC,
  0xFF,0x84,0xF8,0xFF,0xDE,0x02,0x00,0x09,
  0x00,0x05,0x00,0x02,0x00,0x05,0x00,0x01,
  0x00,0x02,0x00,0x03,0x00,0xFF,0x00,0x7F,
  0x00,0x7F,0x00,0xBF,0x00,0x7F,0x00,0x5F,
  0x00,0x6F,0x00,0x3F,0x84,0x41,0xFF,0xCA,
  0x40,0x00,0x40,0x00,0xA0,0x00,0xD0,0x00,
  0xE4,0x00,0xF0,0x86,0x31,0xFF,0xC8,0x04,
  0x00,0x01,0x00,0x08,0x00,0x4F,0x00,0x2B,
  0x86,0x21,0xFF,0xC0,0x40,0x84,0xF0,0xFF,
  0xCA,0x2A,0x00,0x04,0x00,0x08,0x00,0x04,
  0x00,0x00,0x00,0x0A,0x84,0xDC,0xFF,0xC0,
  0x80,0x88,0x03,0xFF,0xC2,0x20,0x00,0x02,
  0x86,0xB6,0xFF,0xC4,0x43,0x00,0x42,0x01,
  0x63,0x83,0xFC,0xFF,0xD5,0x00,0x43,0x00,
  0x62,0x01,0x47,0x00,0x90,0x00,0x84,0x00,
  0xD1,0x00,0x94,0x00,0x82,0x00,0x89,0x00,
  0x8A,0x00,0x85,0x88,0xB0,0xFF,0xC8,0x10,
  0x00,0x48,0x00,0x12,0x00,0x48,0x00,0x07,
  0x86,0xC6,0xFF,0x87,0xB8,0xFE,0xC0,0x81,
  0x8E,0xAF,0xFE,0xF8,0x41,0x00,0xE1,0x00,
  0x80,0x00,0x60,0x00,0x81,0x00,0x60,0x00,
  0x40,0x00,0x30,0x00,0xAA,0x00,0x7A,0x00,
  0xD5,0x00,0x7B,0x00,0xAA,0x00,0x7D,0x00,
  0xFA,0x00,0x3D,0x00,0xA8,0x00,0xAD,0x00,
  0x54,0x00,0x57,0x00,0xA8,0x00,0xAB,0x00,
  0xAA,0x00,0x55,0x00,0x08,0x00,0x44,0x00,
  0x20,0x00,0x08,0x00,0xA0,0x83,0xFC,0xFF,
  0x84,0x63,0xFE,0x85,0x66,0xFF,0xD0,0x04,
  0x00,0x03,0x00,0x00,0x00,0x05,0x00,0xFF,
  0x00,0x5F,0x00,0x6B,0x00,0x58,0x00,0x28,
  0x84,0x1A,0xFF,0xF0,0x62,0x00,0xF2,0x00,
  0xE1,0x00,0xEA,0x00,0xC9,0x00,0x49,0x00,
  0x0C,0x00,0x1C,0x00,0x8E,0x00,0xBE,0x00,
  0xA7,0x00,0xC0,0x00,0xF4,0x00,0xC4,0x00,
  0xE7,0x00,0x0A,0x00,0x0F,0x00,0x28,0x00,
  0x14,0x00,0x68,0x00,0x20,0x00,0x00,0x00,
  0x30,0x00,0x50,0x00,0x20,0x8A,0x0C,0xFF,
  0x85,0x06,0xFE,0xC0,0x08,0x86,0x9E,0xFF,
  0xC0,0x40,0x10,0x00,0xF4,0x83,0x00,0xE7,
  0x00,0x7E,0x00,0xC3,0x00,0xC7,0x00,0xC7,
  0x00,0xCF,0x00,0x8F,0x00,0x8F,0x00,0x0F,
  0x00,0x1F,0x00,0x95,0x00,0x0A,0x00,0x9A,
  0x00,0x15,0x00,0x3A,0x00,0x0E,0x00,0x75,
  0x00,0x3D,0x00,0x52,0x00,0xA8,0x00,0x8A,
  0x00,0x52,0x00,0xAB,0x00,0xAB,0x00,0x56,
  0x00,0x57,0x84,0x72,0xFE,0xCB,0xA0,0x00,
  0xA0,0x00,0x6B,0x01,0x63,0x0F,0xBF,0x1F,
  0xBF,0x7F,0x83,0xAE,0xFD,0xC3,0x07,0x0F,
  0x3F,0x7F,0x07,0xFF,0xC2,0x20,0x05,0x3F,
  0x0C,0xFF,0xC1,0x3F,0xC0,0x0D,0xFF,0xC8,
  0x52,0x00,0x50,0x80,0xC0,0xF0,0xF8,0xFC,
  0xFE,0x86,0xCF,0xFF,0x89,0x60,0xFD,0xC8,
  0xE0,0xC0,0xF0,0xF0,0xFC,0xFC,0x02,0x00,
  0x08,0x84,0xEC,0xFD,0xC0,0x02,0x84,0x5A,
  0xFD,0xDC,0x01,0x00,0x81,0x00,0xA8,0x00,
  0x52,0x00,0x48,0x00,0x2A,0x00,0x48,0x00,
  0x24,0x00,0x2A,0x00,0x1F,0x00,0xC7,0x00,
  0x8E,0x00,0x62,0x00,0x60,0x00,0x20,0x83,
  0xFC,0xFF,0xD5,0x00,0x0A,0x00,0x0E,0x00,
  0x22,0x00,0x30,0x00,0x69,0x00,0x79,0x00,
  0xEB,0x00,0x68,0x00,0x82,0x00,0x41,0x00,
  0x10,0x84,0x06,0xFE,0x83,0xEC,0xFE,0xC0,
  0x84,0x86,0x01,0xFD,0xC0,0x80,0x92,0x00,
  0xFF,0x83,0x86,0xFE,0xC2,0x03,0x00,0x14,
  0x8E,0xDF,0xFC,0xC2,0x1E,0x00,0x3F,0x83,
  0xFC,0xFF,0xD3,0x00,0x3C,0x00,0x3E,0x00,
  0x79,0x00,0x7E,0x00,0xEB,0x00,0x3E,0x00,
  0xEA,0x00,0x6A,0x00,0xF6,0x00,0xB5,0x84,
  0xFA,0xFF,0xCB,0xAA,0x01,0xDB,0x03,0xC7,
  0x0F,0xCF,0x1F,0xBF,0x3F,0x3F,0x7F,0x88,
  0x0B,0xFF,0x8A,0x0E,0xFF,0x87,0x28,0xFF,
  0x87,0xF0,0xFE,0xCC,0x00,0x00,0xC0,0x80,
  0xC0,0xC0,0xE0,0xF0,0xF0,0xF8,0xF8,0xFC,
  0xFC,0x02,0xFE,0xC4,0x42,0x00,0x2A,0x00,
  0x00,0x83,0xFC,0xFF,0x84,0x58,0xFD,0x83,
  0x70,0xFC,0x83,0xEE,0xFC,0xDA,0x0A,0x00,
  0x4A,0x00,0x0E,0x00,0x56,0x00,0x1E,0x00,
  0xF0,0x00,0x5A,0x00,0x60,0x00,0x12,0x00,
  0x0C,0x00,0x55,0x00,0x79,0x00,0x31,0x00,
  0x20,0x84,0x16,0xFD,0xC8,0x40,0x00,0x02,
  0x00,0xE0,0x00,0x00,0x00,0xC4,0x86,0x44,
  0xFC,0x83,0x10,0xFE,0xC0,0x09,0x84,0x2A,
  0xFF,0xC8,0x03,0x00,0x01,0x00,0x04,0x00,
  0x04,0x00,0x10,0x86,0x17,0xFC,0xDF,0x3A,
  0x00,0x7B,0x00,0x7A,0x00,0x7C,0x00,0x3A,
  0x00,0x7D,0x00,0x7E,0x00,0x7F,0x00,0xB9,
  0x01,0x4B,0x01,0xB3,0x03,0x93,0x07,0x27,
  0x07,0x07,0x0F,0x4F,0x0F,0x1F,0x0F,0x83,
  0xF3,0xFE,0x02,0x80,0x03,0xC0,0x04,0xE0,
  0xC2,0x14,0x00,0x16,0x88,0xC4,0xFF,0x83,
  0xD4,0xFB,0xC8,0x60,0x00,0x24,0x00,0x04,
  0x00,0x06,0x00,0x05,0x8A,0xBE,0xFD,0xC0,
  0x22,0x84,0xB6,0xFC,0x83,0xD6,0xFE,0xC0,
  0x0A,0x84,0xB0,0xFD,0xC0,0x44,0x84,0xB8,
  0xFB,0xC0,0x90,0x84,0xF6,0xFF,0xCC,0x80,
  0x00,0x02,0x00,0x11,0x00,0x04,0x00,0x11,
  0x00,0x84,0x00,0x05,0x84,0x78,0xFD,0xEC,
  0x0A,0x04,0x01,0x0E,0x10,0x0F,0x00,0x0F,
  0x0A,0x05,0x05,0x02,0x06,0x01,0x7E,0x00,
  0x5F,0x20,0x6F,0x10,0x6F,0x10,0x4F,0xB0,
  0x23,0xDC,0x17,0xE8,0x81,0x7E,0x9F,0x1F,
  0xDF,0x1F,0x5F,0x3F,0x8F,0x3F,0xFF,0x3F,
  0x8D,0x3F,0xB5,0x7F,0x8F,0x8C,0xD3,0xFD,
  0xC2,0xDF,0xFF,0xDF,0x88,0xBE,0xFE,0xC6,
  0xFD,0xFF,0xF7,0xFF,0xFF,0xFF,0xEB,0x8E,
  0x9E,0xFE,0xC0,0xFD,0x88,0x9A,0xFE,0xC7,
  0xFE,0xFF,0xFE,0xFF,0xFC,0xFF,0xFC,0xFF,
  0x8B,0x7C,0xFE,0xC0,0xFE,0x88,0xE0,0xFF,
  0x85,0x72,0xFD,0xC4,0xF7,0xFF,0xF7,0xFF,
  0xE0,0x02,0xF0,0x83,0x82,0xFE,0xC7,0x68,
  0xF8,0x68,0xF8,0x54,0xF8,0x58,0xFC,0x83,
  0xE0,0xFB,0xDA,0x11,0x00,0x0A,0x01,0x28,
  0x03,0x50,0x07,0xA1,0x0E,0x43,0x1C,0x00,
  0x00,0xB4,0x40,0x10,0xE0,0x10,0xE0,0x08,
  0xE0,0xA0,0x40,0x68,0x80,0x44,0x84,0xCD,
  0xFB,0xC2,0x04,0x00,0x82,0x84,0x8A,0xFB,
  0xC4,0x09,0x00,0x00,0x00,0x11,0x84,0xBF,
  0xFA,0xC0,0x4A,0x84,0xB9,0xFA,0xCA,0x12,
  0x00,0x00,0x00,0x0D,0x00,0x42,0x00,0x09,
  0x00,0x48,0x84,0x48,0xFB,0xC7,0x40,0x00,
  0x0A,0x00,0x01,0x02,0x00,0x01,0x8B,0xB0,
  0xFA,0xDF,0x8B,0x74,0x41,0x3E,0x22,0x9D,
  0x71,0x8E,0xEA,0x17,0x19,0x47,0x40,0x2B,
  0x0E,0x21,0xD9,0x7F,0x0D,0x7F,0x95,0x7F,
  0x15,0x5F,0x85,0x7F,0x01,0xAF,0x29,0xDF,
  0x82,0xEF,0x42,0xDF,0xFF,0xFA,0xDE,0xFF,
  0xBF,0xFF,0xBF,0xFF,0x5F,0xFE,0xBE,0xFF,
  0x6D,0xFF,0x77,0xFF,0xD7,0xFF,0xAB,0xFF,
  0x56,0xFF,0x57,0xFF,0x95,0xFF,0xAE,0xFF,
  0xFF,0xFF,0xFB,0xFF,0x7B,0xFF,0xFB,0xFF,
  0xF3,0xFF,0xF3,0xFF,0xE7,0xFF,0xE3,0xFE,
  0xFA,0xFF,0xFA,0xFF,0xF9,0xF7,0xED,0xFF,
  0xC5,0xFF,0xAF,0xFF,0x1B,0xFF,0xBF,0xFF,
  0xFD,0x86,0xE4,0xFF,0xD6,0xEE,0xFF,0xC6,
  0xFF,0xB5,0xFF,0xBD,0xFF,0x7F,0xFF,0x7F,
  0xFF,0x3F,0xFF,0x5F,0xFF,0x9F,0xFF,0xA7,
  0xFF,0x4E,0xFF,0x6F,0x83,0xCB,0xFE,0xD7,
  0xFF,0xFD,0xFF,0xBF,0xFF,0xDE,0xFF,0xDF,
  0xFF,0xEE,0xFF,0xAE,0xFF,0xF7,0xFF,0xF3,
  0xFF,0xF6,0xFF,0xF7,0xF7,0xFD,0xFF,0xF3,
  0x83,0xB6,0xFF,0xE5,0xFF,0x51,0xF4,0xB0,
  0xFC,0x51,0xFC,0x51,0xFC,0x00,0xF5,0x51,
  0xFF,0x02,0xE7,0xA0,0xFF,0x25,0x1A,0xC8,
  0x35,0x89,0x72,0x11,0xEA,0x16,0xE0,0x02,
  0xD4,0x60,0x88,0x05,0xA8,0xA8,0x00,0x80,
  0x00,0x54,0x84,0x5E,0xFA,0xC6,0x94,0x00,
  0x00,0x00,0x48,0x00,0x00,0x84,0x18,0xFE,
  0x8B,0xBA,0xF9,0xC0,0x24,0x86,0xA8,0xFB,
  0x83,0xAE,0xFA,0xC8,0x01,0x00,0xA0,0x00,
  0x02,0x00,0x50,0x00,0x02,0x84,0x50,0xFB,
  0xC0,0x14,0x84,0x84,0xFA,0x83,0xE4,0xFE,
  0xC0,0x20,0x84,0xE2,0xFE,0xC2,0x04,0x00,
  0x22,0x90,0x8E,0xFC,0x87,0x50,0xFA,0x85,
  0xA4,0xFF,0xEC,0x24,0x00,0x00,0x2A,0x03,
  0x28,0x13,0x04,0x08,0x12,0x00,0x0A,0x04,
  0x09,0x0C,0x02,0x06,0x08,0x45,0xF7,0xBA,
  0x73,0x62,0xBF,0xD2,0x3B,0x29,0x9F,0x23,
  0x5D,0x25,0x9F,0x31,0x8F,0x7F,0xFE,0xBE,
  0xFF,0x7C,0xFE,0xBE,0xFF,0x78,0xFD,0x7C,
  0x83,0xFC,0xFF,0xE7,0xFE,0x90,0xFF,0x94,
  0xFF,0x92,0xF9,0x84,0xFB,0x00,0xEF,0x94,
  0xAB,0x4A,0xB5,0x30,0xCF,0xD8,0xDF,0xB0,
  0xCF,0xDC,0xA3,0x10,0xFF,0x49,0xFF,0x02,
  0xFF,0x02,0xFF,0x51,0xFF,0x7D,0xFF,0x3E,
  0xFF,0xBF,0xFF,0x3F,0x86,0xE8,0xFD,0xFF,
  0x5F,0xFF,0x7B,0xFF,0xFD,0xFF,0xF9,0xFF,
  0xF8,0xFF,0xF1,0xFE,0xFC,0xFF,0xFB,0xFF,
  0x5A,0xFF,0x53,0xFF,0x45,0xFB,0x1C,0xE3,
  0x41,0xBF,0x88,0x7F,0x40,0xFF,0x00,0xFF,
  0x88,0xFF,0xD6,0x7F,0x96,0x7F,0x4F,0x3F,
  0x02,0xEF,0x03,0xFB,0xA1,0x5B,0x28,0xD7,
  0x00,0xF5,0xFA,0xFF,0x7A,0xFB,0x7C,0xFF,
  0x7A,0xFF,0x78,0x7F,0x3A,0xFF,0x7D,0x7F,
  0xE1,0x7D,0x3F,0x05,0xDE,0x89,0xFE,0x92,
  0xBC,0x80,0xFD,0x98,0xF2,0x86,0xF8,0x30,
  0xE5,0x00,0xF5,0x12,0x48,0x19,0x40,0x14,
  0xA0,0x40,0x10,0x10,0xA0,0x08,0xA0,0x20,
  0x40,0x40,0x20,0x85,0x9C,0xFB,0xC0,0x10,
  0x8A,0xDA,0xF9,0xC4,0xD0,0x00,0x2A,0x00,
  0x4A,0x84,0x14,0xFA,0xC0,0x12,0x84,0xCE,
  0xFD,0xD2,0x91,0x00,0x04,0x00,0xA2,0x00,
  0xAD,0x00,0x56,0x00,0xAA,0x00,0xBA,0x00,
  0x08,0x00,0x24,0x00,0xA8,0x84,0xBE,0xFA,
  0x86,0x62,0xF9,0xFF,0x05,0x04,0x02,0x03,
  0x04,0x02,0x05,0x04,0x02,0x02,0x05,0x25,
  0x02,0x10,0x05,0x20,0x5F,0x24,0x8F,0x88,
  0x57,0x33,0x4E,0x60,0x9F,0x30,0x4F,0x52,
  0xAF,0xE0,0x1F,0xF0,0xFA,0x7C,0xFD,0xF0,
  0xFA,0x79,0xFC,0xF1,0xF0,0x78,0xF8,0x74,
  0xF0,0x31,0xFE,0x00,0xBF,0x10,0x40,0x95,
  0x03,0x56,0x0F,0x5F,0x3F,0x1F,0x7F,0x78,
  0x7F,0x5C,0x3F,0x0A,0xFF,0xFF,0x08,0x07,
  0xE8,0xF3,0xBA,0xFD,0x3C,0xFF,0x5F,0xBE,
  0xEF,0x3F,0xAD,0x7F,0xF5,0xFF,0x3D,0xFF,
  0xAB,0xFF,0x5B,0xFF,0x16,0xFF,0x2B,0xFF,
  0xB7,0x7F,0x3B,0xFF,0xFD,0xFF,0x54,0xFF,
  0x74,0xFF,0x54,0xFF,0xE8,0xFF,0xA0,0xFE,
  0xD9,0xFF,0xDE,0xFD,0x40,0xFF,0x20,0xC0,
  0x0F,0xBF,0x39,0x7F,0x7B,0xFF,0xF7,0xF9,
  0xF6,0xF9,0xE0,0xFF,0x10,0xFE,0xEB,0x00,
  0x0A,0x24,0x81,0xF4,0xE0,0xF2,0xF8,0xBC,
  0xFC,0x70,0xFC,0x78,0xFC,0x5D,0x7F,0x1C,
  0x7F,0x3C,0x7F,0x3E,0x1F,0x1B,0x3E,0x3E,
  0x1F,0x98,0x7F,0x1E,0x9F,0x51,0xE4,0x00,
  0xEA,0x60,0xD5,0x60,0xD5,0x14,0xEA,0xA2,
  0xD5,0x0C,0xF2,0x95,0xEA,0x40,0x80,0xA0,
  0x40,0x80,0x40,0x00,0x40,0x40,0x80,0x80,
  0x40,0x40,0x80,0x40,0x80,0x85,0x38,0xFB,
  0x83,0x72,0xF8,0x83,0x6C,0xF8,0x83,0xD0,
  0xFD,0xC0,0xA4,0x84,0xD6,0xFC,0x83,0xC2,
  0xFC,0xC0,0x20,0x84,0x74,0xF8,0xC0,0x80,
  0x84,0x62,0xF9,0x83,0x7C,0xF8,0xC2,0x08,
  0x00,0x82,0x84,0x62,0xF8,0x89,0xA4,0xFB,
  0xC8,0x00,0x00,0xAA,0x00,0xA8,0x00,0x30,
  0x00,0x90,0x86,0xDC,0xFF,0x87,0x5C,0xF7,
  0xC0,0x00,0x84,0xF2,0xF8,0x83,0x24,0xFB,
  0xFF,0xAD,0x02,0xA9,0x02,0x5A,0x05,0x52,
  0x05,0xB8,0x07,0xBA,0x07,0x79,0x07,0xB8,
  0x07,0x52,0xAF,0x44,0xBF,0x84,0x7F,0x14,
  0xFF,0x3C,0xFF,0x94,0xFF,0x50,0xFF,0x00,
  0xFF,0x70,0xF7,0x30,0x7B,0x70,0xF7,0x30,
  0x77,0x30,0xF7,0x30,0xB7,0x38,0xF7,0x50,
  0xB7,0xA1,0x1E,0x04,0xCB,0xF3,0xC4,0x6C,
  0xF3,0xF1,0xFE,0xB0,0xFF,0xFC,0xFB,0x5A,
  0xFD,0xFF,0x61,0x98,0x24,0xDB,0xA9,0x56,
  0x00,0xFF,0x20,0xDF,0x04,0xFB,0x01,0xFE,
  0x00,0xFF,0x05,0xFF,0x08,0xF7,0x06,0xF9,
  0x24,0xDB,0x0B,0xF7,0x4A,0xB7,0x13,0xEF,
  0x07,0xFF,0x40,0xFE,0x80,0x7F,0xA0,0x5F,
  0x68,0x97,0x80,0xFF,0xEA,0xD5,0xD0,0xEF,
  0xF4,0xEB,0x41,0x3A,0x02,0xDD,0x8A,0x75,
  0x42,0xBD,0x00,0xFF,0x00,0xFF,0x80,0x7F,
  0x12,0xED,0xFF,0x0B,0xF1,0x04,0xE3,0xD4,
  0x0F,0x26,0xDF,0x1C,0xFF,0x5E,0xBF,0x1A,
  0xFF,0x3C,0xFF,0x18,0xFD,0x5C,0x9F,0x18,
  0xDD,0x1C,0xDF,0x18,0xDB,0x18,0xDF,0x11,
  0xDF,0x30,0xDF,0x8E,0xF1,0x85,0xFA,0x42,
  0xFD,0x50,0xFF,0x68,0xFF,0x34,0xFF,0x4A,
  0xFF,0x90,0x6F,0xC0,0x00,0x28,0xC0,0xAA,
  0x00,0x34,0xC0,0x15,0xC0,0x12,0xC0,0xB5,
  0xC0,0x15,0xC0,0x87,0x80,0xF7,0x83,0x0A,
  0xF7,0xC0,0xA0,0x84,0x38,0xFA,0xC0,0x10,
  0x84,0xC0,0xFA,0xD0,0x24,0x00,0x01,0x00,
  0x10,0x00,0x0A,0x00,0x40,0x00,0x12,0x00,
  0x80,0x00,0x49,0x00,0x00,0x84,0x0E,0xF8,
  0xCE,0x84,0x00,0x09,0x00,0x4A,0x00,0x0A,
  0x00,0x25,0x00,0x15,0x00,0x82,0x00,0x12,
  0x84,0x42,0xF8,0x8D,0x42,0xF6,0x8F,0xB2,
  0xFC,0x83,0x28,0xF7,0xC0,0x22,0x84,0x2E,
  0xF6,0x83,0x78,0xFA,0xFF,0x00,0x00,0xFC,
  0x03,0x5F,0x00,0xBA,0x00,0x5E,0x00,0xBF,
  0x00,0x2D,0x00,0x5F,0x00,0x2B,0x00,0xBD,
  0x40,0xB5,0x4A,0x40,0xAA,0x2A,0x55,0x90,
  0x2A,0xCA,0x15,0x6A,0x15,0xAA,0x05,0x14,
  0xFB,0x50,0x1F,0x40,0xBB,0xD8,0x0F,0x50,
  0xAB,0x04,0x5B,0x80,0x5B,0xA2,0x4D,0xFC,
  0xFF,0xB4,0xFF,0x7C,0xFF,0xBF,0xFF,0x6D,
  0xFF,0x3E,0xFF,0x6F,0xFF,0xFF,0x3A,0xFF,
  0x89,0x76,0x40,0xBF,0x08,0xF7,0x0A,0xF5,
  0xDB,0xFF,0xDF,0xFF,0xF7,0xFF,0xBF,0xFF,
  0x57,0xAF,0x4F,0xBF,0x9F,0x7F,0x2F,0xFF,
  0x7F,0xFF,0x37,0xFF,0x09,0xFF,0x92,0xEF,
  0xC1,0xFE,0xE4,0xFB,0xF2,0xFD,0xFC,0xFF,
  0xEA,0xFF,0xF9,0xFF,0x03,0xFF,0x81,0xFF,
  0x40,0xBF,0x00,0xFF,0x52,0xAD,0x11,0xEF,
  0xBF,0xFF,0xEB,0xFF,0xFD,0xFF,0xFF,0xED,
  0xFF,0xBD,0x7F,0x5C,0xFF,0x7A,0xFF,0xFC,
  0xFF,0x78,0xFF,0xDC,0xFF,0x74,0xFF,0xB0,
  0xFF,0x55,0xBA,0x78,0x95,0x00,0xF5,0x20,
  0xB5,0x31,0xAA,0x07,0xA8,0x9A,0x65,0x42,
  0x35,0xEA,0x15,0x3B,0x44,0x8A,0x54,0x07,
  0x68,0x0B,0xB0,0x6F,0x90,0xA6,0x50,0xB7,
  0x40,0x55,0x80,0xB7,0x00,0xFA,0x00,0xAF,
  0x00,0xFA,0x00,0xEF,0x00,0xFD,0x00,0xC2,
  0xDF,0x00,0x40,0x84,0xD0,0xFD,0xC8,0x50,
  0x00,0xA0,0x00,0xF0,0x00,0xB0,0x00,0x58,
  0x8A,0xCC,0xFB,0x87,0x36,0xF6,0x85,0x86,
  0xF9,0x87,0x28,0xF5,0x83,0x58,0xF9,0xC0,
  0x29,0x86,0x0E,0xF6,0x85,0x28,0xF5,0x83,
  0xC6,0xF7,0xC6,0x40,0x00,0xA2,0x00,0x42,
  0x00,0xA6,0x84,0x0A,0xF7,0x85,0x98,0xF8,
  0x87,0x98,0xF6,0x85,0xD0,0xFE,0x85,0x8A,
  0xF6,0x83,0xD8,0xFF,0xFF,0xAF,0x00,0x2F,
  0x00,0xBB,0x00,0x0E,0x00,0xBF,0x00,0x8D,
  0x00,0x3F,0x00,0x16,0x00,0xE5,0x0A,0x66,
  0x01,0xD4,0x02,0xF2,0x01,0xA0,0x01,0xF1,
  0x00,0xF1,0x00,0xB1,0x00,0x56,0xA9,0x82,
  0x5D,0x42,0xBD,0xA1,0x5E,0x00,0xFE,0x81,
  0x76,0xB0,0x4A,0x60,0x80,0x2F,0xFF,0x2A,
  0xFF,0x1B,0xFF,0x0D,0xFF,0x2A,0xFF,0x0A,
  0xFF,0x15,0xFF,0x8A,0x7F,0xFF,0xEB,0xFF,
  0xBA,0xFF,0x4F,0xFF,0x61,0xFF,0x82,0xFF,
  0x1C,0xE3,0x32,0xC1,0x00,0xF8,0xA0,0xFF,
  0xC0,0xFF,0xA0,0xFF,0xF8,0xFF,0x28,0xFF,
  0x1A,0xFF,0x00,0xFF,0x60,0x1F,0x07,0xFF,
  0x13,0xFF,0x0E,0xFF,0x37,0xFF,0x5C,0xFF,
  0x2A,0xFD,0x82,0xFC,0x00,0xFC,0xAA,0xFF,
  0xD5,0xFF,0x02,0xFF,0x40,0xBF,0xB1,0x0F,
  0x10,0x0F,0x41,0x3F,0x45,0x3F,0xFF,0xD4,
  0xFF,0x50,0xFF,0xD0,0xFF,0xA0,0xFE,0x49,
  0xFE,0x40,0xFE,0x40,0xFC,0x42,0xFC,0x85,
  0x6A,0x11,0x6A,0x0A,0xF5,0x84,0x7B,0x00,
  0xFF,0x23,0xDC,0x3D,0x80,0x05,0x00,0x4D,
  0xA0,0x7B,0x80,0x7D,0x00,0xFD,0x00,0x7E,
  0x00,0xFF,0x00,0xF8,0x00,0xFE,0x00,0x7E,
  0x00,0x56,0x00,0x7D,0x00,0x0F,0x00,0x6F,
  0x00,0x5F,0x00,0x5E,0x00,0xAF,0x00,0xCE,
  0xAC,0x00,0xEA,0x00,0x5D,0x00,0x76,0x00,
  0xAD,0x00,0xFD,0x00,0xAE,0x00,0xEB,0x88,
  0x10,0xF7,0xC0,0xE8,0x84,0xBA,0xF4,0x8A,
  0xA1,0xF6,0xD5,0x00,0xA4,0x00,0xF8,0x00,
  0xDE,0x00,0x86,0x00,0x44,0x00,0xA2,0x00,
  0x64,0x00,0xE6,0x00,0x72,0x00,0xC6,0x00,
  0xF2,0x84,0xF4,0xF3,0x85,0x1C,0xF9,0x85,
  0x12,0xFA,0xD6,0x5F,0x00,0x05,0x00,0x5F,
  0x00,0x07,0x00,0xAF,0x00,0x27,0x00,0x1D,
  0x02,0x87,0x00,0xF9,0x00,0xB1,0x00,0xF8,
  0x00,0xF9,0x43,0x00,0xFC,0xFF,0x00,0x90,
  0x64,0xC0,0x35,0x90,0x62,0xC8,0x32,0x98,
  0x60,0xC0,0x38,0xDC,0x20,0xC0,0x38,0x85,
  0x7F,0x45,0x3F,0x02,0xBF,0x22,0x9F,0x00,
  0xDF,0x10,0x4F,0x00,0x0F,0x00,0x07,0x44,
  0xF8,0x00,0xFE,0xC1,0xFE,0x60,0xFF,0xA8,
  0xFF,0x50,0xFF,0x28,0xFF,0x14,0xFF,0x10,
  0x2B,0x00,0x1F,0x02,0x0F,0x80,0x00,0x00,
  0x80,0x02,0xC0,0x00,0xFF,0x1A,0xF6,0xFF,
  0x80,0x50,0x01,0xF0,0x64,0xC3,0x00,0x0B,
  0x04,0x1F,0xA8,0x1F,0x30,0xFF,0xA0,0xFF,
  0x02,0xFF,0x8A,0x7F,0x05,0xFF,0x15,0xFF,
  0x2A,0xFF,0x2A,0xFF,0x28,0xFF,0xA8,0xFF,
  0x80,0xFC,0x80,0xFA,0x01,0xF9,0x00,0xF9,
  0x00,0xF6,0x00,0xF0,0x21,0xC8,0x24,0xC0,
  0x0E,0xA0,0x1F,0x80,0x1F,0x40,0x83,0x7C,
  0xF3,0xC6,0x3E,0x00,0x7D,0x00,0x01,0x00,
  0xAE,0x84,0x2A,0xFF,0x83,0xF2,0xFE,0xE4,
  0xFD,0x00,0x6B,0x00,0x57,0x00,0xBE,0x00,
  0x97,0x00,0xDD,0x00,0xAF,0x00,0x7A,0x00,
  0xFF,0x00,0xED,0x00,0xF6,0x00,0xFA,0x00,
  0xAA,0x00,0xB5,0x00,0xAD,0x00,0xD7,0x00,
  0x7A,0x00,0xAF,0x00,0xBF,0x84,0xFC,0xFE,
  0xC0,0x7F,0x44,0x00,0xFF,0xC5,0x00,0xF5,
  0x00,0xFD,0x00,0xFD,0x88,0xF0,0xFF,0xC0,
  0xFD,0x88,0xE0,0xF5,0xD2,0xC0,0x00,0xF0,
  0x00,0xFC,0x00,0xFF,0x00,0xA6,0x00,0x66,
  0x00,0xA2,0x00,0x24,0x00,0x06,0x00,0x02,
  0x83,0xFC,0xFF,0x86,0x5A,0xF6,0x87,0xBC,
  0xFD,0xD0,0x00,0x00,0x2F,0x00,0x0D,0x02,
  0x2F,0x00,0x02,0x05,0x2E,0x01,0x0F,0x00,
  0x54,0x03,0x17,0x43,0x00,0xFE,0xDB,0x00,
  0xEE,0x10,0x6E,0x90,0xB8,0x40,0x38,0xC0,
  0x5C,0x20,0x44,0x38,0x36,0x08,0x3E,0x00,
  0x36,0x08,0x33,0x0C,0x1B,0x04,0x1D,0x02,
  0x00,0x07,0x02,0x84,0x8F,0xF2,0xD7,0x02,
  0x00,0x02,0x01,0x81,0x02,0x83,0x00,0x15,
  0xFF,0x14,0xFF,0x05,0xFF,0x82,0x7F,0x82,
  0x7F,0x20,0x1F,0xE1,0x1F,0x40,0x8F,0x83,
  0x98,0xFB,0xFF,0x40,0xFF,0x83,0xFF,0xAF,
  0xFF,0xA6,0xFF,0x55,0xFF,0x54,0xFF,0x00,
  0xFF,0x01,0xFF,0x12,0xEF,0xAA,0xFF,0xCB,
  0xFF,0xD5,0xFF,0xAA,0xFF,0x54,0xFF,0x50,
  0xFF,0x50,0xFF,0xA1,0xFE,0x81,0xFE,0x04,
  0xF8,0x15,0xE8,0x01,0xF2,0x36,0xC1,0x4E,
  0x80,0x1F,0x80,0x3C,0x00,0x2F,0x00,0x3C,
  0x80,0xAE,0x00,0xB7,0x00,0x9F,0x00,0x2B,
  0x00,0x03,0x00,0xD0,0x97,0x00,0x07,0x00,
  0x4F,0x00,0x8F,0x00,0x2F,0x00,0x8F,0x00,
  0x57,0x00,0xDF,0x00,0xF7,0x84,0x10,0xFF,
  0xDE,0xEF,0x00,0xDF,0x00,0xDF,0x00,0xFB,
  0x00,0xFD,0x00,0xEA,0x00,0xEF,0x00,0xBB,
  0x00,0xFE,0x00,0x7B,0x00,0x7E,0x00,0x6F,
  0x00,0xBF,0x00,0xEF,0x00,0x7F,0x00,0xDF,
  0x84,0xDE,0xFF,0x83,0xE8,0xFE,0xC5,0xF7,
  0x08,0xDF,0x20,0xFB,0x04,0x83,0xDE,0xFE,
  0xC1,0xBB,0x44,0x87,0xEA,0xFE,0x89,0xD0,
  0xFE,0x83,0xE6,0xFF,0x85,0xE2,0xFF,0xC1,
  0xF7,0x08,0x83,0xBA,0xFE,0xC0,0x03,0x84,
  0x5A,0xF2,0x85,0xFA,0xFF,0x83,0xF8,0xFF,
  0xC2,0x0B,0x00,0x05,0x8C,0x5A,0xFB,0xC1,
  0xE0,0x00,0x86,0x0D,0xFB,0x86,0x87,0xF1,
  0xC6,0x0B,0x04,0x0C,0x03,0x06,0x01,0x07,
  0x84,0xCC,0xFF,0x83,0x88,0xF1,0xEF,0xC2,
  0x01,0xE0,0x01,0xF2,0x01,0x7A,0x81,0x5A,
  0xA1,0x72,0x89,0xDE,0x21,0xFE,0x01,0xCC,
  0x23,0x18,0xA3,0x13,0xC8,0x0B,0xE4,0x3F,
  0xC0,0x05,0xEA,0x20,0xD5,0x0A,0xF5,0x15,
  0xFF,0x05,0xFF,0x00,0xFF,0x81,0x7F,0x40,
  0x3F,0x1A,0x85,0x28,0x40,0xD1,0x2A,0x83,
  0x00,0xFF,0xE2,0x01,0xFE,0x03,0xFC,0x0B,
  0xF0,0x31,0xC4,0x02,0x15,0xFF,0x00,0x4A,
  0x95,0x94,0x43,0x68,0x17,0xF0,0x07,0x70,
  0x8F,0xC8,0x27,0x80,0x5F,0xB0,0x4F,0xEF,
  0x00,0x2F,0x00,0xFE,0x00,0x1E,0x84,0x16,
  0xFE,0xCC,0xFE,0x00,0xFF,0x00,0x2F,0x00,
  0x85,0x00,0x80,0x00,0x90,0x00,0x05,0x84,
  0xE4,0xF4,0xDA,0x41,0x00,0x1F,0x00,0x1F,
  0x00,0x5D,0x00,0x06,0x00,0xAA,0x00,0xCA,
  0x00,0x47,0x00,0x62,0x00,0xF7,0x00,0x35,
  0x00,0x5F,0x00,0xAB,0x00,0xBF,0x84,0xFE,
  0xFE,0xC0,0xFF,0x84,0xDC,0xFC,0x45,0xFF,
  0x00,0xC1,0xEF,0x10,0x49,0xFF,0x00,0xC8,
  0xEF,0x00,0xFB,0x00,0xAF,0x00,0xEB,0x00,
  0x5B,0x84,0xFA,0xFE,0xC1,0xEF,0x10,0x89,
  0xDA,0xFF,0x85,0x28,0xFF,0x83,0x7A,0xF4,
  0x85,0xA6,0xF0,0x43,0x80,0x00,0x43,0xC0,
  0x00,0xC7,0x7D,0x02,0x34,0x03,0x0A,0x05,
  0x0C,0x03,0x83,0xEC,0xF4,0xCD,0x01,0x1E,
  0x00,0x1F,0x17,0xE8,0x10,0xEE,0x05,0xFA,
  0x01,0xFE,0x44,0xFB,0x85,0x6B,0xFD,0xFF,
  0x77,0x88,0x5D,0xA2,0x06,0xA9,0x68,0x95,
  0x45,0xAA,0x96,0x69,0x2A,0xD5,0x01,0xFE,
  0x15,0xAA,0xBF,0x40,0x2A,0x55,0xE3,0x14,
  0xB4,0x4B,0xD4,0x2B,0xA0,0x5F,0x14,0xEB,
  0x50,0xAF,0x80,0x7F,0x50,0xAF,0x01,0xFE,
  0x84,0x7F,0x01,0xFE,0x08,0xFF,0x01,0xFE,
  0xDC,0x00,0x9F,0x40,0x9A,0x40,0x25,0xC0,
  0x0A,0xE0,0x12,0xE0,0x04,0xF0,0x0A,0xF0,
  0x83,0xBA,0xF9,0x85,0x88,0xF8,0x85,0x08,
  0xF3,0xCF,0x4B,0x00,0x03,0x00,0x2B,0x00,
  0x0B,0x00,0x03,0x00,0x29,0x00,0x07,0x00,
  0x85,0x00,0x00
};

void set_title_bg_tiles_low_palette(void) BANKED {
  set_bkg_palette(0, 2, title_bg_tiles_lowCGBPal);
}

void set_title_bg_tiles_low(void) BANKED {
  VBK_REG = VBK_BANK_0;
  gb_decompress_bkg_data(0, title_bg_tiles_low);
}

palette_color_t* get_title_bg_tiles_low_palette(uint8_t idx) BANKED {
  return (palette_color_t*)title_bg_tiles_lowCGBPal[idx];
}

/* End of TITLE_BG_TILES_LOW.C */
