#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"

struct DustParticle
{
  float3 pos;
  float size;
};

StructuredBuffer<DustParticle> particles : register(t0);

static const float3 offsets[] =
{
  float3(-1,-1,0),
  float3(-1,1,0),
  float3(1,-1,0),
  float3(1,-1,0),
  float3(-1,1,0),
  float3(1,1,0)
};

VertexPNTOut main(uint id : SV_VertexID)
{
	VertexPNTOut vout;
  uint particle_idx = id/6;
  uint quad_idx = id%6;
  float aspect = g_screen_size.x/g_screen_size.y;

  float3 p = particles[particle_idx].pos;
	float3 s = float3(40,40,40);
  p -= g_cam_pos;
  p -= s*round(p/s);

  float3 view_pos = mul(float4(p,0.0f),g_view).xyz;
  float4 clip_pos = mul(float4(view_pos, 1.0f), g_proj);

  float size = sin(particles[particle_idx].size + g_time*g_dust_flicker) * 0.5 + 0.5;

  vout.pos_h = clip_pos + float4(offsets[quad_idx]*0.0018f*float3(1.0,aspect,1.0)*view_pos.z*size*g_dust_size,0.0);
  vout.pos_v = view_pos;
  vout.normal = float3(0,0,-1);
  vout.uv = offsets[quad_idx].xy*0.5 + 0.5;
  return vout;
}
