#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\pbd\\pbd_common.h"

cbuffer PerMesh : register( b0 )
{
  float4x4 world;
  int particle_offset;
  int constraint_offset;
  uint max_edges;
  uint max_particles;
}

StructuredBuffer<float3> mesh : register( t0 );
StructuredBuffer<Edge> edges : register( t1 );
RWStructuredBuffer<Particle> particles : register(u0);
RWStructuredBuffer<DistConstraint> constraints : register(u1);
RWStructuredBuffer<uint> constraints_inds : register(u2);

[numthreads(8,1,1)]
void main(uint3 dispatch_thread_id  : SV_DispatchThreadID)
{
  if (dispatch_thread_id.x >= max_edges)
    return;
  
  uint index = dispatch_thread_id.x;
  uint a = edges[index].idx0;
  uint b = edges[index].idx1;
  
  constraints[constraint_offset + index].p0 = particle_offset + a;
  constraints[constraint_offset + index].p1 = particle_offset + b;
  constraints[constraint_offset + index].l0 = length(mul(float4(mesh[a],1.0f),world).xyz - mul(float4(mesh[b],1.0f),world).xyz);

  uint p0_c_index;
  InterlockedAdd( particles[particle_offset + a].num_constraints, 1, p0_c_index);
  
  uint p1_c_index;
  InterlockedAdd( particles[particle_offset + b].num_constraints, 1, p1_c_index);

  constraints_inds[(particle_offset + a) * 10 + p0_c_index] = constraint_offset + index;
  constraints_inds[(particle_offset + b) * 10 + p1_c_index] = constraint_offset + index;

}