#include "data\\shaders\\input_formats.h"

cbuffer cbPerFrame : register(b0)
{
  float2 g_dir;
  float2 _pad;
};

Texture2D g_input : register(t0);
SamplerState g_sam_linear : register(s3);

float4 main(VertexTOut pin) : SV_Target
{
  int s_length = 5; float coeffs[] = { 0.235833, 0.198063, 0.117294, 0.048968, 0.014408, };
  
  float4 color = coeffs[0] * g_input.Sample(g_sam_linear, pin.uv);
  for (int i = 1; i < s_length; ++i)
  {
    color += coeffs[i] * g_input.Sample(g_sam_linear, pin.uv + g_dir*float(i));
    color += coeffs[i] * g_input.Sample(g_sam_linear, pin.uv - g_dir*float(i));
  }
  
  return color;
}