#include "data\\shaders\\common.h"

Texture2D g_normal : register(t0);

RWTexture2D<float2> g_coc : register(u0);

SamplerState g_sam_point : register(s1);

[numthreads(8, 8, 1)]
void main(uint3 globalID : SV_DispatchThreadID, uint3 localID : SV_GroupThreadID, uint localIndex : SV_GroupIndex, uint3 groupID : SV_GroupID)
{
  float2 dim;
  g_normal.GetDimensions(dim.x,dim.y);
  if(globalID.x >= dim.x || globalID.y >= dim.y)
    return;
  
  float2 uv = (globalID.xy + 0.5f) / dim;  
  const float4 normal = g_normal.SampleLevel(g_sam_point, uv, 0);
  const float depth = normal.w;
  
  float n = g_dof_focal_dist - g_dof_sharp_range;
  float near_coc = saturate((n - depth) / g_dof_focus_range);
  
  float f = g_dof_focal_dist + g_dof_sharp_range;
  float far_coc = saturate((depth - f) / g_dof_focus_range);
  
  if (length(normal.xyz) < 0.001f)
  {
    near_coc = 0.0f;
    far_coc = 1.0f;
  }
  
  g_coc[globalID.xy].xy = float2(near_coc,far_coc);
}