#include "data\\shaders\\common.h"
#include "data\\shaders\\pbd\\pbd_common.h"
#include "data\\shaders\\input_formats.h"

cbuffer PerFrame : register(b0)
{
  float4x4 g_light_view_proj;
}

cbuffer Constant : register(b0, space4)
{
  uint start_idx;
};

StructuredBuffer<Particle> particles : register(t0, space0);
StructuredBuffer<uint16_t> particle_indices : register(t1, space0);

float4 main(uint id : SV_VertexID) : SV_POSITION
{
  Particle particle = particles[start_idx+particle_indices[id]];
  float3 world_pos = float3(particle.p_x,particle.p_y,particle.p_z);
  float4 clip_pos = mul(float4(world_pos, 1.0f), g_light_view_proj);

  //if (particle.flags > 0)
  //  return float4(0,0,0,0)/0.0f;

  return clip_pos;
}
