/* loadingScreen.js
 * Affiche simplement un écran noir pendant le pré‑chargement.
 * Aucune barre, aucun texte.
 *
 * À brancher dans Settings ▸ Loading Screen.
 */
pc.script.createLoadingScreen(function (app) {

    // --- SHOW ---------------------------------------------------
    var overlay = document.createElement('div');
    overlay.style.position        = 'absolute';
    overlay.style.top             = '0';
    overlay.style.left            = '0';
    overlay.style.width           = '100%';
    overlay.style.height          = '100%';
    overlay.style.backgroundColor = '#000';    // noir plein
    overlay.style.zIndex          = '9999';
    document.body.appendChild(overlay);

    // --- HIDE ---------------------------------------------------
    app.on('preload:end', function () {
        if (overlay && overlay.parentNode) {
            overlay.parentNode.removeChild(overlay);
            overlay = null;
        }
    });
});
