uniform float time;
float colormap_red(float x) {
    if (x < 0.0) {
        return 54.0 / 255.0;
    } else if (x < 20049.0 / 82979.0) {
        return (829.79 * x + 54.51) / 255.0;
    } else {
        return 1.0;
    }
}

float colormap_green(float x) {
    if (x < 20049.0 / 82979.0) {
        return 0.0;
    } else if (x < 327013.0 / 810990.0) {
        return (8546482679670.0 / 10875673217.0 * x - 2064961390770.0 / 10875673217.0) / 255.0;
    } else if (x <= 1.0) {
        return (103806720.0 / 483977.0 * x + 19607415.0 / 483977.0) / 255.0;
    } else {
        return 1.0;
    }
}

float colormap_blue(float x) {
    if (x < 0.0) {
        return 54.0 / 255.0;
    } else if (x < 7249.0 / 82979.0) {
        return (829.79 * x + 54.51) / 255.0;
    } else if (x < 20049.0 / 82979.0) {
        return 127.0 / 255.0;
    } else if (x < 327013.0 / 810990.0) {
        return (792.02249341361393720147485376583 * x - 64.364790735602331034989206222672) / 255.0;
    } else {
        return 1.0;
    }
}

vec4 colormap(float x) {
    return vec4(colormap_red(x), colormap_green(x), colormap_blue(x), 1.0);
}



float rand(vec2 n) { 
    return fract(sin(dot(n, vec2(-0.490,-0.250))) * 900000.5453);
}

float noise(vec2 p){
    vec2 ip = floor(p);
    vec2 u = fract(p);
    u = u*u*(3.0-2.0*u); ///Dont Modify / Fracture

    float res = mix(
        mix(rand(ip),rand(ip+vec2(1.0,0.0)),u.x), ///Dont Modify / Fracture
        mix(rand(ip+vec2(0.0,1.0)),rand(ip+vec2(1.0,1.0)),u.x),u.y); ///Dont Modify / Fracture
    return res*res;
}

const mat2 mtx = mat2( .90,  .10, -.40,  .80 ); ///Pattern mapped to x,y grid
///angle / warp / speed / rotation


float fbm( vec2 p )
{
    float f = -0.0; ///Height

    f += 0.500000*noise( p + time  ); p = mtx*p*1.2; ///Pulsing / Detail
    f += 0.15*noise( p ); p = mtx*p*2.01; /// Height of Brightest color
    f += 0.10*noise( p ); p = mtx*p*2.03; /// Depth of darkest color
    f += 0.141*noise( p ); p = mtx*p*1.01; ///Texture / Detail
    f += 0.062500*noise( p ); p = mtx*p*1.04; ///Texture / Detail
    f += -0.168*noise( p + sin(time) ); /// Noise 

    return f/1.09; /// Final Noise 
}

float pattern( in vec2 p )
{
	return fbm( p + fbm( p + fbm( p ) ) );
}
float bandSize=20.0;
float speed=-0.25;
float stripes(vec2 uv, float time) {
    // Calculer le défilement en fonction du temps et de la vitesse
    float stripePosition = mod((uv.x+uv.y) * bandSize - time * speed, 1.0);
    return step(0.5, stripePosition);
}
void getEmission() {
    vec2 uv = vUv0;
    float shade = pattern(uv);
    vec3 colorMap = vec3(colormap(shade).r * shade, colormap(shade).gb);
    
    // Obtenir l'effet de bande
    float bandEffect = stripes(uv, time);
    
    // Combinaison de l'effet de couleur avec l'effet de bande
    // Les bandes noires et blanches modifient la luminosité du résultat final
    dEmission = mix(colorMap * 0.1, colorMap, bandEffect); // Bandes noires plus sombres, bandes blanches avec couleur pleine
}