var BarcamMovement = pc.createScript('barcamMovement');

/**
 * Attributs configurables dans l’éditeur PlayCanvas
 */

// L’entité “cible” que la caméra regarde durant son déplacement
BarcamMovement.attributes.add('target', {
    type: 'entity',
    title: 'Cible',
    description: 'Entité que la caméra regarde pendant le déplacement'
});

// Vitesse de déplacement (unités/secondes)
BarcamMovement.attributes.add('speed', {
    type: 'number',
    default: 2,
    title: 'Vitesse (unités/sec)'
});

// Délai avant le début du mouvement (ms)
BarcamMovement.attributes.add('startDelayMs', {
    type: 'number',
    default: 0,
    title: 'Délai (ms)'
});

// --- NOUVEAUX ATTRIBUTS ---
// Position finale par défaut
BarcamMovement.attributes.add('endPosition', {
    type: 'vec3',
    default: [2.1814935207366943, 58.548828125, 12.100506782531738],
    title: 'Position finale',
    description: 'Position que la caméra doit atteindre'
});

// Direction finale par défaut
BarcamMovement.attributes.add('endDirection', {
    type: 'vec3',
    default: [-0.02403315754794052, 0.984195606114128, -0.1754463343701436],
    title: 'Direction finale',
    description: 'Orientation de la caméra une fois arrivée'
});


/**
 * Initialise les variables d’état
 */
BarcamMovement.prototype.initialize = function() {
    // Pour gérer le délai
    this.waiting = false;
    this.waitTime = 0;   // compteur du temps d’attente en ms

    // Pour gérer le déplacement
    this.moving = false;
    this.travelTime = 0; // durée totale du déplacement
    this.elapsed = 0;    // temps écoulé depuis le début du déplacement

    // Positions de départ et d'arrivée
    this.startPos = new pc.Vec3();
    this.endPos = new pc.Vec3();

    // Écoute l’événement "barcamAnim"
    this.app.on('barcamAnim', this.onBarcamAnim, this);
};


/**
 * Callback appelé quand l’événement 'barcamAnim' est émis
 */
BarcamMovement.prototype.onBarcamAnim = function() {
    // On définit la position de départ comme la position actuelle de la caméra
    this.startPos.copy(this.entity.getPosition());

    // On définit la position finale depuis l’attribut endPosition
    this.endPos.copy(this.endPosition);

    // Calcul de la distance à parcourir
    var distance = this.startPos.distance(this.endPos);

    // Calcul de la durée du déplacement en secondes, selon la vitesse
    this.travelTime = distance / this.speed;
    this.elapsed = 0;

    // Gérer le délai
    if (this.startDelayMs > 0) {
        this.waiting = true;
        this.waitTime = 0;
        this.moving = false;
    } else {
        this.waiting = false;
        this.moving = true;
    }
};


/**
 * update() est appelé à chaque frame
 */
BarcamMovement.prototype.update = function(dt) {
    // 1) Gérer le délai avant le déplacement
    if (this.waiting) {
        this.waitTime += dt * 1000; // dt en secondes => on convertit en ms
        if (this.waitTime >= this.startDelayMs) {
            // Fin du délai, on démarre le mouvement
            this.waiting = false;
            this.moving = true;
            this.elapsed = 0;
        }
    }

    // 2) Déplacer la caméra si on est en mode "moving"
    if (this.moving) {
        this.elapsed += dt;

        // Pourcentage d’avancement entre 0 et 1
        var t = this.elapsed / this.travelTime;
        if (t > 1) t = 1;

        // Interpolation linéaire entre startPos et endPos
        var newPos = new pc.Vec3().lerp(this.startPos, this.endPos, t);
        this.entity.setPosition(newPos);

        // Tant qu'on n'est pas à destination, on regarde la target (si définie)
        if (this.target) {
            this.entity.lookAt(this.target.getPosition());
        }

        // Si on atteint la fin du déplacement
        if (t === 1) {
            // On fixe la position exactement
            this.entity.setPosition(this.endPos);

            // On définit la direction finale
            var finalLook = this.endPos.clone().add(this.endDirection);
            this.entity.lookAt(finalLook);

            // On arrête le mouvement
            this.moving = false;

            // On émet les événements existants
           
       
            this.app.fire('moveHexagon');
        }
    }
};
