var Billboard = pc.createScript("billboard");

/**
 * @name Billboard
 * @description
 * Script qui oriente toujours l'entité pour qu'elle fasse face à la caméra.
 * 
 * Place-le sur une entité qui possède un modèle ou un sprite. Associe
 * éventuellement la "cameraEntity" via l'inspecteur PlayCanvas. 
 * Sinon, il cherchera la première caméra trouvée dans la hiérarchie.
 */

Billboard.attributes.add("cameraEntity", {
    type: "entity",
    title: "Camera Entity",
    description: "Caméra à viser. Si non spécifiée, on la cherche automatiquement."
});

Billboard.prototype.initialize = function() {
    // Si aucune caméra n'est définie, on essaie de trouver la première dans la scène
    if (!this.cameraEntity) {
        var cameras = this.app.root.findByTag("camera");
        if (cameras.length > 0) {
            this.cameraEntity = cameras[0];
        } else {
            // Ou, s'il n'y a pas de tag, on cherche par nom
            var found = this.app.root.findByName("Camera");
            if (found) {
                this.cameraEntity = found;
            } else {
                console.warn("Billboard script: Aucune caméra spécifiée ni trouvée. L'entité ne pivotera pas.");
            }
        }
    }
};

Billboard.prototype.update = function(dt) {
    if (!this.cameraEntity) {
        return; // Pas de caméra => on ne fait rien
    }

    // Fait en sorte que l'entité regarde vers la position de la caméra.
    // Note : lookAt pointe l'axe -Z local vers la cible. 
    this.entity.lookAt(this.cameraEntity.getPosition());

    // Selon l'orientation de ton mesh, il se peut que tu doives inverser l'axe
    // Pour retourner de 180° l'objet (si tu vois le dos de l'objet):
    // this.entity.rotateLocal(0, 180, 0);
};
