var StarfieldShader = pc.createScript('starfieldShader');

// Vitesse de l'animation
StarfieldShader.attributes.add('speed', {
    type: 'number',
    default: 1.0,
    title: 'Speed'
});

// Liste des matériaux sur lesquels appliquer le shader personnalisé
StarfieldShader.attributes.add('materials', {
    type: 'asset',
    assetType: 'material',
    array: true,
    title: 'Materials'
});

// Code du vertex shader (intégré directement)
var vertexShaderCode = 
"attribute vec3 aPosition;\n" +
"attribute vec2 aUv0;\n" +
"varying vec2 vUv0;\n" +
"uniform mat4 matrix_model;\n" +
"uniform mat4 matrix_viewProjection;\n" +
"void main(void) {\n" +
"    vUv0 = aUv0;\n" +
"    gl_Position = matrix_viewProjection * matrix_model * vec4(aPosition, 1.0);\n" +
"}\n";

// Code du fragment shader (inspiré du shader Shadertoy)
var fragmentShaderCode = 
"precision mediump float;\n" +
"varying vec2 vUv0;\n" +
"uniform float iTime;\n" +
"uniform vec2 iResolution;\n" +
"\n" +
"#define NUM_LAYERS 8.0\n" +
"#define TAU 6.28318\n" +
"#define Velocity 0.025\n" +
"#define StarGlow 0.025\n" +
"#define CanvasView 20.0\n" +
"\n" +
"float Star(vec2 uv, float flare){\n" +
"    float d = length(uv);\n" +
"    float m = sin(StarGlow * 1.2) / d;\n" +
"    float rays = max(0.0, 0.5 - abs(uv.x * uv.y * 1000.0));\n" +
"    m += (rays * flare) * 2.0;\n" +
"    m *= smoothstep(1.0, 0.1, d);\n" +
"    return m;\n" +
"}\n" +
"\n" +
"float Hash21(vec2 p){\n" +
"    p = fract(p * vec2(123.34, 456.21));\n" +
"    p += dot(p, p + 45.32);\n" +
"    return fract(p.x * p.y);\n" +
"}\n" +
"\n" +
"vec3 StarLayer(vec2 uv){\n" +
"    vec3 col = vec3(0.0);\n" +
"    vec2 gv = fract(uv);\n" +
"    vec2 id = floor(uv);\n" +
"    for (int y = -1; y <= 1; y++) {\n" +
"        for (int x = -1; x <= 1; x++) {\n" +
"            vec2 offs = vec2(float(x), float(y));\n" +
"            float n = Hash21(id + offs);\n" +
"            float size = fract(n);\n" +
"            float star = Star(gv - offs - vec2(n, fract(n * 34.0)) + 0.5, smoothstep(0.1, 0.9, size) * 0.46);\n" +
"            vec3 color = sin(vec3(0.2, 0.3, 0.9) * fract(n * 2345.2) * TAU) * 0.25 + 0.75;\n" +
"            color *= vec3(0.9, 0.59, 0.9 + size);\n" +
"            star *= sin(iTime * 0.6 + n * TAU) * 0.5 + 0.5;\n" +
"            col += star * size * color;\n" +
"        }\n" +
"    }\n" +
"    return col;\n" +
"}\n" +
"\n" +
"void main(void) {\n" +
"    // Recalibrer les UV pour un rendu correct sur la sphère\n" +
"    vec2 uv = (vUv0 - 0.5) * vec2(iResolution.x / iResolution.y, 1.0);\n" +
"    float t = iTime * Velocity;\n" +
"    vec3 col = vec3(0.0);\n" +
"    for (float i = 0.0; i < 1.0; i += 1.0 / NUM_LAYERS) {\n" +
"        float depth = fract(i + t);\n" +
"        float scale = mix(CanvasView, 0.5, depth);\n" +
"        float fade = depth * smoothstep(1.0, 0.9, depth);\n" +
"        col += StarLayer(uv * scale + i * 453.2 - iTime * 0.05) * fade;\n" +
"    }\n" +
"    gl_FragColor = vec4(col, 1.0);\n" +
"}\n";

StarfieldShader.prototype.initialize = function() {
    this.time = 0;
    var app = this.app;
    var gd = app.graphicsDevice;

    // Pour chaque matériau assigné, on crée et applique le shader personnalisé
    for (var i = 0; i < this.materials.length; i++) {
        var materialAsset = this.materials[i];
        var material = materialAsset.resource;
        
        // Création du shader personnalisé avec les shaders intégrés
        material.shader = new pc.Shader(gd, {
            attributes: {
                aPosition: pc.SEMANTIC_POSITION,
                aUv0: pc.SEMANTIC_TEXCOORD0
            },
            vshader: vertexShaderCode,
            fshader: fragmentShaderCode
        });
        
        // Définir la résolution (pour que le shader connaisse la taille du canvas)
        material.setParameter("iResolution", [app.graphicsDevice.canvas.width, app.graphicsDevice.canvas.height]);
        // Inverser le culling pour rendre l'intérieur de la sphère visible
      //  material.cull = pc.CULLFACE_BACK;
        material.update();
    }

    // Mettre à jour la résolution en cas de redimensionnement de la fenêtre
    window.addEventListener('resize', function() {
        for (var i = 0; i < this.materials.length; i++) {
            var material = this.materials[i].resource;
            material.setParameter("iResolution", [app.graphicsDevice.canvas.width, app.graphicsDevice.canvas.height]);
        }
    }.bind(this));
};

StarfieldShader.prototype.update = function(dt) {
    this.time += dt * this.speed;
    for (var i = 0; i < this.materials.length; i++) {
        var material = this.materials[i].resource;
        material.setParameter('iTime', this.time);
    }
};
