var PlaceTween = pc.createScript('placeTween');

// Ajouter les attributs réglables
PlaceTween.attributes.add('triggerEvent', {
    type: 'string',
    default: 'place',
    title: 'Événement Déclencheur',
    description: 'Nom de l\'événement qui déclenche l\'animation'
});

PlaceTween.attributes.add('targetEntity', {
    type: 'entity',
    title: 'Entité à Animer',
    description: 'L\'entité qui sera déplacée devant la caméra'
});

PlaceTween.attributes.add('cameraEntity', {
    type: 'entity',
    title: 'Caméra',
    description: 'La caméra devant laquelle l\'objet sera placé'
});

PlaceTween.attributes.add('distance', {
    type: 'number',
    default: 10,
    title: 'Distance devant la Caméra',
    description: 'Distance à laquelle placer l\'objet devant la caméra'
});

PlaceTween.attributes.add('speed', {
    type: 'number',
    default: 5,
    title: 'Vitesse de déplacement',
    description: 'Vitesse en unités par seconde'
});

// Initialisation
PlaceTween.prototype.initialize = function () {
    this.moving = false;
    this.targetPos = new pc.Vec3();

    // Écoute l'événement déclencheur
    this.app.on(this.triggerEvent, this.startMoving, this);
};

// Fonction qui définit la position cible et active le déplacement
PlaceTween.prototype.startMoving = function () {
    if (!this.targetEntity) {
        console.warn("PlaceTween: Aucune entité cible sélectionnée !");
        return;
    }

    if (!this.cameraEntity) {
        console.warn("PlaceTween: Aucune caméra sélectionnée !");
        return;
    }

    // Calculer la position cible devant la caméra
    var cameraPos = this.cameraEntity.getPosition();
    var cameraForward = this.cameraEntity.forward.clone().normalize(); // Direction de la caméra

    this.targetPos.copy(cameraPos).add(cameraForward.scale(this.distance)); // Position finale

    this.moving = true;
};

// Update : Gère le déplacement progressif
PlaceTween.prototype.update = function (dt) {
    if (this.moving && this.targetEntity) {
        var currentPos = this.targetEntity.getPosition();
        
        // Interpolation linéaire (lerp) pour lisser le déplacement
        currentPos.lerp(currentPos, this.targetPos, this.speed * dt);
        
        this.targetEntity.setPosition(currentPos);

        // Vérifier si l'objet est suffisamment proche de la cible
        if (currentPos.distance(this.targetPos) < 0.1) {
            this.moving = false; // Arrêter le mouvement
        }
    }
};
