var ChronoDisplay = pc.createScript('chronoDisplay');

/**
 * Référence à l'entité qui possède le script timelineManager.
 * Assurez-vous que 'timelineManager' est bien un nom de script attaché à cette entité.
 */
ChronoDisplay.attributes.add('timelineEntity', {
    type: 'entity',
    title: 'Entity with timelineManager'
});

ChronoDisplay.prototype.initialize = function() {
    // Création d'un élément HTML qui affichera le temps
    this.chronoDiv = document.createElement('div');
    
    // Placement et style de l'affichage
    this.chronoDiv.style.position = 'absolute';
    this.chronoDiv.style.top = '10px';
    this.chronoDiv.style.left = '60px';
    this.chronoDiv.style.color = 'white';
    this.chronoDiv.style.backgroundColor = 'rgba(0, 0, 0, 0.7)';
    this.chronoDiv.style.padding = '5px';
    this.chronoDiv.style.fontFamily = 'Arial';
    this.chronoDiv.style.fontSize = '18px';
    this.chronoDiv.style.fontWeight='bold';
    this.chronoDiv.style.zIndex = 9999; // Pour s'assurer qu'il apparaît devant
    
    // Ajout au DOM
    document.body.appendChild(this.chronoDiv);
};

ChronoDisplay.prototype.update = function(dt) {
    // On récupère le script "timelineManager" sur l'entité spécifiée
    var timelineScript = this.timelineEntity && this.timelineEntity.script.timelineManager;
    
    if (timelineScript) {
        // Récupère le temps écoulé
        var timeElapsed = timelineScript.getTimeElapsed();
        
        // Mise à jour de l'affichage (arrondi à 2 décimales)
        this.chronoDiv.textContent = timeElapsed.toFixed(2) + ' s';
    }
};

ChronoDisplay.prototype.destroy = function() {
    // Nettoyage de l'élément HTML lorsqu'on retire l'entité
    if (this.chronoDiv && this.chronoDiv.parentNode) {
        this.chronoDiv.parentNode.removeChild(this.chronoDiv);
    }
};
