var Activator = pc.createScript('activator');

// Définit le nom de l’évènement à écouter
Activator.attributes.add('eventName', {
    type: 'string',
    default: 'activerEntite',
    title: 'Nom de l\'évènement'
});

// Cible à activer
Activator.attributes.add('target', {
    type: 'entity',
    title: 'Entité à activer'
});

Activator.prototype.initialize = function() {
    // On écoute l’évènement
    this.app.on(this.eventName, this.onActivate, this);
};

Activator.prototype.onActivate = function() {
    if (this.target) {
        // On active la hiérarchie "target + enfants"
        this.target.enabled = true;
    }
};

// Se désabonner de l’évènement si l’entité manager est détruite
Activator.prototype.destroy = function() {
    this.app.off(this.eventName, this.onActivate, this);
};
