var TimelineTrigger = pc.createScript('timelineTrigger');

TimelineTrigger.attributes.add('entities', {
    type: 'json',
    array: true,
    title: 'Nombre d’entités à gérer',
    schema: [{
        name: 'targetEntity',
        type: 'entity',
        title: 'Entité à activer'
    }, {
        name: 'triggerTime',
        type: 'number',
        default: 1.0,
        title: 'Temps avant déclenchement (sec)'
    }, {
        name: 'consoleMessage',
        type: 'string',
        default: '',
        title: 'Message à envoyer dans la console'
    }, {
        name: 'eventToFire',
        type: 'string',
        default: '',
        title: 'eventToFire'
    }]
});

TimelineTrigger.prototype.initialize = function () {
    this.elapsedTime = 0;

    // Tri par ordre croissant de temps
    this.entities.sort(function (a, b) {
        return a.triggerTime - b.triggerTime;
    });

    // Marque chaque événement comme "non déclenché"
    this.entities.forEach(function (e) {
        e.triggered = false;
    });
};

TimelineTrigger.prototype.update = function (dt) {
    this.elapsedTime += dt;

    for (let i = 0; i < this.entities.length; i++) {
        const item = this.entities[i];

        if (!item.triggered && this.elapsedTime >= item.triggerTime) {
            item.triggered = true;

            if (item.targetEntity) {
                item.targetEntity.enabled = true;
                this.switchCameraToScene(item.targetEntity);
            }

            if (item.consoleMessage && item.consoleMessage.trim() !== '') {
                console.log('[TimelineTrigger]', item.consoleMessage);
            }

            if (item.eventToFire && item.eventToFire.trim() !== '') {
                this.app.fire(item.eventToFire);
            }
        }
    }
};

TimelineTrigger.prototype.switchCameraToScene = function (sceneEntity) {
    const cam = sceneEntity.findComponent('camera');
    if (!cam) return;

    const allCams = this.app.root.findComponents('camera');
    allCams.forEach(function (c) {
        c.entity.enabled = false;
    });

    cam.entity.enabled = true;
    console.log('[TimelineTrigger] Caméra activée :', cam.entity.name);
};
