var PlaneGenerator = pc.createScript('planeGenerator');

// Paramètres pour définir la taille et le nombre de subdivisions
PlaneGenerator.attributes.add('planeWidth', {
    type: 'number',
    default: 10,
    title: 'Largeur du Plane'
});
PlaneGenerator.attributes.add('planeHeight', {
    type: 'number',
    default: 10,
    title: 'Hauteur du Plane'
});
PlaneGenerator.attributes.add('widthSegments', {
    type: 'number',
    default: 10,
    title: 'Segments en largeur'
});
PlaneGenerator.attributes.add('heightSegments', {
    type: 'number',
    default: 10,
    title: 'Segments en hauteur'
});

// Ajout d'un attribut pour sélectionner un matériau dans l'éditeur (assetType: 'material')
PlaneGenerator.attributes.add('planeMaterial', {
    type: 'asset',
    assetType: 'material',
    title: 'Matériau'
});

PlaneGenerator.prototype.initialize = function() {
    // 1) Génère le mesh subdivisé
    var mesh = pc.createPlane(this.app.graphicsDevice, {
        halfExtents: new pc.Vec2(this.planeWidth / 2, this.planeHeight / 2),
        widthSegments: this.widthSegments,
        lengthSegments: this.heightSegments
    });

    // 2) Récupère le matériau sélectionné, ou crée un matériau par défaut
    var mat;
    if (this.planeMaterial) {
        // Si un matériau est sélectionné dans l'éditeur
        mat = this.planeMaterial.resource;
    } else {
        // Sinon on crée un matériau blanc par défaut
        mat = new pc.StandardMaterial();
        mat.diffuse = new pc.Color(1, 1, 1);
        mat.update();
    }

    // 3) Crée la meshInstance associant le mesh au matériau
    var meshInstance = new pc.MeshInstance(mesh, mat);

    // 4) Ajoute un composant Render à l'entité
    this.entity.addComponent('render', {
        meshInstances: [meshInstance],
        castShadows: true,
        receiveShadows: true
    });
};
