var BloomAllCameras = pc.createScript('bloomAllCameras');

// Attributs de config pour l’effet Bloom
BloomAllCameras.attributes.add('bloomIntensity', { type: 'number', default: 1 });
BloomAllCameras.attributes.add('bloomThreshold', { type: 'number', default: 0.25 });
BloomAllCameras.attributes.add('blurAmount', { type: 'number', default: 4 });

BloomAllCameras.prototype.initialize = function() {
    // Récupère tous les entities ayant un composant 'camera'
    var cameraEntities = this.app.root.findComponents('camera');

    // Tableau pour stocker les (camera, effet) pour un éventuel nettoyage
    this.bloomData = [];

    for (var i = 0; i < cameraEntities.length; i++) {
        var cam = cameraEntities[i];

        // Crée une instance de BloomEffect
        var bloomEffect = new BloomEffect(this.app.graphicsDevice);
        // Paramètre les propriétés
        bloomEffect.bloomThreshold = this.bloomThreshold;
        bloomEffect.blurAmount     = this.blurAmount;
        bloomEffect.bloomIntensity= this.bloomIntensity;

        // Ajoute l’effet à la postEffects queue de la caméra
        cam.postEffects.addEffect(bloomEffect);

        // Mémorise pour pouvoir le retirer plus tard si besoin
        this.bloomData.push({
            cameraEntity: cam.entity,     // ou cam, ou comme vous voulez
            effect: bloomEffect
        });
    }
};

// Méthode pour retirer tous les effets Bloom de toutes les caméras
BloomAllCameras.prototype.removeAllBloom = function() {
    for (var i = 0; i < this.bloomData.length; i++) {
        var data = this.bloomData[i];
        var cameraEntity = data.cameraEntity;
        if (cameraEntity && cameraEntity.camera) {
            cameraEntity.camera.postEffects.removeEffect(data.effect);
        }
        // détruire les RT si nécessaire :
        if (data.effect._destroy) {
            data.effect._destroy();
        }
    }
    this.bloomData = [];
};

// Si vous souhaitez appeler removeAllBloom() à la destruction :
BloomAllCameras.prototype.destroy = function() {
    this.removeAllBloom();
};
