var ScenePreloader = pc.createScript('scenePreloader');

ScenePreloader.attributes.add('scenesToPreload', {
    type: 'entity',
    array: true,
    title: 'Scènes à précharger'
});

ScenePreloader.prototype.initialize = function () {
    this.currentSceneIndex = 0;
    this.frameCounter = 0;

    if (this.scenesToPreload.length === 0) {
        console.warn("[ScenePreloader] Aucune scène définie pour préchargement.");
        this.enabled = false;
        return;
    }

    console.log("[ScenePreloader] Début du préchargement des scènes...");
};

ScenePreloader.prototype.update = function (dt) {
    if (this.currentSceneIndex >= this.scenesToPreload.length) {
        console.log("[ScenePreloader] Toutes les scènes ont été préchargées.");
        this.enabled = false;
        return;
    }

    // Active brièvement chaque scène (pendant une seule frame)
    if (this.frameCounter === 0) {
        var currentScene = this.scenesToPreload[this.currentSceneIndex];
        currentScene.enabled = true;
        console.log("[ScenePreloader] Activation temporaire de :", currentScene.name);
    } else if (this.frameCounter === 1) {
        var currentScene = this.scenesToPreload[this.currentSceneIndex];
        currentScene.enabled = false;
        console.log("[ScenePreloader] Désactivation après préchargement :", currentScene.name);

        // Passe à la scène suivante
        this.currentSceneIndex++;
        this.frameCounter = -1; // Reset pour prochaine scène
    }

    this.frameCounter++;
};
