var CustomWave = pc.createScript('customWave');

// Paramètres pour régler l'effet
CustomWave.attributes.add('amplitude', {
    type: 'number',
    default: 0.1,
    title: 'Amplitude'
});

CustomWave.attributes.add('speed', {
    type: 'number',
    default: 4.0,
    title: 'Speed'
});

CustomWave.prototype.initialize = function() {
    this.time = 0;

    var gd = this.app.graphicsDevice;

    // === Vertex shader ===
    var vs = [
        "attribute vec3 aPosition;",
        "attribute vec2 aUv0;",

        // Matrices auto-gérées par PlayCanvas (on les connectera via 'uniforms' + 'semantic')
        "uniform mat4 matrix_model;",
        "uniform mat4 matrix_viewProjection;",

        // Uniformes qu'on mettra à jour dans 'update()'
        "uniform float uTime;",
        "uniform float uAmplitude;",
        "uniform float uSpeed;",

        "varying vec2 vUv0;",

        "void main(void) {",
        "    // Transforme la position locale en world space",
        "    vec4 pos = matrix_model * vec4(aPosition, 1.0);",
        "",
        "    // Application d'un déplacement sin/cos, façon « effet ondulé »",
        "    // Ajustez la formule selon vos goûts",
        "    pos.x += sin(uTime + pos.y * uSpeed) * uAmplitude;",
        "    pos.y += cos(uTime + pos.x * uSpeed) * uAmplitude;",
        "",
        "    // On transmet l'UV au fragment shader pour usage éventuel",
        "    vUv0 = aUv0;",
        "",
        "    // Ensuite, on calcule la position écran via viewProjection",
        "    gl_Position = matrix_viewProjection * pos;",
        "}"
    ].join("\n");

    // === Fragment shader ===
    // Ici, on fait simple : on colorie en fonction des UV
    var fs = [
        "precision " + gd.precision + " float;",
        "varying vec2 vUv0;",
        "void main(void) {",
        "    // Pour l'exemple, on fait un dégradé en RGB = (u, v, 0)",
        "    gl_FragColor = vec4(vUv0, 0.0, 1.0);",
        "}"
    ].join("\n");

    // Définition du shader, en indiquant les « semantics » pour que le moteur
    // injecte automatiquement matrix_model et matrix_viewProjection.
    var shaderDefinition = {
        attributes: {
            aPosition: pc.SEMANTIC_POSITION,
            aUv0: pc.SEMANTIC_TEXCOORD0
        },

        // Si vous voulez que PlayCanvas mette à jour auto. `matrix_model` et `matrix_viewProjection`,
        // vous pouvez utiliser la propriété `uniforms` + `semantic`. (Optionnel, mais pratique.)
        uniforms: [
            { name: "matrix_model",          semantic: pc.SEMANTIC_MODEL,          type: pc.UNIFORMTYPE_MAT4 },
            { name: "matrix_viewProjection", semantic: pc.SEMANTIC_VIEWPROJECTION, type: pc.UNIFORMTYPE_MAT4 },
            { name: "uTime",       type: pc.UNIFORMTYPE_FLOAT },
            { name: "uAmplitude",  type: pc.UNIFORMTYPE_FLOAT },
            { name: "uSpeed",      type: pc.UNIFORMTYPE_FLOAT }
        ],

        vshader: vs,
        fshader: fs
    };

    // Crée le shader custom
    var shader = new pc.Shader(gd, shaderDefinition);

    // Crée un matériau PlayCanvas qui utilisera ce shader
    this.material = new pc.Material();
    this.material.shader = shader;
    this.material.update();

    // Assigne ce matériau à tous les meshInstances de l'entité
    var renderOrModel = this.entity.render || this.entity.model;
    if (renderOrModel && renderOrModel.meshInstances) {
        for (var i = 0; i < renderOrModel.meshInstances.length; i++) {
            renderOrModel.meshInstances[i].material = this.material;
        }
    } else {
        console.warn("L'entité n'a pas de meshInstances (pas de render/model)");
    }
};

CustomWave.prototype.update = function(dt) {
    // Incrémente le temps
    this.time += dt;

    // On transmet nos valeurs d'uniformes
    this.material.setParameter("uTime", this.time);
    this.material.setParameter("uAmplitude", this.amplitude);
    this.material.setParameter("uSpeed", this.speed);
};
