/* eslint-disable no-undef */
var StarfieldDepth = pc.createScript('starfieldDepth');

/*─────────────────
 * ATTRIBUTS
 *────────────────*/
StarfieldDepth.attributes.add('speed', {
    type: 'number',
    default: 1,
    title: 'Animation Speed'
});

StarfieldDepth.attributes.add('fadeInSpeed', {
    type: 'number',
    default: 0.5,
    title: 'Fade‑In Speed'
});

StarfieldDepth.attributes.add('camOffsetFactor', {
    type: 'number',
    default: 0.001,
    title: 'Camera Offset Factor'
});

/*─────────────────
 * INITIALISATION
 *────────────────*/
StarfieldDepth.prototype.initialize = function () {

    this.effect = new StarfieldDepthEffect(this.app.graphicsDevice);
    this.queue  = this.entity.camera.postEffects;
    this._effectAdded = false;

    /* ancien déclencheur par événement supprimé —> on active directement */
    this.enableStarfieldDepthEffect();

    /* enable/disable via this.enabled */
    this.on('state', function (enabled) {
        if (!enabled)   this.disableStarfieldDepthEffect(false);
        else            this.enableStarfieldDepthEffect();
    });

    /* clean onDestroy */
    this.on('destroy', function () {
        this.disableStarfieldDepthEffect(true);
    });
};

/*─────────────────
 * UPDATE
 *────────────────*/
StarfieldDepth.prototype.update = function (dt) {
    if (!this._effectAdded) return;

    /* animation */
    this.effect.time += dt * this.speed;

    /* fade‑in progressif */
    if (this.effect.fade < 1) {
        this.effect.fade += dt * this.fadeInSpeed;
        if (this.effect.fade > 1) this.effect.fade = 1;
    }

    /* décalage UV basé sur la rotation caméra */
    const euler = this.entity.getEulerAngles();      // degrés
    const offsetX = euler.y * this.camOffsetFactor;
    const offsetY = euler.x * this.camOffsetFactor;
    this.effect.camOffset.set(offsetX, offsetY);
};

/*─────────────────
 * (DES)ACTIVATION DE L’EFFET
 *────────────────*/
StarfieldDepth.prototype.enableStarfieldDepthEffect = function () {
    if (!this.enabled) return;
    this.effect.fade = 0;
    if (!this._effectAdded) {
        this.queue.addEffect(this.effect);
        this._effectAdded = true;
    }
};

StarfieldDepth.prototype.disableStarfieldDepthEffect = function (destroy) {
    if (this._effectAdded) {
        this.queue.removeEffect(this.effect);
        this._effectAdded = false;
    }
    if (destroy && this.effect && this.effect._destroy) {
        this.effect._destroy();
    }
};
