var SoundTrigger = pc.createScript('soundTrigger');

// Attribut pour sélectionner la caméra
SoundTrigger.attributes.add('camera', {
    type: 'entity',
    title: 'Caméra'
});

// Attribut pour sélectionner l'entité cible
SoundTrigger.attributes.add('targetEntity', {
    type: 'entity',
    title: 'Entité Cible'
});

// Distance max
SoundTrigger.attributes.add('maxDistance', {
    type: 'number',
    default: 10,
    title: 'Distance Maximale'
});

// Attribut pour sélectionner l'asset audio
SoundTrigger.attributes.add('soundAsset', {
    type: 'asset',
    assetType: 'audio',
    title: 'Son'
});

SoundTrigger.prototype.initialize = function() {
    this.soundPlayed = false;
    
    // Vérifie si l'entité a déjà un composant Sound. Sinon, on l’ajoute.
    if (!this.entity.sound) {
        this.entity.addComponent('sound', {
            // Paramètre "positional" selon si tu veux un son 3D ou non
            positional: false,
            volume: 1
        });
       console.log("Composant son ajouté automatiquement.");
    }

    // On crée un slot si inexistant
    // (nomme-le comme tu veux, ici "slotTrigger")
    if (!this.entity.sound.slot('slotTrigger')) {
        this.entity.sound.addSlot('slotTrigger', {
            asset: this.soundAsset,
            loop: false,
            volume: 1
        });
    }
};

SoundTrigger.prototype.update = function(dt) {
    if (this.soundPlayed) return;

    if (!this.camera || !this.targetEntity) {
        console.error("Veuillez assigner la Caméra et l'Entité Cible dans l'inspecteur.");
        return;
    }
    
    var camPos = this.camera.getPosition();
    var targetPos = this.targetEntity.getPosition();
    
    var distance = targetPos.clone().sub(camPos).length();
    //console.log("Distance Euclidienne :", distance);
    
    if (distance > this.maxDistance) {
      //  console.log("Distance (" + distance + ") > max (" + this.maxDistance + ").");
        return;
    }
    
    var screenPos = new pc.Vec3();
    this.camera.camera.worldToScreen(targetPos, screenPos);
    
    if (screenPos.z < 0) {
        console.log("L'entité est derrière la caméra.");
        return;
    }
    
    var width = this.app.graphicsDevice.width;
    var height = this.app.graphicsDevice.height;
    
    if (screenPos.x < 0 || screenPos.x > width || screenPos.y < 0 || screenPos.y > height) {
        console.log("L'entité cible n'est pas visible dans le champ de vision.");
        return;
    }
    
    // On lance le son depuis le slot
    console.log("Conditions remplies. Lecture du son.");
    this.entity.sound.play('slotTrigger');
    this.soundPlayed = true;
};
