var CameraEllipse = pc.createScript('cameraEllipse');

// Entité autour de laquelle la caméra orbitera
CameraEllipse.attributes.add('target', {
    type: 'entity',
    title: 'Cible',
    description: 'Entité autour de laquelle la caméra orbitera'
});

// Vitesse de déplacement (facteur appliqué au temps)
CameraEllipse.attributes.add('speed', {
    type: 'number',
    default: 1,
    title: 'Vitesse',
    description: 'Vitesse de déplacement de la caméra'
});

// Amplitudes (rayons d’oscillation sur X, Y et Z)
CameraEllipse.attributes.add('amplitudeX', {
    type: 'number',
    default: 3,
    title: 'Amplitude X'
});
CameraEllipse.attributes.add('amplitudeY', {
    type: 'number',
    default: 2,
    title: 'Amplitude Y'
});
CameraEllipse.attributes.add('amplitudeZ', {
    type: 'number',
    default: 3,
    title: 'Amplitude Z'
});

// Fréquences (nombre d’oscillations sur X, Y et Z)
CameraEllipse.attributes.add('frequencyX', {
    type: 'number',
    default: 1,
    title: 'Fréquence X'
});
CameraEllipse.attributes.add('frequencyY', {
    type: 'number',
    default: 2,
    title: 'Fréquence Y'
});
CameraEllipse.attributes.add('frequencyZ', {
    type: 'number',
    default: 3,
    title: 'Fréquence Z'
});

// Phases (décalages de départ sur chaque axe)
CameraEllipse.attributes.add('phaseX', {
    type: 'number',
    default: 0,
    title: 'Phase X'
});
CameraEllipse.attributes.add('phaseY', {
    type: 'number',
    default: 0,
    title: 'Phase Y'
});
CameraEllipse.attributes.add('phaseZ', {
    type: 'number',
    default: 0,
    title: 'Phase Z'
});

// Hauteur minimum autorisée pour la caméra
CameraEllipse.attributes.add('minHeight', {
    type: 'number',
    default: 0,
    title: 'Hauteur Minimum',
    description: 'La caméra ne descendra pas en-dessous de cette valeur sur l’axe Y'
});

// Initialisation
CameraEllipse.prototype.initialize = function() {
    this.time = 0;
};

// Mise à jour (à chaque frame)
CameraEllipse.prototype.update = function(dt) {
    // Si aucune cible n’est définie, on stoppe
    if (!this.target) return;

    // Avancement temporel modulé par la vitesse
    this.time += dt * this.speed;

    // Calcule la position en Lissajous
    var x = this.amplitudeX * Math.sin(this.frequencyX * this.time + this.phaseX);
    var y = this.amplitudeY * Math.sin(this.frequencyY * this.time + this.phaseY);
    var z = this.amplitudeZ * Math.sin(this.frequencyZ * this.time + this.phaseZ);

    // Position de la cible
    var targetPos = this.target.getPosition();

    // Nouvelle position de la caméra
    var newPos = new pc.Vec3(
        targetPos.x + x,
        targetPos.y + y,
        targetPos.z + z
    );

    // Empêcher la caméra de descendre en-dessous de minHeight
    if (newPos.y < this.minHeight) {
        newPos.y = this.minHeight;
    }

    // On met à jour la position et on oriente la caméra vers la cible
    this.entity.setPosition(newPos);
    this.entity.lookAt(targetPos);
};
