(function () {
	'use strict';

	function getDefaultExportFromCjs (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function getAugmentedNamespace(n) {
		if (n.__esModule) return n;
		var a = Object.defineProperty({}, '__esModule', {value: true});
		Object.keys(n).forEach(function (k) {
			var d = Object.getOwnPropertyDescriptor(n, k);
			Object.defineProperty(a, k, d.get ? d : {
				enumerable: true,
				get: function () {
					return n[k];
				}
			});
		});
		return a;
	}

	var dist$2 = {};

	var dist$1 = {};

	/**
	 * Checks if `value` is classified as an `Array` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
	 * @example
	 *
	 * _.isArray([1, 2, 3]);
	 * // => true
	 *
	 * _.isArray(document.body.children);
	 * // => false
	 *
	 * _.isArray('abc');
	 * // => false
	 *
	 * _.isArray(_.noop);
	 * // => false
	 */
	var isArray = Array.isArray;

	var isArray$1 = isArray;

	/** Detect free variable `global` from Node.js. */
	var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

	var freeGlobal$1 = freeGlobal;

	/** Detect free variable `self`. */
	var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

	/** Used as a reference to the global object. */
	var root = freeGlobal$1 || freeSelf || Function('return this')();

	var root$1 = root;

	/** Built-in value references. */
	var Symbol$1 = root$1.Symbol;

	var Symbol$2 = Symbol$1;

	/** Used for built-in method references. */
	var objectProto$5 = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty$5 = objectProto$5.hasOwnProperty;

	/**
	 * Used to resolve the
	 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var nativeObjectToString$1 = objectProto$5.toString;

	/** Built-in value references. */
	var symToStringTag$1 = Symbol$2 ? Symbol$2.toStringTag : undefined;

	/**
	 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @returns {string} Returns the raw `toStringTag`.
	 */
	function getRawTag(value) {
	  var isOwn = hasOwnProperty$5.call(value, symToStringTag$1),
	      tag = value[symToStringTag$1];

	  try {
	    value[symToStringTag$1] = undefined;
	    var unmasked = true;
	  } catch (e) {}

	  var result = nativeObjectToString$1.call(value);
	  if (unmasked) {
	    if (isOwn) {
	      value[symToStringTag$1] = tag;
	    } else {
	      delete value[symToStringTag$1];
	    }
	  }
	  return result;
	}

	/** Used for built-in method references. */
	var objectProto$4 = Object.prototype;

	/**
	 * Used to resolve the
	 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var nativeObjectToString = objectProto$4.toString;

	/**
	 * Converts `value` to a string using `Object.prototype.toString`.
	 *
	 * @private
	 * @param {*} value The value to convert.
	 * @returns {string} Returns the converted string.
	 */
	function objectToString(value) {
	  return nativeObjectToString.call(value);
	}

	/** `Object#toString` result references. */
	var nullTag = '[object Null]',
	    undefinedTag = '[object Undefined]';

	/** Built-in value references. */
	var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : undefined;

	/**
	 * The base implementation of `getTag` without fallbacks for buggy environments.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @returns {string} Returns the `toStringTag`.
	 */
	function baseGetTag(value) {
	  if (value == null) {
	    return value === undefined ? undefinedTag : nullTag;
	  }
	  return (symToStringTag && symToStringTag in Object(value))
	    ? getRawTag(value)
	    : objectToString(value);
	}

	/**
	 * Checks if `value` is object-like. A value is object-like if it's not `null`
	 * and has a `typeof` result of "object".
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
	 * @example
	 *
	 * _.isObjectLike({});
	 * // => true
	 *
	 * _.isObjectLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isObjectLike(_.noop);
	 * // => false
	 *
	 * _.isObjectLike(null);
	 * // => false
	 */
	function isObjectLike(value) {
	  return value != null && typeof value == 'object';
	}

	/** `Object#toString` result references. */
	var symbolTag = '[object Symbol]';

	/**
	 * Checks if `value` is classified as a `Symbol` primitive or object.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
	 * @example
	 *
	 * _.isSymbol(Symbol.iterator);
	 * // => true
	 *
	 * _.isSymbol('abc');
	 * // => false
	 */
	function isSymbol(value) {
	  return typeof value == 'symbol' ||
	    (isObjectLike(value) && baseGetTag(value) == symbolTag);
	}

	/** Used to match property names within property paths. */
	var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
	    reIsPlainProp = /^\w*$/;

	/**
	 * Checks if `value` is a property name and not a property path.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @param {Object} [object] The object to query keys on.
	 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
	 */
	function isKey(value, object) {
	  if (isArray$1(value)) {
	    return false;
	  }
	  var type = typeof value;
	  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
	      value == null || isSymbol(value)) {
	    return true;
	  }
	  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
	    (object != null && value in Object(object));
	}

	/**
	 * Checks if `value` is the
	 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
	 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
	 * @example
	 *
	 * _.isObject({});
	 * // => true
	 *
	 * _.isObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isObject(_.noop);
	 * // => true
	 *
	 * _.isObject(null);
	 * // => false
	 */
	function isObject(value) {
	  var type = typeof value;
	  return value != null && (type == 'object' || type == 'function');
	}

	/** `Object#toString` result references. */
	var asyncTag = '[object AsyncFunction]',
	    funcTag = '[object Function]',
	    genTag = '[object GeneratorFunction]',
	    proxyTag = '[object Proxy]';

	/**
	 * Checks if `value` is classified as a `Function` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
	 * @example
	 *
	 * _.isFunction(_);
	 * // => true
	 *
	 * _.isFunction(/abc/);
	 * // => false
	 */
	function isFunction(value) {
	  if (!isObject(value)) {
	    return false;
	  }
	  // The use of `Object#toString` avoids issues with the `typeof` operator
	  // in Safari 9 which returns 'object' for typed arrays and other constructors.
	  var tag = baseGetTag(value);
	  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
	}

	/** Used to detect overreaching core-js shims. */
	var coreJsData = root$1['__core-js_shared__'];

	var coreJsData$1 = coreJsData;

	/** Used to detect methods masquerading as native. */
	var maskSrcKey = (function() {
	  var uid = /[^.]+$/.exec(coreJsData$1 && coreJsData$1.keys && coreJsData$1.keys.IE_PROTO || '');
	  return uid ? ('Symbol(src)_1.' + uid) : '';
	}());

	/**
	 * Checks if `func` has its source masked.
	 *
	 * @private
	 * @param {Function} func The function to check.
	 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
	 */
	function isMasked(func) {
	  return !!maskSrcKey && (maskSrcKey in func);
	}

	/** Used for built-in method references. */
	var funcProto$2 = Function.prototype;

	/** Used to resolve the decompiled source of functions. */
	var funcToString$2 = funcProto$2.toString;

	/**
	 * Converts `func` to its source code.
	 *
	 * @private
	 * @param {Function} func The function to convert.
	 * @returns {string} Returns the source code.
	 */
	function toSource(func) {
	  if (func != null) {
	    try {
	      return funcToString$2.call(func);
	    } catch (e) {}
	    try {
	      return (func + '');
	    } catch (e) {}
	  }
	  return '';
	}

	/**
	 * Used to match `RegExp`
	 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
	 */
	var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

	/** Used to detect host constructors (Safari). */
	var reIsHostCtor = /^\[object .+?Constructor\]$/;

	/** Used for built-in method references. */
	var funcProto$1 = Function.prototype,
	    objectProto$3 = Object.prototype;

	/** Used to resolve the decompiled source of functions. */
	var funcToString$1 = funcProto$1.toString;

	/** Used to check objects for own properties. */
	var hasOwnProperty$4 = objectProto$3.hasOwnProperty;

	/** Used to detect if a method is native. */
	var reIsNative = RegExp('^' +
	  funcToString$1.call(hasOwnProperty$4).replace(reRegExpChar, '\\$&')
	  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
	);

	/**
	 * The base implementation of `_.isNative` without bad shim checks.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a native function,
	 *  else `false`.
	 */
	function baseIsNative(value) {
	  if (!isObject(value) || isMasked(value)) {
	    return false;
	  }
	  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
	  return pattern.test(toSource(value));
	}

	/**
	 * Gets the value at `key` of `object`.
	 *
	 * @private
	 * @param {Object} [object] The object to query.
	 * @param {string} key The key of the property to get.
	 * @returns {*} Returns the property value.
	 */
	function getValue(object, key) {
	  return object == null ? undefined : object[key];
	}

	/**
	 * Gets the native function at `key` of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {string} key The key of the method to get.
	 * @returns {*} Returns the function if it's native, else `undefined`.
	 */
	function getNative(object, key) {
	  var value = getValue(object, key);
	  return baseIsNative(value) ? value : undefined;
	}

	/* Built-in method references that are verified to be native. */
	var nativeCreate = getNative(Object, 'create');

	var nativeCreate$1 = nativeCreate;

	/**
	 * Removes all key-value entries from the hash.
	 *
	 * @private
	 * @name clear
	 * @memberOf Hash
	 */
	function hashClear() {
	  this.__data__ = nativeCreate$1 ? nativeCreate$1(null) : {};
	  this.size = 0;
	}

	/**
	 * Removes `key` and its value from the hash.
	 *
	 * @private
	 * @name delete
	 * @memberOf Hash
	 * @param {Object} hash The hash to modify.
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function hashDelete(key) {
	  var result = this.has(key) && delete this.__data__[key];
	  this.size -= result ? 1 : 0;
	  return result;
	}

	/** Used to stand-in for `undefined` hash values. */
	var HASH_UNDEFINED$1 = '__lodash_hash_undefined__';

	/** Used for built-in method references. */
	var objectProto$2 = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty$3 = objectProto$2.hasOwnProperty;

	/**
	 * Gets the hash value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf Hash
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function hashGet(key) {
	  var data = this.__data__;
	  if (nativeCreate$1) {
	    var result = data[key];
	    return result === HASH_UNDEFINED$1 ? undefined : result;
	  }
	  return hasOwnProperty$3.call(data, key) ? data[key] : undefined;
	}

	/** Used for built-in method references. */
	var objectProto$1 = Object.prototype;

	/** Used to check objects for own properties. */
	var hasOwnProperty$2 = objectProto$1.hasOwnProperty;

	/**
	 * Checks if a hash value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf Hash
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function hashHas(key) {
	  var data = this.__data__;
	  return nativeCreate$1 ? (data[key] !== undefined) : hasOwnProperty$2.call(data, key);
	}

	/** Used to stand-in for `undefined` hash values. */
	var HASH_UNDEFINED = '__lodash_hash_undefined__';

	/**
	 * Sets the hash `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf Hash
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the hash instance.
	 */
	function hashSet(key, value) {
	  var data = this.__data__;
	  this.size += this.has(key) ? 0 : 1;
	  data[key] = (nativeCreate$1 && value === undefined) ? HASH_UNDEFINED : value;
	  return this;
	}

	/**
	 * Creates a hash object.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function Hash(entries) {
	  var index = -1,
	      length = entries == null ? 0 : entries.length;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	// Add methods to `Hash`.
	Hash.prototype.clear = hashClear;
	Hash.prototype['delete'] = hashDelete;
	Hash.prototype.get = hashGet;
	Hash.prototype.has = hashHas;
	Hash.prototype.set = hashSet;

	/**
	 * Removes all key-value entries from the list cache.
	 *
	 * @private
	 * @name clear
	 * @memberOf ListCache
	 */
	function listCacheClear() {
	  this.__data__ = [];
	  this.size = 0;
	}

	/**
	 * Performs a
	 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	 * comparison between two values to determine if they are equivalent.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to compare.
	 * @param {*} other The other value to compare.
	 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	 * @example
	 *
	 * var object = { 'a': 1 };
	 * var other = { 'a': 1 };
	 *
	 * _.eq(object, object);
	 * // => true
	 *
	 * _.eq(object, other);
	 * // => false
	 *
	 * _.eq('a', 'a');
	 * // => true
	 *
	 * _.eq('a', Object('a'));
	 * // => false
	 *
	 * _.eq(NaN, NaN);
	 * // => true
	 */
	function eq(value, other) {
	  return value === other || (value !== value && other !== other);
	}

	/**
	 * Gets the index at which the `key` is found in `array` of key-value pairs.
	 *
	 * @private
	 * @param {Array} array The array to inspect.
	 * @param {*} key The key to search for.
	 * @returns {number} Returns the index of the matched value, else `-1`.
	 */
	function assocIndexOf(array, key) {
	  var length = array.length;
	  while (length--) {
	    if (eq(array[length][0], key)) {
	      return length;
	    }
	  }
	  return -1;
	}

	/** Used for built-in method references. */
	var arrayProto = Array.prototype;

	/** Built-in value references. */
	var splice = arrayProto.splice;

	/**
	 * Removes `key` and its value from the list cache.
	 *
	 * @private
	 * @name delete
	 * @memberOf ListCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function listCacheDelete(key) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  if (index < 0) {
	    return false;
	  }
	  var lastIndex = data.length - 1;
	  if (index == lastIndex) {
	    data.pop();
	  } else {
	    splice.call(data, index, 1);
	  }
	  --this.size;
	  return true;
	}

	/**
	 * Gets the list cache value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf ListCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function listCacheGet(key) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  return index < 0 ? undefined : data[index][1];
	}

	/**
	 * Checks if a list cache value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf ListCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function listCacheHas(key) {
	  return assocIndexOf(this.__data__, key) > -1;
	}

	/**
	 * Sets the list cache `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf ListCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the list cache instance.
	 */
	function listCacheSet(key, value) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  if (index < 0) {
	    ++this.size;
	    data.push([key, value]);
	  } else {
	    data[index][1] = value;
	  }
	  return this;
	}

	/**
	 * Creates an list cache object.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function ListCache(entries) {
	  var index = -1,
	      length = entries == null ? 0 : entries.length;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	// Add methods to `ListCache`.
	ListCache.prototype.clear = listCacheClear;
	ListCache.prototype['delete'] = listCacheDelete;
	ListCache.prototype.get = listCacheGet;
	ListCache.prototype.has = listCacheHas;
	ListCache.prototype.set = listCacheSet;

	/* Built-in method references that are verified to be native. */
	var Map$1 = getNative(root$1, 'Map');

	var Map$2 = Map$1;

	/**
	 * Removes all key-value entries from the map.
	 *
	 * @private
	 * @name clear
	 * @memberOf MapCache
	 */
	function mapCacheClear() {
	  this.size = 0;
	  this.__data__ = {
	    'hash': new Hash,
	    'map': new (Map$2 || ListCache),
	    'string': new Hash
	  };
	}

	/**
	 * Checks if `value` is suitable for use as unique object key.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
	 */
	function isKeyable(value) {
	  var type = typeof value;
	  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
	    ? (value !== '__proto__')
	    : (value === null);
	}

	/**
	 * Gets the data for `map`.
	 *
	 * @private
	 * @param {Object} map The map to query.
	 * @param {string} key The reference key.
	 * @returns {*} Returns the map data.
	 */
	function getMapData(map, key) {
	  var data = map.__data__;
	  return isKeyable(key)
	    ? data[typeof key == 'string' ? 'string' : 'hash']
	    : data.map;
	}

	/**
	 * Removes `key` and its value from the map.
	 *
	 * @private
	 * @name delete
	 * @memberOf MapCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function mapCacheDelete(key) {
	  var result = getMapData(this, key)['delete'](key);
	  this.size -= result ? 1 : 0;
	  return result;
	}

	/**
	 * Gets the map value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf MapCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function mapCacheGet(key) {
	  return getMapData(this, key).get(key);
	}

	/**
	 * Checks if a map value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf MapCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function mapCacheHas(key) {
	  return getMapData(this, key).has(key);
	}

	/**
	 * Sets the map `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf MapCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the map cache instance.
	 */
	function mapCacheSet(key, value) {
	  var data = getMapData(this, key),
	      size = data.size;

	  data.set(key, value);
	  this.size += data.size == size ? 0 : 1;
	  return this;
	}

	/**
	 * Creates a map cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function MapCache(entries) {
	  var index = -1,
	      length = entries == null ? 0 : entries.length;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	// Add methods to `MapCache`.
	MapCache.prototype.clear = mapCacheClear;
	MapCache.prototype['delete'] = mapCacheDelete;
	MapCache.prototype.get = mapCacheGet;
	MapCache.prototype.has = mapCacheHas;
	MapCache.prototype.set = mapCacheSet;

	/** Error message constants. */
	var FUNC_ERROR_TEXT = 'Expected a function';

	/**
	 * Creates a function that memoizes the result of `func`. If `resolver` is
	 * provided, it determines the cache key for storing the result based on the
	 * arguments provided to the memoized function. By default, the first argument
	 * provided to the memoized function is used as the map cache key. The `func`
	 * is invoked with the `this` binding of the memoized function.
	 *
	 * **Note:** The cache is exposed as the `cache` property on the memoized
	 * function. Its creation may be customized by replacing the `_.memoize.Cache`
	 * constructor with one whose instances implement the
	 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
	 * method interface of `clear`, `delete`, `get`, `has`, and `set`.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Function
	 * @param {Function} func The function to have its output memoized.
	 * @param {Function} [resolver] The function to resolve the cache key.
	 * @returns {Function} Returns the new memoized function.
	 * @example
	 *
	 * var object = { 'a': 1, 'b': 2 };
	 * var other = { 'c': 3, 'd': 4 };
	 *
	 * var values = _.memoize(_.values);
	 * values(object);
	 * // => [1, 2]
	 *
	 * values(other);
	 * // => [3, 4]
	 *
	 * object.a = 2;
	 * values(object);
	 * // => [1, 2]
	 *
	 * // Modify the result cache.
	 * values.cache.set(object, ['a', 'b']);
	 * values(object);
	 * // => ['a', 'b']
	 *
	 * // Replace `_.memoize.Cache`.
	 * _.memoize.Cache = WeakMap;
	 */
	function memoize$1(func, resolver) {
	  if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
	    throw new TypeError(FUNC_ERROR_TEXT);
	  }
	  var memoized = function() {
	    var args = arguments,
	        key = resolver ? resolver.apply(this, args) : args[0],
	        cache = memoized.cache;

	    if (cache.has(key)) {
	      return cache.get(key);
	    }
	    var result = func.apply(this, args);
	    memoized.cache = cache.set(key, result) || cache;
	    return result;
	  };
	  memoized.cache = new (memoize$1.Cache || MapCache);
	  return memoized;
	}

	// Expose `MapCache`.
	memoize$1.Cache = MapCache;

	/** Used as the maximum memoize cache size. */
	var MAX_MEMOIZE_SIZE = 500;

	/**
	 * A specialized version of `_.memoize` which clears the memoized function's
	 * cache when it exceeds `MAX_MEMOIZE_SIZE`.
	 *
	 * @private
	 * @param {Function} func The function to have its output memoized.
	 * @returns {Function} Returns the new memoized function.
	 */
	function memoizeCapped(func) {
	  var result = memoize$1(func, function(key) {
	    if (cache.size === MAX_MEMOIZE_SIZE) {
	      cache.clear();
	    }
	    return key;
	  });

	  var cache = result.cache;
	  return result;
	}

	/** Used to match property names within property paths. */
	var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

	/** Used to match backslashes in property paths. */
	var reEscapeChar = /\\(\\)?/g;

	/**
	 * Converts `string` to a property path array.
	 *
	 * @private
	 * @param {string} string The string to convert.
	 * @returns {Array} Returns the property path array.
	 */
	var stringToPath = memoizeCapped(function(string) {
	  var result = [];
	  if (string.charCodeAt(0) === 46 /* . */) {
	    result.push('');
	  }
	  string.replace(rePropName, function(match, number, quote, subString) {
	    result.push(quote ? subString.replace(reEscapeChar, '$1') : (number || match));
	  });
	  return result;
	});

	var stringToPath$1 = stringToPath;

	/**
	 * A specialized version of `_.map` for arrays without support for iteratee
	 * shorthands.
	 *
	 * @private
	 * @param {Array} [array] The array to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Array} Returns the new mapped array.
	 */
	function arrayMap(array, iteratee) {
	  var index = -1,
	      length = array == null ? 0 : array.length,
	      result = Array(length);

	  while (++index < length) {
	    result[index] = iteratee(array[index], index, array);
	  }
	  return result;
	}

	/** Used as references for various `Number` constants. */
	var INFINITY$1 = 1 / 0;

	/** Used to convert symbols to primitives and strings. */
	var symbolProto = Symbol$2 ? Symbol$2.prototype : undefined,
	    symbolToString = symbolProto ? symbolProto.toString : undefined;

	/**
	 * The base implementation of `_.toString` which doesn't convert nullish
	 * values to empty strings.
	 *
	 * @private
	 * @param {*} value The value to process.
	 * @returns {string} Returns the string.
	 */
	function baseToString(value) {
	  // Exit early for strings to avoid a performance hit in some environments.
	  if (typeof value == 'string') {
	    return value;
	  }
	  if (isArray$1(value)) {
	    // Recursively convert values (susceptible to call stack limits).
	    return arrayMap(value, baseToString) + '';
	  }
	  if (isSymbol(value)) {
	    return symbolToString ? symbolToString.call(value) : '';
	  }
	  var result = (value + '');
	  return (result == '0' && (1 / value) == -INFINITY$1) ? '-0' : result;
	}

	/**
	 * Converts `value` to a string. An empty string is returned for `null`
	 * and `undefined` values. The sign of `-0` is preserved.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to convert.
	 * @returns {string} Returns the converted string.
	 * @example
	 *
	 * _.toString(null);
	 * // => ''
	 *
	 * _.toString(-0);
	 * // => '-0'
	 *
	 * _.toString([1, 2, 3]);
	 * // => '1,2,3'
	 */
	function toString(value) {
	  return value == null ? '' : baseToString(value);
	}

	/**
	 * Casts `value` to a path array if it's not one.
	 *
	 * @private
	 * @param {*} value The value to inspect.
	 * @param {Object} [object] The object to query keys on.
	 * @returns {Array} Returns the cast property path array.
	 */
	function castPath(value, object) {
	  if (isArray$1(value)) {
	    return value;
	  }
	  return isKey(value, object) ? [value] : stringToPath$1(toString(value));
	}

	/** Used as references for various `Number` constants. */
	var INFINITY = 1 / 0;

	/**
	 * Converts `value` to a string key if it's not a string or symbol.
	 *
	 * @private
	 * @param {*} value The value to inspect.
	 * @returns {string|symbol} Returns the key.
	 */
	function toKey(value) {
	  if (typeof value == 'string' || isSymbol(value)) {
	    return value;
	  }
	  var result = (value + '');
	  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
	}

	/**
	 * The base implementation of `_.get` without support for default values.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {Array|string} path The path of the property to get.
	 * @returns {*} Returns the resolved value.
	 */
	function baseGet(object, path) {
	  path = castPath(path, object);

	  var index = 0,
	      length = path.length;

	  while (object != null && index < length) {
	    object = object[toKey(path[index++])];
	  }
	  return (index && index == length) ? object : undefined;
	}

	/**
	 * Gets the value at `path` of `object`. If the resolved value is
	 * `undefined`, the `defaultValue` is returned in its place.
	 *
	 * @static
	 * @memberOf _
	 * @since 3.7.0
	 * @category Object
	 * @param {Object} object The object to query.
	 * @param {Array|string} path The path of the property to get.
	 * @param {*} [defaultValue] The value returned for `undefined` resolved values.
	 * @returns {*} Returns the resolved value.
	 * @example
	 *
	 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
	 *
	 * _.get(object, 'a[0].b.c');
	 * // => 3
	 *
	 * _.get(object, ['a', '0', 'b', 'c']);
	 * // => 3
	 *
	 * _.get(object, 'a.b.c', 'default');
	 * // => 'default'
	 */
	function get(object, path, defaultValue) {
	  var result = object == null ? undefined : baseGet(object, path);
	  return result === undefined ? defaultValue : result;
	}

	var get$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		'default': get
	});

	var require$$0 = /*@__PURE__*/getAugmentedNamespace(get$1);

	/**
	 * Creates a unary function that invokes `func` with its argument transformed.
	 *
	 * @private
	 * @param {Function} func The function to wrap.
	 * @param {Function} transform The argument transform.
	 * @returns {Function} Returns the new function.
	 */
	function overArg(func, transform) {
	  return function(arg) {
	    return func(transform(arg));
	  };
	}

	/** Built-in value references. */
	var getPrototype = overArg(Object.getPrototypeOf, Object);

	var getPrototype$1 = getPrototype;

	/** `Object#toString` result references. */
	var objectTag = '[object Object]';

	/** Used for built-in method references. */
	var funcProto = Function.prototype,
	    objectProto = Object.prototype;

	/** Used to resolve the decompiled source of functions. */
	var funcToString = funcProto.toString;

	/** Used to check objects for own properties. */
	var hasOwnProperty$1 = objectProto.hasOwnProperty;

	/** Used to infer the `Object` constructor. */
	var objectCtorString = funcToString.call(Object);

	/**
	 * Checks if `value` is a plain object, that is, an object created by the
	 * `Object` constructor or one with a `[[Prototype]]` of `null`.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.8.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
	 * @example
	 *
	 * function Foo() {
	 *   this.a = 1;
	 * }
	 *
	 * _.isPlainObject(new Foo);
	 * // => false
	 *
	 * _.isPlainObject([1, 2, 3]);
	 * // => false
	 *
	 * _.isPlainObject({ 'x': 0, 'y': 0 });
	 * // => true
	 *
	 * _.isPlainObject(Object.create(null));
	 * // => true
	 */
	function isPlainObject(value) {
	  if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
	    return false;
	  }
	  var proto = getPrototype$1(value);
	  if (proto === null) {
	    return true;
	  }
	  var Ctor = hasOwnProperty$1.call(proto, 'constructor') && proto.constructor;
	  return typeof Ctor == 'function' && Ctor instanceof Ctor &&
	    funcToString.call(Ctor) == objectCtorString;
	}

	var isPlainObject$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		'default': isPlainObject
	});

	var require$$1 = /*@__PURE__*/getAugmentedNamespace(isPlainObject$1);

	/**
	 * Gets the last element of `array`.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Array
	 * @param {Array} array The array to query.
	 * @returns {*} Returns the last element of `array`.
	 * @example
	 *
	 * _.last([1, 2, 3]);
	 * // => 3
	 */
	function last(array) {
	  var length = array == null ? 0 : array.length;
	  return length ? array[length - 1] : undefined;
	}

	var last$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		'default': last
	});

	var require$$2 = /*@__PURE__*/getAugmentedNamespace(last$1);

	(function (exports) {
	var __create = Object.create;
	var __defProp = Object.defineProperty;
	var __defProps = Object.defineProperties;
	var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
	var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
	var __getOwnPropNames = Object.getOwnPropertyNames;
	var __getOwnPropSymbols = Object.getOwnPropertySymbols;
	var __getProtoOf = Object.getPrototypeOf;
	var __hasOwnProp = Object.prototype.hasOwnProperty;
	var __propIsEnum = Object.prototype.propertyIsEnumerable;
	var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
	var __spreadValues = (a, b) => {
	  for (var prop in b || (b = {}))
	    if (__hasOwnProp.call(b, prop))
	      __defNormalProp(a, prop, b[prop]);
	  if (__getOwnPropSymbols)
	    for (var prop of __getOwnPropSymbols(b)) {
	      if (__propIsEnum.call(b, prop))
	        __defNormalProp(a, prop, b[prop]);
	    }
	  return a;
	};
	var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
	var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
	var __export = (target, all) => {
	  __markAsModule(target);
	  for (var name in all)
	    __defProp(target, name, { get: all[name], enumerable: true });
	};
	var __reExport = (target, module2, desc) => {
	  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
	    for (let key of __getOwnPropNames(module2))
	      if (!__hasOwnProp.call(target, key) && key !== "default")
	        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
	  }
	  return target;
	};
	var __toModule = (module2) => {
	  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
	};

	// src/index.ts
	__export(exports, {
	  AbstractDerivation: () => AbstractDerivation,
	  Atom: () => Atom,
	  Box: () => Box,
	  ConstantDerivation: () => ConstantDerivation,
	  DerivationFromSource: () => DerivationFromSource,
	  PointerProxy: () => PointerProxy,
	  Ticker: () => Ticker,
	  getPointerParts: () => getPointerParts,
	  isDerivation: () => isDerivation,
	  isPointer: () => isPointer,
	  iterateAndCountTicks: () => iterateAndCountTicks,
	  iterateOver: () => iterateOver,
	  pointer: () => pointer_default,
	  prism: () => prism_default,
	  val: () => val,
	  valueDerivation: () => valueDerivation
	});

	// src/Atom.ts
	var import_get = __toModule(require$$0);
	var import_isPlainObject = __toModule(require$$1);
	var import_last = __toModule(require$$2);

	// src/utils/Tappable.ts
	var Tappable = class {
	  constructor(props) {
	    this._untapFromSourceTimeout = null;
	    this._cb = (arg) => {
	      this._tappers.forEach((cb) => {
	        cb(arg);
	      });
	    };
	    this._lastTapperId = 0;
	    this._untapFromSource = null;
	    this._props = props;
	    this._tappers = new Map();
	  }
	  _check() {
	    if (this._untapFromSource) {
	      if (this._tappers.size === 0) {
	        this._scheduleToUntapFromSource();
	      }
	    } else {
	      if (this._tappers.size !== 0) {
	        this._untapFromSource = this._props.tapToSource(this._cb);
	      }
	    }
	  }
	  _scheduleToUntapFromSource() {
	    if (this._untapFromSourceTimeout !== null)
	      return;
	    this._untapFromSourceTimeout = setTimeout(() => {
	      this._untapFromSourceTimeout = null;
	      if (this._tappers.size === 0) {
	        this._untapFromSource();
	        this._untapFromSource = null;
	      }
	    }, 0);
	  }
	  tap(cb) {
	    const tapperId = this._lastTapperId++;
	    this._tappers.set(tapperId, cb);
	    this._check();
	    return () => {
	      this._removeTapperById(tapperId);
	    };
	  }
	  _removeTapperById(id) {
	    this._tappers.delete(id);
	    this._check();
	  }
	};

	// src/utils/Emitter.ts
	var Emitter = class {
	  constructor() {
	    this._lastTapperId = 0;
	    this._tappers = new Map();
	    this.tappable = new Tappable({
	      tapToSource: (cb) => {
	        return this._tap(cb);
	      }
	    });
	  }
	  _tap(cb) {
	    const tapperId = this._lastTapperId++;
	    this._tappers.set(tapperId, cb);
	    this._onNumberOfTappersChangeListener && this._onNumberOfTappersChangeListener(this._tappers.size);
	    return () => {
	      this._removeTapperById(tapperId);
	    };
	  }
	  _removeTapperById(id) {
	    const oldSize = this._tappers.size;
	    this._tappers.delete(id);
	    const newSize = this._tappers.size;
	    if (oldSize !== newSize) {
	      this._onNumberOfTappersChangeListener && this._onNumberOfTappersChangeListener(this._tappers.size);
	    }
	  }
	  emit(payload) {
	    this._tappers.forEach((cb) => {
	      cb(payload);
	    });
	  }
	  hasTappers() {
	    return this._tappers.size !== 0;
	  }
	  onNumberOfTappersChange(cb) {
	    this._onNumberOfTappersChangeListener = cb;
	  }
	};

	// src/derivations/DerivationEmitter.ts
	var DerivationEmitter = class {
	  constructor(derivation, ticker) {
	    this._possiblyMarkAsStale = () => {
	      this._ticker.onThisOrNextTick(this._refresh);
	    };
	    this._refresh = () => {
	      const newValue = this._derivation.getValue();
	      if (newValue === this._lastValue && this._lastValueRecorded === true)
	        return;
	      this._lastValue = newValue;
	      this._lastValueRecorded = true;
	      this._emitter.emit(newValue);
	    };
	    this._derivation = derivation;
	    this._ticker = ticker;
	    this._emitter = new Emitter();
	    this._emitter.onNumberOfTappersChange(() => {
	      this._reactToNumberOfTappersChange();
	    });
	    this._hadTappers = false;
	    this._lastValueRecorded = false;
	    this._lastValue = void 0;
	    return this;
	  }
	  _reactToNumberOfTappersChange() {
	    const hasTappers = this._emitter.hasTappers();
	    if (hasTappers !== this._hadTappers) {
	      this._hadTappers = hasTappers;
	      if (hasTappers) {
	        this._derivation.addDependent(this._possiblyMarkAsStale);
	      } else {
	        this._derivation.removeDependent(this._possiblyMarkAsStale);
	      }
	    }
	  }
	  tappable() {
	    return this._emitter.tappable;
	  }
	};

	// src/derivations/DerivationValuelessEmitter.ts
	var DerivationValuelessEmitter = class {
	  constructor(derivation, dontEmitValues = false) {
	    this.dontEmitValues = dontEmitValues;
	    this._possiblyMarkAsStale = () => {
	      this._emitter.emit(void 0);
	    };
	    this._derivation = derivation;
	    this._emitter = new Emitter();
	    this._emitter.onNumberOfTappersChange(() => {
	      this._reactToNumberOfTappersChange();
	    });
	    this._hadTappers = false;
	    return this;
	  }
	  _reactToNumberOfTappersChange() {
	    const hasTappers = this._emitter.hasTappers();
	    if (hasTappers !== this._hadTappers) {
	      this._hadTappers = hasTappers;
	      if (hasTappers) {
	        this._derivation.addDependent(this._possiblyMarkAsStale);
	      } else {
	        this._derivation.removeDependent(this._possiblyMarkAsStale);
	      }
	    }
	  }
	  tappable() {
	    return this._emitter.tappable;
	  }
	};

	// src/derivations/IDerivation.ts
	function isDerivation(d) {
	  return d && d.isDerivation && d.isDerivation === true;
	}

	// src/derivations/flatMap.ts
	var UPDATE_NEEDED_FROM;
	(function(UPDATE_NEEDED_FROM2) {
	  UPDATE_NEEDED_FROM2[UPDATE_NEEDED_FROM2["none"] = 0] = "none";
	  UPDATE_NEEDED_FROM2[UPDATE_NEEDED_FROM2["dep"] = 1] = "dep";
	  UPDATE_NEEDED_FROM2[UPDATE_NEEDED_FROM2["inner"] = 2] = "inner";
	})(UPDATE_NEEDED_FROM || (UPDATE_NEEDED_FROM = {}));
	var makeFlatMapDerivationClass = () => {
	  class FlatMapDerivation extends AbstractDerivation {
	    constructor(_depDerivation, _fn) {
	      super();
	      this._depDerivation = _depDerivation;
	      this._fn = _fn;
	      this._innerDerivation = void 0;
	      this._staleDependency = 1;
	      this._addDependency(_depDerivation);
	      return this;
	    }
	    _recalculateHot() {
	      const updateNeededFrom = this._staleDependency;
	      this._staleDependency = 0;
	      if (updateNeededFrom === 2) {
	        return this._innerDerivation.getValue();
	      }
	      const possibleInnerDerivation = this._fn(this._depDerivation.getValue());
	      if (isDerivation(possibleInnerDerivation)) {
	        this._innerDerivation = possibleInnerDerivation;
	        this._addDependency(possibleInnerDerivation);
	        return possibleInnerDerivation.getValue();
	      } else {
	        return possibleInnerDerivation;
	      }
	    }
	    _recalculateCold() {
	      const possibleInnerDerivation = this._fn(this._depDerivation.getValue());
	      if (isDerivation(possibleInnerDerivation)) {
	        return possibleInnerDerivation.getValue();
	      } else {
	        return possibleInnerDerivation;
	      }
	    }
	    _recalculate() {
	      return this.isHot ? this._recalculateHot() : this._recalculateCold();
	    }
	    _reactToDependencyBecomingStale(msgComingFrom) {
	      const updateNeededFrom = msgComingFrom === this._depDerivation ? 1 : 2;
	      if (updateNeededFrom === 2 && msgComingFrom !== this._innerDerivation) {
	        throw Error(`got a _reactToDependencyBecomingStale() from neither the dep nor the inner derivation`);
	      }
	      if (this._staleDependency === 0) {
	        this._staleDependency = updateNeededFrom;
	        if (updateNeededFrom === 1) {
	          this._removeInnerDerivation();
	        }
	      } else if (this._staleDependency === 1) ; else {
	        if (updateNeededFrom === 1) {
	          this._staleDependency = 1;
	          this._removeInnerDerivation();
	        }
	      }
	    }
	    _removeInnerDerivation() {
	      if (this._innerDerivation) {
	        this._removeDependency(this._innerDerivation);
	        this._innerDerivation = void 0;
	      }
	    }
	    _keepHot() {
	      this._staleDependency = 1;
	      this.getValue();
	    }
	    _becomeCold() {
	      this._staleDependency = 1;
	      this._removeInnerDerivation();
	    }
	  }
	  FlatMapDerivation.displayName = "flatMap";
	  return FlatMapDerivation;
	};
	var cls = void 0;
	function flatMap(dep, fn) {
	  if (!cls) {
	    cls = makeFlatMapDerivationClass();
	  }
	  return new cls(dep, fn);
	}

	// src/derivations/map.ts
	var makeMapDerivationClass = () => class MapDerivation extends AbstractDerivation {
	  constructor(_dep, _fn) {
	    super();
	    this._dep = _dep;
	    this._fn = _fn;
	    this._addDependency(_dep);
	  }
	  _recalculate() {
	    return this._fn(this._dep.getValue());
	  }
	  _reactToDependencyBecomingStale() {
	  }
	};
	var cls2 = void 0;
	function flatMap2(dep, fn) {
	  if (!cls2) {
	    cls2 = makeMapDerivationClass();
	  }
	  return new cls2(dep, fn);
	}

	// src/utils/Stack.ts
	var Stack = class {
	  constructor() {
	    this._head = void 0;
	  }
	  peek() {
	    return this._head && this._head.data;
	  }
	  pop() {
	    const head = this._head;
	    if (!head) {
	      return void 0;
	    }
	    this._head = head.next;
	    return head.data;
	  }
	  push(data) {
	    const node = { next: this._head, data };
	    this._head = node;
	  }
	};

	// src/derivations/prism/discoveryMechanism.ts
	function createMechanism() {
	  const noop2 = () => {
	  };
	  const stack = new Stack();
	  const noopCollector = noop2;
	  const pushCollector2 = (collector) => {
	    stack.push(collector);
	  };
	  const popCollector2 = (collector) => {
	    const existing = stack.peek();
	    if (existing !== collector) {
	      throw new Error(`Popped collector is not on top of the stack`);
	    }
	    stack.pop();
	  };
	  const startIgnoringDependencies2 = () => {
	    stack.push(noopCollector);
	  };
	  const stopIgnoringDependencies2 = () => {
	    if (stack.peek() !== noopCollector) ; else {
	      stack.pop();
	    }
	  };
	  const reportResolutionStart2 = (d) => {
	    const possibleCollector = stack.peek();
	    if (possibleCollector) {
	      possibleCollector(d);
	    }
	    stack.push(noopCollector);
	  };
	  const reportResolutionEnd2 = (_d) => {
	    stack.pop();
	  };
	  return {
	    type: "Dataverse_discoveryMechanism",
	    startIgnoringDependencies: startIgnoringDependencies2,
	    stopIgnoringDependencies: stopIgnoringDependencies2,
	    reportResolutionStart: reportResolutionStart2,
	    reportResolutionEnd: reportResolutionEnd2,
	    pushCollector: pushCollector2,
	    popCollector: popCollector2
	  };
	}
	function getSharedMechanism() {
	  const varName = "__dataverse_discoveryMechanism_sharedStack";
	  if (window) {
	    const existingMechanism = window[varName];
	    if (existingMechanism && typeof existingMechanism === "object" && existingMechanism.type === "Dataverse_discoveryMechanism") {
	      return existingMechanism;
	    } else {
	      const mechanism = createMechanism();
	      window[varName] = mechanism;
	      return mechanism;
	    }
	  } else {
	    return createMechanism();
	  }
	}
	var {
	  startIgnoringDependencies,
	  stopIgnoringDependencies,
	  reportResolutionEnd,
	  reportResolutionStart,
	  pushCollector,
	  popCollector
	} = getSharedMechanism();

	// src/derivations/AbstractDerivation.ts
	var AbstractDerivation = class {
	  constructor() {
	    this.isDerivation = true;
	    this._didMarkDependentsAsStale = false;
	    this._isHot = false;
	    this._isFresh = false;
	    this._lastValue = void 0;
	    this._dependents = new Set();
	    this._dependencies = new Set();
	    this._internal_markAsStale = (which) => {
	      this._reactToDependencyBecomingStale(which);
	      if (this._didMarkDependentsAsStale)
	        return;
	      this._didMarkDependentsAsStale = true;
	      this._isFresh = false;
	      this._dependents.forEach((dependent) => {
	        dependent(this);
	      });
	    };
	  }
	  get isHot() {
	    return this._isHot;
	  }
	  _addDependency(d) {
	    if (this._dependencies.has(d))
	      return;
	    this._dependencies.add(d);
	    if (this._isHot)
	      d.addDependent(this._internal_markAsStale);
	  }
	  _removeDependency(d) {
	    if (!this._dependencies.has(d))
	      return;
	    this._dependencies.delete(d);
	    if (this._isHot)
	      d.removeDependent(this._internal_markAsStale);
	  }
	  changes(ticker) {
	    return new DerivationEmitter(this, ticker).tappable();
	  }
	  changesWithoutValues() {
	    return new DerivationValuelessEmitter(this).tappable();
	  }
	  keepHot() {
	    return this.changesWithoutValues().tap(() => {
	    });
	  }
	  tapImmediate(ticker, fn) {
	    const untap = this.changes(ticker).tap(fn);
	    fn(this.getValue());
	    return untap;
	  }
	  addDependent(d) {
	    const hadDepsBefore = this._dependents.size > 0;
	    this._dependents.add(d);
	    const hasDepsNow = this._dependents.size > 0;
	    if (hadDepsBefore !== hasDepsNow) {
	      this._reactToNumberOfDependentsChange();
	    }
	  }
	  removeDependent(d) {
	    const hadDepsBefore = this._dependents.size > 0;
	    this._dependents.delete(d);
	    const hasDepsNow = this._dependents.size > 0;
	    if (hadDepsBefore !== hasDepsNow) {
	      this._reactToNumberOfDependentsChange();
	    }
	  }
	  _markAsStale(which) {
	    this._internal_markAsStale(which);
	  }
	  getValue() {
	    reportResolutionStart(this);
	    if (!this._isFresh) {
	      const newValue = this._recalculate();
	      this._lastValue = newValue;
	      if (this._isHot) {
	        this._isFresh = true;
	        this._didMarkDependentsAsStale = false;
	      }
	    }
	    reportResolutionEnd(this);
	    return this._lastValue;
	  }
	  _reactToNumberOfDependentsChange() {
	    const shouldBecomeHot = this._dependents.size > 0;
	    if (shouldBecomeHot === this._isHot)
	      return;
	    this._isHot = shouldBecomeHot;
	    this._didMarkDependentsAsStale = false;
	    this._isFresh = false;
	    if (shouldBecomeHot) {
	      this._dependencies.forEach((d) => {
	        d.addDependent(this._internal_markAsStale);
	      });
	      this._keepHot();
	    } else {
	      this._dependencies.forEach((d) => {
	        d.removeDependent(this._internal_markAsStale);
	      });
	      this._becomeCold();
	    }
	  }
	  _keepHot() {
	  }
	  _becomeCold() {
	  }
	  map(fn) {
	    return flatMap2(this, fn);
	  }
	  flatMap(fn) {
	    return flatMap(this, fn);
	  }
	};

	// src/derivations/DerivationFromSource.ts
	var noop = () => {
	};
	var DerivationFromSource = class extends AbstractDerivation {
	  constructor(_tapToSource, _getValueFromSource) {
	    super();
	    this._tapToSource = _tapToSource;
	    this._getValueFromSource = _getValueFromSource;
	    this._untapFromChanges = noop;
	    this._cachedValue = void 0;
	    this._hasCachedValue = false;
	  }
	  _recalculate() {
	    if (this.isHot) {
	      if (!this._hasCachedValue) {
	        this._cachedValue = this._getValueFromSource();
	        this._hasCachedValue = true;
	      }
	      return this._cachedValue;
	    } else {
	      return this._getValueFromSource();
	    }
	  }
	  _keepHot() {
	    this._hasCachedValue = false;
	    this._cachedValue = void 0;
	    this._untapFromChanges = this._tapToSource((newValue) => {
	      this._hasCachedValue = true;
	      this._cachedValue = newValue;
	      this._markAsStale(this);
	    });
	  }
	  _becomeCold() {
	    this._untapFromChanges();
	    this._untapFromChanges = noop;
	    this._hasCachedValue = false;
	    this._cachedValue = void 0;
	  }
	  _reactToDependencyBecomingStale() {
	  }
	};

	// src/pointer.ts
	var pointerMetaWeakMap = new WeakMap();
	var pointerMetaSymbol = Symbol("pointerMeta");
	var cachedSubPointersWeakMap = new WeakMap();
	var handler = {
	  get(obj, prop) {
	    if (prop === pointerMetaSymbol)
	      return pointerMetaWeakMap.get(obj);
	    let subs = cachedSubPointersWeakMap.get(obj);
	    if (!subs) {
	      subs = {};
	      cachedSubPointersWeakMap.set(obj, subs);
	    }
	    if (subs[prop])
	      return subs[prop];
	    const meta = pointerMetaWeakMap.get(obj);
	    const subPointer = pointer({ root: meta.root, path: [...meta.path, prop] });
	    subs[prop] = subPointer;
	    return subPointer;
	  }
	};
	var getPointerMeta = (p) => {
	  const meta = p[pointerMetaSymbol];
	  return meta;
	};
	var getPointerParts = (p) => {
	  const { root, path } = getPointerMeta(p);
	  return { root, path };
	};
	function pointer(args) {
	  var _a;
	  const meta = {
	    root: args.root,
	    path: (_a = args.path) != null ? _a : []
	  };
	  const hiddenObj = {};
	  pointerMetaWeakMap.set(hiddenObj, meta);
	  return new Proxy(hiddenObj, handler);
	}
	var pointer_default = pointer;
	var isPointer = (p) => {
	  return p && !!getPointerMeta(p);
	};

	// src/utils/updateDeep.ts
	function updateDeep(state2, path, reducer) {
	  if (path.length === 0)
	    return reducer(state2);
	  return hoop(state2, path, reducer);
	}
	var hoop = (s, path, reducer) => {
	  if (path.length === 0) {
	    return reducer(s);
	  }
	  if (Array.isArray(s)) {
	    let [index, ...restOfPath] = path;
	    index = parseInt(String(index), 10);
	    if (isNaN(index))
	      index = 0;
	    const oldVal = s[index];
	    const newVal = hoop(oldVal, restOfPath, reducer);
	    if (oldVal === newVal)
	      return s;
	    const newS = [...s];
	    newS.splice(index, 1, newVal);
	    return newS;
	  } else if (typeof s === "object" && s !== null) {
	    const [key, ...restOfPath] = path;
	    const oldVal = s[key];
	    const newVal = hoop(oldVal, restOfPath, reducer);
	    if (oldVal === newVal)
	      return s;
	    const newS = __spreadProps(__spreadValues({}, s), { [key]: newVal });
	    return newS;
	  } else {
	    const [key, ...restOfPath] = path;
	    return { [key]: hoop(void 0, restOfPath, reducer) };
	  }
	};

	// src/Atom.ts
	var ValueTypes;
	(function(ValueTypes2) {
	  ValueTypes2[ValueTypes2["Dict"] = 0] = "Dict";
	  ValueTypes2[ValueTypes2["Array"] = 1] = "Array";
	  ValueTypes2[ValueTypes2["Other"] = 2] = "Other";
	})(ValueTypes || (ValueTypes = {}));
	var getTypeOfValue = (v) => {
	  if (Array.isArray(v))
	    return 1;
	  if ((0, import_isPlainObject.default)(v))
	    return 0;
	  return 2;
	};
	var getKeyOfValue = (v, key, vType = getTypeOfValue(v)) => {
	  if (vType === 0 && typeof key === "string") {
	    return v[key];
	  } else if (vType === 1 && isValidArrayIndex(key)) {
	    return v[key];
	  } else {
	    return void 0;
	  }
	};
	var isValidArrayIndex = (key) => {
	  const inNumber = typeof key === "number" ? key : parseInt(key, 10);
	  return !isNaN(inNumber) && inNumber >= 0 && inNumber < Infinity && (inNumber | 0) === inNumber;
	};
	var Scope = class {
	  constructor(_parent, _path) {
	    this._parent = _parent;
	    this._path = _path;
	    this.children = new Map();
	    this.identityChangeListeners = new Set();
	  }
	  addIdentityChangeListener(cb) {
	    this.identityChangeListeners.add(cb);
	  }
	  removeIdentityChangeListener(cb) {
	    this.identityChangeListeners.delete(cb);
	    this._checkForGC();
	  }
	  removeChild(key) {
	    this.children.delete(key);
	    this._checkForGC();
	  }
	  getChild(key) {
	    return this.children.get(key);
	  }
	  getOrCreateChild(key) {
	    let child = this.children.get(key);
	    if (!child) {
	      child = child = new Scope(this, this._path.concat([key]));
	      this.children.set(key, child);
	    }
	    return child;
	  }
	  _checkForGC() {
	    if (this.identityChangeListeners.size > 0)
	      return;
	    if (this.children.size > 0)
	      return;
	    if (this._parent) {
	      this._parent.removeChild((0, import_last.default)(this._path));
	    }
	  }
	};
	var Atom = class {
	  constructor(initialState) {
	    this.$$isIdentityDerivationProvider = true;
	    this.reduceState = (path, reducer) => {
	      const newState = updateDeep(this.getState(), path, reducer);
	      this.setState(newState);
	      return newState;
	    };
	    this._onPathValueChange = (path, cb) => {
	      const scope2 = this._getOrCreateScopeForPath(path);
	      scope2.identityChangeListeners.add(cb);
	      const untap = () => {
	        scope2.identityChangeListeners.delete(cb);
	      };
	      return untap;
	    };
	    this._currentState = initialState;
	    this._rootScope = new Scope(void 0, []);
	    this.pointer = pointer_default({ root: this, path: [] });
	  }
	  setState(newState) {
	    const oldState = this._currentState;
	    this._currentState = newState;
	    this._checkUpdates(this._rootScope, oldState, newState);
	  }
	  getState() {
	    return this._currentState;
	  }
	  getIn(path) {
	    return path.length === 0 ? this.getState() : (0, import_get.default)(this.getState(), path);
	  }
	  setIn(path, val2) {
	    return this.reduceState(path, () => val2);
	  }
	  _checkUpdates(scope2, oldState, newState) {
	    if (oldState === newState)
	      return;
	    scope2.identityChangeListeners.forEach((cb) => cb(newState));
	    if (scope2.children.size === 0)
	      return;
	    const oldValueType = getTypeOfValue(oldState);
	    const newValueType = getTypeOfValue(newState);
	    if (oldValueType === 2 && oldValueType === newValueType)
	      return;
	    scope2.children.forEach((childScope, childKey) => {
	      const oldChildVal = getKeyOfValue(oldState, childKey, oldValueType);
	      const newChildVal = getKeyOfValue(newState, childKey, newValueType);
	      this._checkUpdates(childScope, oldChildVal, newChildVal);
	    });
	  }
	  _getOrCreateScopeForPath(path) {
	    let curScope = this._rootScope;
	    for (const pathEl of path) {
	      curScope = curScope.getOrCreateChild(pathEl);
	    }
	    return curScope;
	  }
	  getIdentityDerivation(path) {
	    return new DerivationFromSource((listener) => this._onPathValueChange(path, listener), () => this.getIn(path));
	  }
	};
	var identityDerivationWeakMap = new WeakMap();
	var valueDerivation = (pointer2) => {
	  const meta = getPointerMeta(pointer2);
	  let derivation = identityDerivationWeakMap.get(meta);
	  if (!derivation) {
	    const root = meta.root;
	    if (!isIdentityChangeProvider(root)) {
	      throw new Error(`Cannot run valueDerivation() on a pointer whose root is not an IdentityChangeProvider`);
	    }
	    const { path } = meta;
	    derivation = root.getIdentityDerivation(path);
	    identityDerivationWeakMap.set(meta, derivation);
	  }
	  return derivation;
	};
	function isIdentityChangeProvider(val2) {
	  return typeof val2 === "object" && val2 !== null && val2["$$isIdentityDerivationProvider"] === true;
	}
	var val = (pointerOrDerivationOrPlainValue) => {
	  if (isPointer(pointerOrDerivationOrPlainValue)) {
	    return valueDerivation(pointerOrDerivationOrPlainValue).getValue();
	  } else if (isDerivation(pointerOrDerivationOrPlainValue)) {
	    return pointerOrDerivationOrPlainValue.getValue();
	  } else {
	    return pointerOrDerivationOrPlainValue;
	  }
	};

	// src/Box.ts
	var Box = class {
	  constructor(_value) {
	    this._value = _value;
	    this._emitter = new Emitter();
	    this._publicDerivation = new DerivationFromSource((listener) => this._emitter.tappable.tap(listener), this.get.bind(this));
	  }
	  set(v) {
	    if (v === this._value)
	      return;
	    this._value = v;
	    this._emitter.emit(v);
	  }
	  get() {
	    return this._value;
	  }
	  get derivation() {
	    return this._publicDerivation;
	  }
	};

	// src/derivations/ConstantDerivation.ts
	var ConstantDerivation = class extends AbstractDerivation {
	  constructor(v) {
	    super();
	    this._v = v;
	    return this;
	  }
	  _recalculate() {
	    return this._v;
	  }
	  _reactToDependencyBecomingStale() {
	  }
	};

	// src/derivations/iterateAndCountTicks.ts
	function* iterateAndCountTicks(pointerOrDerivation) {
	  let d;
	  if (isPointer(pointerOrDerivation)) {
	    d = valueDerivation(pointerOrDerivation);
	  } else if (isDerivation(pointerOrDerivation)) {
	    d = pointerOrDerivation;
	  } else {
	    throw new Error(`Only pointers and derivations are supported`);
	  }
	  let ticksCountedSinceLastYield = 0;
	  const untap = d.changesWithoutValues().tap(() => {
	    ticksCountedSinceLastYield++;
	  });
	  try {
	    while (true) {
	      const ticks = ticksCountedSinceLastYield;
	      ticksCountedSinceLastYield = 0;
	      yield { value: d.getValue(), ticks };
	    }
	  } finally {
	    untap();
	  }
	}

	// src/Ticker.ts
	var Ticker = class {
	  constructor() {
	    this._ticking = false;
	    this._scheduledForThisOrNextTick = new Set();
	    this._scheduledForNextTick = new Set();
	    this._timeAtCurrentTick = 0;
	  }
	  onThisOrNextTick(fn) {
	    this._scheduledForThisOrNextTick.add(fn);
	  }
	  onNextTick(fn) {
	    this._scheduledForNextTick.add(fn);
	  }
	  offThisOrNextTick(fn) {
	    this._scheduledForThisOrNextTick.delete(fn);
	  }
	  offNextTick(fn) {
	    this._scheduledForNextTick.delete(fn);
	  }
	  get time() {
	    if (this._ticking) {
	      return this._timeAtCurrentTick;
	    } else
	      return performance.now();
	  }
	  tick(t = performance.now()) {
	    this._ticking = true;
	    this._timeAtCurrentTick = t;
	    this._scheduledForNextTick.forEach((v) => this._scheduledForThisOrNextTick.add(v));
	    this._scheduledForNextTick.clear();
	    this._tick(0);
	    this._ticking = false;
	  }
	  _tick(iterationNumber) {
	    const time = this.time;
	    if (iterationNumber > 10) {
	      console.warn("_tick() recursing for 10 times");
	    }
	    if (iterationNumber > 100) {
	      throw new Error(`Maximum recursion limit for _tick()`);
	    }
	    const oldSet = this._scheduledForThisOrNextTick;
	    this._scheduledForThisOrNextTick = new Set();
	    oldSet.forEach((fn) => {
	      fn(time);
	    });
	    if (this._scheduledForThisOrNextTick.size > 0) {
	      return this._tick(iterationNumber + 1);
	    }
	  }
	};

	// src/derivations/iterateOver.ts
	function* iterateOver(pointerOrDerivation) {
	  let d;
	  if (isPointer(pointerOrDerivation)) {
	    d = valueDerivation(pointerOrDerivation);
	  } else if (isDerivation(pointerOrDerivation)) {
	    d = pointerOrDerivation;
	  } else {
	    throw new Error(`Only pointers and derivations are supported`);
	  }
	  const ticker = new Ticker();
	  const untap = d.changes(ticker).tap((v) => {
	  });
	  try {
	    while (true) {
	      ticker.tick();
	      yield d.getValue();
	    }
	  } finally {
	    untap();
	  }
	}

	// src/derivations/prism/prism.ts
	var voidFn = () => {
	};
	var PrismDerivation = class extends AbstractDerivation {
	  constructor(_fn) {
	    super();
	    this._fn = _fn;
	    this._cacheOfDendencyValues = new Map();
	    this._possiblyStaleDeps = new Set();
	    this._prismScope = new PrismScope();
	  }
	  _recalculate() {
	    let value;
	    if (this._possiblyStaleDeps.size > 0) {
	      let anActuallyStaleDepWasFound = false;
	      startIgnoringDependencies();
	      for (const dep of this._possiblyStaleDeps) {
	        if (this._cacheOfDendencyValues.get(dep) !== dep.getValue()) {
	          anActuallyStaleDepWasFound = true;
	          break;
	        }
	      }
	      stopIgnoringDependencies();
	      this._possiblyStaleDeps.clear();
	      if (!anActuallyStaleDepWasFound) {
	        return this._lastValue;
	      }
	    }
	    const newDeps = new Set();
	    this._cacheOfDendencyValues.clear();
	    const collector = (observedDep) => {
	      newDeps.add(observedDep);
	      this._addDependency(observedDep);
	    };
	    pushCollector(collector);
	    hookScopeStack.push(this._prismScope);
	    try {
	      value = this._fn();
	    } catch (error) {
	      console.error(error);
	    } finally {
	      const topOfTheStack = hookScopeStack.pop();
	      if (topOfTheStack !== this._prismScope) {
	        console.warn(`The Prism hook stack has slipped. This is a bug.`);
	      }
	    }
	    popCollector(collector);
	    this._dependencies.forEach((dep) => {
	      if (!newDeps.has(dep)) {
	        this._removeDependency(dep);
	      }
	    });
	    this._dependencies = newDeps;
	    startIgnoringDependencies();
	    newDeps.forEach((dep) => {
	      this._cacheOfDendencyValues.set(dep, dep.getValue());
	    });
	    stopIgnoringDependencies();
	    return value;
	  }
	  _reactToDependencyBecomingStale(msgComingFrom) {
	    this._possiblyStaleDeps.add(msgComingFrom);
	  }
	  _keepHot() {
	    this._prismScope = new PrismScope();
	    startIgnoringDependencies();
	    this.getValue();
	    stopIgnoringDependencies();
	  }
	  _becomeCold() {
	    cleanupScopeStack(this._prismScope);
	    this._prismScope = new PrismScope();
	  }
	};
	var PrismScope = class {
	  constructor() {
	    this.isPrismScope = true;
	    this._subs = {};
	  }
	  sub(key) {
	    if (!this._subs[key]) {
	      this._subs[key] = new PrismScope();
	    }
	    return this._subs[key];
	  }
	  get subs() {
	    return this._subs;
	  }
	};
	function cleanupScopeStack(scope2) {
	  for (const [_, sub2] of Object.entries(scope2.subs)) {
	    cleanupScopeStack(sub2);
	  }
	  cleanupEffects(scope2);
	}
	function cleanupEffects(scope2) {
	  const effects = effectsWeakMap.get(scope2);
	  if (effects) {
	    for (const k of Object.keys(effects)) {
	      const effect2 = effects[k];
	      safelyRun(effect2.cleanup, void 0);
	    }
	  }
	  effectsWeakMap.delete(scope2);
	}
	function safelyRun(fn, returnValueInCaseOfError) {
	  let returnValue = returnValueInCaseOfError;
	  let success = false;
	  try {
	    returnValue = fn();
	    success = true;
	  } catch (error) {
	    setTimeout(() => {
	      throw error;
	    });
	  }
	  return { success, returnValue };
	}
	var hookScopeStack = new Stack();
	var refsWeakMap = new WeakMap();
	var effectsWeakMap = new WeakMap();
	var memosWeakMap = new WeakMap();
	function ref(key, initialValue) {
	  const scope2 = hookScopeStack.peek();
	  if (!scope2) {
	    throw new Error(`prism.ref() is called outside of a prism() call.`);
	  }
	  let refs = refsWeakMap.get(scope2);
	  if (!refs) {
	    refs = {};
	    refsWeakMap.set(scope2, refs);
	  }
	  if (refs[key]) {
	    return refs[key];
	  } else {
	    const ref2 = {
	      current: initialValue
	    };
	    refs[key] = ref2;
	    return ref2;
	  }
	}
	function effect(key, cb, deps) {
	  const scope2 = hookScopeStack.peek();
	  if (!scope2) {
	    throw new Error(`prism.effect() is called outside of a prism() call.`);
	  }
	  let effects = effectsWeakMap.get(scope2);
	  if (!effects) {
	    effects = {};
	    effectsWeakMap.set(scope2, effects);
	  }
	  if (!effects[key]) {
	    effects[key] = {
	      cleanup: voidFn,
	      deps: [{}]
	    };
	  }
	  const effect2 = effects[key];
	  if (depsHaveChanged(effect2.deps, deps)) {
	    effect2.cleanup();
	    startIgnoringDependencies();
	    effect2.cleanup = safelyRun(cb, voidFn).returnValue;
	    stopIgnoringDependencies();
	    effect2.deps = deps;
	  }
	}
	function depsHaveChanged(oldDeps, newDeps) {
	  if (oldDeps === void 0 || newDeps === void 0) {
	    return true;
	  } else if (oldDeps.length !== newDeps.length) {
	    return true;
	  } else {
	    return oldDeps.some((el, i) => el !== newDeps[i]);
	  }
	}
	function memo(key, fn, deps) {
	  const scope2 = hookScopeStack.peek();
	  if (!scope2) {
	    throw new Error(`prism.memo() is called outside of a prism() call.`);
	  }
	  let memos = memosWeakMap.get(scope2);
	  if (!memos) {
	    memos = {};
	    memosWeakMap.set(scope2, memos);
	  }
	  if (!memos[key]) {
	    memos[key] = {
	      cachedValue: null,
	      deps: [{}]
	    };
	  }
	  const memo2 = memos[key];
	  if (depsHaveChanged(memo2.deps, deps)) {
	    startIgnoringDependencies();
	    memo2.cachedValue = safelyRun(fn, void 0).returnValue;
	    stopIgnoringDependencies();
	    memo2.deps = deps;
	  }
	  return memo2.cachedValue;
	}
	function state(key, initialValue) {
	  const { b, setValue } = prism.memo("state/" + key, () => {
	    const b2 = new Box(initialValue);
	    const setValue2 = (val2) => b2.set(val2);
	    return { b: b2, setValue: setValue2 };
	  }, []);
	  return [b.derivation.getValue(), setValue];
	}
	function ensurePrism() {
	  const scope2 = hookScopeStack.peek();
	  if (!scope2) {
	    throw new Error(`The parent function is called outside of a prism() call.`);
	  }
	}
	function scope(key, fn) {
	  const parentScope = hookScopeStack.peek();
	  if (!parentScope) {
	    throw new Error(`prism.scope() is called outside of a prism() call.`);
	  }
	  const subScope = parentScope.sub(key);
	  hookScopeStack.push(subScope);
	  const ret = safelyRun(fn, void 0).returnValue;
	  hookScopeStack.pop();
	  return ret;
	}
	function sub(key, fn, deps) {
	  return memo(key, () => prism(fn), deps).getValue();
	}
	function inPrism() {
	  return !!hookScopeStack.peek();
	}
	var prism = (fn) => {
	  return new PrismDerivation(fn);
	};
	prism.ref = ref;
	prism.effect = effect;
	prism.memo = memo;
	prism.ensurePrism = ensurePrism;
	prism.state = state;
	prism.scope = scope;
	prism.sub = sub;
	prism.inPrism = inPrism;
	var prism_default = prism;

	// src/PointerProxy.ts
	var PointerProxy = class {
	  constructor(currentPointer) {
	    this.$$isIdentityDerivationProvider = true;
	    this._currentPointerBox = new Box(currentPointer);
	    this.pointer = pointer_default({ root: this, path: [] });
	  }
	  setPointer(p) {
	    this._currentPointerBox.set(p);
	  }
	  getIdentityDerivation(path) {
	    return this._currentPointerBox.derivation.flatMap((p) => {
	      const subPointer = path.reduce((pointerSoFar, pathItem) => pointerSoFar[pathItem], p);
	      return valueDerivation(subPointer);
	    });
	  }
	};

	}(dist$1));

	(function (exports) {
	var __create = Object.create;
	var __defProp = Object.defineProperty;
	var __defProps = Object.defineProperties;
	var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
	var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
	var __getOwnPropNames = Object.getOwnPropertyNames;
	var __getOwnPropSymbols = Object.getOwnPropertySymbols;
	var __getProtoOf = Object.getPrototypeOf;
	var __hasOwnProp = Object.prototype.hasOwnProperty;
	var __propIsEnum = Object.prototype.propertyIsEnumerable;
	var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
	var __spreadValues = (a2, b2) => {
	  for (var prop in b2 || (b2 = {}))
	    if (__hasOwnProp.call(b2, prop))
	      __defNormalProp(a2, prop, b2[prop]);
	  if (__getOwnPropSymbols)
	    for (var prop of __getOwnPropSymbols(b2)) {
	      if (__propIsEnum.call(b2, prop))
	        __defNormalProp(a2, prop, b2[prop]);
	    }
	  return a2;
	};
	var __spreadProps = (a2, b2) => __defProps(a2, __getOwnPropDescs(b2));
	var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
	var __objRest = (source, exclude) => {
	  var target = {};
	  for (var prop in source)
	    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
	      target[prop] = source[prop];
	  if (source != null && __getOwnPropSymbols)
	    for (var prop of __getOwnPropSymbols(source)) {
	      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
	        target[prop] = source[prop];
	    }
	  return target;
	};
	var __commonJS = (cb, mod) => function __require() {
	  return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
	};
	var __export = (target, all) => {
	  __markAsModule(target);
	  for (var name in all)
	    __defProp(target, name, { get: all[name], enumerable: true });
	};
	var __reExport = (target, module2, desc) => {
	  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
	    for (let key of __getOwnPropNames(module2))
	      if (!__hasOwnProp.call(target, key) && key !== "default")
	        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
	  }
	  return target;
	};
	var __toModule = (module2) => {
	  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
	};
	var __publicField = (obj, key, value) => {
	  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
	  return value;
	};

	// ../node_modules/timing-function/lib/UnitBezier.js
	var require_UnitBezier = __commonJS({
	  "../node_modules/timing-function/lib/UnitBezier.js"(exports, module2) {
	    module2.exports = function() {
	      function UnitBezier3(p1x, p1y, p2x, p2y) {
	        this.set(p1x, p1y, p2x, p2y);
	      }
	      UnitBezier3.prototype.set = function(p1x, p1y, p2x, p2y) {
	        this._cx = 3 * p1x;
	        this._bx = 3 * (p2x - p1x) - this._cx;
	        this._ax = 1 - this._cx - this._bx;
	        this._cy = 3 * p1y;
	        this._by = 3 * (p2y - p1y) - this._cy;
	        this._ay = 1 - this._cy - this._by;
	      };
	      UnitBezier3.epsilon = 1e-6;
	      UnitBezier3.prototype._sampleCurveX = function(t3) {
	        return ((this._ax * t3 + this._bx) * t3 + this._cx) * t3;
	      };
	      UnitBezier3.prototype._sampleCurveY = function(t3) {
	        return ((this._ay * t3 + this._by) * t3 + this._cy) * t3;
	      };
	      UnitBezier3.prototype._sampleCurveDerivativeX = function(t3) {
	        return (3 * this._ax * t3 + 2 * this._bx) * t3 + this._cx;
	      };
	      UnitBezier3.prototype._solveCurveX = function(x2, epsilon) {
	        var d2, i2, t0, t1, t22, x22;
	        t0 = void 0;
	        t1 = void 0;
	        t22 = void 0;
	        x22 = void 0;
	        d2 = void 0;
	        i2 = void 0;
	        t22 = x2;
	        i2 = 0;
	        while (i2 < 8) {
	          x22 = this._sampleCurveX(t22) - x2;
	          if (Math.abs(x22) < epsilon) {
	            return t22;
	          }
	          d2 = this._sampleCurveDerivativeX(t22);
	          if (Math.abs(d2) < epsilon) {
	            break;
	          }
	          t22 = t22 - x22 / d2;
	          i2++;
	        }
	        t0 = 0;
	        t1 = 1;
	        t22 = x2;
	        if (t22 < t0) {
	          return t0;
	        }
	        if (t22 > t1) {
	          return t1;
	        }
	        while (t0 < t1) {
	          x22 = this._sampleCurveX(t22);
	          if (Math.abs(x22 - x2) < epsilon) {
	            return t22;
	          }
	          if (x2 > x22) {
	            t0 = t22;
	          } else {
	            t1 = t22;
	          }
	          t22 = (t1 - t0) * 0.5 + t0;
	        }
	        return t22;
	      };
	      UnitBezier3.prototype.solve = function(x2, epsilon) {
	        return this._sampleCurveY(this._solveCurveX(x2, epsilon));
	      };
	      UnitBezier3.prototype.solveSimple = function(x2) {
	        return this._sampleCurveY(this._solveCurveX(x2, 1e-6));
	      };
	      return UnitBezier3;
	    }();
	  }
	});

	// ../node_modules/levenshtein-edit-distance/index.js
	var require_levenshtein_edit_distance = __commonJS({
	  "../node_modules/levenshtein-edit-distance/index.js"(exports, module2) {
	    var cache;
	    var codes;
	    cache = [];
	    codes = [];
	    function levenshtein(value, other, insensitive) {
	      var length, lengthOther, code, result, distance, distanceOther, index, indexOther;
	      if (value === other) {
	        return 0;
	      }
	      length = value.length;
	      lengthOther = other.length;
	      if (length === 0) {
	        return lengthOther;
	      }
	      if (lengthOther === 0) {
	        return length;
	      }
	      if (insensitive) {
	        value = value.toLowerCase();
	        other = other.toLowerCase();
	      }
	      index = 0;
	      while (index < length) {
	        codes[index] = value.charCodeAt(index);
	        cache[index] = ++index;
	      }
	      indexOther = 0;
	      while (indexOther < lengthOther) {
	        code = other.charCodeAt(indexOther);
	        result = distance = indexOther++;
	        index = -1;
	        while (++index < length) {
	          distanceOther = code === codes[index] ? distance : distance + 1;
	          distance = cache[index];
	          cache[index] = result = distance > result ? distanceOther > result ? result + 1 : distanceOther : distanceOther > distance ? distance + 1 : distanceOther;
	        }
	      }
	      return result;
	    }
	    module2.exports = levenshtein;
	  }
	});

	// ../node_modules/propose/propose.js
	var require_propose = __commonJS({
	  "../node_modules/propose/propose.js"(exports, module2) {
	    var levenshtein = require_levenshtein_edit_distance();
	    function propose2() {
	      var ratio;
	      var distance;
	      var proposed;
	      var threshold;
	      var ignoreCase;
	      var max_ratio = 0;
	      var word = arguments[0];
	      var dictionary = arguments[1];
	      var len = dictionary.length;
	      var options = arguments[2];
	      if (options) {
	        threshold = options.threshold;
	        ignoreCase = options.ignoreCase;
	      }
	      if (threshold === void 0)
	        threshold = 0;
	      for (var i2 = 0; i2 < len; ++i2) {
	        if (ignoreCase)
	          distance = levenshtein(word, dictionary[i2], true);
	        else
	          distance = levenshtein(word, dictionary[i2]);
	        if (distance > word.length)
	          ratio = 1 - distance / dictionary[i2].length;
	        else
	          ratio = 1 - distance / word.length;
	        if (ratio > max_ratio) {
	          max_ratio = ratio;
	          proposed = dictionary[i2];
	        }
	      }
	      if (max_ratio >= threshold)
	        return proposed;
	      return null;
	    }
	    module2.exports = propose2;
	  }
	});

	// ../node_modules/fast-deep-equal/index.js
	var require_fast_deep_equal = __commonJS({
	  "../node_modules/fast-deep-equal/index.js"(exports, module2) {
	    module2.exports = function equal(a2, b2) {
	      if (a2 === b2)
	        return true;
	      if (a2 && b2 && typeof a2 == "object" && typeof b2 == "object") {
	        if (a2.constructor !== b2.constructor)
	          return false;
	        var length, i2, keys;
	        if (Array.isArray(a2)) {
	          length = a2.length;
	          if (length != b2.length)
	            return false;
	          for (i2 = length; i2-- !== 0; )
	            if (!equal(a2[i2], b2[i2]))
	              return false;
	          return true;
	        }
	        if (a2.constructor === RegExp)
	          return a2.source === b2.source && a2.flags === b2.flags;
	        if (a2.valueOf !== Object.prototype.valueOf)
	          return a2.valueOf() === b2.valueOf();
	        if (a2.toString !== Object.prototype.toString)
	          return a2.toString() === b2.toString();
	        keys = Object.keys(a2);
	        length = keys.length;
	        if (length !== Object.keys(b2).length)
	          return false;
	        for (i2 = length; i2-- !== 0; )
	          if (!Object.prototype.hasOwnProperty.call(b2, keys[i2]))
	            return false;
	        for (i2 = length; i2-- !== 0; ) {
	          var key = keys[i2];
	          if (!equal(a2[key], b2[key]))
	            return false;
	        }
	        return true;
	      }
	      return a2 !== a2 && b2 !== b2;
	    };
	  }
	});

	// core/src/index.ts
	__export(exports, {
	  getProject: () => getProject,
	  onChange: () => onChange,
	  types: () => propTypes_exports,
	  val: () => val6
	});

	// core/src/coreExports.ts
	var coreExports_exports = {};
	__export(coreExports_exports, {
	  getProject: () => getProject,
	  onChange: () => onChange,
	  types: () => propTypes_exports,
	  val: () => val6
	});

	// core/src/projects/projectsSingleton.ts
	var import_dataverse = __toModule(dist$1);
	var ProjectsSingleton = class {
	  constructor() {
	    __publicField(this, "atom", new import_dataverse.Atom({ projects: {} }));
	  }
	  add(id, project) {
	    this.atom.reduceState(["projects", id], () => project);
	  }
	  get(id) {
	    return this.atom.getState().projects[id];
	  }
	  has(id) {
	    return !!this.get(id);
	  }
	};
	var singleton = new ProjectsSingleton();
	var projectsSingleton_default = singleton;

	// core/src/privateAPIs.ts
	var publicAPIToPrivateAPIMap = new WeakMap();
	function privateAPI(pub) {
	  return publicAPIToPrivateAPIMap.get(pub);
	}
	function setPrivateAPI(pub, priv) {
	  publicAPIToPrivateAPIMap.set(pub, priv);
	}

	// shared/src/utils/index.ts
	var emptyArray = [];

	// ../node_modules/lodash-es/isArray.js
	var isArray = Array.isArray;
	var isArray_default = isArray;

	// ../node_modules/lodash-es/_freeGlobal.js
	var freeGlobal = typeof window == "object" && window && window.Object === Object && window;
	var freeGlobal_default = freeGlobal;

	// ../node_modules/lodash-es/_root.js
	var freeSelf = typeof self == "object" && self && self.Object === Object && self;
	var root = freeGlobal_default || freeSelf || Function("return this")();
	var root_default = root;

	// ../node_modules/lodash-es/_Symbol.js
	var Symbol2 = root_default.Symbol;
	var Symbol_default = Symbol2;

	// ../node_modules/lodash-es/_getRawTag.js
	var objectProto = Object.prototype;
	var hasOwnProperty = objectProto.hasOwnProperty;
	var nativeObjectToString = objectProto.toString;
	var symToStringTag = Symbol_default ? Symbol_default.toStringTag : void 0;
	function getRawTag(value) {
	  var isOwn = hasOwnProperty.call(value, symToStringTag), tag = value[symToStringTag];
	  try {
	    value[symToStringTag] = void 0;
	    var unmasked = true;
	  } catch (e2) {
	  }
	  var result = nativeObjectToString.call(value);
	  if (unmasked) {
	    if (isOwn) {
	      value[symToStringTag] = tag;
	    } else {
	      delete value[symToStringTag];
	    }
	  }
	  return result;
	}
	var getRawTag_default = getRawTag;

	// ../node_modules/lodash-es/_objectToString.js
	var objectProto2 = Object.prototype;
	var nativeObjectToString2 = objectProto2.toString;
	function objectToString(value) {
	  return nativeObjectToString2.call(value);
	}
	var objectToString_default = objectToString;

	// ../node_modules/lodash-es/_baseGetTag.js
	var nullTag = "[object Null]";
	var undefinedTag = "[object Undefined]";
	var symToStringTag2 = Symbol_default ? Symbol_default.toStringTag : void 0;
	function baseGetTag(value) {
	  if (value == null) {
	    return value === void 0 ? undefinedTag : nullTag;
	  }
	  return symToStringTag2 && symToStringTag2 in Object(value) ? getRawTag_default(value) : objectToString_default(value);
	}
	var baseGetTag_default = baseGetTag;

	// ../node_modules/lodash-es/isObjectLike.js
	function isObjectLike(value) {
	  return value != null && typeof value == "object";
	}
	var isObjectLike_default = isObjectLike;

	// ../node_modules/lodash-es/isSymbol.js
	var symbolTag = "[object Symbol]";
	function isSymbol(value) {
	  return typeof value == "symbol" || isObjectLike_default(value) && baseGetTag_default(value) == symbolTag;
	}
	var isSymbol_default = isSymbol;

	// ../node_modules/lodash-es/_isKey.js
	var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/;
	var reIsPlainProp = /^\w*$/;
	function isKey(value, object) {
	  if (isArray_default(value)) {
	    return false;
	  }
	  var type = typeof value;
	  if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol_default(value)) {
	    return true;
	  }
	  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object(object);
	}
	var isKey_default = isKey;

	// ../node_modules/lodash-es/isObject.js
	function isObject(value) {
	  var type = typeof value;
	  return value != null && (type == "object" || type == "function");
	}
	var isObject_default = isObject;

	// ../node_modules/lodash-es/isFunction.js
	var asyncTag = "[object AsyncFunction]";
	var funcTag = "[object Function]";
	var genTag = "[object GeneratorFunction]";
	var proxyTag = "[object Proxy]";
	function isFunction(value) {
	  if (!isObject_default(value)) {
	    return false;
	  }
	  var tag = baseGetTag_default(value);
	  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
	}
	var isFunction_default = isFunction;

	// ../node_modules/lodash-es/_coreJsData.js
	var coreJsData = root_default["__core-js_shared__"];
	var coreJsData_default = coreJsData;

	// ../node_modules/lodash-es/_isMasked.js
	var maskSrcKey = function() {
	  var uid = /[^.]+$/.exec(coreJsData_default && coreJsData_default.keys && coreJsData_default.keys.IE_PROTO || "");
	  return uid ? "Symbol(src)_1." + uid : "";
	}();
	function isMasked(func) {
	  return !!maskSrcKey && maskSrcKey in func;
	}
	var isMasked_default = isMasked;

	// ../node_modules/lodash-es/_toSource.js
	var funcProto = Function.prototype;
	var funcToString = funcProto.toString;
	function toSource(func) {
	  if (func != null) {
	    try {
	      return funcToString.call(func);
	    } catch (e2) {
	    }
	    try {
	      return func + "";
	    } catch (e2) {
	    }
	  }
	  return "";
	}
	var toSource_default = toSource;

	// ../node_modules/lodash-es/_baseIsNative.js
	var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
	var reIsHostCtor = /^\[object .+?Constructor\]$/;
	var funcProto2 = Function.prototype;
	var objectProto3 = Object.prototype;
	var funcToString2 = funcProto2.toString;
	var hasOwnProperty2 = objectProto3.hasOwnProperty;
	var reIsNative = RegExp("^" + funcToString2.call(hasOwnProperty2).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$");
	function baseIsNative(value) {
	  if (!isObject_default(value) || isMasked_default(value)) {
	    return false;
	  }
	  var pattern = isFunction_default(value) ? reIsNative : reIsHostCtor;
	  return pattern.test(toSource_default(value));
	}
	var baseIsNative_default = baseIsNative;

	// ../node_modules/lodash-es/_getValue.js
	function getValue(object, key) {
	  return object == null ? void 0 : object[key];
	}
	var getValue_default = getValue;

	// ../node_modules/lodash-es/_getNative.js
	function getNative(object, key) {
	  var value = getValue_default(object, key);
	  return baseIsNative_default(value) ? value : void 0;
	}
	var getNative_default = getNative;

	// ../node_modules/lodash-es/_nativeCreate.js
	var nativeCreate = getNative_default(Object, "create");
	var nativeCreate_default = nativeCreate;

	// ../node_modules/lodash-es/_hashClear.js
	function hashClear() {
	  this.__data__ = nativeCreate_default ? nativeCreate_default(null) : {};
	  this.size = 0;
	}
	var hashClear_default = hashClear;

	// ../node_modules/lodash-es/_hashDelete.js
	function hashDelete(key) {
	  var result = this.has(key) && delete this.__data__[key];
	  this.size -= result ? 1 : 0;
	  return result;
	}
	var hashDelete_default = hashDelete;

	// ../node_modules/lodash-es/_hashGet.js
	var HASH_UNDEFINED = "__lodash_hash_undefined__";
	var objectProto4 = Object.prototype;
	var hasOwnProperty3 = objectProto4.hasOwnProperty;
	function hashGet(key) {
	  var data = this.__data__;
	  if (nativeCreate_default) {
	    var result = data[key];
	    return result === HASH_UNDEFINED ? void 0 : result;
	  }
	  return hasOwnProperty3.call(data, key) ? data[key] : void 0;
	}
	var hashGet_default = hashGet;

	// ../node_modules/lodash-es/_hashHas.js
	var objectProto5 = Object.prototype;
	var hasOwnProperty4 = objectProto5.hasOwnProperty;
	function hashHas(key) {
	  var data = this.__data__;
	  return nativeCreate_default ? data[key] !== void 0 : hasOwnProperty4.call(data, key);
	}
	var hashHas_default = hashHas;

	// ../node_modules/lodash-es/_hashSet.js
	var HASH_UNDEFINED2 = "__lodash_hash_undefined__";
	function hashSet(key, value) {
	  var data = this.__data__;
	  this.size += this.has(key) ? 0 : 1;
	  data[key] = nativeCreate_default && value === void 0 ? HASH_UNDEFINED2 : value;
	  return this;
	}
	var hashSet_default = hashSet;

	// ../node_modules/lodash-es/_Hash.js
	function Hash(entries) {
	  var index = -1, length = entries == null ? 0 : entries.length;
	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}
	Hash.prototype.clear = hashClear_default;
	Hash.prototype["delete"] = hashDelete_default;
	Hash.prototype.get = hashGet_default;
	Hash.prototype.has = hashHas_default;
	Hash.prototype.set = hashSet_default;
	var Hash_default = Hash;

	// ../node_modules/lodash-es/_listCacheClear.js
	function listCacheClear() {
	  this.__data__ = [];
	  this.size = 0;
	}
	var listCacheClear_default = listCacheClear;

	// ../node_modules/lodash-es/eq.js
	function eq(value, other) {
	  return value === other || value !== value && other !== other;
	}
	var eq_default = eq;

	// ../node_modules/lodash-es/_assocIndexOf.js
	function assocIndexOf(array, key) {
	  var length = array.length;
	  while (length--) {
	    if (eq_default(array[length][0], key)) {
	      return length;
	    }
	  }
	  return -1;
	}
	var assocIndexOf_default = assocIndexOf;

	// ../node_modules/lodash-es/_listCacheDelete.js
	var arrayProto = Array.prototype;
	var splice = arrayProto.splice;
	function listCacheDelete(key) {
	  var data = this.__data__, index = assocIndexOf_default(data, key);
	  if (index < 0) {
	    return false;
	  }
	  var lastIndex = data.length - 1;
	  if (index == lastIndex) {
	    data.pop();
	  } else {
	    splice.call(data, index, 1);
	  }
	  --this.size;
	  return true;
	}
	var listCacheDelete_default = listCacheDelete;

	// ../node_modules/lodash-es/_listCacheGet.js
	function listCacheGet(key) {
	  var data = this.__data__, index = assocIndexOf_default(data, key);
	  return index < 0 ? void 0 : data[index][1];
	}
	var listCacheGet_default = listCacheGet;

	// ../node_modules/lodash-es/_listCacheHas.js
	function listCacheHas(key) {
	  return assocIndexOf_default(this.__data__, key) > -1;
	}
	var listCacheHas_default = listCacheHas;

	// ../node_modules/lodash-es/_listCacheSet.js
	function listCacheSet(key, value) {
	  var data = this.__data__, index = assocIndexOf_default(data, key);
	  if (index < 0) {
	    ++this.size;
	    data.push([key, value]);
	  } else {
	    data[index][1] = value;
	  }
	  return this;
	}
	var listCacheSet_default = listCacheSet;

	// ../node_modules/lodash-es/_ListCache.js
	function ListCache(entries) {
	  var index = -1, length = entries == null ? 0 : entries.length;
	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}
	ListCache.prototype.clear = listCacheClear_default;
	ListCache.prototype["delete"] = listCacheDelete_default;
	ListCache.prototype.get = listCacheGet_default;
	ListCache.prototype.has = listCacheHas_default;
	ListCache.prototype.set = listCacheSet_default;
	var ListCache_default = ListCache;

	// ../node_modules/lodash-es/_Map.js
	var Map2 = getNative_default(root_default, "Map");
	var Map_default = Map2;

	// ../node_modules/lodash-es/_mapCacheClear.js
	function mapCacheClear() {
	  this.size = 0;
	  this.__data__ = {
	    "hash": new Hash_default(),
	    "map": new (Map_default || ListCache_default)(),
	    "string": new Hash_default()
	  };
	}
	var mapCacheClear_default = mapCacheClear;

	// ../node_modules/lodash-es/_isKeyable.js
	function isKeyable(value) {
	  var type = typeof value;
	  return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
	}
	var isKeyable_default = isKeyable;

	// ../node_modules/lodash-es/_getMapData.js
	function getMapData(map, key) {
	  var data = map.__data__;
	  return isKeyable_default(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
	}
	var getMapData_default = getMapData;

	// ../node_modules/lodash-es/_mapCacheDelete.js
	function mapCacheDelete(key) {
	  var result = getMapData_default(this, key)["delete"](key);
	  this.size -= result ? 1 : 0;
	  return result;
	}
	var mapCacheDelete_default = mapCacheDelete;

	// ../node_modules/lodash-es/_mapCacheGet.js
	function mapCacheGet(key) {
	  return getMapData_default(this, key).get(key);
	}
	var mapCacheGet_default = mapCacheGet;

	// ../node_modules/lodash-es/_mapCacheHas.js
	function mapCacheHas(key) {
	  return getMapData_default(this, key).has(key);
	}
	var mapCacheHas_default = mapCacheHas;

	// ../node_modules/lodash-es/_mapCacheSet.js
	function mapCacheSet(key, value) {
	  var data = getMapData_default(this, key), size = data.size;
	  data.set(key, value);
	  this.size += data.size == size ? 0 : 1;
	  return this;
	}
	var mapCacheSet_default = mapCacheSet;

	// ../node_modules/lodash-es/_MapCache.js
	function MapCache(entries) {
	  var index = -1, length = entries == null ? 0 : entries.length;
	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}
	MapCache.prototype.clear = mapCacheClear_default;
	MapCache.prototype["delete"] = mapCacheDelete_default;
	MapCache.prototype.get = mapCacheGet_default;
	MapCache.prototype.has = mapCacheHas_default;
	MapCache.prototype.set = mapCacheSet_default;
	var MapCache_default = MapCache;

	// ../node_modules/lodash-es/memoize.js
	var FUNC_ERROR_TEXT = "Expected a function";
	function memoize(func, resolver) {
	  if (typeof func != "function" || resolver != null && typeof resolver != "function") {
	    throw new TypeError(FUNC_ERROR_TEXT);
	  }
	  var memoized = function() {
	    var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache = memoized.cache;
	    if (cache.has(key)) {
	      return cache.get(key);
	    }
	    var result = func.apply(this, args);
	    memoized.cache = cache.set(key, result) || cache;
	    return result;
	  };
	  memoized.cache = new (memoize.Cache || MapCache_default)();
	  return memoized;
	}
	memoize.Cache = MapCache_default;
	var memoize_default = memoize;

	// ../node_modules/lodash-es/_memoizeCapped.js
	var MAX_MEMOIZE_SIZE = 500;
	function memoizeCapped(func) {
	  var result = memoize_default(func, function(key) {
	    if (cache.size === MAX_MEMOIZE_SIZE) {
	      cache.clear();
	    }
	    return key;
	  });
	  var cache = result.cache;
	  return result;
	}
	var memoizeCapped_default = memoizeCapped;

	// ../node_modules/lodash-es/_stringToPath.js
	var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
	var reEscapeChar = /\\(\\)?/g;
	var stringToPath = memoizeCapped_default(function(string2) {
	  var result = [];
	  if (string2.charCodeAt(0) === 46) {
	    result.push("");
	  }
	  string2.replace(rePropName, function(match, number2, quote, subString) {
	    result.push(quote ? subString.replace(reEscapeChar, "$1") : number2 || match);
	  });
	  return result;
	});
	var stringToPath_default = stringToPath;

	// ../node_modules/lodash-es/_arrayMap.js
	function arrayMap(array, iteratee) {
	  var index = -1, length = array == null ? 0 : array.length, result = Array(length);
	  while (++index < length) {
	    result[index] = iteratee(array[index], index, array);
	  }
	  return result;
	}
	var arrayMap_default = arrayMap;

	// ../node_modules/lodash-es/_baseToString.js
	var INFINITY = 1 / 0;
	var symbolProto = Symbol_default ? Symbol_default.prototype : void 0;
	var symbolToString = symbolProto ? symbolProto.toString : void 0;
	function baseToString(value) {
	  if (typeof value == "string") {
	    return value;
	  }
	  if (isArray_default(value)) {
	    return arrayMap_default(value, baseToString) + "";
	  }
	  if (isSymbol_default(value)) {
	    return symbolToString ? symbolToString.call(value) : "";
	  }
	  var result = value + "";
	  return result == "0" && 1 / value == -INFINITY ? "-0" : result;
	}
	var baseToString_default = baseToString;

	// ../node_modules/lodash-es/toString.js
	function toString(value) {
	  return value == null ? "" : baseToString_default(value);
	}
	var toString_default = toString;

	// ../node_modules/lodash-es/_castPath.js
	function castPath(value, object) {
	  if (isArray_default(value)) {
	    return value;
	  }
	  return isKey_default(value, object) ? [value] : stringToPath_default(toString_default(value));
	}
	var castPath_default = castPath;

	// ../node_modules/lodash-es/_toKey.js
	var INFINITY2 = 1 / 0;
	function toKey(value) {
	  if (typeof value == "string" || isSymbol_default(value)) {
	    return value;
	  }
	  var result = value + "";
	  return result == "0" && 1 / value == -INFINITY2 ? "-0" : result;
	}
	var toKey_default = toKey;

	// ../node_modules/lodash-es/_baseGet.js
	function baseGet(object, path) {
	  path = castPath_default(path, object);
	  var index = 0, length = path.length;
	  while (object != null && index < length) {
	    object = object[toKey_default(path[index++])];
	  }
	  return index && index == length ? object : void 0;
	}
	var baseGet_default = baseGet;

	// ../node_modules/lodash-es/get.js
	function get(object, path, defaultValue) {
	  var result = object == null ? void 0 : baseGet_default(object, path);
	  return result === void 0 ? defaultValue : result;
	}
	var get_default = get;

	// shared/src/utils/getDeep.ts
	function getDeep(v2, path) {
	  if (path.length === 0)
	    return v2;
	  return get_default(v2, path);
	}

	// shared/src/utils/SimpleCache.ts
	var SimpleCache = class {
	  constructor() {
	    __publicField(this, "_values", {});
	  }
	  get(key, producer) {
	    if (this.has(key)) {
	      return this._values[key];
	    } else {
	      const cachedValue = producer();
	      this._values[key] = cachedValue;
	      return cachedValue;
	    }
	  }
	  has(key) {
	    return this._values.hasOwnProperty(key);
	  }
	};

	// core/src/sheetObjects/SheetObjectTemplate.ts
	var import_dataverse7 = __toModule(dist$1);

	// ../node_modules/lodash-es/_defineProperty.js
	var defineProperty = function() {
	  try {
	    var func = getNative_default(Object, "defineProperty");
	    func({}, "", {});
	    return func;
	  } catch (e2) {
	  }
	}();
	var defineProperty_default = defineProperty;

	// ../node_modules/lodash-es/_baseAssignValue.js
	function baseAssignValue(object, key, value) {
	  if (key == "__proto__" && defineProperty_default) {
	    defineProperty_default(object, key, {
	      "configurable": true,
	      "enumerable": true,
	      "value": value,
	      "writable": true
	    });
	  } else {
	    object[key] = value;
	  }
	}
	var baseAssignValue_default = baseAssignValue;

	// ../node_modules/lodash-es/_assignValue.js
	var objectProto6 = Object.prototype;
	var hasOwnProperty5 = objectProto6.hasOwnProperty;
	function assignValue(object, key, value) {
	  var objValue = object[key];
	  if (!(hasOwnProperty5.call(object, key) && eq_default(objValue, value)) || value === void 0 && !(key in object)) {
	    baseAssignValue_default(object, key, value);
	  }
	}
	var assignValue_default = assignValue;

	// ../node_modules/lodash-es/_isIndex.js
	var MAX_SAFE_INTEGER = 9007199254740991;
	var reIsUint = /^(?:0|[1-9]\d*)$/;
	function isIndex(value, length) {
	  var type = typeof value;
	  length = length == null ? MAX_SAFE_INTEGER : length;
	  return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
	}
	var isIndex_default = isIndex;

	// ../node_modules/lodash-es/_baseSet.js
	function baseSet(object, path, value, customizer) {
	  if (!isObject_default(object)) {
	    return object;
	  }
	  path = castPath_default(path, object);
	  var index = -1, length = path.length, lastIndex = length - 1, nested = object;
	  while (nested != null && ++index < length) {
	    var key = toKey_default(path[index]), newValue = value;
	    if (key === "__proto__" || key === "constructor" || key === "prototype") {
	      return object;
	    }
	    if (index != lastIndex) {
	      var objValue = nested[key];
	      newValue = customizer ? customizer(objValue, key, nested) : void 0;
	      if (newValue === void 0) {
	        newValue = isObject_default(objValue) ? objValue : isIndex_default(path[index + 1]) ? [] : {};
	      }
	    }
	    assignValue_default(nested, key, newValue);
	    nested = nested[key];
	  }
	  return object;
	}
	var baseSet_default = baseSet;

	// ../node_modules/lodash-es/set.js
	function set(object, path, value) {
	  return object == null ? object : baseSet_default(object, path, value);
	}
	var set_default = set;

	// core/src/sheetObjects/getPropDefaultsOfSheetObject.ts
	var cachedDefaults = new WeakMap();
	function getPropDefaultsOfSheetObject(config) {
	  return getDefaultsOfPropTypeConfig(config);
	}
	function getDefaultsOfPropTypeConfig(config) {
	  if (cachedDefaults.has(config)) {
	    return cachedDefaults.get(config);
	  }
	  const generated = config.type === "compound" ? generateDefaultsForCompound(config) : config.type === "enum" ? generateDefaultsForEnum(config) : config.default;
	  cachedDefaults.set(config, generated);
	  return generated;
	}
	function generateDefaultsForEnum(config) {
	  const defaults = {
	    $case: config.defaultCase
	  };
	  for (const [case_, caseConf] of Object.entries(config.cases)) {
	    defaults[case_] = getDefaultsOfPropTypeConfig(caseConf);
	  }
	  return defaults;
	}
	function generateDefaultsForCompound(config) {
	  const defaults = {};
	  for (const [key, propConf] of Object.entries(config.props)) {
	    defaults[key] = getDefaultsOfPropTypeConfig(propConf);
	  }
	  return defaults;
	}

	// core/src/sequences/trackValueAtTime.ts
	var import_dataverse2 = __toModule(dist$1);

	// shared/src/logger.ts
	var logger = {
	  log: console.log,
	  warn: console.warn,
	  error: console.error,
	  trace: console.trace
	};
	var logger_default = logger;

	// core/src/sequences/trackValueAtTime.ts
	var import_UnitBezier = __toModule(require_UnitBezier());
	function trackValueAtTime(trackP, timeD) {
	  return (0, import_dataverse2.prism)(() => {
	    const track = (0, import_dataverse2.val)(trackP);
	    const driverD = import_dataverse2.prism.memo("driver", () => {
	      if (!track) {
	        return new import_dataverse2.ConstantDerivation(void 0);
	      } else if (track.type === "BasicKeyframedTrack") {
	        return trackValueAtTime_basicKeyframedTrack(track, timeD);
	      } else {
	        logger_default.error(`Track type not yet supported.`);
	        return new import_dataverse2.ConstantDerivation(void 0);
	      }
	    }, [track]);
	    return driverD.getValue();
	  });
	}
	function trackValueAtTime_basicKeyframedTrack(track, timeD) {
	  return (0, import_dataverse2.prism)(() => {
	    let stateRef = import_dataverse2.prism.ref("state", { started: false });
	    let state = stateRef.current;
	    const time = timeD.getValue();
	    if (!state.started || time < state.validFrom || state.validTo <= time) {
	      stateRef.current = state = pp(timeD, track);
	    }
	    return state.der.getValue();
	  });
	}
	var undefinedConstD = new import_dataverse2.ConstantDerivation(void 0);
	var pp = (progressionD, track) => {
	  const progression = progressionD.getValue();
	  if (track.keyframes.length === 0) {
	    return {
	      started: true,
	      validFrom: -Infinity,
	      validTo: Infinity,
	      der: undefinedConstD
	    };
	  }
	  let currentKeyframeIndex = 0;
	  while (true) {
	    const currentKeyframe = track.keyframes[currentKeyframeIndex];
	    if (!currentKeyframe) {
	      return states.error;
	    }
	    const isLastKeyframe = currentKeyframeIndex === track.keyframes.length - 1;
	    if (progression < currentKeyframe.position) {
	      if (currentKeyframeIndex === 0) {
	        return states.beforeFirstKeyframe(currentKeyframe);
	      } else {
	        return states.error;
	      }
	    } else if (currentKeyframe.position === progression) {
	      if (isLastKeyframe) {
	        return states.lastKeyframe(currentKeyframe);
	      } else {
	        return states.between(currentKeyframe, track.keyframes[currentKeyframeIndex + 1], progressionD);
	      }
	    } else {
	      if (currentKeyframeIndex === track.keyframes.length - 1) {
	        return states.lastKeyframe(currentKeyframe);
	      } else {
	        const nextKeyframeIndex = currentKeyframeIndex + 1;
	        if (track.keyframes[nextKeyframeIndex].position <= progression) {
	          currentKeyframeIndex = nextKeyframeIndex;
	          continue;
	        } else {
	          return states.between(currentKeyframe, track.keyframes[currentKeyframeIndex + 1], progressionD);
	        }
	      }
	    }
	  }
	};
	var states = {
	  beforeFirstKeyframe(kf) {
	    return {
	      started: true,
	      validFrom: -Infinity,
	      validTo: kf.position,
	      der: new import_dataverse2.ConstantDerivation(kf.value)
	    };
	  },
	  lastKeyframe(kf) {
	    return {
	      started: true,
	      validFrom: kf.position,
	      validTo: Infinity,
	      der: new import_dataverse2.ConstantDerivation(kf.value)
	    };
	  },
	  between(left, right, progressionD) {
	    if (!left.connectedRight) {
	      return {
	        started: true,
	        validFrom: left.position,
	        validTo: right.position,
	        der: new import_dataverse2.ConstantDerivation(left.value)
	      };
	    }
	    const solver = new import_UnitBezier.default(left.handles[2], left.handles[3], right.handles[0], right.handles[1]);
	    const globalProgressionToLocalProgression = (globalProgression) => {
	      return (globalProgression - left.position) / (right.position - left.position);
	    };
	    const der = (0, import_dataverse2.prism)(() => {
	      const progression = globalProgressionToLocalProgression(progressionD.getValue());
	      const valueProgression = solver.solveSimple(progression);
	      return left.value + valueProgression * (right.value - left.value);
	    });
	    return {
	      started: true,
	      validFrom: left.position,
	      validTo: right.position,
	      der
	    };
	  },
	  error: {
	    started: true,
	    validFrom: -Infinity,
	    validTo: Infinity,
	    der: undefinedConstD
	  }
	};

	// shared/src/utils/deepMergeWithCache.ts
	function deepMergeWithCache(base, override, cache) {
	  const _cache = cache;
	  const possibleCachedValue = _cache.get(base);
	  if (possibleCachedValue && possibleCachedValue.override === override) {
	    return possibleCachedValue.merged;
	  }
	  const merged = __spreadValues({}, base);
	  for (const key of Object.keys(override)) {
	    const valueInOverride = override[key];
	    const valueInBase = base[key];
	    merged[key] = typeof valueInOverride === "object" && typeof valueInBase === "object" ? deepMergeWithCache(valueInBase, valueInOverride, cache) : typeof valueInOverride === "undefined" ? valueInBase : valueInOverride;
	  }
	  cache.set(base, { override, merged });
	  return merged;
	}

	// shared/src/utils/pointerDeep.ts
	function pointerDeep(base, toAppend) {
	  let p2 = base;
	  for (const k2 of toAppend) {
	    p2 = p2[k2];
	  }
	  return p2;
	}

	// shared/src/utils/valToAtom.ts
	var import_dataverse3 = __toModule(dist$1);
	var valToAtom = (key, vals) => {
	  const a2 = import_dataverse3.prism.memo(key, () => new import_dataverse3.Atom(vals), []);
	  a2.setState(vals);
	  return a2;
	};

	// core/src/sheetObjects/SheetObject.ts
	var import_dataverse6 = __toModule(dist$1);

	// core/src/coreTicker.ts
	var import_dataverse4 = __toModule(dist$1);
	var coreTicker = new import_dataverse4.Ticker();
	var coreTicker_default = coreTicker;
	var onAnimationFrame = (t3) => {
	  coreTicker.tick(t3);
	  window.requestAnimationFrame(onAnimationFrame);
	};
	window.requestAnimationFrame(onAnimationFrame);

	// core/src/sheetObjects/TheatreSheetObject.ts
	var import_dataverse5 = __toModule(dist$1);
	var TheatreSheetObject = class {
	  constructor(internals) {
	    __publicField(this, "_cache", new SimpleCache());
	    setPrivateAPI(this, internals);
	  }
	  get type() {
	    return "Theatre_SheetObject_PublicAPI";
	  }
	  get props() {
	    return privateAPI(this).propsP;
	  }
	  get sheet() {
	    return privateAPI(this).sheet.publicApi;
	  }
	  get project() {
	    return privateAPI(this).sheet.project.publicApi;
	  }
	  get address() {
	    return __spreadValues({}, privateAPI(this).address);
	  }
	  _valuesDerivation() {
	    return this._cache.get("onValuesChangeDerivation", () => {
	      const sheetObject = privateAPI(this);
	      const d2 = (0, import_dataverse5.prism)(() => {
	        return (0, import_dataverse5.val)(sheetObject.getValues().getValue());
	      });
	      return d2;
	    });
	  }
	  onValuesChange(fn2) {
	    return this._valuesDerivation().tapImmediate(coreTicker_default, fn2);
	  }
	  get value() {
	    return this._valuesDerivation().getValue();
	  }
	  set initialValue(val7) {
	    privateAPI(this).setInitialValue(val7);
	  }
	};

	// core/src/sheetObjects/SheetObject.ts
	var SheetObject = class {
	  constructor(sheet, template, nativeObject) {
	    this.sheet = sheet;
	    this.template = template;
	    this.nativeObject = nativeObject;
	    __publicField(this, "$$isIdentityDerivationProvider", true);
	    __publicField(this, "address");
	    __publicField(this, "publicApi");
	    __publicField(this, "_initialValue", new import_dataverse6.Atom({}));
	    __publicField(this, "_cache", new SimpleCache());
	    this.address = __spreadProps(__spreadValues({}, template.address), {
	      sheetInstanceId: sheet.address.sheetInstanceId
	    });
	    this.publicApi = new TheatreSheetObject(this);
	  }
	  get type() {
	    return "Theatre_SheetObject";
	  }
	  getValues() {
	    return this._cache.get("getValues()", () => (0, import_dataverse6.prism)(() => {
	      const defaults = (0, import_dataverse6.val)(this.template.getDefaultValues());
	      const initial = (0, import_dataverse6.val)(this._initialValue.pointer);
	      const withInitialCache = import_dataverse6.prism.memo("withInitialCache", () => new WeakMap(), []);
	      const withInitial = deepMergeWithCache(defaults, initial, withInitialCache);
	      const statics = (0, import_dataverse6.val)(this.template.getStaticValues());
	      const withStaticsCache = import_dataverse6.prism.memo("withStatics", () => new WeakMap(), []);
	      const withStatics = deepMergeWithCache(withInitial, statics, withStaticsCache);
	      let final = withStatics;
	      let sequenced;
	      {
	        const pointerToSequencedValuesD = import_dataverse6.prism.memo("seq", () => this.getSequencedValues(), []);
	        const withSeqsCache = import_dataverse6.prism.memo("withSeqsCache", () => new WeakMap(), []);
	        sequenced = (0, import_dataverse6.val)((0, import_dataverse6.val)(pointerToSequencedValuesD));
	        const withSeqs = deepMergeWithCache(final, sequenced, withSeqsCache);
	        final = withSeqs;
	      }
	      const a2 = valToAtom("finalAtom", final);
	      return a2.pointer;
	    }));
	  }
	  getValueByPointer(pointer3) {
	    const allValuesP = (0, import_dataverse6.val)(this.getValues());
	    const { path } = (0, import_dataverse6.getPointerParts)(pointer3);
	    return (0, import_dataverse6.val)(pointerDeep(allValuesP, path));
	  }
	  getIdentityDerivation(path) {
	    return (0, import_dataverse6.prism)(() => {
	      const allValuesP = (0, import_dataverse6.val)(this.getValues());
	      return (0, import_dataverse6.val)(pointerDeep(allValuesP, path));
	    });
	  }
	  getSequencedValues() {
	    return (0, import_dataverse6.prism)(() => {
	      const tracksToProcessD = import_dataverse6.prism.memo("tracksToProcess", () => this.template.getArrayOfValidSequenceTracks(), []);
	      const tracksToProcess = (0, import_dataverse6.val)(tracksToProcessD);
	      const valsAtom = new import_dataverse6.Atom({});
	      import_dataverse6.prism.effect("processTracks", () => {
	        const untaps = [];
	        for (const { trackId, pathToProp } of tracksToProcess) {
	          const derivation = this._trackIdToDerivation(trackId);
	          const updateSequenceValueFromItsDerivation = () => {
	            valsAtom.setIn(pathToProp, derivation.getValue());
	          };
	          const untap = derivation.changesWithoutValues().tap(updateSequenceValueFromItsDerivation);
	          updateSequenceValueFromItsDerivation();
	          untaps.push(untap);
	        }
	        return () => {
	          for (const untap of untaps) {
	            untap();
	          }
	        };
	      }, tracksToProcess);
	      return valsAtom.pointer;
	    });
	  }
	  _trackIdToDerivation(trackId) {
	    const trackP = this.template.project.pointers.historic.sheetsById[this.address.sheetId].sequence.tracksByObject[this.address.objectKey].trackData[trackId];
	    const timeD = this.sheet.getSequence().positionDerivation;
	    return trackValueAtTime(trackP, timeD);
	  }
	  get propsP() {
	    return this._cache.get("propsP", () => (0, import_dataverse6.pointer)({ root: this, path: [] }));
	  }
	  validateValue(pointer3, value) {
	  }
	  setInitialValue(val7) {
	    this.validateValue(this.propsP, val7);
	    this._initialValue.setState(val7);
	  }
	};

	// core/src/sheetObjects/SheetObjectTemplate.ts
	var SheetObjectTemplate = class {
	  constructor(sheetTemplate, objectKey, nativeObject, config) {
	    this.sheetTemplate = sheetTemplate;
	    __publicField(this, "address");
	    __publicField(this, "type", "Theatre_SheetObjectTemplate");
	    __publicField(this, "_config");
	    __publicField(this, "_cache", new SimpleCache());
	    __publicField(this, "project");
	    this.address = __spreadProps(__spreadValues({}, sheetTemplate.address), { objectKey });
	    this._config = new import_dataverse7.Atom(config);
	    this.project = sheetTemplate.project;
	  }
	  get config() {
	    return this._config.getState();
	  }
	  createInstance(sheet, nativeObject, config) {
	    this._config.setState(config);
	    return new SheetObject(sheet, this, nativeObject);
	  }
	  overrideConfig(config) {
	    this._config.setState(config);
	  }
	  getDefaultValues() {
	    return this._cache.get("getDefaultValues()", () => (0, import_dataverse7.prism)(() => {
	      const config = (0, import_dataverse7.val)(this._config.pointer);
	      return getPropDefaultsOfSheetObject(config);
	    }));
	  }
	  getStaticValues() {
	    return this._cache.get("getDerivationOfStatics", () => (0, import_dataverse7.prism)(() => {
	      const pointerToSheetState = this.sheetTemplate.project.pointers.historic.sheetsById[this.address.sheetId];
	      return (0, import_dataverse7.val)(pointerToSheetState.staticOverrides.byObject[this.address.objectKey]) || {};
	    }));
	  }
	  getArrayOfValidSequenceTracks() {
	    return this._cache.get("getArrayOfValidSequenceTracks", () => (0, import_dataverse7.prism)(() => {
	      const defaults = (0, import_dataverse7.val)(this.getDefaultValues());
	      const pointerToSheetState = this.project.pointers.historic.sheetsById[this.address.sheetId];
	      const trackIdByPropPath = (0, import_dataverse7.val)(pointerToSheetState.sequence.tracksByObject[this.address.objectKey].trackIdByPropPath);
	      const arrayOfIds = [];
	      if (trackIdByPropPath) {
	        for (const [pathToPropInString, trackId] of Object.entries(trackIdByPropPath)) {
	          let pathToProp;
	          try {
	            pathToProp = JSON.parse(pathToPropInString);
	          } catch (e2) {
	            logger_default.warn(`property ${JSON.stringify(pathToPropInString)} cannot be parsed. Skipping.`);
	            continue;
	          }
	          const defaultValue = get_default(defaults, pathToProp);
	          if (typeof defaultValue !== "number") {
	            continue;
	          }
	          arrayOfIds.push({ pathToProp, trackId });
	        }
	      } else {
	        return emptyArray;
	      }
	      if (arrayOfIds.length === 0) {
	        return emptyArray;
	      } else {
	        return arrayOfIds;
	      }
	    }));
	  }
	  getMapOfValidSequenceTracks_forStudio() {
	    return this._cache.get("getMapOfValidSequenceTracks_forStudio", () => this.getArrayOfValidSequenceTracks().map((arr) => {
	      let map = {};
	      for (const { pathToProp, trackId } of arr) {
	        set_default(map, pathToProp, trackId);
	      }
	      return map;
	    }));
	  }
	  getDefaultsAtPointer(pointer3) {
	    const { path } = (0, import_dataverse7.getPointerParts)(pointer3);
	    const defaults = this.getDefaultValues().getValue();
	    const defaultsAtPath = getDeep(defaults, path);
	    return defaultsAtPath;
	  }
	};

	// core/src/sheets/SheetTemplate.ts
	var import_dataverse13 = __toModule(dist$1);

	// shared/src/utils/didYouMean.ts
	__toModule(require_propose());

	// shared/src/utils/errors.ts
	var TheatreError = class extends Error {
	};
	var InvalidArgumentError = class extends TheatreError {
	};

	// core/src/sequences/Sequence.ts
	var import_dataverse10 = __toModule(dist$1);
	var import_dataverse11 = __toModule(dist$1);

	// ../node_modules/lodash-es/_trimmedEndIndex.js
	var reWhitespace = /\s/;
	function trimmedEndIndex(string2) {
	  var index = string2.length;
	  while (index-- && reWhitespace.test(string2.charAt(index))) {
	  }
	  return index;
	}
	var trimmedEndIndex_default = trimmedEndIndex;

	// ../node_modules/lodash-es/_baseTrim.js
	var reTrimStart = /^\s+/;
	function baseTrim(string2) {
	  return string2 ? string2.slice(0, trimmedEndIndex_default(string2) + 1).replace(reTrimStart, "") : string2;
	}
	var baseTrim_default = baseTrim;

	// ../node_modules/lodash-es/toNumber.js
	var NAN = 0 / 0;
	var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
	var reIsBinary = /^0b[01]+$/i;
	var reIsOctal = /^0o[0-7]+$/i;
	var freeParseInt = parseInt;
	function toNumber(value) {
	  if (typeof value == "number") {
	    return value;
	  }
	  if (isSymbol_default(value)) {
	    return NAN;
	  }
	  if (isObject_default(value)) {
	    var other = typeof value.valueOf == "function" ? value.valueOf() : value;
	    value = isObject_default(other) ? other + "" : other;
	  }
	  if (typeof value != "string") {
	    return value === 0 ? value : +value;
	  }
	  value = baseTrim_default(value);
	  var isBinary = reIsBinary.test(value);
	  return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
	}
	var toNumber_default = toNumber;

	// ../node_modules/lodash-es/toFinite.js
	var INFINITY3 = 1 / 0;
	var MAX_INTEGER = 17976931348623157e292;
	function toFinite(value) {
	  if (!value) {
	    return value === 0 ? value : 0;
	  }
	  value = toNumber_default(value);
	  if (value === INFINITY3 || value === -INFINITY3) {
	    var sign = value < 0 ? -1 : 1;
	    return sign * MAX_INTEGER;
	  }
	  return value === value ? value : 0;
	}
	var toFinite_default = toFinite;

	// ../node_modules/lodash-es/toInteger.js
	function toInteger(value) {
	  var result = toFinite_default(value), remainder = result % 1;
	  return result === result ? remainder ? result - remainder : result : 0;
	}
	var toInteger_default = toInteger;

	// ../node_modules/lodash-es/_overArg.js
	function overArg(func, transform) {
	  return function(arg) {
	    return func(transform(arg));
	  };
	}
	var overArg_default = overArg;

	// ../node_modules/lodash-es/_getPrototype.js
	var getPrototype = overArg_default(Object.getPrototypeOf, Object);
	var getPrototype_default = getPrototype;

	// ../node_modules/lodash-es/isPlainObject.js
	var objectTag = "[object Object]";
	var funcProto3 = Function.prototype;
	var objectProto7 = Object.prototype;
	var funcToString3 = funcProto3.toString;
	var hasOwnProperty6 = objectProto7.hasOwnProperty;
	var objectCtorString = funcToString3.call(Object);
	function isPlainObject(value) {
	  if (!isObjectLike_default(value) || baseGetTag_default(value) != objectTag) {
	    return false;
	  }
	  var proto = getPrototype_default(value);
	  if (proto === null) {
	    return true;
	  }
	  var Ctor = hasOwnProperty6.call(proto, "constructor") && proto.constructor;
	  return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString3.call(Ctor) == objectCtorString;
	}
	var isPlainObject_default = isPlainObject;

	// ../node_modules/lodash-es/_baseSlice.js
	function baseSlice(array, start, end) {
	  var index = -1, length = array.length;
	  if (start < 0) {
	    start = -start > length ? 0 : length + start;
	  }
	  end = end > length ? length : end;
	  if (end < 0) {
	    end += length;
	  }
	  length = start > end ? 0 : end - start >>> 0;
	  start >>>= 0;
	  var result = Array(length);
	  while (++index < length) {
	    result[index] = array[index + start];
	  }
	  return result;
	}
	var baseSlice_default = baseSlice;

	// ../node_modules/lodash-es/_castSlice.js
	function castSlice(array, start, end) {
	  var length = array.length;
	  end = end === void 0 ? length : end;
	  return !start && end >= length ? array : baseSlice_default(array, start, end);
	}
	var castSlice_default = castSlice;

	// ../node_modules/lodash-es/_hasUnicode.js
	var rsAstralRange = "\\ud800-\\udfff";
	var rsComboMarksRange = "\\u0300-\\u036f";
	var reComboHalfMarksRange = "\\ufe20-\\ufe2f";
	var rsComboSymbolsRange = "\\u20d0-\\u20ff";
	var rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange;
	var rsVarRange = "\\ufe0e\\ufe0f";
	var rsZWJ = "\\u200d";
	var reHasUnicode = RegExp("[" + rsZWJ + rsAstralRange + rsComboRange + rsVarRange + "]");
	function hasUnicode(string2) {
	  return reHasUnicode.test(string2);
	}
	var hasUnicode_default = hasUnicode;

	// ../node_modules/lodash-es/_asciiToArray.js
	function asciiToArray(string2) {
	  return string2.split("");
	}
	var asciiToArray_default = asciiToArray;

	// ../node_modules/lodash-es/_unicodeToArray.js
	var rsAstralRange2 = "\\ud800-\\udfff";
	var rsComboMarksRange2 = "\\u0300-\\u036f";
	var reComboHalfMarksRange2 = "\\ufe20-\\ufe2f";
	var rsComboSymbolsRange2 = "\\u20d0-\\u20ff";
	var rsComboRange2 = rsComboMarksRange2 + reComboHalfMarksRange2 + rsComboSymbolsRange2;
	var rsVarRange2 = "\\ufe0e\\ufe0f";
	var rsAstral = "[" + rsAstralRange2 + "]";
	var rsCombo = "[" + rsComboRange2 + "]";
	var rsFitz = "\\ud83c[\\udffb-\\udfff]";
	var rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")";
	var rsNonAstral = "[^" + rsAstralRange2 + "]";
	var rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}";
	var rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]";
	var rsZWJ2 = "\\u200d";
	var reOptMod = rsModifier + "?";
	var rsOptVar = "[" + rsVarRange2 + "]?";
	var rsOptJoin = "(?:" + rsZWJ2 + "(?:" + [rsNonAstral, rsRegional, rsSurrPair].join("|") + ")" + rsOptVar + reOptMod + ")*";
	var rsSeq = rsOptVar + reOptMod + rsOptJoin;
	var rsSymbol = "(?:" + [rsNonAstral + rsCombo + "?", rsCombo, rsRegional, rsSurrPair, rsAstral].join("|") + ")";
	var reUnicode = RegExp(rsFitz + "(?=" + rsFitz + ")|" + rsSymbol + rsSeq, "g");
	function unicodeToArray(string2) {
	  return string2.match(reUnicode) || [];
	}
	var unicodeToArray_default = unicodeToArray;

	// ../node_modules/lodash-es/_stringToArray.js
	function stringToArray(string2) {
	  return hasUnicode_default(string2) ? unicodeToArray_default(string2) : asciiToArray_default(string2);
	}
	var stringToArray_default = stringToArray;

	// ../node_modules/lodash-es/_baseProperty.js
	function baseProperty(key) {
	  return function(object) {
	    return object == null ? void 0 : object[key];
	  };
	}
	var baseProperty_default = baseProperty;

	// ../node_modules/lodash-es/_baseRepeat.js
	var MAX_SAFE_INTEGER2 = 9007199254740991;
	var nativeFloor = Math.floor;
	function baseRepeat(string2, n2) {
	  var result = "";
	  if (!string2 || n2 < 1 || n2 > MAX_SAFE_INTEGER2) {
	    return result;
	  }
	  do {
	    if (n2 % 2) {
	      result += string2;
	    }
	    n2 = nativeFloor(n2 / 2);
	    if (n2) {
	      string2 += string2;
	    }
	  } while (n2);
	  return result;
	}
	var baseRepeat_default = baseRepeat;

	// ../node_modules/lodash-es/_asciiSize.js
	var asciiSize = baseProperty_default("length");
	var asciiSize_default = asciiSize;

	// ../node_modules/lodash-es/_unicodeSize.js
	var rsAstralRange3 = "\\ud800-\\udfff";
	var rsComboMarksRange3 = "\\u0300-\\u036f";
	var reComboHalfMarksRange3 = "\\ufe20-\\ufe2f";
	var rsComboSymbolsRange3 = "\\u20d0-\\u20ff";
	var rsComboRange3 = rsComboMarksRange3 + reComboHalfMarksRange3 + rsComboSymbolsRange3;
	var rsVarRange3 = "\\ufe0e\\ufe0f";
	var rsAstral2 = "[" + rsAstralRange3 + "]";
	var rsCombo2 = "[" + rsComboRange3 + "]";
	var rsFitz2 = "\\ud83c[\\udffb-\\udfff]";
	var rsModifier2 = "(?:" + rsCombo2 + "|" + rsFitz2 + ")";
	var rsNonAstral2 = "[^" + rsAstralRange3 + "]";
	var rsRegional2 = "(?:\\ud83c[\\udde6-\\uddff]){2}";
	var rsSurrPair2 = "[\\ud800-\\udbff][\\udc00-\\udfff]";
	var rsZWJ3 = "\\u200d";
	var reOptMod2 = rsModifier2 + "?";
	var rsOptVar2 = "[" + rsVarRange3 + "]?";
	var rsOptJoin2 = "(?:" + rsZWJ3 + "(?:" + [rsNonAstral2, rsRegional2, rsSurrPair2].join("|") + ")" + rsOptVar2 + reOptMod2 + ")*";
	var rsSeq2 = rsOptVar2 + reOptMod2 + rsOptJoin2;
	var rsSymbol2 = "(?:" + [rsNonAstral2 + rsCombo2 + "?", rsCombo2, rsRegional2, rsSurrPair2, rsAstral2].join("|") + ")";
	var reUnicode2 = RegExp(rsFitz2 + "(?=" + rsFitz2 + ")|" + rsSymbol2 + rsSeq2, "g");
	function unicodeSize(string2) {
	  var result = reUnicode2.lastIndex = 0;
	  while (reUnicode2.test(string2)) {
	    ++result;
	  }
	  return result;
	}
	var unicodeSize_default = unicodeSize;

	// ../node_modules/lodash-es/_stringSize.js
	function stringSize(string2) {
	  return hasUnicode_default(string2) ? unicodeSize_default(string2) : asciiSize_default(string2);
	}
	var stringSize_default = stringSize;

	// ../node_modules/lodash-es/_createPadding.js
	var nativeCeil = Math.ceil;
	function createPadding(length, chars) {
	  chars = chars === void 0 ? " " : baseToString_default(chars);
	  var charsLength = chars.length;
	  if (charsLength < 2) {
	    return charsLength ? baseRepeat_default(chars, length) : chars;
	  }
	  var result = baseRepeat_default(chars, nativeCeil(length / stringSize_default(chars)));
	  return hasUnicode_default(chars) ? castSlice_default(stringToArray_default(result), 0, length).join("") : result.slice(0, length);
	}
	var createPadding_default = createPadding;

	// ../node_modules/lodash-es/padStart.js
	function padStart(string2, length, chars) {
	  string2 = toString_default(string2);
	  length = toInteger_default(length);
	  var strLength = length ? stringSize_default(string2) : 0;
	  return length && strLength < length ? createPadding_default(length - strLength, chars) + string2 : string2;
	}
	var padStart_default = padStart;

	// shared/src/utils/defer.ts
	function defer() {
	  let resolve;
	  let reject;
	  const promise = new Promise((rs, rj) => {
	    resolve = (v2) => {
	      rs(v2);
	      deferred.status = "resolved";
	    };
	    reject = (v2) => {
	      rj(v2);
	      deferred.status = "rejected";
	    };
	  });
	  const deferred = {
	    resolve,
	    reject,
	    promise,
	    status: "pending"
	  };
	  return deferred;
	}

	// shared/src/utils/noop.ts
	var noop = () => {
	};
	var noop_default = noop;

	// core/src/sequences/playbackControllers/DefaultPlaybackController.ts
	var import_dataverse8 = __toModule(dist$1);
	var DefaultPlaybackController = class {
	  constructor(_ticker) {
	    this._ticker = _ticker;
	    __publicField(this, "_stopPlayCallback", noop_default);
	    __publicField(this, "_state", new import_dataverse8.Atom({
	      position: 0,
	      playing: false
	    }));
	    __publicField(this, "statePointer");
	    this.statePointer = this._state.pointer;
	  }
	  destroy() {
	  }
	  pause() {
	    this._stopPlayCallback();
	    this.playing = false;
	    this._stopPlayCallback = noop_default;
	  }
	  gotoPosition(time) {
	    this._updatePositionInState(time);
	  }
	  _updatePositionInState(time) {
	    this._state.reduceState(["position"], () => time);
	  }
	  getCurrentPosition() {
	    return this._state.getState().position;
	  }
	  get playing() {
	    return this._state.getState().playing;
	  }
	  set playing(playing) {
	    this._state.setIn(["playing"], playing);
	  }
	  play(iterationCount, range, rate, direction) {
	    if (this.playing) {
	      this.pause();
	    }
	    this.playing = true;
	    const ticker = this._ticker;
	    const iterationLength = range[1] - range[0];
	    {
	      const startPos = this.getCurrentPosition();
	      if (startPos < range[0] || startPos > range[1]) {
	        if (direction === "normal" || direction === "alternate") {
	          this._updatePositionInState(range[0]);
	        } else if (direction === "reverse" || direction === "alternateReverse") {
	          this._updatePositionInState(range[1]);
	        }
	      } else if (direction === "normal" || direction === "alternate") {
	        if (startPos === range[1]) {
	          this._updatePositionInState(range[0]);
	        }
	      } else {
	        if (startPos === range[0]) {
	          this._updatePositionInState(range[1]);
	        }
	      }
	    }
	    const deferred = defer();
	    const initialTickerTime = ticker.time;
	    const totalPlaybackLength = iterationLength * iterationCount;
	    let initialElapsedPos = this.getCurrentPosition() - range[0];
	    if (direction === "reverse" || direction === "alternateReverse") {
	      initialElapsedPos = range[1] - this.getCurrentPosition();
	    }
	    const tick = (currentTickerTime) => {
	      const elapsedTickerTime = Math.max(currentTickerTime - initialTickerTime, 0);
	      const elapsedTickerTimeInSeconds = elapsedTickerTime / 1e3;
	      const elapsedPos = Math.min(elapsedTickerTimeInSeconds * rate + initialElapsedPos, totalPlaybackLength);
	      if (elapsedPos !== totalPlaybackLength) {
	        const iterationNumber = Math.floor(elapsedPos / iterationLength);
	        let currentIterationPos = elapsedPos / iterationLength % 1 * iterationLength;
	        if (direction !== "normal") {
	          if (direction === "reverse") {
	            currentIterationPos = iterationLength - currentIterationPos;
	          } else {
	            const isCurrentIterationNumberEven = iterationNumber % 2 === 0;
	            if (direction === "alternate") {
	              if (!isCurrentIterationNumberEven) {
	                currentIterationPos = iterationLength - currentIterationPos;
	              }
	            } else {
	              if (isCurrentIterationNumberEven) {
	                currentIterationPos = iterationLength - currentIterationPos;
	              }
	            }
	          }
	        }
	        this._updatePositionInState(currentIterationPos + range[0]);
	        requestNextTick();
	      } else {
	        if (direction === "normal") {
	          this._updatePositionInState(range[1]);
	        } else if (direction === "reverse") {
	          this._updatePositionInState(range[0]);
	        } else {
	          const isLastIterationEven = (iterationCount - 1) % 2 === 0;
	          if (direction === "alternate") {
	            if (isLastIterationEven) {
	              this._updatePositionInState(range[1]);
	            } else {
	              this._updatePositionInState(range[0]);
	            }
	          } else {
	            if (isLastIterationEven) {
	              this._updatePositionInState(range[0]);
	            } else {
	              this._updatePositionInState(range[1]);
	            }
	          }
	        }
	        this.playing = false;
	        deferred.resolve(true);
	      }
	    };
	    this._stopPlayCallback = () => {
	      ticker.offThisOrNextTick(tick);
	      ticker.offNextTick(tick);
	      if (this.playing)
	        deferred.resolve(false);
	    };
	    const requestNextTick = () => ticker.onNextTick(tick);
	    ticker.onThisOrNextTick(tick);
	    return deferred.promise;
	  }
	};

	// core/src/sequences/playbackControllers/AudioPlaybackController.ts
	var import_dataverse9 = __toModule(dist$1);
	var AudioPlaybackController = class {
	  constructor(_ticker, _decodedBuffer, _audioContext, _nodeDestination) {
	    this._ticker = _ticker;
	    this._decodedBuffer = _decodedBuffer;
	    this._audioContext = _audioContext;
	    this._nodeDestination = _nodeDestination;
	    __publicField(this, "_mainGain");
	    __publicField(this, "_state", new import_dataverse9.Atom({
	      position: 0,
	      playing: false
	    }));
	    __publicField(this, "statePointer");
	    __publicField(this, "_stopPlayCallback", noop_default);
	    this.statePointer = this._state.pointer;
	    this._mainGain = this._audioContext.createGain();
	    this._mainGain.connect(this._nodeDestination);
	  }
	  get _playing() {
	    return this._state.getState().playing;
	  }
	  set _playing(playing) {
	    this._state.setIn(["playing"], playing);
	  }
	  destroy() {
	  }
	  pause() {
	    this._stopPlayCallback();
	    this._playing = false;
	    this._stopPlayCallback = noop_default;
	  }
	  gotoPosition(time) {
	    this._updatePositionInState(time);
	  }
	  _updatePositionInState(time) {
	    this._state.reduceState(["position"], () => time);
	  }
	  getCurrentPosition() {
	    return this._state.getState().position;
	  }
	  play(iterationCount, range, rate, direction) {
	    if (this._playing) {
	      this.pause();
	    }
	    this._playing = true;
	    const ticker = this._ticker;
	    let startPos = this.getCurrentPosition();
	    const iterationLength = range[1] - range[0];
	    if (direction !== "normal") {
	      throw new InvalidArgumentError(`Audio-controlled sequences can only be played in the "normal" direction. '${direction}' given.`);
	    }
	    if (startPos < range[0] || startPos > range[1]) {
	      this._updatePositionInState(range[0]);
	    } else if (startPos === range[1]) {
	      this._updatePositionInState(range[0]);
	    }
	    startPos = this.getCurrentPosition();
	    const deferred = defer();
	    const currentSource = this._audioContext.createBufferSource();
	    currentSource.buffer = this._decodedBuffer;
	    currentSource.connect(this._mainGain);
	    currentSource.playbackRate.value = rate;
	    if (iterationCount > 1e3) {
	      console.warn(`Audio-controlled sequences cannot have an iterationCount larger than 1000. It has been clamped to 1000.`);
	      iterationCount = 1e3;
	    }
	    if (iterationCount > 1) {
	      currentSource.loop = true;
	      currentSource.loopStart = range[0];
	      currentSource.loopEnd = range[1];
	    }
	    const initialTickerTime = ticker.time;
	    let initialElapsedPos = startPos - range[0];
	    const totalPlaybackLength = iterationLength * iterationCount;
	    currentSource.start(0, startPos, totalPlaybackLength - initialElapsedPos);
	    const tick = (currentTickerTime) => {
	      const elapsedTickerTime = Math.max(currentTickerTime - initialTickerTime, 0);
	      const elapsedTickerTimeInSeconds = elapsedTickerTime / 1e3;
	      const elapsedPos = Math.min(elapsedTickerTimeInSeconds * rate + initialElapsedPos, totalPlaybackLength);
	      if (elapsedPos !== totalPlaybackLength) {
	        let currentIterationPos = elapsedPos / iterationLength % 1 * iterationLength;
	        this._updatePositionInState(currentIterationPos + range[0]);
	        requestNextTick();
	      } else {
	        this._updatePositionInState(range[1]);
	        this._playing = false;
	        cleanup();
	        deferred.resolve(true);
	      }
	    };
	    const cleanup = () => {
	      currentSource.stop();
	      currentSource.disconnect();
	    };
	    this._stopPlayCallback = () => {
	      cleanup();
	      ticker.offThisOrNextTick(tick);
	      ticker.offNextTick(tick);
	      if (this._playing)
	        deferred.resolve(false);
	    };
	    const requestNextTick = () => ticker.onNextTick(tick);
	    ticker.onThisOrNextTick(tick);
	    return deferred.promise;
	  }
	};

	// core/src/sequences/TheatreSequence.ts
	var TheatreSequence = class {
	  get type() {
	    return "Theatre_Sequence_PublicAPI";
	  }
	  constructor(sheet) {
	    setPrivateAPI(this, sheet);
	  }
	  play(conf) {
	    if (privateAPI(this)._project.isReady()) {
	      return privateAPI(this).play(conf);
	    } else {
	      const d2 = defer();
	      d2.resolve(true);
	      return d2.promise;
	    }
	  }
	  pause() {
	    privateAPI(this).pause();
	  }
	  get position() {
	    return privateAPI(this).position;
	  }
	  set position(position) {
	    privateAPI(this).position = position;
	  }
	  async attachAudio(args) {
	    const { audioContext, destinationNode, decodedBuffer, gainNode } = await resolveAudioBuffer(args);
	    const playbackController = new AudioPlaybackController(coreTicker_default, decodedBuffer, audioContext, gainNode);
	    privateAPI(this).replacePlaybackController(playbackController);
	    return { audioContext, destinationNode, decodedBuffer, gainNode };
	  }
	  get pointer() {
	    return privateAPI(this).pointer;
	  }
	};
	async function resolveAudioBuffer(args) {
	  function getAudioContext() {
	    if (args.audioContext)
	      return Promise.resolve(args.audioContext);
	    const ctx = new AudioContext();
	    if (ctx.state === "running")
	      return Promise.resolve(ctx);
	    return new Promise((resolve) => {
	      const listener = () => {
	        ctx.resume();
	      };
	      const eventsToHookInto = [
	        "mousedown",
	        "keydown",
	        "touchstart"
	      ];
	      const eventListenerOpts = { capture: true, passive: false };
	      eventsToHookInto.forEach((eventName) => {
	        window.addEventListener(eventName, listener, eventListenerOpts);
	      });
	      ctx.addEventListener("statechange", () => {
	        if (ctx.state === "running") {
	          eventsToHookInto.forEach((eventName) => {
	            window.removeEventListener(eventName, listener, eventListenerOpts);
	          });
	          resolve(ctx);
	        }
	      });
	    });
	  }
	  async function getAudioBuffer() {
	    if (args.source instanceof AudioBuffer) {
	      return args.source;
	    }
	    const decodedBufferDeferred = defer();
	    if (typeof args.source !== "string") {
	      throw new Error(`Error validating arguments to sequence.attachAudio(). args.source must either be a string or an instance of AudioBuffer.`);
	    }
	    let fetchResponse;
	    try {
	      fetchResponse = await fetch(args.source);
	    } catch (e2) {
	      console.error(e2);
	      throw new Error(`Could not fetch '${args.source}'. Network error logged above.`);
	    }
	    let arrayBuffer;
	    try {
	      arrayBuffer = await fetchResponse.arrayBuffer();
	    } catch (e2) {
	      console.error(e2);
	      throw new Error(`Could not read '${args.source}' as an arrayBuffer.`);
	    }
	    const audioContext2 = await audioContextPromise;
	    audioContext2.decodeAudioData(arrayBuffer, decodedBufferDeferred.resolve, decodedBufferDeferred.reject);
	    let decodedBuffer2;
	    try {
	      decodedBuffer2 = await decodedBufferDeferred.promise;
	    } catch (e2) {
	      console.error(e2);
	      throw new Error(`Could not decode ${args.source} as an audio file.`);
	    }
	    return decodedBuffer2;
	  }
	  const audioContextPromise = getAudioContext();
	  const audioBufferPromise = getAudioBuffer();
	  const [audioContext, decodedBuffer] = await Promise.all([
	    audioContextPromise,
	    audioBufferPromise
	  ]);
	  const destinationNode = args.destinationNode || audioContext.destination;
	  const gainNode = audioContext.createGain();
	  gainNode.connect(destinationNode);
	  return {
	    audioContext,
	    decodedBuffer,
	    gainNode,
	    destinationNode
	  };
	}
	var Sequence = class {
	  constructor(_project, _sheet, _lengthD, _subUnitsPerUnitD, playbackController) {
	    this._project = _project;
	    this._sheet = _sheet;
	    this._lengthD = _lengthD;
	    this._subUnitsPerUnitD = _subUnitsPerUnitD;
	    __publicField(this, "address");
	    __publicField(this, "publicApi");
	    __publicField(this, "_playbackControllerBox");
	    __publicField(this, "_statePointerDerivation");
	    __publicField(this, "_positionD");
	    __publicField(this, "_positionFormatterD");
	    __publicField(this, "_playableRangeD");
	    __publicField(this, "pointer", (0, import_dataverse10.pointer)({ root: this, path: [] }));
	    __publicField(this, "$$isIdentityDerivationProvider", true);
	    __publicField(this, "closestGridPosition", (posInUnitSpace) => {
	      const subUnitsPerUnit = this.subUnitsPerUnit;
	      const gridLength = 1 / subUnitsPerUnit;
	      return parseFloat((Math.round(posInUnitSpace / gridLength) * gridLength).toFixed(3));
	    });
	    this.address = __spreadProps(__spreadValues({}, this._sheet.address), { sequenceName: "default" });
	    this.publicApi = new TheatreSequence(this);
	    this._playbackControllerBox = new import_dataverse11.Box(playbackController != null ? playbackController : new DefaultPlaybackController(coreTicker_default));
	    this._statePointerDerivation = this._playbackControllerBox.derivation.map((playbackController2) => playbackController2.statePointer);
	    this._positionD = this._statePointerDerivation.flatMap((statePointer) => (0, import_dataverse11.valueDerivation)(statePointer.position));
	    this._positionFormatterD = this._subUnitsPerUnitD.map((subUnitsPerUnit) => new TimeBasedPositionFormatter(subUnitsPerUnit));
	  }
	  getIdentityDerivation(path) {
	    if (path.length === 0) {
	      return (0, import_dataverse11.prism)(() => ({
	        length: (0, import_dataverse11.val)(this.pointer.length),
	        playing: (0, import_dataverse11.val)(this.pointer.playing),
	        position: (0, import_dataverse11.val)(this.pointer.position)
	      }));
	    }
	    if (path.length > 1) {
	      return (0, import_dataverse11.prism)(() => void 0);
	    }
	    const [prop] = path;
	    if (prop === "length") {
	      return this._lengthD;
	    } else if (prop === "position") {
	      return this._positionD;
	    } else if (prop === "playing") {
	      return (0, import_dataverse11.prism)(() => {
	        return (0, import_dataverse11.val)(this._statePointerDerivation.getValue().playing);
	      });
	    } else {
	      return (0, import_dataverse11.prism)(() => void 0);
	    }
	  }
	  get positionFormatter() {
	    return this._positionFormatterD.getValue();
	  }
	  get derivationToStatePointer() {
	    return this._statePointerDerivation;
	  }
	  get length() {
	    return this._lengthD.getValue();
	  }
	  get positionDerivation() {
	    return this._positionD;
	  }
	  get position() {
	    return this._playbackControllerBox.get().getCurrentPosition();
	  }
	  get subUnitsPerUnit() {
	    return this._subUnitsPerUnitD.getValue();
	  }
	  get positionSnappedToGrid() {
	    return this.closestGridPosition(this.position);
	  }
	  set position(requestedPosition) {
	    let position = requestedPosition;
	    this.pause();
	    if (position > this.length) {
	      position = this.length;
	    }
	    const dur = this.length;
	    this._playbackControllerBox.get().gotoPosition(position > dur ? dur : position);
	  }
	  getDurationCold() {
	    return this._lengthD.getValue();
	  }
	  get playing() {
	    return (0, import_dataverse11.val)(this._playbackControllerBox.get().statePointer.playing);
	  }
	  _makeRangeFromSequenceTemplate() {
	    return (0, import_dataverse11.prism)(() => {
	      return [0, (0, import_dataverse11.val)(this._lengthD)];
	    });
	  }
	  async play(conf) {
	    const sequenceDuration = this.length;
	    const range = conf && conf.range ? conf.range : [0, sequenceDuration];
	    const iterationCount = conf && typeof conf.iterationCount === "number" ? conf.iterationCount : 1;
	    const rate = conf && typeof conf.rate !== "undefined" ? conf.rate : 1;
	    const direction = conf && conf.direction ? conf.direction : "normal";
	    return await this._play(iterationCount, [range[0], range[1]], rate, direction);
	  }
	  _play(iterationCount, range, rate, direction) {
	    return this._playbackControllerBox.get().play(iterationCount, range, rate, direction);
	  }
	  pause() {
	    this._playbackControllerBox.get().pause();
	  }
	  replacePlaybackController(playbackController) {
	    this.pause();
	    const oldController = this._playbackControllerBox.get();
	    this._playbackControllerBox.set(playbackController);
	    const time = oldController.getCurrentPosition();
	    oldController.destroy();
	    playbackController.gotoPosition(time);
	  }
	};
	var TimeBasedPositionFormatter = class {
	  constructor(_fps) {
	    this._fps = _fps;
	  }
	  formatSubUnitForGrid(posInUnitSpace) {
	    const subSecondPos = posInUnitSpace % 1;
	    const frame = 1 / this._fps;
	    const frames = Math.round(subSecondPos / frame);
	    return frames + "f";
	  }
	  formatFullUnitForGrid(posInUnitSpace) {
	    let p2 = posInUnitSpace;
	    let s2 = "";
	    if (p2 >= hour) {
	      const hours = Math.floor(p2 / hour);
	      s2 += hours + "h";
	      p2 = p2 % hour;
	    }
	    if (p2 >= minute) {
	      const minutes = Math.floor(p2 / minute);
	      s2 += minutes + "m";
	      p2 = p2 % minute;
	    }
	    if (p2 >= second) {
	      const seconds = Math.floor(p2 / second);
	      s2 += seconds + "s";
	      p2 = p2 % second;
	    }
	    const frame = 1 / this._fps;
	    if (p2 >= frame) {
	      const frames = Math.floor(p2 / frame);
	      s2 += frames + "f";
	      p2 = p2 % frame;
	    }
	    return s2.length === 0 ? "0s" : s2;
	  }
	  formatForPlayhead(posInUnitSpace) {
	    let p2 = posInUnitSpace;
	    let s2 = "";
	    if (p2 >= hour) {
	      const hours = Math.floor(p2 / hour);
	      s2 += padStart_default(hours.toString(), 2, "0") + "h";
	      p2 = p2 % hour;
	    }
	    if (p2 >= minute) {
	      const minutes = Math.floor(p2 / minute);
	      s2 += padStart_default(minutes.toString(), 2, "0") + "m";
	      p2 = p2 % minute;
	    } else if (s2.length > 0) {
	      s2 += "00m";
	    }
	    if (p2 >= second) {
	      const seconds = Math.floor(p2 / second);
	      s2 += padStart_default(seconds.toString(), 2, "0") + "s";
	      p2 = p2 % second;
	    } else {
	      s2 += "00s";
	    }
	    const frameLength = 1 / this._fps;
	    if (p2 >= frameLength) {
	      const frames = Math.round(p2 / frameLength);
	      s2 += padStart_default(frames.toString(), 2, "0") + "f";
	      p2 = p2 % frameLength;
	    } else if (p2 / frameLength > 0.98) {
	      const frames = 1;
	      s2 += padStart_default(frames.toString(), 2, "0") + "f";
	      p2 = p2 % frameLength;
	    } else {
	      s2 += "00f";
	    }
	    return s2.length === 0 ? "00s00f" : s2;
	  }
	  formatBasic(posInUnitSpace) {
	    return posInUnitSpace.toFixed(2) + "s";
	  }
	};
	var second = 1;
	var minute = second * 60;
	var hour = minute * 60;

	// core/src/propTypes/index.ts
	var propTypes_exports = {};
	__export(propTypes_exports, {
	  boolean: () => boolean,
	  compound: () => compound,
	  number: () => number,
	  string: () => string,
	  stringLiteral: () => stringLiteral
	});

	// shared/src/utils/ellipsify.ts
	function ellipsify(str, maxLength) {
	  if (str.length <= maxLength)
	    return str;
	  return str.substr(0, maxLength - 3) + "...";
	}

	// shared/src/utils/userReadableTypeOfValue.ts
	var userReadableTypeOfValue = (v2) => {
	  if (typeof v2 === "string") {
	    return `string("${ellipsify(v2, 10)}")`;
	  } else if (typeof v2 === "number") {
	    return `number(${ellipsify(String(v2), 10)})`;
	  } else if (v2 === null) {
	    return "null";
	  } else if (v2 === void 0) {
	    return "undefined";
	  } else if (typeof v2 === "boolean") {
	    return String(v2);
	  } else if (Array.isArray(v2)) {
	    return "array";
	  } else if (typeof v2 === "object") {
	    return "object";
	  } else {
	    return "unknown";
	  }
	};
	var userReadableTypeOfValue_default = userReadableTypeOfValue;

	// core/src/propTypes/internals.ts
	var propTypeSymbol = Symbol("TheatrePropType_Basic");
	function isLonghandPropType(t3) {
	  return typeof t3 === "object" && !!t3 && t3[propTypeSymbol] === "TheatrePropType";
	}
	function toLonghandProp(p2) {
	  if (typeof p2 === "number") {
	    return number(p2);
	  } else if (typeof p2 === "boolean") {
	    return boolean(p2);
	  } else if (typeof p2 === "string") {
	    return string(p2);
	  } else if (typeof p2 === "object" && !!p2) {
	    if (isLonghandPropType(p2))
	      return p2;
	    if (isPlainObject_default(p2)) {
	      return compound(p2);
	    } else {
	      throw new InvalidArgumentError(`This value is not a valid prop type: ${userReadableTypeOfValue_default(p2)}`);
	    }
	  } else {
	    throw new InvalidArgumentError(`This value is not a valid prop type: ${userReadableTypeOfValue_default(p2)}`);
	  }
	}
	function sanitizeCompoundProps(props) {
	  const sanitizedProps = {};
	  for (const key of Object.keys(props)) {
	    const val7 = props[key];
	    if (isLonghandPropType(val7)) {
	      sanitizedProps[key] = val7;
	    } else {
	      sanitizedProps[key] = toLonghandProp(val7);
	    }
	  }
	  return sanitizedProps;
	}
	var compound = (props, opts) => {
	  return {
	    type: "compound",
	    props: sanitizeCompoundProps(props),
	    valueType: null,
	    [propTypeSymbol]: "TheatrePropType",
	    label: opts == null ? void 0 : opts.label
	  };
	};
	var number = (defaultValue, opts) => {
	  var _a;
	  return __spreadProps(__spreadValues({
	    type: "number",
	    valueType: 0,
	    default: defaultValue,
	    [propTypeSymbol]: "TheatrePropType"
	  }, opts ? opts : {}), {
	    label: opts == null ? void 0 : opts.label,
	    nudgeFn: (_a = opts == null ? void 0 : opts.nudgeFn) != null ? _a : defaultNumberNudgeFn,
	    nudgeMultiplier: typeof (opts == null ? void 0 : opts.nudgeMultiplier) === "number" ? opts.nudgeMultiplier : 1
	  });
	};
	var boolean = (defaultValue, opts) => {
	  return {
	    type: "boolean",
	    default: defaultValue,
	    valueType: null,
	    [propTypeSymbol]: "TheatrePropType",
	    label: opts == null ? void 0 : opts.label
	  };
	};
	var string = (defaultValue, opts) => {
	  return {
	    type: "string",
	    default: defaultValue,
	    valueType: null,
	    [propTypeSymbol]: "TheatrePropType",
	    label: opts == null ? void 0 : opts.label
	  };
	};
	function stringLiteral(defaultValue, options, opts) {
	  var _a;
	  return {
	    type: "stringLiteral",
	    default: defaultValue,
	    options: __spreadValues({}, options),
	    [propTypeSymbol]: "TheatrePropType",
	    valueType: null,
	    as: (_a = opts == null ? void 0 : opts.as) != null ? _a : "menu",
	    label: opts == null ? void 0 : opts.label
	  };
	}
	var defaultNumberNudgeFn = ({
	  config,
	  deltaX,
	  deltaFraction,
	  magnitude
	}) => {
	  const { range } = config;
	  if (range) {
	    return deltaFraction * (range[1] - range[0]) * magnitude * config.nudgeMultiplier;
	  }
	  return deltaX * magnitude * config.nudgeMultiplier;
	};

	// shared/src/utils/slashedPaths.ts
	var sanifySlashedPath = (p2) => p2.replace(/^[\s\/]*/, "").replace(/[\s\/]*$/, "").replace(/\s*\/\s*/, " / ");
	function validateAndSanitiseSlashedPathOrThrow(unsanitisedPath, fnName) {
	  const sanitisedPath = sanifySlashedPath(unsanitisedPath);
	  {
	    return sanitisedPath;
	  }
	}

	// core/src/sheets/TheatreSheet.ts
	__toModule(require_fast_deep_equal());
	var TheatreSheet = class {
	  get type() {
	    return "Theatre_Sheet_PublicAPI";
	  }
	  constructor(sheet) {
	    setPrivateAPI(this, sheet);
	  }
	  object(key, config) {
	    const internal = privateAPI(this);
	    const sanitizedPath = validateAndSanitiseSlashedPathOrThrow(key);
	    const existingObject = internal.getObject(sanitizedPath);
	    const nativeObject = null;
	    if (existingObject) {
	      return existingObject.publicApi;
	    } else {
	      const sanitizedConfig = compound(config);
	      const object = internal.createObject(sanitizedPath, nativeObject, sanitizedConfig);
	      return object.publicApi;
	    }
	  }
	  get sequence() {
	    return privateAPI(this).getSequence().publicApi;
	  }
	  get project() {
	    return privateAPI(this).project.publicApi;
	  }
	  get address() {
	    return __spreadValues({}, privateAPI(this).address);
	  }
	};

	// core/src/sheets/Sheet.ts
	var import_dataverse12 = __toModule(dist$1);
	var Sheet = class {
	  constructor(template, instanceId) {
	    this.template = template;
	    this.instanceId = instanceId;
	    __publicField(this, "_objects", new import_dataverse12.Atom({}));
	    __publicField(this, "_sequence");
	    __publicField(this, "address");
	    __publicField(this, "publicApi");
	    __publicField(this, "project");
	    __publicField(this, "objectsP", this._objects.pointer);
	    __publicField(this, "type", "Theatre_Sheet");
	    this.project = template.project;
	    this.address = __spreadProps(__spreadValues({}, template.address), {
	      sheetInstanceId: this.instanceId
	    });
	    this.publicApi = new TheatreSheet(this);
	  }
	  createObject(key, nativeObject, config) {
	    const objTemplate = this.template.getObjectTemplate(key, nativeObject, config);
	    const object = objTemplate.createInstance(this, nativeObject, config);
	    this._objects.setIn([key], object);
	    return object;
	  }
	  getObject(key) {
	    return this._objects.getState()[key];
	  }
	  getSequence() {
	    if (!this._sequence) {
	      const lengthD = (0, import_dataverse12.valueDerivation)(this.project.pointers.historic.sheetsById[this.address.sheetId].sequence.length).map((s2) => typeof s2 === "number" ? s2 : 10);
	      const subUnitsPerUnitD = (0, import_dataverse12.valueDerivation)(this.project.pointers.historic.sheetsById[this.address.sheetId].sequence.subUnitsPerUnit).map((s2) => typeof s2 === "number" ? s2 : 30);
	      this._sequence = new Sequence(this.template.project, this, lengthD, subUnitsPerUnitD);
	    }
	    return this._sequence;
	  }
	};

	// core/src/sheets/SheetTemplate.ts
	var SheetTemplate = class {
	  constructor(project, sheetId) {
	    this.project = project;
	    __publicField(this, "type", "Theatre_SheetTemplate");
	    __publicField(this, "address");
	    __publicField(this, "_instances", new import_dataverse13.Atom({}));
	    __publicField(this, "instancesP", this._instances.pointer);
	    __publicField(this, "_objectTemplates", new import_dataverse13.Atom({}));
	    __publicField(this, "objectTemplatesP", this._objectTemplates.pointer);
	    this.address = __spreadProps(__spreadValues({}, project.address), { sheetId });
	  }
	  getInstance(instanceId) {
	    let inst = this._instances.getState()[instanceId];
	    if (!inst) {
	      inst = new Sheet(this, instanceId);
	      this._instances.setIn([instanceId], inst);
	    }
	    return inst;
	  }
	  getObjectTemplate(key, nativeObject, config) {
	    let template = this._objectTemplates.getState()[key];
	    if (!template) {
	      template = new SheetObjectTemplate(this, key, nativeObject, config);
	      this._objectTemplates.setIn([key], template);
	    }
	    return template;
	  }
	};

	// core/src/projects/Project.ts
	var import_dataverse14 = __toModule(dist$1);
	var import_dataverse15 = __toModule(dist$1);

	// shared/src/utils/delay.ts
	var delay = (dur) => new Promise((resolve) => setTimeout(resolve, dur));
	var delay_default = delay;

	// ../node_modules/immer/dist/immer.esm.js
	function n(n2) {
	  for (var t3 = arguments.length, r2 = Array(t3 > 1 ? t3 - 1 : 0), e2 = 1; e2 < t3; e2++)
	    r2[e2 - 1] = arguments[e2];
	  throw Error("[Immer] minified error nr: " + n2 + (r2.length ? " " + r2.map(function(n3) {
	    return "'" + n3 + "'";
	  }).join(",") : "") + ". Find the full error at: https://bit.ly/3cXEKWf");
	}
	function t2(n2) {
	  return !!n2 && !!n2[Q];
	}
	function r(n2) {
	  return !!n2 && (function(n3) {
	    if (!n3 || typeof n3 != "object")
	      return false;
	    var t3 = Object.getPrototypeOf(n3);
	    if (t3 === null)
	      return true;
	    var r2 = Object.hasOwnProperty.call(t3, "constructor") && t3.constructor;
	    return r2 === Object || typeof r2 == "function" && Function.toString.call(r2) === Z;
	  }(n2) || Array.isArray(n2) || !!n2[L] || !!n2.constructor[L] || s(n2) || v(n2));
	}
	function e(r2) {
	  return t2(r2) || n(23, r2), r2[Q].t;
	}
	function i(n2, t3, r2) {
	  r2 === void 0 && (r2 = false), o(n2) === 0 ? (r2 ? Object.keys : nn)(n2).forEach(function(e2) {
	    r2 && typeof e2 == "symbol" || t3(e2, n2[e2], n2);
	  }) : n2.forEach(function(r3, e2) {
	    return t3(e2, r3, n2);
	  });
	}
	function o(n2) {
	  var t3 = n2[Q];
	  return t3 ? t3.i > 3 ? t3.i - 4 : t3.i : Array.isArray(n2) ? 1 : s(n2) ? 2 : v(n2) ? 3 : 0;
	}
	function u(n2, t3) {
	  return o(n2) === 2 ? n2.has(t3) : Object.prototype.hasOwnProperty.call(n2, t3);
	}
	function a(n2, t3) {
	  return o(n2) === 2 ? n2.get(t3) : n2[t3];
	}
	function f(n2, t3, r2) {
	  var e2 = o(n2);
	  e2 === 2 ? n2.set(t3, r2) : e2 === 3 ? (n2.delete(t3), n2.add(r2)) : n2[t3] = r2;
	}
	function c(n2, t3) {
	  return n2 === t3 ? n2 !== 0 || 1 / n2 == 1 / t3 : n2 != n2 && t3 != t3;
	}
	function s(n2) {
	  return X && n2 instanceof Map;
	}
	function v(n2) {
	  return q && n2 instanceof Set;
	}
	function p(n2) {
	  return n2.o || n2.t;
	}
	function l(n2) {
	  if (Array.isArray(n2))
	    return Array.prototype.slice.call(n2);
	  var t3 = tn(n2);
	  delete t3[Q];
	  for (var r2 = nn(t3), e2 = 0; e2 < r2.length; e2++) {
	    var i2 = r2[e2], o2 = t3[i2];
	    o2.writable === false && (o2.writable = true, o2.configurable = true), (o2.get || o2.set) && (t3[i2] = { configurable: true, writable: true, enumerable: o2.enumerable, value: n2[i2] });
	  }
	  return Object.create(Object.getPrototypeOf(n2), t3);
	}
	function d(n2, e2) {
	  return e2 === void 0 && (e2 = false), y(n2) || t2(n2) || !r(n2) ? n2 : (o(n2) > 1 && (n2.set = n2.add = n2.clear = n2.delete = h), Object.freeze(n2), e2 && i(n2, function(n3, t3) {
	    return d(t3, true);
	  }, true), n2);
	}
	function h() {
	  n(2);
	}
	function y(n2) {
	  return n2 == null || typeof n2 != "object" || Object.isFrozen(n2);
	}
	function b(t3) {
	  var r2 = rn[t3];
	  return r2 || n(18, t3), r2;
	}
	function _() {
	  return U;
	}
	function j(n2, t3) {
	  t3 && (b("Patches"), n2.u = [], n2.s = [], n2.v = t3);
	}
	function O(n2) {
	  g(n2), n2.p.forEach(S), n2.p = null;
	}
	function g(n2) {
	  n2 === U && (U = n2.l);
	}
	function w(n2) {
	  return U = { p: [], l: U, h: n2, m: true, _: 0 };
	}
	function S(n2) {
	  var t3 = n2[Q];
	  t3.i === 0 || t3.i === 1 ? t3.j() : t3.O = true;
	}
	function P(t3, e2) {
	  e2._ = e2.p.length;
	  var i2 = e2.p[0], o2 = t3 !== void 0 && t3 !== i2;
	  return e2.h.g || b("ES5").S(e2, t3, o2), o2 ? (i2[Q].P && (O(e2), n(4)), r(t3) && (t3 = M(e2, t3), e2.l || x(e2, t3)), e2.u && b("Patches").M(i2[Q], t3, e2.u, e2.s)) : t3 = M(e2, i2, []), O(e2), e2.u && e2.v(e2.u, e2.s), t3 !== H ? t3 : void 0;
	}
	function M(n2, t3, r2) {
	  if (y(t3))
	    return t3;
	  var e2 = t3[Q];
	  if (!e2)
	    return i(t3, function(i2, o3) {
	      return A(n2, e2, t3, i2, o3, r2);
	    }, true), t3;
	  if (e2.A !== n2)
	    return t3;
	  if (!e2.P)
	    return x(n2, e2.t, true), e2.t;
	  if (!e2.I) {
	    e2.I = true, e2.A._--;
	    var o2 = e2.i === 4 || e2.i === 5 ? e2.o = l(e2.k) : e2.o;
	    i(e2.i === 3 ? new Set(o2) : o2, function(t4, i2) {
	      return A(n2, e2, o2, t4, i2, r2);
	    }), x(n2, o2, false), r2 && n2.u && b("Patches").R(e2, r2, n2.u, n2.s);
	  }
	  return e2.o;
	}
	function A(e2, i2, o2, a2, c2, s2) {
	  if (t2(c2)) {
	    var v2 = M(e2, c2, s2 && i2 && i2.i !== 3 && !u(i2.D, a2) ? s2.concat(a2) : void 0);
	    if (f(o2, a2, v2), !t2(v2))
	      return;
	    e2.m = false;
	  }
	  if (r(c2) && !y(c2)) {
	    if (!e2.h.F && e2._ < 1)
	      return;
	    M(e2, c2), i2 && i2.A.l || x(e2, c2);
	  }
	}
	function x(n2, t3, r2) {
	  r2 === void 0 && (r2 = false), n2.h.F && n2.m && d(t3, r2);
	}
	function z(n2, t3) {
	  var r2 = n2[Q];
	  return (r2 ? p(r2) : n2)[t3];
	}
	function I(n2, t3) {
	  if (t3 in n2)
	    for (var r2 = Object.getPrototypeOf(n2); r2; ) {
	      var e2 = Object.getOwnPropertyDescriptor(r2, t3);
	      if (e2)
	        return e2;
	      r2 = Object.getPrototypeOf(r2);
	    }
	}
	function k(n2) {
	  n2.P || (n2.P = true, n2.l && k(n2.l));
	}
	function E(n2) {
	  n2.o || (n2.o = l(n2.t));
	}
	function R(n2, t3, r2) {
	  var e2 = s(t3) ? b("MapSet").N(t3, r2) : v(t3) ? b("MapSet").T(t3, r2) : n2.g ? function(n3, t4) {
	    var r3 = Array.isArray(n3), e3 = { i: r3 ? 1 : 0, A: t4 ? t4.A : _(), P: false, I: false, D: {}, l: t4, t: n3, k: null, o: null, j: null, C: false }, i2 = e3, o2 = en;
	    r3 && (i2 = [e3], o2 = on);
	    var u2 = Proxy.revocable(i2, o2), a2 = u2.revoke, f2 = u2.proxy;
	    return e3.k = f2, e3.j = a2, f2;
	  }(t3, r2) : b("ES5").J(t3, r2);
	  return (r2 ? r2.A : _()).p.push(e2), e2;
	}
	function D(e2) {
	  return t2(e2) || n(22, e2), function n2(t3) {
	    if (!r(t3))
	      return t3;
	    var e3, u2 = t3[Q], c2 = o(t3);
	    if (u2) {
	      if (!u2.P && (u2.i < 4 || !b("ES5").K(u2)))
	        return u2.t;
	      u2.I = true, e3 = F(t3, c2), u2.I = false;
	    } else
	      e3 = F(t3, c2);
	    return i(e3, function(t4, r2) {
	      u2 && a(u2.t, t4) === r2 || f(e3, t4, n2(r2));
	    }), c2 === 3 ? new Set(e3) : e3;
	  }(e2);
	}
	function F(n2, t3) {
	  switch (t3) {
	    case 2:
	      return new Map(n2);
	    case 3:
	      return Array.from(n2);
	  }
	  return l(n2);
	}
	var G;
	var U;
	var W = typeof Symbol != "undefined" && typeof Symbol("x") == "symbol";
	var X = typeof Map != "undefined";
	var q = typeof Set != "undefined";
	var B = typeof Proxy != "undefined" && Proxy.revocable !== void 0 && typeof Reflect != "undefined";
	var H = W ? Symbol.for("immer-nothing") : ((G = {})["immer-nothing"] = true, G);
	var L = W ? Symbol.for("immer-draftable") : "__$immer_draftable";
	var Q = W ? Symbol.for("immer-state") : "__$immer_state";
	var Z = "" + Object.prototype.constructor;
	var nn = typeof Reflect != "undefined" && Reflect.ownKeys ? Reflect.ownKeys : Object.getOwnPropertySymbols !== void 0 ? function(n2) {
	  return Object.getOwnPropertyNames(n2).concat(Object.getOwnPropertySymbols(n2));
	} : Object.getOwnPropertyNames;
	var tn = Object.getOwnPropertyDescriptors || function(n2) {
	  var t3 = {};
	  return nn(n2).forEach(function(r2) {
	    t3[r2] = Object.getOwnPropertyDescriptor(n2, r2);
	  }), t3;
	};
	var rn = {};
	var en = { get: function(n2, t3) {
	  if (t3 === Q)
	    return n2;
	  var e2 = p(n2);
	  if (!u(e2, t3))
	    return function(n3, t4, r2) {
	      var e3, i3 = I(t4, r2);
	      return i3 ? "value" in i3 ? i3.value : (e3 = i3.get) === null || e3 === void 0 ? void 0 : e3.call(n3.k) : void 0;
	    }(n2, e2, t3);
	  var i2 = e2[t3];
	  return n2.I || !r(i2) ? i2 : i2 === z(n2.t, t3) ? (E(n2), n2.o[t3] = R(n2.A.h, i2, n2)) : i2;
	}, has: function(n2, t3) {
	  return t3 in p(n2);
	}, ownKeys: function(n2) {
	  return Reflect.ownKeys(p(n2));
	}, set: function(n2, t3, r2) {
	  var e2 = I(p(n2), t3);
	  if (e2 == null ? void 0 : e2.set)
	    return e2.set.call(n2.k, r2), true;
	  if (!n2.P) {
	    var i2 = z(p(n2), t3), o2 = i2 == null ? void 0 : i2[Q];
	    if (o2 && o2.t === r2)
	      return n2.o[t3] = r2, n2.D[t3] = false, true;
	    if (c(r2, i2) && (r2 !== void 0 || u(n2.t, t3)))
	      return true;
	    E(n2), k(n2);
	  }
	  return n2.o[t3] === r2 && typeof r2 != "number" && (r2 !== void 0 || t3 in n2.o) || (n2.o[t3] = r2, n2.D[t3] = true, true);
	}, deleteProperty: function(n2, t3) {
	  return z(n2.t, t3) !== void 0 || t3 in n2.t ? (n2.D[t3] = false, E(n2), k(n2)) : delete n2.D[t3], n2.o && delete n2.o[t3], true;
	}, getOwnPropertyDescriptor: function(n2, t3) {
	  var r2 = p(n2), e2 = Reflect.getOwnPropertyDescriptor(r2, t3);
	  return e2 ? { writable: true, configurable: n2.i !== 1 || t3 !== "length", enumerable: e2.enumerable, value: r2[t3] } : e2;
	}, defineProperty: function() {
	  n(11);
	}, getPrototypeOf: function(n2) {
	  return Object.getPrototypeOf(n2.t);
	}, setPrototypeOf: function() {
	  n(12);
	} };
	var on = {};
	i(en, function(n2, t3) {
	  on[n2] = function() {
	    return arguments[0] = arguments[0][0], t3.apply(this, arguments);
	  };
	}), on.deleteProperty = function(t3, r2) {
	  return en.deleteProperty.call(this, t3[0], r2);
	}, on.set = function(t3, r2, e2) {
	  return en.set.call(this, t3[0], r2, e2, t3[0]);
	};
	var un = function() {
	  function e2(t3) {
	    var e3 = this;
	    this.g = B, this.F = true, this.produce = function(t4, i3, o2) {
	      if (typeof t4 == "function" && typeof i3 != "function") {
	        var u2 = i3;
	        i3 = t4;
	        var a2 = e3;
	        return function(n2) {
	          var t5 = this;
	          n2 === void 0 && (n2 = u2);
	          for (var r2 = arguments.length, e4 = Array(r2 > 1 ? r2 - 1 : 0), o3 = 1; o3 < r2; o3++)
	            e4[o3 - 1] = arguments[o3];
	          return a2.produce(n2, function(n3) {
	            var r3;
	            return (r3 = i3).call.apply(r3, [t5, n3].concat(e4));
	          });
	        };
	      }
	      var f2;
	      if (typeof i3 != "function" && n(6), o2 !== void 0 && typeof o2 != "function" && n(7), r(t4)) {
	        var c2 = w(e3), s2 = R(e3, t4, void 0), v2 = true;
	        try {
	          f2 = i3(s2), v2 = false;
	        } finally {
	          v2 ? O(c2) : g(c2);
	        }
	        return typeof Promise != "undefined" && f2 instanceof Promise ? f2.then(function(n2) {
	          return j(c2, o2), P(n2, c2);
	        }, function(n2) {
	          throw O(c2), n2;
	        }) : (j(c2, o2), P(f2, c2));
	      }
	      if (!t4 || typeof t4 != "object") {
	        if ((f2 = i3(t4)) === H)
	          return;
	        return f2 === void 0 && (f2 = t4), e3.F && d(f2, true), f2;
	      }
	      n(21, t4);
	    }, this.produceWithPatches = function(n2, t4) {
	      return typeof n2 == "function" ? function(t5) {
	        for (var r3 = arguments.length, i4 = Array(r3 > 1 ? r3 - 1 : 0), o2 = 1; o2 < r3; o2++)
	          i4[o2 - 1] = arguments[o2];
	        return e3.produceWithPatches(t5, function(t6) {
	          return n2.apply(void 0, [t6].concat(i4));
	        });
	      } : [e3.produce(n2, t4, function(n3, t5) {
	        r2 = n3, i3 = t5;
	      }), r2, i3];
	      var r2, i3;
	    }, typeof (t3 == null ? void 0 : t3.useProxies) == "boolean" && this.setUseProxies(t3.useProxies), typeof (t3 == null ? void 0 : t3.autoFreeze) == "boolean" && this.setAutoFreeze(t3.autoFreeze);
	  }
	  var i2 = e2.prototype;
	  return i2.createDraft = function(e3) {
	    r(e3) || n(8), t2(e3) && (e3 = D(e3));
	    var i3 = w(this), o2 = R(this, e3, void 0);
	    return o2[Q].C = true, g(i3), o2;
	  }, i2.finishDraft = function(t3, r2) {
	    var e3 = t3 && t3[Q];
	    var i3 = e3.A;
	    return j(i3, r2), P(void 0, i3);
	  }, i2.setAutoFreeze = function(n2) {
	    this.F = n2;
	  }, i2.setUseProxies = function(t3) {
	    t3 && !B && n(20), this.g = t3;
	  }, i2.applyPatches = function(n2, r2) {
	    var e3;
	    for (e3 = r2.length - 1; e3 >= 0; e3--) {
	      var i3 = r2[e3];
	      if (i3.path.length === 0 && i3.op === "replace") {
	        n2 = i3.value;
	        break;
	      }
	    }
	    var o2 = b("Patches").$;
	    return t2(n2) ? o2(n2, r2) : this.produce(n2, function(n3) {
	      return o2(n3, r2.slice(e3 + 1));
	    });
	  }, e2;
	}();
	var an = new un();
	an.produce;
	an.produceWithPatches.bind(an);
	an.setAutoFreeze.bind(an);
	an.setUseProxies.bind(an);
	an.applyPatches.bind(an);
	an.createDraft.bind(an);
	an.finishDraft.bind(an);

	// shared/src/globals.ts
	var globals = {
	  currentProjectStateDefinitionVersion: "0.4.0"
	};
	var globals_default = globals;

	// core/src/projects/initialiseProjectState.ts
	async function initialiseProjectState(studio, project, onDiskState) {
	  await delay_default(0);
	  studio.transaction(({ drafts }) => {
	    var _a;
	    const projectId = project.address.projectId;
	    drafts.ephemeral.coreByProject[projectId] = {
	      lastExportedObject: null,
	      loadingState: { type: "loading" }
	    };
	    drafts.ahistoric.coreByProject[projectId] = {
	      ahistoricStuff: ""
	    };
	    function useInitialState() {
	      drafts.ephemeral.coreByProject[projectId].loadingState = {
	        type: "loaded"
	      };
	      drafts.historic.coreByProject[projectId] = {
	        sheetsById: {},
	        definitionVersion: globals_default.currentProjectStateDefinitionVersion,
	        revisionHistory: []
	      };
	    }
	    function useOnDiskState(state) {
	      drafts.ephemeral.coreByProject[projectId].loadingState = {
	        type: "loaded"
	      };
	      drafts.historic.coreByProject[projectId] = state;
	    }
	    function useBrowserState() {
	      drafts.ephemeral.coreByProject[projectId].loadingState = {
	        type: "loaded"
	      };
	    }
	    function browserStateIsNotBasedOnDiskState(onDiskState2) {
	      drafts.ephemeral.coreByProject[projectId].loadingState = {
	        type: "browserStateIsNotBasedOnDiskState",
	        onDiskState: onDiskState2
	      };
	    }
	    const browserState = (_a = e(drafts.historic)) == null ? void 0 : _a.coreByProject[project.address.projectId];
	    if (!browserState) {
	      if (!onDiskState) {
	        useInitialState();
	      } else {
	        useOnDiskState(onDiskState);
	      }
	    } else {
	      if (!onDiskState) {
	        useBrowserState();
	      } else {
	        if (browserState.revisionHistory.indexOf(onDiskState.revisionHistory[0]) == -1) {
	          browserStateIsNotBasedOnDiskState(onDiskState);
	        } else {
	          useBrowserState();
	        }
	      }
	    }
	  });
	}

	// core/src/projects/Project.ts
	var Project = class {
	  constructor(id, config = {}, publicApi) {
	    this.config = config;
	    this.publicApi = publicApi;
	    __publicField(this, "pointers");
	    __publicField(this, "_pointerProxies");
	    __publicField(this, "address");
	    __publicField(this, "_readyDeferred");
	    __publicField(this, "_sheetTemplates", new import_dataverse15.Atom({}));
	    __publicField(this, "sheetTemplatesP", this._sheetTemplates.pointer);
	    __publicField(this, "_studio");
	    __publicField(this, "type", "Theatre_Project");
	    var _a;
	    this.address = { projectId: id };
	    const onDiskStateAtom = new import_dataverse15.Atom({
	      ahistoric: {
	        ahistoricStuff: ""
	      },
	      historic: (_a = config.state) != null ? _a : {
	        sheetsById: {},
	        definitionVersion: globals_default.currentProjectStateDefinitionVersion,
	        revisionHistory: []
	      },
	      ephemeral: {
	        loadingState: {
	          type: "loaded"
	        },
	        lastExportedObject: null
	      }
	    });
	    this._pointerProxies = {
	      historic: new import_dataverse14.PointerProxy(onDiskStateAtom.pointer.historic),
	      ahistoric: new import_dataverse14.PointerProxy(onDiskStateAtom.pointer.ahistoric),
	      ephemeral: new import_dataverse14.PointerProxy(onDiskStateAtom.pointer.ephemeral)
	    };
	    this.pointers = {
	      historic: this._pointerProxies.historic.pointer,
	      ahistoric: this._pointerProxies.ahistoric.pointer,
	      ephemeral: this._pointerProxies.ephemeral.pointer
	    };
	    projectsSingleton_default.add(id, this);
	    this._readyDeferred = defer();
	    if (config.state) {
	      setTimeout(() => {
	        if (!this._studio) {
	          this._readyDeferred.resolve(void 0);
	        }
	      }, 0);
	    } else {
	      setTimeout(() => {
	        if (!this._studio) {
	          throw new Error(`Argument config.state in Theatre.getProject("${id}", config) is empty. This is fine while you are using @theatre/core along with @theatre/sutdio. But since @theatre/studio is not loaded, the state of project "${id}" will be empty.

To fix this, you need to add @theatre/studio into the bundle and export the projet's state. Learn how to do that at https://docs.theatrejs.com/in-depth/#exporting`);
	        }
	      }, 1e3);
	    }
	  }
	  attachToStudio(studio) {
	    if (this._studio) {
	      if (this._studio !== studio) {
	        throw new Error(`Project ${this.address.projectId} is already attached to studio ${this._studio.address.studioId}`);
	      } else {
	        console.warn(`Project ${this.address.projectId} is already attached to studio ${this._studio.address.studioId}`);
	        return;
	      }
	    }
	    this._studio = studio;
	    studio.initialized.then(async () => {
	      await initialiseProjectState(studio, this, this.config.state);
	      this._pointerProxies.historic.setPointer(studio.atomP.historic.coreByProject[this.address.projectId]);
	      this._pointerProxies.ahistoric.setPointer(studio.atomP.ahistoric.coreByProject[this.address.projectId]);
	      this._pointerProxies.ephemeral.setPointer(studio.atomP.ephemeral.coreByProject[this.address.projectId]);
	      this._readyDeferred.resolve(void 0);
	    });
	  }
	  get isAttachedToStudio() {
	    return !!this._studio;
	  }
	  get ready() {
	    return this._readyDeferred.promise;
	  }
	  isReady() {
	    return this._readyDeferred.status === "resolved";
	  }
	  getOrCreateSheet(sheetId, instanceId = "default") {
	    let template = this._sheetTemplates.getState()[sheetId];
	    if (!template) {
	      template = new SheetTemplate(this, sheetId);
	      this._sheetTemplates.setIn([sheetId], template);
	    }
	    return template.getInstance(instanceId);
	  }
	};

	// core/src/projects/TheatreProject.ts
	var TheatreProject = class {
	  get type() {
	    return "Theatre_Project_PublicAPI";
	  }
	  constructor(id, config = {}) {
	    setPrivateAPI(this, new Project(id, config, this));
	  }
	  get ready() {
	    return privateAPI(this).ready;
	  }
	  get isReady() {
	    return privateAPI(this).isReady();
	  }
	  get address() {
	    return __spreadValues({}, privateAPI(this).address);
	  }
	  sheet(sheetId, instanceId = "default") {
	    const sanitizedPath = validateAndSanitiseSlashedPathOrThrow(sheetId);
	    return privateAPI(this).getOrCreateSheet(sanitizedPath, instanceId).publicApi;
	  }
	};

	// core/src/coreExports.ts
	__toModule(require_fast_deep_equal());
	var import_dataverse16 = __toModule(dist$1);
	var import_dataverse17 = __toModule(dist$1);
	function getProject(id, config = {}) {
	  const restOfConfig = __objRest(config, []);
	  const existingProject = projectsSingleton_default.get(id);
	  if (existingProject) {
	    return existingProject.publicApi;
	  }
	  if (config.state) {
	    {
	      deepValidateOnDiskState(id, config.state);
	    }
	  }
	  return new TheatreProject(id, restOfConfig);
	}
	var shallowValidateOnDiskState = (projectId, s2) => {
	  if (Array.isArray(s2) || s2 == null || s2.definitionVersion !== globals_default.currentProjectStateDefinitionVersion) {
	    throw new InvalidArgumentError(`Error validating conf.state in Theatre.getProject(${JSON.stringify(projectId)}, conf). The state seems to be formatted in a way that is unreadable to Theatre.js. Read more at https://docs.theatrejs.com`);
	  }
	};
	var deepValidateOnDiskState = (projectId, s2) => {
	  shallowValidateOnDiskState(projectId, s2);
	};
	function onChange(pointer3, callback) {
	  if ((0, import_dataverse16.isPointer)(pointer3)) {
	    const derivation = (0, import_dataverse17.valueDerivation)(pointer3);
	    return derivation.tapImmediate(coreTicker_default, callback);
	  } else if ((0, import_dataverse17.isDerivation)(pointer3)) {
	    return pointer3.tapImmediate(coreTicker_default, callback);
	  } else {
	    throw new Error(`Called onChange(p) where p is neither a pointer nor a derivation.`);
	  }
	}
	function val6(pointer3) {
	  if ((0, import_dataverse16.isPointer)(pointer3)) {
	    return (0, import_dataverse17.valueDerivation)(pointer3).getValue();
	  } else {
	    throw new Error(`Called val(p) where p is not a pointer.`);
	  }
	}

	// shared/src/globalVariableNames.ts
	var studioBundle = "__TheatreJS_StudioBundle";
	var coreBundle = "__TheatreJS_CoreBundle";

	// core/src/CoreBundle.ts
	var CoreBundle = class {
	  constructor() {
	    __publicField(this, "_studio");
	  }
	  get type() {
	    return "Theatre_CoreBundle";
	  }
	  get version() {
	    return "0.4.7";
	  }
	  getBitsForStudio(studio, callback) {
	    if (this._studio) {
	      throw new Error(`@theatre/core is already attached to @theatre/studio`);
	    }
	    this._studio = studio;
	    const bits = {
	      projectsP: projectsSingleton_default.atom.pointer.projects,
	      privateAPI,
	      coreExports: coreExports_exports
	    };
	    callback(bits);
	  }
	};

	// core/src/index.ts
	registerCoreBundle();
	function registerCoreBundle() {
	  if (typeof window == "undefined")
	    return;
	  const existingBundle = window[coreBundle];
	  if (typeof existingBundle !== "undefined") {
	    if (typeof existingBundle === "object" && existingBundle && typeof existingBundle.version === "string") {
	      throw new Error(`It seems that the module '@theatre/core' is loaded more than once. This could have two possible causes:
1. You might have two separate versions of theatre in node_modules.
2. Or this might be a bundling misconfiguration, in case you're using a bundler like Webpack/ESBuild/Rollup.

Note that it **is okay** to import '@theatre/core' multiple times. But those imports should point to the same module.`);
	    } else {
	      throw new Error(`The variable window.${coreBundle} seems to be already set by a module other than @theatre/core.`);
	    }
	  }
	  const coreBundle2 = new CoreBundle();
	  window[coreBundle] = coreBundle2;
	  const possibleExistingStudioBundle = window[studioBundle];
	  if (possibleExistingStudioBundle && possibleExistingStudioBundle !== null && possibleExistingStudioBundle.type === "Theatre_StudioBundle") {
	    possibleExistingStudioBundle.registerCoreBundle(coreBundle2);
	  }
	}
	/**
	 * @license
	 * Lodash (Custom Build) <https://lodash.com/>
	 * Build: `lodash modularize exports="es" -o ./`
	 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
	 * Released under MIT license <https://lodash.com/license>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 */

	}(dist$2));

	var dist = {exports: {}};

	var react = {exports: {}};

	var react_production_min = {};

	/*
	object-assign
	(c) Sindre Sorhus
	@license MIT
	*/
	/* eslint-disable no-unused-vars */
	var getOwnPropertySymbols$1 = Object.getOwnPropertySymbols;
	var hasOwnProperty = Object.prototype.hasOwnProperty;
	var propIsEnumerable = Object.prototype.propertyIsEnumerable;

	function toObject(val) {
		if (val === null || val === undefined) {
			throw new TypeError('Object.assign cannot be called with null or undefined');
		}

		return Object(val);
	}

	function shouldUseNative() {
		try {
			if (!Object.assign) {
				return false;
			}

			// Detect buggy property enumeration order in older V8 versions.

			// https://bugs.chromium.org/p/v8/issues/detail?id=4118
			var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
			test1[5] = 'de';
			if (Object.getOwnPropertyNames(test1)[0] === '5') {
				return false;
			}

			// https://bugs.chromium.org/p/v8/issues/detail?id=3056
			var test2 = {};
			for (var i = 0; i < 10; i++) {
				test2['_' + String.fromCharCode(i)] = i;
			}
			var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
				return test2[n];
			});
			if (order2.join('') !== '0123456789') {
				return false;
			}

			// https://bugs.chromium.org/p/v8/issues/detail?id=3056
			var test3 = {};
			'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
				test3[letter] = letter;
			});
			if (Object.keys(Object.assign({}, test3)).join('') !==
					'abcdefghijklmnopqrst') {
				return false;
			}

			return true;
		} catch (err) {
			// We don't expect any of the above to throw, but better to be safe.
			return false;
		}
	}

	var objectAssign = shouldUseNative() ? Object.assign : function (target, source) {
		var from;
		var to = toObject(target);
		var symbols;

		for (var s = 1; s < arguments.length; s++) {
			from = Object(arguments[s]);

			for (var key in from) {
				if (hasOwnProperty.call(from, key)) {
					to[key] = from[key];
				}
			}

			if (getOwnPropertySymbols$1) {
				symbols = getOwnPropertySymbols$1(from);
				for (var i = 0; i < symbols.length; i++) {
					if (propIsEnumerable.call(from, symbols[i])) {
						to[symbols[i]] = from[symbols[i]];
					}
				}
			}
		}

		return to;
	};

	/** @license React v17.0.2
	 * react.production.min.js
	 *
	 * Copyright (c) Facebook, Inc. and its affiliates.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */
	var l$1=objectAssign,n$1=60103,p$1=60106;react_production_min.Fragment=60107;react_production_min.StrictMode=60108;react_production_min.Profiler=60114;var q$2=60109,r$3=60110,t$1=60112;react_production_min.Suspense=60113;var u=60115,v$2=60116;
	if("function"===typeof Symbol&&Symbol.for){var w$2=Symbol.for;n$1=w$2("react.element");p$1=w$2("react.portal");react_production_min.Fragment=w$2("react.fragment");react_production_min.StrictMode=w$2("react.strict_mode");react_production_min.Profiler=w$2("react.profiler");q$2=w$2("react.provider");r$3=w$2("react.context");t$1=w$2("react.forward_ref");react_production_min.Suspense=w$2("react.suspense");u=w$2("react.memo");v$2=w$2("react.lazy");}var x$2="function"===typeof Symbol&&Symbol.iterator;
	function y$2(a){if(null===a||"object"!==typeof a)return null;a=x$2&&a[x$2]||a["@@iterator"];return "function"===typeof a?a:null}function z$2(a){for(var b="https://reactjs.org/docs/error-decoder.html?invariant="+a,c=1;c<arguments.length;c++)b+="&args[]="+encodeURIComponent(arguments[c]);return "Minified React error #"+a+"; visit "+b+" for the full message or use the non-minified dev environment for full errors and additional helpful warnings."}
	var A$2={isMounted:function(){return !1},enqueueForceUpdate:function(){},enqueueReplaceState:function(){},enqueueSetState:function(){}},B$2={};function C$1(a,b,c){this.props=a;this.context=b;this.refs=B$2;this.updater=c||A$2;}C$1.prototype.isReactComponent={};C$1.prototype.setState=function(a,b){if("object"!==typeof a&&"function"!==typeof a&&null!=a)throw Error(z$2(85));this.updater.enqueueSetState(this,a,b,"setState");};C$1.prototype.forceUpdate=function(a){this.updater.enqueueForceUpdate(this,a,"forceUpdate");};
	function D$1(){}D$1.prototype=C$1.prototype;function E$2(a,b,c){this.props=a;this.context=b;this.refs=B$2;this.updater=c||A$2;}var F$2=E$2.prototype=new D$1;F$2.constructor=E$2;l$1(F$2,C$1.prototype);F$2.isPureReactComponent=!0;var G$2={current:null},H$2=Object.prototype.hasOwnProperty,I$2={key:!0,ref:!0,__self:!0,__source:!0};
	function J$1(a,b,c){var e,d={},k=null,h=null;if(null!=b)for(e in void 0!==b.ref&&(h=b.ref),void 0!==b.key&&(k=""+b.key),b)H$2.call(b,e)&&!I$2.hasOwnProperty(e)&&(d[e]=b[e]);var g=arguments.length-2;if(1===g)d.children=c;else if(1<g){for(var f=Array(g),m=0;m<g;m++)f[m]=arguments[m+2];d.children=f;}if(a&&a.defaultProps)for(e in g=a.defaultProps,g)void 0===d[e]&&(d[e]=g[e]);return {$$typeof:n$1,type:a,key:k,ref:h,props:d,_owner:G$2.current}}
	function K$1(a,b){return {$$typeof:n$1,type:a.type,key:b,ref:a.ref,props:a.props,_owner:a._owner}}function L$1(a){return "object"===typeof a&&null!==a&&a.$$typeof===n$1}function escape(a){var b={"=":"=0",":":"=2"};return "$"+a.replace(/[=:]/g,function(a){return b[a]})}var M$2=/\/+/g;function N$2(a,b){return "object"===typeof a&&null!==a&&null!=a.key?escape(""+a.key):b.toString(36)}
	function O$2(a,b,c,e,d){var k=typeof a;if("undefined"===k||"boolean"===k)a=null;var h=!1;if(null===a)h=!0;else switch(k){case "string":case "number":h=!0;break;case "object":switch(a.$$typeof){case n$1:case p$1:h=!0;}}if(h)return h=a,d=d(h),a=""===e?"."+N$2(h,0):e,Array.isArray(d)?(c="",null!=a&&(c=a.replace(M$2,"$&/")+"/"),O$2(d,b,c,"",function(a){return a})):null!=d&&(L$1(d)&&(d=K$1(d,c+(!d.key||h&&h.key===d.key?"":(""+d.key).replace(M$2,"$&/")+"/")+a)),b.push(d)),1;h=0;e=""===e?".":e+":";if(Array.isArray(a))for(var g=
	0;g<a.length;g++){k=a[g];var f=e+N$2(k,g);h+=O$2(k,b,c,f,d);}else if(f=y$2(a),"function"===typeof f)for(a=f.call(a),g=0;!(k=a.next()).done;)k=k.value,f=e+N$2(k,g++),h+=O$2(k,b,c,f,d);else if("object"===k)throw b=""+a,Error(z$2(31,"[object Object]"===b?"object with keys {"+Object.keys(a).join(", ")+"}":b));return h}function P$2(a,b,c){if(null==a)return a;var e=[],d=0;O$2(a,e,"","",function(a){return b.call(c,a,d++)});return e}
	function Q$1(a){if(-1===a._status){var b=a._result;b=b();a._status=0;a._result=b;b.then(function(b){0===a._status&&(b=b.default,a._status=1,a._result=b);},function(b){0===a._status&&(a._status=2,a._result=b);});}if(1===a._status)return a._result;throw a._result;}var R$1={current:null};function S$2(){var a=R$1.current;if(null===a)throw Error(z$2(321));return a}var T$2={ReactCurrentDispatcher:R$1,ReactCurrentBatchConfig:{transition:0},ReactCurrentOwner:G$2,IsSomeRendererActing:{current:!1},assign:l$1};
	react_production_min.Children={map:P$2,forEach:function(a,b,c){P$2(a,function(){b.apply(this,arguments);},c);},count:function(a){var b=0;P$2(a,function(){b++;});return b},toArray:function(a){return P$2(a,function(a){return a})||[]},only:function(a){if(!L$1(a))throw Error(z$2(143));return a}};react_production_min.Component=C$1;react_production_min.PureComponent=E$2;react_production_min.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED=T$2;
	react_production_min.cloneElement=function(a,b,c){if(null===a||void 0===a)throw Error(z$2(267,a));var e=l$1({},a.props),d=a.key,k=a.ref,h=a._owner;if(null!=b){void 0!==b.ref&&(k=b.ref,h=G$2.current);void 0!==b.key&&(d=""+b.key);if(a.type&&a.type.defaultProps)var g=a.type.defaultProps;for(f in b)H$2.call(b,f)&&!I$2.hasOwnProperty(f)&&(e[f]=void 0===b[f]&&void 0!==g?g[f]:b[f]);}var f=arguments.length-2;if(1===f)e.children=c;else if(1<f){g=Array(f);for(var m=0;m<f;m++)g[m]=arguments[m+2];e.children=g;}return {$$typeof:n$1,type:a.type,
	key:d,ref:k,props:e,_owner:h}};react_production_min.createContext=function(a,b){void 0===b&&(b=null);a={$$typeof:r$3,_calculateChangedBits:b,_currentValue:a,_currentValue2:a,_threadCount:0,Provider:null,Consumer:null};a.Provider={$$typeof:q$2,_context:a};return a.Consumer=a};react_production_min.createElement=J$1;react_production_min.createFactory=function(a){var b=J$1.bind(null,a);b.type=a;return b};react_production_min.createRef=function(){return {current:null}};react_production_min.forwardRef=function(a){return {$$typeof:t$1,render:a}};react_production_min.isValidElement=L$1;
	react_production_min.lazy=function(a){return {$$typeof:v$2,_payload:{_status:-1,_result:a},_init:Q$1}};react_production_min.memo=function(a,b){return {$$typeof:u,type:a,compare:void 0===b?null:b}};react_production_min.useCallback=function(a,b){return S$2().useCallback(a,b)};react_production_min.useContext=function(a,b){return S$2().useContext(a,b)};react_production_min.useDebugValue=function(){};react_production_min.useEffect=function(a,b){return S$2().useEffect(a,b)};react_production_min.useImperativeHandle=function(a,b,c){return S$2().useImperativeHandle(a,b,c)};
	react_production_min.useLayoutEffect=function(a,b){return S$2().useLayoutEffect(a,b)};react_production_min.useMemo=function(a,b){return S$2().useMemo(a,b)};react_production_min.useReducer=function(a,b,c){return S$2().useReducer(a,b,c)};react_production_min.useRef=function(a){return S$2().useRef(a)};react_production_min.useState=function(a){return S$2().useState(a)};react_production_min.version="17.0.2";

	{
	  react.exports = react_production_min;
	}

	var r$2 = react.exports;

	var reactDom = {exports: {}};

	var reactDom_production_min = {};

	var scheduler = {exports: {}};

	var scheduler_production_min = {};

	/** @license React v0.20.2
	 * scheduler.production.min.js
	 *
	 * Copyright (c) Facebook, Inc. and its affiliates.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */

	(function (exports) {
	var f,g,h,k;if("object"===typeof performance&&"function"===typeof performance.now){var l=performance;exports.unstable_now=function(){return l.now()};}else {var p=Date,q=p.now();exports.unstable_now=function(){return p.now()-q};}
	if("undefined"===typeof window||"function"!==typeof MessageChannel){var t=null,u=null,w=function(){if(null!==t)try{var a=exports.unstable_now();t(!0,a);t=null;}catch(b){throw setTimeout(w,0),b;}};f=function(a){null!==t?setTimeout(f,0,a):(t=a,setTimeout(w,0));};g=function(a,b){u=setTimeout(a,b);};h=function(){clearTimeout(u);};exports.unstable_shouldYield=function(){return !1};k=exports.unstable_forceFrameRate=function(){};}else {var x=window.setTimeout,y=window.clearTimeout;if("undefined"!==typeof console){var z=
	window.cancelAnimationFrame;"function"!==typeof window.requestAnimationFrame&&console.error("This browser doesn't support requestAnimationFrame. Make sure that you load a polyfill in older browsers. https://reactjs.org/link/react-polyfills");"function"!==typeof z&&console.error("This browser doesn't support cancelAnimationFrame. Make sure that you load a polyfill in older browsers. https://reactjs.org/link/react-polyfills");}var A=!1,B=null,C=-1,D=5,E=0;exports.unstable_shouldYield=function(){return exports.unstable_now()>=
	E};k=function(){};exports.unstable_forceFrameRate=function(a){0>a||125<a?console.error("forceFrameRate takes a positive int between 0 and 125, forcing frame rates higher than 125 fps is not supported"):D=0<a?Math.floor(1E3/a):5;};var F=new MessageChannel,G=F.port2;F.port1.onmessage=function(){if(null!==B){var a=exports.unstable_now();E=a+D;try{B(!0,a)?G.postMessage(null):(A=!1,B=null);}catch(b){throw G.postMessage(null),b;}}else A=!1;};f=function(a){B=a;A||(A=!0,G.postMessage(null));};g=function(a,b){C=
	x(function(){a(exports.unstable_now());},b);};h=function(){y(C);C=-1;};}function H(a,b){var c=a.length;a.push(b);a:for(;;){var d=c-1>>>1,e=a[d];if(void 0!==e&&0<I(e,b))a[d]=b,a[c]=e,c=d;else break a}}function J(a){a=a[0];return void 0===a?null:a}
	function K(a){var b=a[0];if(void 0!==b){var c=a.pop();if(c!==b){a[0]=c;a:for(var d=0,e=a.length;d<e;){var m=2*(d+1)-1,n=a[m],v=m+1,r=a[v];if(void 0!==n&&0>I(n,c))void 0!==r&&0>I(r,n)?(a[d]=r,a[v]=c,d=v):(a[d]=n,a[m]=c,d=m);else if(void 0!==r&&0>I(r,c))a[d]=r,a[v]=c,d=v;else break a}}return b}return null}function I(a,b){var c=a.sortIndex-b.sortIndex;return 0!==c?c:a.id-b.id}var L=[],M=[],N=1,O=null,P=3,Q=!1,R=!1,S=!1;
	function T(a){for(var b=J(M);null!==b;){if(null===b.callback)K(M);else if(b.startTime<=a)K(M),b.sortIndex=b.expirationTime,H(L,b);else break;b=J(M);}}function U(a){S=!1;T(a);if(!R)if(null!==J(L))R=!0,f(V);else {var b=J(M);null!==b&&g(U,b.startTime-a);}}
	function V(a,b){R=!1;S&&(S=!1,h());Q=!0;var c=P;try{T(b);for(O=J(L);null!==O&&(!(O.expirationTime>b)||a&&!exports.unstable_shouldYield());){var d=O.callback;if("function"===typeof d){O.callback=null;P=O.priorityLevel;var e=d(O.expirationTime<=b);b=exports.unstable_now();"function"===typeof e?O.callback=e:O===J(L)&&K(L);T(b);}else K(L);O=J(L);}if(null!==O)var m=!0;else {var n=J(M);null!==n&&g(U,n.startTime-b);m=!1;}return m}finally{O=null,P=c,Q=!1;}}var W=k;exports.unstable_IdlePriority=5;
	exports.unstable_ImmediatePriority=1;exports.unstable_LowPriority=4;exports.unstable_NormalPriority=3;exports.unstable_Profiling=null;exports.unstable_UserBlockingPriority=2;exports.unstable_cancelCallback=function(a){a.callback=null;};exports.unstable_continueExecution=function(){R||Q||(R=!0,f(V));};exports.unstable_getCurrentPriorityLevel=function(){return P};exports.unstable_getFirstCallbackNode=function(){return J(L)};
	exports.unstable_next=function(a){switch(P){case 1:case 2:case 3:var b=3;break;default:b=P;}var c=P;P=b;try{return a()}finally{P=c;}};exports.unstable_pauseExecution=function(){};exports.unstable_requestPaint=W;exports.unstable_runWithPriority=function(a,b){switch(a){case 1:case 2:case 3:case 4:case 5:break;default:a=3;}var c=P;P=a;try{return b()}finally{P=c;}};
	exports.unstable_scheduleCallback=function(a,b,c){var d=exports.unstable_now();"object"===typeof c&&null!==c?(c=c.delay,c="number"===typeof c&&0<c?d+c:d):c=d;switch(a){case 1:var e=-1;break;case 2:e=250;break;case 5:e=1073741823;break;case 4:e=1E4;break;default:e=5E3;}e=c+e;a={id:N++,callback:b,priorityLevel:a,startTime:c,expirationTime:e,sortIndex:-1};c>d?(a.sortIndex=c,H(M,a),null===J(L)&&a===J(M)&&(S?h():S=!0,g(U,c-d))):(a.sortIndex=e,H(L,a),R||Q||(R=!0,f(V)));return a};
	exports.unstable_wrapCallback=function(a){var b=P;return function(){var c=P;P=b;try{return a.apply(this,arguments)}finally{P=c;}}};
	}(scheduler_production_min));

	{
	  scheduler.exports = scheduler_production_min;
	}

	/** @license React v17.0.2
	 * react-dom.production.min.js
	 *
	 * Copyright (c) Facebook, Inc. and its affiliates.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */
	var aa=react.exports,m$1=objectAssign,r$1=scheduler.exports;function y$1(a){for(var b="https://reactjs.org/docs/error-decoder.html?invariant="+a,c=1;c<arguments.length;c++)b+="&args[]="+encodeURIComponent(arguments[c]);return "Minified React error #"+a+"; visit "+b+" for the full message or use the non-minified dev environment for full errors and additional helpful warnings."}if(!aa)throw Error(y$1(227));var ba=new Set,ca={};function da(a,b){ea(a,b);ea(a+"Capture",b);}
	function ea(a,b){ca[a]=b;for(a=0;a<b.length;a++)ba.add(b[a]);}
	var fa=!("undefined"===typeof window||"undefined"===typeof window.document||"undefined"===typeof window.document.createElement),ha=/^[:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD][:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*$/,ia=Object.prototype.hasOwnProperty,
	ja={},ka={};function la(a){if(ia.call(ka,a))return !0;if(ia.call(ja,a))return !1;if(ha.test(a))return ka[a]=!0;ja[a]=!0;return !1}function ma(a,b,c,d){if(null!==c&&0===c.type)return !1;switch(typeof b){case "function":case "symbol":return !0;case "boolean":if(d)return !1;if(null!==c)return !c.acceptsBooleans;a=a.toLowerCase().slice(0,5);return "data-"!==a&&"aria-"!==a;default:return !1}}
	function na(a,b,c,d){if(null===b||"undefined"===typeof b||ma(a,b,c,d))return !0;if(d)return !1;if(null!==c)switch(c.type){case 3:return !b;case 4:return !1===b;case 5:return isNaN(b);case 6:return isNaN(b)||1>b}return !1}function B$1(a,b,c,d,e,f,g){this.acceptsBooleans=2===b||3===b||4===b;this.attributeName=d;this.attributeNamespace=e;this.mustUseProperty=c;this.propertyName=a;this.type=b;this.sanitizeURL=f;this.removeEmptyString=g;}var D={};
	"children dangerouslySetInnerHTML defaultValue defaultChecked innerHTML suppressContentEditableWarning suppressHydrationWarning style".split(" ").forEach(function(a){D[a]=new B$1(a,0,!1,a,null,!1,!1);});[["acceptCharset","accept-charset"],["className","class"],["htmlFor","for"],["httpEquiv","http-equiv"]].forEach(function(a){var b=a[0];D[b]=new B$1(b,1,!1,a[1],null,!1,!1);});["contentEditable","draggable","spellCheck","value"].forEach(function(a){D[a]=new B$1(a,2,!1,a.toLowerCase(),null,!1,!1);});
	["autoReverse","externalResourcesRequired","focusable","preserveAlpha"].forEach(function(a){D[a]=new B$1(a,2,!1,a,null,!1,!1);});"allowFullScreen async autoFocus autoPlay controls default defer disabled disablePictureInPicture disableRemotePlayback formNoValidate hidden loop noModule noValidate open playsInline readOnly required reversed scoped seamless itemScope".split(" ").forEach(function(a){D[a]=new B$1(a,3,!1,a.toLowerCase(),null,!1,!1);});
	["checked","multiple","muted","selected"].forEach(function(a){D[a]=new B$1(a,3,!0,a,null,!1,!1);});["capture","download"].forEach(function(a){D[a]=new B$1(a,4,!1,a,null,!1,!1);});["cols","rows","size","span"].forEach(function(a){D[a]=new B$1(a,6,!1,a,null,!1,!1);});["rowSpan","start"].forEach(function(a){D[a]=new B$1(a,5,!1,a.toLowerCase(),null,!1,!1);});var oa=/[\-:]([a-z])/g;function pa(a){return a[1].toUpperCase()}
	"accent-height alignment-baseline arabic-form baseline-shift cap-height clip-path clip-rule color-interpolation color-interpolation-filters color-profile color-rendering dominant-baseline enable-background fill-opacity fill-rule flood-color flood-opacity font-family font-size font-size-adjust font-stretch font-style font-variant font-weight glyph-name glyph-orientation-horizontal glyph-orientation-vertical horiz-adv-x horiz-origin-x image-rendering letter-spacing lighting-color marker-end marker-mid marker-start overline-position overline-thickness paint-order panose-1 pointer-events rendering-intent shape-rendering stop-color stop-opacity strikethrough-position strikethrough-thickness stroke-dasharray stroke-dashoffset stroke-linecap stroke-linejoin stroke-miterlimit stroke-opacity stroke-width text-anchor text-decoration text-rendering underline-position underline-thickness unicode-bidi unicode-range units-per-em v-alphabetic v-hanging v-ideographic v-mathematical vector-effect vert-adv-y vert-origin-x vert-origin-y word-spacing writing-mode xmlns:xlink x-height".split(" ").forEach(function(a){var b=a.replace(oa,
	pa);D[b]=new B$1(b,1,!1,a,null,!1,!1);});"xlink:actuate xlink:arcrole xlink:role xlink:show xlink:title xlink:type".split(" ").forEach(function(a){var b=a.replace(oa,pa);D[b]=new B$1(b,1,!1,a,"http://www.w3.org/1999/xlink",!1,!1);});["xml:base","xml:lang","xml:space"].forEach(function(a){var b=a.replace(oa,pa);D[b]=new B$1(b,1,!1,a,"http://www.w3.org/XML/1998/namespace",!1,!1);});["tabIndex","crossOrigin"].forEach(function(a){D[a]=new B$1(a,1,!1,a.toLowerCase(),null,!1,!1);});
	D.xlinkHref=new B$1("xlinkHref",1,!1,"xlink:href","http://www.w3.org/1999/xlink",!0,!1);["src","href","action","formAction"].forEach(function(a){D[a]=new B$1(a,1,!1,a.toLowerCase(),null,!0,!0);});
	function qa(a,b,c,d){var e=D.hasOwnProperty(b)?D[b]:null;var f=null!==e?0===e.type:d?!1:!(2<b.length)||"o"!==b[0]&&"O"!==b[0]||"n"!==b[1]&&"N"!==b[1]?!1:!0;f||(na(b,c,e,d)&&(c=null),d||null===e?la(b)&&(null===c?a.removeAttribute(b):a.setAttribute(b,""+c)):e.mustUseProperty?a[e.propertyName]=null===c?3===e.type?!1:"":c:(b=e.attributeName,d=e.attributeNamespace,null===c?a.removeAttribute(b):(e=e.type,c=3===e||4===e&&!0===c?"":""+c,d?a.setAttributeNS(d,b,c):a.setAttribute(b,c))));}
	var ra=aa.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED,sa=60103,ta=60106,ua=60107,wa=60108,xa=60114,ya=60109,za=60110,Aa=60112,Ba=60113,Ca=60120,Da=60115,Ea=60116,Fa=60121,Ga=60128,Ha=60129,Ia=60130,Ja=60131;
	if("function"===typeof Symbol&&Symbol.for){var E$1=Symbol.for;sa=E$1("react.element");ta=E$1("react.portal");ua=E$1("react.fragment");wa=E$1("react.strict_mode");xa=E$1("react.profiler");ya=E$1("react.provider");za=E$1("react.context");Aa=E$1("react.forward_ref");Ba=E$1("react.suspense");Ca=E$1("react.suspense_list");Da=E$1("react.memo");Ea=E$1("react.lazy");Fa=E$1("react.block");E$1("react.scope");Ga=E$1("react.opaque.id");Ha=E$1("react.debug_trace_mode");Ia=E$1("react.offscreen");Ja=E$1("react.legacy_hidden");}
	var Ka="function"===typeof Symbol&&Symbol.iterator;function La(a){if(null===a||"object"!==typeof a)return null;a=Ka&&a[Ka]||a["@@iterator"];return "function"===typeof a?a:null}var Ma;function Na(a){if(void 0===Ma)try{throw Error();}catch(c){var b=c.stack.trim().match(/\n( *(at )?)/);Ma=b&&b[1]||"";}return "\n"+Ma+a}var Oa=!1;
	function Pa(a,b){if(!a||Oa)return "";Oa=!0;var c=Error.prepareStackTrace;Error.prepareStackTrace=void 0;try{if(b)if(b=function(){throw Error();},Object.defineProperty(b.prototype,"props",{set:function(){throw Error();}}),"object"===typeof Reflect&&Reflect.construct){try{Reflect.construct(b,[]);}catch(k){var d=k;}Reflect.construct(a,[],b);}else {try{b.call();}catch(k){d=k;}a.call(b.prototype);}else {try{throw Error();}catch(k){d=k;}a();}}catch(k){if(k&&d&&"string"===typeof k.stack){for(var e=k.stack.split("\n"),
	f=d.stack.split("\n"),g=e.length-1,h=f.length-1;1<=g&&0<=h&&e[g]!==f[h];)h--;for(;1<=g&&0<=h;g--,h--)if(e[g]!==f[h]){if(1!==g||1!==h){do if(g--,h--,0>h||e[g]!==f[h])return "\n"+e[g].replace(" at new "," at ");while(1<=g&&0<=h)}break}}}finally{Oa=!1,Error.prepareStackTrace=c;}return (a=a?a.displayName||a.name:"")?Na(a):""}
	function Qa(a){switch(a.tag){case 5:return Na(a.type);case 16:return Na("Lazy");case 13:return Na("Suspense");case 19:return Na("SuspenseList");case 0:case 2:case 15:return a=Pa(a.type,!1),a;case 11:return a=Pa(a.type.render,!1),a;case 22:return a=Pa(a.type._render,!1),a;case 1:return a=Pa(a.type,!0),a;default:return ""}}
	function Ra(a){if(null==a)return null;if("function"===typeof a)return a.displayName||a.name||null;if("string"===typeof a)return a;switch(a){case ua:return "Fragment";case ta:return "Portal";case xa:return "Profiler";case wa:return "StrictMode";case Ba:return "Suspense";case Ca:return "SuspenseList"}if("object"===typeof a)switch(a.$$typeof){case za:return (a.displayName||"Context")+".Consumer";case ya:return (a._context.displayName||"Context")+".Provider";case Aa:var b=a.render;b=b.displayName||b.name||"";
	return a.displayName||(""!==b?"ForwardRef("+b+")":"ForwardRef");case Da:return Ra(a.type);case Fa:return Ra(a._render);case Ea:b=a._payload;a=a._init;try{return Ra(a(b))}catch(c){}}return null}function Sa(a){switch(typeof a){case "boolean":case "number":case "object":case "string":case "undefined":return a;default:return ""}}function Ta(a){var b=a.type;return (a=a.nodeName)&&"input"===a.toLowerCase()&&("checkbox"===b||"radio"===b)}
	function Ua(a){var b=Ta(a)?"checked":"value",c=Object.getOwnPropertyDescriptor(a.constructor.prototype,b),d=""+a[b];if(!a.hasOwnProperty(b)&&"undefined"!==typeof c&&"function"===typeof c.get&&"function"===typeof c.set){var e=c.get,f=c.set;Object.defineProperty(a,b,{configurable:!0,get:function(){return e.call(this)},set:function(a){d=""+a;f.call(this,a);}});Object.defineProperty(a,b,{enumerable:c.enumerable});return {getValue:function(){return d},setValue:function(a){d=""+a;},stopTracking:function(){a._valueTracker=
	null;delete a[b];}}}}function Va(a){a._valueTracker||(a._valueTracker=Ua(a));}function Wa(a){if(!a)return !1;var b=a._valueTracker;if(!b)return !0;var c=b.getValue();var d="";a&&(d=Ta(a)?a.checked?"true":"false":a.value);a=d;return a!==c?(b.setValue(a),!0):!1}function Xa(a){a=a||("undefined"!==typeof document?document:void 0);if("undefined"===typeof a)return null;try{return a.activeElement||a.body}catch(b){return a.body}}
	function Ya(a,b){var c=b.checked;return m$1({},b,{defaultChecked:void 0,defaultValue:void 0,value:void 0,checked:null!=c?c:a._wrapperState.initialChecked})}function Za(a,b){var c=null==b.defaultValue?"":b.defaultValue,d=null!=b.checked?b.checked:b.defaultChecked;c=Sa(null!=b.value?b.value:c);a._wrapperState={initialChecked:d,initialValue:c,controlled:"checkbox"===b.type||"radio"===b.type?null!=b.checked:null!=b.value};}function $a(a,b){b=b.checked;null!=b&&qa(a,"checked",b,!1);}
	function ab(a,b){$a(a,b);var c=Sa(b.value),d=b.type;if(null!=c)if("number"===d){if(0===c&&""===a.value||a.value!=c)a.value=""+c;}else a.value!==""+c&&(a.value=""+c);else if("submit"===d||"reset"===d){a.removeAttribute("value");return}b.hasOwnProperty("value")?bb(a,b.type,c):b.hasOwnProperty("defaultValue")&&bb(a,b.type,Sa(b.defaultValue));null==b.checked&&null!=b.defaultChecked&&(a.defaultChecked=!!b.defaultChecked);}
	function cb(a,b,c){if(b.hasOwnProperty("value")||b.hasOwnProperty("defaultValue")){var d=b.type;if(!("submit"!==d&&"reset"!==d||void 0!==b.value&&null!==b.value))return;b=""+a._wrapperState.initialValue;c||b===a.value||(a.value=b);a.defaultValue=b;}c=a.name;""!==c&&(a.name="");a.defaultChecked=!!a._wrapperState.initialChecked;""!==c&&(a.name=c);}
	function bb(a,b,c){if("number"!==b||Xa(a.ownerDocument)!==a)null==c?a.defaultValue=""+a._wrapperState.initialValue:a.defaultValue!==""+c&&(a.defaultValue=""+c);}function db(a){var b="";aa.Children.forEach(a,function(a){null!=a&&(b+=a);});return b}function eb(a,b){a=m$1({children:void 0},b);if(b=db(b.children))a.children=b;return a}
	function fb(a,b,c,d){a=a.options;if(b){b={};for(var e=0;e<c.length;e++)b["$"+c[e]]=!0;for(c=0;c<a.length;c++)e=b.hasOwnProperty("$"+a[c].value),a[c].selected!==e&&(a[c].selected=e),e&&d&&(a[c].defaultSelected=!0);}else {c=""+Sa(c);b=null;for(e=0;e<a.length;e++){if(a[e].value===c){a[e].selected=!0;d&&(a[e].defaultSelected=!0);return}null!==b||a[e].disabled||(b=a[e]);}null!==b&&(b.selected=!0);}}
	function gb(a,b){if(null!=b.dangerouslySetInnerHTML)throw Error(y$1(91));return m$1({},b,{value:void 0,defaultValue:void 0,children:""+a._wrapperState.initialValue})}function hb(a,b){var c=b.value;if(null==c){c=b.children;b=b.defaultValue;if(null!=c){if(null!=b)throw Error(y$1(92));if(Array.isArray(c)){if(!(1>=c.length))throw Error(y$1(93));c=c[0];}b=c;}null==b&&(b="");c=b;}a._wrapperState={initialValue:Sa(c)};}
	function ib(a,b){var c=Sa(b.value),d=Sa(b.defaultValue);null!=c&&(c=""+c,c!==a.value&&(a.value=c),null==b.defaultValue&&a.defaultValue!==c&&(a.defaultValue=c));null!=d&&(a.defaultValue=""+d);}function jb(a){var b=a.textContent;b===a._wrapperState.initialValue&&""!==b&&null!==b&&(a.value=b);}var kb={html:"http://www.w3.org/1999/xhtml",mathml:"http://www.w3.org/1998/Math/MathML",svg:"http://www.w3.org/2000/svg"};
	function lb(a){switch(a){case "svg":return "http://www.w3.org/2000/svg";case "math":return "http://www.w3.org/1998/Math/MathML";default:return "http://www.w3.org/1999/xhtml"}}function mb(a,b){return null==a||"http://www.w3.org/1999/xhtml"===a?lb(b):"http://www.w3.org/2000/svg"===a&&"foreignObject"===b?"http://www.w3.org/1999/xhtml":a}
	var nb,ob=function(a){return "undefined"!==typeof MSApp&&MSApp.execUnsafeLocalFunction?function(b,c,d,e){MSApp.execUnsafeLocalFunction(function(){return a(b,c,d,e)});}:a}(function(a,b){if(a.namespaceURI!==kb.svg||"innerHTML"in a)a.innerHTML=b;else {nb=nb||document.createElement("div");nb.innerHTML="<svg>"+b.valueOf().toString()+"</svg>";for(b=nb.firstChild;a.firstChild;)a.removeChild(a.firstChild);for(;b.firstChild;)a.appendChild(b.firstChild);}});
	function pb(a,b){if(b){var c=a.firstChild;if(c&&c===a.lastChild&&3===c.nodeType){c.nodeValue=b;return}}a.textContent=b;}
	var qb={animationIterationCount:!0,borderImageOutset:!0,borderImageSlice:!0,borderImageWidth:!0,boxFlex:!0,boxFlexGroup:!0,boxOrdinalGroup:!0,columnCount:!0,columns:!0,flex:!0,flexGrow:!0,flexPositive:!0,flexShrink:!0,flexNegative:!0,flexOrder:!0,gridArea:!0,gridRow:!0,gridRowEnd:!0,gridRowSpan:!0,gridRowStart:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnSpan:!0,gridColumnStart:!0,fontWeight:!0,lineClamp:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,tabSize:!0,widows:!0,zIndex:!0,zoom:!0,fillOpacity:!0,
	floodOpacity:!0,stopOpacity:!0,strokeDasharray:!0,strokeDashoffset:!0,strokeMiterlimit:!0,strokeOpacity:!0,strokeWidth:!0},rb=["Webkit","ms","Moz","O"];Object.keys(qb).forEach(function(a){rb.forEach(function(b){b=b+a.charAt(0).toUpperCase()+a.substring(1);qb[b]=qb[a];});});function sb(a,b,c){return null==b||"boolean"===typeof b||""===b?"":c||"number"!==typeof b||0===b||qb.hasOwnProperty(a)&&qb[a]?(""+b).trim():b+"px"}
	function tb(a,b){a=a.style;for(var c in b)if(b.hasOwnProperty(c)){var d=0===c.indexOf("--"),e=sb(c,b[c],d);"float"===c&&(c="cssFloat");d?a.setProperty(c,e):a[c]=e;}}var ub=m$1({menuitem:!0},{area:!0,base:!0,br:!0,col:!0,embed:!0,hr:!0,img:!0,input:!0,keygen:!0,link:!0,meta:!0,param:!0,source:!0,track:!0,wbr:!0});
	function vb(a,b){if(b){if(ub[a]&&(null!=b.children||null!=b.dangerouslySetInnerHTML))throw Error(y$1(137,a));if(null!=b.dangerouslySetInnerHTML){if(null!=b.children)throw Error(y$1(60));if(!("object"===typeof b.dangerouslySetInnerHTML&&"__html"in b.dangerouslySetInnerHTML))throw Error(y$1(61));}if(null!=b.style&&"object"!==typeof b.style)throw Error(y$1(62));}}
	function wb(a,b){if(-1===a.indexOf("-"))return "string"===typeof b.is;switch(a){case "annotation-xml":case "color-profile":case "font-face":case "font-face-src":case "font-face-uri":case "font-face-format":case "font-face-name":case "missing-glyph":return !1;default:return !0}}function xb(a){a=a.target||a.srcElement||window;a.correspondingUseElement&&(a=a.correspondingUseElement);return 3===a.nodeType?a.parentNode:a}var yb=null,zb=null,Ab=null;
	function Bb(a){if(a=Cb(a)){if("function"!==typeof yb)throw Error(y$1(280));var b=a.stateNode;b&&(b=Db(b),yb(a.stateNode,a.type,b));}}function Eb(a){zb?Ab?Ab.push(a):Ab=[a]:zb=a;}function Fb(){if(zb){var a=zb,b=Ab;Ab=zb=null;Bb(a);if(b)for(a=0;a<b.length;a++)Bb(b[a]);}}function Gb(a,b){return a(b)}function Hb(a,b,c,d,e){return a(b,c,d,e)}function Ib(){}var Jb=Gb,Kb=!1,Lb=!1;function Mb(){if(null!==zb||null!==Ab)Ib(),Fb();}
	function Nb(a,b,c){if(Lb)return a(b,c);Lb=!0;try{return Jb(a,b,c)}finally{Lb=!1,Mb();}}
	function Ob(a,b){var c=a.stateNode;if(null===c)return null;var d=Db(c);if(null===d)return null;c=d[b];a:switch(b){case "onClick":case "onClickCapture":case "onDoubleClick":case "onDoubleClickCapture":case "onMouseDown":case "onMouseDownCapture":case "onMouseMove":case "onMouseMoveCapture":case "onMouseUp":case "onMouseUpCapture":case "onMouseEnter":(d=!d.disabled)||(a=a.type,d=!("button"===a||"input"===a||"select"===a||"textarea"===a));a=!d;break a;default:a=!1;}if(a)return null;if(c&&"function"!==
	typeof c)throw Error(y$1(231,b,typeof c));return c}var Pb=!1;if(fa)try{var Qb={};Object.defineProperty(Qb,"passive",{get:function(){Pb=!0;}});window.addEventListener("test",Qb,Qb);window.removeEventListener("test",Qb,Qb);}catch(a){Pb=!1;}function Rb(a,b,c,d,e,f,g,h,k){var l=Array.prototype.slice.call(arguments,3);try{b.apply(c,l);}catch(n){this.onError(n);}}var Sb=!1,Tb=null,Ub=!1,Vb=null,Wb={onError:function(a){Sb=!0;Tb=a;}};function Xb(a,b,c,d,e,f,g,h,k){Sb=!1;Tb=null;Rb.apply(Wb,arguments);}
	function Yb(a,b,c,d,e,f,g,h,k){Xb.apply(this,arguments);if(Sb){if(Sb){var l=Tb;Sb=!1;Tb=null;}else throw Error(y$1(198));Ub||(Ub=!0,Vb=l);}}function Zb(a){var b=a,c=a;if(a.alternate)for(;b.return;)b=b.return;else {a=b;do b=a,0!==(b.flags&1026)&&(c=b.return),a=b.return;while(a)}return 3===b.tag?c:null}function $b(a){if(13===a.tag){var b=a.memoizedState;null===b&&(a=a.alternate,null!==a&&(b=a.memoizedState));if(null!==b)return b.dehydrated}return null}function ac(a){if(Zb(a)!==a)throw Error(y$1(188));}
	function bc(a){var b=a.alternate;if(!b){b=Zb(a);if(null===b)throw Error(y$1(188));return b!==a?null:a}for(var c=a,d=b;;){var e=c.return;if(null===e)break;var f=e.alternate;if(null===f){d=e.return;if(null!==d){c=d;continue}break}if(e.child===f.child){for(f=e.child;f;){if(f===c)return ac(e),a;if(f===d)return ac(e),b;f=f.sibling;}throw Error(y$1(188));}if(c.return!==d.return)c=e,d=f;else {for(var g=!1,h=e.child;h;){if(h===c){g=!0;c=e;d=f;break}if(h===d){g=!0;d=e;c=f;break}h=h.sibling;}if(!g){for(h=f.child;h;){if(h===
	c){g=!0;c=f;d=e;break}if(h===d){g=!0;d=f;c=e;break}h=h.sibling;}if(!g)throw Error(y$1(189));}}if(c.alternate!==d)throw Error(y$1(190));}if(3!==c.tag)throw Error(y$1(188));return c.stateNode.current===c?a:b}function cc(a){a=bc(a);if(!a)return null;for(var b=a;;){if(5===b.tag||6===b.tag)return b;if(b.child)b.child.return=b,b=b.child;else {if(b===a)break;for(;!b.sibling;){if(!b.return||b.return===a)return null;b=b.return;}b.sibling.return=b.return;b=b.sibling;}}return null}
	function dc(a,b){for(var c=a.alternate;null!==b;){if(b===a||b===c)return !0;b=b.return;}return !1}var ec,fc,gc,hc,ic=!1,jc=[],kc=null,lc=null,mc=null,nc=new Map,oc=new Map,pc=[],qc="mousedown mouseup touchcancel touchend touchstart auxclick dblclick pointercancel pointerdown pointerup dragend dragstart drop compositionend compositionstart keydown keypress keyup input textInput copy cut paste click change contextmenu reset submit".split(" ");
	function rc(a,b,c,d,e){return {blockedOn:a,domEventName:b,eventSystemFlags:c|16,nativeEvent:e,targetContainers:[d]}}function sc(a,b){switch(a){case "focusin":case "focusout":kc=null;break;case "dragenter":case "dragleave":lc=null;break;case "mouseover":case "mouseout":mc=null;break;case "pointerover":case "pointerout":nc.delete(b.pointerId);break;case "gotpointercapture":case "lostpointercapture":oc.delete(b.pointerId);}}
	function tc(a,b,c,d,e,f){if(null===a||a.nativeEvent!==f)return a=rc(b,c,d,e,f),null!==b&&(b=Cb(b),null!==b&&fc(b)),a;a.eventSystemFlags|=d;b=a.targetContainers;null!==e&&-1===b.indexOf(e)&&b.push(e);return a}
	function uc(a,b,c,d,e){switch(b){case "focusin":return kc=tc(kc,a,b,c,d,e),!0;case "dragenter":return lc=tc(lc,a,b,c,d,e),!0;case "mouseover":return mc=tc(mc,a,b,c,d,e),!0;case "pointerover":var f=e.pointerId;nc.set(f,tc(nc.get(f)||null,a,b,c,d,e));return !0;case "gotpointercapture":return f=e.pointerId,oc.set(f,tc(oc.get(f)||null,a,b,c,d,e)),!0}return !1}
	function vc(a){var b=wc(a.target);if(null!==b){var c=Zb(b);if(null!==c)if(b=c.tag,13===b){if(b=$b(c),null!==b){a.blockedOn=b;hc(a.lanePriority,function(){r$1.unstable_runWithPriority(a.priority,function(){gc(c);});});return}}else if(3===b&&c.stateNode.hydrate){a.blockedOn=3===c.tag?c.stateNode.containerInfo:null;return}}a.blockedOn=null;}
	function xc(a){if(null!==a.blockedOn)return !1;for(var b=a.targetContainers;0<b.length;){var c=yc(a.domEventName,a.eventSystemFlags,b[0],a.nativeEvent);if(null!==c)return b=Cb(c),null!==b&&fc(b),a.blockedOn=c,!1;b.shift();}return !0}function zc(a,b,c){xc(a)&&c.delete(b);}
	function Ac(){for(ic=!1;0<jc.length;){var a=jc[0];if(null!==a.blockedOn){a=Cb(a.blockedOn);null!==a&&ec(a);break}for(var b=a.targetContainers;0<b.length;){var c=yc(a.domEventName,a.eventSystemFlags,b[0],a.nativeEvent);if(null!==c){a.blockedOn=c;break}b.shift();}null===a.blockedOn&&jc.shift();}null!==kc&&xc(kc)&&(kc=null);null!==lc&&xc(lc)&&(lc=null);null!==mc&&xc(mc)&&(mc=null);nc.forEach(zc);oc.forEach(zc);}
	function Bc(a,b){a.blockedOn===b&&(a.blockedOn=null,ic||(ic=!0,r$1.unstable_scheduleCallback(r$1.unstable_NormalPriority,Ac)));}
	function Cc(a){function b(b){return Bc(b,a)}if(0<jc.length){Bc(jc[0],a);for(var c=1;c<jc.length;c++){var d=jc[c];d.blockedOn===a&&(d.blockedOn=null);}}null!==kc&&Bc(kc,a);null!==lc&&Bc(lc,a);null!==mc&&Bc(mc,a);nc.forEach(b);oc.forEach(b);for(c=0;c<pc.length;c++)d=pc[c],d.blockedOn===a&&(d.blockedOn=null);for(;0<pc.length&&(c=pc[0],null===c.blockedOn);)vc(c),null===c.blockedOn&&pc.shift();}
	function Dc(a,b){var c={};c[a.toLowerCase()]=b.toLowerCase();c["Webkit"+a]="webkit"+b;c["Moz"+a]="moz"+b;return c}var Ec={animationend:Dc("Animation","AnimationEnd"),animationiteration:Dc("Animation","AnimationIteration"),animationstart:Dc("Animation","AnimationStart"),transitionend:Dc("Transition","TransitionEnd")},Fc={},Gc={};
	fa&&(Gc=document.createElement("div").style,"AnimationEvent"in window||(delete Ec.animationend.animation,delete Ec.animationiteration.animation,delete Ec.animationstart.animation),"TransitionEvent"in window||delete Ec.transitionend.transition);function Hc(a){if(Fc[a])return Fc[a];if(!Ec[a])return a;var b=Ec[a],c;for(c in b)if(b.hasOwnProperty(c)&&c in Gc)return Fc[a]=b[c];return a}
	var Ic=Hc("animationend"),Jc=Hc("animationiteration"),Kc=Hc("animationstart"),Lc=Hc("transitionend"),Mc=new Map,Nc=new Map,Oc=["abort","abort",Ic,"animationEnd",Jc,"animationIteration",Kc,"animationStart","canplay","canPlay","canplaythrough","canPlayThrough","durationchange","durationChange","emptied","emptied","encrypted","encrypted","ended","ended","error","error","gotpointercapture","gotPointerCapture","load","load","loadeddata","loadedData","loadedmetadata","loadedMetadata","loadstart","loadStart",
	"lostpointercapture","lostPointerCapture","playing","playing","progress","progress","seeking","seeking","stalled","stalled","suspend","suspend","timeupdate","timeUpdate",Lc,"transitionEnd","waiting","waiting"];function Pc(a,b){for(var c=0;c<a.length;c+=2){var d=a[c],e=a[c+1];e="on"+(e[0].toUpperCase()+e.slice(1));Nc.set(d,b);Mc.set(d,e);da(e,[d]);}}var Qc=r$1.unstable_now;Qc();var F$1=8;
	function Rc(a){if(0!==(1&a))return F$1=15,1;if(0!==(2&a))return F$1=14,2;if(0!==(4&a))return F$1=13,4;var b=24&a;if(0!==b)return F$1=12,b;if(0!==(a&32))return F$1=11,32;b=192&a;if(0!==b)return F$1=10,b;if(0!==(a&256))return F$1=9,256;b=3584&a;if(0!==b)return F$1=8,b;if(0!==(a&4096))return F$1=7,4096;b=4186112&a;if(0!==b)return F$1=6,b;b=62914560&a;if(0!==b)return F$1=5,b;if(a&67108864)return F$1=4,67108864;if(0!==(a&134217728))return F$1=3,134217728;b=805306368&a;if(0!==b)return F$1=2,b;if(0!==(1073741824&a))return F$1=1,1073741824;
	F$1=8;return a}function Sc(a){switch(a){case 99:return 15;case 98:return 10;case 97:case 96:return 8;case 95:return 2;default:return 0}}function Tc(a){switch(a){case 15:case 14:return 99;case 13:case 12:case 11:case 10:return 98;case 9:case 8:case 7:case 6:case 4:case 5:return 97;case 3:case 2:case 1:return 95;case 0:return 90;default:throw Error(y$1(358,a));}}
	function Uc(a,b){var c=a.pendingLanes;if(0===c)return F$1=0;var d=0,e=0,f=a.expiredLanes,g=a.suspendedLanes,h=a.pingedLanes;if(0!==f)d=f,e=F$1=15;else if(f=c&134217727,0!==f){var k=f&~g;0!==k?(d=Rc(k),e=F$1):(h&=f,0!==h&&(d=Rc(h),e=F$1));}else f=c&~g,0!==f?(d=Rc(f),e=F$1):0!==h&&(d=Rc(h),e=F$1);if(0===d)return 0;d=31-Vc(d);d=c&((0>d?0:1<<d)<<1)-1;if(0!==b&&b!==d&&0===(b&g)){Rc(b);if(e<=F$1)return b;F$1=e;}b=a.entangledLanes;if(0!==b)for(a=a.entanglements,b&=d;0<b;)c=31-Vc(b),e=1<<c,d|=a[c],b&=~e;return d}
	function Wc(a){a=a.pendingLanes&-1073741825;return 0!==a?a:a&1073741824?1073741824:0}function Xc(a,b){switch(a){case 15:return 1;case 14:return 2;case 12:return a=Yc(24&~b),0===a?Xc(10,b):a;case 10:return a=Yc(192&~b),0===a?Xc(8,b):a;case 8:return a=Yc(3584&~b),0===a&&(a=Yc(4186112&~b),0===a&&(a=512)),a;case 2:return b=Yc(805306368&~b),0===b&&(b=268435456),b}throw Error(y$1(358,a));}function Yc(a){return a&-a}function Zc(a){for(var b=[],c=0;31>c;c++)b.push(a);return b}
	function $c(a,b,c){a.pendingLanes|=b;var d=b-1;a.suspendedLanes&=d;a.pingedLanes&=d;a=a.eventTimes;b=31-Vc(b);a[b]=c;}var Vc=Math.clz32?Math.clz32:ad,bd=Math.log,cd=Math.LN2;function ad(a){return 0===a?32:31-(bd(a)/cd|0)|0}var dd=r$1.unstable_UserBlockingPriority,ed=r$1.unstable_runWithPriority,fd=!0;function gd(a,b,c,d){Kb||Ib();var e=hd,f=Kb;Kb=!0;try{Hb(e,a,b,c,d);}finally{(Kb=f)||Mb();}}function id(a,b,c,d){ed(dd,hd.bind(null,a,b,c,d));}
	function hd(a,b,c,d){if(fd){var e;if((e=0===(b&4))&&0<jc.length&&-1<qc.indexOf(a))a=rc(null,a,b,c,d),jc.push(a);else {var f=yc(a,b,c,d);if(null===f)e&&sc(a,d);else {if(e){if(-1<qc.indexOf(a)){a=rc(f,a,b,c,d);jc.push(a);return}if(uc(f,a,b,c,d))return;sc(a,d);}jd(a,b,d,null,c);}}}}
	function yc(a,b,c,d){var e=xb(d);e=wc(e);if(null!==e){var f=Zb(e);if(null===f)e=null;else {var g=f.tag;if(13===g){e=$b(f);if(null!==e)return e;e=null;}else if(3===g){if(f.stateNode.hydrate)return 3===f.tag?f.stateNode.containerInfo:null;e=null;}else f!==e&&(e=null);}}jd(a,b,d,e,c);return null}var kd=null,ld=null,md=null;
	function nd(){if(md)return md;var a,b=ld,c=b.length,d,e="value"in kd?kd.value:kd.textContent,f=e.length;for(a=0;a<c&&b[a]===e[a];a++);var g=c-a;for(d=1;d<=g&&b[c-d]===e[f-d];d++);return md=e.slice(a,1<d?1-d:void 0)}function od(a){var b=a.keyCode;"charCode"in a?(a=a.charCode,0===a&&13===b&&(a=13)):a=b;10===a&&(a=13);return 32<=a||13===a?a:0}function pd(){return !0}function qd(){return !1}
	function rd(a){function b(b,d,e,f,g){this._reactName=b;this._targetInst=e;this.type=d;this.nativeEvent=f;this.target=g;this.currentTarget=null;for(var c in a)a.hasOwnProperty(c)&&(b=a[c],this[c]=b?b(f):f[c]);this.isDefaultPrevented=(null!=f.defaultPrevented?f.defaultPrevented:!1===f.returnValue)?pd:qd;this.isPropagationStopped=qd;return this}m$1(b.prototype,{preventDefault:function(){this.defaultPrevented=!0;var a=this.nativeEvent;a&&(a.preventDefault?a.preventDefault():"unknown"!==typeof a.returnValue&&
	(a.returnValue=!1),this.isDefaultPrevented=pd);},stopPropagation:function(){var a=this.nativeEvent;a&&(a.stopPropagation?a.stopPropagation():"unknown"!==typeof a.cancelBubble&&(a.cancelBubble=!0),this.isPropagationStopped=pd);},persist:function(){},isPersistent:pd});return b}
	var sd={eventPhase:0,bubbles:0,cancelable:0,timeStamp:function(a){return a.timeStamp||Date.now()},defaultPrevented:0,isTrusted:0},td=rd(sd),ud=m$1({},sd,{view:0,detail:0}),vd=rd(ud),wd,xd,yd,Ad=m$1({},ud,{screenX:0,screenY:0,clientX:0,clientY:0,pageX:0,pageY:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,getModifierState:zd,button:0,buttons:0,relatedTarget:function(a){return void 0===a.relatedTarget?a.fromElement===a.srcElement?a.toElement:a.fromElement:a.relatedTarget},movementX:function(a){if("movementX"in
	a)return a.movementX;a!==yd&&(yd&&"mousemove"===a.type?(wd=a.screenX-yd.screenX,xd=a.screenY-yd.screenY):xd=wd=0,yd=a);return wd},movementY:function(a){return "movementY"in a?a.movementY:xd}}),Bd=rd(Ad),Cd=m$1({},Ad,{dataTransfer:0}),Dd=rd(Cd),Ed=m$1({},ud,{relatedTarget:0}),Fd=rd(Ed),Gd=m$1({},sd,{animationName:0,elapsedTime:0,pseudoElement:0}),Hd=rd(Gd),Id=m$1({},sd,{clipboardData:function(a){return "clipboardData"in a?a.clipboardData:window.clipboardData}}),Jd=rd(Id),Kd=m$1({},sd,{data:0}),Ld=rd(Kd),Md={Esc:"Escape",
	Spacebar:" ",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown",Del:"Delete",Win:"OS",Menu:"ContextMenu",Apps:"ContextMenu",Scroll:"ScrollLock",MozPrintableKey:"Unidentified"},Nd={8:"Backspace",9:"Tab",12:"Clear",13:"Enter",16:"Shift",17:"Control",18:"Alt",19:"Pause",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",45:"Insert",46:"Delete",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",
	119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"NumLock",145:"ScrollLock",224:"Meta"},Od={Alt:"altKey",Control:"ctrlKey",Meta:"metaKey",Shift:"shiftKey"};function Pd(a){var b=this.nativeEvent;return b.getModifierState?b.getModifierState(a):(a=Od[a])?!!b[a]:!1}function zd(){return Pd}
	var Qd=m$1({},ud,{key:function(a){if(a.key){var b=Md[a.key]||a.key;if("Unidentified"!==b)return b}return "keypress"===a.type?(a=od(a),13===a?"Enter":String.fromCharCode(a)):"keydown"===a.type||"keyup"===a.type?Nd[a.keyCode]||"Unidentified":""},code:0,location:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,repeat:0,locale:0,getModifierState:zd,charCode:function(a){return "keypress"===a.type?od(a):0},keyCode:function(a){return "keydown"===a.type||"keyup"===a.type?a.keyCode:0},which:function(a){return "keypress"===
	a.type?od(a):"keydown"===a.type||"keyup"===a.type?a.keyCode:0}}),Rd=rd(Qd),Sd=m$1({},Ad,{pointerId:0,width:0,height:0,pressure:0,tangentialPressure:0,tiltX:0,tiltY:0,twist:0,pointerType:0,isPrimary:0}),Td=rd(Sd),Ud=m$1({},ud,{touches:0,targetTouches:0,changedTouches:0,altKey:0,metaKey:0,ctrlKey:0,shiftKey:0,getModifierState:zd}),Vd=rd(Ud),Wd=m$1({},sd,{propertyName:0,elapsedTime:0,pseudoElement:0}),Xd=rd(Wd),Yd=m$1({},Ad,{deltaX:function(a){return "deltaX"in a?a.deltaX:"wheelDeltaX"in a?-a.wheelDeltaX:0},
	deltaY:function(a){return "deltaY"in a?a.deltaY:"wheelDeltaY"in a?-a.wheelDeltaY:"wheelDelta"in a?-a.wheelDelta:0},deltaZ:0,deltaMode:0}),Zd=rd(Yd),$d=[9,13,27,32],ae$1=fa&&"CompositionEvent"in window,be$1=null;fa&&"documentMode"in document&&(be$1=document.documentMode);var ce$1=fa&&"TextEvent"in window&&!be$1,de$1=fa&&(!ae$1||be$1&&8<be$1&&11>=be$1),ee$1=String.fromCharCode(32),fe$1=!1;
	function ge$1(a,b){switch(a){case "keyup":return -1!==$d.indexOf(b.keyCode);case "keydown":return 229!==b.keyCode;case "keypress":case "mousedown":case "focusout":return !0;default:return !1}}function he$1(a){a=a.detail;return "object"===typeof a&&"data"in a?a.data:null}var ie$1=!1;function je$1(a,b){switch(a){case "compositionend":return he$1(b);case "keypress":if(32!==b.which)return null;fe$1=!0;return ee$1;case "textInput":return a=b.data,a===ee$1&&fe$1?null:a;default:return null}}
	function ke$1(a,b){if(ie$1)return "compositionend"===a||!ae$1&&ge$1(a,b)?(a=nd(),md=ld=kd=null,ie$1=!1,a):null;switch(a){case "paste":return null;case "keypress":if(!(b.ctrlKey||b.altKey||b.metaKey)||b.ctrlKey&&b.altKey){if(b.char&&1<b.char.length)return b.char;if(b.which)return String.fromCharCode(b.which)}return null;case "compositionend":return de$1&&"ko"!==b.locale?null:b.data;default:return null}}
	var le$1={color:!0,date:!0,datetime:!0,"datetime-local":!0,email:!0,month:!0,number:!0,password:!0,range:!0,search:!0,tel:!0,text:!0,time:!0,url:!0,week:!0};function me$1(a){var b=a&&a.nodeName&&a.nodeName.toLowerCase();return "input"===b?!!le$1[a.type]:"textarea"===b?!0:!1}function ne$1(a,b,c,d){Eb(d);b=oe$1(b,"onChange");0<b.length&&(c=new td("onChange","change",null,c,d),a.push({event:c,listeners:b}));}var pe$1=null,qe$1=null;function re$1(a){se$1(a,0);}function te$1(a){var b=ue$1(a);if(Wa(b))return a}
	function ve$1(a,b){if("change"===a)return b}var we$1=!1;if(fa){var xe$1;if(fa){var ye$1="oninput"in document;if(!ye$1){var ze$1=document.createElement("div");ze$1.setAttribute("oninput","return;");ye$1="function"===typeof ze$1.oninput;}xe$1=ye$1;}else xe$1=!1;we$1=xe$1&&(!document.documentMode||9<document.documentMode);}function Ae$1(){pe$1&&(pe$1.detachEvent("onpropertychange",Be$1),qe$1=pe$1=null);}function Be$1(a){if("value"===a.propertyName&&te$1(qe$1)){var b=[];ne$1(b,qe$1,a,xb(a));a=re$1;if(Kb)a(b);else {Kb=!0;try{Gb(a,b);}finally{Kb=!1,Mb();}}}}
	function Ce$1(a,b,c){"focusin"===a?(Ae$1(),pe$1=b,qe$1=c,pe$1.attachEvent("onpropertychange",Be$1)):"focusout"===a&&Ae$1();}function De$1(a){if("selectionchange"===a||"keyup"===a||"keydown"===a)return te$1(qe$1)}function Ee$1(a,b){if("click"===a)return te$1(b)}function Fe$1(a,b){if("input"===a||"change"===a)return te$1(b)}function Ge$1(a,b){return a===b&&(0!==a||1/a===1/b)||a!==a&&b!==b}var He$1="function"===typeof Object.is?Object.is:Ge$1,Ie=Object.prototype.hasOwnProperty;
	function Je$1(a,b){if(He$1(a,b))return !0;if("object"!==typeof a||null===a||"object"!==typeof b||null===b)return !1;var c=Object.keys(a),d=Object.keys(b);if(c.length!==d.length)return !1;for(d=0;d<c.length;d++)if(!Ie.call(b,c[d])||!He$1(a[c[d]],b[c[d]]))return !1;return !0}function Ke$1(a){for(;a&&a.firstChild;)a=a.firstChild;return a}
	function Le$1(a,b){var c=Ke$1(a);a=0;for(var d;c;){if(3===c.nodeType){d=a+c.textContent.length;if(a<=b&&d>=b)return {node:c,offset:b-a};a=d;}a:{for(;c;){if(c.nextSibling){c=c.nextSibling;break a}c=c.parentNode;}c=void 0;}c=Ke$1(c);}}function Me$1(a,b){return a&&b?a===b?!0:a&&3===a.nodeType?!1:b&&3===b.nodeType?Me$1(a,b.parentNode):"contains"in a?a.contains(b):a.compareDocumentPosition?!!(a.compareDocumentPosition(b)&16):!1:!1}
	function Ne$1(){for(var a=window,b=Xa();b instanceof a.HTMLIFrameElement;){try{var c="string"===typeof b.contentWindow.location.href;}catch(d){c=!1;}if(c)a=b.contentWindow;else break;b=Xa(a.document);}return b}function Oe(a){var b=a&&a.nodeName&&a.nodeName.toLowerCase();return b&&("input"===b&&("text"===a.type||"search"===a.type||"tel"===a.type||"url"===a.type||"password"===a.type)||"textarea"===b||"true"===a.contentEditable)}
	var Pe=fa&&"documentMode"in document&&11>=document.documentMode,Qe=null,Re$1=null,Se$1=null,Te$1=!1;
	function Ue$1(a,b,c){var d=c.window===c?c.document:9===c.nodeType?c:c.ownerDocument;Te$1||null==Qe||Qe!==Xa(d)||(d=Qe,"selectionStart"in d&&Oe(d)?d={start:d.selectionStart,end:d.selectionEnd}:(d=(d.ownerDocument&&d.ownerDocument.defaultView||window).getSelection(),d={anchorNode:d.anchorNode,anchorOffset:d.anchorOffset,focusNode:d.focusNode,focusOffset:d.focusOffset}),Se$1&&Je$1(Se$1,d)||(Se$1=d,d=oe$1(Re$1,"onSelect"),0<d.length&&(b=new td("onSelect","select",null,b,c),a.push({event:b,listeners:d}),b.target=Qe)));}
	Pc("cancel cancel click click close close contextmenu contextMenu copy copy cut cut auxclick auxClick dblclick doubleClick dragend dragEnd dragstart dragStart drop drop focusin focus focusout blur input input invalid invalid keydown keyDown keypress keyPress keyup keyUp mousedown mouseDown mouseup mouseUp paste paste pause pause play play pointercancel pointerCancel pointerdown pointerDown pointerup pointerUp ratechange rateChange reset reset seeked seeked submit submit touchcancel touchCancel touchend touchEnd touchstart touchStart volumechange volumeChange".split(" "),
	0);Pc("drag drag dragenter dragEnter dragexit dragExit dragleave dragLeave dragover dragOver mousemove mouseMove mouseout mouseOut mouseover mouseOver pointermove pointerMove pointerout pointerOut pointerover pointerOver scroll scroll toggle toggle touchmove touchMove wheel wheel".split(" "),1);Pc(Oc,2);for(var Ve$1="change selectionchange textInput compositionstart compositionend compositionupdate".split(" "),We$1=0;We$1<Ve$1.length;We$1++)Nc.set(Ve$1[We$1],0);ea("onMouseEnter",["mouseout","mouseover"]);
	ea("onMouseLeave",["mouseout","mouseover"]);ea("onPointerEnter",["pointerout","pointerover"]);ea("onPointerLeave",["pointerout","pointerover"]);da("onChange","change click focusin focusout input keydown keyup selectionchange".split(" "));da("onSelect","focusout contextmenu dragend focusin keydown keyup mousedown mouseup selectionchange".split(" "));da("onBeforeInput",["compositionend","keypress","textInput","paste"]);da("onCompositionEnd","compositionend focusout keydown keypress keyup mousedown".split(" "));
	da("onCompositionStart","compositionstart focusout keydown keypress keyup mousedown".split(" "));da("onCompositionUpdate","compositionupdate focusout keydown keypress keyup mousedown".split(" "));var Xe$1="abort canplay canplaythrough durationchange emptied encrypted ended error loadeddata loadedmetadata loadstart pause play playing progress ratechange seeked seeking stalled suspend timeupdate volumechange waiting".split(" "),Ye$1=new Set("cancel close invalid load scroll toggle".split(" ").concat(Xe$1));
	function Ze$1(a,b,c){var d=a.type||"unknown-event";a.currentTarget=c;Yb(d,b,void 0,a);a.currentTarget=null;}
	function se$1(a,b){b=0!==(b&4);for(var c=0;c<a.length;c++){var d=a[c],e=d.event;d=d.listeners;a:{var f=void 0;if(b)for(var g=d.length-1;0<=g;g--){var h=d[g],k=h.instance,l=h.currentTarget;h=h.listener;if(k!==f&&e.isPropagationStopped())break a;Ze$1(e,h,l);f=k;}else for(g=0;g<d.length;g++){h=d[g];k=h.instance;l=h.currentTarget;h=h.listener;if(k!==f&&e.isPropagationStopped())break a;Ze$1(e,h,l);f=k;}}}if(Ub)throw a=Vb,Ub=!1,Vb=null,a;}
	function G$1(a,b){var c=$e$1(b),d=a+"__bubble";c.has(d)||(af(b,a,2,!1),c.add(d));}var bf="_reactListening"+Math.random().toString(36).slice(2);function cf(a){a[bf]||(a[bf]=!0,ba.forEach(function(b){Ye$1.has(b)||df(b,!1,a,null);df(b,!0,a,null);}));}
	function df(a,b,c,d){var e=4<arguments.length&&void 0!==arguments[4]?arguments[4]:0,f=c;"selectionchange"===a&&9!==c.nodeType&&(f=c.ownerDocument);if(null!==d&&!b&&Ye$1.has(a)){if("scroll"!==a)return;e|=2;f=d;}var g=$e$1(f),h=a+"__"+(b?"capture":"bubble");g.has(h)||(b&&(e|=4),af(f,a,e,b),g.add(h));}
	function af(a,b,c,d){var e=Nc.get(b);switch(void 0===e?2:e){case 0:e=gd;break;case 1:e=id;break;default:e=hd;}c=e.bind(null,b,c,a);e=void 0;!Pb||"touchstart"!==b&&"touchmove"!==b&&"wheel"!==b||(e=!0);d?void 0!==e?a.addEventListener(b,c,{capture:!0,passive:e}):a.addEventListener(b,c,!0):void 0!==e?a.addEventListener(b,c,{passive:e}):a.addEventListener(b,c,!1);}
	function jd(a,b,c,d,e){var f=d;if(0===(b&1)&&0===(b&2)&&null!==d)a:for(;;){if(null===d)return;var g=d.tag;if(3===g||4===g){var h=d.stateNode.containerInfo;if(h===e||8===h.nodeType&&h.parentNode===e)break;if(4===g)for(g=d.return;null!==g;){var k=g.tag;if(3===k||4===k)if(k=g.stateNode.containerInfo,k===e||8===k.nodeType&&k.parentNode===e)return;g=g.return;}for(;null!==h;){g=wc(h);if(null===g)return;k=g.tag;if(5===k||6===k){d=f=g;continue a}h=h.parentNode;}}d=d.return;}Nb(function(){var d=f,e=xb(c),g=[];
	a:{var h=Mc.get(a);if(void 0!==h){var k=td,x=a;switch(a){case "keypress":if(0===od(c))break a;case "keydown":case "keyup":k=Rd;break;case "focusin":x="focus";k=Fd;break;case "focusout":x="blur";k=Fd;break;case "beforeblur":case "afterblur":k=Fd;break;case "click":if(2===c.button)break a;case "auxclick":case "dblclick":case "mousedown":case "mousemove":case "mouseup":case "mouseout":case "mouseover":case "contextmenu":k=Bd;break;case "drag":case "dragend":case "dragenter":case "dragexit":case "dragleave":case "dragover":case "dragstart":case "drop":k=
	Dd;break;case "touchcancel":case "touchend":case "touchmove":case "touchstart":k=Vd;break;case Ic:case Jc:case Kc:k=Hd;break;case Lc:k=Xd;break;case "scroll":k=vd;break;case "wheel":k=Zd;break;case "copy":case "cut":case "paste":k=Jd;break;case "gotpointercapture":case "lostpointercapture":case "pointercancel":case "pointerdown":case "pointermove":case "pointerout":case "pointerover":case "pointerup":k=Td;}var w=0!==(b&4),z=!w&&"scroll"===a,u=w?null!==h?h+"Capture":null:h;w=[];for(var t=d,q;null!==
	t;){q=t;var v=q.stateNode;5===q.tag&&null!==v&&(q=v,null!==u&&(v=Ob(t,u),null!=v&&w.push(ef(t,v,q))));if(z)break;t=t.return;}0<w.length&&(h=new k(h,x,null,c,e),g.push({event:h,listeners:w}));}}if(0===(b&7)){a:{h="mouseover"===a||"pointerover"===a;k="mouseout"===a||"pointerout"===a;if(h&&0===(b&16)&&(x=c.relatedTarget||c.fromElement)&&(wc(x)||x[ff]))break a;if(k||h){h=e.window===e?e:(h=e.ownerDocument)?h.defaultView||h.parentWindow:window;if(k){if(x=c.relatedTarget||c.toElement,k=d,x=x?wc(x):null,null!==
	x&&(z=Zb(x),x!==z||5!==x.tag&&6!==x.tag))x=null;}else k=null,x=d;if(k!==x){w=Bd;v="onMouseLeave";u="onMouseEnter";t="mouse";if("pointerout"===a||"pointerover"===a)w=Td,v="onPointerLeave",u="onPointerEnter",t="pointer";z=null==k?h:ue$1(k);q=null==x?h:ue$1(x);h=new w(v,t+"leave",k,c,e);h.target=z;h.relatedTarget=q;v=null;wc(e)===d&&(w=new w(u,t+"enter",x,c,e),w.target=q,w.relatedTarget=z,v=w);z=v;if(k&&x)b:{w=k;u=x;t=0;for(q=w;q;q=gf(q))t++;q=0;for(v=u;v;v=gf(v))q++;for(;0<t-q;)w=gf(w),t--;for(;0<q-t;)u=
	gf(u),q--;for(;t--;){if(w===u||null!==u&&w===u.alternate)break b;w=gf(w);u=gf(u);}w=null;}else w=null;null!==k&&hf(g,h,k,w,!1);null!==x&&null!==z&&hf(g,z,x,w,!0);}}}a:{h=d?ue$1(d):window;k=h.nodeName&&h.nodeName.toLowerCase();if("select"===k||"input"===k&&"file"===h.type)var J=ve$1;else if(me$1(h))if(we$1)J=Fe$1;else {J=De$1;var K=Ce$1;}else (k=h.nodeName)&&"input"===k.toLowerCase()&&("checkbox"===h.type||"radio"===h.type)&&(J=Ee$1);if(J&&(J=J(a,d))){ne$1(g,J,c,e);break a}K&&K(a,h,d);"focusout"===a&&(K=h._wrapperState)&&
	K.controlled&&"number"===h.type&&bb(h,"number",h.value);}K=d?ue$1(d):window;switch(a){case "focusin":if(me$1(K)||"true"===K.contentEditable)Qe=K,Re$1=d,Se$1=null;break;case "focusout":Se$1=Re$1=Qe=null;break;case "mousedown":Te$1=!0;break;case "contextmenu":case "mouseup":case "dragend":Te$1=!1;Ue$1(g,c,e);break;case "selectionchange":if(Pe)break;case "keydown":case "keyup":Ue$1(g,c,e);}var Q;if(ae$1)b:{switch(a){case "compositionstart":var L="onCompositionStart";break b;case "compositionend":L="onCompositionEnd";break b;
	case "compositionupdate":L="onCompositionUpdate";break b}L=void 0;}else ie$1?ge$1(a,c)&&(L="onCompositionEnd"):"keydown"===a&&229===c.keyCode&&(L="onCompositionStart");L&&(de$1&&"ko"!==c.locale&&(ie$1||"onCompositionStart"!==L?"onCompositionEnd"===L&&ie$1&&(Q=nd()):(kd=e,ld="value"in kd?kd.value:kd.textContent,ie$1=!0)),K=oe$1(d,L),0<K.length&&(L=new Ld(L,a,null,c,e),g.push({event:L,listeners:K}),Q?L.data=Q:(Q=he$1(c),null!==Q&&(L.data=Q))));if(Q=ce$1?je$1(a,c):ke$1(a,c))d=oe$1(d,"onBeforeInput"),0<d.length&&(e=new Ld("onBeforeInput",
	"beforeinput",null,c,e),g.push({event:e,listeners:d}),e.data=Q);}se$1(g,b);});}function ef(a,b,c){return {instance:a,listener:b,currentTarget:c}}function oe$1(a,b){for(var c=b+"Capture",d=[];null!==a;){var e=a,f=e.stateNode;5===e.tag&&null!==f&&(e=f,f=Ob(a,c),null!=f&&d.unshift(ef(a,f,e)),f=Ob(a,b),null!=f&&d.push(ef(a,f,e)));a=a.return;}return d}function gf(a){if(null===a)return null;do a=a.return;while(a&&5!==a.tag);return a?a:null}
	function hf(a,b,c,d,e){for(var f=b._reactName,g=[];null!==c&&c!==d;){var h=c,k=h.alternate,l=h.stateNode;if(null!==k&&k===d)break;5===h.tag&&null!==l&&(h=l,e?(k=Ob(c,f),null!=k&&g.unshift(ef(c,k,h))):e||(k=Ob(c,f),null!=k&&g.push(ef(c,k,h))));c=c.return;}0!==g.length&&a.push({event:b,listeners:g});}function jf(){}var kf=null,lf=null;function mf(a,b){switch(a){case "button":case "input":case "select":case "textarea":return !!b.autoFocus}return !1}
	function nf(a,b){return "textarea"===a||"option"===a||"noscript"===a||"string"===typeof b.children||"number"===typeof b.children||"object"===typeof b.dangerouslySetInnerHTML&&null!==b.dangerouslySetInnerHTML&&null!=b.dangerouslySetInnerHTML.__html}var of="function"===typeof setTimeout?setTimeout:void 0,pf="function"===typeof clearTimeout?clearTimeout:void 0;function qf(a){1===a.nodeType?a.textContent="":9===a.nodeType&&(a=a.body,null!=a&&(a.textContent=""));}
	function rf(a){for(;null!=a;a=a.nextSibling){var b=a.nodeType;if(1===b||3===b)break}return a}function sf(a){a=a.previousSibling;for(var b=0;a;){if(8===a.nodeType){var c=a.data;if("$"===c||"$!"===c||"$?"===c){if(0===b)return a;b--;}else "/$"===c&&b++;}a=a.previousSibling;}return null}var tf=0;function uf(a){return {$$typeof:Ga,toString:a,valueOf:a}}var vf=Math.random().toString(36).slice(2),wf="__reactFiber$"+vf,xf="__reactProps$"+vf,ff="__reactContainer$"+vf,yf="__reactEvents$"+vf;
	function wc(a){var b=a[wf];if(b)return b;for(var c=a.parentNode;c;){if(b=c[ff]||c[wf]){c=b.alternate;if(null!==b.child||null!==c&&null!==c.child)for(a=sf(a);null!==a;){if(c=a[wf])return c;a=sf(a);}return b}a=c;c=a.parentNode;}return null}function Cb(a){a=a[wf]||a[ff];return !a||5!==a.tag&&6!==a.tag&&13!==a.tag&&3!==a.tag?null:a}function ue$1(a){if(5===a.tag||6===a.tag)return a.stateNode;throw Error(y$1(33));}function Db(a){return a[xf]||null}
	function $e$1(a){var b=a[yf];void 0===b&&(b=a[yf]=new Set);return b}var zf=[],Af=-1;function Bf(a){return {current:a}}function H$1(a){0>Af||(a.current=zf[Af],zf[Af]=null,Af--);}function I$1(a,b){Af++;zf[Af]=a.current;a.current=b;}var Cf={},M$1=Bf(Cf),N$1=Bf(!1),Df=Cf;
	function Ef(a,b){var c=a.type.contextTypes;if(!c)return Cf;var d=a.stateNode;if(d&&d.__reactInternalMemoizedUnmaskedChildContext===b)return d.__reactInternalMemoizedMaskedChildContext;var e={},f;for(f in c)e[f]=b[f];d&&(a=a.stateNode,a.__reactInternalMemoizedUnmaskedChildContext=b,a.__reactInternalMemoizedMaskedChildContext=e);return e}function Ff(a){a=a.childContextTypes;return null!==a&&void 0!==a}function Gf(){H$1(N$1);H$1(M$1);}function Hf(a,b,c){if(M$1.current!==Cf)throw Error(y$1(168));I$1(M$1,b);I$1(N$1,c);}
	function If(a,b,c){var d=a.stateNode;a=b.childContextTypes;if("function"!==typeof d.getChildContext)return c;d=d.getChildContext();for(var e in d)if(!(e in a))throw Error(y$1(108,Ra(b)||"Unknown",e));return m$1({},c,d)}function Jf(a){a=(a=a.stateNode)&&a.__reactInternalMemoizedMergedChildContext||Cf;Df=M$1.current;I$1(M$1,a);I$1(N$1,N$1.current);return !0}function Kf(a,b,c){var d=a.stateNode;if(!d)throw Error(y$1(169));c?(a=If(a,b,Df),d.__reactInternalMemoizedMergedChildContext=a,H$1(N$1),H$1(M$1),I$1(M$1,a)):H$1(N$1);I$1(N$1,c);}
	var Lf=null,Mf=null,Nf=r$1.unstable_runWithPriority,Of=r$1.unstable_scheduleCallback,Pf=r$1.unstable_cancelCallback,Qf=r$1.unstable_shouldYield,Rf=r$1.unstable_requestPaint,Sf=r$1.unstable_now,Tf=r$1.unstable_getCurrentPriorityLevel,Uf=r$1.unstable_ImmediatePriority,Vf=r$1.unstable_UserBlockingPriority,Wf=r$1.unstable_NormalPriority,Xf=r$1.unstable_LowPriority,Yf=r$1.unstable_IdlePriority,Zf={},$f=void 0!==Rf?Rf:function(){},ag=null,bg=null,cg=!1,dg=Sf(),O$1=1E4>dg?Sf:function(){return Sf()-dg};
	function eg(){switch(Tf()){case Uf:return 99;case Vf:return 98;case Wf:return 97;case Xf:return 96;case Yf:return 95;default:throw Error(y$1(332));}}function fg(a){switch(a){case 99:return Uf;case 98:return Vf;case 97:return Wf;case 96:return Xf;case 95:return Yf;default:throw Error(y$1(332));}}function gg(a,b){a=fg(a);return Nf(a,b)}function hg(a,b,c){a=fg(a);return Of(a,b,c)}function ig(){if(null!==bg){var a=bg;bg=null;Pf(a);}jg();}
	function jg(){if(!cg&&null!==ag){cg=!0;var a=0;try{var b=ag;gg(99,function(){for(;a<b.length;a++){var c=b[a];do c=c(!0);while(null!==c)}});ag=null;}catch(c){throw null!==ag&&(ag=ag.slice(a+1)),Of(Uf,ig),c;}finally{cg=!1;}}}var kg=ra.ReactCurrentBatchConfig;function lg(a,b){if(a&&a.defaultProps){b=m$1({},b);a=a.defaultProps;for(var c in a)void 0===b[c]&&(b[c]=a[c]);return b}return b}var mg=Bf(null),ng=null,og=null,pg=null;function qg(){pg=og=ng=null;}
	function rg(a){var b=mg.current;H$1(mg);a.type._context._currentValue=b;}function sg(a,b){for(;null!==a;){var c=a.alternate;if((a.childLanes&b)===b)if(null===c||(c.childLanes&b)===b)break;else c.childLanes|=b;else a.childLanes|=b,null!==c&&(c.childLanes|=b);a=a.return;}}function tg(a,b){ng=a;pg=og=null;a=a.dependencies;null!==a&&null!==a.firstContext&&(0!==(a.lanes&b)&&(ug=!0),a.firstContext=null);}
	function vg(a,b){if(pg!==a&&!1!==b&&0!==b){if("number"!==typeof b||1073741823===b)pg=a,b=1073741823;b={context:a,observedBits:b,next:null};if(null===og){if(null===ng)throw Error(y$1(308));og=b;ng.dependencies={lanes:0,firstContext:b,responders:null};}else og=og.next=b;}return a._currentValue}var wg=!1;function xg(a){a.updateQueue={baseState:a.memoizedState,firstBaseUpdate:null,lastBaseUpdate:null,shared:{pending:null},effects:null};}
	function yg(a,b){a=a.updateQueue;b.updateQueue===a&&(b.updateQueue={baseState:a.baseState,firstBaseUpdate:a.firstBaseUpdate,lastBaseUpdate:a.lastBaseUpdate,shared:a.shared,effects:a.effects});}function zg(a,b){return {eventTime:a,lane:b,tag:0,payload:null,callback:null,next:null}}function Ag(a,b){a=a.updateQueue;if(null!==a){a=a.shared;var c=a.pending;null===c?b.next=b:(b.next=c.next,c.next=b);a.pending=b;}}
	function Bg(a,b){var c=a.updateQueue,d=a.alternate;if(null!==d&&(d=d.updateQueue,c===d)){var e=null,f=null;c=c.firstBaseUpdate;if(null!==c){do{var g={eventTime:c.eventTime,lane:c.lane,tag:c.tag,payload:c.payload,callback:c.callback,next:null};null===f?e=f=g:f=f.next=g;c=c.next;}while(null!==c);null===f?e=f=b:f=f.next=b;}else e=f=b;c={baseState:d.baseState,firstBaseUpdate:e,lastBaseUpdate:f,shared:d.shared,effects:d.effects};a.updateQueue=c;return}a=c.lastBaseUpdate;null===a?c.firstBaseUpdate=b:a.next=
	b;c.lastBaseUpdate=b;}
	function Cg(a,b,c,d){var e=a.updateQueue;wg=!1;var f=e.firstBaseUpdate,g=e.lastBaseUpdate,h=e.shared.pending;if(null!==h){e.shared.pending=null;var k=h,l=k.next;k.next=null;null===g?f=l:g.next=l;g=k;var n=a.alternate;if(null!==n){n=n.updateQueue;var A=n.lastBaseUpdate;A!==g&&(null===A?n.firstBaseUpdate=l:A.next=l,n.lastBaseUpdate=k);}}if(null!==f){A=e.baseState;g=0;n=l=k=null;do{h=f.lane;var p=f.eventTime;if((d&h)===h){null!==n&&(n=n.next={eventTime:p,lane:0,tag:f.tag,payload:f.payload,callback:f.callback,
	next:null});a:{var C=a,x=f;h=b;p=c;switch(x.tag){case 1:C=x.payload;if("function"===typeof C){A=C.call(p,A,h);break a}A=C;break a;case 3:C.flags=C.flags&-4097|64;case 0:C=x.payload;h="function"===typeof C?C.call(p,A,h):C;if(null===h||void 0===h)break a;A=m$1({},A,h);break a;case 2:wg=!0;}}null!==f.callback&&(a.flags|=32,h=e.effects,null===h?e.effects=[f]:h.push(f));}else p={eventTime:p,lane:h,tag:f.tag,payload:f.payload,callback:f.callback,next:null},null===n?(l=n=p,k=A):n=n.next=p,g|=h;f=f.next;if(null===
	f)if(h=e.shared.pending,null===h)break;else f=h.next,h.next=null,e.lastBaseUpdate=h,e.shared.pending=null;}while(1);null===n&&(k=A);e.baseState=k;e.firstBaseUpdate=l;e.lastBaseUpdate=n;Dg|=g;a.lanes=g;a.memoizedState=A;}}function Eg(a,b,c){a=b.effects;b.effects=null;if(null!==a)for(b=0;b<a.length;b++){var d=a[b],e=d.callback;if(null!==e){d.callback=null;d=c;if("function"!==typeof e)throw Error(y$1(191,e));e.call(d);}}}var Fg=(new aa.Component).refs;
	function Gg(a,b,c,d){b=a.memoizedState;c=c(d,b);c=null===c||void 0===c?b:m$1({},b,c);a.memoizedState=c;0===a.lanes&&(a.updateQueue.baseState=c);}
	var Kg={isMounted:function(a){return (a=a._reactInternals)?Zb(a)===a:!1},enqueueSetState:function(a,b,c){a=a._reactInternals;var d=Hg(),e=Ig(a),f=zg(d,e);f.payload=b;void 0!==c&&null!==c&&(f.callback=c);Ag(a,f);Jg(a,e,d);},enqueueReplaceState:function(a,b,c){a=a._reactInternals;var d=Hg(),e=Ig(a),f=zg(d,e);f.tag=1;f.payload=b;void 0!==c&&null!==c&&(f.callback=c);Ag(a,f);Jg(a,e,d);},enqueueForceUpdate:function(a,b){a=a._reactInternals;var c=Hg(),d=Ig(a),e=zg(c,d);e.tag=2;void 0!==b&&null!==b&&(e.callback=
	b);Ag(a,e);Jg(a,d,c);}};function Lg(a,b,c,d,e,f,g){a=a.stateNode;return "function"===typeof a.shouldComponentUpdate?a.shouldComponentUpdate(d,f,g):b.prototype&&b.prototype.isPureReactComponent?!Je$1(c,d)||!Je$1(e,f):!0}
	function Mg(a,b,c){var d=!1,e=Cf;var f=b.contextType;"object"===typeof f&&null!==f?f=vg(f):(e=Ff(b)?Df:M$1.current,d=b.contextTypes,f=(d=null!==d&&void 0!==d)?Ef(a,e):Cf);b=new b(c,f);a.memoizedState=null!==b.state&&void 0!==b.state?b.state:null;b.updater=Kg;a.stateNode=b;b._reactInternals=a;d&&(a=a.stateNode,a.__reactInternalMemoizedUnmaskedChildContext=e,a.__reactInternalMemoizedMaskedChildContext=f);return b}
	function Ng(a,b,c,d){a=b.state;"function"===typeof b.componentWillReceiveProps&&b.componentWillReceiveProps(c,d);"function"===typeof b.UNSAFE_componentWillReceiveProps&&b.UNSAFE_componentWillReceiveProps(c,d);b.state!==a&&Kg.enqueueReplaceState(b,b.state,null);}
	function Og(a,b,c,d){var e=a.stateNode;e.props=c;e.state=a.memoizedState;e.refs=Fg;xg(a);var f=b.contextType;"object"===typeof f&&null!==f?e.context=vg(f):(f=Ff(b)?Df:M$1.current,e.context=Ef(a,f));Cg(a,c,e,d);e.state=a.memoizedState;f=b.getDerivedStateFromProps;"function"===typeof f&&(Gg(a,b,f,c),e.state=a.memoizedState);"function"===typeof b.getDerivedStateFromProps||"function"===typeof e.getSnapshotBeforeUpdate||"function"!==typeof e.UNSAFE_componentWillMount&&"function"!==typeof e.componentWillMount||
	(b=e.state,"function"===typeof e.componentWillMount&&e.componentWillMount(),"function"===typeof e.UNSAFE_componentWillMount&&e.UNSAFE_componentWillMount(),b!==e.state&&Kg.enqueueReplaceState(e,e.state,null),Cg(a,c,e,d),e.state=a.memoizedState);"function"===typeof e.componentDidMount&&(a.flags|=4);}var Pg=Array.isArray;
	function Qg(a,b,c){a=c.ref;if(null!==a&&"function"!==typeof a&&"object"!==typeof a){if(c._owner){c=c._owner;if(c){if(1!==c.tag)throw Error(y$1(309));var d=c.stateNode;}if(!d)throw Error(y$1(147,a));var e=""+a;if(null!==b&&null!==b.ref&&"function"===typeof b.ref&&b.ref._stringRef===e)return b.ref;b=function(a){var b=d.refs;b===Fg&&(b=d.refs={});null===a?delete b[e]:b[e]=a;};b._stringRef=e;return b}if("string"!==typeof a)throw Error(y$1(284));if(!c._owner)throw Error(y$1(290,a));}return a}
	function Rg(a,b){if("textarea"!==a.type)throw Error(y$1(31,"[object Object]"===Object.prototype.toString.call(b)?"object with keys {"+Object.keys(b).join(", ")+"}":b));}
	function Sg(a){function b(b,c){if(a){var d=b.lastEffect;null!==d?(d.nextEffect=c,b.lastEffect=c):b.firstEffect=b.lastEffect=c;c.nextEffect=null;c.flags=8;}}function c(c,d){if(!a)return null;for(;null!==d;)b(c,d),d=d.sibling;return null}function d(a,b){for(a=new Map;null!==b;)null!==b.key?a.set(b.key,b):a.set(b.index,b),b=b.sibling;return a}function e(a,b){a=Tg(a,b);a.index=0;a.sibling=null;return a}function f(b,c,d){b.index=d;if(!a)return c;d=b.alternate;if(null!==d)return d=d.index,d<c?(b.flags=2,
	c):d;b.flags=2;return c}function g(b){a&&null===b.alternate&&(b.flags=2);return b}function h(a,b,c,d){if(null===b||6!==b.tag)return b=Ug(c,a.mode,d),b.return=a,b;b=e(b,c);b.return=a;return b}function k(a,b,c,d){if(null!==b&&b.elementType===c.type)return d=e(b,c.props),d.ref=Qg(a,b,c),d.return=a,d;d=Vg(c.type,c.key,c.props,null,a.mode,d);d.ref=Qg(a,b,c);d.return=a;return d}function l(a,b,c,d){if(null===b||4!==b.tag||b.stateNode.containerInfo!==c.containerInfo||b.stateNode.implementation!==c.implementation)return b=
	Wg(c,a.mode,d),b.return=a,b;b=e(b,c.children||[]);b.return=a;return b}function n(a,b,c,d,f){if(null===b||7!==b.tag)return b=Xg(c,a.mode,d,f),b.return=a,b;b=e(b,c);b.return=a;return b}function A(a,b,c){if("string"===typeof b||"number"===typeof b)return b=Ug(""+b,a.mode,c),b.return=a,b;if("object"===typeof b&&null!==b){switch(b.$$typeof){case sa:return c=Vg(b.type,b.key,b.props,null,a.mode,c),c.ref=Qg(a,null,b),c.return=a,c;case ta:return b=Wg(b,a.mode,c),b.return=a,b}if(Pg(b)||La(b))return b=Xg(b,
	a.mode,c,null),b.return=a,b;Rg(a,b);}return null}function p(a,b,c,d){var e=null!==b?b.key:null;if("string"===typeof c||"number"===typeof c)return null!==e?null:h(a,b,""+c,d);if("object"===typeof c&&null!==c){switch(c.$$typeof){case sa:return c.key===e?c.type===ua?n(a,b,c.props.children,d,e):k(a,b,c,d):null;case ta:return c.key===e?l(a,b,c,d):null}if(Pg(c)||La(c))return null!==e?null:n(a,b,c,d,null);Rg(a,c);}return null}function C(a,b,c,d,e){if("string"===typeof d||"number"===typeof d)return a=a.get(c)||
	null,h(b,a,""+d,e);if("object"===typeof d&&null!==d){switch(d.$$typeof){case sa:return a=a.get(null===d.key?c:d.key)||null,d.type===ua?n(b,a,d.props.children,e,d.key):k(b,a,d,e);case ta:return a=a.get(null===d.key?c:d.key)||null,l(b,a,d,e)}if(Pg(d)||La(d))return a=a.get(c)||null,n(b,a,d,e,null);Rg(b,d);}return null}function x(e,g,h,k){for(var l=null,t=null,u=g,z=g=0,q=null;null!==u&&z<h.length;z++){u.index>z?(q=u,u=null):q=u.sibling;var n=p(e,u,h[z],k);if(null===n){null===u&&(u=q);break}a&&u&&null===
	n.alternate&&b(e,u);g=f(n,g,z);null===t?l=n:t.sibling=n;t=n;u=q;}if(z===h.length)return c(e,u),l;if(null===u){for(;z<h.length;z++)u=A(e,h[z],k),null!==u&&(g=f(u,g,z),null===t?l=u:t.sibling=u,t=u);return l}for(u=d(e,u);z<h.length;z++)q=C(u,e,z,h[z],k),null!==q&&(a&&null!==q.alternate&&u.delete(null===q.key?z:q.key),g=f(q,g,z),null===t?l=q:t.sibling=q,t=q);a&&u.forEach(function(a){return b(e,a)});return l}function w(e,g,h,k){var l=La(h);if("function"!==typeof l)throw Error(y$1(150));h=l.call(h);if(null==
	h)throw Error(y$1(151));for(var t=l=null,u=g,z=g=0,q=null,n=h.next();null!==u&&!n.done;z++,n=h.next()){u.index>z?(q=u,u=null):q=u.sibling;var w=p(e,u,n.value,k);if(null===w){null===u&&(u=q);break}a&&u&&null===w.alternate&&b(e,u);g=f(w,g,z);null===t?l=w:t.sibling=w;t=w;u=q;}if(n.done)return c(e,u),l;if(null===u){for(;!n.done;z++,n=h.next())n=A(e,n.value,k),null!==n&&(g=f(n,g,z),null===t?l=n:t.sibling=n,t=n);return l}for(u=d(e,u);!n.done;z++,n=h.next())n=C(u,e,z,n.value,k),null!==n&&(a&&null!==n.alternate&&
	u.delete(null===n.key?z:n.key),g=f(n,g,z),null===t?l=n:t.sibling=n,t=n);a&&u.forEach(function(a){return b(e,a)});return l}return function(a,d,f,h){var k="object"===typeof f&&null!==f&&f.type===ua&&null===f.key;k&&(f=f.props.children);var l="object"===typeof f&&null!==f;if(l)switch(f.$$typeof){case sa:a:{l=f.key;for(k=d;null!==k;){if(k.key===l){switch(k.tag){case 7:if(f.type===ua){c(a,k.sibling);d=e(k,f.props.children);d.return=a;a=d;break a}break;default:if(k.elementType===f.type){c(a,k.sibling);
	d=e(k,f.props);d.ref=Qg(a,k,f);d.return=a;a=d;break a}}c(a,k);break}else b(a,k);k=k.sibling;}f.type===ua?(d=Xg(f.props.children,a.mode,h,f.key),d.return=a,a=d):(h=Vg(f.type,f.key,f.props,null,a.mode,h),h.ref=Qg(a,d,f),h.return=a,a=h);}return g(a);case ta:a:{for(k=f.key;null!==d;){if(d.key===k)if(4===d.tag&&d.stateNode.containerInfo===f.containerInfo&&d.stateNode.implementation===f.implementation){c(a,d.sibling);d=e(d,f.children||[]);d.return=a;a=d;break a}else {c(a,d);break}else b(a,d);d=d.sibling;}d=
	Wg(f,a.mode,h);d.return=a;a=d;}return g(a)}if("string"===typeof f||"number"===typeof f)return f=""+f,null!==d&&6===d.tag?(c(a,d.sibling),d=e(d,f),d.return=a,a=d):(c(a,d),d=Ug(f,a.mode,h),d.return=a,a=d),g(a);if(Pg(f))return x(a,d,f,h);if(La(f))return w(a,d,f,h);l&&Rg(a,f);if("undefined"===typeof f&&!k)switch(a.tag){case 1:case 22:case 0:case 11:case 15:throw Error(y$1(152,Ra(a.type)||"Component"));}return c(a,d)}}var Yg=Sg(!0),Zg=Sg(!1),$g={},ah=Bf($g),bh=Bf($g),ch=Bf($g);
	function dh(a){if(a===$g)throw Error(y$1(174));return a}function eh(a,b){I$1(ch,b);I$1(bh,a);I$1(ah,$g);a=b.nodeType;switch(a){case 9:case 11:b=(b=b.documentElement)?b.namespaceURI:mb(null,"");break;default:a=8===a?b.parentNode:b,b=a.namespaceURI||null,a=a.tagName,b=mb(b,a);}H$1(ah);I$1(ah,b);}function fh(){H$1(ah);H$1(bh);H$1(ch);}function gh(a){dh(ch.current);var b=dh(ah.current);var c=mb(b,a.type);b!==c&&(I$1(bh,a),I$1(ah,c));}function hh(a){bh.current===a&&(H$1(ah),H$1(bh));}var P$1=Bf(0);
	function ih(a){for(var b=a;null!==b;){if(13===b.tag){var c=b.memoizedState;if(null!==c&&(c=c.dehydrated,null===c||"$?"===c.data||"$!"===c.data))return b}else if(19===b.tag&&void 0!==b.memoizedProps.revealOrder){if(0!==(b.flags&64))return b}else if(null!==b.child){b.child.return=b;b=b.child;continue}if(b===a)break;for(;null===b.sibling;){if(null===b.return||b.return===a)return null;b=b.return;}b.sibling.return=b.return;b=b.sibling;}return null}var jh=null,kh=null,lh=!1;
	function mh(a,b){var c=nh(5,null,null,0);c.elementType="DELETED";c.type="DELETED";c.stateNode=b;c.return=a;c.flags=8;null!==a.lastEffect?(a.lastEffect.nextEffect=c,a.lastEffect=c):a.firstEffect=a.lastEffect=c;}function oh(a,b){switch(a.tag){case 5:var c=a.type;b=1!==b.nodeType||c.toLowerCase()!==b.nodeName.toLowerCase()?null:b;return null!==b?(a.stateNode=b,!0):!1;case 6:return b=""===a.pendingProps||3!==b.nodeType?null:b,null!==b?(a.stateNode=b,!0):!1;case 13:return !1;default:return !1}}
	function ph(a){if(lh){var b=kh;if(b){var c=b;if(!oh(a,b)){b=rf(c.nextSibling);if(!b||!oh(a,b)){a.flags=a.flags&-1025|2;lh=!1;jh=a;return}mh(jh,c);}jh=a;kh=rf(b.firstChild);}else a.flags=a.flags&-1025|2,lh=!1,jh=a;}}function qh(a){for(a=a.return;null!==a&&5!==a.tag&&3!==a.tag&&13!==a.tag;)a=a.return;jh=a;}
	function rh(a){if(a!==jh)return !1;if(!lh)return qh(a),lh=!0,!1;var b=a.type;if(5!==a.tag||"head"!==b&&"body"!==b&&!nf(b,a.memoizedProps))for(b=kh;b;)mh(a,b),b=rf(b.nextSibling);qh(a);if(13===a.tag){a=a.memoizedState;a=null!==a?a.dehydrated:null;if(!a)throw Error(y$1(317));a:{a=a.nextSibling;for(b=0;a;){if(8===a.nodeType){var c=a.data;if("/$"===c){if(0===b){kh=rf(a.nextSibling);break a}b--;}else "$"!==c&&"$!"!==c&&"$?"!==c||b++;}a=a.nextSibling;}kh=null;}}else kh=jh?rf(a.stateNode.nextSibling):null;return !0}
	function sh(){kh=jh=null;lh=!1;}var th=[];function uh(){for(var a=0;a<th.length;a++)th[a]._workInProgressVersionPrimary=null;th.length=0;}var vh=ra.ReactCurrentDispatcher,wh=ra.ReactCurrentBatchConfig,xh=0,R=null,S$1=null,T$1=null,yh=!1,zh=!1;function Ah(){throw Error(y$1(321));}function Bh(a,b){if(null===b)return !1;for(var c=0;c<b.length&&c<a.length;c++)if(!He$1(a[c],b[c]))return !1;return !0}
	function Ch(a,b,c,d,e,f){xh=f;R=b;b.memoizedState=null;b.updateQueue=null;b.lanes=0;vh.current=null===a||null===a.memoizedState?Dh:Eh;a=c(d,e);if(zh){f=0;do{zh=!1;if(!(25>f))throw Error(y$1(301));f+=1;T$1=S$1=null;b.updateQueue=null;vh.current=Fh;a=c(d,e);}while(zh)}vh.current=Gh;b=null!==S$1&&null!==S$1.next;xh=0;T$1=S$1=R=null;yh=!1;if(b)throw Error(y$1(300));return a}function Hh(){var a={memoizedState:null,baseState:null,baseQueue:null,queue:null,next:null};null===T$1?R.memoizedState=T$1=a:T$1=T$1.next=a;return T$1}
	function Ih(){if(null===S$1){var a=R.alternate;a=null!==a?a.memoizedState:null;}else a=S$1.next;var b=null===T$1?R.memoizedState:T$1.next;if(null!==b)T$1=b,S$1=a;else {if(null===a)throw Error(y$1(310));S$1=a;a={memoizedState:S$1.memoizedState,baseState:S$1.baseState,baseQueue:S$1.baseQueue,queue:S$1.queue,next:null};null===T$1?R.memoizedState=T$1=a:T$1=T$1.next=a;}return T$1}function Jh(a,b){return "function"===typeof b?b(a):b}
	function Kh(a){var b=Ih(),c=b.queue;if(null===c)throw Error(y$1(311));c.lastRenderedReducer=a;var d=S$1,e=d.baseQueue,f=c.pending;if(null!==f){if(null!==e){var g=e.next;e.next=f.next;f.next=g;}d.baseQueue=e=f;c.pending=null;}if(null!==e){e=e.next;d=d.baseState;var h=g=f=null,k=e;do{var l=k.lane;if((xh&l)===l)null!==h&&(h=h.next={lane:0,action:k.action,eagerReducer:k.eagerReducer,eagerState:k.eagerState,next:null}),d=k.eagerReducer===a?k.eagerState:a(d,k.action);else {var n={lane:l,action:k.action,eagerReducer:k.eagerReducer,
	eagerState:k.eagerState,next:null};null===h?(g=h=n,f=d):h=h.next=n;R.lanes|=l;Dg|=l;}k=k.next;}while(null!==k&&k!==e);null===h?f=d:h.next=g;He$1(d,b.memoizedState)||(ug=!0);b.memoizedState=d;b.baseState=f;b.baseQueue=h;c.lastRenderedState=d;}return [b.memoizedState,c.dispatch]}
	function Lh(a){var b=Ih(),c=b.queue;if(null===c)throw Error(y$1(311));c.lastRenderedReducer=a;var d=c.dispatch,e=c.pending,f=b.memoizedState;if(null!==e){c.pending=null;var g=e=e.next;do f=a(f,g.action),g=g.next;while(g!==e);He$1(f,b.memoizedState)||(ug=!0);b.memoizedState=f;null===b.baseQueue&&(b.baseState=f);c.lastRenderedState=f;}return [f,d]}
	function Mh(a,b,c){var d=b._getVersion;d=d(b._source);var e=b._workInProgressVersionPrimary;if(null!==e)a=e===d;else if(a=a.mutableReadLanes,a=(xh&a)===a)b._workInProgressVersionPrimary=d,th.push(b);if(a)return c(b._source);th.push(b);throw Error(y$1(350));}
	function Nh(a,b,c,d){var e=U$1;if(null===e)throw Error(y$1(349));var f=b._getVersion,g=f(b._source),h=vh.current,k=h.useState(function(){return Mh(e,b,c)}),l=k[1],n=k[0];k=T$1;var A=a.memoizedState,p=A.refs,C=p.getSnapshot,x=A.source;A=A.subscribe;var w=R;a.memoizedState={refs:p,source:b,subscribe:d};h.useEffect(function(){p.getSnapshot=c;p.setSnapshot=l;var a=f(b._source);if(!He$1(g,a)){a=c(b._source);He$1(n,a)||(l(a),a=Ig(w),e.mutableReadLanes|=a&e.pendingLanes);a=e.mutableReadLanes;e.entangledLanes|=a;for(var d=
	e.entanglements,h=a;0<h;){var k=31-Vc(h),v=1<<k;d[k]|=a;h&=~v;}}},[c,b,d]);h.useEffect(function(){return d(b._source,function(){var a=p.getSnapshot,c=p.setSnapshot;try{c(a(b._source));var d=Ig(w);e.mutableReadLanes|=d&e.pendingLanes;}catch(q){c(function(){throw q;});}})},[b,d]);He$1(C,c)&&He$1(x,b)&&He$1(A,d)||(a={pending:null,dispatch:null,lastRenderedReducer:Jh,lastRenderedState:n},a.dispatch=l=Oh.bind(null,R,a),k.queue=a,k.baseQueue=null,n=Mh(e,b,c),k.memoizedState=k.baseState=n);return n}
	function Ph(a,b,c){var d=Ih();return Nh(d,a,b,c)}function Qh(a){var b=Hh();"function"===typeof a&&(a=a());b.memoizedState=b.baseState=a;a=b.queue={pending:null,dispatch:null,lastRenderedReducer:Jh,lastRenderedState:a};a=a.dispatch=Oh.bind(null,R,a);return [b.memoizedState,a]}
	function Rh(a,b,c,d){a={tag:a,create:b,destroy:c,deps:d,next:null};b=R.updateQueue;null===b?(b={lastEffect:null},R.updateQueue=b,b.lastEffect=a.next=a):(c=b.lastEffect,null===c?b.lastEffect=a.next=a:(d=c.next,c.next=a,a.next=d,b.lastEffect=a));return a}function Sh(a){var b=Hh();a={current:a};return b.memoizedState=a}function Th(){return Ih().memoizedState}function Uh(a,b,c,d){var e=Hh();R.flags|=a;e.memoizedState=Rh(1|b,c,void 0,void 0===d?null:d);}
	function Vh(a,b,c,d){var e=Ih();d=void 0===d?null:d;var f=void 0;if(null!==S$1){var g=S$1.memoizedState;f=g.destroy;if(null!==d&&Bh(d,g.deps)){Rh(b,c,f,d);return}}R.flags|=a;e.memoizedState=Rh(1|b,c,f,d);}function Wh(a,b){return Uh(516,4,a,b)}function Xh(a,b){return Vh(516,4,a,b)}function Yh(a,b){return Vh(4,2,a,b)}function Zh(a,b){if("function"===typeof b)return a=a(),b(a),function(){b(null);};if(null!==b&&void 0!==b)return a=a(),b.current=a,function(){b.current=null;}}
	function $h(a,b,c){c=null!==c&&void 0!==c?c.concat([a]):null;return Vh(4,2,Zh.bind(null,b,a),c)}function ai(){}function bi(a,b){var c=Ih();b=void 0===b?null:b;var d=c.memoizedState;if(null!==d&&null!==b&&Bh(b,d[1]))return d[0];c.memoizedState=[a,b];return a}function ci(a,b){var c=Ih();b=void 0===b?null:b;var d=c.memoizedState;if(null!==d&&null!==b&&Bh(b,d[1]))return d[0];a=a();c.memoizedState=[a,b];return a}
	function di(a,b){var c=eg();gg(98>c?98:c,function(){a(!0);});gg(97<c?97:c,function(){var c=wh.transition;wh.transition=1;try{a(!1),b();}finally{wh.transition=c;}});}
	function Oh(a,b,c){var d=Hg(),e=Ig(a),f={lane:e,action:c,eagerReducer:null,eagerState:null,next:null},g=b.pending;null===g?f.next=f:(f.next=g.next,g.next=f);b.pending=f;g=a.alternate;if(a===R||null!==g&&g===R)zh=yh=!0;else {if(0===a.lanes&&(null===g||0===g.lanes)&&(g=b.lastRenderedReducer,null!==g))try{var h=b.lastRenderedState,k=g(h,c);f.eagerReducer=g;f.eagerState=k;if(He$1(k,h))return}catch(l){}finally{}Jg(a,e,d);}}
	var Gh={readContext:vg,useCallback:Ah,useContext:Ah,useEffect:Ah,useImperativeHandle:Ah,useLayoutEffect:Ah,useMemo:Ah,useReducer:Ah,useRef:Ah,useState:Ah,useDebugValue:Ah,useDeferredValue:Ah,useTransition:Ah,useMutableSource:Ah,useOpaqueIdentifier:Ah,unstable_isNewReconciler:!1},Dh={readContext:vg,useCallback:function(a,b){Hh().memoizedState=[a,void 0===b?null:b];return a},useContext:vg,useEffect:Wh,useImperativeHandle:function(a,b,c){c=null!==c&&void 0!==c?c.concat([a]):null;return Uh(4,2,Zh.bind(null,
	b,a),c)},useLayoutEffect:function(a,b){return Uh(4,2,a,b)},useMemo:function(a,b){var c=Hh();b=void 0===b?null:b;a=a();c.memoizedState=[a,b];return a},useReducer:function(a,b,c){var d=Hh();b=void 0!==c?c(b):b;d.memoizedState=d.baseState=b;a=d.queue={pending:null,dispatch:null,lastRenderedReducer:a,lastRenderedState:b};a=a.dispatch=Oh.bind(null,R,a);return [d.memoizedState,a]},useRef:Sh,useState:Qh,useDebugValue:ai,useDeferredValue:function(a){var b=Qh(a),c=b[0],d=b[1];Wh(function(){var b=wh.transition;
	wh.transition=1;try{d(a);}finally{wh.transition=b;}},[a]);return c},useTransition:function(){var a=Qh(!1),b=a[0];a=di.bind(null,a[1]);Sh(a);return [a,b]},useMutableSource:function(a,b,c){var d=Hh();d.memoizedState={refs:{getSnapshot:b,setSnapshot:null},source:a,subscribe:c};return Nh(d,a,b,c)},useOpaqueIdentifier:function(){if(lh){var a=!1,b=uf(function(){a||(a=!0,c("r:"+(tf++).toString(36)));throw Error(y$1(355));}),c=Qh(b)[1];0===(R.mode&2)&&(R.flags|=516,Rh(5,function(){c("r:"+(tf++).toString(36));},
	void 0,null));return b}b="r:"+(tf++).toString(36);Qh(b);return b},unstable_isNewReconciler:!1},Eh={readContext:vg,useCallback:bi,useContext:vg,useEffect:Xh,useImperativeHandle:$h,useLayoutEffect:Yh,useMemo:ci,useReducer:Kh,useRef:Th,useState:function(){return Kh(Jh)},useDebugValue:ai,useDeferredValue:function(a){var b=Kh(Jh),c=b[0],d=b[1];Xh(function(){var b=wh.transition;wh.transition=1;try{d(a);}finally{wh.transition=b;}},[a]);return c},useTransition:function(){var a=Kh(Jh)[0];return [Th().current,
	a]},useMutableSource:Ph,useOpaqueIdentifier:function(){return Kh(Jh)[0]},unstable_isNewReconciler:!1},Fh={readContext:vg,useCallback:bi,useContext:vg,useEffect:Xh,useImperativeHandle:$h,useLayoutEffect:Yh,useMemo:ci,useReducer:Lh,useRef:Th,useState:function(){return Lh(Jh)},useDebugValue:ai,useDeferredValue:function(a){var b=Lh(Jh),c=b[0],d=b[1];Xh(function(){var b=wh.transition;wh.transition=1;try{d(a);}finally{wh.transition=b;}},[a]);return c},useTransition:function(){var a=Lh(Jh)[0];return [Th().current,
	a]},useMutableSource:Ph,useOpaqueIdentifier:function(){return Lh(Jh)[0]},unstable_isNewReconciler:!1},ei=ra.ReactCurrentOwner,ug=!1;function fi(a,b,c,d){b.child=null===a?Zg(b,null,c,d):Yg(b,a.child,c,d);}function gi(a,b,c,d,e){c=c.render;var f=b.ref;tg(b,e);d=Ch(a,b,c,d,f,e);if(null!==a&&!ug)return b.updateQueue=a.updateQueue,b.flags&=-517,a.lanes&=~e,hi(a,b,e);b.flags|=1;fi(a,b,d,e);return b.child}
	function ii(a,b,c,d,e,f){if(null===a){var g=c.type;if("function"===typeof g&&!ji(g)&&void 0===g.defaultProps&&null===c.compare&&void 0===c.defaultProps)return b.tag=15,b.type=g,ki(a,b,g,d,e,f);a=Vg(c.type,null,d,b,b.mode,f);a.ref=b.ref;a.return=b;return b.child=a}g=a.child;if(0===(e&f)&&(e=g.memoizedProps,c=c.compare,c=null!==c?c:Je$1,c(e,d)&&a.ref===b.ref))return hi(a,b,f);b.flags|=1;a=Tg(g,d);a.ref=b.ref;a.return=b;return b.child=a}
	function ki(a,b,c,d,e,f){if(null!==a&&Je$1(a.memoizedProps,d)&&a.ref===b.ref)if(ug=!1,0!==(f&e))0!==(a.flags&16384)&&(ug=!0);else return b.lanes=a.lanes,hi(a,b,f);return li(a,b,c,d,f)}
	function mi(a,b,c){var d=b.pendingProps,e=d.children,f=null!==a?a.memoizedState:null;if("hidden"===d.mode||"unstable-defer-without-hiding"===d.mode)if(0===(b.mode&4))b.memoizedState={baseLanes:0},ni(b,c);else if(0!==(c&1073741824))b.memoizedState={baseLanes:0},ni(b,null!==f?f.baseLanes:c);else return a=null!==f?f.baseLanes|c:c,b.lanes=b.childLanes=1073741824,b.memoizedState={baseLanes:a},ni(b,a),null;else null!==f?(d=f.baseLanes|c,b.memoizedState=null):d=c,ni(b,d);fi(a,b,e,c);return b.child}
	function oi(a,b){var c=b.ref;if(null===a&&null!==c||null!==a&&a.ref!==c)b.flags|=128;}function li(a,b,c,d,e){var f=Ff(c)?Df:M$1.current;f=Ef(b,f);tg(b,e);c=Ch(a,b,c,d,f,e);if(null!==a&&!ug)return b.updateQueue=a.updateQueue,b.flags&=-517,a.lanes&=~e,hi(a,b,e);b.flags|=1;fi(a,b,c,e);return b.child}
	function pi(a,b,c,d,e){if(Ff(c)){var f=!0;Jf(b);}else f=!1;tg(b,e);if(null===b.stateNode)null!==a&&(a.alternate=null,b.alternate=null,b.flags|=2),Mg(b,c,d),Og(b,c,d,e),d=!0;else if(null===a){var g=b.stateNode,h=b.memoizedProps;g.props=h;var k=g.context,l=c.contextType;"object"===typeof l&&null!==l?l=vg(l):(l=Ff(c)?Df:M$1.current,l=Ef(b,l));var n=c.getDerivedStateFromProps,A="function"===typeof n||"function"===typeof g.getSnapshotBeforeUpdate;A||"function"!==typeof g.UNSAFE_componentWillReceiveProps&&
	"function"!==typeof g.componentWillReceiveProps||(h!==d||k!==l)&&Ng(b,g,d,l);wg=!1;var p=b.memoizedState;g.state=p;Cg(b,d,g,e);k=b.memoizedState;h!==d||p!==k||N$1.current||wg?("function"===typeof n&&(Gg(b,c,n,d),k=b.memoizedState),(h=wg||Lg(b,c,h,d,p,k,l))?(A||"function"!==typeof g.UNSAFE_componentWillMount&&"function"!==typeof g.componentWillMount||("function"===typeof g.componentWillMount&&g.componentWillMount(),"function"===typeof g.UNSAFE_componentWillMount&&g.UNSAFE_componentWillMount()),"function"===
	typeof g.componentDidMount&&(b.flags|=4)):("function"===typeof g.componentDidMount&&(b.flags|=4),b.memoizedProps=d,b.memoizedState=k),g.props=d,g.state=k,g.context=l,d=h):("function"===typeof g.componentDidMount&&(b.flags|=4),d=!1);}else {g=b.stateNode;yg(a,b);h=b.memoizedProps;l=b.type===b.elementType?h:lg(b.type,h);g.props=l;A=b.pendingProps;p=g.context;k=c.contextType;"object"===typeof k&&null!==k?k=vg(k):(k=Ff(c)?Df:M$1.current,k=Ef(b,k));var C=c.getDerivedStateFromProps;(n="function"===typeof C||
	"function"===typeof g.getSnapshotBeforeUpdate)||"function"!==typeof g.UNSAFE_componentWillReceiveProps&&"function"!==typeof g.componentWillReceiveProps||(h!==A||p!==k)&&Ng(b,g,d,k);wg=!1;p=b.memoizedState;g.state=p;Cg(b,d,g,e);var x=b.memoizedState;h!==A||p!==x||N$1.current||wg?("function"===typeof C&&(Gg(b,c,C,d),x=b.memoizedState),(l=wg||Lg(b,c,l,d,p,x,k))?(n||"function"!==typeof g.UNSAFE_componentWillUpdate&&"function"!==typeof g.componentWillUpdate||("function"===typeof g.componentWillUpdate&&g.componentWillUpdate(d,
	x,k),"function"===typeof g.UNSAFE_componentWillUpdate&&g.UNSAFE_componentWillUpdate(d,x,k)),"function"===typeof g.componentDidUpdate&&(b.flags|=4),"function"===typeof g.getSnapshotBeforeUpdate&&(b.flags|=256)):("function"!==typeof g.componentDidUpdate||h===a.memoizedProps&&p===a.memoizedState||(b.flags|=4),"function"!==typeof g.getSnapshotBeforeUpdate||h===a.memoizedProps&&p===a.memoizedState||(b.flags|=256),b.memoizedProps=d,b.memoizedState=x),g.props=d,g.state=x,g.context=k,d=l):("function"!==typeof g.componentDidUpdate||
	h===a.memoizedProps&&p===a.memoizedState||(b.flags|=4),"function"!==typeof g.getSnapshotBeforeUpdate||h===a.memoizedProps&&p===a.memoizedState||(b.flags|=256),d=!1);}return qi(a,b,c,d,f,e)}
	function qi(a,b,c,d,e,f){oi(a,b);var g=0!==(b.flags&64);if(!d&&!g)return e&&Kf(b,c,!1),hi(a,b,f);d=b.stateNode;ei.current=b;var h=g&&"function"!==typeof c.getDerivedStateFromError?null:d.render();b.flags|=1;null!==a&&g?(b.child=Yg(b,a.child,null,f),b.child=Yg(b,null,h,f)):fi(a,b,h,f);b.memoizedState=d.state;e&&Kf(b,c,!0);return b.child}function ri(a){var b=a.stateNode;b.pendingContext?Hf(a,b.pendingContext,b.pendingContext!==b.context):b.context&&Hf(a,b.context,!1);eh(a,b.containerInfo);}
	var si={dehydrated:null,retryLane:0};
	function ti(a,b,c){var d=b.pendingProps,e=P$1.current,f=!1,g;(g=0!==(b.flags&64))||(g=null!==a&&null===a.memoizedState?!1:0!==(e&2));g?(f=!0,b.flags&=-65):null!==a&&null===a.memoizedState||void 0===d.fallback||!0===d.unstable_avoidThisFallback||(e|=1);I$1(P$1,e&1);if(null===a){void 0!==d.fallback&&ph(b);a=d.children;e=d.fallback;if(f)return a=ui(b,a,e,c),b.child.memoizedState={baseLanes:c},b.memoizedState=si,a;if("number"===typeof d.unstable_expectedLoadTime)return a=ui(b,a,e,c),b.child.memoizedState={baseLanes:c},
	b.memoizedState=si,b.lanes=33554432,a;c=vi({mode:"visible",children:a},b.mode,c,null);c.return=b;return b.child=c}if(null!==a.memoizedState){if(f)return d=wi(a,b,d.children,d.fallback,c),f=b.child,e=a.child.memoizedState,f.memoizedState=null===e?{baseLanes:c}:{baseLanes:e.baseLanes|c},f.childLanes=a.childLanes&~c,b.memoizedState=si,d;c=xi(a,b,d.children,c);b.memoizedState=null;return c}if(f)return d=wi(a,b,d.children,d.fallback,c),f=b.child,e=a.child.memoizedState,f.memoizedState=null===e?{baseLanes:c}:
	{baseLanes:e.baseLanes|c},f.childLanes=a.childLanes&~c,b.memoizedState=si,d;c=xi(a,b,d.children,c);b.memoizedState=null;return c}function ui(a,b,c,d){var e=a.mode,f=a.child;b={mode:"hidden",children:b};0===(e&2)&&null!==f?(f.childLanes=0,f.pendingProps=b):f=vi(b,e,0,null);c=Xg(c,e,d,null);f.return=a;c.return=a;f.sibling=c;a.child=f;return c}
	function xi(a,b,c,d){var e=a.child;a=e.sibling;c=Tg(e,{mode:"visible",children:c});0===(b.mode&2)&&(c.lanes=d);c.return=b;c.sibling=null;null!==a&&(a.nextEffect=null,a.flags=8,b.firstEffect=b.lastEffect=a);return b.child=c}
	function wi(a,b,c,d,e){var f=b.mode,g=a.child;a=g.sibling;var h={mode:"hidden",children:c};0===(f&2)&&b.child!==g?(c=b.child,c.childLanes=0,c.pendingProps=h,g=c.lastEffect,null!==g?(b.firstEffect=c.firstEffect,b.lastEffect=g,g.nextEffect=null):b.firstEffect=b.lastEffect=null):c=Tg(g,h);null!==a?d=Tg(a,d):(d=Xg(d,f,e,null),d.flags|=2);d.return=b;c.return=b;c.sibling=d;b.child=c;return d}function yi(a,b){a.lanes|=b;var c=a.alternate;null!==c&&(c.lanes|=b);sg(a.return,b);}
	function zi(a,b,c,d,e,f){var g=a.memoizedState;null===g?a.memoizedState={isBackwards:b,rendering:null,renderingStartTime:0,last:d,tail:c,tailMode:e,lastEffect:f}:(g.isBackwards=b,g.rendering=null,g.renderingStartTime=0,g.last=d,g.tail=c,g.tailMode=e,g.lastEffect=f);}
	function Ai(a,b,c){var d=b.pendingProps,e=d.revealOrder,f=d.tail;fi(a,b,d.children,c);d=P$1.current;if(0!==(d&2))d=d&1|2,b.flags|=64;else {if(null!==a&&0!==(a.flags&64))a:for(a=b.child;null!==a;){if(13===a.tag)null!==a.memoizedState&&yi(a,c);else if(19===a.tag)yi(a,c);else if(null!==a.child){a.child.return=a;a=a.child;continue}if(a===b)break a;for(;null===a.sibling;){if(null===a.return||a.return===b)break a;a=a.return;}a.sibling.return=a.return;a=a.sibling;}d&=1;}I$1(P$1,d);if(0===(b.mode&2))b.memoizedState=
	null;else switch(e){case "forwards":c=b.child;for(e=null;null!==c;)a=c.alternate,null!==a&&null===ih(a)&&(e=c),c=c.sibling;c=e;null===c?(e=b.child,b.child=null):(e=c.sibling,c.sibling=null);zi(b,!1,e,c,f,b.lastEffect);break;case "backwards":c=null;e=b.child;for(b.child=null;null!==e;){a=e.alternate;if(null!==a&&null===ih(a)){b.child=e;break}a=e.sibling;e.sibling=c;c=e;e=a;}zi(b,!0,c,null,f,b.lastEffect);break;case "together":zi(b,!1,null,null,void 0,b.lastEffect);break;default:b.memoizedState=null;}return b.child}
	function hi(a,b,c){null!==a&&(b.dependencies=a.dependencies);Dg|=b.lanes;if(0!==(c&b.childLanes)){if(null!==a&&b.child!==a.child)throw Error(y$1(153));if(null!==b.child){a=b.child;c=Tg(a,a.pendingProps);b.child=c;for(c.return=b;null!==a.sibling;)a=a.sibling,c=c.sibling=Tg(a,a.pendingProps),c.return=b;c.sibling=null;}return b.child}return null}var Bi,Ci,Di,Ei;
	Bi=function(a,b){for(var c=b.child;null!==c;){if(5===c.tag||6===c.tag)a.appendChild(c.stateNode);else if(4!==c.tag&&null!==c.child){c.child.return=c;c=c.child;continue}if(c===b)break;for(;null===c.sibling;){if(null===c.return||c.return===b)return;c=c.return;}c.sibling.return=c.return;c=c.sibling;}};Ci=function(){};
	Di=function(a,b,c,d){var e=a.memoizedProps;if(e!==d){a=b.stateNode;dh(ah.current);var f=null;switch(c){case "input":e=Ya(a,e);d=Ya(a,d);f=[];break;case "option":e=eb(a,e);d=eb(a,d);f=[];break;case "select":e=m$1({},e,{value:void 0});d=m$1({},d,{value:void 0});f=[];break;case "textarea":e=gb(a,e);d=gb(a,d);f=[];break;default:"function"!==typeof e.onClick&&"function"===typeof d.onClick&&(a.onclick=jf);}vb(c,d);var g;c=null;for(l in e)if(!d.hasOwnProperty(l)&&e.hasOwnProperty(l)&&null!=e[l])if("style"===
	l){var h=e[l];for(g in h)h.hasOwnProperty(g)&&(c||(c={}),c[g]="");}else "dangerouslySetInnerHTML"!==l&&"children"!==l&&"suppressContentEditableWarning"!==l&&"suppressHydrationWarning"!==l&&"autoFocus"!==l&&(ca.hasOwnProperty(l)?f||(f=[]):(f=f||[]).push(l,null));for(l in d){var k=d[l];h=null!=e?e[l]:void 0;if(d.hasOwnProperty(l)&&k!==h&&(null!=k||null!=h))if("style"===l)if(h){for(g in h)!h.hasOwnProperty(g)||k&&k.hasOwnProperty(g)||(c||(c={}),c[g]="");for(g in k)k.hasOwnProperty(g)&&h[g]!==k[g]&&(c||
	(c={}),c[g]=k[g]);}else c||(f||(f=[]),f.push(l,c)),c=k;else "dangerouslySetInnerHTML"===l?(k=k?k.__html:void 0,h=h?h.__html:void 0,null!=k&&h!==k&&(f=f||[]).push(l,k)):"children"===l?"string"!==typeof k&&"number"!==typeof k||(f=f||[]).push(l,""+k):"suppressContentEditableWarning"!==l&&"suppressHydrationWarning"!==l&&(ca.hasOwnProperty(l)?(null!=k&&"onScroll"===l&&G$1("scroll",a),f||h===k||(f=[])):"object"===typeof k&&null!==k&&k.$$typeof===Ga?k.toString():(f=f||[]).push(l,k));}c&&(f=f||[]).push("style",
	c);var l=f;if(b.updateQueue=l)b.flags|=4;}};Ei=function(a,b,c,d){c!==d&&(b.flags|=4);};function Fi(a,b){if(!lh)switch(a.tailMode){case "hidden":b=a.tail;for(var c=null;null!==b;)null!==b.alternate&&(c=b),b=b.sibling;null===c?a.tail=null:c.sibling=null;break;case "collapsed":c=a.tail;for(var d=null;null!==c;)null!==c.alternate&&(d=c),c=c.sibling;null===d?b||null===a.tail?a.tail=null:a.tail.sibling=null:d.sibling=null;}}
	function Gi(a,b,c){var d=b.pendingProps;switch(b.tag){case 2:case 16:case 15:case 0:case 11:case 7:case 8:case 12:case 9:case 14:return null;case 1:return Ff(b.type)&&Gf(),null;case 3:fh();H$1(N$1);H$1(M$1);uh();d=b.stateNode;d.pendingContext&&(d.context=d.pendingContext,d.pendingContext=null);if(null===a||null===a.child)rh(b)?b.flags|=4:d.hydrate||(b.flags|=256);Ci(b);return null;case 5:hh(b);var e=dh(ch.current);c=b.type;if(null!==a&&null!=b.stateNode)Di(a,b,c,d,e),a.ref!==b.ref&&(b.flags|=128);else {if(!d){if(null===
	b.stateNode)throw Error(y$1(166));return null}a=dh(ah.current);if(rh(b)){d=b.stateNode;c=b.type;var f=b.memoizedProps;d[wf]=b;d[xf]=f;switch(c){case "dialog":G$1("cancel",d);G$1("close",d);break;case "iframe":case "object":case "embed":G$1("load",d);break;case "video":case "audio":for(a=0;a<Xe$1.length;a++)G$1(Xe$1[a],d);break;case "source":G$1("error",d);break;case "img":case "image":case "link":G$1("error",d);G$1("load",d);break;case "details":G$1("toggle",d);break;case "input":Za(d,f);G$1("invalid",d);break;case "select":d._wrapperState=
	{wasMultiple:!!f.multiple};G$1("invalid",d);break;case "textarea":hb(d,f),G$1("invalid",d);}vb(c,f);a=null;for(var g in f)f.hasOwnProperty(g)&&(e=f[g],"children"===g?"string"===typeof e?d.textContent!==e&&(a=["children",e]):"number"===typeof e&&d.textContent!==""+e&&(a=["children",""+e]):ca.hasOwnProperty(g)&&null!=e&&"onScroll"===g&&G$1("scroll",d));switch(c){case "input":Va(d);cb(d,f,!0);break;case "textarea":Va(d);jb(d);break;case "select":case "option":break;default:"function"===typeof f.onClick&&(d.onclick=
	jf);}d=a;b.updateQueue=d;null!==d&&(b.flags|=4);}else {g=9===e.nodeType?e:e.ownerDocument;a===kb.html&&(a=lb(c));a===kb.html?"script"===c?(a=g.createElement("div"),a.innerHTML="<script>\x3c/script>",a=a.removeChild(a.firstChild)):"string"===typeof d.is?a=g.createElement(c,{is:d.is}):(a=g.createElement(c),"select"===c&&(g=a,d.multiple?g.multiple=!0:d.size&&(g.size=d.size))):a=g.createElementNS(a,c);a[wf]=b;a[xf]=d;Bi(a,b,!1,!1);b.stateNode=a;g=wb(c,d);switch(c){case "dialog":G$1("cancel",a);G$1("close",a);
	e=d;break;case "iframe":case "object":case "embed":G$1("load",a);e=d;break;case "video":case "audio":for(e=0;e<Xe$1.length;e++)G$1(Xe$1[e],a);e=d;break;case "source":G$1("error",a);e=d;break;case "img":case "image":case "link":G$1("error",a);G$1("load",a);e=d;break;case "details":G$1("toggle",a);e=d;break;case "input":Za(a,d);e=Ya(a,d);G$1("invalid",a);break;case "option":e=eb(a,d);break;case "select":a._wrapperState={wasMultiple:!!d.multiple};e=m$1({},d,{value:void 0});G$1("invalid",a);break;case "textarea":hb(a,d);e=
	gb(a,d);G$1("invalid",a);break;default:e=d;}vb(c,e);var h=e;for(f in h)if(h.hasOwnProperty(f)){var k=h[f];"style"===f?tb(a,k):"dangerouslySetInnerHTML"===f?(k=k?k.__html:void 0,null!=k&&ob(a,k)):"children"===f?"string"===typeof k?("textarea"!==c||""!==k)&&pb(a,k):"number"===typeof k&&pb(a,""+k):"suppressContentEditableWarning"!==f&&"suppressHydrationWarning"!==f&&"autoFocus"!==f&&(ca.hasOwnProperty(f)?null!=k&&"onScroll"===f&&G$1("scroll",a):null!=k&&qa(a,f,k,g));}switch(c){case "input":Va(a);cb(a,d,!1);
	break;case "textarea":Va(a);jb(a);break;case "option":null!=d.value&&a.setAttribute("value",""+Sa(d.value));break;case "select":a.multiple=!!d.multiple;f=d.value;null!=f?fb(a,!!d.multiple,f,!1):null!=d.defaultValue&&fb(a,!!d.multiple,d.defaultValue,!0);break;default:"function"===typeof e.onClick&&(a.onclick=jf);}mf(c,d)&&(b.flags|=4);}null!==b.ref&&(b.flags|=128);}return null;case 6:if(a&&null!=b.stateNode)Ei(a,b,a.memoizedProps,d);else {if("string"!==typeof d&&null===b.stateNode)throw Error(y$1(166));
	c=dh(ch.current);dh(ah.current);rh(b)?(d=b.stateNode,c=b.memoizedProps,d[wf]=b,d.nodeValue!==c&&(b.flags|=4)):(d=(9===c.nodeType?c:c.ownerDocument).createTextNode(d),d[wf]=b,b.stateNode=d);}return null;case 13:H$1(P$1);d=b.memoizedState;if(0!==(b.flags&64))return b.lanes=c,b;d=null!==d;c=!1;null===a?void 0!==b.memoizedProps.fallback&&rh(b):c=null!==a.memoizedState;if(d&&!c&&0!==(b.mode&2))if(null===a&&!0!==b.memoizedProps.unstable_avoidThisFallback||0!==(P$1.current&1))0===V$1&&(V$1=3);else {if(0===V$1||3===V$1)V$1=
	4;null===U$1||0===(Dg&134217727)&&0===(Hi&134217727)||Ii(U$1,W$1);}if(d||c)b.flags|=4;return null;case 4:return fh(),Ci(b),null===a&&cf(b.stateNode.containerInfo),null;case 10:return rg(b),null;case 17:return Ff(b.type)&&Gf(),null;case 19:H$1(P$1);d=b.memoizedState;if(null===d)return null;f=0!==(b.flags&64);g=d.rendering;if(null===g)if(f)Fi(d,!1);else {if(0!==V$1||null!==a&&0!==(a.flags&64))for(a=b.child;null!==a;){g=ih(a);if(null!==g){b.flags|=64;Fi(d,!1);f=g.updateQueue;null!==f&&(b.updateQueue=f,b.flags|=4);
	null===d.lastEffect&&(b.firstEffect=null);b.lastEffect=d.lastEffect;d=c;for(c=b.child;null!==c;)f=c,a=d,f.flags&=2,f.nextEffect=null,f.firstEffect=null,f.lastEffect=null,g=f.alternate,null===g?(f.childLanes=0,f.lanes=a,f.child=null,f.memoizedProps=null,f.memoizedState=null,f.updateQueue=null,f.dependencies=null,f.stateNode=null):(f.childLanes=g.childLanes,f.lanes=g.lanes,f.child=g.child,f.memoizedProps=g.memoizedProps,f.memoizedState=g.memoizedState,f.updateQueue=g.updateQueue,f.type=g.type,a=g.dependencies,
	f.dependencies=null===a?null:{lanes:a.lanes,firstContext:a.firstContext}),c=c.sibling;I$1(P$1,P$1.current&1|2);return b.child}a=a.sibling;}null!==d.tail&&O$1()>Ji&&(b.flags|=64,f=!0,Fi(d,!1),b.lanes=33554432);}else {if(!f)if(a=ih(g),null!==a){if(b.flags|=64,f=!0,c=a.updateQueue,null!==c&&(b.updateQueue=c,b.flags|=4),Fi(d,!0),null===d.tail&&"hidden"===d.tailMode&&!g.alternate&&!lh)return b=b.lastEffect=d.lastEffect,null!==b&&(b.nextEffect=null),null}else 2*O$1()-d.renderingStartTime>Ji&&1073741824!==c&&(b.flags|=
	64,f=!0,Fi(d,!1),b.lanes=33554432);d.isBackwards?(g.sibling=b.child,b.child=g):(c=d.last,null!==c?c.sibling=g:b.child=g,d.last=g);}return null!==d.tail?(c=d.tail,d.rendering=c,d.tail=c.sibling,d.lastEffect=b.lastEffect,d.renderingStartTime=O$1(),c.sibling=null,b=P$1.current,I$1(P$1,f?b&1|2:b&1),c):null;case 23:case 24:return Ki(),null!==a&&null!==a.memoizedState!==(null!==b.memoizedState)&&"unstable-defer-without-hiding"!==d.mode&&(b.flags|=4),null}throw Error(y$1(156,b.tag));}
	function Li(a){switch(a.tag){case 1:Ff(a.type)&&Gf();var b=a.flags;return b&4096?(a.flags=b&-4097|64,a):null;case 3:fh();H$1(N$1);H$1(M$1);uh();b=a.flags;if(0!==(b&64))throw Error(y$1(285));a.flags=b&-4097|64;return a;case 5:return hh(a),null;case 13:return H$1(P$1),b=a.flags,b&4096?(a.flags=b&-4097|64,a):null;case 19:return H$1(P$1),null;case 4:return fh(),null;case 10:return rg(a),null;case 23:case 24:return Ki(),null;default:return null}}
	function Mi(a,b){try{var c="",d=b;do c+=Qa(d),d=d.return;while(d);var e=c;}catch(f){e="\nError generating stack: "+f.message+"\n"+f.stack;}return {value:a,source:b,stack:e}}function Ni(a,b){try{console.error(b.value);}catch(c){setTimeout(function(){throw c;});}}var Oi="function"===typeof WeakMap?WeakMap:Map;function Pi(a,b,c){c=zg(-1,c);c.tag=3;c.payload={element:null};var d=b.value;c.callback=function(){Qi||(Qi=!0,Ri=d);Ni(a,b);};return c}
	function Si(a,b,c){c=zg(-1,c);c.tag=3;var d=a.type.getDerivedStateFromError;if("function"===typeof d){var e=b.value;c.payload=function(){Ni(a,b);return d(e)};}var f=a.stateNode;null!==f&&"function"===typeof f.componentDidCatch&&(c.callback=function(){"function"!==typeof d&&(null===Ti?Ti=new Set([this]):Ti.add(this),Ni(a,b));var c=b.stack;this.componentDidCatch(b.value,{componentStack:null!==c?c:""});});return c}var Ui="function"===typeof WeakSet?WeakSet:Set;
	function Vi(a){var b=a.ref;if(null!==b)if("function"===typeof b)try{b(null);}catch(c){Wi(a,c);}else b.current=null;}function Xi(a,b){switch(b.tag){case 0:case 11:case 15:case 22:return;case 1:if(b.flags&256&&null!==a){var c=a.memoizedProps,d=a.memoizedState;a=b.stateNode;b=a.getSnapshotBeforeUpdate(b.elementType===b.type?c:lg(b.type,c),d);a.__reactInternalSnapshotBeforeUpdate=b;}return;case 3:b.flags&256&&qf(b.stateNode.containerInfo);return;case 5:case 6:case 4:case 17:return}throw Error(y$1(163));}
	function Yi(a,b,c){switch(c.tag){case 0:case 11:case 15:case 22:b=c.updateQueue;b=null!==b?b.lastEffect:null;if(null!==b){a=b=b.next;do{if(3===(a.tag&3)){var d=a.create;a.destroy=d();}a=a.next;}while(a!==b)}b=c.updateQueue;b=null!==b?b.lastEffect:null;if(null!==b){a=b=b.next;do{var e=a;d=e.next;e=e.tag;0!==(e&4)&&0!==(e&1)&&(Zi(c,a),$i(c,a));a=d;}while(a!==b)}return;case 1:a=c.stateNode;c.flags&4&&(null===b?a.componentDidMount():(d=c.elementType===c.type?b.memoizedProps:lg(c.type,b.memoizedProps),a.componentDidUpdate(d,
	b.memoizedState,a.__reactInternalSnapshotBeforeUpdate)));b=c.updateQueue;null!==b&&Eg(c,b,a);return;case 3:b=c.updateQueue;if(null!==b){a=null;if(null!==c.child)switch(c.child.tag){case 5:a=c.child.stateNode;break;case 1:a=c.child.stateNode;}Eg(c,b,a);}return;case 5:a=c.stateNode;null===b&&c.flags&4&&mf(c.type,c.memoizedProps)&&a.focus();return;case 6:return;case 4:return;case 12:return;case 13:null===c.memoizedState&&(c=c.alternate,null!==c&&(c=c.memoizedState,null!==c&&(c=c.dehydrated,null!==c&&Cc(c))));
	return;case 19:case 17:case 20:case 21:case 23:case 24:return}throw Error(y$1(163));}
	function aj(a,b){for(var c=a;;){if(5===c.tag){var d=c.stateNode;if(b)d=d.style,"function"===typeof d.setProperty?d.setProperty("display","none","important"):d.display="none";else {d=c.stateNode;var e=c.memoizedProps.style;e=void 0!==e&&null!==e&&e.hasOwnProperty("display")?e.display:null;d.style.display=sb("display",e);}}else if(6===c.tag)c.stateNode.nodeValue=b?"":c.memoizedProps;else if((23!==c.tag&&24!==c.tag||null===c.memoizedState||c===a)&&null!==c.child){c.child.return=c;c=c.child;continue}if(c===
	a)break;for(;null===c.sibling;){if(null===c.return||c.return===a)return;c=c.return;}c.sibling.return=c.return;c=c.sibling;}}
	function bj(a,b){if(Mf&&"function"===typeof Mf.onCommitFiberUnmount)try{Mf.onCommitFiberUnmount(Lf,b);}catch(f){}switch(b.tag){case 0:case 11:case 14:case 15:case 22:a=b.updateQueue;if(null!==a&&(a=a.lastEffect,null!==a)){var c=a=a.next;do{var d=c,e=d.destroy;d=d.tag;if(void 0!==e)if(0!==(d&4))Zi(b,c);else {d=b;try{e();}catch(f){Wi(d,f);}}c=c.next;}while(c!==a)}break;case 1:Vi(b);a=b.stateNode;if("function"===typeof a.componentWillUnmount)try{a.props=b.memoizedProps,a.state=b.memoizedState,a.componentWillUnmount();}catch(f){Wi(b,
	f);}break;case 5:Vi(b);break;case 4:cj(a,b);}}function dj(a){a.alternate=null;a.child=null;a.dependencies=null;a.firstEffect=null;a.lastEffect=null;a.memoizedProps=null;a.memoizedState=null;a.pendingProps=null;a.return=null;a.updateQueue=null;}function ej(a){return 5===a.tag||3===a.tag||4===a.tag}
	function fj(a){a:{for(var b=a.return;null!==b;){if(ej(b))break a;b=b.return;}throw Error(y$1(160));}var c=b;b=c.stateNode;switch(c.tag){case 5:var d=!1;break;case 3:b=b.containerInfo;d=!0;break;case 4:b=b.containerInfo;d=!0;break;default:throw Error(y$1(161));}c.flags&16&&(pb(b,""),c.flags&=-17);a:b:for(c=a;;){for(;null===c.sibling;){if(null===c.return||ej(c.return)){c=null;break a}c=c.return;}c.sibling.return=c.return;for(c=c.sibling;5!==c.tag&&6!==c.tag&&18!==c.tag;){if(c.flags&2)continue b;if(null===
	c.child||4===c.tag)continue b;else c.child.return=c,c=c.child;}if(!(c.flags&2)){c=c.stateNode;break a}}d?gj(a,c,b):hj(a,c,b);}
	function gj(a,b,c){var d=a.tag,e=5===d||6===d;if(e)a=e?a.stateNode:a.stateNode.instance,b?8===c.nodeType?c.parentNode.insertBefore(a,b):c.insertBefore(a,b):(8===c.nodeType?(b=c.parentNode,b.insertBefore(a,c)):(b=c,b.appendChild(a)),c=c._reactRootContainer,null!==c&&void 0!==c||null!==b.onclick||(b.onclick=jf));else if(4!==d&&(a=a.child,null!==a))for(gj(a,b,c),a=a.sibling;null!==a;)gj(a,b,c),a=a.sibling;}
	function hj(a,b,c){var d=a.tag,e=5===d||6===d;if(e)a=e?a.stateNode:a.stateNode.instance,b?c.insertBefore(a,b):c.appendChild(a);else if(4!==d&&(a=a.child,null!==a))for(hj(a,b,c),a=a.sibling;null!==a;)hj(a,b,c),a=a.sibling;}
	function cj(a,b){for(var c=b,d=!1,e,f;;){if(!d){d=c.return;a:for(;;){if(null===d)throw Error(y$1(160));e=d.stateNode;switch(d.tag){case 5:f=!1;break a;case 3:e=e.containerInfo;f=!0;break a;case 4:e=e.containerInfo;f=!0;break a}d=d.return;}d=!0;}if(5===c.tag||6===c.tag){a:for(var g=a,h=c,k=h;;)if(bj(g,k),null!==k.child&&4!==k.tag)k.child.return=k,k=k.child;else {if(k===h)break a;for(;null===k.sibling;){if(null===k.return||k.return===h)break a;k=k.return;}k.sibling.return=k.return;k=k.sibling;}f?(g=e,h=c.stateNode,
	8===g.nodeType?g.parentNode.removeChild(h):g.removeChild(h)):e.removeChild(c.stateNode);}else if(4===c.tag){if(null!==c.child){e=c.stateNode.containerInfo;f=!0;c.child.return=c;c=c.child;continue}}else if(bj(a,c),null!==c.child){c.child.return=c;c=c.child;continue}if(c===b)break;for(;null===c.sibling;){if(null===c.return||c.return===b)return;c=c.return;4===c.tag&&(d=!1);}c.sibling.return=c.return;c=c.sibling;}}
	function ij(a,b){switch(b.tag){case 0:case 11:case 14:case 15:case 22:var c=b.updateQueue;c=null!==c?c.lastEffect:null;if(null!==c){var d=c=c.next;do 3===(d.tag&3)&&(a=d.destroy,d.destroy=void 0,void 0!==a&&a()),d=d.next;while(d!==c)}return;case 1:return;case 5:c=b.stateNode;if(null!=c){d=b.memoizedProps;var e=null!==a?a.memoizedProps:d;a=b.type;var f=b.updateQueue;b.updateQueue=null;if(null!==f){c[xf]=d;"input"===a&&"radio"===d.type&&null!=d.name&&$a(c,d);wb(a,e);b=wb(a,d);for(e=0;e<f.length;e+=
	2){var g=f[e],h=f[e+1];"style"===g?tb(c,h):"dangerouslySetInnerHTML"===g?ob(c,h):"children"===g?pb(c,h):qa(c,g,h,b);}switch(a){case "input":ab(c,d);break;case "textarea":ib(c,d);break;case "select":a=c._wrapperState.wasMultiple,c._wrapperState.wasMultiple=!!d.multiple,f=d.value,null!=f?fb(c,!!d.multiple,f,!1):a!==!!d.multiple&&(null!=d.defaultValue?fb(c,!!d.multiple,d.defaultValue,!0):fb(c,!!d.multiple,d.multiple?[]:"",!1));}}}return;case 6:if(null===b.stateNode)throw Error(y$1(162));b.stateNode.nodeValue=
	b.memoizedProps;return;case 3:c=b.stateNode;c.hydrate&&(c.hydrate=!1,Cc(c.containerInfo));return;case 12:return;case 13:null!==b.memoizedState&&(jj=O$1(),aj(b.child,!0));kj(b);return;case 19:kj(b);return;case 17:return;case 23:case 24:aj(b,null!==b.memoizedState);return}throw Error(y$1(163));}function kj(a){var b=a.updateQueue;if(null!==b){a.updateQueue=null;var c=a.stateNode;null===c&&(c=a.stateNode=new Ui);b.forEach(function(b){var d=lj.bind(null,a,b);c.has(b)||(c.add(b),b.then(d,d));});}}
	function mj(a,b){return null!==a&&(a=a.memoizedState,null===a||null!==a.dehydrated)?(b=b.memoizedState,null!==b&&null===b.dehydrated):!1}var nj=Math.ceil,oj=ra.ReactCurrentDispatcher,pj=ra.ReactCurrentOwner,X$1=0,U$1=null,Y$1=null,W$1=0,qj=0,rj=Bf(0),V$1=0,sj=null,tj=0,Dg=0,Hi=0,uj=0,vj=null,jj=0,Ji=Infinity;function wj(){Ji=O$1()+500;}var Z$1=null,Qi=!1,Ri=null,Ti=null,xj=!1,yj=null,zj=90,Aj=[],Bj=[],Cj=null,Dj=0,Ej=null,Fj=-1,Gj=0,Hj=0,Ij=null,Jj=!1;function Hg(){return 0!==(X$1&48)?O$1():-1!==Fj?Fj:Fj=O$1()}
	function Ig(a){a=a.mode;if(0===(a&2))return 1;if(0===(a&4))return 99===eg()?1:2;0===Gj&&(Gj=tj);if(0!==kg.transition){0!==Hj&&(Hj=null!==vj?vj.pendingLanes:0);a=Gj;var b=4186112&~Hj;b&=-b;0===b&&(a=4186112&~a,b=a&-a,0===b&&(b=8192));return b}a=eg();0!==(X$1&4)&&98===a?a=Xc(12,Gj):(a=Sc(a),a=Xc(a,Gj));return a}
	function Jg(a,b,c){if(50<Dj)throw Dj=0,Ej=null,Error(y$1(185));a=Kj(a,b);if(null===a)return null;$c(a,b,c);a===U$1&&(Hi|=b,4===V$1&&Ii(a,W$1));var d=eg();1===b?0!==(X$1&8)&&0===(X$1&48)?Lj(a):(Mj(a,c),0===X$1&&(wj(),ig())):(0===(X$1&4)||98!==d&&99!==d||(null===Cj?Cj=new Set([a]):Cj.add(a)),Mj(a,c));vj=a;}function Kj(a,b){a.lanes|=b;var c=a.alternate;null!==c&&(c.lanes|=b);c=a;for(a=a.return;null!==a;)a.childLanes|=b,c=a.alternate,null!==c&&(c.childLanes|=b),c=a,a=a.return;return 3===c.tag?c.stateNode:null}
	function Mj(a,b){for(var c=a.callbackNode,d=a.suspendedLanes,e=a.pingedLanes,f=a.expirationTimes,g=a.pendingLanes;0<g;){var h=31-Vc(g),k=1<<h,l=f[h];if(-1===l){if(0===(k&d)||0!==(k&e)){l=b;Rc(k);var n=F$1;f[h]=10<=n?l+250:6<=n?l+5E3:-1;}}else l<=b&&(a.expiredLanes|=k);g&=~k;}d=Uc(a,a===U$1?W$1:0);b=F$1;if(0===d)null!==c&&(c!==Zf&&Pf(c),a.callbackNode=null,a.callbackPriority=0);else {if(null!==c){if(a.callbackPriority===b)return;c!==Zf&&Pf(c);}15===b?(c=Lj.bind(null,a),null===ag?(ag=[c],bg=Of(Uf,jg)):ag.push(c),
	c=Zf):14===b?c=hg(99,Lj.bind(null,a)):(c=Tc(b),c=hg(c,Nj.bind(null,a)));a.callbackPriority=b;a.callbackNode=c;}}
	function Nj(a){Fj=-1;Hj=Gj=0;if(0!==(X$1&48))throw Error(y$1(327));var b=a.callbackNode;if(Oj()&&a.callbackNode!==b)return null;var c=Uc(a,a===U$1?W$1:0);if(0===c)return null;var d=c;var e=X$1;X$1|=16;var f=Pj();if(U$1!==a||W$1!==d)wj(),Qj(a,d);do try{Rj();break}catch(h){Sj(a,h);}while(1);qg();oj.current=f;X$1=e;null!==Y$1?d=0:(U$1=null,W$1=0,d=V$1);if(0!==(tj&Hi))Qj(a,0);else if(0!==d){2===d&&(X$1|=64,a.hydrate&&(a.hydrate=!1,qf(a.containerInfo)),c=Wc(a),0!==c&&(d=Tj(a,c)));if(1===d)throw b=sj,Qj(a,0),Ii(a,c),Mj(a,O$1()),b;a.finishedWork=
	a.current.alternate;a.finishedLanes=c;switch(d){case 0:case 1:throw Error(y$1(345));case 2:Uj(a);break;case 3:Ii(a,c);if((c&62914560)===c&&(d=jj+500-O$1(),10<d)){if(0!==Uc(a,0))break;e=a.suspendedLanes;if((e&c)!==c){Hg();a.pingedLanes|=a.suspendedLanes&e;break}a.timeoutHandle=of(Uj.bind(null,a),d);break}Uj(a);break;case 4:Ii(a,c);if((c&4186112)===c)break;d=a.eventTimes;for(e=-1;0<c;){var g=31-Vc(c);f=1<<g;g=d[g];g>e&&(e=g);c&=~f;}c=e;c=O$1()-c;c=(120>c?120:480>c?480:1080>c?1080:1920>c?1920:3E3>c?3E3:4320>
	c?4320:1960*nj(c/1960))-c;if(10<c){a.timeoutHandle=of(Uj.bind(null,a),c);break}Uj(a);break;case 5:Uj(a);break;default:throw Error(y$1(329));}}Mj(a,O$1());return a.callbackNode===b?Nj.bind(null,a):null}function Ii(a,b){b&=~uj;b&=~Hi;a.suspendedLanes|=b;a.pingedLanes&=~b;for(a=a.expirationTimes;0<b;){var c=31-Vc(b),d=1<<c;a[c]=-1;b&=~d;}}
	function Lj(a){if(0!==(X$1&48))throw Error(y$1(327));Oj();if(a===U$1&&0!==(a.expiredLanes&W$1)){var b=W$1;var c=Tj(a,b);0!==(tj&Hi)&&(b=Uc(a,b),c=Tj(a,b));}else b=Uc(a,0),c=Tj(a,b);0!==a.tag&&2===c&&(X$1|=64,a.hydrate&&(a.hydrate=!1,qf(a.containerInfo)),b=Wc(a),0!==b&&(c=Tj(a,b)));if(1===c)throw c=sj,Qj(a,0),Ii(a,b),Mj(a,O$1()),c;a.finishedWork=a.current.alternate;a.finishedLanes=b;Uj(a);Mj(a,O$1());return null}
	function Vj(){if(null!==Cj){var a=Cj;Cj=null;a.forEach(function(a){a.expiredLanes|=24&a.pendingLanes;Mj(a,O$1());});}ig();}function Wj(a,b){var c=X$1;X$1|=1;try{return a(b)}finally{X$1=c,0===X$1&&(wj(),ig());}}function Xj(a,b){var c=X$1;X$1&=-2;X$1|=8;try{return a(b)}finally{X$1=c,0===X$1&&(wj(),ig());}}function ni(a,b){I$1(rj,qj);qj|=b;tj|=b;}function Ki(){qj=rj.current;H$1(rj);}
	function Qj(a,b){a.finishedWork=null;a.finishedLanes=0;var c=a.timeoutHandle;-1!==c&&(a.timeoutHandle=-1,pf(c));if(null!==Y$1)for(c=Y$1.return;null!==c;){var d=c;switch(d.tag){case 1:d=d.type.childContextTypes;null!==d&&void 0!==d&&Gf();break;case 3:fh();H$1(N$1);H$1(M$1);uh();break;case 5:hh(d);break;case 4:fh();break;case 13:H$1(P$1);break;case 19:H$1(P$1);break;case 10:rg(d);break;case 23:case 24:Ki();}c=c.return;}U$1=a;Y$1=Tg(a.current,null);W$1=qj=tj=b;V$1=0;sj=null;uj=Hi=Dg=0;}
	function Sj(a,b){do{var c=Y$1;try{qg();vh.current=Gh;if(yh){for(var d=R.memoizedState;null!==d;){var e=d.queue;null!==e&&(e.pending=null);d=d.next;}yh=!1;}xh=0;T$1=S$1=R=null;zh=!1;pj.current=null;if(null===c||null===c.return){V$1=1;sj=b;Y$1=null;break}a:{var f=a,g=c.return,h=c,k=b;b=W$1;h.flags|=2048;h.firstEffect=h.lastEffect=null;if(null!==k&&"object"===typeof k&&"function"===typeof k.then){var l=k;if(0===(h.mode&2)){var n=h.alternate;n?(h.updateQueue=n.updateQueue,h.memoizedState=n.memoizedState,h.lanes=n.lanes):
	(h.updateQueue=null,h.memoizedState=null);}var A=0!==(P$1.current&1),p=g;do{var C;if(C=13===p.tag){var x=p.memoizedState;if(null!==x)C=null!==x.dehydrated?!0:!1;else {var w=p.memoizedProps;C=void 0===w.fallback?!1:!0!==w.unstable_avoidThisFallback?!0:A?!1:!0;}}if(C){var z=p.updateQueue;if(null===z){var u=new Set;u.add(l);p.updateQueue=u;}else z.add(l);if(0===(p.mode&2)){p.flags|=64;h.flags|=16384;h.flags&=-2981;if(1===h.tag)if(null===h.alternate)h.tag=17;else {var t=zg(-1,1);t.tag=2;Ag(h,t);}h.lanes|=1;break a}k=
	void 0;h=b;var q=f.pingCache;null===q?(q=f.pingCache=new Oi,k=new Set,q.set(l,k)):(k=q.get(l),void 0===k&&(k=new Set,q.set(l,k)));if(!k.has(h)){k.add(h);var v=Yj.bind(null,f,l,h);l.then(v,v);}p.flags|=4096;p.lanes=b;break a}p=p.return;}while(null!==p);k=Error((Ra(h.type)||"A React component")+" suspended while rendering, but no fallback UI was specified.\n\nAdd a <Suspense fallback=...> component higher in the tree to provide a loading indicator or placeholder to display.");}5!==V$1&&(V$1=2);k=Mi(k,h);p=
	g;do{switch(p.tag){case 3:f=k;p.flags|=4096;b&=-b;p.lanes|=b;var J=Pi(p,f,b);Bg(p,J);break a;case 1:f=k;var K=p.type,Q=p.stateNode;if(0===(p.flags&64)&&("function"===typeof K.getDerivedStateFromError||null!==Q&&"function"===typeof Q.componentDidCatch&&(null===Ti||!Ti.has(Q)))){p.flags|=4096;b&=-b;p.lanes|=b;var L=Si(p,f,b);Bg(p,L);break a}}p=p.return;}while(null!==p)}Zj(c);}catch(va){b=va;Y$1===c&&null!==c&&(Y$1=c=c.return);continue}break}while(1)}
	function Pj(){var a=oj.current;oj.current=Gh;return null===a?Gh:a}function Tj(a,b){var c=X$1;X$1|=16;var d=Pj();U$1===a&&W$1===b||Qj(a,b);do try{ak();break}catch(e){Sj(a,e);}while(1);qg();X$1=c;oj.current=d;if(null!==Y$1)throw Error(y$1(261));U$1=null;W$1=0;return V$1}function ak(){for(;null!==Y$1;)bk(Y$1);}function Rj(){for(;null!==Y$1&&!Qf();)bk(Y$1);}function bk(a){var b=ck(a.alternate,a,qj);a.memoizedProps=a.pendingProps;null===b?Zj(a):Y$1=b;pj.current=null;}
	function Zj(a){var b=a;do{var c=b.alternate;a=b.return;if(0===(b.flags&2048)){c=Gi(c,b,qj);if(null!==c){Y$1=c;return}c=b;if(24!==c.tag&&23!==c.tag||null===c.memoizedState||0!==(qj&1073741824)||0===(c.mode&4)){for(var d=0,e=c.child;null!==e;)d|=e.lanes|e.childLanes,e=e.sibling;c.childLanes=d;}null!==a&&0===(a.flags&2048)&&(null===a.firstEffect&&(a.firstEffect=b.firstEffect),null!==b.lastEffect&&(null!==a.lastEffect&&(a.lastEffect.nextEffect=b.firstEffect),a.lastEffect=b.lastEffect),1<b.flags&&(null!==
	a.lastEffect?a.lastEffect.nextEffect=b:a.firstEffect=b,a.lastEffect=b));}else {c=Li(b);if(null!==c){c.flags&=2047;Y$1=c;return}null!==a&&(a.firstEffect=a.lastEffect=null,a.flags|=2048);}b=b.sibling;if(null!==b){Y$1=b;return}Y$1=b=a;}while(null!==b);0===V$1&&(V$1=5);}function Uj(a){var b=eg();gg(99,dk.bind(null,a,b));return null}
	function dk(a,b){do Oj();while(null!==yj);if(0!==(X$1&48))throw Error(y$1(327));var c=a.finishedWork;if(null===c)return null;a.finishedWork=null;a.finishedLanes=0;if(c===a.current)throw Error(y$1(177));a.callbackNode=null;var d=c.lanes|c.childLanes,e=d,f=a.pendingLanes&~e;a.pendingLanes=e;a.suspendedLanes=0;a.pingedLanes=0;a.expiredLanes&=e;a.mutableReadLanes&=e;a.entangledLanes&=e;e=a.entanglements;for(var g=a.eventTimes,h=a.expirationTimes;0<f;){var k=31-Vc(f),l=1<<k;e[k]=0;g[k]=-1;h[k]=-1;f&=~l;}null!==
	Cj&&0===(d&24)&&Cj.has(a)&&Cj.delete(a);a===U$1&&(Y$1=U$1=null,W$1=0);1<c.flags?null!==c.lastEffect?(c.lastEffect.nextEffect=c,d=c.firstEffect):d=c:d=c.firstEffect;if(null!==d){e=X$1;X$1|=32;pj.current=null;kf=fd;g=Ne$1();if(Oe(g)){if("selectionStart"in g)h={start:g.selectionStart,end:g.selectionEnd};else a:if(h=(h=g.ownerDocument)&&h.defaultView||window,(l=h.getSelection&&h.getSelection())&&0!==l.rangeCount){h=l.anchorNode;f=l.anchorOffset;k=l.focusNode;l=l.focusOffset;try{h.nodeType,k.nodeType;}catch(va){h=null;
	break a}var n=0,A=-1,p=-1,C=0,x=0,w=g,z=null;b:for(;;){for(var u;;){w!==h||0!==f&&3!==w.nodeType||(A=n+f);w!==k||0!==l&&3!==w.nodeType||(p=n+l);3===w.nodeType&&(n+=w.nodeValue.length);if(null===(u=w.firstChild))break;z=w;w=u;}for(;;){if(w===g)break b;z===h&&++C===f&&(A=n);z===k&&++x===l&&(p=n);if(null!==(u=w.nextSibling))break;w=z;z=w.parentNode;}w=u;}h=-1===A||-1===p?null:{start:A,end:p};}else h=null;h=h||{start:0,end:0};}else h=null;lf={focusedElem:g,selectionRange:h};fd=!1;Ij=null;Jj=!1;Z$1=d;do try{ek();}catch(va){if(null===
	Z$1)throw Error(y$1(330));Wi(Z$1,va);Z$1=Z$1.nextEffect;}while(null!==Z$1);Ij=null;Z$1=d;do try{for(g=a;null!==Z$1;){var t=Z$1.flags;t&16&&pb(Z$1.stateNode,"");if(t&128){var q=Z$1.alternate;if(null!==q){var v=q.ref;null!==v&&("function"===typeof v?v(null):v.current=null);}}switch(t&1038){case 2:fj(Z$1);Z$1.flags&=-3;break;case 6:fj(Z$1);Z$1.flags&=-3;ij(Z$1.alternate,Z$1);break;case 1024:Z$1.flags&=-1025;break;case 1028:Z$1.flags&=-1025;ij(Z$1.alternate,Z$1);break;case 4:ij(Z$1.alternate,Z$1);break;case 8:h=Z$1;cj(g,h);var J=h.alternate;dj(h);null!==
	J&&dj(J);}Z$1=Z$1.nextEffect;}}catch(va){if(null===Z$1)throw Error(y$1(330));Wi(Z$1,va);Z$1=Z$1.nextEffect;}while(null!==Z$1);v=lf;q=Ne$1();t=v.focusedElem;g=v.selectionRange;if(q!==t&&t&&t.ownerDocument&&Me$1(t.ownerDocument.documentElement,t)){null!==g&&Oe(t)&&(q=g.start,v=g.end,void 0===v&&(v=q),"selectionStart"in t?(t.selectionStart=q,t.selectionEnd=Math.min(v,t.value.length)):(v=(q=t.ownerDocument||document)&&q.defaultView||window,v.getSelection&&(v=v.getSelection(),h=t.textContent.length,J=Math.min(g.start,h),g=void 0===
	g.end?J:Math.min(g.end,h),!v.extend&&J>g&&(h=g,g=J,J=h),h=Le$1(t,J),f=Le$1(t,g),h&&f&&(1!==v.rangeCount||v.anchorNode!==h.node||v.anchorOffset!==h.offset||v.focusNode!==f.node||v.focusOffset!==f.offset)&&(q=q.createRange(),q.setStart(h.node,h.offset),v.removeAllRanges(),J>g?(v.addRange(q),v.extend(f.node,f.offset)):(q.setEnd(f.node,f.offset),v.addRange(q))))));q=[];for(v=t;v=v.parentNode;)1===v.nodeType&&q.push({element:v,left:v.scrollLeft,top:v.scrollTop});"function"===typeof t.focus&&t.focus();for(t=
	0;t<q.length;t++)v=q[t],v.element.scrollLeft=v.left,v.element.scrollTop=v.top;}fd=!!kf;lf=kf=null;a.current=c;Z$1=d;do try{for(t=a;null!==Z$1;){var K=Z$1.flags;K&36&&Yi(t,Z$1.alternate,Z$1);if(K&128){q=void 0;var Q=Z$1.ref;if(null!==Q){var L=Z$1.stateNode;switch(Z$1.tag){case 5:q=L;break;default:q=L;}"function"===typeof Q?Q(q):Q.current=q;}}Z$1=Z$1.nextEffect;}}catch(va){if(null===Z$1)throw Error(y$1(330));Wi(Z$1,va);Z$1=Z$1.nextEffect;}while(null!==Z$1);Z$1=null;$f();X$1=e;}else a.current=c;if(xj)xj=!1,yj=a,zj=b;else for(Z$1=d;null!==Z$1;)b=
	Z$1.nextEffect,Z$1.nextEffect=null,Z$1.flags&8&&(K=Z$1,K.sibling=null,K.stateNode=null),Z$1=b;d=a.pendingLanes;0===d&&(Ti=null);1===d?a===Ej?Dj++:(Dj=0,Ej=a):Dj=0;c=c.stateNode;if(Mf&&"function"===typeof Mf.onCommitFiberRoot)try{Mf.onCommitFiberRoot(Lf,c,void 0,64===(c.current.flags&64));}catch(va){}Mj(a,O$1());if(Qi)throw Qi=!1,a=Ri,Ri=null,a;if(0!==(X$1&8))return null;ig();return null}
	function ek(){for(;null!==Z$1;){var a=Z$1.alternate;Jj||null===Ij||(0!==(Z$1.flags&8)?dc(Z$1,Ij)&&(Jj=!0):13===Z$1.tag&&mj(a,Z$1)&&dc(Z$1,Ij)&&(Jj=!0));var b=Z$1.flags;0!==(b&256)&&Xi(a,Z$1);0===(b&512)||xj||(xj=!0,hg(97,function(){Oj();return null}));Z$1=Z$1.nextEffect;}}function Oj(){if(90!==zj){var a=97<zj?97:zj;zj=90;return gg(a,fk)}return !1}function $i(a,b){Aj.push(b,a);xj||(xj=!0,hg(97,function(){Oj();return null}));}function Zi(a,b){Bj.push(b,a);xj||(xj=!0,hg(97,function(){Oj();return null}));}
	function fk(){if(null===yj)return !1;var a=yj;yj=null;if(0!==(X$1&48))throw Error(y$1(331));var b=X$1;X$1|=32;var c=Bj;Bj=[];for(var d=0;d<c.length;d+=2){var e=c[d],f=c[d+1],g=e.destroy;e.destroy=void 0;if("function"===typeof g)try{g();}catch(k){if(null===f)throw Error(y$1(330));Wi(f,k);}}c=Aj;Aj=[];for(d=0;d<c.length;d+=2){e=c[d];f=c[d+1];try{var h=e.create;e.destroy=h();}catch(k){if(null===f)throw Error(y$1(330));Wi(f,k);}}for(h=a.current.firstEffect;null!==h;)a=h.nextEffect,h.nextEffect=null,h.flags&8&&(h.sibling=
	null,h.stateNode=null),h=a;X$1=b;ig();return !0}function gk(a,b,c){b=Mi(c,b);b=Pi(a,b,1);Ag(a,b);b=Hg();a=Kj(a,1);null!==a&&($c(a,1,b),Mj(a,b));}
	function Wi(a,b){if(3===a.tag)gk(a,a,b);else for(var c=a.return;null!==c;){if(3===c.tag){gk(c,a,b);break}else if(1===c.tag){var d=c.stateNode;if("function"===typeof c.type.getDerivedStateFromError||"function"===typeof d.componentDidCatch&&(null===Ti||!Ti.has(d))){a=Mi(b,a);var e=Si(c,a,1);Ag(c,e);e=Hg();c=Kj(c,1);if(null!==c)$c(c,1,e),Mj(c,e);else if("function"===typeof d.componentDidCatch&&(null===Ti||!Ti.has(d)))try{d.componentDidCatch(b,a);}catch(f){}break}}c=c.return;}}
	function Yj(a,b,c){var d=a.pingCache;null!==d&&d.delete(b);b=Hg();a.pingedLanes|=a.suspendedLanes&c;U$1===a&&(W$1&c)===c&&(4===V$1||3===V$1&&(W$1&62914560)===W$1&&500>O$1()-jj?Qj(a,0):uj|=c);Mj(a,b);}function lj(a,b){var c=a.stateNode;null!==c&&c.delete(b);b=0;0===b&&(b=a.mode,0===(b&2)?b=1:0===(b&4)?b=99===eg()?1:2:(0===Gj&&(Gj=tj),b=Yc(62914560&~Gj),0===b&&(b=4194304)));c=Hg();a=Kj(a,b);null!==a&&($c(a,b,c),Mj(a,c));}var ck;
	ck=function(a,b,c){var d=b.lanes;if(null!==a)if(a.memoizedProps!==b.pendingProps||N$1.current)ug=!0;else if(0!==(c&d))ug=0!==(a.flags&16384)?!0:!1;else {ug=!1;switch(b.tag){case 3:ri(b);sh();break;case 5:gh(b);break;case 1:Ff(b.type)&&Jf(b);break;case 4:eh(b,b.stateNode.containerInfo);break;case 10:d=b.memoizedProps.value;var e=b.type._context;I$1(mg,e._currentValue);e._currentValue=d;break;case 13:if(null!==b.memoizedState){if(0!==(c&b.child.childLanes))return ti(a,b,c);I$1(P$1,P$1.current&1);b=hi(a,b,c);return null!==
	b?b.sibling:null}I$1(P$1,P$1.current&1);break;case 19:d=0!==(c&b.childLanes);if(0!==(a.flags&64)){if(d)return Ai(a,b,c);b.flags|=64;}e=b.memoizedState;null!==e&&(e.rendering=null,e.tail=null,e.lastEffect=null);I$1(P$1,P$1.current);if(d)break;else return null;case 23:case 24:return b.lanes=0,mi(a,b,c)}return hi(a,b,c)}else ug=!1;b.lanes=0;switch(b.tag){case 2:d=b.type;null!==a&&(a.alternate=null,b.alternate=null,b.flags|=2);a=b.pendingProps;e=Ef(b,M$1.current);tg(b,c);e=Ch(null,b,d,a,e,c);b.flags|=1;if("object"===
	typeof e&&null!==e&&"function"===typeof e.render&&void 0===e.$$typeof){b.tag=1;b.memoizedState=null;b.updateQueue=null;if(Ff(d)){var f=!0;Jf(b);}else f=!1;b.memoizedState=null!==e.state&&void 0!==e.state?e.state:null;xg(b);var g=d.getDerivedStateFromProps;"function"===typeof g&&Gg(b,d,g,a);e.updater=Kg;b.stateNode=e;e._reactInternals=b;Og(b,d,a,c);b=qi(null,b,d,!0,f,c);}else b.tag=0,fi(null,b,e,c),b=b.child;return b;case 16:e=b.elementType;a:{null!==a&&(a.alternate=null,b.alternate=null,b.flags|=2);
	a=b.pendingProps;f=e._init;e=f(e._payload);b.type=e;f=b.tag=hk(e);a=lg(e,a);switch(f){case 0:b=li(null,b,e,a,c);break a;case 1:b=pi(null,b,e,a,c);break a;case 11:b=gi(null,b,e,a,c);break a;case 14:b=ii(null,b,e,lg(e.type,a),d,c);break a}throw Error(y$1(306,e,""));}return b;case 0:return d=b.type,e=b.pendingProps,e=b.elementType===d?e:lg(d,e),li(a,b,d,e,c);case 1:return d=b.type,e=b.pendingProps,e=b.elementType===d?e:lg(d,e),pi(a,b,d,e,c);case 3:ri(b);d=b.updateQueue;if(null===a||null===d)throw Error(y$1(282));
	d=b.pendingProps;e=b.memoizedState;e=null!==e?e.element:null;yg(a,b);Cg(b,d,null,c);d=b.memoizedState.element;if(d===e)sh(),b=hi(a,b,c);else {e=b.stateNode;if(f=e.hydrate)kh=rf(b.stateNode.containerInfo.firstChild),jh=b,f=lh=!0;if(f){a=e.mutableSourceEagerHydrationData;if(null!=a)for(e=0;e<a.length;e+=2)f=a[e],f._workInProgressVersionPrimary=a[e+1],th.push(f);c=Zg(b,null,d,c);for(b.child=c;c;)c.flags=c.flags&-3|1024,c=c.sibling;}else fi(a,b,d,c),sh();b=b.child;}return b;case 5:return gh(b),null===a&&
	ph(b),d=b.type,e=b.pendingProps,f=null!==a?a.memoizedProps:null,g=e.children,nf(d,e)?g=null:null!==f&&nf(d,f)&&(b.flags|=16),oi(a,b),fi(a,b,g,c),b.child;case 6:return null===a&&ph(b),null;case 13:return ti(a,b,c);case 4:return eh(b,b.stateNode.containerInfo),d=b.pendingProps,null===a?b.child=Yg(b,null,d,c):fi(a,b,d,c),b.child;case 11:return d=b.type,e=b.pendingProps,e=b.elementType===d?e:lg(d,e),gi(a,b,d,e,c);case 7:return fi(a,b,b.pendingProps,c),b.child;case 8:return fi(a,b,b.pendingProps.children,
	c),b.child;case 12:return fi(a,b,b.pendingProps.children,c),b.child;case 10:a:{d=b.type._context;e=b.pendingProps;g=b.memoizedProps;f=e.value;var h=b.type._context;I$1(mg,h._currentValue);h._currentValue=f;if(null!==g)if(h=g.value,f=He$1(h,f)?0:("function"===typeof d._calculateChangedBits?d._calculateChangedBits(h,f):1073741823)|0,0===f){if(g.children===e.children&&!N$1.current){b=hi(a,b,c);break a}}else for(h=b.child,null!==h&&(h.return=b);null!==h;){var k=h.dependencies;if(null!==k){g=h.child;for(var l=
	k.firstContext;null!==l;){if(l.context===d&&0!==(l.observedBits&f)){1===h.tag&&(l=zg(-1,c&-c),l.tag=2,Ag(h,l));h.lanes|=c;l=h.alternate;null!==l&&(l.lanes|=c);sg(h.return,c);k.lanes|=c;break}l=l.next;}}else g=10===h.tag?h.type===b.type?null:h.child:h.child;if(null!==g)g.return=h;else for(g=h;null!==g;){if(g===b){g=null;break}h=g.sibling;if(null!==h){h.return=g.return;g=h;break}g=g.return;}h=g;}fi(a,b,e.children,c);b=b.child;}return b;case 9:return e=b.type,f=b.pendingProps,d=f.children,tg(b,c),e=vg(e,
	f.unstable_observedBits),d=d(e),b.flags|=1,fi(a,b,d,c),b.child;case 14:return e=b.type,f=lg(e,b.pendingProps),f=lg(e.type,f),ii(a,b,e,f,d,c);case 15:return ki(a,b,b.type,b.pendingProps,d,c);case 17:return d=b.type,e=b.pendingProps,e=b.elementType===d?e:lg(d,e),null!==a&&(a.alternate=null,b.alternate=null,b.flags|=2),b.tag=1,Ff(d)?(a=!0,Jf(b)):a=!1,tg(b,c),Mg(b,d,e),Og(b,d,e,c),qi(null,b,d,!0,a,c);case 19:return Ai(a,b,c);case 23:return mi(a,b,c);case 24:return mi(a,b,c)}throw Error(y$1(156,b.tag));
	};function ik(a,b,c,d){this.tag=a;this.key=c;this.sibling=this.child=this.return=this.stateNode=this.type=this.elementType=null;this.index=0;this.ref=null;this.pendingProps=b;this.dependencies=this.memoizedState=this.updateQueue=this.memoizedProps=null;this.mode=d;this.flags=0;this.lastEffect=this.firstEffect=this.nextEffect=null;this.childLanes=this.lanes=0;this.alternate=null;}function nh(a,b,c,d){return new ik(a,b,c,d)}function ji(a){a=a.prototype;return !(!a||!a.isReactComponent)}
	function hk(a){if("function"===typeof a)return ji(a)?1:0;if(void 0!==a&&null!==a){a=a.$$typeof;if(a===Aa)return 11;if(a===Da)return 14}return 2}
	function Tg(a,b){var c=a.alternate;null===c?(c=nh(a.tag,b,a.key,a.mode),c.elementType=a.elementType,c.type=a.type,c.stateNode=a.stateNode,c.alternate=a,a.alternate=c):(c.pendingProps=b,c.type=a.type,c.flags=0,c.nextEffect=null,c.firstEffect=null,c.lastEffect=null);c.childLanes=a.childLanes;c.lanes=a.lanes;c.child=a.child;c.memoizedProps=a.memoizedProps;c.memoizedState=a.memoizedState;c.updateQueue=a.updateQueue;b=a.dependencies;c.dependencies=null===b?null:{lanes:b.lanes,firstContext:b.firstContext};
	c.sibling=a.sibling;c.index=a.index;c.ref=a.ref;return c}
	function Vg(a,b,c,d,e,f){var g=2;d=a;if("function"===typeof a)ji(a)&&(g=1);else if("string"===typeof a)g=5;else a:switch(a){case ua:return Xg(c.children,e,f,b);case Ha:g=8;e|=16;break;case wa:g=8;e|=1;break;case xa:return a=nh(12,c,b,e|8),a.elementType=xa,a.type=xa,a.lanes=f,a;case Ba:return a=nh(13,c,b,e),a.type=Ba,a.elementType=Ba,a.lanes=f,a;case Ca:return a=nh(19,c,b,e),a.elementType=Ca,a.lanes=f,a;case Ia:return vi(c,e,f,b);case Ja:return a=nh(24,c,b,e),a.elementType=Ja,a.lanes=f,a;default:if("object"===
	typeof a&&null!==a)switch(a.$$typeof){case ya:g=10;break a;case za:g=9;break a;case Aa:g=11;break a;case Da:g=14;break a;case Ea:g=16;d=null;break a;case Fa:g=22;break a}throw Error(y$1(130,null==a?a:typeof a,""));}b=nh(g,c,b,e);b.elementType=a;b.type=d;b.lanes=f;return b}function Xg(a,b,c,d){a=nh(7,a,d,b);a.lanes=c;return a}function vi(a,b,c,d){a=nh(23,a,d,b);a.elementType=Ia;a.lanes=c;return a}function Ug(a,b,c){a=nh(6,a,null,b);a.lanes=c;return a}
	function Wg(a,b,c){b=nh(4,null!==a.children?a.children:[],a.key,b);b.lanes=c;b.stateNode={containerInfo:a.containerInfo,pendingChildren:null,implementation:a.implementation};return b}
	function jk(a,b,c){this.tag=b;this.containerInfo=a;this.finishedWork=this.pingCache=this.current=this.pendingChildren=null;this.timeoutHandle=-1;this.pendingContext=this.context=null;this.hydrate=c;this.callbackNode=null;this.callbackPriority=0;this.eventTimes=Zc(0);this.expirationTimes=Zc(-1);this.entangledLanes=this.finishedLanes=this.mutableReadLanes=this.expiredLanes=this.pingedLanes=this.suspendedLanes=this.pendingLanes=0;this.entanglements=Zc(0);this.mutableSourceEagerHydrationData=null;}
	function kk(a,b,c){var d=3<arguments.length&&void 0!==arguments[3]?arguments[3]:null;return {$$typeof:ta,key:null==d?null:""+d,children:a,containerInfo:b,implementation:c}}
	function lk(a,b,c,d){var e=b.current,f=Hg(),g=Ig(e);a:if(c){c=c._reactInternals;b:{if(Zb(c)!==c||1!==c.tag)throw Error(y$1(170));var h=c;do{switch(h.tag){case 3:h=h.stateNode.context;break b;case 1:if(Ff(h.type)){h=h.stateNode.__reactInternalMemoizedMergedChildContext;break b}}h=h.return;}while(null!==h);throw Error(y$1(171));}if(1===c.tag){var k=c.type;if(Ff(k)){c=If(c,k,h);break a}}c=h;}else c=Cf;null===b.context?b.context=c:b.pendingContext=c;b=zg(f,g);b.payload={element:a};d=void 0===d?null:d;null!==
	d&&(b.callback=d);Ag(e,b);Jg(e,g,f);return g}function mk(a){a=a.current;if(!a.child)return null;switch(a.child.tag){case 5:return a.child.stateNode;default:return a.child.stateNode}}function nk(a,b){a=a.memoizedState;if(null!==a&&null!==a.dehydrated){var c=a.retryLane;a.retryLane=0!==c&&c<b?c:b;}}function ok(a,b){nk(a,b);(a=a.alternate)&&nk(a,b);}function pk(){return null}
	function qk(a,b,c){var d=null!=c&&null!=c.hydrationOptions&&c.hydrationOptions.mutableSources||null;c=new jk(a,b,null!=c&&!0===c.hydrate);b=nh(3,null,null,2===b?7:1===b?3:0);c.current=b;b.stateNode=c;xg(b);a[ff]=c.current;cf(8===a.nodeType?a.parentNode:a);if(d)for(a=0;a<d.length;a++){b=d[a];var e=b._getVersion;e=e(b._source);null==c.mutableSourceEagerHydrationData?c.mutableSourceEagerHydrationData=[b,e]:c.mutableSourceEagerHydrationData.push(b,e);}this._internalRoot=c;}
	qk.prototype.render=function(a){lk(a,this._internalRoot,null,null);};qk.prototype.unmount=function(){var a=this._internalRoot,b=a.containerInfo;lk(null,a,null,function(){b[ff]=null;});};function rk(a){return !(!a||1!==a.nodeType&&9!==a.nodeType&&11!==a.nodeType&&(8!==a.nodeType||" react-mount-point-unstable "!==a.nodeValue))}
	function sk(a,b){b||(b=a?9===a.nodeType?a.documentElement:a.firstChild:null,b=!(!b||1!==b.nodeType||!b.hasAttribute("data-reactroot")));if(!b)for(var c;c=a.lastChild;)a.removeChild(c);return new qk(a,0,b?{hydrate:!0}:void 0)}
	function tk(a,b,c,d,e){var f=c._reactRootContainer;if(f){var g=f._internalRoot;if("function"===typeof e){var h=e;e=function(){var a=mk(g);h.call(a);};}lk(b,g,a,e);}else {f=c._reactRootContainer=sk(c,d);g=f._internalRoot;if("function"===typeof e){var k=e;e=function(){var a=mk(g);k.call(a);};}Xj(function(){lk(b,g,a,e);});}return mk(g)}ec=function(a){if(13===a.tag){var b=Hg();Jg(a,4,b);ok(a,4);}};fc=function(a){if(13===a.tag){var b=Hg();Jg(a,67108864,b);ok(a,67108864);}};
	gc=function(a){if(13===a.tag){var b=Hg(),c=Ig(a);Jg(a,c,b);ok(a,c);}};hc=function(a,b){return b()};
	yb=function(a,b,c){switch(b){case "input":ab(a,c);b=c.name;if("radio"===c.type&&null!=b){for(c=a;c.parentNode;)c=c.parentNode;c=c.querySelectorAll("input[name="+JSON.stringify(""+b)+'][type="radio"]');for(b=0;b<c.length;b++){var d=c[b];if(d!==a&&d.form===a.form){var e=Db(d);if(!e)throw Error(y$1(90));Wa(d);ab(d,e);}}}break;case "textarea":ib(a,c);break;case "select":b=c.value,null!=b&&fb(a,!!c.multiple,b,!1);}};Gb=Wj;
	Hb=function(a,b,c,d,e){var f=X$1;X$1|=4;try{return gg(98,a.bind(null,b,c,d,e))}finally{X$1=f,0===X$1&&(wj(),ig());}};Ib=function(){0===(X$1&49)&&(Vj(),Oj());};Jb=function(a,b){var c=X$1;X$1|=2;try{return a(b)}finally{X$1=c,0===X$1&&(wj(),ig());}};function uk(a,b){var c=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!rk(b))throw Error(y$1(200));return kk(a,b,null,c)}var vk={Events:[Cb,ue$1,Db,Eb,Fb,Oj,{current:!1}]},wk={findFiberByHostInstance:wc,bundleType:0,version:"17.0.2",rendererPackageName:"react-dom"};
	var xk={bundleType:wk.bundleType,version:wk.version,rendererPackageName:wk.rendererPackageName,rendererConfig:wk.rendererConfig,overrideHookState:null,overrideHookStateDeletePath:null,overrideHookStateRenamePath:null,overrideProps:null,overridePropsDeletePath:null,overridePropsRenamePath:null,setSuspenseHandler:null,scheduleUpdate:null,currentDispatcherRef:ra.ReactCurrentDispatcher,findHostInstanceByFiber:function(a){a=cc(a);return null===a?null:a.stateNode},findFiberByHostInstance:wk.findFiberByHostInstance||
	pk,findHostInstancesForRefresh:null,scheduleRefresh:null,scheduleRoot:null,setRefreshHandler:null,getCurrentFiber:null};if("undefined"!==typeof __REACT_DEVTOOLS_GLOBAL_HOOK__){var yk=__REACT_DEVTOOLS_GLOBAL_HOOK__;if(!yk.isDisabled&&yk.supportsFiber)try{Lf=yk.inject(xk),Mf=yk;}catch(a){}}reactDom_production_min.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED=vk;reactDom_production_min.createPortal=uk;
	reactDom_production_min.findDOMNode=function(a){if(null==a)return null;if(1===a.nodeType)return a;var b=a._reactInternals;if(void 0===b){if("function"===typeof a.render)throw Error(y$1(188));throw Error(y$1(268,Object.keys(a)));}a=cc(b);a=null===a?null:a.stateNode;return a};reactDom_production_min.flushSync=function(a,b){var c=X$1;if(0!==(c&48))return a(b);X$1|=1;try{if(a)return gg(99,a.bind(null,b))}finally{X$1=c,ig();}};reactDom_production_min.hydrate=function(a,b,c){if(!rk(b))throw Error(y$1(200));return tk(null,a,b,!0,c)};
	reactDom_production_min.render=function(a,b,c){if(!rk(b))throw Error(y$1(200));return tk(null,a,b,!1,c)};reactDom_production_min.unmountComponentAtNode=function(a){if(!rk(a))throw Error(y$1(40));return a._reactRootContainer?(Xj(function(){tk(null,null,a,!1,function(){a._reactRootContainer=null;a[ff]=null;});}),!0):!1};reactDom_production_min.unstable_batchedUpdates=Wj;reactDom_production_min.unstable_createPortal=function(a,b){return uk(a,b,2<arguments.length&&void 0!==arguments[2]?arguments[2]:null)};
	reactDom_production_min.unstable_renderSubtreeIntoContainer=function(a,b,c,d){if(!rk(c))throw Error(y$1(200));if(null==a||void 0===a._reactInternals)throw Error(y$1(38));return tk(a,b,c,!1,d)};reactDom_production_min.version="17.0.2";

	var schedulerTracing_production_min = {};

	/** @license React v0.20.2
	 * scheduler-tracing.production.min.js
	 *
	 * Copyright (c) Facebook, Inc. and its affiliates.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */
	var b$2=0;schedulerTracing_production_min.__interactionsRef=null;schedulerTracing_production_min.__subscriberRef=null;schedulerTracing_production_min.unstable_clear=function(a){return a()};schedulerTracing_production_min.unstable_getCurrent=function(){return null};schedulerTracing_production_min.unstable_getThreadID=function(){return ++b$2};schedulerTracing_production_min.unstable_subscribe=function(){};schedulerTracing_production_min.unstable_trace=function(a,d,c){return c()};schedulerTracing_production_min.unstable_unsubscribe=function(){};schedulerTracing_production_min.unstable_wrap=function(a){return a};

	function checkDCE() {
	  /* global __REACT_DEVTOOLS_GLOBAL_HOOK__ */
	  if (
	    typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ === 'undefined' ||
	    typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE !== 'function'
	  ) {
	    return;
	  }
	  try {
	    // Verify that the code above has been dead code eliminated (DCE'd).
	    __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(checkDCE);
	  } catch (err) {
	    // DevTools shouldn't crash React, no matter what.
	    // We should still report in case we break this code.
	    console.error(err);
	  }
	}

	{
	  // DCE check should happen before ReactDOM bundle executes so that
	  // DevTools can report bad minification during injection.
	  checkDCE();
	  reactDom.exports = reactDom_production_min;
	}

	var reactIs$1 = {exports: {}};

	var reactIs_production_min = {};

	/** @license React v16.13.1
	 * react-is.production.min.js
	 *
	 * Copyright (c) Facebook, Inc. and its affiliates.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */
	var b$1="function"===typeof Symbol&&Symbol.for,c=b$1?Symbol.for("react.element"):60103,d=b$1?Symbol.for("react.portal"):60106,e=b$1?Symbol.for("react.fragment"):60107,f=b$1?Symbol.for("react.strict_mode"):60108,g$1=b$1?Symbol.for("react.profiler"):60114,h=b$1?Symbol.for("react.provider"):60109,k$1=b$1?Symbol.for("react.context"):60110,l=b$1?Symbol.for("react.async_mode"):60111,m=b$1?Symbol.for("react.concurrent_mode"):60111,n=b$1?Symbol.for("react.forward_ref"):60112,p=b$1?Symbol.for("react.suspense"):60113,q$1=b$1?
	Symbol.for("react.suspense_list"):60120,r=b$1?Symbol.for("react.memo"):60115,t=b$1?Symbol.for("react.lazy"):60116,v$1=b$1?Symbol.for("react.block"):60121,w$1=b$1?Symbol.for("react.fundamental"):60117,x$1=b$1?Symbol.for("react.responder"):60118,y=b$1?Symbol.for("react.scope"):60119;
	function z$1(a){if("object"===typeof a&&null!==a){var u=a.$$typeof;switch(u){case c:switch(a=a.type,a){case l:case m:case e:case g$1:case f:case p:return a;default:switch(a=a&&a.$$typeof,a){case k$1:case n:case t:case r:case h:return a;default:return u}}case d:return u}}}function A$1(a){return z$1(a)===m}reactIs_production_min.AsyncMode=l;reactIs_production_min.ConcurrentMode=m;reactIs_production_min.ContextConsumer=k$1;reactIs_production_min.ContextProvider=h;reactIs_production_min.Element=c;reactIs_production_min.ForwardRef=n;reactIs_production_min.Fragment=e;reactIs_production_min.Lazy=t;reactIs_production_min.Memo=r;reactIs_production_min.Portal=d;
	reactIs_production_min.Profiler=g$1;reactIs_production_min.StrictMode=f;reactIs_production_min.Suspense=p;reactIs_production_min.isAsyncMode=function(a){return A$1(a)||z$1(a)===l};reactIs_production_min.isConcurrentMode=A$1;reactIs_production_min.isContextConsumer=function(a){return z$1(a)===k$1};reactIs_production_min.isContextProvider=function(a){return z$1(a)===h};reactIs_production_min.isElement=function(a){return "object"===typeof a&&null!==a&&a.$$typeof===c};reactIs_production_min.isForwardRef=function(a){return z$1(a)===n};reactIs_production_min.isFragment=function(a){return z$1(a)===e};reactIs_production_min.isLazy=function(a){return z$1(a)===t};
	reactIs_production_min.isMemo=function(a){return z$1(a)===r};reactIs_production_min.isPortal=function(a){return z$1(a)===d};reactIs_production_min.isProfiler=function(a){return z$1(a)===g$1};reactIs_production_min.isStrictMode=function(a){return z$1(a)===f};reactIs_production_min.isSuspense=function(a){return z$1(a)===p};
	reactIs_production_min.isValidElementType=function(a){return "string"===typeof a||"function"===typeof a||a===e||a===m||a===g$1||a===f||a===p||a===q$1||"object"===typeof a&&null!==a&&(a.$$typeof===t||a.$$typeof===r||a.$$typeof===h||a.$$typeof===k$1||a.$$typeof===n||a.$$typeof===w$1||a.$$typeof===x$1||a.$$typeof===y||a.$$typeof===v$1)};reactIs_production_min.typeOf=z$1;

	{
	  reactIs$1.exports = reactIs_production_min;
	}

	//

	var shallowequal = function shallowEqual(objA, objB, compare, compareContext) {
	  var ret = compare ? compare.call(compareContext, objA, objB) : void 0;

	  if (ret !== void 0) {
	    return !!ret;
	  }

	  if (objA === objB) {
	    return true;
	  }

	  if (typeof objA !== "object" || !objA || typeof objB !== "object" || !objB) {
	    return false;
	  }

	  var keysA = Object.keys(objA);
	  var keysB = Object.keys(objB);

	  if (keysA.length !== keysB.length) {
	    return false;
	  }

	  var bHasOwnProperty = Object.prototype.hasOwnProperty.bind(objB);

	  // Test for A's keys different from B.
	  for (var idx = 0; idx < keysA.length; idx++) {
	    var key = keysA[idx];

	    if (!bHasOwnProperty(key)) {
	      return false;
	    }

	    var valueA = objA[key];
	    var valueB = objB[key];

	    ret = compare ? compare.call(compareContext, valueA, valueB, key) : void 0;

	    if (ret === false || (ret === void 0 && valueA !== valueB)) {
	      return false;
	    }
	  }

	  return true;
	};

	function stylis_min (W) {
	  function M(d, c, e, h, a) {
	    for (var m = 0, b = 0, v = 0, n = 0, q, g, x = 0, K = 0, k, u = k = q = 0, l = 0, r = 0, I = 0, t = 0, B = e.length, J = B - 1, y, f = '', p = '', F = '', G = '', C; l < B;) {
	      g = e.charCodeAt(l);
	      l === J && 0 !== b + n + v + m && (0 !== b && (g = 47 === b ? 10 : 47), n = v = m = 0, B++, J++);

	      if (0 === b + n + v + m) {
	        if (l === J && (0 < r && (f = f.replace(N, '')), 0 < f.trim().length)) {
	          switch (g) {
	            case 32:
	            case 9:
	            case 59:
	            case 13:
	            case 10:
	              break;

	            default:
	              f += e.charAt(l);
	          }

	          g = 59;
	        }

	        switch (g) {
	          case 123:
	            f = f.trim();
	            q = f.charCodeAt(0);
	            k = 1;

	            for (t = ++l; l < B;) {
	              switch (g = e.charCodeAt(l)) {
	                case 123:
	                  k++;
	                  break;

	                case 125:
	                  k--;
	                  break;

	                case 47:
	                  switch (g = e.charCodeAt(l + 1)) {
	                    case 42:
	                    case 47:
	                      a: {
	                        for (u = l + 1; u < J; ++u) {
	                          switch (e.charCodeAt(u)) {
	                            case 47:
	                              if (42 === g && 42 === e.charCodeAt(u - 1) && l + 2 !== u) {
	                                l = u + 1;
	                                break a;
	                              }

	                              break;

	                            case 10:
	                              if (47 === g) {
	                                l = u + 1;
	                                break a;
	                              }

	                          }
	                        }

	                        l = u;
	                      }

	                  }

	                  break;

	                case 91:
	                  g++;

	                case 40:
	                  g++;

	                case 34:
	                case 39:
	                  for (; l++ < J && e.charCodeAt(l) !== g;) {
	                  }

	              }

	              if (0 === k) break;
	              l++;
	            }

	            k = e.substring(t, l);
	            0 === q && (q = (f = f.replace(ca, '').trim()).charCodeAt(0));

	            switch (q) {
	              case 64:
	                0 < r && (f = f.replace(N, ''));
	                g = f.charCodeAt(1);

	                switch (g) {
	                  case 100:
	                  case 109:
	                  case 115:
	                  case 45:
	                    r = c;
	                    break;

	                  default:
	                    r = O;
	                }

	                k = M(c, r, k, g, a + 1);
	                t = k.length;
	                0 < A && (r = X(O, f, I), C = H(3, k, r, c, D, z, t, g, a, h), f = r.join(''), void 0 !== C && 0 === (t = (k = C.trim()).length) && (g = 0, k = ''));
	                if (0 < t) switch (g) {
	                  case 115:
	                    f = f.replace(da, ea);

	                  case 100:
	                  case 109:
	                  case 45:
	                    k = f + '{' + k + '}';
	                    break;

	                  case 107:
	                    f = f.replace(fa, '$1 $2');
	                    k = f + '{' + k + '}';
	                    k = 1 === w || 2 === w && L('@' + k, 3) ? '@-webkit-' + k + '@' + k : '@' + k;
	                    break;

	                  default:
	                    k = f + k, 112 === h && (k = (p += k, ''));
	                } else k = '';
	                break;

	              default:
	                k = M(c, X(c, f, I), k, h, a + 1);
	            }

	            F += k;
	            k = I = r = u = q = 0;
	            f = '';
	            g = e.charCodeAt(++l);
	            break;

	          case 125:
	          case 59:
	            f = (0 < r ? f.replace(N, '') : f).trim();
	            if (1 < (t = f.length)) switch (0 === u && (q = f.charCodeAt(0), 45 === q || 96 < q && 123 > q) && (t = (f = f.replace(' ', ':')).length), 0 < A && void 0 !== (C = H(1, f, c, d, D, z, p.length, h, a, h)) && 0 === (t = (f = C.trim()).length) && (f = '\x00\x00'), q = f.charCodeAt(0), g = f.charCodeAt(1), q) {
	              case 0:
	                break;

	              case 64:
	                if (105 === g || 99 === g) {
	                  G += f + e.charAt(l);
	                  break;
	                }

	              default:
	                58 !== f.charCodeAt(t - 1) && (p += P(f, q, g, f.charCodeAt(2)));
	            }
	            I = r = u = q = 0;
	            f = '';
	            g = e.charCodeAt(++l);
	        }
	      }

	      switch (g) {
	        case 13:
	        case 10:
	          47 === b ? b = 0 : 0 === 1 + q && 107 !== h && 0 < f.length && (r = 1, f += '\x00');
	          0 < A * Y && H(0, f, c, d, D, z, p.length, h, a, h);
	          z = 1;
	          D++;
	          break;

	        case 59:
	        case 125:
	          if (0 === b + n + v + m) {
	            z++;
	            break;
	          }

	        default:
	          z++;
	          y = e.charAt(l);

	          switch (g) {
	            case 9:
	            case 32:
	              if (0 === n + m + b) switch (x) {
	                case 44:
	                case 58:
	                case 9:
	                case 32:
	                  y = '';
	                  break;

	                default:
	                  32 !== g && (y = ' ');
	              }
	              break;

	            case 0:
	              y = '\\0';
	              break;

	            case 12:
	              y = '\\f';
	              break;

	            case 11:
	              y = '\\v';
	              break;

	            case 38:
	              0 === n + b + m && (r = I = 1, y = '\f' + y);
	              break;

	            case 108:
	              if (0 === n + b + m + E && 0 < u) switch (l - u) {
	                case 2:
	                  112 === x && 58 === e.charCodeAt(l - 3) && (E = x);

	                case 8:
	                  111 === K && (E = K);
	              }
	              break;

	            case 58:
	              0 === n + b + m && (u = l);
	              break;

	            case 44:
	              0 === b + v + n + m && (r = 1, y += '\r');
	              break;

	            case 34:
	            case 39:
	              0 === b && (n = n === g ? 0 : 0 === n ? g : n);
	              break;

	            case 91:
	              0 === n + b + v && m++;
	              break;

	            case 93:
	              0 === n + b + v && m--;
	              break;

	            case 41:
	              0 === n + b + m && v--;
	              break;

	            case 40:
	              if (0 === n + b + m) {
	                if (0 === q) switch (2 * x + 3 * K) {
	                  case 533:
	                    break;

	                  default:
	                    q = 1;
	                }
	                v++;
	              }

	              break;

	            case 64:
	              0 === b + v + n + m + u + k && (k = 1);
	              break;

	            case 42:
	            case 47:
	              if (!(0 < n + m + v)) switch (b) {
	                case 0:
	                  switch (2 * g + 3 * e.charCodeAt(l + 1)) {
	                    case 235:
	                      b = 47;
	                      break;

	                    case 220:
	                      t = l, b = 42;
	                  }

	                  break;

	                case 42:
	                  47 === g && 42 === x && t + 2 !== l && (33 === e.charCodeAt(t + 2) && (p += e.substring(t, l + 1)), y = '', b = 0);
	              }
	          }

	          0 === b && (f += y);
	      }

	      K = x;
	      x = g;
	      l++;
	    }

	    t = p.length;

	    if (0 < t) {
	      r = c;
	      if (0 < A && (C = H(2, p, r, d, D, z, t, h, a, h), void 0 !== C && 0 === (p = C).length)) return G + p + F;
	      p = r.join(',') + '{' + p + '}';

	      if (0 !== w * E) {
	        2 !== w || L(p, 2) || (E = 0);

	        switch (E) {
	          case 111:
	            p = p.replace(ha, ':-moz-$1') + p;
	            break;

	          case 112:
	            p = p.replace(Q, '::-webkit-input-$1') + p.replace(Q, '::-moz-$1') + p.replace(Q, ':-ms-input-$1') + p;
	        }

	        E = 0;
	      }
	    }

	    return G + p + F;
	  }

	  function X(d, c, e) {
	    var h = c.trim().split(ia);
	    c = h;
	    var a = h.length,
	        m = d.length;

	    switch (m) {
	      case 0:
	      case 1:
	        var b = 0;

	        for (d = 0 === m ? '' : d[0] + ' '; b < a; ++b) {
	          c[b] = Z(d, c[b], e).trim();
	        }

	        break;

	      default:
	        var v = b = 0;

	        for (c = []; b < a; ++b) {
	          for (var n = 0; n < m; ++n) {
	            c[v++] = Z(d[n] + ' ', h[b], e).trim();
	          }
	        }

	    }

	    return c;
	  }

	  function Z(d, c, e) {
	    var h = c.charCodeAt(0);
	    33 > h && (h = (c = c.trim()).charCodeAt(0));

	    switch (h) {
	      case 38:
	        return c.replace(F, '$1' + d.trim());

	      case 58:
	        return d.trim() + c.replace(F, '$1' + d.trim());

	      default:
	        if (0 < 1 * e && 0 < c.indexOf('\f')) return c.replace(F, (58 === d.charCodeAt(0) ? '' : '$1') + d.trim());
	    }

	    return d + c;
	  }

	  function P(d, c, e, h) {
	    var a = d + ';',
	        m = 2 * c + 3 * e + 4 * h;

	    if (944 === m) {
	      d = a.indexOf(':', 9) + 1;
	      var b = a.substring(d, a.length - 1).trim();
	      b = a.substring(0, d).trim() + b + ';';
	      return 1 === w || 2 === w && L(b, 1) ? '-webkit-' + b + b : b;
	    }

	    if (0 === w || 2 === w && !L(a, 1)) return a;

	    switch (m) {
	      case 1015:
	        return 97 === a.charCodeAt(10) ? '-webkit-' + a + a : a;

	      case 951:
	        return 116 === a.charCodeAt(3) ? '-webkit-' + a + a : a;

	      case 963:
	        return 110 === a.charCodeAt(5) ? '-webkit-' + a + a : a;

	      case 1009:
	        if (100 !== a.charCodeAt(4)) break;

	      case 969:
	      case 942:
	        return '-webkit-' + a + a;

	      case 978:
	        return '-webkit-' + a + '-moz-' + a + a;

	      case 1019:
	      case 983:
	        return '-webkit-' + a + '-moz-' + a + '-ms-' + a + a;

	      case 883:
	        if (45 === a.charCodeAt(8)) return '-webkit-' + a + a;
	        if (0 < a.indexOf('image-set(', 11)) return a.replace(ja, '$1-webkit-$2') + a;
	        break;

	      case 932:
	        if (45 === a.charCodeAt(4)) switch (a.charCodeAt(5)) {
	          case 103:
	            return '-webkit-box-' + a.replace('-grow', '') + '-webkit-' + a + '-ms-' + a.replace('grow', 'positive') + a;

	          case 115:
	            return '-webkit-' + a + '-ms-' + a.replace('shrink', 'negative') + a;

	          case 98:
	            return '-webkit-' + a + '-ms-' + a.replace('basis', 'preferred-size') + a;
	        }
	        return '-webkit-' + a + '-ms-' + a + a;

	      case 964:
	        return '-webkit-' + a + '-ms-flex-' + a + a;

	      case 1023:
	        if (99 !== a.charCodeAt(8)) break;
	        b = a.substring(a.indexOf(':', 15)).replace('flex-', '').replace('space-between', 'justify');
	        return '-webkit-box-pack' + b + '-webkit-' + a + '-ms-flex-pack' + b + a;

	      case 1005:
	        return ka.test(a) ? a.replace(aa, ':-webkit-') + a.replace(aa, ':-moz-') + a : a;

	      case 1e3:
	        b = a.substring(13).trim();
	        c = b.indexOf('-') + 1;

	        switch (b.charCodeAt(0) + b.charCodeAt(c)) {
	          case 226:
	            b = a.replace(G, 'tb');
	            break;

	          case 232:
	            b = a.replace(G, 'tb-rl');
	            break;

	          case 220:
	            b = a.replace(G, 'lr');
	            break;

	          default:
	            return a;
	        }

	        return '-webkit-' + a + '-ms-' + b + a;

	      case 1017:
	        if (-1 === a.indexOf('sticky', 9)) break;

	      case 975:
	        c = (a = d).length - 10;
	        b = (33 === a.charCodeAt(c) ? a.substring(0, c) : a).substring(d.indexOf(':', 7) + 1).trim();

	        switch (m = b.charCodeAt(0) + (b.charCodeAt(7) | 0)) {
	          case 203:
	            if (111 > b.charCodeAt(8)) break;

	          case 115:
	            a = a.replace(b, '-webkit-' + b) + ';' + a;
	            break;

	          case 207:
	          case 102:
	            a = a.replace(b, '-webkit-' + (102 < m ? 'inline-' : '') + 'box') + ';' + a.replace(b, '-webkit-' + b) + ';' + a.replace(b, '-ms-' + b + 'box') + ';' + a;
	        }

	        return a + ';';

	      case 938:
	        if (45 === a.charCodeAt(5)) switch (a.charCodeAt(6)) {
	          case 105:
	            return b = a.replace('-items', ''), '-webkit-' + a + '-webkit-box-' + b + '-ms-flex-' + b + a;

	          case 115:
	            return '-webkit-' + a + '-ms-flex-item-' + a.replace(ba, '') + a;

	          default:
	            return '-webkit-' + a + '-ms-flex-line-pack' + a.replace('align-content', '').replace(ba, '') + a;
	        }
	        break;

	      case 973:
	      case 989:
	        if (45 !== a.charCodeAt(3) || 122 === a.charCodeAt(4)) break;

	      case 931:
	      case 953:
	        if (!0 === la.test(d)) return 115 === (b = d.substring(d.indexOf(':') + 1)).charCodeAt(0) ? P(d.replace('stretch', 'fill-available'), c, e, h).replace(':fill-available', ':stretch') : a.replace(b, '-webkit-' + b) + a.replace(b, '-moz-' + b.replace('fill-', '')) + a;
	        break;

	      case 962:
	        if (a = '-webkit-' + a + (102 === a.charCodeAt(5) ? '-ms-' + a : '') + a, 211 === e + h && 105 === a.charCodeAt(13) && 0 < a.indexOf('transform', 10)) return a.substring(0, a.indexOf(';', 27) + 1).replace(ma, '$1-webkit-$2') + a;
	    }

	    return a;
	  }

	  function L(d, c) {
	    var e = d.indexOf(1 === c ? ':' : '{'),
	        h = d.substring(0, 3 !== c ? e : 10);
	    e = d.substring(e + 1, d.length - 1);
	    return R(2 !== c ? h : h.replace(na, '$1'), e, c);
	  }

	  function ea(d, c) {
	    var e = P(c, c.charCodeAt(0), c.charCodeAt(1), c.charCodeAt(2));
	    return e !== c + ';' ? e.replace(oa, ' or ($1)').substring(4) : '(' + c + ')';
	  }

	  function H(d, c, e, h, a, m, b, v, n, q) {
	    for (var g = 0, x = c, w; g < A; ++g) {
	      switch (w = S[g].call(B, d, x, e, h, a, m, b, v, n, q)) {
	        case void 0:
	        case !1:
	        case !0:
	        case null:
	          break;

	        default:
	          x = w;
	      }
	    }

	    if (x !== c) return x;
	  }

	  function T(d) {
	    switch (d) {
	      case void 0:
	      case null:
	        A = S.length = 0;
	        break;

	      default:
	        if ('function' === typeof d) S[A++] = d;else if ('object' === typeof d) for (var c = 0, e = d.length; c < e; ++c) {
	          T(d[c]);
	        } else Y = !!d | 0;
	    }

	    return T;
	  }

	  function U(d) {
	    d = d.prefix;
	    void 0 !== d && (R = null, d ? 'function' !== typeof d ? w = 1 : (w = 2, R = d) : w = 0);
	    return U;
	  }

	  function B(d, c) {
	    var e = d;
	    33 > e.charCodeAt(0) && (e = e.trim());
	    V = e;
	    e = [V];

	    if (0 < A) {
	      var h = H(-1, c, e, e, D, z, 0, 0, 0, 0);
	      void 0 !== h && 'string' === typeof h && (c = h);
	    }

	    var a = M(O, e, c, 0, 0);
	    0 < A && (h = H(-2, a, e, e, D, z, a.length, 0, 0, 0), void 0 !== h && (a = h));
	    V = '';
	    E = 0;
	    z = D = 1;
	    return a;
	  }

	  var ca = /^\0+/g,
	      N = /[\0\r\f]/g,
	      aa = /: */g,
	      ka = /zoo|gra/,
	      ma = /([,: ])(transform)/g,
	      ia = /,\r+?/g,
	      F = /([\t\r\n ])*\f?&/g,
	      fa = /@(k\w+)\s*(\S*)\s*/,
	      Q = /::(place)/g,
	      ha = /:(read-only)/g,
	      G = /[svh]\w+-[tblr]{2}/,
	      da = /\(\s*(.*)\s*\)/g,
	      oa = /([\s\S]*?);/g,
	      ba = /-self|flex-/g,
	      na = /[^]*?(:[rp][el]a[\w-]+)[^]*/,
	      la = /stretch|:\s*\w+\-(?:conte|avail)/,
	      ja = /([^-])(image-set\()/,
	      z = 1,
	      D = 1,
	      E = 0,
	      w = 1,
	      O = [],
	      S = [],
	      A = 0,
	      R = null,
	      Y = 0,
	      V = '';
	  B.use = T;
	  B.set = U;
	  void 0 !== W && U(W);
	  return B;
	}

	var unitlessKeys = {
	  animationIterationCount: 1,
	  borderImageOutset: 1,
	  borderImageSlice: 1,
	  borderImageWidth: 1,
	  boxFlex: 1,
	  boxFlexGroup: 1,
	  boxOrdinalGroup: 1,
	  columnCount: 1,
	  columns: 1,
	  flex: 1,
	  flexGrow: 1,
	  flexPositive: 1,
	  flexShrink: 1,
	  flexNegative: 1,
	  flexOrder: 1,
	  gridRow: 1,
	  gridRowEnd: 1,
	  gridRowSpan: 1,
	  gridRowStart: 1,
	  gridColumn: 1,
	  gridColumnEnd: 1,
	  gridColumnSpan: 1,
	  gridColumnStart: 1,
	  msGridRow: 1,
	  msGridRowSpan: 1,
	  msGridColumn: 1,
	  msGridColumnSpan: 1,
	  fontWeight: 1,
	  lineHeight: 1,
	  opacity: 1,
	  order: 1,
	  orphans: 1,
	  tabSize: 1,
	  widows: 1,
	  zIndex: 1,
	  zoom: 1,
	  WebkitLineClamp: 1,
	  // SVG-related properties
	  fillOpacity: 1,
	  floodOpacity: 1,
	  stopOpacity: 1,
	  strokeDasharray: 1,
	  strokeDashoffset: 1,
	  strokeMiterlimit: 1,
	  strokeOpacity: 1,
	  strokeWidth: 1
	};

	function memoize(fn) {
	  var cache = {};
	  return function (arg) {
	    if (cache[arg] === undefined) cache[arg] = fn(arg);
	    return cache[arg];
	  };
	}

	var reactPropsRegex = /^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|download|draggable|encType|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|inert|itemProp|itemScope|itemType|itemID|itemRef|on|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/; // https://esbench.com/bench/5bfee68a4cd7e6009ef61d23

	var index = memoize(function (prop) {
	  return reactPropsRegex.test(prop) || prop.charCodeAt(0) === 111
	  /* o */
	  && prop.charCodeAt(1) === 110
	  /* n */
	  && prop.charCodeAt(2) < 91;
	}
	/* Z+1 */
	);

	var reactIs = reactIs$1.exports;

	/**
	 * Copyright 2015, Yahoo! Inc.
	 * Copyrights licensed under the New BSD License. See the accompanying LICENSE file for terms.
	 */
	var REACT_STATICS = {
	  childContextTypes: true,
	  contextType: true,
	  contextTypes: true,
	  defaultProps: true,
	  displayName: true,
	  getDefaultProps: true,
	  getDerivedStateFromError: true,
	  getDerivedStateFromProps: true,
	  mixins: true,
	  propTypes: true,
	  type: true
	};
	var KNOWN_STATICS = {
	  name: true,
	  length: true,
	  prototype: true,
	  caller: true,
	  callee: true,
	  arguments: true,
	  arity: true
	};
	var FORWARD_REF_STATICS = {
	  '$$typeof': true,
	  render: true,
	  defaultProps: true,
	  displayName: true,
	  propTypes: true
	};
	var MEMO_STATICS = {
	  '$$typeof': true,
	  compare: true,
	  defaultProps: true,
	  displayName: true,
	  propTypes: true,
	  type: true
	};
	var TYPE_STATICS = {};
	TYPE_STATICS[reactIs.ForwardRef] = FORWARD_REF_STATICS;
	TYPE_STATICS[reactIs.Memo] = MEMO_STATICS;

	function getStatics(component) {
	  // React v16.11 and below
	  if (reactIs.isMemo(component)) {
	    return MEMO_STATICS;
	  } // React v16.12 and above


	  return TYPE_STATICS[component['$$typeof']] || REACT_STATICS;
	}

	var defineProperty = Object.defineProperty;
	var getOwnPropertyNames = Object.getOwnPropertyNames;
	var getOwnPropertySymbols = Object.getOwnPropertySymbols;
	var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
	var getPrototypeOf = Object.getPrototypeOf;
	var objectPrototype = Object.prototype;
	function hoistNonReactStatics(targetComponent, sourceComponent, blacklist) {
	  if (typeof sourceComponent !== 'string') {
	    // don't hoist over string (html) components
	    if (objectPrototype) {
	      var inheritedComponent = getPrototypeOf(sourceComponent);

	      if (inheritedComponent && inheritedComponent !== objectPrototype) {
	        hoistNonReactStatics(targetComponent, inheritedComponent, blacklist);
	      }
	    }

	    var keys = getOwnPropertyNames(sourceComponent);

	    if (getOwnPropertySymbols) {
	      keys = keys.concat(getOwnPropertySymbols(sourceComponent));
	    }

	    var targetStatics = getStatics(targetComponent);
	    var sourceStatics = getStatics(sourceComponent);

	    for (var i = 0; i < keys.length; ++i) {
	      var key = keys[i];

	      if (!KNOWN_STATICS[key] && !(blacklist && blacklist[key]) && !(sourceStatics && sourceStatics[key]) && !(targetStatics && targetStatics[key])) {
	        var descriptor = getOwnPropertyDescriptor(sourceComponent, key);

	        try {
	          // Avoid failures from read-only properties
	          defineProperty(targetComponent, key, descriptor);
	        } catch (e) {}
	      }
	    }
	  }

	  return targetComponent;
	}

	var hoistNonReactStatics_cjs = hoistNonReactStatics;

	function v(){return (v=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r]);}return e}).apply(this,arguments)}var g=function(e,t){for(var n=[e[0]],r=0,o=t.length;r<o;r+=1)n.push(t[r],e[r+1]);return n},S=function(t){return null!==t&&"object"==typeof t&&"[object Object]"===(t.toString?t.toString():Object.prototype.toString.call(t))&&!reactIs$1.exports.typeOf(t)},w=Object.freeze([]),E=Object.freeze({});function b(e){return "function"==typeof e}function _(e){return e.displayName||e.name||"Component"}function N(e){return e&&"string"==typeof e.styledComponentId}var A="undefined"!=typeof process&&(process.env.REACT_APP_SC_ATTR||process.env.SC_ATTR)||"data-styled",C="5.3.3",I="undefined"!=typeof window&&"HTMLElement"in window,P=Boolean("boolean"==typeof SC_DISABLE_SPEEDY?SC_DISABLE_SPEEDY:"undefined"!=typeof process&&void 0!==process.env.REACT_APP_SC_DISABLE_SPEEDY&&""!==process.env.REACT_APP_SC_DISABLE_SPEEDY?"false"!==process.env.REACT_APP_SC_DISABLE_SPEEDY&&process.env.REACT_APP_SC_DISABLE_SPEEDY:"undefined"!=typeof process&&void 0!==process.env.SC_DISABLE_SPEEDY&&""!==process.env.SC_DISABLE_SPEEDY?"false"!==process.env.SC_DISABLE_SPEEDY&&process.env.SC_DISABLE_SPEEDY:"production"!=="production"),O={};function j(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];throw new Error("An error occurred. See https://git.io/JUIaE#"+e+" for more information."+(n.length>0?" Args: "+n.join(", "):""))}var T=function(){function e(e){this.groupSizes=new Uint32Array(512),this.length=512,this.tag=e;}var t=e.prototype;return t.indexOfGroup=function(e){for(var t=0,n=0;n<e;n++)t+=this.groupSizes[n];return t},t.insertRules=function(e,t){if(e>=this.groupSizes.length){for(var n=this.groupSizes,r=n.length,o=r;e>=o;)(o<<=1)<0&&j(16,""+e);this.groupSizes=new Uint32Array(o),this.groupSizes.set(n),this.length=o;for(var s=r;s<o;s++)this.groupSizes[s]=0;}for(var i=this.indexOfGroup(e+1),a=0,c=t.length;a<c;a++)this.tag.insertRule(i,t[a])&&(this.groupSizes[e]++,i++);},t.clearGroup=function(e){if(e<this.length){var t=this.groupSizes[e],n=this.indexOfGroup(e),r=n+t;this.groupSizes[e]=0;for(var o=n;o<r;o++)this.tag.deleteRule(n);}},t.getGroup=function(e){var t="";if(e>=this.length||0===this.groupSizes[e])return t;for(var n=this.groupSizes[e],r=this.indexOfGroup(e),o=r+n,s=r;s<o;s++)t+=this.tag.getRule(s)+"/*!sc*/\n";return t},e}(),x=new Map,k=new Map,V=1,B=function(e){if(x.has(e))return x.get(e);for(;k.has(V);)V++;var t=V++;return x.set(e,t),k.set(t,e),t},z=function(e){return k.get(e)},M=function(e,t){t>=V&&(V=t+1),x.set(e,t),k.set(t,e);},G="style["+A+'][data-styled-version="5.3.3"]',L=new RegExp("^"+A+'\\.g(\\d+)\\[id="([\\w\\d-]+)"\\].*?"([^"]*)'),F=function(e,t,n){for(var r,o=n.split(","),s=0,i=o.length;s<i;s++)(r=o[s])&&e.registerName(t,r);},Y=function(e,t){for(var n=(t.textContent||"").split("/*!sc*/\n"),r=[],o=0,s=n.length;o<s;o++){var i=n[o].trim();if(i){var a=i.match(L);if(a){var c=0|parseInt(a[1],10),u=a[2];0!==c&&(M(u,c),F(e,u,a[3]),e.getTag().insertRules(c,r)),r.length=0;}else r.push(i);}}},q=function(){return "undefined"!=typeof window&&void 0!==window.__webpack_nonce__?window.__webpack_nonce__:null},H=function(e){var t=document.head,n=e||t,r=document.createElement("style"),o=function(e){for(var t=e.childNodes,n=t.length;n>=0;n--){var r=t[n];if(r&&1===r.nodeType&&r.hasAttribute(A))return r}}(n),s=void 0!==o?o.nextSibling:null;r.setAttribute(A,"active"),r.setAttribute("data-styled-version","5.3.3");var i=q();return i&&r.setAttribute("nonce",i),n.insertBefore(r,s),r},$=function(){function e(e){var t=this.element=H(e);t.appendChild(document.createTextNode("")),this.sheet=function(e){if(e.sheet)return e.sheet;for(var t=document.styleSheets,n=0,r=t.length;n<r;n++){var o=t[n];if(o.ownerNode===e)return o}j(17);}(t),this.length=0;}var t=e.prototype;return t.insertRule=function(e,t){try{return this.sheet.insertRule(t,e),this.length++,!0}catch(e){return !1}},t.deleteRule=function(e){this.sheet.deleteRule(e),this.length--;},t.getRule=function(e){var t=this.sheet.cssRules[e];return void 0!==t&&"string"==typeof t.cssText?t.cssText:""},e}(),W=function(){function e(e){var t=this.element=H(e);this.nodes=t.childNodes,this.length=0;}var t=e.prototype;return t.insertRule=function(e,t){if(e<=this.length&&e>=0){var n=document.createTextNode(t),r=this.nodes[e];return this.element.insertBefore(n,r||null),this.length++,!0}return !1},t.deleteRule=function(e){this.element.removeChild(this.nodes[e]),this.length--;},t.getRule=function(e){return e<this.length?this.nodes[e].textContent:""},e}(),U=function(){function e(e){this.rules=[],this.length=0;}var t=e.prototype;return t.insertRule=function(e,t){return e<=this.length&&(this.rules.splice(e,0,t),this.length++,!0)},t.deleteRule=function(e){this.rules.splice(e,1),this.length--;},t.getRule=function(e){return e<this.length?this.rules[e]:""},e}(),J=I,X={isServer:!I,useCSSOMInjection:!P},Z=function(){function e(e,t,n){void 0===e&&(e=E),void 0===t&&(t={}),this.options=v({},X,{},e),this.gs=t,this.names=new Map(n),this.server=!!e.isServer,!this.server&&I&&J&&(J=!1,function(e){for(var t=document.querySelectorAll(G),n=0,r=t.length;n<r;n++){var o=t[n];o&&"active"!==o.getAttribute(A)&&(Y(e,o),o.parentNode&&o.parentNode.removeChild(o));}}(this));}e.registerId=function(e){return B(e)};var t=e.prototype;return t.reconstructWithOptions=function(t,n){return void 0===n&&(n=!0),new e(v({},this.options,{},t),this.gs,n&&this.names||void 0)},t.allocateGSInstance=function(e){return this.gs[e]=(this.gs[e]||0)+1},t.getTag=function(){return this.tag||(this.tag=(n=(t=this.options).isServer,r=t.useCSSOMInjection,o=t.target,e=n?new U(o):r?new $(o):new W(o),new T(e)));var e,t,n,r,o;},t.hasNameForId=function(e,t){return this.names.has(e)&&this.names.get(e).has(t)},t.registerName=function(e,t){if(B(e),this.names.has(e))this.names.get(e).add(t);else {var n=new Set;n.add(t),this.names.set(e,n);}},t.insertRules=function(e,t,n){this.registerName(e,t),this.getTag().insertRules(B(e),n);},t.clearNames=function(e){this.names.has(e)&&this.names.get(e).clear();},t.clearRules=function(e){this.getTag().clearGroup(B(e)),this.clearNames(e);},t.clearTag=function(){this.tag=void 0;},t.toString=function(){return function(e){for(var t=e.getTag(),n=t.length,r="",o=0;o<n;o++){var s=z(o);if(void 0!==s){var i=e.names.get(s),a=t.getGroup(o);if(i&&a&&i.size){var c=A+".g"+o+'[id="'+s+'"]',u="";void 0!==i&&i.forEach((function(e){e.length>0&&(u+=e+",");})),r+=""+a+c+'{content:"'+u+'"}/*!sc*/\n';}}}return r}(this)},e}(),K=/(a)(d)/gi,Q=function(e){return String.fromCharCode(e+(e>25?39:97))};function ee(e){var t,n="";for(t=Math.abs(e);t>52;t=t/52|0)n=Q(t%52)+n;return (Q(t%52)+n).replace(K,"$1-$2")}var te=function(e,t){for(var n=t.length;n;)e=33*e^t.charCodeAt(--n);return e},ne=function(e){return te(5381,e)};function re(e){for(var t=0;t<e.length;t+=1){var n=e[t];if(b(n)&&!N(n))return !1}return !0}var oe=ne("5.3.3"),se=function(){function e(e,t,n){this.rules=e,this.staticRulesId="",this.isStatic=(void 0===n||n.isStatic)&&re(e),this.componentId=t,this.baseHash=te(oe,t),this.baseStyle=n,Z.registerId(t);}return e.prototype.generateAndInjectStyles=function(e,t,n){var r=this.componentId,o=[];if(this.baseStyle&&o.push(this.baseStyle.generateAndInjectStyles(e,t,n)),this.isStatic&&!n.hash)if(this.staticRulesId&&t.hasNameForId(r,this.staticRulesId))o.push(this.staticRulesId);else {var s=Ne(this.rules,e,t,n).join(""),i=ee(te(this.baseHash,s)>>>0);if(!t.hasNameForId(r,i)){var a=n(s,"."+i,void 0,r);t.insertRules(r,i,a);}o.push(i),this.staticRulesId=i;}else {for(var c=this.rules.length,u=te(this.baseHash,n.hash),l="",d=0;d<c;d++){var h=this.rules[d];if("string"==typeof h)l+=h;else if(h){var p=Ne(h,e,t,n),f=Array.isArray(p)?p.join(""):p;u=te(u,f+d),l+=f;}}if(l){var m=ee(u>>>0);if(!t.hasNameForId(r,m)){var y=n(l,"."+m,void 0,r);t.insertRules(r,m,y);}o.push(m);}}return o.join(" ")},e}(),ie=/^\s*\/\/.*$/gm,ae=[":","[",".","#"];function ce(e){var t,n,r,o,s=void 0===e?E:e,i=s.options,a=void 0===i?E:i,c=s.plugins,u=void 0===c?w:c,l=new stylis_min(a),d=[],h=function(e){function t(t){if(t)try{e(t+"}");}catch(e){}}return function(n,r,o,s,i,a,c,u,l,d){switch(n){case 1:if(0===l&&64===r.charCodeAt(0))return e(r+";"),"";break;case 2:if(0===u)return r+"/*|*/";break;case 3:switch(u){case 102:case 112:return e(o[0]+r),"";default:return r+(0===d?"/*|*/":"")}case-2:r.split("/*|*/}").forEach(t);}}}((function(e){d.push(e);})),f=function(e,r,s){return 0===r&&-1!==ae.indexOf(s[n.length])||s.match(o)?e:"."+t};function m(e,s,i,a){void 0===a&&(a="&");var c=e.replace(ie,""),u=s&&i?i+" "+s+" { "+c+" }":c;return t=a,n=s,r=new RegExp("\\"+n+"\\b","g"),o=new RegExp("(\\"+n+"\\b){2,}"),l(i||!s?"":s,u)}return l.use([].concat(u,[function(e,t,o){2===e&&o.length&&o[0].lastIndexOf(n)>0&&(o[0]=o[0].replace(r,f));},h,function(e){if(-2===e){var t=d;return d=[],t}}])),m.hash=u.length?u.reduce((function(e,t){return t.name||j(15),te(e,t.name)}),5381).toString():"",m}var ue=r$2.createContext(),le=ue.Consumer,de=r$2.createContext(),he=(de.Consumer,new Z),pe=ce();function fe(){return react.exports.useContext(ue)||he}function me(){return react.exports.useContext(de)||pe}function ye(e){var t=react.exports.useState(e.stylisPlugins),n=t[0],s=t[1],c=fe(),u=react.exports.useMemo((function(){var t=c;return e.sheet?t=e.sheet:e.target&&(t=t.reconstructWithOptions({target:e.target},!1)),e.disableCSSOMInjection&&(t=t.reconstructWithOptions({useCSSOMInjection:!1})),t}),[e.disableCSSOMInjection,e.sheet,e.target]),l=react.exports.useMemo((function(){return ce({options:{prefix:!e.disableVendorPrefixes},plugins:n})}),[e.disableVendorPrefixes,n]);return react.exports.useEffect((function(){shallowequal(n,e.stylisPlugins)||s(e.stylisPlugins);}),[e.stylisPlugins]),r$2.createElement(ue.Provider,{value:u},r$2.createElement(de.Provider,{value:l},e.children))}var ve=function(){function e(e,t){var n=this;this.inject=function(e,t){void 0===t&&(t=pe);var r=n.name+t.hash;e.hasNameForId(n.id,r)||e.insertRules(n.id,r,t(n.rules,r,"@keyframes"));},this.toString=function(){return j(12,String(n.name))},this.name=e,this.id="sc-keyframes-"+e,this.rules=t;}return e.prototype.getName=function(e){return void 0===e&&(e=pe),this.name+e.hash},e}(),ge=/([A-Z])/,Se=/([A-Z])/g,we=/^ms-/,Ee=function(e){return "-"+e.toLowerCase()};function be(e){return ge.test(e)?e.replace(Se,Ee).replace(we,"-ms-"):e}var _e=function(e){return null==e||!1===e||""===e};function Ne(e,n,r,o){if(Array.isArray(e)){for(var s,i=[],a=0,c=e.length;a<c;a+=1)""!==(s=Ne(e[a],n,r,o))&&(Array.isArray(s)?i.push.apply(i,s):i.push(s));return i}if(_e(e))return "";if(N(e))return "."+e.styledComponentId;if(b(e)){if("function"!=typeof(l=e)||l.prototype&&l.prototype.isReactComponent||!n)return e;var u=e(n);return Ne(u,n,r,o)}var l;return e instanceof ve?r?(e.inject(r,o),e.getName(o)):e:S(e)?function e(t,n){var r,o,s=[];for(var i in t)t.hasOwnProperty(i)&&!_e(t[i])&&(Array.isArray(t[i])&&t[i].isCss||b(t[i])?s.push(be(i)+":",t[i],";"):S(t[i])?s.push.apply(s,e(t[i],i)):s.push(be(i)+": "+(r=i,null==(o=t[i])||"boolean"==typeof o||""===o?"":"number"!=typeof o||0===o||r in unitlessKeys?String(o).trim():o+"px")+";"));return n?[n+" {"].concat(s,["}"]):s}(e):e.toString()}var Ae=function(e){return Array.isArray(e)&&(e.isCss=!0),e};function Ce(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];return b(e)||S(e)?Ae(Ne(g(w,[e].concat(n)))):0===n.length&&1===e.length&&"string"==typeof e[0]?e:Ae(Ne(g(e,n)))}var Re=function(e,t,n){return void 0===n&&(n=E),e.theme!==n.theme&&e.theme||t||n.theme},De=/[!"#$%&'()*+,./:;<=>?@[\\\]^`{|}~-]+/g,je=/(^-|-$)/g;function Te(e){return e.replace(De,"-").replace(je,"")}var xe=function(e){return ee(ne(e)>>>0)};function ke(e){return "string"==typeof e&&("production"==="production")}var Ve=function(e){return "function"==typeof e||"object"==typeof e&&null!==e&&!Array.isArray(e)},Be=function(e){return "__proto__"!==e&&"constructor"!==e&&"prototype"!==e};function ze(e,t,n){var r=e[n];Ve(t)&&Ve(r)?Me(r,t):e[n]=t;}function Me(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];for(var o=0,s=n;o<s.length;o++){var i=s[o];if(Ve(i))for(var a in i)Be(a)&&ze(e,i[a],a);}return e}var Ge=r$2.createContext(),Le=Ge.Consumer;function Fe(e){var t=react.exports.useContext(Ge),n=react.exports.useMemo((function(){return function(e,t){if(!e)return j(14);if(b(e)){var n=e(t);return n}return Array.isArray(e)||"object"!=typeof e?j(8):t?v({},t,{},e):e}(e.theme,t)}),[e.theme,t]);return e.children?r$2.createElement(Ge.Provider,{value:n},e.children):null}var Ye={};function qe(e,t,n){var o=N(e),i=!ke(e),a=t.attrs,c=void 0===a?w:a,d=t.componentId,h=void 0===d?function(e,t){var n="string"!=typeof e?"sc":Te(e);Ye[n]=(Ye[n]||0)+1;var r=n+"-"+xe("5.3.3"+n+Ye[n]);return t?t+"-"+r:r}(t.displayName,t.parentComponentId):d,p=t.displayName,f=void 0===p?function(e){return ke(e)?"styled."+e:"Styled("+_(e)+")"}(e):p,g=t.displayName&&t.componentId?Te(t.displayName)+"-"+t.componentId:t.componentId||h,S=o&&e.attrs?Array.prototype.concat(e.attrs,c).filter(Boolean):c,A=t.shouldForwardProp;o&&e.shouldForwardProp&&(A=t.shouldForwardProp?function(n,r,o){return e.shouldForwardProp(n,r,o)&&t.shouldForwardProp(n,r,o)}:e.shouldForwardProp);var C,I=new se(n,g,o?e.componentStyle:void 0),P=I.isStatic&&0===c.length,O=function(e,t){return function(e,t,n,r){var o=e.attrs,i=e.componentStyle,a=e.defaultProps,c=e.foldedComponentIds,d=e.shouldForwardProp,h=e.styledComponentId,p=e.target;var f=function(e,t,n){void 0===e&&(e=E);var r=v({},t,{theme:e}),o={};return n.forEach((function(e){var t,n,s,i=e;for(t in b(i)&&(i=i(r)),i)r[t]=o[t]="className"===t?(n=o[t],s=i[t],n&&s?n+" "+s:n||s):i[t];})),[r,o]}(Re(t,react.exports.useContext(Ge),a)||E,t,o),y=f[0],g=f[1],S=function(e,t,n,r){var o=fe(),s=me(),i=t?e.generateAndInjectStyles(E,o,s):e.generateAndInjectStyles(n,o,s);return i}(i,r,y),w=n,_=g.$as||t.$as||g.as||t.as||p,N=ke(_),A=g!==t?v({},t,{},g):t,C={};for(var I in A)"$"!==I[0]&&"as"!==I&&("forwardedAs"===I?C.as=A[I]:(d?d(I,index,_):!N||index(I))&&(C[I]=A[I]));return t.style&&g.style!==t.style&&(C.style=v({},t.style,{},g.style)),C.className=Array.prototype.concat(c,h,S!==h?S:null,t.className,g.className).filter(Boolean).join(" "),C.ref=w,react.exports.createElement(_,C)}(C,e,t,P)};return O.displayName=f,(C=r$2.forwardRef(O)).attrs=S,C.componentStyle=I,C.displayName=f,C.shouldForwardProp=A,C.foldedComponentIds=o?Array.prototype.concat(e.foldedComponentIds,e.styledComponentId):w,C.styledComponentId=g,C.target=o?e.target:e,C.withComponent=function(e){var r=t.componentId,o=function(e,t){if(null==e)return {};var n,r,o={},s=Object.keys(e);for(r=0;r<s.length;r++)n=s[r],t.indexOf(n)>=0||(o[n]=e[n]);return o}(t,["componentId"]),s=r&&r+"-"+(ke(e)?e:Te(_(e)));return qe(e,v({},o,{attrs:S,componentId:s}),n)},Object.defineProperty(C,"defaultProps",{get:function(){return this._foldedDefaultProps},set:function(t){this._foldedDefaultProps=o?Me({},e.defaultProps,t):t;}}),C.toString=function(){return "."+C.styledComponentId},i&&hoistNonReactStatics_cjs(C,e,{attrs:!0,componentStyle:!0,displayName:!0,foldedComponentIds:!0,shouldForwardProp:!0,styledComponentId:!0,target:!0,withComponent:!0}),C}var He=function(e){return function e(t,r,o){if(void 0===o&&(o=E),!reactIs$1.exports.isValidElementType(r))return j(1,String(r));var s=function(){return t(r,o,Ce.apply(void 0,arguments))};return s.withConfig=function(n){return e(t,r,v({},o,{},n))},s.attrs=function(n){return e(t,r,v({},o,{attrs:Array.prototype.concat(o.attrs,n).filter(Boolean)}))},s}(qe,e)};["a","abbr","address","area","article","aside","audio","b","base","bdi","bdo","big","blockquote","body","br","button","canvas","caption","cite","code","col","colgroup","data","datalist","dd","del","details","dfn","dialog","div","dl","dt","em","embed","fieldset","figcaption","figure","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","iframe","img","input","ins","kbd","keygen","label","legend","li","link","main","map","mark","marquee","menu","menuitem","meta","meter","nav","noscript","object","ol","optgroup","option","output","p","param","picture","pre","progress","q","rp","rt","ruby","s","samp","script","section","select","small","source","span","strong","style","sub","summary","sup","table","tbody","td","textarea","tfoot","th","thead","time","title","tr","track","u","ul","var","video","wbr","circle","clipPath","defs","ellipse","foreignObject","g","image","line","linearGradient","marker","mask","path","pattern","polygon","polyline","radialGradient","rect","stop","svg","text","textPath","tspan"].forEach((function(e){He[e]=He(e);}));var $e=function(){function e(e,t){this.rules=e,this.componentId=t,this.isStatic=re(e),Z.registerId(this.componentId+1);}var t=e.prototype;return t.createStyles=function(e,t,n,r){var o=r(Ne(this.rules,t,n,r).join(""),""),s=this.componentId+e;n.insertRules(s,s,o);},t.removeStyles=function(e,t){t.clearRules(this.componentId+e);},t.renderStyles=function(e,t,n,r){e>2&&Z.registerId(this.componentId+e),this.removeStyles(e,n),this.createStyles(e,t,n,r);},e}();function We(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),o=1;o<t;o++)n[o-1]=arguments[o];var i=Ce.apply(void 0,[e].concat(n)),a="sc-global-"+xe(JSON.stringify(i)),u=new $e(i,a);function l(e){var t=fe(),n=me(),o=react.exports.useContext(Ge),l=react.exports.useRef(t.allocateGSInstance(a)).current;return t.server&&h(l,e,t,o,n),react.exports.useLayoutEffect((function(){if(!t.server)return h(l,e,t,o,n),function(){return u.removeStyles(l,t)}}),[l,e,t,o,n]),null}function h(e,t,n,r,o){if(u.isStatic)u.renderStyles(e,O,n,o);else {var s=v({},t,{theme:Re(t,r,l.defaultProps)});u.renderStyles(e,s,n,o);}}return r$2.memo(l)}function Ue(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];var o=Ce.apply(void 0,[e].concat(n)).join(""),s=xe(o);return new ve(s,o)}var Je=function(){function e(){var e=this;this._emitSheetCSS=function(){var t=e.instance.toString();if(!t)return "";var n=q();return "<style "+[n&&'nonce="'+n+'"',A+'="true"','data-styled-version="5.3.3"'].filter(Boolean).join(" ")+">"+t+"</style>"},this.getStyleTags=function(){return e.sealed?j(2):e._emitSheetCSS()},this.getStyleElement=function(){var t;if(e.sealed)return j(2);var n=((t={})[A]="",t["data-styled-version"]="5.3.3",t.dangerouslySetInnerHTML={__html:e.instance.toString()},t),o=q();return o&&(n.nonce=o),[r$2.createElement("style",v({},n,{key:"sc-0-0"}))]},this.seal=function(){e.sealed=!0;},this.instance=new Z({isServer:!0}),this.sealed=!1;}var t=e.prototype;return t.collectStyles=function(e){return this.sealed?j(2):r$2.createElement(ye,{sheet:this.instance},e)},t.interleaveWithNodeStream=function(e){return j(3)},e}(),Xe=function(e){var t=r$2.forwardRef((function(t,n){var o=react.exports.useContext(Ge),i=e.defaultProps,a=Re(t,o,i);return r$2.createElement(e,v({},t,{theme:a,ref:n}))}));return hoistNonReactStatics_cjs(t,e),t.displayName="WithTheme("+_(e)+")",t},Ze=function(){return react.exports.useContext(Ge)},Ke={StyleSheet:Z,masterSheet:he};

	var styledComponents_browser_esm = /*#__PURE__*/Object.freeze({
		__proto__: null,
		'default': He,
		ServerStyleSheet: Je,
		StyleSheetConsumer: le,
		StyleSheetContext: ue,
		StyleSheetManager: ye,
		ThemeConsumer: Le,
		ThemeContext: Ge,
		ThemeProvider: Fe,
		__PRIVATE__: Ke,
		createGlobalStyle: We,
		css: Ce,
		isStyledComponent: N,
		keyframes: Ue,
		useTheme: Ze,
		version: C,
		withTheme: Xe
	});

	var require$$3 = /*@__PURE__*/getAugmentedNamespace(styledComponents_browser_esm);

	(function (module, exports) {
	var __create = Object.create;
	var __defProp = Object.defineProperty;
	var __defProps = Object.defineProperties;
	var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
	var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
	var __getOwnPropNames = Object.getOwnPropertyNames;
	var __getOwnPropSymbols = Object.getOwnPropertySymbols;
	var __getProtoOf = Object.getPrototypeOf;
	var __hasOwnProp = Object.prototype.hasOwnProperty;
	var __propIsEnum = Object.prototype.propertyIsEnumerable;
	var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
	var __spreadValues = (a2, b2) => {
	  for (var prop in b2 || (b2 = {}))
	    if (__hasOwnProp.call(b2, prop))
	      __defNormalProp(a2, prop, b2[prop]);
	  if (__getOwnPropSymbols)
	    for (var prop of __getOwnPropSymbols(b2)) {
	      if (__propIsEnum.call(b2, prop))
	        __defNormalProp(a2, prop, b2[prop]);
	    }
	  return a2;
	};
	var __spreadProps = (a2, b2) => __defProps(a2, __getOwnPropDescs(b2));
	var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
	var __objRest = (source, exclude) => {
	  var target = {};
	  for (var prop in source)
	    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
	      target[prop] = source[prop];
	  if (source != null && __getOwnPropSymbols)
	    for (var prop of __getOwnPropSymbols(source)) {
	      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
	        target[prop] = source[prop];
	    }
	  return target;
	};
	var __commonJS = (cb, mod) => function __require() {
	  return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
	};
	var __export = (target, all) => {
	  __markAsModule(target);
	  for (var name in all)
	    __defProp(target, name, { get: all[name], enumerable: true });
	};
	var __reExport = (target, module2, desc) => {
	  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
	    for (let key of __getOwnPropNames(module2))
	      if (!__hasOwnProp.call(target, key) && key !== "default")
	        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
	  }
	  return target;
	};
	var __toModule = (module2) => {
	  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
	};
	var __publicField = (obj, key, value) => {
	  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
	  return value;
	};
	var __async = (__this, __arguments, generator) => {
	  return new Promise((resolve, reject) => {
	    var fulfilled = (value) => {
	      try {
	        step(generator.next(value));
	      } catch (e) {
	        reject(e);
	      }
	    };
	    var rejected = (value) => {
	      try {
	        step(generator.throw(value));
	      } catch (e) {
	        reject(e);
	      }
	    };
	    var step = (x2) => x2.done ? resolve(x2.value) : Promise.resolve(x2.value).then(fulfilled, rejected);
	    step((generator = generator.apply(__this, __arguments)).next());
	  });
	};

	// ../node_modules/queue-microtask/index.js
	var require_queue_microtask = __commonJS({
	  "../node_modules/queue-microtask/index.js"(exports2, module2) {
	    var promise;
	    module2.exports = typeof queueMicrotask === "function" ? queueMicrotask.bind(typeof window !== "undefined" ? window : window) : (cb) => (promise || (promise = Promise.resolve())).then(cb).catch((err) => setTimeout(() => {
	      throw err;
	    }, 0));
	  }
	});

	// ../node_modules/polished/lib/internalHelpers/_curry.js
	var require_curry = __commonJS({
	  "../node_modules/polished/lib/internalHelpers/_curry.js"(exports2, module2) {
	    exports2.__esModule = true;
	    exports2["default"] = curry2;
	    function curried2(f2, length, acc) {
	      return function fn2() {
	        var combined = acc.concat(Array.prototype.slice.call(arguments));
	        return combined.length >= length ? f2.apply(this, combined) : curried2(f2, length, combined);
	      };
	    }
	    function curry2(f2) {
	      return curried2(f2, f2.length, []);
	    }
	    module2.exports = exports2.default;
	  }
	});

	// ../node_modules/polished/lib/internalHelpers/_guard.js
	var require_guard = __commonJS({
	  "../node_modules/polished/lib/internalHelpers/_guard.js"(exports2, module2) {
	    exports2.__esModule = true;
	    exports2["default"] = void 0;
	    function guard2(lowerBoundary, upperBoundary, value) {
	      return Math.max(lowerBoundary, Math.min(upperBoundary, value));
	    }
	    var _default = guard2;
	    exports2["default"] = _default;
	    module2.exports = exports2.default;
	  }
	});

	// ../node_modules/polished/lib/internalHelpers/_hslToRgb.js
	var require_hslToRgb = __commonJS({
	  "../node_modules/polished/lib/internalHelpers/_hslToRgb.js"(exports2, module2) {
	    exports2.__esModule = true;
	    exports2["default"] = void 0;
	    function colorToInt2(color2) {
	      return Math.round(color2 * 255);
	    }
	    function convertToInt2(red, green, blue) {
	      return colorToInt2(red) + "," + colorToInt2(green) + "," + colorToInt2(blue);
	    }
	    function hslToRgb2(hue, saturation, lightness, convert) {
	      if (convert === void 0) {
	        convert = convertToInt2;
	      }
	      if (saturation === 0) {
	        return convert(lightness, lightness, lightness);
	      }
	      var huePrime = (hue % 360 + 360) % 360 / 60;
	      var chroma = (1 - Math.abs(2 * lightness - 1)) * saturation;
	      var secondComponent = chroma * (1 - Math.abs(huePrime % 2 - 1));
	      var red = 0;
	      var green = 0;
	      var blue = 0;
	      if (huePrime >= 0 && huePrime < 1) {
	        red = chroma;
	        green = secondComponent;
	      } else if (huePrime >= 1 && huePrime < 2) {
	        red = secondComponent;
	        green = chroma;
	      } else if (huePrime >= 2 && huePrime < 3) {
	        green = chroma;
	        blue = secondComponent;
	      } else if (huePrime >= 3 && huePrime < 4) {
	        green = secondComponent;
	        blue = chroma;
	      } else if (huePrime >= 4 && huePrime < 5) {
	        red = secondComponent;
	        blue = chroma;
	      } else if (huePrime >= 5 && huePrime < 6) {
	        red = chroma;
	        blue = secondComponent;
	      }
	      var lightnessModification = lightness - chroma / 2;
	      var finalRed = red + lightnessModification;
	      var finalGreen = green + lightnessModification;
	      var finalBlue = blue + lightnessModification;
	      return convert(finalRed, finalGreen, finalBlue);
	    }
	    var _default = hslToRgb2;
	    exports2["default"] = _default;
	    module2.exports = exports2.default;
	  }
	});

	// ../node_modules/polished/lib/internalHelpers/_nameToHex.js
	var require_nameToHex = __commonJS({
	  "../node_modules/polished/lib/internalHelpers/_nameToHex.js"(exports2, module2) {
	    exports2.__esModule = true;
	    exports2["default"] = void 0;
	    var namedColorMap2 = {
	      aliceblue: "f0f8ff",
	      antiquewhite: "faebd7",
	      aqua: "00ffff",
	      aquamarine: "7fffd4",
	      azure: "f0ffff",
	      beige: "f5f5dc",
	      bisque: "ffe4c4",
	      black: "000",
	      blanchedalmond: "ffebcd",
	      blue: "0000ff",
	      blueviolet: "8a2be2",
	      brown: "a52a2a",
	      burlywood: "deb887",
	      cadetblue: "5f9ea0",
	      chartreuse: "7fff00",
	      chocolate: "d2691e",
	      coral: "ff7f50",
	      cornflowerblue: "6495ed",
	      cornsilk: "fff8dc",
	      crimson: "dc143c",
	      cyan: "00ffff",
	      darkblue: "00008b",
	      darkcyan: "008b8b",
	      darkgoldenrod: "b8860b",
	      darkgray: "a9a9a9",
	      darkgreen: "006400",
	      darkgrey: "a9a9a9",
	      darkkhaki: "bdb76b",
	      darkmagenta: "8b008b",
	      darkolivegreen: "556b2f",
	      darkorange: "ff8c00",
	      darkorchid: "9932cc",
	      darkred: "8b0000",
	      darksalmon: "e9967a",
	      darkseagreen: "8fbc8f",
	      darkslateblue: "483d8b",
	      darkslategray: "2f4f4f",
	      darkslategrey: "2f4f4f",
	      darkturquoise: "00ced1",
	      darkviolet: "9400d3",
	      deeppink: "ff1493",
	      deepskyblue: "00bfff",
	      dimgray: "696969",
	      dimgrey: "696969",
	      dodgerblue: "1e90ff",
	      firebrick: "b22222",
	      floralwhite: "fffaf0",
	      forestgreen: "228b22",
	      fuchsia: "ff00ff",
	      gainsboro: "dcdcdc",
	      ghostwhite: "f8f8ff",
	      gold: "ffd700",
	      goldenrod: "daa520",
	      gray: "808080",
	      green: "008000",
	      greenyellow: "adff2f",
	      grey: "808080",
	      honeydew: "f0fff0",
	      hotpink: "ff69b4",
	      indianred: "cd5c5c",
	      indigo: "4b0082",
	      ivory: "fffff0",
	      khaki: "f0e68c",
	      lavender: "e6e6fa",
	      lavenderblush: "fff0f5",
	      lawngreen: "7cfc00",
	      lemonchiffon: "fffacd",
	      lightblue: "add8e6",
	      lightcoral: "f08080",
	      lightcyan: "e0ffff",
	      lightgoldenrodyellow: "fafad2",
	      lightgray: "d3d3d3",
	      lightgreen: "90ee90",
	      lightgrey: "d3d3d3",
	      lightpink: "ffb6c1",
	      lightsalmon: "ffa07a",
	      lightseagreen: "20b2aa",
	      lightskyblue: "87cefa",
	      lightslategray: "789",
	      lightslategrey: "789",
	      lightsteelblue: "b0c4de",
	      lightyellow: "ffffe0",
	      lime: "0f0",
	      limegreen: "32cd32",
	      linen: "faf0e6",
	      magenta: "f0f",
	      maroon: "800000",
	      mediumaquamarine: "66cdaa",
	      mediumblue: "0000cd",
	      mediumorchid: "ba55d3",
	      mediumpurple: "9370db",
	      mediumseagreen: "3cb371",
	      mediumslateblue: "7b68ee",
	      mediumspringgreen: "00fa9a",
	      mediumturquoise: "48d1cc",
	      mediumvioletred: "c71585",
	      midnightblue: "191970",
	      mintcream: "f5fffa",
	      mistyrose: "ffe4e1",
	      moccasin: "ffe4b5",
	      navajowhite: "ffdead",
	      navy: "000080",
	      oldlace: "fdf5e6",
	      olive: "808000",
	      olivedrab: "6b8e23",
	      orange: "ffa500",
	      orangered: "ff4500",
	      orchid: "da70d6",
	      palegoldenrod: "eee8aa",
	      palegreen: "98fb98",
	      paleturquoise: "afeeee",
	      palevioletred: "db7093",
	      papayawhip: "ffefd5",
	      peachpuff: "ffdab9",
	      peru: "cd853f",
	      pink: "ffc0cb",
	      plum: "dda0dd",
	      powderblue: "b0e0e6",
	      purple: "800080",
	      rebeccapurple: "639",
	      red: "f00",
	      rosybrown: "bc8f8f",
	      royalblue: "4169e1",
	      saddlebrown: "8b4513",
	      salmon: "fa8072",
	      sandybrown: "f4a460",
	      seagreen: "2e8b57",
	      seashell: "fff5ee",
	      sienna: "a0522d",
	      silver: "c0c0c0",
	      skyblue: "87ceeb",
	      slateblue: "6a5acd",
	      slategray: "708090",
	      slategrey: "708090",
	      snow: "fffafa",
	      springgreen: "00ff7f",
	      steelblue: "4682b4",
	      tan: "d2b48c",
	      teal: "008080",
	      thistle: "d8bfd8",
	      tomato: "ff6347",
	      turquoise: "40e0d0",
	      violet: "ee82ee",
	      wheat: "f5deb3",
	      white: "fff",
	      whitesmoke: "f5f5f5",
	      yellow: "ff0",
	      yellowgreen: "9acd32"
	    };
	    function nameToHex2(color2) {
	      if (typeof color2 !== "string")
	        return color2;
	      var normalizedColorName = color2.toLowerCase();
	      return namedColorMap2[normalizedColorName] ? "#" + namedColorMap2[normalizedColorName] : color2;
	    }
	    var _default = nameToHex2;
	    exports2["default"] = _default;
	    module2.exports = exports2.default;
	  }
	});

	// ../node_modules/polished/lib/internalHelpers/_errors.js
	var require_errors = __commonJS({
	  "../node_modules/polished/lib/internalHelpers/_errors.js"(exports2, module2) {
	    exports2.__esModule = true;
	    exports2["default"] = void 0;
	    function _assertThisInitialized2(self2) {
	      if (self2 === void 0) {
	        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	      }
	      return self2;
	    }
	    function _inheritsLoose2(subClass, superClass) {
	      subClass.prototype = Object.create(superClass.prototype);
	      subClass.prototype.constructor = subClass;
	      _setPrototypeOf2(subClass, superClass);
	    }
	    function _wrapNativeSuper2(Class) {
	      var _cache = typeof Map === "function" ? new Map() : void 0;
	      _wrapNativeSuper2 = function _wrapNativeSuper3(Class2) {
	        if (Class2 === null || !_isNativeFunction2(Class2))
	          return Class2;
	        if (typeof Class2 !== "function") {
	          throw new TypeError("Super expression must either be null or a function");
	        }
	        if (typeof _cache !== "undefined") {
	          if (_cache.has(Class2))
	            return _cache.get(Class2);
	          _cache.set(Class2, Wrapper);
	        }
	        function Wrapper() {
	          return _construct2(Class2, arguments, _getPrototypeOf2(this).constructor);
	        }
	        Wrapper.prototype = Object.create(Class2.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } });
	        return _setPrototypeOf2(Wrapper, Class2);
	      };
	      return _wrapNativeSuper2(Class);
	    }
	    function _construct2(Parent, args, Class) {
	      if (_isNativeReflectConstruct2()) {
	        _construct2 = Reflect.construct;
	      } else {
	        _construct2 = function _construct3(Parent2, args2, Class2) {
	          var a2 = [null];
	          a2.push.apply(a2, args2);
	          var Constructor = Function.bind.apply(Parent2, a2);
	          var instance = new Constructor();
	          if (Class2)
	            _setPrototypeOf2(instance, Class2.prototype);
	          return instance;
	        };
	      }
	      return _construct2.apply(null, arguments);
	    }
	    function _isNativeReflectConstruct2() {
	      if (typeof Reflect === "undefined" || !Reflect.construct)
	        return false;
	      if (Reflect.construct.sham)
	        return false;
	      if (typeof Proxy === "function")
	        return true;
	      try {
	        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
	        }));
	        return true;
	      } catch (e) {
	        return false;
	      }
	    }
	    function _isNativeFunction2(fn2) {
	      return Function.toString.call(fn2).indexOf("[native code]") !== -1;
	    }
	    function _setPrototypeOf2(o2, p2) {
	      _setPrototypeOf2 = Object.setPrototypeOf || function _setPrototypeOf3(o3, p3) {
	        o3.__proto__ = p3;
	        return o3;
	      };
	      return _setPrototypeOf2(o2, p2);
	    }
	    function _getPrototypeOf2(o2) {
	      _getPrototypeOf2 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf3(o3) {
	        return o3.__proto__ || Object.getPrototypeOf(o3);
	      };
	      return _getPrototypeOf2(o2);
	    }
	    var ERRORS2 = {
	      "1": "Passed invalid arguments to hsl, please pass multiple numbers e.g. hsl(360, 0.75, 0.4) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75 }).\n\n",
	      "2": "Passed invalid arguments to hsla, please pass multiple numbers e.g. hsla(360, 0.75, 0.4, 0.7) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75, alpha: 0.7 }).\n\n",
	      "3": "Passed an incorrect argument to a color function, please pass a string representation of a color.\n\n",
	      "4": "Couldn't generate valid rgb string from %s, it returned %s.\n\n",
	      "5": "Couldn't parse the color string. Please provide the color as a string in hex, rgb, rgba, hsl or hsla notation.\n\n",
	      "6": "Passed invalid arguments to rgb, please pass multiple numbers e.g. rgb(255, 205, 100) or an object e.g. rgb({ red: 255, green: 205, blue: 100 }).\n\n",
	      "7": "Passed invalid arguments to rgba, please pass multiple numbers e.g. rgb(255, 205, 100, 0.75) or an object e.g. rgb({ red: 255, green: 205, blue: 100, alpha: 0.75 }).\n\n",
	      "8": "Passed invalid argument to toColorString, please pass a RgbColor, RgbaColor, HslColor or HslaColor object.\n\n",
	      "9": "Please provide a number of steps to the modularScale helper.\n\n",
	      "10": "Please pass a number or one of the predefined scales to the modularScale helper as the ratio.\n\n",
	      "11": 'Invalid value passed as base to modularScale, expected number or em string but got "%s"\n\n',
	      "12": 'Expected a string ending in "px" or a number passed as the first argument to %s(), got "%s" instead.\n\n',
	      "13": 'Expected a string ending in "px" or a number passed as the second argument to %s(), got "%s" instead.\n\n',
	      "14": 'Passed invalid pixel value ("%s") to %s(), please pass a value like "12px" or 12.\n\n',
	      "15": 'Passed invalid base value ("%s") to %s(), please pass a value like "12px" or 12.\n\n',
	      "16": "You must provide a template to this method.\n\n",
	      "17": "You passed an unsupported selector state to this method.\n\n",
	      "18": "minScreen and maxScreen must be provided as stringified numbers with the same units.\n\n",
	      "19": "fromSize and toSize must be provided as stringified numbers with the same units.\n\n",
	      "20": "expects either an array of objects or a single object with the properties prop, fromSize, and toSize.\n\n",
	      "21": "expects the objects in the first argument array to have the properties `prop`, `fromSize`, and `toSize`.\n\n",
	      "22": "expects the first argument object to have the properties `prop`, `fromSize`, and `toSize`.\n\n",
	      "23": "fontFace expects a name of a font-family.\n\n",
	      "24": "fontFace expects either the path to the font file(s) or a name of a local copy.\n\n",
	      "25": "fontFace expects localFonts to be an array.\n\n",
	      "26": "fontFace expects fileFormats to be an array.\n\n",
	      "27": "radialGradient requries at least 2 color-stops to properly render.\n\n",
	      "28": "Please supply a filename to retinaImage() as the first argument.\n\n",
	      "29": "Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.\n\n",
	      "30": "Passed an invalid value to `height` or `width`. Please provide a pixel based unit.\n\n",
	      "31": "The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation\n\n",
	      "32": "To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s')\n\n",
	      "33": "The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation\n\n",
	      "34": "borderRadius expects a radius value as a string or number as the second argument.\n\n",
	      "35": 'borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.\n\n',
	      "36": "Property must be a string value.\n\n",
	      "37": "Syntax Error at %s.\n\n",
	      "38": "Formula contains a function that needs parentheses at %s.\n\n",
	      "39": "Formula is missing closing parenthesis at %s.\n\n",
	      "40": "Formula has too many closing parentheses at %s.\n\n",
	      "41": "All values in a formula must have the same unit or be unitless.\n\n",
	      "42": "Please provide a number of steps to the modularScale helper.\n\n",
	      "43": "Please pass a number or one of the predefined scales to the modularScale helper as the ratio.\n\n",
	      "44": "Invalid value passed as base to modularScale, expected number or em/rem string but got %s.\n\n",
	      "45": "Passed invalid argument to hslToColorString, please pass a HslColor or HslaColor object.\n\n",
	      "46": "Passed invalid argument to rgbToColorString, please pass a RgbColor or RgbaColor object.\n\n",
	      "47": "minScreen and maxScreen must be provided as stringified numbers with the same units.\n\n",
	      "48": "fromSize and toSize must be provided as stringified numbers with the same units.\n\n",
	      "49": "Expects either an array of objects or a single object with the properties prop, fromSize, and toSize.\n\n",
	      "50": "Expects the objects in the first argument array to have the properties prop, fromSize, and toSize.\n\n",
	      "51": "Expects the first argument object to have the properties prop, fromSize, and toSize.\n\n",
	      "52": "fontFace expects either the path to the font file(s) or a name of a local copy.\n\n",
	      "53": "fontFace expects localFonts to be an array.\n\n",
	      "54": "fontFace expects fileFormats to be an array.\n\n",
	      "55": "fontFace expects a name of a font-family.\n\n",
	      "56": "linearGradient requries at least 2 color-stops to properly render.\n\n",
	      "57": "radialGradient requries at least 2 color-stops to properly render.\n\n",
	      "58": "Please supply a filename to retinaImage() as the first argument.\n\n",
	      "59": "Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.\n\n",
	      "60": "Passed an invalid value to `height` or `width`. Please provide a pixel based unit.\n\n",
	      "61": "Property must be a string value.\n\n",
	      "62": "borderRadius expects a radius value as a string or number as the second argument.\n\n",
	      "63": 'borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.\n\n',
	      "64": "The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation.\n\n",
	      "65": "To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s').\n\n",
	      "66": "The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation.\n\n",
	      "67": "You must provide a template to this method.\n\n",
	      "68": "You passed an unsupported selector state to this method.\n\n",
	      "69": 'Expected a string ending in "px" or a number passed as the first argument to %s(), got %s instead.\n\n',
	      "70": 'Expected a string ending in "px" or a number passed as the second argument to %s(), got %s instead.\n\n',
	      "71": 'Passed invalid pixel value %s to %s(), please pass a value like "12px" or 12.\n\n',
	      "72": 'Passed invalid base value %s to %s(), please pass a value like "12px" or 12.\n\n',
	      "73": "Please provide a valid CSS variable.\n\n",
	      "74": "CSS variable not found and no default was provided.\n\n",
	      "75": "important requires a valid style object, got a %s instead.\n\n",
	      "76": "fromSize and toSize must be provided as stringified numbers with the same units as minScreen and maxScreen.\n\n",
	      "77": 'remToPx expects a value in "rem" but you provided it in "%s".\n\n',
	      "78": 'base must be set in "px" or "%" but you set it in "%s".\n'
	    };
	    function format4() {
	      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	        args[_key] = arguments[_key];
	      }
	      var a2 = args[0];
	      var b2 = [];
	      var c2;
	      for (c2 = 1; c2 < args.length; c2 += 1) {
	        b2.push(args[c2]);
	      }
	      b2.forEach(function(d2) {
	        a2 = a2.replace(/%[a-z]/, d2);
	      });
	      return a2;
	    }
	    var PolishedError2 = /* @__PURE__ */ function(_Error) {
	      _inheritsLoose2(PolishedError3, _Error);
	      function PolishedError3(code) {
	        var _this;
	        {
	          for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
	            args[_key2 - 1] = arguments[_key2];
	          }
	          _this = _Error.call(this, format4.apply(void 0, [ERRORS2[code]].concat(args))) || this;
	        }
	        return _assertThisInitialized2(_this);
	      }
	      return PolishedError3;
	    }(/* @__PURE__ */ _wrapNativeSuper2(Error));
	    exports2["default"] = PolishedError2;
	    module2.exports = exports2.default;
	  }
	});

	// ../node_modules/polished/lib/color/parseToRgb.js
	var require_parseToRgb = __commonJS({
	  "../node_modules/polished/lib/color/parseToRgb.js"(exports2, module2) {
	    exports2.__esModule = true;
	    exports2["default"] = parseToRgb2;
	    var _hslToRgb = /* @__PURE__ */ _interopRequireDefault(require_hslToRgb());
	    var _nameToHex = /* @__PURE__ */ _interopRequireDefault(require_nameToHex());
	    var _errors = /* @__PURE__ */ _interopRequireDefault(require_errors());
	    function _interopRequireDefault(obj) {
	      return obj && obj.__esModule ? obj : { "default": obj };
	    }
	    var hexRegex2 = /^#[a-fA-F0-9]{6}$/;
	    var hexRgbaRegex2 = /^#[a-fA-F0-9]{8}$/;
	    var reducedHexRegex2 = /^#[a-fA-F0-9]{3}$/;
	    var reducedRgbaHexRegex2 = /^#[a-fA-F0-9]{4}$/;
	    var rgbRegex2 = /^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/i;
	    var rgbaRegex2 = /^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i;
	    var hslRegex2 = /^hsl\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*\)$/i;
	    var hslaRegex2 = /^hsla\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i;
	    function parseToRgb2(color2) {
	      if (typeof color2 !== "string") {
	        throw new _errors["default"](3);
	      }
	      var normalizedColor = (0, _nameToHex["default"])(color2);
	      if (normalizedColor.match(hexRegex2)) {
	        return {
	          red: parseInt("" + normalizedColor[1] + normalizedColor[2], 16),
	          green: parseInt("" + normalizedColor[3] + normalizedColor[4], 16),
	          blue: parseInt("" + normalizedColor[5] + normalizedColor[6], 16)
	        };
	      }
	      if (normalizedColor.match(hexRgbaRegex2)) {
	        var alpha = parseFloat((parseInt("" + normalizedColor[7] + normalizedColor[8], 16) / 255).toFixed(2));
	        return {
	          red: parseInt("" + normalizedColor[1] + normalizedColor[2], 16),
	          green: parseInt("" + normalizedColor[3] + normalizedColor[4], 16),
	          blue: parseInt("" + normalizedColor[5] + normalizedColor[6], 16),
	          alpha
	        };
	      }
	      if (normalizedColor.match(reducedHexRegex2)) {
	        return {
	          red: parseInt("" + normalizedColor[1] + normalizedColor[1], 16),
	          green: parseInt("" + normalizedColor[2] + normalizedColor[2], 16),
	          blue: parseInt("" + normalizedColor[3] + normalizedColor[3], 16)
	        };
	      }
	      if (normalizedColor.match(reducedRgbaHexRegex2)) {
	        var _alpha = parseFloat((parseInt("" + normalizedColor[4] + normalizedColor[4], 16) / 255).toFixed(2));
	        return {
	          red: parseInt("" + normalizedColor[1] + normalizedColor[1], 16),
	          green: parseInt("" + normalizedColor[2] + normalizedColor[2], 16),
	          blue: parseInt("" + normalizedColor[3] + normalizedColor[3], 16),
	          alpha: _alpha
	        };
	      }
	      var rgbMatched = rgbRegex2.exec(normalizedColor);
	      if (rgbMatched) {
	        return {
	          red: parseInt("" + rgbMatched[1], 10),
	          green: parseInt("" + rgbMatched[2], 10),
	          blue: parseInt("" + rgbMatched[3], 10)
	        };
	      }
	      var rgbaMatched = rgbaRegex2.exec(normalizedColor.substring(0, 50));
	      if (rgbaMatched) {
	        return {
	          red: parseInt("" + rgbaMatched[1], 10),
	          green: parseInt("" + rgbaMatched[2], 10),
	          blue: parseInt("" + rgbaMatched[3], 10),
	          alpha: parseFloat("" + rgbaMatched[4])
	        };
	      }
	      var hslMatched = hslRegex2.exec(normalizedColor);
	      if (hslMatched) {
	        var hue = parseInt("" + hslMatched[1], 10);
	        var saturation = parseInt("" + hslMatched[2], 10) / 100;
	        var lightness = parseInt("" + hslMatched[3], 10) / 100;
	        var rgbColorString = "rgb(" + (0, _hslToRgb["default"])(hue, saturation, lightness) + ")";
	        var hslRgbMatched = rgbRegex2.exec(rgbColorString);
	        if (!hslRgbMatched) {
	          throw new _errors["default"](4, normalizedColor, rgbColorString);
	        }
	        return {
	          red: parseInt("" + hslRgbMatched[1], 10),
	          green: parseInt("" + hslRgbMatched[2], 10),
	          blue: parseInt("" + hslRgbMatched[3], 10)
	        };
	      }
	      var hslaMatched = hslaRegex2.exec(normalizedColor.substring(0, 50));
	      if (hslaMatched) {
	        var _hue = parseInt("" + hslaMatched[1], 10);
	        var _saturation = parseInt("" + hslaMatched[2], 10) / 100;
	        var _lightness = parseInt("" + hslaMatched[3], 10) / 100;
	        var _rgbColorString = "rgb(" + (0, _hslToRgb["default"])(_hue, _saturation, _lightness) + ")";
	        var _hslRgbMatched = rgbRegex2.exec(_rgbColorString);
	        if (!_hslRgbMatched) {
	          throw new _errors["default"](4, normalizedColor, _rgbColorString);
	        }
	        return {
	          red: parseInt("" + _hslRgbMatched[1], 10),
	          green: parseInt("" + _hslRgbMatched[2], 10),
	          blue: parseInt("" + _hslRgbMatched[3], 10),
	          alpha: parseFloat("" + hslaMatched[4])
	        };
	      }
	      throw new _errors["default"](5);
	    }
	    module2.exports = exports2.default;
	  }
	});

	// ../node_modules/polished/lib/internalHelpers/_reduceHexValue.js
	var require_reduceHexValue = __commonJS({
	  "../node_modules/polished/lib/internalHelpers/_reduceHexValue.js"(exports2, module2) {
	    exports2.__esModule = true;
	    exports2["default"] = void 0;
	    var reduceHexValue3 = function reduceHexValue4(value) {
	      if (value.length === 7 && value[1] === value[2] && value[3] === value[4] && value[5] === value[6]) {
	        return "#" + value[1] + value[3] + value[5];
	      }
	      return value;
	    };
	    var _default = reduceHexValue3;
	    exports2["default"] = _default;
	    module2.exports = exports2.default;
	  }
	});

	// ../node_modules/polished/lib/internalHelpers/_numberToHex.js
	var require_numberToHex = __commonJS({
	  "../node_modules/polished/lib/internalHelpers/_numberToHex.js"(exports2, module2) {
	    exports2.__esModule = true;
	    exports2["default"] = void 0;
	    function numberToHex2(value) {
	      var hex = value.toString(16);
	      return hex.length === 1 ? "0" + hex : hex;
	    }
	    var _default = numberToHex2;
	    exports2["default"] = _default;
	    module2.exports = exports2.default;
	  }
	});

	// ../node_modules/polished/lib/color/rgb.js
	var require_rgb = __commonJS({
	  "../node_modules/polished/lib/color/rgb.js"(exports2, module2) {
	    exports2.__esModule = true;
	    exports2["default"] = rgb2;
	    var _reduceHexValue = /* @__PURE__ */ _interopRequireDefault(require_reduceHexValue());
	    var _numberToHex = /* @__PURE__ */ _interopRequireDefault(require_numberToHex());
	    var _errors = /* @__PURE__ */ _interopRequireDefault(require_errors());
	    function _interopRequireDefault(obj) {
	      return obj && obj.__esModule ? obj : { "default": obj };
	    }
	    function rgb2(value, green, blue) {
	      if (typeof value === "number" && typeof green === "number" && typeof blue === "number") {
	        return (0, _reduceHexValue["default"])("#" + (0, _numberToHex["default"])(value) + (0, _numberToHex["default"])(green) + (0, _numberToHex["default"])(blue));
	      } else if (typeof value === "object" && green === void 0 && blue === void 0) {
	        return (0, _reduceHexValue["default"])("#" + (0, _numberToHex["default"])(value.red) + (0, _numberToHex["default"])(value.green) + (0, _numberToHex["default"])(value.blue));
	      }
	      throw new _errors["default"](6);
	    }
	    module2.exports = exports2.default;
	  }
	});

	// ../node_modules/polished/lib/color/rgba.js
	var require_rgba = __commonJS({
	  "../node_modules/polished/lib/color/rgba.js"(exports2, module2) {
	    exports2.__esModule = true;
	    exports2["default"] = rgba2;
	    var _parseToRgb = /* @__PURE__ */ _interopRequireDefault(require_parseToRgb());
	    var _rgb = /* @__PURE__ */ _interopRequireDefault(require_rgb());
	    var _errors = /* @__PURE__ */ _interopRequireDefault(require_errors());
	    function _interopRequireDefault(obj) {
	      return obj && obj.__esModule ? obj : { "default": obj };
	    }
	    function rgba2(firstValue, secondValue, thirdValue, fourthValue) {
	      if (typeof firstValue === "string" && typeof secondValue === "number") {
	        var rgbValue = (0, _parseToRgb["default"])(firstValue);
	        return "rgba(" + rgbValue.red + "," + rgbValue.green + "," + rgbValue.blue + "," + secondValue + ")";
	      } else if (typeof firstValue === "number" && typeof secondValue === "number" && typeof thirdValue === "number" && typeof fourthValue === "number") {
	        return fourthValue >= 1 ? (0, _rgb["default"])(firstValue, secondValue, thirdValue) : "rgba(" + firstValue + "," + secondValue + "," + thirdValue + "," + fourthValue + ")";
	      } else if (typeof firstValue === "object" && secondValue === void 0 && thirdValue === void 0 && fourthValue === void 0) {
	        return firstValue.alpha >= 1 ? (0, _rgb["default"])(firstValue.red, firstValue.green, firstValue.blue) : "rgba(" + firstValue.red + "," + firstValue.green + "," + firstValue.blue + "," + firstValue.alpha + ")";
	      }
	      throw new _errors["default"](7);
	    }
	    module2.exports = exports2.default;
	  }
	});

	// ../node_modules/polished/lib/color/transparentize.js
	var require_transparentize = __commonJS({
	  "../node_modules/polished/lib/color/transparentize.js"(exports2, module2) {
	    exports2.__esModule = true;
	    exports2["default"] = void 0;
	    var _curry = /* @__PURE__ */ _interopRequireDefault(require_curry());
	    var _guard = /* @__PURE__ */ _interopRequireDefault(require_guard());
	    var _rgba = /* @__PURE__ */ _interopRequireDefault(require_rgba());
	    var _parseToRgb = /* @__PURE__ */ _interopRequireDefault(require_parseToRgb());
	    function _interopRequireDefault(obj) {
	      return obj && obj.__esModule ? obj : { "default": obj };
	    }
	    function _extends2() {
	      _extends2 = Object.assign || function(target) {
	        for (var i2 = 1; i2 < arguments.length; i2++) {
	          var source = arguments[i2];
	          for (var key in source) {
	            if (Object.prototype.hasOwnProperty.call(source, key)) {
	              target[key] = source[key];
	            }
	          }
	        }
	        return target;
	      };
	      return _extends2.apply(this, arguments);
	    }
	    function transparentize3(amount, color2) {
	      if (color2 === "transparent")
	        return color2;
	      var parsedColor = (0, _parseToRgb["default"])(color2);
	      var alpha = typeof parsedColor.alpha === "number" ? parsedColor.alpha : 1;
	      var colorWithAlpha = _extends2({}, parsedColor, {
	        alpha: (0, _guard["default"])(0, 1, +(alpha * 100 - parseFloat(amount) * 100).toFixed(2) / 100)
	      });
	      return (0, _rgba["default"])(colorWithAlpha);
	    }
	    var curriedTransparentize2 = /* @__PURE__ */ (0, _curry["default"])(transparentize3);
	    var _default = curriedTransparentize2;
	    exports2["default"] = _default;
	    module2.exports = exports2.default;
	  }
	});

	// ../node_modules/react-error-boundary/dist/react-error-boundary.umd.js
	var require_react_error_boundary_umd = __commonJS({
	  "../node_modules/react-error-boundary/dist/react-error-boundary.umd.js"(exports2, module2) {
	    (function(global2, factory) {
	      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2, react.exports) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2.ReactErrorBoundary = {}, global2.React));
	    })(exports2, function(exports3, React96) {
	      function _interopNamespace(e) {
	        if (e && e.__esModule)
	          return e;
	        var n2 = Object.create(null);
	        if (e) {
	          Object.keys(e).forEach(function(k2) {
	            if (k2 !== "default") {
	              var d2 = Object.getOwnPropertyDescriptor(e, k2);
	              Object.defineProperty(n2, k2, d2.get ? d2 : {
	                enumerable: true,
	                get: function() {
	                  return e[k2];
	                }
	              });
	            }
	          });
	        }
	        n2["default"] = e;
	        return Object.freeze(n2);
	      }
	      var React__namespace = /* @__PURE__ */ _interopNamespace(React96);
	      function _setPrototypeOf2(o2, p2) {
	        _setPrototypeOf2 = Object.setPrototypeOf || function _setPrototypeOf3(o3, p3) {
	          o3.__proto__ = p3;
	          return o3;
	        };
	        return _setPrototypeOf2(o2, p2);
	      }
	      function _inheritsLoose2(subClass, superClass) {
	        subClass.prototype = Object.create(superClass.prototype);
	        subClass.prototype.constructor = subClass;
	        _setPrototypeOf2(subClass, superClass);
	      }
	      var changedArray = function changedArray2(a2, b2) {
	        if (a2 === void 0) {
	          a2 = [];
	        }
	        if (b2 === void 0) {
	          b2 = [];
	        }
	        return a2.length !== b2.length || a2.some(function(item, index) {
	          return !Object.is(item, b2[index]);
	        });
	      };
	      var initialState2 = {
	        error: null
	      };
	      var ErrorBoundary2 = /* @__PURE__ */ function(_React$Component) {
	        _inheritsLoose2(ErrorBoundary3, _React$Component);
	        function ErrorBoundary3() {
	          var _this;
	          for (var _len = arguments.length, _args = new Array(_len), _key = 0; _key < _len; _key++) {
	            _args[_key] = arguments[_key];
	          }
	          _this = _React$Component.call.apply(_React$Component, [this].concat(_args)) || this;
	          _this.state = initialState2;
	          _this.updatedWithError = false;
	          _this.resetErrorBoundary = function() {
	            var _this$props;
	            for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
	              args[_key2] = arguments[_key2];
	            }
	            _this.props.onReset == null ? void 0 : (_this$props = _this.props).onReset.apply(_this$props, args);
	            _this.reset();
	          };
	          return _this;
	        }
	        ErrorBoundary3.getDerivedStateFromError = function getDerivedStateFromError(error) {
	          return {
	            error
	          };
	        };
	        var _proto = ErrorBoundary3.prototype;
	        _proto.reset = function reset() {
	          this.updatedWithError = false;
	          this.setState(initialState2);
	        };
	        _proto.componentDidCatch = function componentDidCatch(error, info) {
	          var _this$props$onError, _this$props2;
	          (_this$props$onError = (_this$props2 = this.props).onError) == null ? void 0 : _this$props$onError.call(_this$props2, error, info);
	        };
	        _proto.componentDidMount = function componentDidMount() {
	          var error = this.state.error;
	          if (error !== null) {
	            this.updatedWithError = true;
	          }
	        };
	        _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
	          var error = this.state.error;
	          var resetKeys = this.props.resetKeys;
	          if (error !== null && !this.updatedWithError) {
	            this.updatedWithError = true;
	            return;
	          }
	          if (error !== null && changedArray(prevProps.resetKeys, resetKeys)) {
	            var _this$props$onResetKe, _this$props3;
	            (_this$props$onResetKe = (_this$props3 = this.props).onResetKeysChange) == null ? void 0 : _this$props$onResetKe.call(_this$props3, prevProps.resetKeys, resetKeys);
	            this.reset();
	          }
	        };
	        _proto.render = function render() {
	          var error = this.state.error;
	          var _this$props4 = this.props, fallbackRender = _this$props4.fallbackRender, FallbackComponent = _this$props4.FallbackComponent, fallback = _this$props4.fallback;
	          if (error !== null) {
	            var _props = {
	              error,
	              resetErrorBoundary: this.resetErrorBoundary
	            };
	            if (/* @__PURE__ */ React__namespace.isValidElement(fallback)) {
	              return fallback;
	            } else if (typeof fallbackRender === "function") {
	              return fallbackRender(_props);
	            } else if (FallbackComponent) {
	              return /* @__PURE__ */ React__namespace.createElement(FallbackComponent, _props);
	            } else {
	              throw new Error("react-error-boundary requires either a fallback, fallbackRender, or FallbackComponent prop");
	            }
	          }
	          return this.props.children;
	        };
	        return ErrorBoundary3;
	      }(React__namespace.Component);
	      function withErrorBoundary(Component, errorBoundaryProps) {
	        var Wrapped = function Wrapped2(props) {
	          return /* @__PURE__ */ React__namespace.createElement(ErrorBoundary2, errorBoundaryProps, /* @__PURE__ */ React__namespace.createElement(Component, props));
	        };
	        var name = Component.displayName || Component.name || "Unknown";
	        Wrapped.displayName = "withErrorBoundary(" + name + ")";
	        return Wrapped;
	      }
	      function useErrorHandler(givenError) {
	        var _React$useState = React__namespace.useState(null), error = _React$useState[0], setError = _React$useState[1];
	        if (givenError != null)
	          throw givenError;
	        if (error != null)
	          throw error;
	        return setError;
	      }
	      exports3.ErrorBoundary = ErrorBoundary2;
	      exports3.useErrorHandler = useErrorHandler;
	      exports3.withErrorBoundary = withErrorBoundary;
	      Object.defineProperty(exports3, "__esModule", { value: true });
	    });
	  }
	});

	// ../node_modules/jiff/lib/lcs.js
	var require_lcs = __commonJS({
	  "../node_modules/jiff/lib/lcs.js"(exports2) {
	    exports2.compare = compare;
	    exports2.reduce = reduce;
	    var RIGHT;
	    var DOWN;
	    var SKIP;
	    exports2.REMOVE = RIGHT = -1;
	    exports2.ADD = DOWN = 1;
	    exports2.EQUAL = SKIP = 0;
	    function compare(a2, b2) {
	      var cols = a2.length;
	      var rows = b2.length;
	      var prefix = findPrefix(a2, b2);
	      var suffix = prefix < cols && prefix < rows ? findSuffix(a2, b2) : 0;
	      var remove = suffix + prefix - 1;
	      cols -= remove;
	      rows -= remove;
	      var matrix = createMatrix(cols, rows);
	      for (var j2 = cols - 1; j2 >= 0; --j2) {
	        for (var i2 = rows - 1; i2 >= 0; --i2) {
	          matrix[i2][j2] = backtrack(matrix, a2, b2, prefix, j2, i2);
	        }
	      }
	      return {
	        prefix,
	        matrix,
	        suffix
	      };
	    }
	    function reduce(f2, r2, lcs) {
	      var i2, j2, k2, op;
	      var m = lcs.matrix;
	      var l2 = lcs.prefix;
	      for (i2 = 0; i2 < l2; ++i2) {
	        r2 = f2(r2, SKIP, i2, i2);
	      }
	      k2 = i2;
	      l2 = m.length;
	      i2 = 0;
	      j2 = 0;
	      while (i2 < l2) {
	        op = m[i2][j2].type;
	        r2 = f2(r2, op, i2 + k2, j2 + k2);
	        switch (op) {
	          case SKIP:
	            ++i2;
	            ++j2;
	            break;
	          case RIGHT:
	            ++j2;
	            break;
	          case DOWN:
	            ++i2;
	            break;
	        }
	      }
	      i2 += k2;
	      j2 += k2;
	      l2 = lcs.suffix;
	      for (k2 = 0; k2 < l2; ++k2) {
	        r2 = f2(r2, SKIP, i2 + k2, j2 + k2);
	      }
	      return r2;
	    }
	    function findPrefix(a2, b2) {
	      var i2 = 0;
	      var l2 = Math.min(a2.length, b2.length);
	      while (i2 < l2 && a2[i2] === b2[i2]) {
	        ++i2;
	      }
	      return i2;
	    }
	    function findSuffix(a2, b2) {
	      var al = a2.length - 1;
	      var bl = b2.length - 1;
	      var l2 = Math.min(al, bl);
	      var i2 = 0;
	      while (i2 < l2 && a2[al - i2] === b2[bl - i2]) {
	        ++i2;
	      }
	      return i2;
	    }
	    function backtrack(matrix, a2, b2, start, j2, i2) {
	      if (a2[j2 + start] === b2[i2 + start]) {
	        return { value: matrix[i2 + 1][j2 + 1].value, type: SKIP };
	      }
	      if (matrix[i2][j2 + 1].value < matrix[i2 + 1][j2].value) {
	        return { value: matrix[i2][j2 + 1].value + 1, type: RIGHT };
	      }
	      return { value: matrix[i2 + 1][j2].value + 1, type: DOWN };
	    }
	    function createMatrix(cols, rows) {
	      var m = [], i2, j2, lastrow;
	      lastrow = m[rows] = [];
	      for (j2 = 0; j2 < cols; ++j2) {
	        lastrow[j2] = { value: cols - j2, type: RIGHT };
	      }
	      for (i2 = 0; i2 < rows; ++i2) {
	        m[i2] = [];
	        m[i2][cols] = { value: rows - i2, type: DOWN };
	      }
	      m[rows][cols] = { value: 0, type: SKIP };
	      return m;
	    }
	  }
	});

	// ../node_modules/jiff/lib/array.js
	var require_array = __commonJS({
	  "../node_modules/jiff/lib/array.js"(exports2) {
	    exports2.cons = cons;
	    exports2.tail = tail;
	    exports2.map = map;
	    function cons(x2, a2) {
	      var l2 = a2.length;
	      var b2 = new Array(l2 + 1);
	      b2[0] = x2;
	      for (var i2 = 0; i2 < l2; ++i2) {
	        b2[i2 + 1] = a2[i2];
	      }
	      return b2;
	    }
	    function tail(a2) {
	      var l2 = a2.length - 1;
	      var b2 = new Array(l2);
	      for (var i2 = 0; i2 < l2; ++i2) {
	        b2[i2] = a2[i2 + 1];
	      }
	      return b2;
	    }
	    function map(f2, a2) {
	      var b2 = new Array(a2.length);
	      for (var i2 = 0; i2 < a2.length; ++i2) {
	        b2[i2] = f2(a2[i2]);
	      }
	      return b2;
	    }
	  }
	});

	// ../node_modules/jiff/lib/jsonPointerParse.js
	var require_jsonPointerParse = __commonJS({
	  "../node_modules/jiff/lib/jsonPointerParse.js"(exports2, module2) {
	    module2.exports = jsonPointerParse;
	    var parseRx = /\/|~1|~0/g;
	    var separator = "/";
	    var escapeChar = "~";
	    var encodedSeparator = "~1";
	    function jsonPointerParse(path, onSegment) {
	      var pos, accum, matches2, match;
	      pos = path.charAt(0) === separator ? 1 : 0;
	      accum = "";
	      parseRx.lastIndex = pos;
	      while (matches2 = parseRx.exec(path)) {
	        match = matches2[0];
	        accum += path.slice(pos, parseRx.lastIndex - match.length);
	        pos = parseRx.lastIndex;
	        if (match === separator) {
	          if (onSegment(accum) === false)
	            return path;
	          accum = "";
	        } else {
	          accum += match === encodedSeparator ? separator : escapeChar;
	        }
	      }
	      accum += path.slice(pos);
	      onSegment(accum);
	      return path;
	    }
	  }
	});

	// ../node_modules/jiff/lib/jsonPointer.js
	var require_jsonPointer = __commonJS({
	  "../node_modules/jiff/lib/jsonPointer.js"(exports2) {
	    var _parse = require_jsonPointerParse();
	    exports2.find = find;
	    exports2.join = join;
	    exports2.absolute = absolute;
	    exports2.parse = parse;
	    exports2.contains = contains2;
	    exports2.encodeSegment = encodeSegment;
	    exports2.decodeSegment = decodeSegment;
	    exports2.parseArrayIndex = parseArrayIndex;
	    exports2.isValidArrayIndex = isValidArrayIndex;
	    var separator = "/";
	    var separatorRx = /\//g;
	    var encodedSeparator = "~1";
	    var encodedSeparatorRx = /~1/g;
	    var escapeChar = "~";
	    var escapeRx = /~/g;
	    var encodedEscape = "~0";
	    var encodedEscapeRx = /~0/g;
	    function find(x2, path, findContext, context3) {
	      if (typeof path !== "string") {
	        return;
	      }
	      if (path === "") {
	        return { target: x2, key: void 0 };
	      }
	      if (path === separator) {
	        return { target: x2, key: "" };
	      }
	      var parent = x2, key;
	      var hasContext = context3 !== void 0;
	      _parse(path, function(segment) {
	        if (x2 == null) {
	          parent = null;
	          return false;
	        }
	        if (Array.isArray(x2)) {
	          key = hasContext ? findIndex2(findContext, parseArrayIndex(segment), x2, context3) : segment === "-" ? segment : parseArrayIndex(segment);
	        } else {
	          key = segment;
	        }
	        parent = x2;
	        x2 = x2[key];
	      });
	      return parent === null ? void 0 : { target: parent, key };
	    }
	    function absolute(path) {
	      return path[0] === separator ? path : separator + path;
	    }
	    function join(segments) {
	      return segments.join(separator);
	    }
	    function parse(path) {
	      var segments = [];
	      _parse(path, segments.push.bind(segments));
	      return segments;
	    }
	    function contains2(a2, b2) {
	      return b2.indexOf(a2) === 0 && b2[a2.length] === separator;
	    }
	    function decodeSegment(s2) {
	      return s2.replace(encodedSeparatorRx, separator).replace(encodedEscapeRx, escapeChar);
	    }
	    function encodeSegment(s2) {
	      return s2.replace(escapeRx, encodedEscape).replace(separatorRx, encodedSeparator);
	    }
	    var arrayIndexRx = /^(0|[1-9]\d*)$/;
	    function isValidArrayIndex(s2) {
	      return arrayIndexRx.test(s2);
	    }
	    function parseArrayIndex(s2) {
	      if (isValidArrayIndex(s2)) {
	        return +s2;
	      }
	      throw new SyntaxError("invalid array index " + s2);
	    }
	    function findIndex2(findContext, start, array, context3) {
	      var index = start;
	      if (index < 0) {
	        throw new Error("array index out of bounds " + index);
	      }
	      if (context3 !== void 0 && typeof findContext === "function") {
	        index = findContext(start, array, context3);
	        if (index < 0) {
	          throw new Error("could not find patch context " + context3);
	        }
	      }
	      return index;
	    }
	  }
	});

	// ../node_modules/jiff/lib/clone.js
	var require_clone = __commonJS({
	  "../node_modules/jiff/lib/clone.js"(exports2, module2) {
	    module2.exports = clone;
	    function clone(x2) {
	      if (x2 == null || typeof x2 !== "object") {
	        return x2;
	      }
	      if (Array.isArray(x2)) {
	        return cloneArray(x2);
	      }
	      return cloneObject(x2);
	    }
	    function cloneArray(x2) {
	      var l2 = x2.length;
	      var y2 = new Array(l2);
	      for (var i2 = 0; i2 < l2; ++i2) {
	        y2[i2] = clone(x2[i2]);
	      }
	      return y2;
	    }
	    function cloneObject(x2) {
	      var keys2 = Object.keys(x2);
	      var y2 = {};
	      for (var k2, i2 = 0, l2 = keys2.length; i2 < l2; ++i2) {
	        k2 = keys2[i2];
	        y2[k2] = clone(x2[k2]);
	      }
	      return y2;
	    }
	  }
	});

	// ../node_modules/jiff/lib/deepEquals.js
	var require_deepEquals = __commonJS({
	  "../node_modules/jiff/lib/deepEquals.js"(exports2, module2) {
	    module2.exports = deepEquals;
	    function deepEquals(a2, b2) {
	      if (a2 === b2) {
	        return true;
	      }
	      if (Array.isArray(a2) && Array.isArray(b2)) {
	        return compareArrays(a2, b2);
	      }
	      if (typeof a2 === "object" && typeof b2 === "object") {
	        return compareObjects(a2, b2);
	      }
	      return false;
	    }
	    function compareArrays(a2, b2) {
	      if (a2.length !== b2.length) {
	        return false;
	      }
	      for (var i2 = 0; i2 < a2.length; ++i2) {
	        if (!deepEquals(a2[i2], b2[i2])) {
	          return false;
	        }
	      }
	      return true;
	    }
	    function compareObjects(a2, b2) {
	      if (a2 === null && b2 !== null || a2 !== null && b2 === null) {
	        return false;
	      }
	      var akeys = Object.keys(a2);
	      var bkeys = Object.keys(b2);
	      if (akeys.length !== bkeys.length) {
	        return false;
	      }
	      for (var i2 = 0, k2; i2 < akeys.length; ++i2) {
	        k2 = akeys[i2];
	        if (!(k2 in b2 && deepEquals(a2[k2], b2[k2]))) {
	          return false;
	        }
	      }
	      return true;
	    }
	  }
	});

	// ../node_modules/jiff/lib/commutePaths.js
	var require_commutePaths = __commonJS({
	  "../node_modules/jiff/lib/commutePaths.js"(exports2, module2) {
	    var jsonPointer = require_jsonPointer();
	    module2.exports = function commutePaths(a2, b2) {
	      var left = jsonPointer.parse(a2.path);
	      var right = jsonPointer.parse(b2.path);
	      var prefix = getCommonPathPrefix(left, right);
	      var isArray2 = isArrayPath(left, right, prefix.length);
	      var ac = copyPatch(a2);
	      var bc = copyPatch(b2);
	      if (prefix.length === 0 && !isArray2) {
	        return [bc, ac];
	      }
	      if (isArray2) {
	        return commuteArrayPaths(ac, left, bc, right);
	      } else {
	        return commuteTreePaths(ac, left, bc);
	      }
	    };
	    function commuteTreePaths(a2, left, b2, right) {
	      if (a2.path === b2.path) {
	        throw new TypeError("cannot commute " + a2.op + "," + b2.op + " with identical object paths");
	      }
	      return [b2, a2];
	    }
	    function commuteArrayPaths(a2, left, b2, right) {
	      if (left.length === right.length) {
	        return commuteArraySiblings(a2, left, b2, right);
	      }
	      if (left.length > right.length) {
	        left = commuteArrayAncestor(b2, right, a2, left, -1);
	        a2.path = jsonPointer.absolute(jsonPointer.join(left));
	      } else {
	        right = commuteArrayAncestor(a2, left, b2, right, 1);
	        b2.path = jsonPointer.absolute(jsonPointer.join(right));
	      }
	      return [b2, a2];
	    }
	    function isArrayPath(left, right, index) {
	      return jsonPointer.isValidArrayIndex(left[index]) && jsonPointer.isValidArrayIndex(right[index]);
	    }
	    function commuteArraySiblings(l2, lpath, r2, rpath) {
	      var target = lpath.length - 1;
	      var lindex = +lpath[target];
	      var rindex = +rpath[target];
	      var commuted;
	      if (lindex < rindex) {
	        if (l2.op === "add" || l2.op === "copy") {
	          commuted = rpath.slice();
	          commuted[target] = Math.max(0, rindex - 1);
	          r2.path = jsonPointer.absolute(jsonPointer.join(commuted));
	        } else if (l2.op === "remove") {
	          commuted = rpath.slice();
	          commuted[target] = rindex + 1;
	          r2.path = jsonPointer.absolute(jsonPointer.join(commuted));
	        }
	      } else if (r2.op === "add" || r2.op === "copy") {
	        commuted = lpath.slice();
	        commuted[target] = lindex + 1;
	        l2.path = jsonPointer.absolute(jsonPointer.join(commuted));
	      } else if (lindex > rindex && r2.op === "remove") {
	        commuted = lpath.slice();
	        commuted[target] = Math.max(0, lindex - 1);
	        l2.path = jsonPointer.absolute(jsonPointer.join(commuted));
	      }
	      return [r2, l2];
	    }
	    function commuteArrayAncestor(l2, lpath, r2, rpath, direction) {
	      var target = lpath.length - 1;
	      var lindex = +lpath[target];
	      var rindex = +rpath[target];
	      var rc = rpath.slice();
	      if (lindex > rindex) {
	        return rc;
	      }
	      if (l2.op === "add" || l2.op === "copy") {
	        rc[target] = Math.max(0, rindex - direction);
	      } else if (l2.op === "remove") {
	        rc[target] = Math.max(0, rindex + direction);
	      }
	      return rc;
	    }
	    function getCommonPathPrefix(p1, p2) {
	      var p1l = p1.length;
	      var p2l = p2.length;
	      if (p1l === 0 || p2l === 0 || p1l < 2 && p2l < 2) {
	        return [];
	      }
	      var l2 = p1l === p2l ? p1l - 1 : Math.min(p1l, p2l);
	      var i2 = 0;
	      while (i2 < l2 && p1[i2] === p2[i2]) {
	        ++i2;
	      }
	      return p1.slice(0, i2);
	    }
	    function copyPatch(p2) {
	      if (p2.op === "remove") {
	        return { op: p2.op, path: p2.path };
	      }
	      if (p2.op === "copy" || p2.op === "move") {
	        return { op: p2.op, path: p2.path, from: p2.from };
	      }
	      return { op: p2.op, path: p2.path, value: p2.value };
	    }
	  }
	});

	// ../node_modules/jiff/lib/TestFailedError.js
	var require_TestFailedError = __commonJS({
	  "../node_modules/jiff/lib/TestFailedError.js"(exports2, module2) {
	    module2.exports = TestFailedError;
	    function TestFailedError(message) {
	      Error.call(this);
	      this.name = this.constructor.name;
	      this.message = message;
	      if (typeof Error.captureStackTrace === "function") {
	        Error.captureStackTrace(this, this.constructor);
	      }
	    }
	    TestFailedError.prototype = Object.create(Error.prototype);
	    TestFailedError.prototype.constructor = TestFailedError;
	  }
	});

	// ../node_modules/jiff/lib/InvalidPatchOperationError.js
	var require_InvalidPatchOperationError = __commonJS({
	  "../node_modules/jiff/lib/InvalidPatchOperationError.js"(exports2, module2) {
	    module2.exports = InvalidPatchOperationError;
	    function InvalidPatchOperationError(message) {
	      Error.call(this);
	      this.name = this.constructor.name;
	      this.message = message;
	      if (typeof Error.captureStackTrace === "function") {
	        Error.captureStackTrace(this, this.constructor);
	      }
	    }
	    InvalidPatchOperationError.prototype = Object.create(Error.prototype);
	    InvalidPatchOperationError.prototype.constructor = InvalidPatchOperationError;
	  }
	});

	// ../node_modules/jiff/lib/PatchNotInvertibleError.js
	var require_PatchNotInvertibleError = __commonJS({
	  "../node_modules/jiff/lib/PatchNotInvertibleError.js"(exports2, module2) {
	    module2.exports = PatchNotInvertibleError;
	    function PatchNotInvertibleError(message) {
	      Error.call(this);
	      this.name = this.constructor.name;
	      this.message = message;
	      if (typeof Error.captureStackTrace === "function") {
	        Error.captureStackTrace(this, this.constructor);
	      }
	    }
	    PatchNotInvertibleError.prototype = Object.create(Error.prototype);
	    PatchNotInvertibleError.prototype.constructor = PatchNotInvertibleError;
	  }
	});

	// ../node_modules/jiff/lib/patches.js
	var require_patches = __commonJS({
	  "../node_modules/jiff/lib/patches.js"(exports2) {
	    var jsonPointer = require_jsonPointer();
	    var clone = require_clone();
	    var deepEquals = require_deepEquals();
	    var commutePaths = require_commutePaths();
	    var array = require_array();
	    var TestFailedError = require_TestFailedError();
	    var InvalidPatchOperationError = require_InvalidPatchOperationError();
	    var PatchNotInvertibleError = require_PatchNotInvertibleError();
	    var find = jsonPointer.find;
	    var parseArrayIndex = jsonPointer.parseArrayIndex;
	    exports2.test = {
	      apply: applyTest,
	      inverse: invertTest,
	      commute: commuteTest
	    };
	    exports2.add = {
	      apply: applyAdd,
	      inverse: invertAdd,
	      commute: commuteAddOrCopy
	    };
	    exports2.remove = {
	      apply: applyRemove,
	      inverse: invertRemove,
	      commute: commuteRemove
	    };
	    exports2.replace = {
	      apply: applyReplace,
	      inverse: invertReplace,
	      commute: commuteReplace
	    };
	    exports2.move = {
	      apply: applyMove,
	      inverse: invertMove,
	      commute: commuteMove
	    };
	    exports2.copy = {
	      apply: applyCopy,
	      inverse: notInvertible,
	      commute: commuteAddOrCopy
	    };
	    function applyTest(x2, test, options) {
	      var pointer2 = find(x2, test.path, options.findContext, test.context);
	      var target = pointer2.target;
	      var index, value;
	      if (Array.isArray(target)) {
	        index = parseArrayIndex(pointer2.key);
	        value = target[index];
	      } else {
	        value = pointer2.key === void 0 ? pointer2.target : pointer2.target[pointer2.key];
	      }
	      if (!deepEquals(value, test.value)) {
	        throw new TestFailedError("test failed " + JSON.stringify(test));
	      }
	      return x2;
	    }
	    function invertTest(pr, test) {
	      pr.push(test);
	      return 1;
	    }
	    function commuteTest(test, b2) {
	      if (test.path === b2.path && b2.op === "remove") {
	        throw new TypeError("Can't commute test,remove -> remove,test for same path");
	      }
	      if (b2.op === "test" || b2.op === "replace") {
	        return [b2, test];
	      }
	      return commutePaths(test, b2);
	    }
	    function applyAdd(x2, change, options) {
	      var pointer2 = find(x2, change.path, options.findContext, change.context);
	      if (notFound(pointer2)) {
	        throw new InvalidPatchOperationError("path does not exist " + change.path);
	      }
	      if (change.value === void 0) {
	        throw new InvalidPatchOperationError("missing value");
	      }
	      var val39 = clone(change.value);
	      if (pointer2.key === void 0) {
	        return val39;
	      }
	      _add(pointer2, val39);
	      return x2;
	    }
	    function _add(pointer2, value) {
	      var target = pointer2.target;
	      if (Array.isArray(target)) {
	        if (pointer2.key === "-") {
	          target.push(value);
	        } else if (pointer2.key > target.length) {
	          throw new InvalidPatchOperationError("target of add outside of array bounds");
	        } else {
	          target.splice(pointer2.key, 0, value);
	        }
	      } else if (isValidObject(target)) {
	        target[pointer2.key] = value;
	      } else {
	        throw new InvalidPatchOperationError("target of add must be an object or array " + pointer2.key);
	      }
	    }
	    function invertAdd(pr, add) {
	      var context3 = add.context;
	      if (context3 !== void 0) {
	        context3 = {
	          before: context3.before,
	          after: array.cons(add.value, context3.after)
	        };
	      }
	      pr.push({ op: "test", path: add.path, value: add.value, context: context3 });
	      pr.push({ op: "remove", path: add.path, context: context3 });
	      return 1;
	    }
	    function commuteAddOrCopy(add, b2) {
	      if (add.path === b2.path && b2.op === "remove") {
	        throw new TypeError("Can't commute add,remove -> remove,add for same path");
	      }
	      return commutePaths(add, b2);
	    }
	    function applyReplace(x2, change, options) {
	      var pointer2 = find(x2, change.path, options.findContext, change.context);
	      if (notFound(pointer2) || missingValue(pointer2)) {
	        throw new InvalidPatchOperationError("path does not exist " + change.path);
	      }
	      if (change.value === void 0) {
	        throw new InvalidPatchOperationError("missing value");
	      }
	      var value = clone(change.value);
	      if (pointer2.key === void 0) {
	        return value;
	      }
	      var target = pointer2.target;
	      if (Array.isArray(target)) {
	        target[parseArrayIndex(pointer2.key)] = value;
	      } else {
	        target[pointer2.key] = value;
	      }
	      return x2;
	    }
	    function invertReplace(pr, c2, i2, patch2) {
	      var prev = patch2[i2 - 1];
	      if (prev === void 0 || prev.op !== "test" || prev.path !== c2.path) {
	        throw new PatchNotInvertibleError("cannot invert replace w/o test");
	      }
	      var context3 = prev.context;
	      if (context3 !== void 0) {
	        context3 = {
	          before: context3.before,
	          after: array.cons(prev.value, array.tail(context3.after))
	        };
	      }
	      pr.push({ op: "test", path: prev.path, value: c2.value });
	      pr.push({ op: "replace", path: prev.path, value: prev.value });
	      return 2;
	    }
	    function commuteReplace(replace, b2) {
	      if (replace.path === b2.path && b2.op === "remove") {
	        throw new TypeError("Can't commute replace,remove -> remove,replace for same path");
	      }
	      if (b2.op === "test" || b2.op === "replace") {
	        return [b2, replace];
	      }
	      return commutePaths(replace, b2);
	    }
	    function applyRemove(x2, change, options) {
	      var pointer2 = find(x2, change.path, options.findContext, change.context);
	      if (notFound(pointer2) || pointer2.target[pointer2.key] === void 0) {
	        throw new InvalidPatchOperationError("path does not exist " + change.path);
	      }
	      _remove(pointer2);
	      return x2;
	    }
	    function _remove(pointer2) {
	      var target = pointer2.target;
	      var removed;
	      if (Array.isArray(target)) {
	        removed = target.splice(parseArrayIndex(pointer2.key), 1);
	        return removed[0];
	      } else if (isValidObject(target)) {
	        removed = target[pointer2.key];
	        delete target[pointer2.key];
	        return removed;
	      } else {
	        throw new InvalidPatchOperationError("target of remove must be an object or array");
	      }
	    }
	    function invertRemove(pr, c2, i2, patch2) {
	      var prev = patch2[i2 - 1];
	      if (prev === void 0 || prev.op !== "test" || prev.path !== c2.path) {
	        throw new PatchNotInvertibleError("cannot invert remove w/o test");
	      }
	      var context3 = prev.context;
	      if (context3 !== void 0) {
	        context3 = {
	          before: context3.before,
	          after: array.tail(context3.after)
	        };
	      }
	      pr.push({ op: "add", path: prev.path, value: prev.value, context: context3 });
	      return 2;
	    }
	    function commuteRemove(remove, b2) {
	      if (remove.path === b2.path && b2.op === "remove") {
	        return [b2, remove];
	      }
	      return commutePaths(remove, b2);
	    }
	    function applyMove(x2, change, options) {
	      if (jsonPointer.contains(change.path, change.from)) {
	        throw new InvalidPatchOperationError("move.from cannot be ancestor of move.path");
	      }
	      var pto = find(x2, change.path, options.findContext, change.context);
	      var pfrom = find(x2, change.from, options.findContext, change.fromContext);
	      _add(pto, _remove(pfrom));
	      return x2;
	    }
	    function invertMove(pr, c2) {
	      pr.push({
	        op: "move",
	        path: c2.from,
	        context: c2.fromContext,
	        from: c2.path,
	        fromContext: c2.context
	      });
	      return 1;
	    }
	    function commuteMove(move, b2) {
	      if (move.path === b2.path && b2.op === "remove") {
	        throw new TypeError("Can't commute move,remove -> move,replace for same path");
	      }
	      return commutePaths(move, b2);
	    }
	    function applyCopy(x2, change, options) {
	      var pto = find(x2, change.path, options.findContext, change.context);
	      var pfrom = find(x2, change.from, options.findContext, change.fromContext);
	      if (notFound(pfrom) || missingValue(pfrom)) {
	        throw new InvalidPatchOperationError("copy.from must exist");
	      }
	      var target = pfrom.target;
	      var value;
	      if (Array.isArray(target)) {
	        value = target[parseArrayIndex(pfrom.key)];
	      } else {
	        value = target[pfrom.key];
	      }
	      _add(pto, clone(value));
	      return x2;
	    }
	    function notInvertible(_2, c2) {
	      throw new PatchNotInvertibleError("cannot invert " + c2.op);
	    }
	    function notFound(pointer2) {
	      return pointer2 === void 0 || pointer2.target == null && pointer2.key !== void 0;
	    }
	    function missingValue(pointer2) {
	      return pointer2.key !== void 0 && pointer2.target[pointer2.key] === void 0;
	    }
	    function isValidObject(x2) {
	      return x2 !== null && typeof x2 === "object";
	    }
	  }
	});

	// ../node_modules/jiff/lib/jsonPatch.js
	var require_jsonPatch = __commonJS({
	  "../node_modules/jiff/lib/jsonPatch.js"(exports2) {
	    var patches = require_patches();
	    var clone = require_clone();
	    var InvalidPatchOperationError = require_InvalidPatchOperationError();
	    exports2.apply = patch2;
	    exports2.applyInPlace = patchInPlace;
	    exports2.clone = clone;
	    exports2.isValidObject = isValidObject;
	    exports2.defaultHash = defaultHash;
	    var defaultOptions = {};
	    function patch2(changes, x2, options) {
	      return patchInPlace(changes, clone(x2), options);
	    }
	    function patchInPlace(changes, x2, options) {
	      if (!options) {
	        options = defaultOptions;
	      }
	      if (!Array.isArray(changes)) {
	        return x2;
	      }
	      var patch3, p2;
	      for (var i2 = 0; i2 < changes.length; ++i2) {
	        p2 = changes[i2];
	        patch3 = patches[p2.op];
	        if (patch3 === void 0) {
	          throw new InvalidPatchOperationError("invalid op " + JSON.stringify(p2));
	        }
	        x2 = patch3.apply(x2, p2, options);
	      }
	      return x2;
	    }
	    function defaultHash(x2) {
	      return isValidObject(x2) || isArray2(x2) ? JSON.stringify(x2) : x2;
	    }
	    function isValidObject(x2) {
	      return x2 !== null && Object.prototype.toString.call(x2) === "[object Object]";
	    }
	    function isArray2(x2) {
	      return Object.prototype.toString.call(x2) === "[object Array]";
	    }
	  }
	});

	// ../node_modules/jiff/lib/inverse.js
	var require_inverse = __commonJS({
	  "../node_modules/jiff/lib/inverse.js"(exports2, module2) {
	    var patches = require_patches();
	    module2.exports = function inverse(p2) {
	      var pr = [];
	      var i2, skip;
	      for (i2 = p2.length - 1; i2 >= 0; i2 -= skip) {
	        skip = invertOp(pr, p2[i2], i2, p2);
	      }
	      return pr;
	    };
	    function invertOp(patch2, c2, i2, context3) {
	      var op = patches[c2.op];
	      return op !== void 0 && typeof op.inverse === "function" ? op.inverse(patch2, c2, i2, context3) : 1;
	    }
	  }
	});

	// ../node_modules/jiff/jiff.js
	var require_jiff = __commonJS({
	  "../node_modules/jiff/jiff.js"(exports2) {
	    var lcs = require_lcs();
	    var array = require_array();
	    var patch2 = require_jsonPatch();
	    var inverse = require_inverse();
	    var jsonPointer = require_jsonPointer();
	    var encodeSegment = jsonPointer.encodeSegment;
	    exports2.diff = diff;
	    exports2.patch = patch2.apply;
	    exports2.patchInPlace = patch2.applyInPlace;
	    exports2.inverse = inverse;
	    exports2.clone = patch2.clone;
	    exports2.InvalidPatchOperationError = require_InvalidPatchOperationError();
	    exports2.TestFailedError = require_TestFailedError();
	    exports2.PatchNotInvertibleError = require_PatchNotInvertibleError();
	    var isValidObject = patch2.isValidObject;
	    var defaultHash = patch2.defaultHash;
	    function diff(a2, b2, options) {
	      return appendChanges(a2, b2, "", initState(options, [])).patch;
	    }
	    function initState(options, patch3) {
	      if (typeof options === "object") {
	        return {
	          patch: patch3,
	          hash: orElse(isFunction2, options.hash, defaultHash),
	          makeContext: orElse(isFunction2, options.makeContext, defaultContext),
	          invertible: !(options.invertible === false)
	        };
	      } else {
	        return {
	          patch: patch3,
	          hash: orElse(isFunction2, options, defaultHash),
	          makeContext: defaultContext,
	          invertible: true
	        };
	      }
	    }
	    function appendChanges(a2, b2, path, state) {
	      if (Array.isArray(a2) && Array.isArray(b2)) {
	        return appendArrayChanges(a2, b2, path, state);
	      }
	      if (isValidObject(a2) && isValidObject(b2)) {
	        return appendObjectChanges(a2, b2, path, state);
	      }
	      return appendValueChanges(a2, b2, path, state);
	    }
	    function appendObjectChanges(o1, o2, path, state) {
	      var keys2 = Object.keys(o2);
	      var patch3 = state.patch;
	      var i2, key;
	      for (i2 = keys2.length - 1; i2 >= 0; --i2) {
	        key = keys2[i2];
	        var keyPath = path + "/" + encodeSegment(key);
	        if (o1[key] !== void 0) {
	          appendChanges(o1[key], o2[key], keyPath, state);
	        } else {
	          patch3.push({ op: "add", path: keyPath, value: o2[key] });
	        }
	      }
	      keys2 = Object.keys(o1);
	      for (i2 = keys2.length - 1; i2 >= 0; --i2) {
	        key = keys2[i2];
	        if (o2[key] === void 0) {
	          var p2 = path + "/" + encodeSegment(key);
	          if (state.invertible) {
	            patch3.push({ op: "test", path: p2, value: o1[key] });
	          }
	          patch3.push({ op: "remove", path: p2 });
	        }
	      }
	      return state;
	    }
	    function appendArrayChanges(a1, a2, path, state) {
	      var a1hash = array.map(state.hash, a1);
	      var a2hash = array.map(state.hash, a2);
	      var lcsMatrix = lcs.compare(a1hash, a2hash);
	      return lcsToJsonPatch(a1, a2, path, state, lcsMatrix);
	    }
	    function lcsToJsonPatch(a1, a2, path, state, lcsMatrix) {
	      var offset = 0;
	      return lcs.reduce(function(state2, op, i2, j2) {
	        var last2, context3;
	        var patch3 = state2.patch;
	        var p2 = path + "/" + (j2 + offset);
	        if (op === lcs.REMOVE) {
	          last2 = patch3[patch3.length - 1];
	          context3 = state2.makeContext(j2, a1);
	          if (state2.invertible) {
	            patch3.push({ op: "test", path: p2, value: a1[j2], context: context3 });
	          }
	          if (last2 !== void 0 && last2.op === "add" && last2.path === p2) {
	            last2.op = "replace";
	            last2.context = context3;
	          } else {
	            patch3.push({ op: "remove", path: p2, context: context3 });
	          }
	          offset -= 1;
	        } else if (op === lcs.ADD) {
	          patch3.push({
	            op: "add",
	            path: p2,
	            value: a2[i2],
	            context: state2.makeContext(j2, a1)
	          });
	          offset += 1;
	        } else {
	          appendChanges(a1[j2], a2[i2], p2, state2);
	        }
	        return state2;
	      }, state, lcsMatrix);
	    }
	    function appendValueChanges(a2, b2, path, state) {
	      if (a2 !== b2) {
	        if (state.invertible) {
	          state.patch.push({ op: "test", path, value: a2 });
	        }
	        state.patch.push({ op: "replace", path, value: b2 });
	      }
	      return state;
	    }
	    function orElse(predicate, x2, y2) {
	      return predicate(x2) ? x2 : y2;
	    }
	    function defaultContext() {
	      return void 0;
	    }
	    function isFunction2(x2) {
	      return typeof x2 === "function";
	    }
	  }
	});

	// ../node_modules/json-touch-patch/lib/utils/pluck.js
	var require_pluck = __commonJS({
	  "../node_modules/json-touch-patch/lib/utils/pluck.js"(exports2, module2) {
	    function pluck(object, keys2) {
	      for (var i2 = 0, imax = keys2.length - 1; i2 < imax; i2++) {
	        if (!object[keys2[i2]]) {
	          return null;
	        }
	        object = object[keys2[i2]];
	      }
	      return object;
	    }
	    module2.exports = pluck;
	  }
	});

	// ../node_modules/json-touch-patch/lib/utils/toKeys.js
	var require_toKeys = __commonJS({
	  "../node_modules/json-touch-patch/lib/utils/toKeys.js"(exports2, module2) {
	    function esc(m) {
	      return m === "~0" ? "~" : "/";
	    }
	    function toKeys(path) {
	      var keys2 = path.split("/");
	      if (path.indexOf("~") === -1) {
	        return keys2;
	      }
	      for (var i2 = 0, imax = keys2.length; i2 < imax; i2++) {
	        if (keys2[i2].indexOf("~") !== -1) {
	          keys2[i2] = keys2[i2].replace(/~[01]/g, esc);
	        }
	      }
	      return keys2;
	    }
	    module2.exports = toKeys;
	  }
	});

	// ../node_modules/json-touch-patch/lib/get.js
	var require_get = __commonJS({
	  "../node_modules/json-touch-patch/lib/get.js"(exports2, module2) {
	    var pluck = require_pluck();
	    var toKeys = require_toKeys();
	    function get2(object, path) {
	      var keys2 = toKeys(path);
	      var lastKey = keys2[keys2.length - 1];
	      var target = pluck(object, keys2);
	      return target ? target[lastKey] : void 0;
	    }
	    module2.exports = get2;
	  }
	});

	// ../node_modules/json-touch-patch/lib/utils/deepEqual.js
	var require_deepEqual = __commonJS({
	  "../node_modules/json-touch-patch/lib/utils/deepEqual.js"(exports2, module2) {
	    function deepEqual(a2, b2) {
	      if (a2 === b2) {
	        return true;
	      }
	      if (!(a2 && b2) || typeof a2 !== "object" || typeof b2 !== "object") {
	        return false;
	      }
	      if (a2.length !== b2.length) {
	        return false;
	      }
	      if (Array.isArray(a2)) {
	        if (!Array.isArray(b2)) {
	          return false;
	        }
	        for (var i2 = 0, imax = a2.length; i2 < imax; i2++) {
	          if (!deepEqual(a2[i2], b2[i2])) {
	            return false;
	          }
	        }
	        return true;
	      }
	      var aKeys = Object.keys(a2);
	      if (aKeys.length !== Object.keys(b2).length) {
	        return false;
	      }
	      for (var j2 = 0, jmax = aKeys.length; j2 < jmax; j2++) {
	        var key = aKeys[j2];
	        if (!deepEqual(a2[key], b2[key])) {
	          return false;
	        }
	      }
	      return true;
	    }
	    module2.exports = deepEqual;
	  }
	});

	// ../node_modules/json-touch-patch/lib/utils/toArrayIndex.js
	var require_toArrayIndex = __commonJS({
	  "../node_modules/json-touch-patch/lib/utils/toArrayIndex.js"(exports2, module2) {
	    function toArrayIndex(array, str) {
	      if (str === "-") {
	        return array.length;
	      }
	      for (var i2 = 0, imax = str.length; i2 < imax; i2++) {
	        var ch = str.charCodeAt(i2);
	        if (57 < ch || ch < 48) {
	          return Infinity;
	        }
	      }
	      return +str;
	    }
	    module2.exports = toArrayIndex;
	  }
	});

	// ../node_modules/json-touch-patch/lib/add.js
	var require_add = __commonJS({
	  "../node_modules/json-touch-patch/lib/add.js"(exports2, module2) {
	    var deepEqual = require_deepEqual();
	    var pluck = require_pluck();
	    var toArrayIndex = require_toArrayIndex();
	    var toKeys = require_toKeys();
	    function add(object, path, value, pluckWithShallowCopy) {
	      if (typeof value === "undefined") {
	        return "[op:add] require value, but got undefined";
	      }
	      var keys2 = toKeys(path);
	      var lastKey = keys2[keys2.length - 1];
	      var target = pluck(object, keys2);
	      if (target === null) {
	        return "[op:add] path not found: " + path;
	      }
	      if (Array.isArray(target)) {
	        var index = toArrayIndex(target, lastKey);
	        if (target.length < index) {
	          return "[op:add] invalid array index: " + path;
	        }
	        pluckWithShallowCopy(object, keys2).splice(index, 0, value);
	      } else {
	        if (!deepEqual(target[lastKey], value)) {
	          pluckWithShallowCopy(object, keys2)[lastKey] = value;
	        }
	      }
	    }
	    module2.exports = add;
	  }
	});

	// ../node_modules/json-touch-patch/lib/remove.js
	var require_remove = __commonJS({
	  "../node_modules/json-touch-patch/lib/remove.js"(exports2, module2) {
	    var pluck = require_pluck();
	    var toArrayIndex = require_toArrayIndex();
	    var toKeys = require_toKeys();
	    function remove(object, path, pluckWithShallowCopy) {
	      var keys2 = toKeys(path);
	      var lastKey = keys2[keys2.length - 1];
	      var target = pluck(object, keys2);
	      if (target === null) {
	        return "[op:remove] path not found: " + path;
	      }
	      if (Array.isArray(target)) {
	        var index = toArrayIndex(target, lastKey);
	        if (target.length <= index) {
	          return "[op:remove] invalid array index: " + path;
	        }
	        pluckWithShallowCopy(object, keys2).splice(index, 1);
	      } else {
	        delete pluckWithShallowCopy(object, keys2)[lastKey];
	      }
	    }
	    module2.exports = remove;
	  }
	});

	// ../node_modules/json-touch-patch/lib/replace.js
	var require_replace = __commonJS({
	  "../node_modules/json-touch-patch/lib/replace.js"(exports2, module2) {
	    var deepEqual = require_deepEqual();
	    var pluck = require_pluck();
	    var toArrayIndex = require_toArrayIndex();
	    var toKeys = require_toKeys();
	    function replace(object, path, value, pluckWithShallowCopy) {
	      if (typeof value === "undefined") {
	        return "[op:replace] require value, but got undefined";
	      }
	      var keys2 = toKeys(path);
	      var lastKey = keys2[keys2.length - 1];
	      var target = pluck(object, keys2);
	      if (target === null) {
	        return "[op:replace] path not found: " + path;
	      }
	      if (Array.isArray(target)) {
	        var index = toArrayIndex(target, lastKey);
	        if (target.length <= index) {
	          return "[op:replace] invalid array index: " + path;
	        }
	        if (!deepEqual(target[index], value)) {
	          pluckWithShallowCopy(object, keys2).splice(index, 1, value);
	        }
	      } else {
	        if (!deepEqual(target[lastKey], value)) {
	          pluckWithShallowCopy(object, keys2)[lastKey] = value;
	        }
	      }
	    }
	    module2.exports = replace;
	  }
	});

	// ../node_modules/json-touch-patch/lib/move.js
	var require_move = __commonJS({
	  "../node_modules/json-touch-patch/lib/move.js"(exports2, module2) {
	    var add = require_add();
	    var pluck = require_pluck();
	    var toArrayIndex = require_toArrayIndex();
	    var toKeys = require_toKeys();
	    function move(object, from, path, pluckWithShallowCopy) {
	      if (path !== from) {
	        var keys2 = toKeys(from);
	        var lastKey = keys2[keys2.length - 1];
	        var target = pluck(object, keys2);
	        if (target === null) {
	          return "[op:move] path not found: " + from;
	        }
	        var value = void 0;
	        if (Array.isArray(target)) {
	          var index = toArrayIndex(target, lastKey);
	          if (target.length <= index) {
	            return "[op:move] invalid array index: " + path;
	          }
	          value = target[index];
	          pluckWithShallowCopy(object, keys2).splice(index, 1);
	        } else {
	          value = target[lastKey];
	          delete pluckWithShallowCopy(object, keys2)[lastKey];
	        }
	        return add(object, path, value, pluckWithShallowCopy);
	      }
	    }
	    module2.exports = move;
	  }
	});

	// ../node_modules/json-touch-patch/lib/copy.js
	var require_copy = __commonJS({
	  "../node_modules/json-touch-patch/lib/copy.js"(exports2, module2) {
	    var pluck = require_pluck();
	    var toKeys = require_toKeys();
	    var add = require_add();
	    function copy(object, from, path, pluckWithShallowCopy) {
	      var keys2 = toKeys(from);
	      var lastKey = keys2[keys2.length - 1];
	      var target = pluck(object, keys2);
	      if (target === null) {
	        return "[op:copy] path not found: " + from;
	      }
	      return add(object, path, target[lastKey], pluckWithShallowCopy);
	    }
	    module2.exports = copy;
	  }
	});

	// ../node_modules/json-touch-patch/lib/test.js
	var require_test = __commonJS({
	  "../node_modules/json-touch-patch/lib/test.js"(exports2, module2) {
	    var deepEqual = require_deepEqual();
	    var pluck = require_pluck();
	    var toKeys = require_toKeys();
	    function test(object, path, expected) {
	      var keys2 = toKeys(path);
	      var lastKey = keys2[keys2.length - 1];
	      var target = pluck(object, keys2);
	      if (target === null) {
	        return "[op:test] path not found: " + path;
	      }
	      if (!deepEqual(target[lastKey], expected)) {
	        var a2 = JSON.stringify(target[lastKey]);
	        var b2 = JSON.stringify(expected);
	        return "[op:test] not matched: " + a2 + " " + b2;
	      }
	    }
	    module2.exports = test;
	  }
	});

	// ../node_modules/json-touch-patch/lib/utils/shallowCopy.js
	var require_shallowCopy = __commonJS({
	  "../node_modules/json-touch-patch/lib/utils/shallowCopy.js"(exports2, module2) {
	    function shallowCopy(obj) {
	      if (!obj || typeof obj !== "object") {
	        return obj;
	      }
	      if (Array.isArray(obj)) {
	        var len = obj.length;
	        var ary = new Array(len);
	        for (var i2 = 0; i2 < len; i2++) {
	          ary[i2] = obj[i2];
	        }
	        return ary;
	      }
	      var keys2 = Object.keys(obj);
	      var copy = {};
	      for (var j2 = 0, jmax = keys2.length; j2 < jmax; j2++) {
	        var key = keys2[j2];
	        copy[key] = obj[key];
	      }
	      return copy;
	    }
	    module2.exports = shallowCopy;
	  }
	});

	// ../node_modules/json-touch-patch/lib/utils/createAPI.js
	var require_createAPI = __commonJS({
	  "../node_modules/json-touch-patch/lib/utils/createAPI.js"(exports2, module2) {
	    var get2 = require_get();
	    var add = require_add();
	    var remove = require_remove();
	    var replace = require_replace();
	    var move = require_move();
	    var copy = require_copy();
	    var test = require_test();
	    var deepEqual = require_deepEqual();
	    var shallowCopy = require_shallowCopy();
	    var toKeys = require_toKeys();
	    function createAPI(root3, pluckFn) {
	      return {
	        get: function(path) {
	          return get2(root3, path);
	        },
	        add: function(path, value) {
	          return add(root3, path, value, pluckFn);
	        },
	        remove: function(path) {
	          return remove(root3, path, pluckFn);
	        },
	        replace: function(path, value) {
	          return replace(root3, path, value, pluckFn);
	        },
	        move: function(from, path) {
	          return move(root3, from, path, pluckFn);
	        },
	        copy: function(from, path) {
	          return copy(root3, from, path, pluckFn);
	        },
	        test: function(path, expected) {
	          return test(root3, path, expected);
	        },
	        deepEqual,
	        shallowCopy,
	        toKeys
	      };
	    }
	    module2.exports = createAPI;
	  }
	});

	// ../node_modules/json-touch-patch/lib/utils/exit.js
	var require_exit = __commonJS({
	  "../node_modules/json-touch-patch/lib/utils/exit.js"(exports2, module2) {
	    function exit(object, root3, patch2, opts) {
	      opts.error = patch2;
	      return opts.partial ? root3[""] : object;
	    }
	    module2.exports = exit;
	  }
	});

	// ../node_modules/json-touch-patch/lib/utils/toBoolean.js
	var require_toBoolean = __commonJS({
	  "../node_modules/json-touch-patch/lib/utils/toBoolean.js"(exports2, module2) {
	    function toBoolean(value) {
	      return !!value;
	    }
	    module2.exports = toBoolean;
	  }
	});

	// ../node_modules/json-touch-patch/lib/utils/throwException.js
	var require_throwException = __commonJS({
	  "../node_modules/json-touch-patch/lib/utils/throwException.js"(exports2, module2) {
	    function throwException(message) {
	      if (message) {
	        throw new TypeError(message);
	      }
	    }
	    module2.exports = throwException;
	  }
	});

	// ../node_modules/json-touch-patch/lib/utils/pluckWithShallowCopy.js
	var require_pluckWithShallowCopy = __commonJS({
	  "../node_modules/json-touch-patch/lib/utils/pluckWithShallowCopy.js"(exports2, module2) {
	    var shallowCopy = require_shallowCopy();
	    function pluckWithShallowCopy(object, keys2) {
	      for (var i2 = 0, imax = keys2.length - 1; i2 < imax; i2++) {
	        object = object[keys2[i2]] = shallowCopy(object[keys2[i2]]);
	      }
	      return object;
	    }
	    module2.exports = pluckWithShallowCopy;
	  }
	});

	// ../node_modules/json-touch-patch/lib/utils/pluckWithCachedShallowCopy.js
	var require_pluckWithCachedShallowCopy = __commonJS({
	  "../node_modules/json-touch-patch/lib/utils/pluckWithCachedShallowCopy.js"(exports2, module2) {
	    var shallowCopy = require_shallowCopy();
	    function fetch(object, key, cache) {
	      var value = object[key];
	      if (!cache.has(value)) {
	        value = shallowCopy(value);
	        cache.add(value);
	      }
	      return value;
	    }
	    function pluckWithCachedShallowCopy(object, keys2, cache) {
	      for (var i2 = 0, imax = keys2.length - 1; i2 < imax; i2++) {
	        object = object[keys2[i2]] = fetch(object, keys2[i2], cache);
	      }
	      return object;
	    }
	    module2.exports = pluckWithCachedShallowCopy;
	  }
	});

	// ../node_modules/json-touch-patch/lib/patch.js
	var require_patch = __commonJS({
	  "../node_modules/json-touch-patch/lib/patch.js"(exports2, module2) {
	    var createAPI = require_createAPI();
	    var exit = require_exit();
	    var toBoolean = require_toBoolean();
	    var throwException = require_throwException();
	    var pluckWithShallowCopy = require_pluckWithShallowCopy();
	    var pluckWithCachedShallowCopy = require_pluckWithCachedShallowCopy();
	    var add = require_add();
	    var remove = require_remove();
	    var replace = require_replace();
	    var move = require_move();
	    var copy = require_copy();
	    var test = require_test();
	    var Cache = window.Set || function() {
	      var set2 = [];
	      set2.has = function(value) {
	        return this.indexOf(value) !== -1;
	      };
	      set2.add = function(value) {
	        this.push(value);
	      };
	      return set2;
	    };
	    function patchFn(object, patches, opts) {
	      if (patches.length === 0) {
	        return object;
	      }
	      opts = opts || {};
	      var hasError = opts.strict ? throwException : toBoolean;
	      var pluckFn = patches.length === 1 ? pluckWithShallowCopy : function(cache) {
	        return function(object2, keys2) {
	          return pluckWithCachedShallowCopy(object2, keys2, cache);
	        };
	      }(new Cache());
	      var root3 = { "": object };
	      var api;
	      for (var i2 = 0, imax = patches.length; i2 < imax; i2++) {
	        var patch2 = patches[i2];
	        switch (patch2.op) {
	          case "add":
	            if (hasError(add(root3, "" + patch2.path, patch2.value, pluckFn))) {
	              return exit(object, root3, patch2, opts);
	            }
	            break;
	          case "remove":
	            if (hasError(remove(root3, "" + patch2.path, pluckFn))) {
	              return exit(object, root3, patch2, opts);
	            }
	            break;
	          case "replace":
	            if (hasError(replace(root3, "" + patch2.path, patch2.value, pluckFn))) {
	              return exit(object, root3, patch2, opts);
	            }
	            break;
	          case "move":
	            if (hasError(move(root3, "" + patch2.from, "" + patch2.path, pluckFn))) {
	              return exit(object, root3, patch2, opts);
	            }
	            break;
	          case "copy":
	            if (hasError(copy(root3, "" + patch2.from, "" + patch2.path, pluckFn))) {
	              return exit(object, root3, patch2, opts);
	            }
	            break;
	          case "test":
	            if (hasError(test(root3, "" + patch2.path, patch2.value))) {
	              return exit(object, root3, patch2, opts);
	            }
	            break;
	          default:
	            if (opts.custom && opts.custom[patch2.op]) {
	              api = api || createAPI(root3, pluckFn);
	              if (hasError(opts.custom[patch2.op](api, patch2, i2, patches))) {
	                return exit(object, root3, patch2, opts);
	              }
	            } else {
	              hasError("[op:" + patch2.op + "] unknown");
	              return exit(object, root3, patch2, opts);
	            }
	            break;
	        }
	      }
	      return root3[""];
	    }
	    module2.exports = patchFn;
	  }
	});

	// ../node_modules/json-touch-patch/lib/index.js
	var require_lib = __commonJS({
	  "../node_modules/json-touch-patch/lib/index.js"(exports2, module2) {
	    module2.exports = require_patch();
	  }
	});

	// studio/src/index.ts
	__export(exports, {
	  ToolbarDropdownSelect: () => ToolbarDropdownSelect_default,
	  ToolbarIconButton: () => ToolbarIconButton_default,
	  ToolbarSwitchSelect: () => ToolbarSwitchSelect_default,
	  default: () => src_default
	});

	// studio/src/getStudio.ts
	var studio;
	function setStudio(s2) {
	  studio = s2;
	}
	function getStudio() {
	  return studio;
	}

	// shared/src/utils/forEachDeep.ts
	function forEachDeep(m, fn2, startingPath = []) {
	  if (typeof m === "object" && m) {
	    for (const [key, value] of Object.entries(m)) {
	      forEachDeep(value, fn2, [...startingPath, key]);
	    }
	  } else if (typeof m === "undefined" || m === null) {
	    return;
	  } else {
	    fn2(m, startingPath);
	  }
	}

	// studio/src/Scrub.ts
	var import_dataverse = __toModule(dist$1);

	// shared/src/logger.ts
	var logger = {
	  log: console.log,
	  warn: console.warn,
	  error: console.error,
	  trace: console.trace
	};
	var logger_default = logger;

	// shared/src/instanceTypes.ts
	var isProject = typeAsserter("Theatre_Project");
	var isSheet = typeAsserter("Theatre_Sheet");
	var isSheetTemplate = typeAsserter("Theatre_SheetTemplate");
	var isSheetObject = typeAsserter("Theatre_SheetObject");
	var isSheetObjectTemplate = typeAsserter("Theatre_SheetObjectTemplate");
	var isSheetPublicAPI = typeAsserter("Theatre_Sheet_PublicAPI");
	var isSheetObjectPublicAPI = typeAsserter("Theatre_SheetObject_PublicAPI");
	function typeAsserter(t2) {
	  return (v2) => typeof v2 === "object" && !!v2 && v2.type === t2;
	}

	// studio/src/Scrub.ts
	var lastScrubIdAsNumber = 0;
	var Scrub = class {
	  constructor(_studio) {
	    this._studio = _studio;
	    __publicField(this, "_id");
	    __publicField(this, "_state", { type: "Ready" });
	    this._id = String(lastScrubIdAsNumber++);
	  }
	  get status() {
	    return this._state.type;
	  }
	  reset() {
	    const { _state: state } = this;
	    if (state.type === "Ready") {
	      return;
	    } else if (state.type === "Captured") {
	      this._state = { type: "Ready" };
	      state.transaction.discard();
	      state.flagsTransaction.discard();
	    } else if (state.type === "Committed") {
	      throw new Error(`This scrub is already committed and can't be reset.`);
	    } else {
	      throw new Error(`This scrub is already discarded and can't be reset.`);
	    }
	  }
	  commit() {
	    const { _state: state } = this;
	    if (state.type === "Captured") {
	      state.transaction.commit();
	      state.flagsTransaction.discard();
	      this._state = { type: "Committed" };
	    } else if (state.type === "Ready") {
	      logger_default.warn(`Scrub is empty. Nothing to commit.`);
	      return;
	    } else if (state.type === "Committed") {
	      throw new Error(`This scrub is already committed.`);
	    } else {
	      throw new Error(`This scrub is already discarded and can't be comitted.`);
	    }
	  }
	  capture(fn2) {
	    if (this._state.type === "Captured") {
	      this.reset();
	    }
	    if (this._state.type === "Ready") {
	      let errored = true;
	      try {
	        this._state = __spreadValues({ type: "Captured" }, this._capture(fn2));
	        errored = false;
	      } finally {
	        if (errored) {
	          this._state = { type: "Discarded" };
	        }
	      }
	    } else {
	      if (this._state.type === "Committed") {
	        throw new Error(`This scrub is already committed and cannot capture again.If you wish to capture more, you can start a new studio.scrub() or do so before scrub.commit()`);
	      } else {
	        throw new Error(`This scrub is already discarded and cannot capture again.If you wish to capture more, you can start a new studio.scrub() or do so before scrub.discard()`);
	      }
	    }
	  }
	  _capture(fn2) {
	    const sets = [];
	    const transaction = this._studio.tempTransaction((transactionApi) => {
	      let running = true;
	      const api = {
	        set: (pointer2, value) => {
	          if (!running) {
	            throw new Error(`You seem to have called the scrub api after scrub.capture()`);
	          }
	          const { root: root3, path } = (0, import_dataverse.getPointerParts)(pointer2);
	          if (!isSheetObject(root3)) {
	            throw new Error(`We can only scrub props of Sheet Objects for now`);
	          }
	          transactionApi.set(pointer2, value);
	          sets.push(pointer2);
	        }
	      };
	      try {
	        fn2(api);
	      } finally {
	        running = false;
	      }
	    });
	    const flagsTransaction = this._studio.tempTransaction(({ stateEditors: stateEditors2 }) => {
	      sets.forEach((pointer2) => {
	        const { root: root3, path } = (0, import_dataverse.getPointerParts)(pointer2);
	        if (!isSheetObject(root3)) {
	          return;
	        }
	        const defaultValueOfProp = root3.template.getDefaultsAtPointer(pointer2);
	        forEachDeep(defaultValueOfProp, (val39, pathToProp) => {
	          stateEditors2.studio.ephemeral.projects.stateByProjectId.stateBySheetId.stateByObjectKey.propsBeingScrubbed.flag(__spreadProps(__spreadValues({}, root3.address), { pathToProp }));
	        }, path);
	      });
	    });
	    return { transaction, flagsTransaction };
	  }
	  discard() {
	    const { _state: state } = this;
	    if (state.type === "Captured" || state.type === "Ready") {
	      if (state.type === "Captured") {
	        state.transaction.discard();
	        state.flagsTransaction.discard();
	      }
	      this._state = { type: "Discarded" };
	    } else if (state.type === "Committed") {
	      throw new Error(`This scrub is already committed and can't be discarded.`);
	    } else {
	      throw new Error(`This scrub is already discarded`);
	    }
	  }
	};

	// ../packages/react/src/index.ts
	var import_dataverse2 = __toModule(dist$1);
	var import_dataverse3 = __toModule(dist$1);

	// ../node_modules/lodash-es/_freeGlobal.js
	var freeGlobal = typeof window == "object" && window && window.Object === Object && window;
	var freeGlobal_default = freeGlobal;

	// ../node_modules/lodash-es/_root.js
	var freeSelf = typeof self == "object" && self && self.Object === Object && self;
	var root = freeGlobal_default || freeSelf || Function("return this")();
	var root_default = root;

	// ../node_modules/lodash-es/_Symbol.js
	var Symbol2 = root_default.Symbol;
	var Symbol_default = Symbol2;

	// ../node_modules/lodash-es/_getRawTag.js
	var objectProto = Object.prototype;
	var hasOwnProperty = objectProto.hasOwnProperty;
	var nativeObjectToString = objectProto.toString;
	var symToStringTag = Symbol_default ? Symbol_default.toStringTag : void 0;
	function getRawTag(value) {
	  var isOwn = hasOwnProperty.call(value, symToStringTag), tag = value[symToStringTag];
	  try {
	    value[symToStringTag] = void 0;
	    var unmasked = true;
	  } catch (e) {
	  }
	  var result2 = nativeObjectToString.call(value);
	  if (unmasked) {
	    if (isOwn) {
	      value[symToStringTag] = tag;
	    } else {
	      delete value[symToStringTag];
	    }
	  }
	  return result2;
	}
	var getRawTag_default = getRawTag;

	// ../node_modules/lodash-es/_objectToString.js
	var objectProto2 = Object.prototype;
	var nativeObjectToString2 = objectProto2.toString;
	function objectToString(value) {
	  return nativeObjectToString2.call(value);
	}
	var objectToString_default = objectToString;

	// ../node_modules/lodash-es/_baseGetTag.js
	var nullTag = "[object Null]";
	var undefinedTag = "[object Undefined]";
	var symToStringTag2 = Symbol_default ? Symbol_default.toStringTag : void 0;
	function baseGetTag(value) {
	  if (value == null) {
	    return value === void 0 ? undefinedTag : nullTag;
	  }
	  return symToStringTag2 && symToStringTag2 in Object(value) ? getRawTag_default(value) : objectToString_default(value);
	}
	var baseGetTag_default = baseGetTag;

	// ../node_modules/lodash-es/isObjectLike.js
	function isObjectLike(value) {
	  return value != null && typeof value == "object";
	}
	var isObjectLike_default = isObjectLike;

	// ../node_modules/lodash-es/isSymbol.js
	var symbolTag = "[object Symbol]";
	function isSymbol(value) {
	  return typeof value == "symbol" || isObjectLike_default(value) && baseGetTag_default(value) == symbolTag;
	}
	var isSymbol_default = isSymbol;

	// ../node_modules/lodash-es/_arrayMap.js
	function arrayMap(array, iteratee) {
	  var index = -1, length = array == null ? 0 : array.length, result2 = Array(length);
	  while (++index < length) {
	    result2[index] = iteratee(array[index], index, array);
	  }
	  return result2;
	}
	var arrayMap_default = arrayMap;

	// ../node_modules/lodash-es/isArray.js
	var isArray = Array.isArray;
	var isArray_default = isArray;

	// ../node_modules/lodash-es/_baseToString.js
	var INFINITY = 1 / 0;
	var symbolProto = Symbol_default ? Symbol_default.prototype : void 0;
	var symbolToString = symbolProto ? symbolProto.toString : void 0;
	function baseToString(value) {
	  if (typeof value == "string") {
	    return value;
	  }
	  if (isArray_default(value)) {
	    return arrayMap_default(value, baseToString) + "";
	  }
	  if (isSymbol_default(value)) {
	    return symbolToString ? symbolToString.call(value) : "";
	  }
	  var result2 = value + "";
	  return result2 == "0" && 1 / value == -INFINITY ? "-0" : result2;
	}
	var baseToString_default = baseToString;

	// ../node_modules/lodash-es/_trimmedEndIndex.js
	var reWhitespace = /\s/;
	function trimmedEndIndex(string) {
	  var index = string.length;
	  while (index-- && reWhitespace.test(string.charAt(index))) {
	  }
	  return index;
	}
	var trimmedEndIndex_default = trimmedEndIndex;

	// ../node_modules/lodash-es/_baseTrim.js
	var reTrimStart = /^\s+/;
	function baseTrim(string) {
	  return string ? string.slice(0, trimmedEndIndex_default(string) + 1).replace(reTrimStart, "") : string;
	}
	var baseTrim_default = baseTrim;

	// ../node_modules/lodash-es/isObject.js
	function isObject(value) {
	  var type = typeof value;
	  return value != null && (type == "object" || type == "function");
	}
	var isObject_default = isObject;

	// ../node_modules/lodash-es/toNumber.js
	var NAN = 0 / 0;
	var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
	var reIsBinary = /^0b[01]+$/i;
	var reIsOctal = /^0o[0-7]+$/i;
	var freeParseInt = parseInt;
	function toNumber(value) {
	  if (typeof value == "number") {
	    return value;
	  }
	  if (isSymbol_default(value)) {
	    return NAN;
	  }
	  if (isObject_default(value)) {
	    var other = typeof value.valueOf == "function" ? value.valueOf() : value;
	    value = isObject_default(other) ? other + "" : other;
	  }
	  if (typeof value != "string") {
	    return value === 0 ? value : +value;
	  }
	  value = baseTrim_default(value);
	  var isBinary = reIsBinary.test(value);
	  return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
	}
	var toNumber_default = toNumber;

	// ../node_modules/lodash-es/toFinite.js
	var INFINITY2 = 1 / 0;
	var MAX_INTEGER = 17976931348623157e292;
	function toFinite(value) {
	  if (!value) {
	    return value === 0 ? value : 0;
	  }
	  value = toNumber_default(value);
	  if (value === INFINITY2 || value === -INFINITY2) {
	    var sign = value < 0 ? -1 : 1;
	    return sign * MAX_INTEGER;
	  }
	  return value === value ? value : 0;
	}
	var toFinite_default = toFinite;

	// ../node_modules/lodash-es/toInteger.js
	function toInteger(value) {
	  var result2 = toFinite_default(value), remainder = result2 % 1;
	  return result2 === result2 ? remainder ? result2 - remainder : result2 : 0;
	}
	var toInteger_default = toInteger;

	// ../node_modules/lodash-es/identity.js
	function identity(value) {
	  return value;
	}
	var identity_default = identity;

	// ../node_modules/lodash-es/isFunction.js
	var asyncTag = "[object AsyncFunction]";
	var funcTag = "[object Function]";
	var genTag = "[object GeneratorFunction]";
	var proxyTag = "[object Proxy]";
	function isFunction(value) {
	  if (!isObject_default(value)) {
	    return false;
	  }
	  var tag = baseGetTag_default(value);
	  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
	}
	var isFunction_default = isFunction;

	// ../node_modules/lodash-es/_coreJsData.js
	var coreJsData = root_default["__core-js_shared__"];
	var coreJsData_default = coreJsData;

	// ../node_modules/lodash-es/_isMasked.js
	var maskSrcKey = function() {
	  var uid = /[^.]+$/.exec(coreJsData_default && coreJsData_default.keys && coreJsData_default.keys.IE_PROTO || "");
	  return uid ? "Symbol(src)_1." + uid : "";
	}();
	function isMasked(func) {
	  return !!maskSrcKey && maskSrcKey in func;
	}
	var isMasked_default = isMasked;

	// ../node_modules/lodash-es/_toSource.js
	var funcProto = Function.prototype;
	var funcToString = funcProto.toString;
	function toSource(func) {
	  if (func != null) {
	    try {
	      return funcToString.call(func);
	    } catch (e) {
	    }
	    try {
	      return func + "";
	    } catch (e) {
	    }
	  }
	  return "";
	}
	var toSource_default = toSource;

	// ../node_modules/lodash-es/_baseIsNative.js
	var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
	var reIsHostCtor = /^\[object .+?Constructor\]$/;
	var funcProto2 = Function.prototype;
	var objectProto3 = Object.prototype;
	var funcToString2 = funcProto2.toString;
	var hasOwnProperty2 = objectProto3.hasOwnProperty;
	var reIsNative = RegExp("^" + funcToString2.call(hasOwnProperty2).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$");
	function baseIsNative(value) {
	  if (!isObject_default(value) || isMasked_default(value)) {
	    return false;
	  }
	  var pattern = isFunction_default(value) ? reIsNative : reIsHostCtor;
	  return pattern.test(toSource_default(value));
	}
	var baseIsNative_default = baseIsNative;

	// ../node_modules/lodash-es/_getValue.js
	function getValue(object, key) {
	  return object == null ? void 0 : object[key];
	}
	var getValue_default = getValue;

	// ../node_modules/lodash-es/_getNative.js
	function getNative(object, key) {
	  var value = getValue_default(object, key);
	  return baseIsNative_default(value) ? value : void 0;
	}
	var getNative_default = getNative;

	// ../node_modules/lodash-es/_WeakMap.js
	var WeakMap2 = getNative_default(root_default, "WeakMap");
	var WeakMap_default = WeakMap2;

	// ../node_modules/lodash-es/_apply.js
	function apply(func, thisArg, args) {
	  switch (args.length) {
	    case 0:
	      return func.call(thisArg);
	    case 1:
	      return func.call(thisArg, args[0]);
	    case 2:
	      return func.call(thisArg, args[0], args[1]);
	    case 3:
	      return func.call(thisArg, args[0], args[1], args[2]);
	  }
	  return func.apply(thisArg, args);
	}
	var apply_default = apply;

	// ../node_modules/lodash-es/noop.js
	function noop() {
	}
	var noop_default = noop;

	// ../node_modules/lodash-es/_copyArray.js
	function copyArray(source, array) {
	  var index = -1, length = source.length;
	  array || (array = Array(length));
	  while (++index < length) {
	    array[index] = source[index];
	  }
	  return array;
	}
	var copyArray_default = copyArray;

	// ../node_modules/lodash-es/_shortOut.js
	var HOT_COUNT = 800;
	var HOT_SPAN = 16;
	var nativeNow = Date.now;
	function shortOut(func) {
	  var count = 0, lastCalled = 0;
	  return function() {
	    var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
	    lastCalled = stamp;
	    if (remaining > 0) {
	      if (++count >= HOT_COUNT) {
	        return arguments[0];
	      }
	    } else {
	      count = 0;
	    }
	    return func.apply(void 0, arguments);
	  };
	}
	var shortOut_default = shortOut;

	// ../node_modules/lodash-es/constant.js
	function constant(value) {
	  return function() {
	    return value;
	  };
	}
	var constant_default = constant;

	// ../node_modules/lodash-es/_defineProperty.js
	var defineProperty = function() {
	  try {
	    var func = getNative_default(Object, "defineProperty");
	    func({}, "", {});
	    return func;
	  } catch (e) {
	  }
	}();
	var defineProperty_default = defineProperty;

	// ../node_modules/lodash-es/_baseSetToString.js
	var baseSetToString = !defineProperty_default ? identity_default : function(func, string) {
	  return defineProperty_default(func, "toString", {
	    "configurable": true,
	    "enumerable": false,
	    "value": constant_default(string),
	    "writable": true
	  });
	};
	var baseSetToString_default = baseSetToString;

	// ../node_modules/lodash-es/_setToString.js
	var setToString = shortOut_default(baseSetToString_default);
	var setToString_default = setToString;

	// ../node_modules/lodash-es/_baseFindIndex.js
	function baseFindIndex(array, predicate, fromIndex, fromRight) {
	  var length = array.length, index = fromIndex + (fromRight ? 1 : -1);
	  while (fromRight ? index-- : ++index < length) {
	    if (predicate(array[index], index, array)) {
	      return index;
	    }
	  }
	  return -1;
	}
	var baseFindIndex_default = baseFindIndex;

	// ../node_modules/lodash-es/_baseIsNaN.js
	function baseIsNaN(value) {
	  return value !== value;
	}
	var baseIsNaN_default = baseIsNaN;

	// ../node_modules/lodash-es/_strictIndexOf.js
	function strictIndexOf(array, value, fromIndex) {
	  var index = fromIndex - 1, length = array.length;
	  while (++index < length) {
	    if (array[index] === value) {
	      return index;
	    }
	  }
	  return -1;
	}
	var strictIndexOf_default = strictIndexOf;

	// ../node_modules/lodash-es/_baseIndexOf.js
	function baseIndexOf(array, value, fromIndex) {
	  return value === value ? strictIndexOf_default(array, value, fromIndex) : baseFindIndex_default(array, baseIsNaN_default, fromIndex);
	}
	var baseIndexOf_default = baseIndexOf;

	// ../node_modules/lodash-es/_arrayIncludes.js
	function arrayIncludes(array, value) {
	  var length = array == null ? 0 : array.length;
	  return !!length && baseIndexOf_default(array, value, 0) > -1;
	}
	var arrayIncludes_default = arrayIncludes;

	// ../node_modules/lodash-es/_isIndex.js
	var MAX_SAFE_INTEGER = 9007199254740991;
	var reIsUint = /^(?:0|[1-9]\d*)$/;
	function isIndex(value, length) {
	  var type = typeof value;
	  length = length == null ? MAX_SAFE_INTEGER : length;
	  return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
	}
	var isIndex_default = isIndex;

	// ../node_modules/lodash-es/_baseAssignValue.js
	function baseAssignValue(object, key, value) {
	  if (key == "__proto__" && defineProperty_default) {
	    defineProperty_default(object, key, {
	      "configurable": true,
	      "enumerable": true,
	      "value": value,
	      "writable": true
	    });
	  } else {
	    object[key] = value;
	  }
	}
	var baseAssignValue_default = baseAssignValue;

	// ../node_modules/lodash-es/eq.js
	function eq(value, other) {
	  return value === other || value !== value && other !== other;
	}
	var eq_default = eq;

	// ../node_modules/lodash-es/_assignValue.js
	var objectProto4 = Object.prototype;
	var hasOwnProperty3 = objectProto4.hasOwnProperty;
	function assignValue(object, key, value) {
	  var objValue = object[key];
	  if (!(hasOwnProperty3.call(object, key) && eq_default(objValue, value)) || value === void 0 && !(key in object)) {
	    baseAssignValue_default(object, key, value);
	  }
	}
	var assignValue_default = assignValue;

	// ../node_modules/lodash-es/_overRest.js
	var nativeMax = Math.max;
	function overRest(func, start, transform) {
	  start = nativeMax(start === void 0 ? func.length - 1 : start, 0);
	  return function() {
	    var args = arguments, index = -1, length = nativeMax(args.length - start, 0), array = Array(length);
	    while (++index < length) {
	      array[index] = args[start + index];
	    }
	    index = -1;
	    var otherArgs = Array(start + 1);
	    while (++index < start) {
	      otherArgs[index] = args[index];
	    }
	    otherArgs[start] = transform(array);
	    return apply_default(func, this, otherArgs);
	  };
	}
	var overRest_default = overRest;

	// ../node_modules/lodash-es/_baseRest.js
	function baseRest(func, start) {
	  return setToString_default(overRest_default(func, start, identity_default), func + "");
	}
	var baseRest_default = baseRest;

	// ../node_modules/lodash-es/isLength.js
	var MAX_SAFE_INTEGER2 = 9007199254740991;
	function isLength(value) {
	  return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER2;
	}
	var isLength_default = isLength;

	// ../node_modules/lodash-es/isArrayLike.js
	function isArrayLike(value) {
	  return value != null && isLength_default(value.length) && !isFunction_default(value);
	}
	var isArrayLike_default = isArrayLike;

	// ../node_modules/lodash-es/_isIterateeCall.js
	function isIterateeCall(value, index, object) {
	  if (!isObject_default(object)) {
	    return false;
	  }
	  var type = typeof index;
	  if (type == "number" ? isArrayLike_default(object) && isIndex_default(index, object.length) : type == "string" && index in object) {
	    return eq_default(object[index], value);
	  }
	  return false;
	}
	var isIterateeCall_default = isIterateeCall;

	// ../node_modules/lodash-es/_isPrototype.js
	var objectProto5 = Object.prototype;
	function isPrototype(value) {
	  var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto5;
	  return value === proto;
	}
	var isPrototype_default = isPrototype;

	// ../node_modules/lodash-es/_baseTimes.js
	function baseTimes(n2, iteratee) {
	  var index = -1, result2 = Array(n2);
	  while (++index < n2) {
	    result2[index] = iteratee(index);
	  }
	  return result2;
	}
	var baseTimes_default = baseTimes;

	// ../node_modules/lodash-es/_baseIsArguments.js
	var argsTag = "[object Arguments]";
	function baseIsArguments(value) {
	  return isObjectLike_default(value) && baseGetTag_default(value) == argsTag;
	}
	var baseIsArguments_default = baseIsArguments;

	// ../node_modules/lodash-es/isArguments.js
	var objectProto6 = Object.prototype;
	var hasOwnProperty4 = objectProto6.hasOwnProperty;
	var propertyIsEnumerable = objectProto6.propertyIsEnumerable;
	var isArguments = baseIsArguments_default(function() {
	  return arguments;
	}()) ? baseIsArguments_default : function(value) {
	  return isObjectLike_default(value) && hasOwnProperty4.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
	};
	var isArguments_default = isArguments;

	// ../node_modules/lodash-es/stubFalse.js
	function stubFalse() {
	  return false;
	}
	var stubFalse_default = stubFalse;

	// ../node_modules/lodash-es/isBuffer.js
	var freeExports = exports && !exports.nodeType && exports;
	var freeModule = freeExports && 'object' == "object" && module && !module.nodeType && module;
	var moduleExports = freeModule && freeModule.exports === freeExports;
	var Buffer2 = moduleExports ? root_default.Buffer : void 0;
	var nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : void 0;
	var isBuffer = nativeIsBuffer || stubFalse_default;
	var isBuffer_default = isBuffer;

	// ../node_modules/lodash-es/_baseIsTypedArray.js
	var argsTag2 = "[object Arguments]";
	var arrayTag = "[object Array]";
	var boolTag = "[object Boolean]";
	var dateTag = "[object Date]";
	var errorTag = "[object Error]";
	var funcTag2 = "[object Function]";
	var mapTag = "[object Map]";
	var numberTag = "[object Number]";
	var objectTag = "[object Object]";
	var regexpTag = "[object RegExp]";
	var setTag = "[object Set]";
	var stringTag = "[object String]";
	var weakMapTag = "[object WeakMap]";
	var arrayBufferTag = "[object ArrayBuffer]";
	var dataViewTag = "[object DataView]";
	var float32Tag = "[object Float32Array]";
	var float64Tag = "[object Float64Array]";
	var int8Tag = "[object Int8Array]";
	var int16Tag = "[object Int16Array]";
	var int32Tag = "[object Int32Array]";
	var uint8Tag = "[object Uint8Array]";
	var uint8ClampedTag = "[object Uint8ClampedArray]";
	var uint16Tag = "[object Uint16Array]";
	var uint32Tag = "[object Uint32Array]";
	var typedArrayTags = {};
	typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
	typedArrayTags[argsTag2] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag2] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
	function baseIsTypedArray(value) {
	  return isObjectLike_default(value) && isLength_default(value.length) && !!typedArrayTags[baseGetTag_default(value)];
	}
	var baseIsTypedArray_default = baseIsTypedArray;

	// ../node_modules/lodash-es/_baseUnary.js
	function baseUnary(func) {
	  return function(value) {
	    return func(value);
	  };
	}
	var baseUnary_default = baseUnary;

	// ../node_modules/lodash-es/_nodeUtil.js
	var freeExports2 = exports && !exports.nodeType && exports;
	var freeModule2 = freeExports2 && 'object' == "object" && module && !module.nodeType && module;
	var moduleExports2 = freeModule2 && freeModule2.exports === freeExports2;
	var freeProcess = moduleExports2 && freeGlobal_default.process;
	var nodeUtil = function() {
	  try {
	    var types = freeModule2 && freeModule2.require && freeModule2.require("util").types;
	    if (types) {
	      return types;
	    }
	    return freeProcess && freeProcess.binding && freeProcess.binding("util");
	  } catch (e) {
	  }
	}();
	var nodeUtil_default = nodeUtil;

	// ../node_modules/lodash-es/isTypedArray.js
	var nodeIsTypedArray = nodeUtil_default && nodeUtil_default.isTypedArray;
	var isTypedArray = nodeIsTypedArray ? baseUnary_default(nodeIsTypedArray) : baseIsTypedArray_default;
	var isTypedArray_default = isTypedArray;

	// ../node_modules/lodash-es/_arrayLikeKeys.js
	var objectProto7 = Object.prototype;
	var hasOwnProperty5 = objectProto7.hasOwnProperty;
	function arrayLikeKeys(value, inherited) {
	  var isArr = isArray_default(value), isArg = !isArr && isArguments_default(value), isBuff = !isArr && !isArg && isBuffer_default(value), isType = !isArr && !isArg && !isBuff && isTypedArray_default(value), skipIndexes = isArr || isArg || isBuff || isType, result2 = skipIndexes ? baseTimes_default(value.length, String) : [], length = result2.length;
	  for (var key in value) {
	    if ((inherited || hasOwnProperty5.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex_default(key, length)))) {
	      result2.push(key);
	    }
	  }
	  return result2;
	}
	var arrayLikeKeys_default = arrayLikeKeys;

	// ../node_modules/lodash-es/_overArg.js
	function overArg(func, transform) {
	  return function(arg) {
	    return func(transform(arg));
	  };
	}
	var overArg_default = overArg;

	// ../node_modules/lodash-es/_nativeKeys.js
	var nativeKeys = overArg_default(Object.keys, Object);
	var nativeKeys_default = nativeKeys;

	// ../node_modules/lodash-es/_baseKeys.js
	var objectProto8 = Object.prototype;
	var hasOwnProperty6 = objectProto8.hasOwnProperty;
	function baseKeys(object) {
	  if (!isPrototype_default(object)) {
	    return nativeKeys_default(object);
	  }
	  var result2 = [];
	  for (var key in Object(object)) {
	    if (hasOwnProperty6.call(object, key) && key != "constructor") {
	      result2.push(key);
	    }
	  }
	  return result2;
	}
	var baseKeys_default = baseKeys;

	// ../node_modules/lodash-es/keys.js
	function keys(object) {
	  return isArrayLike_default(object) ? arrayLikeKeys_default(object) : baseKeys_default(object);
	}
	var keys_default = keys;

	// ../node_modules/lodash-es/_isKey.js
	var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/;
	var reIsPlainProp = /^\w*$/;
	function isKey(value, object) {
	  if (isArray_default(value)) {
	    return false;
	  }
	  var type = typeof value;
	  if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol_default(value)) {
	    return true;
	  }
	  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object(object);
	}
	var isKey_default = isKey;

	// ../node_modules/lodash-es/_nativeCreate.js
	var nativeCreate = getNative_default(Object, "create");
	var nativeCreate_default = nativeCreate;

	// ../node_modules/lodash-es/_hashClear.js
	function hashClear() {
	  this.__data__ = nativeCreate_default ? nativeCreate_default(null) : {};
	  this.size = 0;
	}
	var hashClear_default = hashClear;

	// ../node_modules/lodash-es/_hashDelete.js
	function hashDelete(key) {
	  var result2 = this.has(key) && delete this.__data__[key];
	  this.size -= result2 ? 1 : 0;
	  return result2;
	}
	var hashDelete_default = hashDelete;

	// ../node_modules/lodash-es/_hashGet.js
	var HASH_UNDEFINED = "__lodash_hash_undefined__";
	var objectProto9 = Object.prototype;
	var hasOwnProperty7 = objectProto9.hasOwnProperty;
	function hashGet(key) {
	  var data = this.__data__;
	  if (nativeCreate_default) {
	    var result2 = data[key];
	    return result2 === HASH_UNDEFINED ? void 0 : result2;
	  }
	  return hasOwnProperty7.call(data, key) ? data[key] : void 0;
	}
	var hashGet_default = hashGet;

	// ../node_modules/lodash-es/_hashHas.js
	var objectProto10 = Object.prototype;
	var hasOwnProperty8 = objectProto10.hasOwnProperty;
	function hashHas(key) {
	  var data = this.__data__;
	  return nativeCreate_default ? data[key] !== void 0 : hasOwnProperty8.call(data, key);
	}
	var hashHas_default = hashHas;

	// ../node_modules/lodash-es/_hashSet.js
	var HASH_UNDEFINED2 = "__lodash_hash_undefined__";
	function hashSet(key, value) {
	  var data = this.__data__;
	  this.size += this.has(key) ? 0 : 1;
	  data[key] = nativeCreate_default && value === void 0 ? HASH_UNDEFINED2 : value;
	  return this;
	}
	var hashSet_default = hashSet;

	// ../node_modules/lodash-es/_Hash.js
	function Hash(entries) {
	  var index = -1, length = entries == null ? 0 : entries.length;
	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}
	Hash.prototype.clear = hashClear_default;
	Hash.prototype["delete"] = hashDelete_default;
	Hash.prototype.get = hashGet_default;
	Hash.prototype.has = hashHas_default;
	Hash.prototype.set = hashSet_default;
	var Hash_default = Hash;

	// ../node_modules/lodash-es/_listCacheClear.js
	function listCacheClear() {
	  this.__data__ = [];
	  this.size = 0;
	}
	var listCacheClear_default = listCacheClear;

	// ../node_modules/lodash-es/_assocIndexOf.js
	function assocIndexOf(array, key) {
	  var length = array.length;
	  while (length--) {
	    if (eq_default(array[length][0], key)) {
	      return length;
	    }
	  }
	  return -1;
	}
	var assocIndexOf_default = assocIndexOf;

	// ../node_modules/lodash-es/_listCacheDelete.js
	var arrayProto = Array.prototype;
	var splice = arrayProto.splice;
	function listCacheDelete(key) {
	  var data = this.__data__, index = assocIndexOf_default(data, key);
	  if (index < 0) {
	    return false;
	  }
	  var lastIndex = data.length - 1;
	  if (index == lastIndex) {
	    data.pop();
	  } else {
	    splice.call(data, index, 1);
	  }
	  --this.size;
	  return true;
	}
	var listCacheDelete_default = listCacheDelete;

	// ../node_modules/lodash-es/_listCacheGet.js
	function listCacheGet(key) {
	  var data = this.__data__, index = assocIndexOf_default(data, key);
	  return index < 0 ? void 0 : data[index][1];
	}
	var listCacheGet_default = listCacheGet;

	// ../node_modules/lodash-es/_listCacheHas.js
	function listCacheHas(key) {
	  return assocIndexOf_default(this.__data__, key) > -1;
	}
	var listCacheHas_default = listCacheHas;

	// ../node_modules/lodash-es/_listCacheSet.js
	function listCacheSet(key, value) {
	  var data = this.__data__, index = assocIndexOf_default(data, key);
	  if (index < 0) {
	    ++this.size;
	    data.push([key, value]);
	  } else {
	    data[index][1] = value;
	  }
	  return this;
	}
	var listCacheSet_default = listCacheSet;

	// ../node_modules/lodash-es/_ListCache.js
	function ListCache(entries) {
	  var index = -1, length = entries == null ? 0 : entries.length;
	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}
	ListCache.prototype.clear = listCacheClear_default;
	ListCache.prototype["delete"] = listCacheDelete_default;
	ListCache.prototype.get = listCacheGet_default;
	ListCache.prototype.has = listCacheHas_default;
	ListCache.prototype.set = listCacheSet_default;
	var ListCache_default = ListCache;

	// ../node_modules/lodash-es/_Map.js
	var Map2 = getNative_default(root_default, "Map");
	var Map_default = Map2;

	// ../node_modules/lodash-es/_mapCacheClear.js
	function mapCacheClear() {
	  this.size = 0;
	  this.__data__ = {
	    "hash": new Hash_default(),
	    "map": new (Map_default || ListCache_default)(),
	    "string": new Hash_default()
	  };
	}
	var mapCacheClear_default = mapCacheClear;

	// ../node_modules/lodash-es/_isKeyable.js
	function isKeyable(value) {
	  var type = typeof value;
	  return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
	}
	var isKeyable_default = isKeyable;

	// ../node_modules/lodash-es/_getMapData.js
	function getMapData(map, key) {
	  var data = map.__data__;
	  return isKeyable_default(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
	}
	var getMapData_default = getMapData;

	// ../node_modules/lodash-es/_mapCacheDelete.js
	function mapCacheDelete(key) {
	  var result2 = getMapData_default(this, key)["delete"](key);
	  this.size -= result2 ? 1 : 0;
	  return result2;
	}
	var mapCacheDelete_default = mapCacheDelete;

	// ../node_modules/lodash-es/_mapCacheGet.js
	function mapCacheGet(key) {
	  return getMapData_default(this, key).get(key);
	}
	var mapCacheGet_default = mapCacheGet;

	// ../node_modules/lodash-es/_mapCacheHas.js
	function mapCacheHas(key) {
	  return getMapData_default(this, key).has(key);
	}
	var mapCacheHas_default = mapCacheHas;

	// ../node_modules/lodash-es/_mapCacheSet.js
	function mapCacheSet(key, value) {
	  var data = getMapData_default(this, key), size = data.size;
	  data.set(key, value);
	  this.size += data.size == size ? 0 : 1;
	  return this;
	}
	var mapCacheSet_default = mapCacheSet;

	// ../node_modules/lodash-es/_MapCache.js
	function MapCache(entries) {
	  var index = -1, length = entries == null ? 0 : entries.length;
	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}
	MapCache.prototype.clear = mapCacheClear_default;
	MapCache.prototype["delete"] = mapCacheDelete_default;
	MapCache.prototype.get = mapCacheGet_default;
	MapCache.prototype.has = mapCacheHas_default;
	MapCache.prototype.set = mapCacheSet_default;
	var MapCache_default = MapCache;

	// ../node_modules/lodash-es/memoize.js
	var FUNC_ERROR_TEXT = "Expected a function";
	function memoize(func, resolver) {
	  if (typeof func != "function" || resolver != null && typeof resolver != "function") {
	    throw new TypeError(FUNC_ERROR_TEXT);
	  }
	  var memoized = function() {
	    var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache = memoized.cache;
	    if (cache.has(key)) {
	      return cache.get(key);
	    }
	    var result2 = func.apply(this, args);
	    memoized.cache = cache.set(key, result2) || cache;
	    return result2;
	  };
	  memoized.cache = new (memoize.Cache || MapCache_default)();
	  return memoized;
	}
	memoize.Cache = MapCache_default;
	var memoize_default = memoize;

	// ../node_modules/lodash-es/_memoizeCapped.js
	var MAX_MEMOIZE_SIZE = 500;
	function memoizeCapped(func) {
	  var result2 = memoize_default(func, function(key) {
	    if (cache.size === MAX_MEMOIZE_SIZE) {
	      cache.clear();
	    }
	    return key;
	  });
	  var cache = result2.cache;
	  return result2;
	}
	var memoizeCapped_default = memoizeCapped;

	// ../node_modules/lodash-es/_stringToPath.js
	var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
	var reEscapeChar = /\\(\\)?/g;
	var stringToPath = memoizeCapped_default(function(string) {
	  var result2 = [];
	  if (string.charCodeAt(0) === 46) {
	    result2.push("");
	  }
	  string.replace(rePropName, function(match, number, quote, subString) {
	    result2.push(quote ? subString.replace(reEscapeChar, "$1") : number || match);
	  });
	  return result2;
	});
	var stringToPath_default = stringToPath;

	// ../node_modules/lodash-es/toString.js
	function toString(value) {
	  return value == null ? "" : baseToString_default(value);
	}
	var toString_default = toString;

	// ../node_modules/lodash-es/_castPath.js
	function castPath(value, object) {
	  if (isArray_default(value)) {
	    return value;
	  }
	  return isKey_default(value, object) ? [value] : stringToPath_default(toString_default(value));
	}
	var castPath_default = castPath;

	// ../node_modules/lodash-es/_toKey.js
	var INFINITY3 = 1 / 0;
	function toKey(value) {
	  if (typeof value == "string" || isSymbol_default(value)) {
	    return value;
	  }
	  var result2 = value + "";
	  return result2 == "0" && 1 / value == -INFINITY3 ? "-0" : result2;
	}
	var toKey_default = toKey;

	// ../node_modules/lodash-es/_baseGet.js
	function baseGet(object, path) {
	  path = castPath_default(path, object);
	  var index = 0, length = path.length;
	  while (object != null && index < length) {
	    object = object[toKey_default(path[index++])];
	  }
	  return index && index == length ? object : void 0;
	}
	var baseGet_default = baseGet;

	// ../node_modules/lodash-es/get.js
	function get(object, path, defaultValue) {
	  var result2 = object == null ? void 0 : baseGet_default(object, path);
	  return result2 === void 0 ? defaultValue : result2;
	}
	var get_default = get;

	// ../node_modules/lodash-es/_arrayPush.js
	function arrayPush(array, values) {
	  var index = -1, length = values.length, offset = array.length;
	  while (++index < length) {
	    array[offset + index] = values[index];
	  }
	  return array;
	}
	var arrayPush_default = arrayPush;

	// ../node_modules/lodash-es/_isFlattenable.js
	var spreadableSymbol = Symbol_default ? Symbol_default.isConcatSpreadable : void 0;
	function isFlattenable(value) {
	  return isArray_default(value) || isArguments_default(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
	}
	var isFlattenable_default = isFlattenable;

	// ../node_modules/lodash-es/_baseFlatten.js
	function baseFlatten(array, depth, predicate, isStrict, result2) {
	  var index = -1, length = array.length;
	  predicate || (predicate = isFlattenable_default);
	  result2 || (result2 = []);
	  while (++index < length) {
	    var value = array[index];
	    if (depth > 0 && predicate(value)) {
	      if (depth > 1) {
	        baseFlatten(value, depth - 1, predicate, isStrict, result2);
	      } else {
	        arrayPush_default(result2, value);
	      }
	    } else if (!isStrict) {
	      result2[result2.length] = value;
	    }
	  }
	  return result2;
	}
	var baseFlatten_default = baseFlatten;

	// ../node_modules/lodash-es/_getPrototype.js
	var getPrototype = overArg_default(Object.getPrototypeOf, Object);
	var getPrototype_default = getPrototype;

	// ../node_modules/lodash-es/isPlainObject.js
	var objectTag2 = "[object Object]";
	var funcProto3 = Function.prototype;
	var objectProto11 = Object.prototype;
	var funcToString3 = funcProto3.toString;
	var hasOwnProperty9 = objectProto11.hasOwnProperty;
	var objectCtorString = funcToString3.call(Object);
	function isPlainObject(value) {
	  if (!isObjectLike_default(value) || baseGetTag_default(value) != objectTag2) {
	    return false;
	  }
	  var proto = getPrototype_default(value);
	  if (proto === null) {
	    return true;
	  }
	  var Ctor = hasOwnProperty9.call(proto, "constructor") && proto.constructor;
	  return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString3.call(Ctor) == objectCtorString;
	}
	var isPlainObject_default = isPlainObject;

	// ../node_modules/lodash-es/_createRound.js
	var nativeIsFinite = root_default.isFinite;
	var nativeMin = Math.min;
	function createRound(methodName) {
	  var func = Math[methodName];
	  return function(number, precision) {
	    number = toNumber_default(number);
	    precision = precision == null ? 0 : nativeMin(toInteger_default(precision), 292);
	    if (precision && nativeIsFinite(number)) {
	      var pair = (toString_default(number) + "e").split("e"), value = func(pair[0] + "e" + (+pair[1] + precision));
	      pair = (toString_default(value) + "e").split("e");
	      return +(pair[0] + "e" + (+pair[1] - precision));
	    }
	    return func(number);
	  };
	}
	var createRound_default = createRound;

	// ../node_modules/lodash-es/_baseClamp.js
	function baseClamp(number, lower, upper) {
	  if (number === number) {
	    if (upper !== void 0) {
	      number = number <= upper ? number : upper;
	    }
	    if (lower !== void 0) {
	      number = number >= lower ? number : lower;
	    }
	  }
	  return number;
	}
	var baseClamp_default = baseClamp;

	// ../node_modules/lodash-es/clamp.js
	function clamp(number, lower, upper) {
	  if (upper === void 0) {
	    upper = lower;
	    lower = void 0;
	  }
	  if (upper !== void 0) {
	    upper = toNumber_default(upper);
	    upper = upper === upper ? upper : 0;
	  }
	  if (lower !== void 0) {
	    lower = toNumber_default(lower);
	    lower = lower === lower ? lower : 0;
	  }
	  return baseClamp_default(toNumber_default(number), lower, upper);
	}
	var clamp_default = clamp;

	// ../node_modules/lodash-es/_stackClear.js
	function stackClear() {
	  this.__data__ = new ListCache_default();
	  this.size = 0;
	}
	var stackClear_default = stackClear;

	// ../node_modules/lodash-es/_stackDelete.js
	function stackDelete(key) {
	  var data = this.__data__, result2 = data["delete"](key);
	  this.size = data.size;
	  return result2;
	}
	var stackDelete_default = stackDelete;

	// ../node_modules/lodash-es/_stackGet.js
	function stackGet(key) {
	  return this.__data__.get(key);
	}
	var stackGet_default = stackGet;

	// ../node_modules/lodash-es/_stackHas.js
	function stackHas(key) {
	  return this.__data__.has(key);
	}
	var stackHas_default = stackHas;

	// ../node_modules/lodash-es/_stackSet.js
	var LARGE_ARRAY_SIZE = 200;
	function stackSet(key, value) {
	  var data = this.__data__;
	  if (data instanceof ListCache_default) {
	    var pairs = data.__data__;
	    if (!Map_default || pairs.length < LARGE_ARRAY_SIZE - 1) {
	      pairs.push([key, value]);
	      this.size = ++data.size;
	      return this;
	    }
	    data = this.__data__ = new MapCache_default(pairs);
	  }
	  data.set(key, value);
	  this.size = data.size;
	  return this;
	}
	var stackSet_default = stackSet;

	// ../node_modules/lodash-es/_Stack.js
	function Stack(entries) {
	  var data = this.__data__ = new ListCache_default(entries);
	  this.size = data.size;
	}
	Stack.prototype.clear = stackClear_default;
	Stack.prototype["delete"] = stackDelete_default;
	Stack.prototype.get = stackGet_default;
	Stack.prototype.has = stackHas_default;
	Stack.prototype.set = stackSet_default;
	var Stack_default = Stack;

	// ../node_modules/lodash-es/_arrayFilter.js
	function arrayFilter(array, predicate) {
	  var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result2 = [];
	  while (++index < length) {
	    var value = array[index];
	    if (predicate(value, index, array)) {
	      result2[resIndex++] = value;
	    }
	  }
	  return result2;
	}
	var arrayFilter_default = arrayFilter;

	// ../node_modules/lodash-es/stubArray.js
	function stubArray() {
	  return [];
	}
	var stubArray_default = stubArray;

	// ../node_modules/lodash-es/_getSymbols.js
	var objectProto12 = Object.prototype;
	var propertyIsEnumerable2 = objectProto12.propertyIsEnumerable;
	var nativeGetSymbols = Object.getOwnPropertySymbols;
	var getSymbols = !nativeGetSymbols ? stubArray_default : function(object) {
	  if (object == null) {
	    return [];
	  }
	  object = Object(object);
	  return arrayFilter_default(nativeGetSymbols(object), function(symbol) {
	    return propertyIsEnumerable2.call(object, symbol);
	  });
	};
	var getSymbols_default = getSymbols;

	// ../node_modules/lodash-es/_baseGetAllKeys.js
	function baseGetAllKeys(object, keysFunc, symbolsFunc) {
	  var result2 = keysFunc(object);
	  return isArray_default(object) ? result2 : arrayPush_default(result2, symbolsFunc(object));
	}
	var baseGetAllKeys_default = baseGetAllKeys;

	// ../node_modules/lodash-es/_getAllKeys.js
	function getAllKeys(object) {
	  return baseGetAllKeys_default(object, keys_default, getSymbols_default);
	}
	var getAllKeys_default = getAllKeys;

	// ../node_modules/lodash-es/_DataView.js
	var DataView = getNative_default(root_default, "DataView");
	var DataView_default = DataView;

	// ../node_modules/lodash-es/_Promise.js
	var Promise2 = getNative_default(root_default, "Promise");
	var Promise_default = Promise2;

	// ../node_modules/lodash-es/_Set.js
	var Set2 = getNative_default(root_default, "Set");
	var Set_default = Set2;

	// ../node_modules/lodash-es/_getTag.js
	var mapTag2 = "[object Map]";
	var objectTag3 = "[object Object]";
	var promiseTag = "[object Promise]";
	var setTag2 = "[object Set]";
	var weakMapTag2 = "[object WeakMap]";
	var dataViewTag2 = "[object DataView]";
	var dataViewCtorString = toSource_default(DataView_default);
	var mapCtorString = toSource_default(Map_default);
	var promiseCtorString = toSource_default(Promise_default);
	var setCtorString = toSource_default(Set_default);
	var weakMapCtorString = toSource_default(WeakMap_default);
	var getTag = baseGetTag_default;
	if (DataView_default && getTag(new DataView_default(new ArrayBuffer(1))) != dataViewTag2 || Map_default && getTag(new Map_default()) != mapTag2 || Promise_default && getTag(Promise_default.resolve()) != promiseTag || Set_default && getTag(new Set_default()) != setTag2 || WeakMap_default && getTag(new WeakMap_default()) != weakMapTag2) {
	  getTag = function(value) {
	    var result2 = baseGetTag_default(value), Ctor = result2 == objectTag3 ? value.constructor : void 0, ctorString = Ctor ? toSource_default(Ctor) : "";
	    if (ctorString) {
	      switch (ctorString) {
	        case dataViewCtorString:
	          return dataViewTag2;
	        case mapCtorString:
	          return mapTag2;
	        case promiseCtorString:
	          return promiseTag;
	        case setCtorString:
	          return setTag2;
	        case weakMapCtorString:
	          return weakMapTag2;
	      }
	    }
	    return result2;
	  };
	}
	var getTag_default = getTag;

	// ../node_modules/lodash-es/_Uint8Array.js
	var Uint8Array2 = root_default.Uint8Array;
	var Uint8Array_default = Uint8Array2;

	// ../node_modules/lodash-es/_setCacheAdd.js
	var HASH_UNDEFINED3 = "__lodash_hash_undefined__";
	function setCacheAdd(value) {
	  this.__data__.set(value, HASH_UNDEFINED3);
	  return this;
	}
	var setCacheAdd_default = setCacheAdd;

	// ../node_modules/lodash-es/_setCacheHas.js
	function setCacheHas(value) {
	  return this.__data__.has(value);
	}
	var setCacheHas_default = setCacheHas;

	// ../node_modules/lodash-es/_SetCache.js
	function SetCache(values) {
	  var index = -1, length = values == null ? 0 : values.length;
	  this.__data__ = new MapCache_default();
	  while (++index < length) {
	    this.add(values[index]);
	  }
	}
	SetCache.prototype.add = SetCache.prototype.push = setCacheAdd_default;
	SetCache.prototype.has = setCacheHas_default;
	var SetCache_default = SetCache;

	// ../node_modules/lodash-es/_arraySome.js
	function arraySome(array, predicate) {
	  var index = -1, length = array == null ? 0 : array.length;
	  while (++index < length) {
	    if (predicate(array[index], index, array)) {
	      return true;
	    }
	  }
	  return false;
	}
	var arraySome_default = arraySome;

	// ../node_modules/lodash-es/_cacheHas.js
	function cacheHas(cache, key) {
	  return cache.has(key);
	}
	var cacheHas_default = cacheHas;

	// ../node_modules/lodash-es/_equalArrays.js
	var COMPARE_PARTIAL_FLAG = 1;
	var COMPARE_UNORDERED_FLAG = 2;
	function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
	  var isPartial = bitmask & COMPARE_PARTIAL_FLAG, arrLength = array.length, othLength = other.length;
	  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
	    return false;
	  }
	  var arrStacked = stack.get(array);
	  var othStacked = stack.get(other);
	  if (arrStacked && othStacked) {
	    return arrStacked == other && othStacked == array;
	  }
	  var index = -1, result2 = true, seen = bitmask & COMPARE_UNORDERED_FLAG ? new SetCache_default() : void 0;
	  stack.set(array, other);
	  stack.set(other, array);
	  while (++index < arrLength) {
	    var arrValue = array[index], othValue = other[index];
	    if (customizer) {
	      var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
	    }
	    if (compared !== void 0) {
	      if (compared) {
	        continue;
	      }
	      result2 = false;
	      break;
	    }
	    if (seen) {
	      if (!arraySome_default(other, function(othValue2, othIndex) {
	        if (!cacheHas_default(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
	          return seen.push(othIndex);
	        }
	      })) {
	        result2 = false;
	        break;
	      }
	    } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
	      result2 = false;
	      break;
	    }
	  }
	  stack["delete"](array);
	  stack["delete"](other);
	  return result2;
	}
	var equalArrays_default = equalArrays;

	// ../node_modules/lodash-es/_mapToArray.js
	function mapToArray(map) {
	  var index = -1, result2 = Array(map.size);
	  map.forEach(function(value, key) {
	    result2[++index] = [key, value];
	  });
	  return result2;
	}
	var mapToArray_default = mapToArray;

	// ../node_modules/lodash-es/_setToArray.js
	function setToArray(set2) {
	  var index = -1, result2 = Array(set2.size);
	  set2.forEach(function(value) {
	    result2[++index] = value;
	  });
	  return result2;
	}
	var setToArray_default = setToArray;

	// ../node_modules/lodash-es/_equalByTag.js
	var COMPARE_PARTIAL_FLAG2 = 1;
	var COMPARE_UNORDERED_FLAG2 = 2;
	var boolTag2 = "[object Boolean]";
	var dateTag2 = "[object Date]";
	var errorTag2 = "[object Error]";
	var mapTag3 = "[object Map]";
	var numberTag2 = "[object Number]";
	var regexpTag2 = "[object RegExp]";
	var setTag3 = "[object Set]";
	var stringTag2 = "[object String]";
	var symbolTag2 = "[object Symbol]";
	var arrayBufferTag2 = "[object ArrayBuffer]";
	var dataViewTag3 = "[object DataView]";
	var symbolProto2 = Symbol_default ? Symbol_default.prototype : void 0;
	var symbolValueOf = symbolProto2 ? symbolProto2.valueOf : void 0;
	function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
	  switch (tag) {
	    case dataViewTag3:
	      if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
	        return false;
	      }
	      object = object.buffer;
	      other = other.buffer;
	    case arrayBufferTag2:
	      if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array_default(object), new Uint8Array_default(other))) {
	        return false;
	      }
	      return true;
	    case boolTag2:
	    case dateTag2:
	    case numberTag2:
	      return eq_default(+object, +other);
	    case errorTag2:
	      return object.name == other.name && object.message == other.message;
	    case regexpTag2:
	    case stringTag2:
	      return object == other + "";
	    case mapTag3:
	      var convert = mapToArray_default;
	    case setTag3:
	      var isPartial = bitmask & COMPARE_PARTIAL_FLAG2;
	      convert || (convert = setToArray_default);
	      if (object.size != other.size && !isPartial) {
	        return false;
	      }
	      var stacked = stack.get(object);
	      if (stacked) {
	        return stacked == other;
	      }
	      bitmask |= COMPARE_UNORDERED_FLAG2;
	      stack.set(object, other);
	      var result2 = equalArrays_default(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
	      stack["delete"](object);
	      return result2;
	    case symbolTag2:
	      if (symbolValueOf) {
	        return symbolValueOf.call(object) == symbolValueOf.call(other);
	      }
	  }
	  return false;
	}
	var equalByTag_default = equalByTag;

	// ../node_modules/lodash-es/_equalObjects.js
	var COMPARE_PARTIAL_FLAG3 = 1;
	var objectProto13 = Object.prototype;
	var hasOwnProperty10 = objectProto13.hasOwnProperty;
	function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
	  var isPartial = bitmask & COMPARE_PARTIAL_FLAG3, objProps = getAllKeys_default(object), objLength = objProps.length, othProps = getAllKeys_default(other), othLength = othProps.length;
	  if (objLength != othLength && !isPartial) {
	    return false;
	  }
	  var index = objLength;
	  while (index--) {
	    var key = objProps[index];
	    if (!(isPartial ? key in other : hasOwnProperty10.call(other, key))) {
	      return false;
	    }
	  }
	  var objStacked = stack.get(object);
	  var othStacked = stack.get(other);
	  if (objStacked && othStacked) {
	    return objStacked == other && othStacked == object;
	  }
	  var result2 = true;
	  stack.set(object, other);
	  stack.set(other, object);
	  var skipCtor = isPartial;
	  while (++index < objLength) {
	    key = objProps[index];
	    var objValue = object[key], othValue = other[key];
	    if (customizer) {
	      var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
	    }
	    if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
	      result2 = false;
	      break;
	    }
	    skipCtor || (skipCtor = key == "constructor");
	  }
	  if (result2 && !skipCtor) {
	    var objCtor = object.constructor, othCtor = other.constructor;
	    if (objCtor != othCtor && ("constructor" in object && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
	      result2 = false;
	    }
	  }
	  stack["delete"](object);
	  stack["delete"](other);
	  return result2;
	}
	var equalObjects_default = equalObjects;

	// ../node_modules/lodash-es/_baseIsEqualDeep.js
	var COMPARE_PARTIAL_FLAG4 = 1;
	var argsTag3 = "[object Arguments]";
	var arrayTag2 = "[object Array]";
	var objectTag4 = "[object Object]";
	var objectProto14 = Object.prototype;
	var hasOwnProperty11 = objectProto14.hasOwnProperty;
	function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
	  var objIsArr = isArray_default(object), othIsArr = isArray_default(other), objTag = objIsArr ? arrayTag2 : getTag_default(object), othTag = othIsArr ? arrayTag2 : getTag_default(other);
	  objTag = objTag == argsTag3 ? objectTag4 : objTag;
	  othTag = othTag == argsTag3 ? objectTag4 : othTag;
	  var objIsObj = objTag == objectTag4, othIsObj = othTag == objectTag4, isSameTag = objTag == othTag;
	  if (isSameTag && isBuffer_default(object)) {
	    if (!isBuffer_default(other)) {
	      return false;
	    }
	    objIsArr = true;
	    objIsObj = false;
	  }
	  if (isSameTag && !objIsObj) {
	    stack || (stack = new Stack_default());
	    return objIsArr || isTypedArray_default(object) ? equalArrays_default(object, other, bitmask, customizer, equalFunc, stack) : equalByTag_default(object, other, objTag, bitmask, customizer, equalFunc, stack);
	  }
	  if (!(bitmask & COMPARE_PARTIAL_FLAG4)) {
	    var objIsWrapped = objIsObj && hasOwnProperty11.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty11.call(other, "__wrapped__");
	    if (objIsWrapped || othIsWrapped) {
	      var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
	      stack || (stack = new Stack_default());
	      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
	    }
	  }
	  if (!isSameTag) {
	    return false;
	  }
	  stack || (stack = new Stack_default());
	  return equalObjects_default(object, other, bitmask, customizer, equalFunc, stack);
	}
	var baseIsEqualDeep_default = baseIsEqualDeep;

	// ../node_modules/lodash-es/_baseIsEqual.js
	function baseIsEqual(value, other, bitmask, customizer, stack) {
	  if (value === other) {
	    return true;
	  }
	  if (value == null || other == null || !isObjectLike_default(value) && !isObjectLike_default(other)) {
	    return value !== value && other !== other;
	  }
	  return baseIsEqualDeep_default(value, other, bitmask, customizer, baseIsEqual, stack);
	}
	var baseIsEqual_default = baseIsEqual;

	// ../node_modules/lodash-es/_baseIsMatch.js
	var COMPARE_PARTIAL_FLAG5 = 1;
	var COMPARE_UNORDERED_FLAG3 = 2;
	function baseIsMatch(object, source, matchData, customizer) {
	  var index = matchData.length, length = index, noCustomizer = !customizer;
	  if (object == null) {
	    return !length;
	  }
	  object = Object(object);
	  while (index--) {
	    var data = matchData[index];
	    if (noCustomizer && data[2] ? data[1] !== object[data[0]] : !(data[0] in object)) {
	      return false;
	    }
	  }
	  while (++index < length) {
	    data = matchData[index];
	    var key = data[0], objValue = object[key], srcValue = data[1];
	    if (noCustomizer && data[2]) {
	      if (objValue === void 0 && !(key in object)) {
	        return false;
	      }
	    } else {
	      var stack = new Stack_default();
	      if (customizer) {
	        var result2 = customizer(objValue, srcValue, key, object, source, stack);
	      }
	      if (!(result2 === void 0 ? baseIsEqual_default(srcValue, objValue, COMPARE_PARTIAL_FLAG5 | COMPARE_UNORDERED_FLAG3, customizer, stack) : result2)) {
	        return false;
	      }
	    }
	  }
	  return true;
	}
	var baseIsMatch_default = baseIsMatch;

	// ../node_modules/lodash-es/_isStrictComparable.js
	function isStrictComparable(value) {
	  return value === value && !isObject_default(value);
	}
	var isStrictComparable_default = isStrictComparable;

	// ../node_modules/lodash-es/_getMatchData.js
	function getMatchData(object) {
	  var result2 = keys_default(object), length = result2.length;
	  while (length--) {
	    var key = result2[length], value = object[key];
	    result2[length] = [key, value, isStrictComparable_default(value)];
	  }
	  return result2;
	}
	var getMatchData_default = getMatchData;

	// ../node_modules/lodash-es/_matchesStrictComparable.js
	function matchesStrictComparable(key, srcValue) {
	  return function(object) {
	    if (object == null) {
	      return false;
	    }
	    return object[key] === srcValue && (srcValue !== void 0 || key in Object(object));
	  };
	}
	var matchesStrictComparable_default = matchesStrictComparable;

	// ../node_modules/lodash-es/_baseMatches.js
	function baseMatches(source) {
	  var matchData = getMatchData_default(source);
	  if (matchData.length == 1 && matchData[0][2]) {
	    return matchesStrictComparable_default(matchData[0][0], matchData[0][1]);
	  }
	  return function(object) {
	    return object === source || baseIsMatch_default(object, source, matchData);
	  };
	}
	var baseMatches_default = baseMatches;

	// ../node_modules/lodash-es/_baseHasIn.js
	function baseHasIn(object, key) {
	  return object != null && key in Object(object);
	}
	var baseHasIn_default = baseHasIn;

	// ../node_modules/lodash-es/_hasPath.js
	function hasPath(object, path, hasFunc) {
	  path = castPath_default(path, object);
	  var index = -1, length = path.length, result2 = false;
	  while (++index < length) {
	    var key = toKey_default(path[index]);
	    if (!(result2 = object != null && hasFunc(object, key))) {
	      break;
	    }
	    object = object[key];
	  }
	  if (result2 || ++index != length) {
	    return result2;
	  }
	  length = object == null ? 0 : object.length;
	  return !!length && isLength_default(length) && isIndex_default(key, length) && (isArray_default(object) || isArguments_default(object));
	}
	var hasPath_default = hasPath;

	// ../node_modules/lodash-es/hasIn.js
	function hasIn(object, path) {
	  return object != null && hasPath_default(object, path, baseHasIn_default);
	}
	var hasIn_default = hasIn;

	// ../node_modules/lodash-es/_baseMatchesProperty.js
	var COMPARE_PARTIAL_FLAG6 = 1;
	var COMPARE_UNORDERED_FLAG4 = 2;
	function baseMatchesProperty(path, srcValue) {
	  if (isKey_default(path) && isStrictComparable_default(srcValue)) {
	    return matchesStrictComparable_default(toKey_default(path), srcValue);
	  }
	  return function(object) {
	    var objValue = get_default(object, path);
	    return objValue === void 0 && objValue === srcValue ? hasIn_default(object, path) : baseIsEqual_default(srcValue, objValue, COMPARE_PARTIAL_FLAG6 | COMPARE_UNORDERED_FLAG4);
	  };
	}
	var baseMatchesProperty_default = baseMatchesProperty;

	// ../node_modules/lodash-es/_baseProperty.js
	function baseProperty(key) {
	  return function(object) {
	    return object == null ? void 0 : object[key];
	  };
	}
	var baseProperty_default = baseProperty;

	// ../node_modules/lodash-es/_basePropertyDeep.js
	function basePropertyDeep(path) {
	  return function(object) {
	    return baseGet_default(object, path);
	  };
	}
	var basePropertyDeep_default = basePropertyDeep;

	// ../node_modules/lodash-es/property.js
	function property(path) {
	  return isKey_default(path) ? baseProperty_default(toKey_default(path)) : basePropertyDeep_default(path);
	}
	var property_default = property;

	// ../node_modules/lodash-es/_baseIteratee.js
	function baseIteratee(value) {
	  if (typeof value == "function") {
	    return value;
	  }
	  if (value == null) {
	    return identity_default;
	  }
	  if (typeof value == "object") {
	    return isArray_default(value) ? baseMatchesProperty_default(value[0], value[1]) : baseMatches_default(value);
	  }
	  return property_default(value);
	}
	var baseIteratee_default = baseIteratee;

	// ../node_modules/lodash-es/_arrayAggregator.js
	function arrayAggregator(array, setter, iteratee, accumulator) {
	  var index = -1, length = array == null ? 0 : array.length;
	  while (++index < length) {
	    var value = array[index];
	    setter(accumulator, value, iteratee(value), array);
	  }
	  return accumulator;
	}
	var arrayAggregator_default = arrayAggregator;

	// ../node_modules/lodash-es/_createBaseFor.js
	function createBaseFor(fromRight) {
	  return function(object, iteratee, keysFunc) {
	    var index = -1, iterable = Object(object), props = keysFunc(object), length = props.length;
	    while (length--) {
	      var key = props[fromRight ? length : ++index];
	      if (iteratee(iterable[key], key, iterable) === false) {
	        break;
	      }
	    }
	    return object;
	  };
	}
	var createBaseFor_default = createBaseFor;

	// ../node_modules/lodash-es/_baseFor.js
	var baseFor = createBaseFor_default();
	var baseFor_default = baseFor;

	// ../node_modules/lodash-es/_baseForOwn.js
	function baseForOwn(object, iteratee) {
	  return object && baseFor_default(object, iteratee, keys_default);
	}
	var baseForOwn_default = baseForOwn;

	// ../node_modules/lodash-es/_createBaseEach.js
	function createBaseEach(eachFunc, fromRight) {
	  return function(collection, iteratee) {
	    if (collection == null) {
	      return collection;
	    }
	    if (!isArrayLike_default(collection)) {
	      return eachFunc(collection, iteratee);
	    }
	    var length = collection.length, index = fromRight ? length : -1, iterable = Object(collection);
	    while (fromRight ? index-- : ++index < length) {
	      if (iteratee(iterable[index], index, iterable) === false) {
	        break;
	      }
	    }
	    return collection;
	  };
	}
	var createBaseEach_default = createBaseEach;

	// ../node_modules/lodash-es/_baseEach.js
	var baseEach = createBaseEach_default(baseForOwn_default);
	var baseEach_default = baseEach;

	// ../node_modules/lodash-es/_baseAggregator.js
	function baseAggregator(collection, setter, iteratee, accumulator) {
	  baseEach_default(collection, function(value, key, collection2) {
	    setter(accumulator, value, iteratee(value), collection2);
	  });
	  return accumulator;
	}
	var baseAggregator_default = baseAggregator;

	// ../node_modules/lodash-es/_createAggregator.js
	function createAggregator(setter, initializer) {
	  return function(collection, iteratee) {
	    var func = isArray_default(collection) ? arrayAggregator_default : baseAggregator_default, accumulator = initializer ? initializer() : {};
	    return func(collection, setter, baseIteratee_default(iteratee), accumulator);
	  };
	}
	var createAggregator_default = createAggregator;

	// ../node_modules/lodash-es/now.js
	var now = function() {
	  return root_default.Date.now();
	};
	var now_default = now;

	// ../node_modules/lodash-es/debounce.js
	var FUNC_ERROR_TEXT2 = "Expected a function";
	var nativeMax2 = Math.max;
	var nativeMin2 = Math.min;
	function debounce(func, wait, options) {
	  var lastArgs, lastThis, maxWait, result2, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
	  if (typeof func != "function") {
	    throw new TypeError(FUNC_ERROR_TEXT2);
	  }
	  wait = toNumber_default(wait) || 0;
	  if (isObject_default(options)) {
	    leading = !!options.leading;
	    maxing = "maxWait" in options;
	    maxWait = maxing ? nativeMax2(toNumber_default(options.maxWait) || 0, wait) : maxWait;
	    trailing = "trailing" in options ? !!options.trailing : trailing;
	  }
	  function invokeFunc(time) {
	    var args = lastArgs, thisArg = lastThis;
	    lastArgs = lastThis = void 0;
	    lastInvokeTime = time;
	    result2 = func.apply(thisArg, args);
	    return result2;
	  }
	  function leadingEdge(time) {
	    lastInvokeTime = time;
	    timerId = setTimeout(timerExpired, wait);
	    return leading ? invokeFunc(time) : result2;
	  }
	  function remainingWait(time) {
	    var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
	    return maxing ? nativeMin2(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
	  }
	  function shouldInvoke(time) {
	    var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
	    return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
	  }
	  function timerExpired() {
	    var time = now_default();
	    if (shouldInvoke(time)) {
	      return trailingEdge(time);
	    }
	    timerId = setTimeout(timerExpired, remainingWait(time));
	  }
	  function trailingEdge(time) {
	    timerId = void 0;
	    if (trailing && lastArgs) {
	      return invokeFunc(time);
	    }
	    lastArgs = lastThis = void 0;
	    return result2;
	  }
	  function cancel() {
	    if (timerId !== void 0) {
	      clearTimeout(timerId);
	    }
	    lastInvokeTime = 0;
	    lastArgs = lastCallTime = lastThis = timerId = void 0;
	  }
	  function flush() {
	    return timerId === void 0 ? result2 : trailingEdge(now_default());
	  }
	  function debounced() {
	    var time = now_default(), isInvoking = shouldInvoke(time);
	    lastArgs = arguments;
	    lastThis = this;
	    lastCallTime = time;
	    if (isInvoking) {
	      if (timerId === void 0) {
	        return leadingEdge(lastCallTime);
	      }
	      if (maxing) {
	        clearTimeout(timerId);
	        timerId = setTimeout(timerExpired, wait);
	        return invokeFunc(lastCallTime);
	      }
	    }
	    if (timerId === void 0) {
	      timerId = setTimeout(timerExpired, wait);
	    }
	    return result2;
	  }
	  debounced.cancel = cancel;
	  debounced.flush = flush;
	  return debounced;
	}
	var debounce_default = debounce;

	// ../node_modules/lodash-es/_arrayIncludesWith.js
	function arrayIncludesWith(array, value, comparator) {
	  var index = -1, length = array == null ? 0 : array.length;
	  while (++index < length) {
	    if (comparator(value, array[index])) {
	      return true;
	    }
	  }
	  return false;
	}
	var arrayIncludesWith_default = arrayIncludesWith;

	// ../node_modules/lodash-es/last.js
	function last(array) {
	  var length = array == null ? 0 : array.length;
	  return length ? array[length - 1] : void 0;
	}
	var last_default = last;

	// ../node_modules/lodash-es/findIndex.js
	var nativeMax3 = Math.max;
	function findIndex(array, predicate, fromIndex) {
	  var length = array == null ? 0 : array.length;
	  if (!length) {
	    return -1;
	  }
	  var index = fromIndex == null ? 0 : toInteger_default(fromIndex);
	  if (index < 0) {
	    index = nativeMax3(length + index, 0);
	  }
	  return baseFindIndex_default(array, baseIteratee_default(predicate), index);
	}
	var findIndex_default = findIndex;

	// ../node_modules/lodash-es/findLastIndex.js
	var nativeMax4 = Math.max;
	var nativeMin3 = Math.min;
	function findLastIndex(array, predicate, fromIndex) {
	  var length = array == null ? 0 : array.length;
	  if (!length) {
	    return -1;
	  }
	  var index = length - 1;
	  if (fromIndex !== void 0) {
	    index = toInteger_default(fromIndex);
	    index = fromIndex < 0 ? nativeMax4(length + index, 0) : nativeMin3(index, length - 1);
	  }
	  return baseFindIndex_default(array, baseIteratee_default(predicate), index, true);
	}
	var findLastIndex_default = findLastIndex;

	// ../node_modules/lodash-es/_baseMap.js
	function baseMap(collection, iteratee) {
	  var index = -1, result2 = isArrayLike_default(collection) ? Array(collection.length) : [];
	  baseEach_default(collection, function(value, key, collection2) {
	    result2[++index] = iteratee(value, key, collection2);
	  });
	  return result2;
	}
	var baseMap_default = baseMap;

	// ../node_modules/lodash-es/_baseInRange.js
	var nativeMax5 = Math.max;
	var nativeMin4 = Math.min;
	function baseInRange(number, start, end) {
	  return number >= nativeMin4(start, end) && number < nativeMax5(start, end);
	}
	var baseInRange_default = baseInRange;

	// ../node_modules/lodash-es/inRange.js
	function inRange(number, start, end) {
	  start = toFinite_default(start);
	  if (end === void 0) {
	    end = start;
	    start = 0;
	  } else {
	    end = toFinite_default(end);
	  }
	  number = toNumber_default(number);
	  return baseInRange_default(number, start, end);
	}
	var inRange_default = inRange;

	// ../node_modules/lodash-es/isInteger.js
	function isInteger(value) {
	  return typeof value == "number" && value == toInteger_default(value);
	}
	var isInteger_default = isInteger;

	// ../node_modules/lodash-es/keyBy.js
	var keyBy = createAggregator_default(function(result2, value, key) {
	  baseAssignValue_default(result2, key, value);
	});
	var keyBy_default = keyBy;

	// ../node_modules/lodash-es/mapValues.js
	function mapValues(object, iteratee) {
	  var result2 = {};
	  iteratee = baseIteratee_default(iteratee);
	  baseForOwn_default(object, function(value, key, object2) {
	    baseAssignValue_default(result2, key, iteratee(value, key, object2));
	  });
	  return result2;
	}
	var mapValues_default = mapValues;

	// ../node_modules/lodash-es/_baseSet.js
	function baseSet(object, path, value, customizer) {
	  if (!isObject_default(object)) {
	    return object;
	  }
	  path = castPath_default(path, object);
	  var index = -1, length = path.length, lastIndex = length - 1, nested = object;
	  while (nested != null && ++index < length) {
	    var key = toKey_default(path[index]), newValue = value;
	    if (key === "__proto__" || key === "constructor" || key === "prototype") {
	      return object;
	    }
	    if (index != lastIndex) {
	      var objValue = nested[key];
	      newValue = customizer ? customizer(objValue, key, nested) : void 0;
	      if (newValue === void 0) {
	        newValue = isObject_default(objValue) ? objValue : isIndex_default(path[index + 1]) ? [] : {};
	      }
	    }
	    assignValue_default(nested, key, newValue);
	    nested = nested[key];
	  }
	  return object;
	}
	var baseSet_default = baseSet;

	// ../node_modules/lodash-es/_baseSortBy.js
	function baseSortBy(array, comparer) {
	  var length = array.length;
	  array.sort(comparer);
	  while (length--) {
	    array[length] = array[length].value;
	  }
	  return array;
	}
	var baseSortBy_default = baseSortBy;

	// ../node_modules/lodash-es/_compareAscending.js
	function compareAscending(value, other) {
	  if (value !== other) {
	    var valIsDefined = value !== void 0, valIsNull = value === null, valIsReflexive = value === value, valIsSymbol = isSymbol_default(value);
	    var othIsDefined = other !== void 0, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = isSymbol_default(other);
	    if (!othIsNull && !othIsSymbol && !valIsSymbol && value > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
	      return 1;
	    }
	    if (!valIsNull && !valIsSymbol && !othIsSymbol && value < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
	      return -1;
	    }
	  }
	  return 0;
	}
	var compareAscending_default = compareAscending;

	// ../node_modules/lodash-es/_compareMultiple.js
	function compareMultiple(object, other, orders) {
	  var index = -1, objCriteria = object.criteria, othCriteria = other.criteria, length = objCriteria.length, ordersLength = orders.length;
	  while (++index < length) {
	    var result2 = compareAscending_default(objCriteria[index], othCriteria[index]);
	    if (result2) {
	      if (index >= ordersLength) {
	        return result2;
	      }
	      var order = orders[index];
	      return result2 * (order == "desc" ? -1 : 1);
	    }
	  }
	  return object.index - other.index;
	}
	var compareMultiple_default = compareMultiple;

	// ../node_modules/lodash-es/_baseOrderBy.js
	function baseOrderBy(collection, iteratees, orders) {
	  if (iteratees.length) {
	    iteratees = arrayMap_default(iteratees, function(iteratee) {
	      if (isArray_default(iteratee)) {
	        return function(value) {
	          return baseGet_default(value, iteratee.length === 1 ? iteratee[0] : iteratee);
	        };
	      }
	      return iteratee;
	    });
	  } else {
	    iteratees = [identity_default];
	  }
	  var index = -1;
	  iteratees = arrayMap_default(iteratees, baseUnary_default(baseIteratee_default));
	  var result2 = baseMap_default(collection, function(value, key, collection2) {
	    var criteria = arrayMap_default(iteratees, function(iteratee) {
	      return iteratee(value);
	    });
	    return { "criteria": criteria, "index": ++index, "value": value };
	  });
	  return baseSortBy_default(result2, function(object, other) {
	    return compareMultiple_default(object, other, orders);
	  });
	}
	var baseOrderBy_default = baseOrderBy;

	// ../node_modules/lodash-es/_baseIndexOfWith.js
	function baseIndexOfWith(array, value, fromIndex, comparator) {
	  var index = fromIndex - 1, length = array.length;
	  while (++index < length) {
	    if (comparator(array[index], value)) {
	      return index;
	    }
	  }
	  return -1;
	}
	var baseIndexOfWith_default = baseIndexOfWith;

	// ../node_modules/lodash-es/_basePullAll.js
	var arrayProto2 = Array.prototype;
	var splice2 = arrayProto2.splice;
	function basePullAll(array, values, iteratee, comparator) {
	  var indexOf = comparator ? baseIndexOfWith_default : baseIndexOf_default, index = -1, length = values.length, seen = array;
	  if (array === values) {
	    values = copyArray_default(values);
	  }
	  if (iteratee) {
	    seen = arrayMap_default(array, baseUnary_default(iteratee));
	  }
	  while (++index < length) {
	    var fromIndex = 0, value = values[index], computed = iteratee ? iteratee(value) : value;
	    while ((fromIndex = indexOf(seen, computed, fromIndex, comparator)) > -1) {
	      if (seen !== array) {
	        splice2.call(seen, fromIndex, 1);
	      }
	      splice2.call(array, fromIndex, 1);
	    }
	  }
	  return array;
	}
	var basePullAll_default = basePullAll;

	// ../node_modules/lodash-es/pullAll.js
	function pullAll(array, values) {
	  return array && array.length && values && values.length ? basePullAll_default(array, values) : array;
	}
	var pullAll_default = pullAll;

	// ../node_modules/lodash-es/pull.js
	var pull = baseRest_default(pullAll_default);
	var pull_default = pull;

	// ../node_modules/lodash-es/round.js
	var round = createRound_default("round");
	var round_default = round;

	// ../node_modules/lodash-es/set.js
	function set(object, path, value) {
	  return object == null ? object : baseSet_default(object, path, value);
	}
	var set_default = set;

	// ../node_modules/lodash-es/sortBy.js
	var sortBy = baseRest_default(function(collection, iteratees) {
	  if (collection == null) {
	    return [];
	  }
	  var length = iteratees.length;
	  if (length > 1 && isIterateeCall_default(collection, iteratees[0], iteratees[1])) {
	    iteratees = [];
	  } else if (length > 2 && isIterateeCall_default(iteratees[0], iteratees[1], iteratees[2])) {
	    iteratees = [iteratees[0]];
	  }
	  return baseOrderBy_default(collection, baseFlatten_default(iteratees, 1), []);
	});
	var sortBy_default = sortBy;

	// ../node_modules/lodash-es/_createSet.js
	var INFINITY4 = 1 / 0;
	var createSet = !(Set_default && 1 / setToArray_default(new Set_default([, -0]))[1] == INFINITY4) ? noop_default : function(values) {
	  return new Set_default(values);
	};
	var createSet_default = createSet;

	// ../node_modules/lodash-es/_baseUniq.js
	var LARGE_ARRAY_SIZE2 = 200;
	function baseUniq(array, iteratee, comparator) {
	  var index = -1, includes = arrayIncludes_default, length = array.length, isCommon = true, result2 = [], seen = result2;
	  if (comparator) {
	    isCommon = false;
	    includes = arrayIncludesWith_default;
	  } else if (length >= LARGE_ARRAY_SIZE2) {
	    var set2 = iteratee ? null : createSet_default(array);
	    if (set2) {
	      return setToArray_default(set2);
	    }
	    isCommon = false;
	    includes = cacheHas_default;
	    seen = new SetCache_default();
	  } else {
	    seen = iteratee ? [] : result2;
	  }
	  outer:
	    while (++index < length) {
	      var value = array[index], computed = iteratee ? iteratee(value) : value;
	      value = comparator || value !== 0 ? value : 0;
	      if (isCommon && computed === computed) {
	        var seenIndex = seen.length;
	        while (seenIndex--) {
	          if (seen[seenIndex] === computed) {
	            continue outer;
	          }
	        }
	        if (iteratee) {
	          seen.push(computed);
	        }
	        result2.push(value);
	      } else if (!includes(seen, computed, comparator)) {
	        if (seen !== result2) {
	          seen.push(computed);
	        }
	        result2.push(value);
	      }
	    }
	  return result2;
	}
	var baseUniq_default = baseUniq;

	// ../node_modules/lodash-es/uniq.js
	function uniq(array) {
	  return array && array.length ? baseUniq_default(array) : [];
	}
	var uniq_default = uniq;

	// ../packages/react/src/index.ts
	var import_queue_microtask = __toModule(require_queue_microtask());
	var import_react = __toModule(react.exports);
	var import_react_dom = __toModule(reactDom.exports);
	var logger2 = { log: console.log };
	function useForceUpdate(debugLabel) {
	  const [, setTick] = (0, import_react.useState)(0);
	  const update = (0, import_react.useCallback)(() => {
	    if (debugLabel)
	      logger2.log(debugLabel, "forceUpdate", { trace: new Error() });
	    setTick((tick) => tick + 1);
	  }, []);
	  return update;
	}
	function usePrism(fn2, deps, debugLabel) {
	  const fnAsCallback = (0, import_react.useCallback)(fn2, deps);
	  const boxRef = (0, import_react.useRef)(null);
	  if (!boxRef.current) {
	    boxRef.current = new import_dataverse2.Box(fnAsCallback);
	  } else {
	    boxRef.current.set(fnAsCallback);
	  }
	  const derivation = (0, import_react.useMemo)(() => (0, import_dataverse3.prism)(() => {
	    const fn3 = boxRef.current.derivation.getValue();
	    return fn3();
	  }), []);
	  return useDerivation(derivation, debugLabel);
	}
	var useVal = (p2, debugLabel) => {
	  return usePrism(() => (0, import_dataverse3.val)(p2), [p2], debugLabel);
	};
	var lastOrder = 0;
	var queue = [];
	var setOfQueuedItems = new Set();
	var microtaskIsQueued = false;
	var pushToQueue = (item) => {
	  _pushToQueue(item);
	  queueIfNeeded();
	};
	var _pushToQueue = (item) => {
	  if (setOfQueuedItems.has(item))
	    return;
	  setOfQueuedItems.add(item);
	  if (queue.length === 0) {
	    queue.push(item);
	  } else {
	    const index = findIndex_default(queue, (existingItem) => existingItem.order >= item.order);
	    if (index === -1) {
	      queue.push(item);
	    } else {
	      const right = queue[index];
	      if (right.order > item.order) {
	        queue.splice(index, 0, item);
	      }
	    }
	  }
	};
	var removeFromQueue = (item) => {
	  if (!setOfQueuedItems.has(item))
	    return;
	  setOfQueuedItems.delete(item);
	  const index = findIndex_default(queue, (o2) => o2 === item);
	  queue.splice(index, 1);
	};
	function queueIfNeeded() {
	  if (!microtaskIsQueued) {
	    microtaskIsQueued = true;
	    (0, import_queue_microtask.default)(() => {
	      let i2 = 0;
	      while (queue.length > 0) {
	        i2++;
	        if (i2 === 4) {
	          setTimeout(queueIfNeeded, 1);
	          break;
	        }
	        (0, import_react_dom.unstable_batchedUpdates)(() => {
	          for (const item of queue) {
	            item.runUpdate();
	          }
	        }, 1);
	      }
	      microtaskIsQueued = false;
	    });
	  }
	}
	function useDerivation(der, debugLabel) {
	  const _forceUpdate = useForceUpdate(debugLabel);
	  const refs = (0, import_react.useRef)(void 0);
	  if (!refs.current) {
	    lastOrder++;
	    refs.current = {
	      queueItem: {
	        debugLabel,
	        order: lastOrder,
	        runUpdate: () => {
	          if (!refs.current.unmounted) {
	            _forceUpdate();
	          }
	        }
	      },
	      unmounted: false
	    };
	  }
	  const queueUpdate = (0, import_react.useCallback)(() => {
	    pushToQueue(refs.current.queueItem);
	  }, []);
	  (0, import_react.useLayoutEffect)(() => {
	    const untap = der.changesWithoutValues().tap(() => {
	      queueUpdate();
	    });
	    if (lastValueRef.current !== der.getValue()) {
	      queueUpdate();
	    }
	    return untap;
	  }, [der]);
	  (0, import_react.useLayoutEffect)(() => {
	    return function onUnmount() {
	      refs.current.unmounted = true;
	      removeFromQueue(refs.current.queueItem);
	    };
	  }, []);
	  const lastValueRef = (0, import_react.useRef)(void 0);
	  const queueItem = refs.current.queueItem;
	  const mustDefer = setOfQueuedItems.has(queueItem) && queue[0] !== refs.current.queueItem;
	  if (!mustDefer) {
	    removeFromQueue(queueItem);
	    lastValueRef.current = der.getValue();
	  }
	  return lastValueRef.current;
	}

	// studio/src/UIRoot/UIRoot.tsx
	var import_dataverse47 = __toModule(dist$1);
	var import_react172 = __toModule(react.exports);
	var import_styled_components79 = __toModule(require$$3);

	// studio/src/panels/OutlinePanel/OutlinePanel.tsx
	var import_react53 = __toModule(react.exports);
	var import_styled_components15 = __toModule(require$$3);

	// ../node_modules/@babel/runtime/helpers/esm/extends.js
	function _extends() {
	  _extends = Object.assign || function(target) {
	    for (var i2 = 1; i2 < arguments.length; i2++) {
	      var source = arguments[i2];
	      for (var key in source) {
	        if (Object.prototype.hasOwnProperty.call(source, key)) {
	          target[key] = source[key];
	        }
	      }
	    }
	    return target;
	  };
	  return _extends.apply(this, arguments);
	}

	// ../node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js
	function _assertThisInitialized(self2) {
	  if (self2 === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }
	  return self2;
	}

	// ../node_modules/@babel/runtime/helpers/esm/setPrototypeOf.js
	function _setPrototypeOf(o2, p2) {
	  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o3, p3) {
	    o3.__proto__ = p3;
	    return o3;
	  };
	  return _setPrototypeOf(o2, p2);
	}

	// ../node_modules/@babel/runtime/helpers/esm/inheritsLoose.js
	function _inheritsLoose(subClass, superClass) {
	  subClass.prototype = Object.create(superClass.prototype);
	  subClass.prototype.constructor = subClass;
	  _setPrototypeOf(subClass, superClass);
	}

	// ../node_modules/@babel/runtime/helpers/esm/getPrototypeOf.js
	function _getPrototypeOf(o2) {
	  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf2(o3) {
	    return o3.__proto__ || Object.getPrototypeOf(o3);
	  };
	  return _getPrototypeOf(o2);
	}

	// ../node_modules/@babel/runtime/helpers/esm/isNativeFunction.js
	function _isNativeFunction(fn2) {
	  return Function.toString.call(fn2).indexOf("[native code]") !== -1;
	}

	// ../node_modules/@babel/runtime/helpers/esm/isNativeReflectConstruct.js
	function _isNativeReflectConstruct() {
	  if (typeof Reflect === "undefined" || !Reflect.construct)
	    return false;
	  if (Reflect.construct.sham)
	    return false;
	  if (typeof Proxy === "function")
	    return true;
	  try {
	    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
	    }));
	    return true;
	  } catch (e) {
	    return false;
	  }
	}

	// ../node_modules/@babel/runtime/helpers/esm/construct.js
	function _construct(Parent, args, Class) {
	  if (_isNativeReflectConstruct()) {
	    _construct = Reflect.construct;
	  } else {
	    _construct = function _construct2(Parent2, args2, Class2) {
	      var a2 = [null];
	      a2.push.apply(a2, args2);
	      var Constructor = Function.bind.apply(Parent2, a2);
	      var instance = new Constructor();
	      if (Class2)
	        _setPrototypeOf(instance, Class2.prototype);
	      return instance;
	    };
	  }
	  return _construct.apply(null, arguments);
	}

	// ../node_modules/@babel/runtime/helpers/esm/wrapNativeSuper.js
	function _wrapNativeSuper(Class) {
	  var _cache = typeof Map === "function" ? new Map() : void 0;
	  _wrapNativeSuper = function _wrapNativeSuper2(Class2) {
	    if (Class2 === null || !_isNativeFunction(Class2))
	      return Class2;
	    if (typeof Class2 !== "function") {
	      throw new TypeError("Super expression must either be null or a function");
	    }
	    if (typeof _cache !== "undefined") {
	      if (_cache.has(Class2))
	        return _cache.get(Class2);
	      _cache.set(Class2, Wrapper);
	    }
	    function Wrapper() {
	      return _construct(Class2, arguments, _getPrototypeOf(this).constructor);
	    }
	    Wrapper.prototype = Object.create(Class2.prototype, {
	      constructor: {
	        value: Wrapper,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	    return _setPrototypeOf(Wrapper, Class2);
	  };
	  return _wrapNativeSuper(Class);
	}

	// ../node_modules/polished/dist/polished.esm.js
	var ERRORS = {
	  "1": "Passed invalid arguments to hsl, please pass multiple numbers e.g. hsl(360, 0.75, 0.4) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75 }).\n\n",
	  "2": "Passed invalid arguments to hsla, please pass multiple numbers e.g. hsla(360, 0.75, 0.4, 0.7) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75, alpha: 0.7 }).\n\n",
	  "3": "Passed an incorrect argument to a color function, please pass a string representation of a color.\n\n",
	  "4": "Couldn't generate valid rgb string from %s, it returned %s.\n\n",
	  "5": "Couldn't parse the color string. Please provide the color as a string in hex, rgb, rgba, hsl or hsla notation.\n\n",
	  "6": "Passed invalid arguments to rgb, please pass multiple numbers e.g. rgb(255, 205, 100) or an object e.g. rgb({ red: 255, green: 205, blue: 100 }).\n\n",
	  "7": "Passed invalid arguments to rgba, please pass multiple numbers e.g. rgb(255, 205, 100, 0.75) or an object e.g. rgb({ red: 255, green: 205, blue: 100, alpha: 0.75 }).\n\n",
	  "8": "Passed invalid argument to toColorString, please pass a RgbColor, RgbaColor, HslColor or HslaColor object.\n\n",
	  "9": "Please provide a number of steps to the modularScale helper.\n\n",
	  "10": "Please pass a number or one of the predefined scales to the modularScale helper as the ratio.\n\n",
	  "11": 'Invalid value passed as base to modularScale, expected number or em string but got "%s"\n\n',
	  "12": 'Expected a string ending in "px" or a number passed as the first argument to %s(), got "%s" instead.\n\n',
	  "13": 'Expected a string ending in "px" or a number passed as the second argument to %s(), got "%s" instead.\n\n',
	  "14": 'Passed invalid pixel value ("%s") to %s(), please pass a value like "12px" or 12.\n\n',
	  "15": 'Passed invalid base value ("%s") to %s(), please pass a value like "12px" or 12.\n\n',
	  "16": "You must provide a template to this method.\n\n",
	  "17": "You passed an unsupported selector state to this method.\n\n",
	  "18": "minScreen and maxScreen must be provided as stringified numbers with the same units.\n\n",
	  "19": "fromSize and toSize must be provided as stringified numbers with the same units.\n\n",
	  "20": "expects either an array of objects or a single object with the properties prop, fromSize, and toSize.\n\n",
	  "21": "expects the objects in the first argument array to have the properties `prop`, `fromSize`, and `toSize`.\n\n",
	  "22": "expects the first argument object to have the properties `prop`, `fromSize`, and `toSize`.\n\n",
	  "23": "fontFace expects a name of a font-family.\n\n",
	  "24": "fontFace expects either the path to the font file(s) or a name of a local copy.\n\n",
	  "25": "fontFace expects localFonts to be an array.\n\n",
	  "26": "fontFace expects fileFormats to be an array.\n\n",
	  "27": "radialGradient requries at least 2 color-stops to properly render.\n\n",
	  "28": "Please supply a filename to retinaImage() as the first argument.\n\n",
	  "29": "Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.\n\n",
	  "30": "Passed an invalid value to `height` or `width`. Please provide a pixel based unit.\n\n",
	  "31": "The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation\n\n",
	  "32": "To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s')\n\n",
	  "33": "The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation\n\n",
	  "34": "borderRadius expects a radius value as a string or number as the second argument.\n\n",
	  "35": 'borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.\n\n',
	  "36": "Property must be a string value.\n\n",
	  "37": "Syntax Error at %s.\n\n",
	  "38": "Formula contains a function that needs parentheses at %s.\n\n",
	  "39": "Formula is missing closing parenthesis at %s.\n\n",
	  "40": "Formula has too many closing parentheses at %s.\n\n",
	  "41": "All values in a formula must have the same unit or be unitless.\n\n",
	  "42": "Please provide a number of steps to the modularScale helper.\n\n",
	  "43": "Please pass a number or one of the predefined scales to the modularScale helper as the ratio.\n\n",
	  "44": "Invalid value passed as base to modularScale, expected number or em/rem string but got %s.\n\n",
	  "45": "Passed invalid argument to hslToColorString, please pass a HslColor or HslaColor object.\n\n",
	  "46": "Passed invalid argument to rgbToColorString, please pass a RgbColor or RgbaColor object.\n\n",
	  "47": "minScreen and maxScreen must be provided as stringified numbers with the same units.\n\n",
	  "48": "fromSize and toSize must be provided as stringified numbers with the same units.\n\n",
	  "49": "Expects either an array of objects or a single object with the properties prop, fromSize, and toSize.\n\n",
	  "50": "Expects the objects in the first argument array to have the properties prop, fromSize, and toSize.\n\n",
	  "51": "Expects the first argument object to have the properties prop, fromSize, and toSize.\n\n",
	  "52": "fontFace expects either the path to the font file(s) or a name of a local copy.\n\n",
	  "53": "fontFace expects localFonts to be an array.\n\n",
	  "54": "fontFace expects fileFormats to be an array.\n\n",
	  "55": "fontFace expects a name of a font-family.\n\n",
	  "56": "linearGradient requries at least 2 color-stops to properly render.\n\n",
	  "57": "radialGradient requries at least 2 color-stops to properly render.\n\n",
	  "58": "Please supply a filename to retinaImage() as the first argument.\n\n",
	  "59": "Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.\n\n",
	  "60": "Passed an invalid value to `height` or `width`. Please provide a pixel based unit.\n\n",
	  "61": "Property must be a string value.\n\n",
	  "62": "borderRadius expects a radius value as a string or number as the second argument.\n\n",
	  "63": 'borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.\n\n',
	  "64": "The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation.\n\n",
	  "65": "To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s').\n\n",
	  "66": "The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation.\n\n",
	  "67": "You must provide a template to this method.\n\n",
	  "68": "You passed an unsupported selector state to this method.\n\n",
	  "69": 'Expected a string ending in "px" or a number passed as the first argument to %s(), got %s instead.\n\n',
	  "70": 'Expected a string ending in "px" or a number passed as the second argument to %s(), got %s instead.\n\n',
	  "71": 'Passed invalid pixel value %s to %s(), please pass a value like "12px" or 12.\n\n',
	  "72": 'Passed invalid base value %s to %s(), please pass a value like "12px" or 12.\n\n',
	  "73": "Please provide a valid CSS variable.\n\n",
	  "74": "CSS variable not found and no default was provided.\n\n",
	  "75": "important requires a valid style object, got a %s instead.\n\n",
	  "76": "fromSize and toSize must be provided as stringified numbers with the same units as minScreen and maxScreen.\n\n",
	  "77": 'remToPx expects a value in "rem" but you provided it in "%s".\n\n',
	  "78": 'base must be set in "px" or "%" but you set it in "%s".\n'
	};
	function format() {
	  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	    args[_key] = arguments[_key];
	  }
	  var a2 = args[0];
	  var b2 = [];
	  var c2;
	  for (c2 = 1; c2 < args.length; c2 += 1) {
	    b2.push(args[c2]);
	  }
	  b2.forEach(function(d2) {
	    a2 = a2.replace(/%[a-z]/, d2);
	  });
	  return a2;
	}
	var PolishedError = /* @__PURE__ */ function(_Error) {
	  _inheritsLoose(PolishedError2, _Error);
	  function PolishedError2(code) {
	    var _this;
	    {
	      for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
	        args[_key2 - 1] = arguments[_key2];
	      }
	      _this = _Error.call(this, format.apply(void 0, [ERRORS[code]].concat(args))) || this;
	    }
	    return _assertThisInitialized(_this);
	  }
	  return PolishedError2;
	}(/* @__PURE__ */ _wrapNativeSuper(Error));
	function capitalizeString(string) {
	  return string.charAt(0).toUpperCase() + string.slice(1);
	}
	var positionMap$1 = ["Top", "Right", "Bottom", "Left"];
	function generateProperty(property2, position2) {
	  if (!property2)
	    return position2.toLowerCase();
	  var splitProperty = property2.split("-");
	  if (splitProperty.length > 1) {
	    splitProperty.splice(1, 0, position2);
	    return splitProperty.reduce(function(acc, val39) {
	      return "" + acc + capitalizeString(val39);
	    });
	  }
	  var joinedProperty = property2.replace(/([a-z])([A-Z])/g, "$1" + position2 + "$2");
	  return property2 === joinedProperty ? "" + property2 + position2 : joinedProperty;
	}
	function generateStyles(property2, valuesWithDefaults) {
	  var styles = {};
	  for (var i2 = 0; i2 < valuesWithDefaults.length; i2 += 1) {
	    if (valuesWithDefaults[i2] || valuesWithDefaults[i2] === 0) {
	      styles[generateProperty(property2, positionMap$1[i2])] = valuesWithDefaults[i2];
	    }
	  }
	  return styles;
	}
	function directionalProperty(property2) {
	  for (var _len = arguments.length, values = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	    values[_key - 1] = arguments[_key];
	  }
	  var firstValue = values[0], _values$ = values[1], secondValue = _values$ === void 0 ? firstValue : _values$, _values$2 = values[2], thirdValue = _values$2 === void 0 ? firstValue : _values$2, _values$3 = values[3], fourthValue = _values$3 === void 0 ? secondValue : _values$3;
	  var valuesWithDefaults = [firstValue, secondValue, thirdValue, fourthValue];
	  return generateStyles(property2, valuesWithDefaults);
	}
	function colorToInt(color2) {
	  return Math.round(color2 * 255);
	}
	function convertToInt(red, green, blue) {
	  return colorToInt(red) + "," + colorToInt(green) + "," + colorToInt(blue);
	}
	function hslToRgb(hue, saturation, lightness, convert) {
	  if (convert === void 0) {
	    convert = convertToInt;
	  }
	  if (saturation === 0) {
	    return convert(lightness, lightness, lightness);
	  }
	  var huePrime = (hue % 360 + 360) % 360 / 60;
	  var chroma = (1 - Math.abs(2 * lightness - 1)) * saturation;
	  var secondComponent = chroma * (1 - Math.abs(huePrime % 2 - 1));
	  var red = 0;
	  var green = 0;
	  var blue = 0;
	  if (huePrime >= 0 && huePrime < 1) {
	    red = chroma;
	    green = secondComponent;
	  } else if (huePrime >= 1 && huePrime < 2) {
	    red = secondComponent;
	    green = chroma;
	  } else if (huePrime >= 2 && huePrime < 3) {
	    green = chroma;
	    blue = secondComponent;
	  } else if (huePrime >= 3 && huePrime < 4) {
	    green = secondComponent;
	    blue = chroma;
	  } else if (huePrime >= 4 && huePrime < 5) {
	    red = secondComponent;
	    blue = chroma;
	  } else if (huePrime >= 5 && huePrime < 6) {
	    red = chroma;
	    blue = secondComponent;
	  }
	  var lightnessModification = lightness - chroma / 2;
	  var finalRed = red + lightnessModification;
	  var finalGreen = green + lightnessModification;
	  var finalBlue = blue + lightnessModification;
	  return convert(finalRed, finalGreen, finalBlue);
	}
	var namedColorMap = {
	  aliceblue: "f0f8ff",
	  antiquewhite: "faebd7",
	  aqua: "00ffff",
	  aquamarine: "7fffd4",
	  azure: "f0ffff",
	  beige: "f5f5dc",
	  bisque: "ffe4c4",
	  black: "000",
	  blanchedalmond: "ffebcd",
	  blue: "0000ff",
	  blueviolet: "8a2be2",
	  brown: "a52a2a",
	  burlywood: "deb887",
	  cadetblue: "5f9ea0",
	  chartreuse: "7fff00",
	  chocolate: "d2691e",
	  coral: "ff7f50",
	  cornflowerblue: "6495ed",
	  cornsilk: "fff8dc",
	  crimson: "dc143c",
	  cyan: "00ffff",
	  darkblue: "00008b",
	  darkcyan: "008b8b",
	  darkgoldenrod: "b8860b",
	  darkgray: "a9a9a9",
	  darkgreen: "006400",
	  darkgrey: "a9a9a9",
	  darkkhaki: "bdb76b",
	  darkmagenta: "8b008b",
	  darkolivegreen: "556b2f",
	  darkorange: "ff8c00",
	  darkorchid: "9932cc",
	  darkred: "8b0000",
	  darksalmon: "e9967a",
	  darkseagreen: "8fbc8f",
	  darkslateblue: "483d8b",
	  darkslategray: "2f4f4f",
	  darkslategrey: "2f4f4f",
	  darkturquoise: "00ced1",
	  darkviolet: "9400d3",
	  deeppink: "ff1493",
	  deepskyblue: "00bfff",
	  dimgray: "696969",
	  dimgrey: "696969",
	  dodgerblue: "1e90ff",
	  firebrick: "b22222",
	  floralwhite: "fffaf0",
	  forestgreen: "228b22",
	  fuchsia: "ff00ff",
	  gainsboro: "dcdcdc",
	  ghostwhite: "f8f8ff",
	  gold: "ffd700",
	  goldenrod: "daa520",
	  gray: "808080",
	  green: "008000",
	  greenyellow: "adff2f",
	  grey: "808080",
	  honeydew: "f0fff0",
	  hotpink: "ff69b4",
	  indianred: "cd5c5c",
	  indigo: "4b0082",
	  ivory: "fffff0",
	  khaki: "f0e68c",
	  lavender: "e6e6fa",
	  lavenderblush: "fff0f5",
	  lawngreen: "7cfc00",
	  lemonchiffon: "fffacd",
	  lightblue: "add8e6",
	  lightcoral: "f08080",
	  lightcyan: "e0ffff",
	  lightgoldenrodyellow: "fafad2",
	  lightgray: "d3d3d3",
	  lightgreen: "90ee90",
	  lightgrey: "d3d3d3",
	  lightpink: "ffb6c1",
	  lightsalmon: "ffa07a",
	  lightseagreen: "20b2aa",
	  lightskyblue: "87cefa",
	  lightslategray: "789",
	  lightslategrey: "789",
	  lightsteelblue: "b0c4de",
	  lightyellow: "ffffe0",
	  lime: "0f0",
	  limegreen: "32cd32",
	  linen: "faf0e6",
	  magenta: "f0f",
	  maroon: "800000",
	  mediumaquamarine: "66cdaa",
	  mediumblue: "0000cd",
	  mediumorchid: "ba55d3",
	  mediumpurple: "9370db",
	  mediumseagreen: "3cb371",
	  mediumslateblue: "7b68ee",
	  mediumspringgreen: "00fa9a",
	  mediumturquoise: "48d1cc",
	  mediumvioletred: "c71585",
	  midnightblue: "191970",
	  mintcream: "f5fffa",
	  mistyrose: "ffe4e1",
	  moccasin: "ffe4b5",
	  navajowhite: "ffdead",
	  navy: "000080",
	  oldlace: "fdf5e6",
	  olive: "808000",
	  olivedrab: "6b8e23",
	  orange: "ffa500",
	  orangered: "ff4500",
	  orchid: "da70d6",
	  palegoldenrod: "eee8aa",
	  palegreen: "98fb98",
	  paleturquoise: "afeeee",
	  palevioletred: "db7093",
	  papayawhip: "ffefd5",
	  peachpuff: "ffdab9",
	  peru: "cd853f",
	  pink: "ffc0cb",
	  plum: "dda0dd",
	  powderblue: "b0e0e6",
	  purple: "800080",
	  rebeccapurple: "639",
	  red: "f00",
	  rosybrown: "bc8f8f",
	  royalblue: "4169e1",
	  saddlebrown: "8b4513",
	  salmon: "fa8072",
	  sandybrown: "f4a460",
	  seagreen: "2e8b57",
	  seashell: "fff5ee",
	  sienna: "a0522d",
	  silver: "c0c0c0",
	  skyblue: "87ceeb",
	  slateblue: "6a5acd",
	  slategray: "708090",
	  slategrey: "708090",
	  snow: "fffafa",
	  springgreen: "00ff7f",
	  steelblue: "4682b4",
	  tan: "d2b48c",
	  teal: "008080",
	  thistle: "d8bfd8",
	  tomato: "ff6347",
	  turquoise: "40e0d0",
	  violet: "ee82ee",
	  wheat: "f5deb3",
	  white: "fff",
	  whitesmoke: "f5f5f5",
	  yellow: "ff0",
	  yellowgreen: "9acd32"
	};
	function nameToHex(color2) {
	  if (typeof color2 !== "string")
	    return color2;
	  var normalizedColorName = color2.toLowerCase();
	  return namedColorMap[normalizedColorName] ? "#" + namedColorMap[normalizedColorName] : color2;
	}
	var hexRegex = /^#[a-fA-F0-9]{6}$/;
	var hexRgbaRegex = /^#[a-fA-F0-9]{8}$/;
	var reducedHexRegex = /^#[a-fA-F0-9]{3}$/;
	var reducedRgbaHexRegex = /^#[a-fA-F0-9]{4}$/;
	var rgbRegex = /^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/i;
	var rgbaRegex = /^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i;
	var hslRegex = /^hsl\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*\)$/i;
	var hslaRegex = /^hsla\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i;
	function parseToRgb(color2) {
	  if (typeof color2 !== "string") {
	    throw new PolishedError(3);
	  }
	  var normalizedColor = nameToHex(color2);
	  if (normalizedColor.match(hexRegex)) {
	    return {
	      red: parseInt("" + normalizedColor[1] + normalizedColor[2], 16),
	      green: parseInt("" + normalizedColor[3] + normalizedColor[4], 16),
	      blue: parseInt("" + normalizedColor[5] + normalizedColor[6], 16)
	    };
	  }
	  if (normalizedColor.match(hexRgbaRegex)) {
	    var alpha = parseFloat((parseInt("" + normalizedColor[7] + normalizedColor[8], 16) / 255).toFixed(2));
	    return {
	      red: parseInt("" + normalizedColor[1] + normalizedColor[2], 16),
	      green: parseInt("" + normalizedColor[3] + normalizedColor[4], 16),
	      blue: parseInt("" + normalizedColor[5] + normalizedColor[6], 16),
	      alpha
	    };
	  }
	  if (normalizedColor.match(reducedHexRegex)) {
	    return {
	      red: parseInt("" + normalizedColor[1] + normalizedColor[1], 16),
	      green: parseInt("" + normalizedColor[2] + normalizedColor[2], 16),
	      blue: parseInt("" + normalizedColor[3] + normalizedColor[3], 16)
	    };
	  }
	  if (normalizedColor.match(reducedRgbaHexRegex)) {
	    var _alpha = parseFloat((parseInt("" + normalizedColor[4] + normalizedColor[4], 16) / 255).toFixed(2));
	    return {
	      red: parseInt("" + normalizedColor[1] + normalizedColor[1], 16),
	      green: parseInt("" + normalizedColor[2] + normalizedColor[2], 16),
	      blue: parseInt("" + normalizedColor[3] + normalizedColor[3], 16),
	      alpha: _alpha
	    };
	  }
	  var rgbMatched = rgbRegex.exec(normalizedColor);
	  if (rgbMatched) {
	    return {
	      red: parseInt("" + rgbMatched[1], 10),
	      green: parseInt("" + rgbMatched[2], 10),
	      blue: parseInt("" + rgbMatched[3], 10)
	    };
	  }
	  var rgbaMatched = rgbaRegex.exec(normalizedColor.substring(0, 50));
	  if (rgbaMatched) {
	    return {
	      red: parseInt("" + rgbaMatched[1], 10),
	      green: parseInt("" + rgbaMatched[2], 10),
	      blue: parseInt("" + rgbaMatched[3], 10),
	      alpha: parseFloat("" + rgbaMatched[4])
	    };
	  }
	  var hslMatched = hslRegex.exec(normalizedColor);
	  if (hslMatched) {
	    var hue = parseInt("" + hslMatched[1], 10);
	    var saturation = parseInt("" + hslMatched[2], 10) / 100;
	    var lightness = parseInt("" + hslMatched[3], 10) / 100;
	    var rgbColorString = "rgb(" + hslToRgb(hue, saturation, lightness) + ")";
	    var hslRgbMatched = rgbRegex.exec(rgbColorString);
	    if (!hslRgbMatched) {
	      throw new PolishedError(4, normalizedColor, rgbColorString);
	    }
	    return {
	      red: parseInt("" + hslRgbMatched[1], 10),
	      green: parseInt("" + hslRgbMatched[2], 10),
	      blue: parseInt("" + hslRgbMatched[3], 10)
	    };
	  }
	  var hslaMatched = hslaRegex.exec(normalizedColor.substring(0, 50));
	  if (hslaMatched) {
	    var _hue = parseInt("" + hslaMatched[1], 10);
	    var _saturation = parseInt("" + hslaMatched[2], 10) / 100;
	    var _lightness = parseInt("" + hslaMatched[3], 10) / 100;
	    var _rgbColorString = "rgb(" + hslToRgb(_hue, _saturation, _lightness) + ")";
	    var _hslRgbMatched = rgbRegex.exec(_rgbColorString);
	    if (!_hslRgbMatched) {
	      throw new PolishedError(4, normalizedColor, _rgbColorString);
	    }
	    return {
	      red: parseInt("" + _hslRgbMatched[1], 10),
	      green: parseInt("" + _hslRgbMatched[2], 10),
	      blue: parseInt("" + _hslRgbMatched[3], 10),
	      alpha: parseFloat("" + hslaMatched[4])
	    };
	  }
	  throw new PolishedError(5);
	}
	function rgbToHsl(color2) {
	  var red = color2.red / 255;
	  var green = color2.green / 255;
	  var blue = color2.blue / 255;
	  var max = Math.max(red, green, blue);
	  var min = Math.min(red, green, blue);
	  var lightness = (max + min) / 2;
	  if (max === min) {
	    if (color2.alpha !== void 0) {
	      return {
	        hue: 0,
	        saturation: 0,
	        lightness,
	        alpha: color2.alpha
	      };
	    } else {
	      return {
	        hue: 0,
	        saturation: 0,
	        lightness
	      };
	    }
	  }
	  var hue;
	  var delta = max - min;
	  var saturation = lightness > 0.5 ? delta / (2 - max - min) : delta / (max + min);
	  switch (max) {
	    case red:
	      hue = (green - blue) / delta + (green < blue ? 6 : 0);
	      break;
	    case green:
	      hue = (blue - red) / delta + 2;
	      break;
	    default:
	      hue = (red - green) / delta + 4;
	      break;
	  }
	  hue *= 60;
	  if (color2.alpha !== void 0) {
	    return {
	      hue,
	      saturation,
	      lightness,
	      alpha: color2.alpha
	    };
	  }
	  return {
	    hue,
	    saturation,
	    lightness
	  };
	}
	function parseToHsl(color2) {
	  return rgbToHsl(parseToRgb(color2));
	}
	var reduceHexValue = function reduceHexValue2(value) {
	  if (value.length === 7 && value[1] === value[2] && value[3] === value[4] && value[5] === value[6]) {
	    return "#" + value[1] + value[3] + value[5];
	  }
	  return value;
	};
	function numberToHex(value) {
	  var hex = value.toString(16);
	  return hex.length === 1 ? "0" + hex : hex;
	}
	function colorToHex(color2) {
	  return numberToHex(Math.round(color2 * 255));
	}
	function convertToHex(red, green, blue) {
	  return reduceHexValue("#" + colorToHex(red) + colorToHex(green) + colorToHex(blue));
	}
	function hslToHex(hue, saturation, lightness) {
	  return hslToRgb(hue, saturation, lightness, convertToHex);
	}
	function hsl(value, saturation, lightness) {
	  if (typeof value === "number" && typeof saturation === "number" && typeof lightness === "number") {
	    return hslToHex(value, saturation, lightness);
	  } else if (typeof value === "object" && saturation === void 0 && lightness === void 0) {
	    return hslToHex(value.hue, value.saturation, value.lightness);
	  }
	  throw new PolishedError(1);
	}
	function hsla(value, saturation, lightness, alpha) {
	  if (typeof value === "number" && typeof saturation === "number" && typeof lightness === "number" && typeof alpha === "number") {
	    return alpha >= 1 ? hslToHex(value, saturation, lightness) : "rgba(" + hslToRgb(value, saturation, lightness) + "," + alpha + ")";
	  } else if (typeof value === "object" && saturation === void 0 && lightness === void 0 && alpha === void 0) {
	    return value.alpha >= 1 ? hslToHex(value.hue, value.saturation, value.lightness) : "rgba(" + hslToRgb(value.hue, value.saturation, value.lightness) + "," + value.alpha + ")";
	  }
	  throw new PolishedError(2);
	}
	function rgb(value, green, blue) {
	  if (typeof value === "number" && typeof green === "number" && typeof blue === "number") {
	    return reduceHexValue("#" + numberToHex(value) + numberToHex(green) + numberToHex(blue));
	  } else if (typeof value === "object" && green === void 0 && blue === void 0) {
	    return reduceHexValue("#" + numberToHex(value.red) + numberToHex(value.green) + numberToHex(value.blue));
	  }
	  throw new PolishedError(6);
	}
	function rgba(firstValue, secondValue, thirdValue, fourthValue) {
	  if (typeof firstValue === "string" && typeof secondValue === "number") {
	    var rgbValue = parseToRgb(firstValue);
	    return "rgba(" + rgbValue.red + "," + rgbValue.green + "," + rgbValue.blue + "," + secondValue + ")";
	  } else if (typeof firstValue === "number" && typeof secondValue === "number" && typeof thirdValue === "number" && typeof fourthValue === "number") {
	    return fourthValue >= 1 ? rgb(firstValue, secondValue, thirdValue) : "rgba(" + firstValue + "," + secondValue + "," + thirdValue + "," + fourthValue + ")";
	  } else if (typeof firstValue === "object" && secondValue === void 0 && thirdValue === void 0 && fourthValue === void 0) {
	    return firstValue.alpha >= 1 ? rgb(firstValue.red, firstValue.green, firstValue.blue) : "rgba(" + firstValue.red + "," + firstValue.green + "," + firstValue.blue + "," + firstValue.alpha + ")";
	  }
	  throw new PolishedError(7);
	}
	var isRgb = function isRgb2(color2) {
	  return typeof color2.red === "number" && typeof color2.green === "number" && typeof color2.blue === "number" && (typeof color2.alpha !== "number" || typeof color2.alpha === "undefined");
	};
	var isRgba = function isRgba2(color2) {
	  return typeof color2.red === "number" && typeof color2.green === "number" && typeof color2.blue === "number" && typeof color2.alpha === "number";
	};
	var isHsl = function isHsl2(color2) {
	  return typeof color2.hue === "number" && typeof color2.saturation === "number" && typeof color2.lightness === "number" && (typeof color2.alpha !== "number" || typeof color2.alpha === "undefined");
	};
	var isHsla = function isHsla2(color2) {
	  return typeof color2.hue === "number" && typeof color2.saturation === "number" && typeof color2.lightness === "number" && typeof color2.alpha === "number";
	};
	function toColorString(color2) {
	  if (typeof color2 !== "object")
	    throw new PolishedError(8);
	  if (isRgba(color2))
	    return rgba(color2);
	  if (isRgb(color2))
	    return rgb(color2);
	  if (isHsla(color2))
	    return hsla(color2);
	  if (isHsl(color2))
	    return hsl(color2);
	  throw new PolishedError(8);
	}
	function curried(f2, length, acc) {
	  return function fn2() {
	    var combined = acc.concat(Array.prototype.slice.call(arguments));
	    return combined.length >= length ? f2.apply(this, combined) : curried(f2, length, combined);
	  };
	}
	function curry(f2) {
	  return curried(f2, f2.length, []);
	}
	function guard(lowerBoundary, upperBoundary, value) {
	  return Math.max(lowerBoundary, Math.min(upperBoundary, value));
	}
	function darken(amount, color2) {
	  if (color2 === "transparent")
	    return color2;
	  var hslColor = parseToHsl(color2);
	  return toColorString(_extends({}, hslColor, {
	    lightness: guard(0, 1, hslColor.lightness - parseFloat(amount))
	  }));
	}
	var curriedDarken = /* @__PURE__ */ curry(darken);
	function lighten(amount, color2) {
	  if (color2 === "transparent")
	    return color2;
	  var hslColor = parseToHsl(color2);
	  return toColorString(_extends({}, hslColor, {
	    lightness: guard(0, 1, hslColor.lightness + parseFloat(amount))
	  }));
	}
	var curriedLighten = /* @__PURE__ */ curry(lighten);
	function transparentize(amount, color2) {
	  if (color2 === "transparent")
	    return color2;
	  var parsedColor = parseToRgb(color2);
	  var alpha = typeof parsedColor.alpha === "number" ? parsedColor.alpha : 1;
	  var colorWithAlpha = _extends({}, parsedColor, {
	    alpha: guard(0, 1, +(alpha * 100 - parseFloat(amount) * 100).toFixed(2) / 100)
	  });
	  return rgba(colorWithAlpha);
	}
	var curriedTransparentize = /* @__PURE__ */ curry(transparentize);
	var positionMap = ["absolute", "fixed", "relative", "static", "sticky"];
	function position(firstValue) {
	  for (var _len = arguments.length, values = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	    values[_key - 1] = arguments[_key];
	  }
	  if (positionMap.indexOf(firstValue) >= 0 && firstValue) {
	    return _extends({}, directionalProperty.apply(void 0, [""].concat(values)), {
	      position: firstValue
	    });
	  } else {
	    return directionalProperty.apply(void 0, ["", firstValue].concat(values));
	  }
	}

	// studio/src/css.ts
	var import_styled_components = __toModule(require$$3);
	var pointerEventsAutoInNormalMode = import_styled_components.css`
  #pointer-root & {
    pointer-events: none;
  }
  #pointer-root.normal & {
    pointer-events: auto;
  }
`;
	var theme = {
	  panel: {
	    bg: `#282b2f`,
	    head: {
	      title: {
	        color: `#bbb`
	      },
	      punctuation: {
	        color: `#808080`
	      }
	    },
	    body: {
	      compoudThing: {
	        label: {
	          get color() {
	            return curriedLighten(0.6, theme.panel.bg);
	          }
	        }
	      }
	    }
	  }
	};

	// studio/src/panels/BasePanel/common.tsx
	var import_styled_components2 = __toModule(require$$3);
	var panelZIndexes = {
	  get outlinePanel() {
	    return 1;
	  },
	  get propsPanel() {
	    return panelZIndexes.outlinePanel;
	  },
	  get sequenceEditorPanel() {
	    return this.outlinePanel - 1;
	  },
	  get toolbar() {
	    return this.outlinePanel + 1;
	  },
	  get pluginPanes() {
	    return this.sequenceEditorPanel - 1;
	  }
	};
	var propsEditorBackground = theme.panel.bg;
	var TitleBar_Piece = import_styled_components2.default.span`
  white-space: nowrap;
`;
	var TitleBar_Punctuation = import_styled_components2.default.span`
  white-space: nowrap;
  color: ${theme.panel.head.punctuation.color};
`;
	var F2 = import_styled_components2.default.div`
  background: ${propsEditorBackground};
  flex-grow: 1;
  overflow-y: scroll;
  padding: 0;
`;
	var titleBarHeight = 20;
	var TitleBar = import_styled_components2.default.div`
  height: ${titleBarHeight}px;
  box-sizing: border-box;
  display: flex;
  align-items: center;
  padding: 0 10px;
  position: relative;
  color: #adadadb3;
  border-bottom: 1px solid rgb(0 0 0 / 13%);
  background-color: #25272b;
  font-size: 10px;
  font-weight: 500;
  overflow: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;
`;

	// studio/src/panels/OutlinePanel/ProjectsList/ProjectsList.tsx
	var import_dataverse8 = __toModule(dist$1);
	var import_react18 = __toModule(react.exports);
	var import_styled_components8 = __toModule(require$$3);

	// studio/src/panels/OutlinePanel/ProjectsList/ProjectListItem.tsx
	var import_react15 = __toModule(react.exports);

	// studio/src/panels/OutlinePanel/BaseItem.tsx
	var import_react4 = __toModule(react.exports);

	// ../node_modules/react-icons/lib/esm/iconBase.js
	var import_react3 = __toModule(react.exports);

	// ../node_modules/react-icons/lib/esm/iconContext.js
	var import_react2 = __toModule(react.exports);
	var DefaultContext = {
	  color: void 0,
	  size: void 0,
	  className: void 0,
	  style: void 0,
	  attr: void 0
	};
	var IconContext = import_react2.default.createContext && import_react2.default.createContext(DefaultContext);

	// ../node_modules/react-icons/lib/esm/iconBase.js
	var __assign = function() {
	  __assign = Object.assign || function(t2) {
	    for (var s2, i2 = 1, n2 = arguments.length; i2 < n2; i2++) {
	      s2 = arguments[i2];
	      for (var p2 in s2)
	        if (Object.prototype.hasOwnProperty.call(s2, p2))
	          t2[p2] = s2[p2];
	    }
	    return t2;
	  };
	  return __assign.apply(this, arguments);
	};
	var __rest = function(s2, e) {
	  var t2 = {};
	  for (var p2 in s2)
	    if (Object.prototype.hasOwnProperty.call(s2, p2) && e.indexOf(p2) < 0)
	      t2[p2] = s2[p2];
	  if (s2 != null && typeof Object.getOwnPropertySymbols === "function")
	    for (var i2 = 0, p2 = Object.getOwnPropertySymbols(s2); i2 < p2.length; i2++) {
	      if (e.indexOf(p2[i2]) < 0 && Object.prototype.propertyIsEnumerable.call(s2, p2[i2]))
	        t2[p2[i2]] = s2[p2[i2]];
	    }
	  return t2;
	};
	function Tree2Element(tree) {
	  return tree && tree.map(function(node, i2) {
	    return import_react3.default.createElement(node.tag, __assign({
	      key: i2
	    }, node.attr), Tree2Element(node.child));
	  });
	}
	function GenIcon(data) {
	  return function(props) {
	    return import_react3.default.createElement(IconBase, __assign({
	      attr: __assign({}, data.attr)
	    }, props), Tree2Element(data.child));
	  };
	}
	function IconBase(props) {
	  var elem = function(conf) {
	    var attr = props.attr, size = props.size, title = props.title, svgProps = __rest(props, ["attr", "size", "title"]);
	    var computedSize = size || conf.size || "1em";
	    var className;
	    if (conf.className)
	      className = conf.className;
	    if (props.className)
	      className = (className ? className + " " : "") + props.className;
	    return import_react3.default.createElement("svg", __assign({
	      stroke: "currentColor",
	      fill: "currentColor",
	      strokeWidth: "0"
	    }, conf.attr, attr, svgProps, {
	      className,
	      style: __assign(__assign({
	        color: props.color || conf.color
	      }, conf.style), props.style),
	      height: computedSize,
	      width: computedSize,
	      xmlns: "http://www.w3.org/2000/svg"
	    }), title && import_react3.default.createElement("title", null, title), props.children);
	  };
	  return IconContext !== void 0 ? import_react3.default.createElement(IconContext.Consumer, null, function(conf) {
	    return elem(conf);
	  }) : elem(DefaultContext);
	}

	// ../node_modules/react-icons/io5/index.esm.js
	function IoClose(props) {
	  return GenIcon({ "tag": "svg", "attr": { "viewBox": "0 0 512 512" }, "child": [{ "tag": "path", "attr": { "d": "M289.94 256l95-95A24 24 0 00351 127l-95 95-95-95a24 24 0 00-34 34l95 95-95 95a24 24 0 1034 34l95-95 95 95a24 24 0 0034-34z" } }] })(props);
	}

	// ../node_modules/react-icons/go/index.esm.js
	function GoChevronLeft(props) {
	  return GenIcon({ "tag": "svg", "attr": { "viewBox": "0 0 8 16" }, "child": [{ "tag": "path", "attr": { "fillRule": "evenodd", "d": "M5.5 3L7 4.5 3.25 8 7 11.5 5.5 13l-5-5 5-5z" } }] })(props);
	}
	function GoChevronRight(props) {
	  return GenIcon({ "tag": "svg", "attr": { "viewBox": "0 0 8 16" }, "child": [{ "tag": "path", "attr": { "fillRule": "evenodd", "d": "M7.5 8l-5 5L1 11.5 4.75 8 1 4.5 2.5 3l5 5z" } }] })(props);
	}

	// ../node_modules/react-icons/di/index.esm.js
	function DiHtml53DEffects(props) {
	  return GenIcon({ "tag": "svg", "attr": { "version": "1.1", "viewBox": "0 0 32 32" }, "child": [{ "tag": "path", "attr": { "d": "M16.957 6.062l-5.808 1.88 12.58 4.070v8.027l-8.383 2.711-7.074-2.287v-7.863l6.836 2.213 5.808-1.879-12.598-4.077-3.622 1.172v13.036l10.649 3.445 11.958-3.869v-13.23z" } }] })(props);
	}

	// ../node_modules/react-icons/hi/index.esm.js
	function HiOutlineChevronRight(props) {
	  return GenIcon({ "tag": "svg", "attr": { "fill": "none", "viewBox": "0 0 24 24", "stroke": "currentColor" }, "child": [{ "tag": "path", "attr": { "strokeLinecap": "round", "strokeLinejoin": "round", "strokeWidth": "2", "d": "M9 5l7 7-7 7" } }] })(props);
	}

	// ../node_modules/react-icons/cg/index.esm.js
	function CgSelect(props) {
	  return GenIcon({ "tag": "svg", "attr": { "viewBox": "0 0 24 24", "fill": "none" }, "child": [{ "tag": "path", "attr": { "d": "M6 9.65685L7.41421 11.0711L11.6569 6.82843L15.8995 11.0711L17.3137 9.65685L11.6569 4L6 9.65685Z", "fill": "currentColor" } }, { "tag": "path", "attr": { "d": "M6 14.4433L7.41421 13.0291L11.6569 17.2717L15.8995 13.0291L17.3137 14.4433L11.6569 20.1001L6 14.4433Z", "fill": "currentColor" } }] })(props);
	}

	// ../node_modules/react-icons/vsc/index.esm.js
	function VscListTree(props) {
	  return GenIcon({ "tag": "svg", "attr": { "viewBox": "0 0 16 16", "fill": "currentColor" }, "child": [{ "tag": "path", "attr": { "d": "M14 3v1H2V3h12zm-1 3v1H6V6h7zm0 3v1H5V9h8zm0 3v1H5v-1h8z" } }, { "tag": "path", "attr": { "d": "M5 4h1v9H5z" } }] })(props);
	}
	function VscTriangleUp(props) {
	  return GenIcon({ "tag": "svg", "attr": { "viewBox": "0 0 16 16", "fill": "currentColor" }, "child": [{ "tag": "path", "attr": { "d": "M14 10.44l-.413.56H2.393L2 10.46 7.627 5h.827L14 10.44z" } }] })(props);
	}

	// studio/src/panels/OutlinePanel/BaseItem.tsx
	var import_styled_components3 = __toModule(require$$3);

	// shared/src/utils/noop.ts
	var noop2 = () => {
	};
	var noop_default2 = noop2;

	// studio/src/panels/OutlinePanel/BaseItem.tsx
	var Container = import_styled_components3.default.li`
  margin: 0;
  padding: 0;
  list-style: none;
  display: flex;
  justify-content: flex-start;
  flex-direction: column;
  align-items: flex-start;
`;
	var BaseHeader = import_styled_components3.default.div``;
	var baseBg = `#3e4447`;
	var baseBorderColor = `#34343e`;
	var Header = (0, import_styled_components3.default)(BaseHeader)`
  padding-left: calc(4px + var(--depth) * 16px);
  padding-right: 8px;
  height: 28px;
  box-sizing: border-box;
  display: flex;
  flex-wrap: nowrap;
  align-items: center;
  pointer-events: none;
  white-space: nowrap;

  color: rgba(255, 255, 255, 0.75);
  --item-bg: ${baseBg};
  --item-border-color: ${baseBorderColor};

  &.descendant-is-selected {
    color: rgba(255, 255, 255, 0.9);

    --item-bg: #2e4244ed;
    --item-border-color: #254355;
  }

  &:hover {
    color: #fff;

    --item-bg: #1e5866;
    --item-border-color: #152f42;
  }

  &.selected {
    color: rgba(255, 255, 255, 0.9);

    --item-bg: #1e5866;
    --item-border-color: #152f42;
  }
`;
	var outlineItemFont = import_styled_components3.css`
  font-weight: 500;
  font-size: 11px;
  & {
  }
`;
	var Head_Label = import_styled_components3.default.span`
  ${outlineItemFont};

  padding: 2px 8px;
  ${pointerEventsAutoInNormalMode};
  position: relative;
  display: flex;
  height: 17px;
  align-items: center;

  background-color: var(--item-bg);

  &:after {
    border: 1px solid var(--item-border-color);
    position: absolute;
    inset: 0px;
    display: block;
    content: ' ';
    z-index: -1;
    pointer-events: none;
    border-radius: 2px;
    box-sizing: border-box;
    box-shadow: 0px 3px 4px -1px rgba(0, 0, 0, 0.48);
  }

  // hit-zone
  &:before {
    position: absolute;
    inset: -1px -20px;
    display: block;
    content: ' ';
    z-index: 0;
    ${pointerEventsAutoInNormalMode};
  }
`;
	var Head_IconContainer = import_styled_components3.default.span`
  width: 18px;
  box-sizing: border-box;
  height: 18px;
  margin-right: 4px;
  font-weight: 500;
  display: flex;
  align-items: center;
  justify-content: center;
  position: relative;
  opacity: 0.99;

  &:after {
    display: block;
    content: ' ';
    position: absolute;
    inset: 0px;
    z-index: -1;
    background-color: var(--item-bg);
    opacity: 0.6;
    border-radius: 2px;
  }
`;
	var Head_Icon_WithDescendants = import_styled_components3.default.span`
  font-size: 9px;
  position: relative;
  display: block;
  transform: rotateZ(${(props) => props.isOpen ? 90 : 0}deg);
`;
	var ChildrenContainer = import_styled_components3.default.ul`
  margin: 0;
  padding: 0;
  list-style: none;
`;
	var BaseItem = ({ label, children, depth, select, selectionStatus, labelDecoration }) => {
	  const canContainChildren = children !== void 0;
	  return /* @__PURE__ */ import_react4.default.createElement(Container, {
	    style: { "--depth": depth }
	  }, /* @__PURE__ */ import_react4.default.createElement(Header, {
	    className: selectionStatus,
	    onClick: select != null ? select : noop_default2
	  }, /* @__PURE__ */ import_react4.default.createElement(Head_IconContainer, null, canContainChildren ? /* @__PURE__ */ import_react4.default.createElement(Head_Icon_WithDescendants, {
	    isOpen: true
	  }, /* @__PURE__ */ import_react4.default.createElement(GoChevronRight, null)) : /* @__PURE__ */ import_react4.default.createElement(DiHtml53DEffects, null)), /* @__PURE__ */ import_react4.default.createElement(Head_Label, null, /* @__PURE__ */ import_react4.default.createElement("span", null, label)), labelDecoration), canContainChildren && /* @__PURE__ */ import_react4.default.createElement(ChildrenContainer, null, children));
	};
	var BaseItem_default = BaseItem;

	// studio/src/selectors.ts
	var import_dataverse4 = __toModule(dist$1);
	var getOutlineSelection = () => {
	  var _a;
	  const projects = (0, import_dataverse4.val)(getStudio().projectsP);
	  const mapped = ((_a = (0, import_dataverse4.val)(getStudio().atomP.historic.panels.outlinePanel.selection)) != null ? _a : []).map((s2) => {
	    const project = projects[s2.projectId];
	    if (!project)
	      return;
	    if (s2.type === "Project")
	      return project;
	    const sheetTemplate = (0, import_dataverse4.val)(project.sheetTemplatesP[s2.sheetId]);
	    if (!sheetTemplate) {
	      return;
	    }
	    const sheetInstance = getSelectedInstanceOfSheetId(project, s2.sheetId);
	    if (!sheetInstance)
	      return;
	    if (s2.type === "Sheet") {
	      return sheetInstance;
	    }
	    const obj = (0, import_dataverse4.val)(sheetInstance.objectsP[s2.objectKey]);
	    if (!obj)
	      return;
	    return obj;
	  });
	  return uniq_default(mapped.filter((s2) => typeof s2 !== "undefined"));
	};
	var getSelectedInstanceOfSheetId = (project, selectedSheetId) => {
	  const projectStateP = getStudio().atomP.historic.projects.stateByProjectId[project.address.projectId];
	  const instanceId = (0, import_dataverse4.val)(projectStateP.stateBySheetId[selectedSheetId].selectedInstanceId);
	  const template = (0, import_dataverse4.val)(project.sheetTemplatesP[selectedSheetId]);
	  if (!template)
	    return void 0;
	  if (instanceId) {
	    return (0, import_dataverse4.val)(template.instancesP[instanceId]);
	  } else {
	    const allInstances = (0, import_dataverse4.val)(template.instancesP);
	    return allInstances[Object.keys(allInstances)[0]];
	  }
	};
	function getRegisteredSheetIds(project) {
	  return Object.keys((0, import_dataverse4.val)(project.sheetTemplatesP));
	}
	function getSelectedSequence() {
	  const selectedSheets = uniq_default(getOutlineSelection().filter((s2) => isSheet(s2) || isSheetObject(s2)).map((s2) => isSheetObject(s2) ? s2.sheet : s2));
	  const sheet = selectedSheets[0];
	  if (!sheet)
	    return;
	  return sheet.getSequence();
	}

	// studio/src/panels/OutlinePanel/SheetsList/SheetsList.tsx
	var import_react14 = __toModule(react.exports);

	// studio/src/panels/OutlinePanel/SheetsList/SheetItem.tsx
	var import_dataverse6 = __toModule(dist$1);
	var import_react12 = __toModule(react.exports);
	var import_styled_components6 = __toModule(require$$3);

	// studio/src/panels/OutlinePanel/SheetsList/SheetInstanceItem.tsx
	var import_react10 = __toModule(react.exports);
	var import_styled_components5 = __toModule(require$$3);

	// studio/src/panels/OutlinePanel/ObjectsList/ObjectsList.tsx
	var import_dataverse5 = __toModule(dist$1);
	var import_react8 = __toModule(react.exports);
	var import_styled_components4 = __toModule(require$$3);

	// studio/src/panels/OutlinePanel/ObjectsList/ObjectItem.tsx
	var import_react5 = __toModule(react.exports);
	var ObjectItem = ({ sheetObject, depth }) => {
	  const select = () => {
	    getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	      stateEditors2.studio.historic.panels.outline.selection.set([sheetObject]);
	    });
	  };
	  const selection = usePrism(() => getOutlineSelection(), []);
	  return /* @__PURE__ */ import_react5.default.createElement(BaseItem_default, {
	    select,
	    label: sheetObject.address.objectKey,
	    depth,
	    selectionStatus: selection.includes(sheetObject) ? "selected" : "not-selected"
	  });
	};

	// studio/src/panels/OutlinePanel/ObjectsList/ObjectsList.tsx
	import_styled_components4.default.li`
  color: ${(props) => props.isSelected ? "white" : "hsl(1, 1%, 80%)"};
`;
	var ObjectsList = ({ sheet, depth }) => {
	  return usePrism(() => {
	    const objects = (0, import_dataverse5.val)(sheet.objectsP);
	    const objectsEntries = Object.entries(objects);
	    return /* @__PURE__ */ import_react8.default.createElement(import_react8.default.Fragment, null, objectsEntries.map(([objectPath, object]) => {
	      return /* @__PURE__ */ import_react8.default.createElement(ObjectItem, {
	        depth,
	        key: "objectPath(" + objectPath + ")",
	        sheetObject: object
	      });
	    }));
	  }, [sheet, depth]);
	};
	var ObjectsList_default = ObjectsList;

	// studio/src/panels/OutlinePanel/SheetsList/SheetInstanceItem.tsx
	var Head = import_styled_components5.default.div`
  display: flex;
`;
	import_styled_components5.default.li`
  color: ${(props) => props.isSelected ? "white" : "hsl(1, 1%, 80%)"};
`;
	var Body = import_styled_components5.default.div``;
	var SheetInstanceItem = ({ sheet, depth }) => {
	  const setSelectedSheet = (0, import_react10.useCallback)(() => {
	    getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	      stateEditors2.studio.historic.panels.outline.selection.set([sheet]);
	    });
	  }, [sheet]);
	  return usePrism(() => {
	    const selection = getOutlineSelection();
	    return /* @__PURE__ */ import_react10.default.createElement(BaseItem_default, {
	      depth,
	      select: setSelectedSheet,
	      selectionStatus: selection.some((s2) => s2 === sheet) ? "selected" : selection.some((s2) => s2.type === "Theatre_SheetObject" && s2.sheet === sheet) ? "descendant-is-selected" : "not-selected",
	      label: /* @__PURE__ */ import_react10.default.createElement(Head, null, sheet.address.sheetId, ": ", sheet.address.sheetInstanceId)
	    }, /* @__PURE__ */ import_react10.default.createElement(Body, null, /* @__PURE__ */ import_react10.default.createElement(ObjectsList_default, {
	      depth: depth + 1,
	      sheet,
	      key: "objectList" + sheet.address.sheetInstanceId
	    })));
	  }, [depth]);
	};

	// studio/src/panels/OutlinePanel/SheetsList/SheetItem.tsx
	import_styled_components6.default.div`
  display: flex;
`;
	import_styled_components6.default.li`
  color: ${(props) => props.isSelected ? "white" : "hsl(1, 1%, 80%)"};
`;
	import_styled_components6.default.div``;
	var SheetItem = ({ sheetId, depth, project }) => {
	  return usePrism(() => {
	    const template = (0, import_dataverse6.val)(project.sheetTemplatesP[sheetId]);
	    if (!template)
	      return /* @__PURE__ */ import_react12.default.createElement(import_react12.default.Fragment, null);
	    const allInstances = (0, import_dataverse6.val)(template.instancesP);
	    return /* @__PURE__ */ import_react12.default.createElement(import_react12.default.Fragment, null, Object.entries(allInstances).map(([_2, inst]) => {
	      return /* @__PURE__ */ import_react12.default.createElement(SheetInstanceItem, {
	        key: inst.address.sheetInstanceId,
	        sheet: inst,
	        depth
	      });
	    }));
	  }, [depth, sheetId, project]);
	};

	// studio/src/panels/OutlinePanel/SheetsList/SheetsList.tsx
	var SheetsList = ({ project, depth }) => {
	  return usePrism(() => {
	    if (!project)
	      return null;
	    const registeredSheetIds = getRegisteredSheetIds(project);
	    return /* @__PURE__ */ import_react14.default.createElement(import_react14.default.Fragment, null, registeredSheetIds.map((sheetId) => {
	      return /* @__PURE__ */ import_react14.default.createElement(SheetItem, {
	        depth,
	        sheetId,
	        key: `sheet-${sheetId}`,
	        project
	      });
	    }));
	  }, [project, depth]);
	};
	var SheetsList_default = SheetsList;

	// studio/src/panels/OutlinePanel/ProjectsList/ProjectListItem.tsx
	var import_dataverse7 = __toModule(dist$1);
	var import_styled_components7 = __toModule(require$$3);
	var ConflictNotice = import_styled_components7.default.div`
  color: #ff6363;
  margin-left: 11px;
  background: #4c282d;
  padding: 2px 8px;
  border-radius: 2px;
  font-size: 10px;
  box-shadow: 0 2px 8px -4px black;
`;
	var ProjectListItem = ({ depth, project }) => {
	  const selection = usePrism(() => getOutlineSelection(), []);
	  const hasConflict = usePrism(() => {
	    const projectId = project.address.projectId;
	    const loadingState = (0, import_dataverse7.val)(getStudio().atomP.ephemeral.coreByProject[projectId].loadingState);
	    return (loadingState == null ? void 0 : loadingState.type) === "browserStateIsNotBasedOnDiskState";
	  }, [project]);
	  const select = (0, import_react15.useCallback)(() => {
	    getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	      stateEditors2.studio.historic.panels.outline.selection.set([project]);
	    });
	  }, [project]);
	  return /* @__PURE__ */ import_react15.default.createElement(BaseItem_default, {
	    depth,
	    label: project.address.projectId,
	    labelDecoration: hasConflict ? /* @__PURE__ */ import_react15.default.createElement(ConflictNotice, null, "Has Conflicts") : null,
	    children: /* @__PURE__ */ import_react15.default.createElement(SheetsList_default, {
	      project,
	      depth: depth + 1
	    }),
	    selectionStatus: selection.includes(project) ? "selected" : selection.some((s2) => s2.address.projectId === project.address.projectId) ? "descendant-is-selected" : "not-selected",
	    select
	  });
	};
	var ProjectListItem_default = ProjectListItem;

	// studio/src/panels/OutlinePanel/ProjectsList/ProjectsList.tsx
	var Container4 = import_styled_components8.default.ul`
  list-style: none;
  margin: 0;
  padding: 0;
  padding-right: 4px;
`;
	var ProjectsList = (props) => {
	  return usePrism(() => {
	    const projects = (0, import_dataverse8.val)(getStudio().projectsP);
	    return /* @__PURE__ */ import_react18.default.createElement(Container4, null, Object.keys(projects).map((projectId) => {
	      const project = projects[projectId];
	      return /* @__PURE__ */ import_react18.default.createElement(ProjectListItem_default, {
	        depth: 0,
	        project,
	        key: `projectListItem-${projectId}`
	      });
	    }));
	  }, []);
	};
	var ProjectsList_default = ProjectsList;

	// studio/src/uiComponents/toolbar/ToolbarIconButton.tsx
	var import_styled_components13 = __toModule(require$$3);
	var import_react52 = __toModule(react.exports);

	// studio/src/utils/useRefAndState.ts
	var import_react19 = __toModule(react.exports);
	function useRefAndState(initialValue) {
	  const ref = (0, import_react19.useMemo)(() => {
	    let current = initialValue;
	    return {
	      get current() {
	        return current;
	      },
	      set current(v2) {
	        current = v2;
	        setState(v2);
	      }
	    };
	  }, []);
	  const [state, setState] = (0, import_react19.useState)(() => initialValue);
	  return [ref, state];
	}

	// studio/src/uiComponents/Popover/useTooltip.tsx
	var import_react47 = __toModule(react.exports);
	var import_react48 = __toModule(react.exports);
	var import_react49 = __toModule(react.exports);

	// studio/src/uiComponents/Popover/TooltipWrapper.tsx
	var import_react27 = __toModule(react.exports);
	var import_react28 = __toModule(react.exports);

	// ../node_modules/react-use/esm/useWindowSize.js
	var import_react23 = __toModule(react.exports);

	// ../node_modules/react-use/esm/useRafState.js
	var import_react22 = __toModule(react.exports);

	// ../node_modules/react-use/esm/useUnmount.js
	var import_react21 = __toModule(react.exports);

	// ../node_modules/react-use/esm/useEffectOnce.js
	var import_react20 = __toModule(react.exports);
	var useEffectOnce = function(effect) {
	  (0, import_react20.useEffect)(effect, []);
	};
	var useEffectOnce_default = useEffectOnce;

	// ../node_modules/react-use/esm/useUnmount.js
	var useUnmount = function(fn2) {
	  var fnRef = (0, import_react21.useRef)(fn2);
	  fnRef.current = fn2;
	  useEffectOnce_default(function() {
	    return function() {
	      return fnRef.current();
	    };
	  });
	};
	var useUnmount_default = useUnmount;

	// ../node_modules/react-use/esm/useRafState.js
	var useRafState = function(initialState2) {
	  var frame = (0, import_react22.useRef)(0);
	  var _a = (0, import_react22.useState)(initialState2), state = _a[0], setState = _a[1];
	  var setRafState = (0, import_react22.useCallback)(function(value) {
	    cancelAnimationFrame(frame.current);
	    frame.current = requestAnimationFrame(function() {
	      setState(value);
	    });
	  }, []);
	  useUnmount_default(function() {
	    cancelAnimationFrame(frame.current);
	  });
	  return [state, setRafState];
	};
	var useRafState_default = useRafState;

	// ../node_modules/react-use/esm/misc/util.js
	function on(obj) {
	  var args = [];
	  for (var _i = 1; _i < arguments.length; _i++) {
	    args[_i - 1] = arguments[_i];
	  }
	  if (obj && obj.addEventListener) {
	    obj.addEventListener.apply(obj, args);
	  }
	}
	function off(obj) {
	  var args = [];
	  for (var _i = 1; _i < arguments.length; _i++) {
	    args[_i - 1] = arguments[_i];
	  }
	  if (obj && obj.removeEventListener) {
	    obj.removeEventListener.apply(obj, args);
	  }
	}
	var isBrowser = typeof window !== "undefined";

	// ../node_modules/react-use/esm/useWindowSize.js
	var useWindowSize = function(initialWidth, initialHeight) {
	  if (initialWidth === void 0) {
	    initialWidth = Infinity;
	  }
	  if (initialHeight === void 0) {
	    initialHeight = Infinity;
	  }
	  var _a = useRafState_default({
	    width: isBrowser ? window.innerWidth : initialWidth,
	    height: isBrowser ? window.innerHeight : initialHeight
	  }), state = _a[0], setState = _a[1];
	  (0, import_react23.useEffect)(function() {
	    if (isBrowser) {
	      var handler_1 = function() {
	        setState({
	          width: window.innerWidth,
	          height: window.innerHeight
	        });
	      };
	      on(window, "resize", handler_1);
	      return function() {
	        off(window, "resize", handler_1);
	      };
	    }
	  }, []);
	  return state;
	};
	var useWindowSize_default = useWindowSize;

	// studio/src/uiComponents/useBoundingClientRect.ts
	var import_react24 = __toModule(react.exports);
	function useBoundingClientRect(node) {
	  const [bounds, set2] = (0, import_react24.useState)(null);
	  (0, import_react24.useLayoutEffect)(() => {
	    if (node) {
	      set2(node.getBoundingClientRect());
	    }
	    return () => {
	      set2(null);
	    };
	  }, [node]);
	  return bounds;
	}

	// studio/src/uiComponents/Popover/ArrowContext.tsx
	var import_react25 = __toModule(react.exports);
	var ArrowContext = (0, import_react25.createContext)({});
	var ArrowContext_default = ArrowContext;

	// studio/src/uiComponents/useOnClickOutside.ts
	var import_react26 = __toModule(react.exports);
	function useOnClickOutside(container, onOutside) {
	  (0, import_react26.useEffect)(() => {
	    if (!container)
	      return;
	    const onMouseDown = (e) => {
	      if (!e.composedPath().includes(container)) {
	        onOutside(e);
	      }
	    };
	    window.addEventListener("mousedown", onMouseDown, { capture: true });
	    return () => {
	      window.removeEventListener("mousedown", onMouseDown, { capture: true });
	    };
	  }, [container, onOutside]);
	}

	// studio/src/uiComponents/onPointerOutside.ts
	function onPointerOutside(node, threshold, onPointerOutside2) {
	  const containerRect = node.getBoundingClientRect();
	  const onMouseMove = (e) => {
	    if (e.clientX < containerRect.left - threshold || e.clientX > containerRect.left + containerRect.width + threshold || e.clientY < containerRect.top - threshold || e.clientY > containerRect.top + containerRect.height + threshold) {
	      onPointerOutside2(e);
	    }
	  };
	  window.addEventListener("mousemove", onMouseMove);
	  return () => {
	    window.removeEventListener("mousemove", onMouseMove);
	  };
	}

	// studio/src/uiComponents/Popover/TooltipWrapper.tsx
	var minimumDistanceOfArrowToEdgeOfPopover = 8;
	var TooltipWrapper = (props) => {
	  var _a;
	  const originalElement = props.children();
	  const [ref, container] = useRefAndState(null);
	  const style = originalElement.props.style ? __spreadValues({}, originalElement.props.style) : {};
	  style.position = "absolute";
	  const containerRect = useBoundingClientRect(container);
	  const targetRect = useBoundingClientRect(props.target);
	  const windowSize = useWindowSize_default();
	  const [arrowContextValue, setArrowContextValue] = (0, import_react28.useState)({});
	  (0, import_react28.useLayoutEffect)(() => {
	    if (!containerRect || !container || !targetRect)
	      return;
	    const gap = 8;
	    const arrowStyle = {};
	    let verticalPlacement = "bottom";
	    let top = 0;
	    let left = 0;
	    if (targetRect.bottom + containerRect.height + gap < windowSize.height) {
	      verticalPlacement = "bottom";
	      top = targetRect.bottom + gap;
	      arrowStyle.top = "0px";
	    } else if (targetRect.top > containerRect.height + gap) {
	      verticalPlacement = "top";
	      top = targetRect.top - (containerRect.height + gap);
	      arrowStyle.bottom = "0px";
	      arrowStyle.transform = "rotateZ(180deg)";
	    } else {
	      verticalPlacement = "overlay";
	    }
	    let arrowLeft = 0;
	    if (verticalPlacement !== "overlay") {
	      const anchorLeft = targetRect.left + targetRect.width / 2;
	      if (anchorLeft < containerRect.width / 2) {
	        left = gap;
	        arrowLeft = Math.max(anchorLeft - gap, minimumDistanceOfArrowToEdgeOfPopover);
	      } else if (anchorLeft + containerRect.width / 2 > windowSize.width) {
	        left = windowSize.width - (gap + containerRect.width);
	        arrowLeft = Math.min(anchorLeft - left, containerRect.width - minimumDistanceOfArrowToEdgeOfPopover);
	      } else {
	        left = anchorLeft - containerRect.width / 2;
	        arrowLeft = containerRect.width / 2;
	      }
	      arrowStyle.left = arrowLeft + "px";
	    }
	    const pos = { left, top };
	    container.style.left = pos.left + "px";
	    container.style.top = pos.top + "px";
	    setArrowContextValue(arrowStyle);
	    if (props.onPointerOutside) {
	      return onPointerOutside(container, props.onPointerOutside.threshold, props.onPointerOutside.callback);
	    }
	  }, [containerRect, container, props.target, targetRect, windowSize]);
	  useOnClickOutside(container, (_a = props.onClickOutside) != null ? _a : noop_default2);
	  return /* @__PURE__ */ import_react27.default.createElement(ArrowContext_default.Provider, {
	    value: arrowContextValue
	  }, (0, import_react28.cloneElement)(originalElement, { ref, style }));
	};
	var TooltipWrapper_default = TooltipWrapper;

	// studio/src/uiComponents/Popover/useTooltip.tsx
	var import_react_dom4 = __toModule(reactDom.exports);

	// studio/src/uiComponents/Popover/TooltipContext.tsx
	var import_dataverse9 = __toModule(dist$1);
	var import_react29 = __toModule(react.exports);
	var ctx = (0, import_react29.createContext)(null);
	var lastTooltipId = 0;
	var useTooltipOpenState = () => {
	  const id = (0, import_react29.useMemo)(() => lastTooltipId++, []);
	  const { cur, set: set2 } = (0, import_react29.useContext)(ctx);
	  const [isOpenRef, isOpen] = useRefAndState(false);
	  const setIsOpen = (0, import_react29.useCallback)((shouldOpen, delay) => {
	    set2(shouldOpen ? id : -1, delay);
	  }, []);
	  (0, import_react29.useEffect)(() => {
	    return cur.changesWithoutValues().tap(() => {
	      const flag = cur.getValue() === id;
	      if (isOpenRef.current !== flag)
	        isOpenRef.current = flag;
	    });
	  }, [cur, id]);
	  return [isOpen, setIsOpen];
	};
	var TooltipContext = ({ children }) => {
	  const currentTooltipId = (0, import_react29.useMemo)(() => new import_dataverse9.Box(-1), []);
	  const cur = currentTooltipId.derivation;
	  const set2 = (0, import_react29.useMemo)(() => {
	    let lastTimeout = void 0;
	    return (id, delay) => {
	      const overridingPreviousTimeout = lastTimeout !== void 0;
	      if (lastTimeout !== void 0) {
	        clearTimeout(lastTimeout);
	        lastTimeout = void 0;
	      }
	      if (delay === 0 || overridingPreviousTimeout) {
	        currentTooltipId.set(id);
	      } else {
	        lastTimeout = setTimeout(() => {
	          currentTooltipId.set(id);
	          lastTimeout = void 0;
	        }, delay);
	      }
	    };
	  }, []);
	  return /* @__PURE__ */ import_react29.default.createElement(ctx.Provider, {
	    value: { cur, set: set2 }
	  }, children);
	};
	var TooltipContext_default = TooltipContext;

	// ../node_modules/reakit/es/_rollupPluginBabelHelpers-1f0bf8c2.js
	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }
	  return obj;
	}
	function ownKeys(object, enumerableOnly) {
	  var keys2 = Object.keys(object);
	  if (Object.getOwnPropertySymbols) {
	    var symbols = Object.getOwnPropertySymbols(object);
	    if (enumerableOnly)
	      symbols = symbols.filter(function(sym) {
	        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
	      });
	    keys2.push.apply(keys2, symbols);
	  }
	  return keys2;
	}
	function _objectSpread2(target) {
	  for (var i2 = 1; i2 < arguments.length; i2++) {
	    var source = arguments[i2] != null ? arguments[i2] : {};
	    if (i2 % 2) {
	      ownKeys(Object(source), true).forEach(function(key) {
	        _defineProperty(target, key, source[key]);
	      });
	    } else if (Object.getOwnPropertyDescriptors) {
	      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
	    } else {
	      ownKeys(Object(source)).forEach(function(key) {
	        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
	      });
	    }
	  }
	  return target;
	}
	function _objectWithoutPropertiesLoose(source, excluded) {
	  if (source == null)
	    return {};
	  var target = {};
	  var sourceKeys = Object.keys(source);
	  var key, i2;
	  for (i2 = 0; i2 < sourceKeys.length; i2++) {
	    key = sourceKeys[i2];
	    if (excluded.indexOf(key) >= 0)
	      continue;
	    target[key] = source[key];
	  }
	  return target;
	}

	// ../node_modules/reakit-system/es/createComponent.js
	var import_react32 = __toModule(react.exports);

	// ../node_modules/reakit-system/es/SystemContext.js
	var import_react30 = __toModule(react.exports);
	var SystemContext = /* @__PURE__ */ (0, import_react30.createContext)({});

	// ../node_modules/reakit-system/es/_rollupPluginBabelHelpers-0c84a174.js
	function _defineProperty2(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }
	  return obj;
	}
	function ownKeys2(object, enumerableOnly) {
	  var keys2 = Object.keys(object);
	  if (Object.getOwnPropertySymbols) {
	    var symbols = Object.getOwnPropertySymbols(object);
	    if (enumerableOnly)
	      symbols = symbols.filter(function(sym) {
	        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
	      });
	    keys2.push.apply(keys2, symbols);
	  }
	  return keys2;
	}
	function _objectSpread22(target) {
	  for (var i2 = 1; i2 < arguments.length; i2++) {
	    var source = arguments[i2] != null ? arguments[i2] : {};
	    if (i2 % 2) {
	      ownKeys2(Object(source), true).forEach(function(key) {
	        _defineProperty2(target, key, source[key]);
	      });
	    } else if (Object.getOwnPropertyDescriptors) {
	      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
	    } else {
	      ownKeys2(Object(source)).forEach(function(key) {
	        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
	      });
	    }
	  }
	  return target;
	}
	function _objectWithoutPropertiesLoose2(source, excluded) {
	  if (source == null)
	    return {};
	  var target = {};
	  var sourceKeys = Object.keys(source);
	  var key, i2;
	  for (i2 = 0; i2 < sourceKeys.length; i2++) {
	    key = sourceKeys[i2];
	    if (excluded.indexOf(key) >= 0)
	      continue;
	    target[key] = source[key];
	  }
	  return target;
	}
	function _unsupportedIterableToArray(o2, minLen) {
	  if (!o2)
	    return;
	  if (typeof o2 === "string")
	    return _arrayLikeToArray(o2, minLen);
	  var n2 = Object.prototype.toString.call(o2).slice(8, -1);
	  if (n2 === "Object" && o2.constructor)
	    n2 = o2.constructor.name;
	  if (n2 === "Map" || n2 === "Set")
	    return Array.from(o2);
	  if (n2 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2))
	    return _arrayLikeToArray(o2, minLen);
	}
	function _arrayLikeToArray(arr, len) {
	  if (len == null || len > arr.length)
	    len = arr.length;
	  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++)
	    arr2[i2] = arr[i2];
	  return arr2;
	}
	function _createForOfIteratorHelperLoose(o2, allowArrayLike) {
	  var it;
	  if (typeof Symbol === "undefined" || o2[Symbol.iterator] == null) {
	    if (Array.isArray(o2) || (it = _unsupportedIterableToArray(o2)) || allowArrayLike && o2 && typeof o2.length === "number") {
	      if (it)
	        o2 = it;
	      var i2 = 0;
	      return function() {
	        if (i2 >= o2.length)
	          return {
	            done: true
	          };
	        return {
	          done: false,
	          value: o2[i2++]
	        };
	      };
	    }
	    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	  }
	  it = o2[Symbol.iterator]();
	  return it.next.bind(it);
	}

	// ../node_modules/reakit-system/es/useCreateElement.js
	var import_react31 = __toModule(react.exports);
	function isRenderProp(children) {
	  return typeof children === "function";
	}
	var useCreateElement = function useCreateElement2(type, props, children) {
	  if (children === void 0) {
	    children = props.children;
	  }
	  var context3 = (0, import_react31.useContext)(SystemContext);
	  if (context3.useCreateElement) {
	    return context3.useCreateElement(type, props, children);
	  }
	  if (typeof type === "string" && isRenderProp(children)) {
	    props.children; var rest = _objectWithoutPropertiesLoose2(props, ["children"]);
	    return children(rest);
	  }
	  return /* @__PURE__ */ (0, import_react31.createElement)(type, props, children);
	};

	// ../node_modules/reakit-utils/es/_rollupPluginBabelHelpers-1f0bf8c2.js
	function _defineProperty3(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }
	  return obj;
	}
	function ownKeys3(object, enumerableOnly) {
	  var keys2 = Object.keys(object);
	  if (Object.getOwnPropertySymbols) {
	    var symbols = Object.getOwnPropertySymbols(object);
	    if (enumerableOnly)
	      symbols = symbols.filter(function(sym) {
	        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
	      });
	    keys2.push.apply(keys2, symbols);
	  }
	  return keys2;
	}
	function _objectSpread23(target) {
	  for (var i2 = 1; i2 < arguments.length; i2++) {
	    var source = arguments[i2] != null ? arguments[i2] : {};
	    if (i2 % 2) {
	      ownKeys3(Object(source), true).forEach(function(key) {
	        _defineProperty3(target, key, source[key]);
	      });
	    } else if (Object.getOwnPropertyDescriptors) {
	      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
	    } else {
	      ownKeys3(Object(source)).forEach(function(key) {
	        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
	      });
	    }
	  }
	  return target;
	}
	function _objectWithoutPropertiesLoose3(source, excluded) {
	  if (source == null)
	    return {};
	  var target = {};
	  var sourceKeys = Object.keys(source);
	  var key, i2;
	  for (i2 = 0; i2 < sourceKeys.length; i2++) {
	    key = sourceKeys[i2];
	    if (excluded.indexOf(key) >= 0)
	      continue;
	    target[key] = source[key];
	  }
	  return target;
	}
	function _unsupportedIterableToArray2(o2, minLen) {
	  if (!o2)
	    return;
	  if (typeof o2 === "string")
	    return _arrayLikeToArray2(o2, minLen);
	  var n2 = Object.prototype.toString.call(o2).slice(8, -1);
	  if (n2 === "Object" && o2.constructor)
	    n2 = o2.constructor.name;
	  if (n2 === "Map" || n2 === "Set")
	    return Array.from(o2);
	  if (n2 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2))
	    return _arrayLikeToArray2(o2, minLen);
	}
	function _arrayLikeToArray2(arr, len) {
	  if (len == null || len > arr.length)
	    len = arr.length;
	  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++)
	    arr2[i2] = arr[i2];
	  return arr2;
	}
	function _createForOfIteratorHelperLoose2(o2, allowArrayLike) {
	  var it;
	  if (typeof Symbol === "undefined" || o2[Symbol.iterator] == null) {
	    if (Array.isArray(o2) || (it = _unsupportedIterableToArray2(o2)) || allowArrayLike && o2 && typeof o2.length === "number") {
	      if (it)
	        o2 = it;
	      var i2 = 0;
	      return function() {
	        if (i2 >= o2.length)
	          return {
	            done: true
	          };
	        return {
	          done: false,
	          value: o2[i2++]
	        };
	      };
	    }
	    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	  }
	  it = o2[Symbol.iterator]();
	  return it.next.bind(it);
	}

	// ../node_modules/reakit-utils/es/isObject.js
	function isObject2(arg) {
	  return typeof arg === "object" && arg != null;
	}

	// ../node_modules/reakit-utils/es/isPlainObject.js
	function isPlainObject2(arg) {
	  var _proto$constructor;
	  if (!isObject2(arg))
	    return false;
	  var proto = Object.getPrototypeOf(arg);
	  if (proto == null)
	    return true;
	  return ((_proto$constructor = proto.constructor) === null || _proto$constructor === void 0 ? void 0 : _proto$constructor.toString()) === Object.toString();
	}

	// ../node_modules/reakit-utils/es/splitProps.js
	function __deprecatedSplitProps(props, keys2) {
	  var propsKeys = Object.keys(props);
	  var picked = {};
	  var omitted = {};
	  for (var _i = 0, _propsKeys = propsKeys; _i < _propsKeys.length; _i++) {
	    var key = _propsKeys[_i];
	    if (keys2.indexOf(key) >= 0) {
	      picked[key] = props[key];
	    } else {
	      omitted[key] = props[key];
	    }
	  }
	  return [picked, omitted];
	}
	function splitProps(props, keys2) {
	  if (keys2 === void 0) {
	    keys2 = [];
	  }
	  if (!isPlainObject2(props.state)) {
	    return __deprecatedSplitProps(props, keys2);
	  }
	  var _deprecatedSplitProp = __deprecatedSplitProps(props, [].concat(keys2, ["state"])), picked = _deprecatedSplitProp[0], omitted = _deprecatedSplitProp[1];
	  var state = picked.state, restPicked = _objectWithoutPropertiesLoose3(picked, ["state"]);
	  return [_objectSpread23(_objectSpread23({}, state), restPicked), omitted];
	}

	// ../node_modules/reakit-utils/es/shallowEqual.js
	function shallowEqual(objA, objB) {
	  if (objA === objB)
	    return true;
	  if (!objA)
	    return false;
	  if (!objB)
	    return false;
	  if (typeof objA !== "object")
	    return false;
	  if (typeof objB !== "object")
	    return false;
	  var aKeys = Object.keys(objA);
	  var bKeys = Object.keys(objB);
	  var length = aKeys.length;
	  if (bKeys.length !== length)
	    return false;
	  for (var _i = 0, _aKeys = aKeys; _i < _aKeys.length; _i++) {
	    var key = _aKeys[_i];
	    if (objA[key] !== objB[key]) {
	      return false;
	    }
	  }
	  return true;
	}

	// ../node_modules/reakit-utils/es/normalizePropsAreEqual.js
	function normalizePropsAreEqual(propsAreEqual2) {
	  if (propsAreEqual2.name === "normalizePropsAreEqualInner") {
	    return propsAreEqual2;
	  }
	  return function normalizePropsAreEqualInner(prev, next) {
	    if (!isPlainObject2(prev.state) || !isPlainObject2(next.state)) {
	      return propsAreEqual2(prev, next);
	    }
	    return propsAreEqual2(_objectSpread23(_objectSpread23({}, prev.state), prev), _objectSpread23(_objectSpread23({}, next.state), next));
	  };
	}

	// ../node_modules/reakit-system/es/createComponent.js
	function forwardRef(component) {
	  return /* @__PURE__ */ (0, import_react32.forwardRef)(component);
	}
	function memo(component, propsAreEqual2) {
	  return /* @__PURE__ */ (0, import_react32.memo)(component, propsAreEqual2);
	}
	function createComponent(_ref) {
	  var type = _ref.as, useHook = _ref.useHook, shouldMemo = _ref.memo, _ref$propsAreEqual = _ref.propsAreEqual, propsAreEqual2 = _ref$propsAreEqual === void 0 ? useHook === null || useHook === void 0 ? void 0 : useHook.unstable_propsAreEqual : _ref$propsAreEqual, _ref$keys = _ref.keys, keys2 = _ref$keys === void 0 ? (useHook === null || useHook === void 0 ? void 0 : useHook.__keys) || [] : _ref$keys, _ref$useCreateElement = _ref.useCreateElement, useCreateElement$1 = _ref$useCreateElement === void 0 ? useCreateElement : _ref$useCreateElement;
	  var Comp = function Comp2(_ref2, ref) {
	    var _ref2$as = _ref2.as, as = _ref2$as === void 0 ? type : _ref2$as, props = _objectWithoutPropertiesLoose2(_ref2, ["as"]);
	    if (useHook) {
	      var _as$render;
	      var _splitProps = splitProps(props, keys2), _options = _splitProps[0], htmlProps = _splitProps[1];
	      var _useHook = useHook(_options, _objectSpread22({
	        ref
	      }, htmlProps)), wrapElement = _useHook.wrapElement, elementProps = _objectWithoutPropertiesLoose2(_useHook, ["wrapElement"]);
	      var asKeys = ((_as$render = as.render) === null || _as$render === void 0 ? void 0 : _as$render.__keys) || as.__keys;
	      var asOptions = asKeys && splitProps(props, asKeys)[0];
	      var allProps = asOptions ? _objectSpread22(_objectSpread22({}, elementProps), asOptions) : elementProps;
	      var _element = useCreateElement$1(as, allProps);
	      if (wrapElement) {
	        return wrapElement(_element);
	      }
	      return _element;
	    }
	    return useCreateElement$1(as, _objectSpread22({
	      ref
	    }, props));
	  };
	  if (useHook) {
	    Comp.displayName = useHook.name.replace(/^(unstable_)?use/, "");
	  }
	  Comp = forwardRef(Comp);
	  if (shouldMemo) {
	    Comp = memo(Comp, propsAreEqual2 && normalizePropsAreEqual(propsAreEqual2));
	  }
	  Comp.__keys = keys2;
	  Comp.unstable_propsAreEqual = normalizePropsAreEqual(propsAreEqual2 || shallowEqual);
	  return Comp;
	}

	// ../node_modules/reakit-system/es/createHook.js
	__toModule(react.exports);

	// ../node_modules/reakit-system/es/useToken.js
	var import_react33 = __toModule(react.exports);
	function useToken(token, defaultValue) {
	  (0, import_react33.useDebugValue)(token);
	  var context3 = (0, import_react33.useContext)(SystemContext);
	  return context3[token] != null ? context3[token] : defaultValue;
	}

	// ../node_modules/reakit-system/es/useProps.js
	var import_react34 = __toModule(react.exports);
	function useProps(name, options, htmlProps) {
	  if (options === void 0) {
	    options = {};
	  }
	  if (htmlProps === void 0) {
	    htmlProps = {};
	  }
	  var hookName = "use" + name + "Props";
	  (0, import_react34.useDebugValue)(hookName);
	  var useHook = useToken(hookName);
	  if (useHook) {
	    return useHook(options, htmlProps);
	  }
	  return htmlProps;
	}

	// ../node_modules/reakit-system/es/useOptions.js
	var import_react35 = __toModule(react.exports);
	function useOptions(name, options, htmlProps) {
	  if (options === void 0) {
	    options = {};
	  }
	  if (htmlProps === void 0) {
	    htmlProps = {};
	  }
	  var hookName = "use" + name + "Options";
	  (0, import_react35.useDebugValue)(hookName);
	  var useHook = useToken(hookName);
	  if (useHook) {
	    return _objectSpread22(_objectSpread22({}, options), useHook(options, htmlProps));
	  }
	  return options;
	}

	// ../node_modules/reakit-utils/es/toArray.js
	function toArray(arg) {
	  if (Array.isArray(arg)) {
	    return arg;
	  }
	  return typeof arg !== "undefined" ? [arg] : [];
	}

	// ../node_modules/reakit-system/es/createHook.js
	function createHook(options) {
	  var _options$useState, _composedHooks$;
	  var composedHooks = toArray(options.compose);
	  var __useOptions = function __useOptions2(hookOptions, htmlProps) {
	    if (options.useOptions) {
	      hookOptions = options.useOptions(hookOptions, htmlProps);
	    }
	    if (options.name) {
	      hookOptions = useOptions(options.name, hookOptions, htmlProps);
	    }
	    if (options.compose) {
	      for (var _iterator = _createForOfIteratorHelperLoose(composedHooks), _step; !(_step = _iterator()).done; ) {
	        var hook = _step.value;
	        hookOptions = hook.__useOptions(hookOptions, htmlProps);
	      }
	    }
	    return hookOptions;
	  };
	  var useHook = function useHook2(hookOptions, htmlProps, unstable_ignoreUseOptions) {
	    if (hookOptions === void 0) {
	      hookOptions = {};
	    }
	    if (htmlProps === void 0) {
	      htmlProps = {};
	    }
	    if (unstable_ignoreUseOptions === void 0) {
	      unstable_ignoreUseOptions = false;
	    }
	    if (!unstable_ignoreUseOptions) {
	      hookOptions = __useOptions(hookOptions, htmlProps);
	    }
	    if (options.useProps) {
	      htmlProps = options.useProps(hookOptions, htmlProps);
	    }
	    if (options.name) {
	      htmlProps = useProps(options.name, hookOptions, htmlProps);
	    }
	    if (options.compose) {
	      if (options.useComposeOptions) {
	        hookOptions = options.useComposeOptions(hookOptions, htmlProps);
	      }
	      if (options.useComposeProps) {
	        htmlProps = options.useComposeProps(hookOptions, htmlProps);
	      } else {
	        for (var _iterator2 = _createForOfIteratorHelperLoose(composedHooks), _step2; !(_step2 = _iterator2()).done; ) {
	          var hook = _step2.value;
	          htmlProps = hook(hookOptions, htmlProps, true);
	        }
	      }
	    }
	    var finalHTMLProps = {};
	    var definedHTMLProps = htmlProps || {};
	    for (var prop in definedHTMLProps) {
	      if (definedHTMLProps[prop] !== void 0) {
	        finalHTMLProps[prop] = definedHTMLProps[prop];
	      }
	    }
	    return finalHTMLProps;
	  };
	  useHook.__useOptions = __useOptions;
	  var composedKeys = composedHooks.reduce(function(keys2, hook) {
	    keys2.push.apply(keys2, hook.__keys || []);
	    return keys2;
	  }, []);
	  useHook.__keys = [].concat(composedKeys, ((_options$useState = options.useState) === null || _options$useState === void 0 ? void 0 : _options$useState.__keys) || [], options.keys || []);
	  useHook.unstable_propsAreEqual = options.propsAreEqual || ((_composedHooks$ = composedHooks[0]) === null || _composedHooks$ === void 0 ? void 0 : _composedHooks$.unstable_propsAreEqual) || shallowEqual;
	  if (options.name) {
	    Object.defineProperty(useHook, "name", {
	      value: "use" + options.name
	    });
	  }
	  return useHook;
	}

	// ../node_modules/reakit/es/index.js
	__toModule(react.exports);

	// ../node_modules/reakit-utils/es/useForkRef.js
	var import_react37 = __toModule(react.exports);
	function setRef(ref, value) {
	  if (value === void 0) {
	    value = null;
	  }
	  if (!ref)
	    return;
	  if (typeof ref === "function") {
	    ref(value);
	  } else {
	    ref.current = value;
	  }
	}
	function useForkRef(refA, refB) {
	  return (0, import_react37.useMemo)(function() {
	    if (refA == null && refB == null) {
	      return null;
	    }
	    return function(value) {
	      setRef(refA, value);
	      setRef(refB, value);
	    };
	  }, [refA, refB]);
	}

	// ../node_modules/reakit-utils/es/isButton.js
	var buttonInputTypes = ["button", "color", "file", "image", "reset", "submit"];
	function isButton(element) {
	  if (element.tagName === "BUTTON")
	    return true;
	  if (element.tagName === "INPUT") {
	    var input = element;
	    return buttonInputTypes.indexOf(input.type) !== -1;
	  }
	  return false;
	}

	// ../node_modules/reakit-utils/es/flatten.js
	function flatten(array) {
	  var flat = [];
	  for (var _iterator = _createForOfIteratorHelperLoose2(array), _step; !(_step = _iterator()).done; ) {
	    var maybeArray = _step.value;
	    if (Array.isArray(maybeArray)) {
	      flat.push.apply(flat, flatten(maybeArray));
	    } else {
	      flat.push(maybeArray);
	    }
	  }
	  return flat;
	}

	// ../node_modules/reakit-warning/es/warning.js
	function warning(condition) {
	  {
	    var _console;
	    if (!condition)
	      return;
	    for (var _len = arguments.length, messages = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	      messages[_key - 1] = arguments[_key];
	    }
	    var warns = flatten(messages.map(function(message) {
	      return [message, "\n"];
	    }));
	    (_console = console).warn.apply(_console, warns.slice(0, -1));
	    try {
	      throw Error(warns.join(""));
	    } catch (x2) {
	    }
	  }
	}

	// ../node_modules/reakit-warning/es/index.js
	__toModule(react.exports);

	// ../node_modules/reakit-warning/es/useWarning.js
	__toModule(react.exports);

	// ../node_modules/reakit-utils/es/useLiveRef.js
	var import_react41 = __toModule(react.exports);

	// ../node_modules/reakit-utils/es/getDocument.js
	function getDocument(element) {
	  return element ? element.ownerDocument || element : document;
	}

	// ../node_modules/reakit-utils/es/getWindow.js
	var _window;
	try {
	  _window = window;
	} catch (e) {
	}
	function getWindow(element) {
	  if (!element) {
	    return _window;
	  }
	  return getDocument(element).defaultView || _window;
	}

	// ../node_modules/reakit-utils/es/canUseDOM.js
	function checkIsBrowser() {
	  var _window2 = getWindow();
	  return Boolean(typeof _window2 !== "undefined" && _window2.document && _window2.document.createElement);
	}
	var canUseDOM = checkIsBrowser();

	// ../node_modules/reakit-utils/es/useIsomorphicEffect.js
	var import_react40 = __toModule(react.exports);
	var useIsomorphicEffect = !canUseDOM ? import_react40.useEffect : import_react40.useLayoutEffect;

	// ../node_modules/reakit-utils/es/useLiveRef.js
	function useLiveRef(value) {
	  var ref = (0, import_react41.useRef)(value);
	  useIsomorphicEffect(function() {
	    ref.current = value;
	  });
	  return ref;
	}

	// ../node_modules/reakit-utils/es/isSelfTarget.js
	function isSelfTarget(event) {
	  return event.target === event.currentTarget;
	}

	// ../node_modules/reakit-utils/es/getActiveElement.js
	function getActiveElement(element) {
	  var _getDocument = getDocument(element), activeElement = _getDocument.activeElement;
	  if (!(activeElement !== null && activeElement !== void 0 && activeElement.nodeName)) {
	    return null;
	  }
	  return activeElement;
	}

	// ../node_modules/reakit-utils/es/contains.js
	function contains(parent, child) {
	  return parent === child || parent.contains(child);
	}

	// ../node_modules/reakit-utils/es/hasFocusWithin.js
	function hasFocusWithin(element) {
	  var activeElement = getActiveElement(element);
	  if (!activeElement)
	    return false;
	  if (contains(element, activeElement))
	    return true;
	  var activeDescendant = activeElement.getAttribute("aria-activedescendant");
	  if (!activeDescendant)
	    return false;
	  if (activeDescendant === element.id)
	    return true;
	  return !!element.querySelector("#" + activeDescendant);
	}

	// ../node_modules/reakit-utils/es/isPortalEvent.js
	function isPortalEvent(event) {
	  return !contains(event.currentTarget, event.target);
	}

	// ../node_modules/reakit-utils/es/dom.js
	function isUA(string) {
	  if (!canUseDOM)
	    return false;
	  return window.navigator.userAgent.indexOf(string) !== -1;
	}

	// ../node_modules/reakit-utils/es/matches.js
	function matches(element, selectors) {
	  if ("matches" in element) {
	    return element.matches(selectors);
	  }
	  if ("msMatchesSelector" in element) {
	    return element.msMatchesSelector(selectors);
	  }
	  return element.webkitMatchesSelector(selectors);
	}

	// ../node_modules/reakit-utils/es/tabbable.js
	var selector = "input:not([type='hidden']):not([disabled]), select:not([disabled]), textarea:not([disabled]), a[href], button:not([disabled]), [tabindex], iframe, object, embed, area[href], audio[controls], video[controls], [contenteditable]:not([contenteditable='false'])";
	function isVisible(element) {
	  var htmlElement = element;
	  return htmlElement.offsetWidth > 0 || htmlElement.offsetHeight > 0 || element.getClientRects().length > 0;
	}
	function isFocusable(element) {
	  return matches(element, selector) && isVisible(element);
	}

	// ../node_modules/reakit/es/Role/Role.js
	var ROLE_KEYS = ["unstable_system"];
	var useRole = createHook({
	  name: "Role",
	  keys: ROLE_KEYS,
	  propsAreEqual: function propsAreEqual(prev, next) {
	    var prevSystem = prev.unstable_system, prevProps = _objectWithoutPropertiesLoose(prev, ["unstable_system"]);
	    var nextSystem = next.unstable_system, nextProps = _objectWithoutPropertiesLoose(next, ["unstable_system"]);
	    if (prevSystem !== nextSystem && !shallowEqual(prevSystem, nextSystem)) {
	      return false;
	    }
	    return shallowEqual(prevProps, nextProps);
	  }
	});
	createComponent({
	  as: "div",
	  useHook: useRole
	});

	// ../node_modules/reakit/es/Tabbable/Tabbable.js
	var import_react42 = __toModule(react.exports);
	var TABBABLE_KEYS = ["disabled", "focusable"];
	var isSafariOrFirefoxOnMac = isUA("Mac") && !isUA("Chrome") && (isUA("Safari") || isUA("Firefox"));
	function focusIfNeeded(element) {
	  if (!hasFocusWithin(element) && isFocusable(element)) {
	    element.focus();
	  }
	}
	function isNativeTabbable(element) {
	  return element.tagName === "BUTTON" || element.tagName === "INPUT" || element.tagName === "SELECT" || element.tagName === "TEXTAREA" || element.tagName === "A";
	}
	function supportsDisabledAttribute(element) {
	  return element.tagName === "BUTTON" || element.tagName === "INPUT" || element.tagName === "SELECT" || element.tagName === "TEXTAREA";
	}
	function getTabIndex(trulyDisabled, nativeTabbable, supportsDisabled, htmlTabIndex) {
	  if (trulyDisabled) {
	    if (nativeTabbable && !supportsDisabled) {
	      return -1;
	    }
	    return void 0;
	  }
	  if (nativeTabbable) {
	    return htmlTabIndex;
	  }
	  return htmlTabIndex || 0;
	}
	function useDisableEvent(htmlEventRef, disabled) {
	  return (0, import_react42.useCallback)(function(event) {
	    var _htmlEventRef$current;
	    (_htmlEventRef$current = htmlEventRef.current) === null || _htmlEventRef$current === void 0 ? void 0 : _htmlEventRef$current.call(htmlEventRef, event);
	    if (event.defaultPrevented)
	      return;
	    if (disabled) {
	      event.stopPropagation();
	      event.preventDefault();
	    }
	  }, [htmlEventRef, disabled]);
	}
	var useTabbable = createHook({
	  name: "Tabbable",
	  compose: useRole,
	  keys: TABBABLE_KEYS,
	  useOptions: function useOptions2(options, _ref) {
	    var disabled = _ref.disabled;
	    return _objectSpread2({
	      disabled
	    }, options);
	  },
	  useProps: function useProps2(options, _ref2) {
	    var htmlRef = _ref2.ref, htmlTabIndex = _ref2.tabIndex, htmlOnClickCapture = _ref2.onClickCapture, htmlOnMouseDownCapture = _ref2.onMouseDownCapture, htmlOnMouseDown = _ref2.onMouseDown, htmlOnKeyPressCapture = _ref2.onKeyPressCapture, htmlStyle = _ref2.style, htmlProps = _objectWithoutPropertiesLoose(_ref2, ["ref", "tabIndex", "onClickCapture", "onMouseDownCapture", "onMouseDown", "onKeyPressCapture", "style"]);
	    var ref = (0, import_react42.useRef)(null);
	    var onClickCaptureRef = useLiveRef(htmlOnClickCapture);
	    var onMouseDownCaptureRef = useLiveRef(htmlOnMouseDownCapture);
	    var onMouseDownRef = useLiveRef(htmlOnMouseDown);
	    var onKeyPressCaptureRef = useLiveRef(htmlOnKeyPressCapture);
	    var trulyDisabled = !!options.disabled && !options.focusable;
	    var _React$useState = (0, import_react42.useState)(true), nativeTabbable = _React$useState[0], setNativeTabbable = _React$useState[1];
	    var _React$useState2 = (0, import_react42.useState)(true), supportsDisabled = _React$useState2[0], setSupportsDisabled = _React$useState2[1];
	    var style = options.disabled ? _objectSpread2({
	      pointerEvents: "none"
	    }, htmlStyle) : htmlStyle;
	    useIsomorphicEffect(function() {
	      var tabbable = ref.current;
	      if (!tabbable) {
	        warning(true, "Can't determine if the element is a native tabbable element because `ref` wasn't passed to the component.", "See https://reakit.io/docs/tabbable") ;
	        return;
	      }
	      if (!isNativeTabbable(tabbable)) {
	        setNativeTabbable(false);
	      }
	      if (!supportsDisabledAttribute(tabbable)) {
	        setSupportsDisabled(false);
	      }
	    }, []);
	    var onClickCapture = useDisableEvent(onClickCaptureRef, options.disabled);
	    var onMouseDownCapture = useDisableEvent(onMouseDownCaptureRef, options.disabled);
	    var onKeyPressCapture = useDisableEvent(onKeyPressCaptureRef, options.disabled);
	    var onMouseDown = (0, import_react42.useCallback)(function(event) {
	      var _onMouseDownRef$curre;
	      (_onMouseDownRef$curre = onMouseDownRef.current) === null || _onMouseDownRef$curre === void 0 ? void 0 : _onMouseDownRef$curre.call(onMouseDownRef, event);
	      var element = event.currentTarget;
	      if (event.defaultPrevented)
	        return;
	      if (!isSafariOrFirefoxOnMac)
	        return;
	      if (isPortalEvent(event))
	        return;
	      if (!isButton(element))
	        return;
	      var raf = requestAnimationFrame(function() {
	        element.removeEventListener("mouseup", focusImmediately, true);
	        focusIfNeeded(element);
	      });
	      var focusImmediately = function focusImmediately2() {
	        cancelAnimationFrame(raf);
	        focusIfNeeded(element);
	      };
	      element.addEventListener("mouseup", focusImmediately, {
	        once: true,
	        capture: true
	      });
	    }, []);
	    return _objectSpread2({
	      ref: useForkRef(ref, htmlRef),
	      style,
	      tabIndex: getTabIndex(trulyDisabled, nativeTabbable, supportsDisabled, htmlTabIndex),
	      disabled: trulyDisabled && supportsDisabled ? true : void 0,
	      "aria-disabled": options.disabled ? true : void 0,
	      onClickCapture,
	      onMouseDownCapture,
	      onMouseDown,
	      onKeyPressCapture
	    }, htmlProps);
	  }
	});
	createComponent({
	  as: "div",
	  useHook: useTabbable
	});

	// ../node_modules/reakit/es/Clickable/Clickable.js
	var import_react43 = __toModule(react.exports);
	var CLICKABLE_KEYS = ["unstable_clickOnEnter", "unstable_clickOnSpace"];
	function isNativeClick(event) {
	  var element = event.currentTarget;
	  if (!event.isTrusted)
	    return false;
	  return isButton(element) || element.tagName === "INPUT" || element.tagName === "TEXTAREA" || element.tagName === "A" || element.tagName === "SELECT";
	}
	var useClickable = createHook({
	  name: "Clickable",
	  compose: useTabbable,
	  keys: CLICKABLE_KEYS,
	  useOptions: function useOptions3(_ref) {
	    var _ref$unstable_clickOn = _ref.unstable_clickOnEnter, unstable_clickOnEnter = _ref$unstable_clickOn === void 0 ? true : _ref$unstable_clickOn, _ref$unstable_clickOn2 = _ref.unstable_clickOnSpace, unstable_clickOnSpace = _ref$unstable_clickOn2 === void 0 ? true : _ref$unstable_clickOn2, options = _objectWithoutPropertiesLoose(_ref, ["unstable_clickOnEnter", "unstable_clickOnSpace"]);
	    return _objectSpread2({
	      unstable_clickOnEnter,
	      unstable_clickOnSpace
	    }, options);
	  },
	  useProps: function useProps3(options, _ref2) {
	    var htmlOnKeyDown = _ref2.onKeyDown, htmlOnKeyUp = _ref2.onKeyUp, htmlProps = _objectWithoutPropertiesLoose(_ref2, ["onKeyDown", "onKeyUp"]);
	    var _React$useState = (0, import_react43.useState)(false), active = _React$useState[0], setActive = _React$useState[1];
	    var onKeyDownRef = useLiveRef(htmlOnKeyDown);
	    var onKeyUpRef = useLiveRef(htmlOnKeyUp);
	    var onKeyDown = (0, import_react43.useCallback)(function(event) {
	      var _onKeyDownRef$current;
	      (_onKeyDownRef$current = onKeyDownRef.current) === null || _onKeyDownRef$current === void 0 ? void 0 : _onKeyDownRef$current.call(onKeyDownRef, event);
	      if (event.defaultPrevented)
	        return;
	      if (options.disabled)
	        return;
	      if (event.metaKey)
	        return;
	      if (!isSelfTarget(event))
	        return;
	      var isEnter = options.unstable_clickOnEnter && event.key === "Enter";
	      var isSpace = options.unstable_clickOnSpace && event.key === " ";
	      if (isEnter || isSpace) {
	        if (isNativeClick(event))
	          return;
	        event.preventDefault();
	        if (isEnter) {
	          event.currentTarget.click();
	        } else if (isSpace) {
	          setActive(true);
	        }
	      }
	    }, [options.disabled, options.unstable_clickOnEnter, options.unstable_clickOnSpace]);
	    var onKeyUp = (0, import_react43.useCallback)(function(event) {
	      var _onKeyUpRef$current;
	      (_onKeyUpRef$current = onKeyUpRef.current) === null || _onKeyUpRef$current === void 0 ? void 0 : _onKeyUpRef$current.call(onKeyUpRef, event);
	      if (event.defaultPrevented)
	        return;
	      if (options.disabled)
	        return;
	      if (event.metaKey)
	        return;
	      var isSpace = options.unstable_clickOnSpace && event.key === " ";
	      if (active && isSpace) {
	        setActive(false);
	        event.currentTarget.click();
	      }
	    }, [options.disabled, options.unstable_clickOnSpace, active]);
	    return _objectSpread2({
	      "data-active": active || void 0,
	      onKeyDown,
	      onKeyUp
	    }, htmlProps);
	  }
	});
	createComponent({
	  as: "button",
	  memo: true,
	  useHook: useClickable
	});

	// ../node_modules/reakit/es/Button/Button.js
	var import_react44 = __toModule(react.exports);
	var BUTTON_KEYS = [];
	var useButton = createHook({
	  name: "Button",
	  compose: useClickable,
	  keys: BUTTON_KEYS,
	  useProps: function useProps4(_2, _ref) {
	    var htmlRef = _ref.ref, htmlProps = _objectWithoutPropertiesLoose(_ref, ["ref"]);
	    var ref = (0, import_react44.useRef)(null);
	    var _React$useState = (0, import_react44.useState)(void 0), role = _React$useState[0], setRole = _React$useState[1];
	    var _React$useState2 = (0, import_react44.useState)("button"), type = _React$useState2[0], setType = _React$useState2[1];
	    (0, import_react44.useEffect)(function() {
	      var element = ref.current;
	      if (!element) {
	        warning(true, "Can't determine whether the element is a native button because `ref` wasn't passed to the component", "See https://reakit.io/docs/button") ;
	        return;
	      }
	      if (!isButton(element)) {
	        if (element.tagName !== "A") {
	          setRole("button");
	        }
	        setType(void 0);
	      }
	    }, []);
	    return _objectSpread2({
	      ref: useForkRef(ref, htmlRef),
	      role,
	      type
	    }, htmlProps);
	  }
	});
	var Button = createComponent({
	  as: "button",
	  memo: true,
	  useHook: useButton
	});

	// ../node_modules/reakit/es/Group/Group.js
	var GROUP_KEYS = [];
	var useGroup = createHook({
	  name: "Group",
	  compose: useRole,
	  keys: GROUP_KEYS,
	  useProps: function useProps5(_2, htmlProps) {
	    return _objectSpread2({
	      role: "group"
	    }, htmlProps);
	  }
	});
	var Group = createComponent({
	  as: "div",
	  useHook: useGroup
	});

	// ../node_modules/reakit/es/index.js
	__toModule(reactDom.exports);

	// ../node_modules/reakit/es/Portal/Portal.js
	var import_react45 = __toModule(react.exports);
	__toModule(reactDom.exports);
	function getBodyElement() {
	  return canUseDOM ? document.body : null;
	}
	var PortalContext = /* @__PURE__ */ (0, import_react45.createContext)(getBodyElement());
	if (typeof window !== "undefined") {
	  passiveTestOptions = {
	    get passive() {
	      return void 0;
	    }
	  };
	  window.addEventListener("testPassive", null, passiveTestOptions);
	  window.removeEventListener("testPassive", null, passiveTestOptions);
	}
	var passiveTestOptions;
	typeof window !== "undefined" && window.navigator && window.navigator.platform && (/iP(ad|hone|od)/.test(window.navigator.platform) || window.navigator.platform === "MacIntel" && window.navigator.maxTouchPoints > 1);

	// studio/src/uiComponents/Popover/useTooltip.tsx
	function useTooltip(opts, render) {
	  const enabled = opts.enabled !== false;
	  const [isOpen, setIsOpen] = useTooltipOpenState();
	  const [targetRef, targetNode] = useRefAndState(null);
	  (0, import_react48.useEffect)(() => {
	    if (!enabled) {
	      return;
	    }
	    const target = targetRef.current;
	    if (!target)
	      return;
	    const onMouseEnter = () => {
	      var _a;
	      return setIsOpen(true, (_a = opts.enterDelay) != null ? _a : 400);
	    };
	    const onMouseLeave = () => {
	      var _a;
	      return setIsOpen(false, (_a = opts.exitDelay) != null ? _a : 200);
	    };
	    target.addEventListener("mouseenter", onMouseEnter);
	    target.addEventListener("mouseleave", onMouseLeave);
	    return () => {
	      target.removeEventListener("mouseenter", onMouseEnter);
	      target.removeEventListener("mouseleave", onMouseLeave);
	    };
	  }, [targetRef, enabled, opts.enterDelay, opts.exitDelay]);
	  const portalLayer = (0, import_react47.useContext)(PortalContext);
	  const node = enabled && isOpen && targetNode ? (0, import_react_dom4.createPortal)(/* @__PURE__ */ import_react49.default.createElement(TooltipWrapper_default, {
	    children: render,
	    target: targetNode,
	    onClickOutside: noop_default2
	  }), portalLayer) : /* @__PURE__ */ import_react49.default.createElement(import_react49.default.Fragment, null);
	  return [node, targetRef, isOpen];
	}

	// ../node_modules/react-merge-refs/dist/react-merge-refs.esm.js
	function mergeRefs(refs) {
	  return function(value) {
	    refs.forEach(function(ref) {
	      if (typeof ref === "function") {
	        ref(value);
	      } else if (ref != null) {
	        ref.current = value;
	      }
	    });
	  };
	}
	var react_merge_refs_esm_default = mergeRefs;

	// studio/src/uiComponents/Popover/MinimalTooltip.tsx
	var import_styled_components12 = __toModule(require$$3);

	// studio/src/uiComponents/Popover/BasicTooltip.tsx
	var import_styled_components11 = __toModule(require$$3);

	// studio/src/uiComponents/Popover/BasicPopover.tsx
	var import_react51 = __toModule(react.exports);
	var import_styled_components10 = __toModule(require$$3);

	// studio/src/uiComponents/Popover/PopoverArrow.tsx
	var import_react50 = __toModule(react.exports);
	var import_styled_components9 = __toModule(require$$3);
	var Container5 = import_styled_components9.default.div`
  position: absolute;
  width: 0;
  height: 0;
  color: var(--popover-arrow-color);
  pointer-events: none;
`;
	var Adjust = import_styled_components9.default.div`
  width: 12px;
  height: 8px;
  position: absolute;
  left: -7px;
  top: -8px;
  text-align: center;
  line-height: 0;
`;
	var InnerTriangle = import_styled_components9.default.path`
  fill: var(--popover-bg);
`;
	var InnerStroke = import_styled_components9.default.path`
  fill: var(--popover-inner-stroke);
`;
	var OuterStroke = import_styled_components9.default.path`
  fill: var(--popover-outer-stroke);
`;
	var PopoverArrow = (0, import_react50.forwardRef)(({ className }, ref) => {
	  const arrowStyle = (0, import_react50.useContext)(ArrowContext_default);
	  return /* @__PURE__ */ import_react50.default.createElement(Container5, {
	    className,
	    ref,
	    style: __spreadValues({}, arrowStyle)
	  }, /* @__PURE__ */ import_react50.default.createElement(Adjust, null, /* @__PURE__ */ import_react50.default.createElement("svg", {
	    width: "12",
	    height: "8",
	    viewBox: "0 0 12 8",
	    fill: "none",
	    xmlns: "http://www.w3.org/2000/svg"
	  }, /* @__PURE__ */ import_react50.default.createElement(OuterStroke, {
	    d: "M6 0L0 6H12L6 0Z"
	  }), /* @__PURE__ */ import_react50.default.createElement(InnerStroke, {
	    d: "M6 1.5L0 7.5H12L6 1.5Z"
	  }), /* @__PURE__ */ import_react50.default.createElement(InnerTriangle, {
	    d: "M6 3L0 9H12L6 3Z"
	  }))));
	});
	var PopoverArrow_default = PopoverArrow;

	// studio/src/uiComponents/Popover/BasicPopover.tsx
	var popoverBackgroundColor = curriedTransparentize(0.05, `#2a2a31`);
	var Container6 = import_styled_components10.default.div`
  position: absolute;
  --popover-bg: ${popoverBackgroundColor};
  --popover-inner-stroke: #505159;
  --popover-outer-stroke: #111;

  background: var(--popover-bg);

  color: white;
  padding: 0;
  margin: 0;
  cursor: default;
  ${pointerEventsAutoInNormalMode};
  border-radius: 3px;
  z-index: 10000;
  border: 1px solid var(--popover-inner-stroke);
  box-shadow: 0 0 0 1px var(--popover-outer-stroke), 0 6px 8px -4px black;
  backdrop-filter: blur(8px);

  & a {
    color: inherit;
  }
`;
	var BasicPopover = import_react51.default.forwardRef(({ children, className }, ref) => {
	  return /* @__PURE__ */ import_react51.default.createElement(Container6, {
	    className,
	    ref
	  }, /* @__PURE__ */ import_react51.default.createElement(PopoverArrow_default, null), children);
	});
	var BasicPopover_default = BasicPopover;

	// studio/src/uiComponents/Popover/BasicTooltip.tsx
	var BasicTooltip = (0, import_styled_components11.default)(BasicPopover_default)`
  padding: 1em;
  max-width: 240px;
  pointer-events: none !important;
  --popover-outer-stroke: transparent;
  --popover-inner-stroke: #45464d;
`;
	var BasicTooltip_default = BasicTooltip;

	// studio/src/uiComponents/Popover/MinimalTooltip.tsx
	var MinimalTooltip = (0, import_styled_components12.default)(BasicTooltip_default)`
  padding: 6px;
`;
	var MinimalTooltip_default = MinimalTooltip;

	// studio/src/uiComponents/toolbar/ToolbarIconButton.tsx
	var Container7 = import_styled_components13.default.button`
  ${pointerEventsAutoInNormalMode};
  position: relative;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 14px;
  font-weight: 600;
  width: 24px;
  height: 24px;
  outline: none;

  color: rgba(255, 255, 255, 0.75);
  background-color: rgb(47, 49, 53);

  &:hover {
    color: #fff;

    background-color: rgba(28, 30, 32, 0.95);
    &:after {
      border-color: rgba(90, 90, 90, 1);
    }
  }

  &.selected {
    color: #fff;

    background-color: rgba(17, 18, 20, 0.95);
    &:after {
      border-color: rgb(43, 43, 43);
    }
  }

  &:before {
    border: 1px solid rgb(62, 62, 62);
    position: absolute;
    inset: -1px;
    display: block;
    content: ' ';
    z-index: -1;
    pointer-events: none;
    border-radius: 2px;
    box-sizing: border-box;
    box-shadow: 0px 3px 4px -3px rgba(0, 0, 0, 0.49);
  }

  border: 0;
`;
	var ToolbarIconButton = import_react52.default.forwardRef((_a, ref) => {
	  var _b = _a, { title } = _b, props = __objRest(_b, ["title"]);
	  const [tooltip, localRef] = useTooltip({ enabled: typeof title === "string" }, () => /* @__PURE__ */ import_react52.default.createElement(MinimalTooltip_default, null, title));
	  return /* @__PURE__ */ import_react52.default.createElement(import_react52.default.Fragment, null, tooltip, /* @__PURE__ */ import_react52.default.createElement(Container7, __spreadValues({
	    ref: react_merge_refs_esm_default([localRef, ref])
	  }, props)), " ");
	});
	var ToolbarIconButton_default = ToolbarIconButton;

	// studio/src/panels/OutlinePanel/OutlinePanel.tsx
	var import_dataverse10 = __toModule(dist$1);

	// studio/src/uiComponents/Popover/ErrorTooltip.tsx
	var import_styled_components14 = __toModule(require$$3);
	var ErrorTooltip = (0, import_styled_components14.default)(BasicTooltip_default)`
  --popover-outer-stroke: #e11c1c;
  --popover-inner-stroke: #2c1c1c;
  --popover-bg: #2c1c1c;
  pointer-events: none !important;
`;
	var ErrorTooltip_default = ErrorTooltip;

	// studio/src/panels/OutlinePanel/OutlinePanel.tsx
	var Container8 = import_styled_components15.default.div`
  background-color: transparent;
  pointer-events: none;
  position: absolute;
  left: 0;
  top: 12px;
  bottom: 0px;
  right: 0;
  z-index: ${panelZIndexes.outlinePanel};

  &:before {
    display: block;
    content: ' ';
    position: absolute;
    top: 0;
    bottom: 0;
    left: 0;
    width: 40px;
    ${pointerEventsAutoInNormalMode};
  }
  &:hover:before {
    top: -12px;
    width: 300px;
  }
`;
	var TriggerContainer = import_styled_components15.default.div`
  margin-left: 12px;
  position: relative;
  display: flex;
  flex-direction: row;
  justify-content: flex-start;
  align-items: center;
`;
	var Content = import_styled_components15.default.div`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  transform: translateX(-100%);
  pointer-events: none;

  ${Container8}:hover & {
    transform: translateX(0);
  }
`;
	var headerHeight = `32px`;
	var TriggerButton = (0, import_styled_components15.default)(ToolbarIconButton_default)`
  ${Container8}:hover & {
    background-color: rgba(36, 38, 42, 0.95);
    &:after {
      border-color: rgba(255, 255, 255, 0.22);
    }
    color: white;
  }
`;
	import_styled_components15.default.div`
  margin: 0 12px;
  color: #ffffffc2;
  font-weight: 500;
  font-size: 10px;
  user-select: none;
  position: relative;
  display: none;
  background-color: rgba(60, 60, 60, 0.2);
  height: 24px;
  ${Container8}:hover & {
    display: block;
  }

  &:after {
    position: absolute;
    inset: 4px 0px;
    display: block;
    content: ' ';
    pointer-events: none;
    z-index: -1;
    background-color: #69777947;
    border-radius: 0 2px 2px 0;
  }
`;
	var Body3 = import_styled_components15.default.div`
  ${pointerEventsAutoInNormalMode};
  position: absolute;
  top: ${headerHeight};
  left: 8px;
  height: auto;
  max-height: calc(100% - ${headerHeight});
  overflow-y: scroll;
  overflow-x: hidden;
  padding: 0;
  user-select: none;
`;
	var NumberOfConflictsIndicator = import_styled_components15.default.div`
  color: white;
  width: 14px;
  height: 14px;
  background: #d00;
  border-radius: 4px;
  text-align: center;
  line-height: 14px;
  font-weight: 600;
  font-size: 8px;
  position: relative;
  left: -6px;
  top: -11px;
  margin-right: -14px;
  box-shadow: 0 4px 6px -4px #00000059;
`;
	var OutlinePanel = (props) => {
	  const conflicts = usePrism(() => {
	    const ephemeralStateOfAllProjects = (0, import_dataverse10.val)(getStudio().atomP.ephemeral.coreByProject);
	    return Object.entries(ephemeralStateOfAllProjects).map(([projectId, state]) => ({ projectId, state })).filter(({ state }) => state.loadingState.type === "browserStateIsNotBasedOnDiskState");
	  }, []);
	  const [triggerTooltip, triggerButtonRef] = useTooltip({ enabled: conflicts.length > 0, enterDelay: conflicts.length > 0 ? 0 : 200 }, () => conflicts.length > 0 ? /* @__PURE__ */ import_react53.default.createElement(ErrorTooltip_default, null, conflicts.length === 1 ? `There is a state conflict in project "${conflicts[0].projectId}". Select the project in the outline below in order to fix it.` : `There are ${conflicts.length} projects that have state conflicts. They are highlighted in the outline below. `) : /* @__PURE__ */ import_react53.default.createElement(BasicTooltip_default, null, "Outline"));
	  return /* @__PURE__ */ import_react53.default.createElement(Container8, null, /* @__PURE__ */ import_react53.default.createElement(TriggerContainer, null, triggerTooltip, /* @__PURE__ */ import_react53.default.createElement(TriggerButton, {
	    ref: triggerButtonRef
	  }, /* @__PURE__ */ import_react53.default.createElement(VscListTree, null)), conflicts.length > 0 ? /* @__PURE__ */ import_react53.default.createElement(NumberOfConflictsIndicator, null, conflicts.length) : null), /* @__PURE__ */ import_react53.default.createElement(Content, null, /* @__PURE__ */ import_react53.default.createElement(Body3, null, /* @__PURE__ */ import_react53.default.createElement(ProjectsList_default, null))));
	};
	var OutlinePanel_default = OutlinePanel;

	// studio/src/panels/DetailPanel/DetailPanel.tsx
	var import_react83 = __toModule(react.exports);
	var import_styled_components31 = __toModule(require$$3);

	// studio/src/panels/DetailPanel/ObjectDetails.tsx
	var import_react77 = __toModule(react.exports);

	// studio/src/panels/DetailPanel/propEditors/DeterminePropEditor.tsx
	var import_dataverse14 = __toModule(dist$1);
	var import_react76 = __toModule(react.exports);

	// studio/src/panels/DetailPanel/propEditors/BooleanPropEditor.tsx
	var import_react66 = __toModule(react.exports);

	// shared/src/utils/getDeep.ts
	function getDeep(v2, path) {
	  if (path.length === 0)
	    return v2;
	  return get_default(v2, path);
	}

	// studio/src/panels/DetailPanel/propEditors/utils/useEditingToolsForPrimitiveProp.tsx
	var import_dataverse11 = __toModule(dist$1);
	var import_react58 = __toModule(react.exports);

	// studio/src/panels/DetailPanel/propEditors/utils/DefaultValueIndicator.tsx
	var import_react55 = __toModule(react.exports);
	var import_styled_components16 = __toModule(require$$3);
	var theme2 = {
	  defaultState: {
	    color: curriedTransparentize(0.85, `#C4C4C4`)
	  },
	  withStaticOverride: {
	    color: curriedTransparentize(0.85, `#C4C4C4`)
	  }
	};
	var Container9 = import_styled_components16.default.div`
  width: 16px;
  margin: 0 0px 0 2px;
  display: flex;
  justify-content: center;
  align-items: center;

  color: ${(props) => props.hasStaticOverride ? theme2.withStaticOverride.color : theme2.defaultState.color};
`;
	var Rect = import_styled_components16.default.rect`
  fill: currentColor;
`;
	var Icon = () => /* @__PURE__ */ import_react55.default.createElement("svg", {
	  width: "5",
	  height: "5",
	  viewBox: "0 0 5 5",
	  fill: "none",
	  xmlns: "http://www.w3.org/2000/svg"
	}, /* @__PURE__ */ import_react55.default.createElement(Rect, {
	  width: "5",
	  height: "5"
	}));
	var DefaultOrStaticValueIndicator = (props) => {
	  return /* @__PURE__ */ import_react55.default.createElement(Container9, {
	    hasStaticOverride: props.hasStaticOverride
	  }, /* @__PURE__ */ import_react55.default.createElement(Icon, null));
	};
	var DefaultValueIndicator_default = DefaultOrStaticValueIndicator;

	// studio/src/panels/DetailPanel/propEditors/utils/NextPrevKeyframeCursors.tsx
	var import_react56 = __toModule(react.exports);
	var import_styled_components17 = __toModule(require$$3);
	var Container10 = import_styled_components17.default.div`
  display: flex;
  justify-content: center;
  align-items: center;
  width: 16px;
  margin: 0 0px 0 2px;
  position: relative;
  z-index: 0;
  opacity: 0.7;

  &:after {
    position: absolute;
    left: -14px;
    right: -14px;
    top: -2px;
    bottom: -2px;
    content: ' ';
    display: none;
    z-index: -1;
    background: ${curriedTransparentize(0.2, "black")};
  }

  &:hover {
    opacity: 1;
    &:after {
      display: block;
    }
  }
`;
	var Button2 = import_styled_components17.default.div`
  background: none;
  position: relative;
  border: 0;
  transition: transform 0.1s ease-out;
  z-index: 0;
  outline: none;
  cursor: pointer;

  &:after {
    display: none;
    ${Container10}:hover & {
      display: block;
    }
    position: absolute;
    left: -4px;
    right: -4px;
    top: -4px;
    bottom: -4px;
    content: ' ';
    z-index: -1;
  }
`;
	var nextPrevCursorsTheme = {
	  offColor: "#555",
	  onColor: "#e0c917"
	};
	var CurButton = (0, import_styled_components17.default)(Button2)`
  &:hover {
    color: #e0c917;
  }
  color: ${(props) => props.isOn ? nextPrevCursorsTheme.onColor : nextPrevCursorsTheme.offColor};
`;
	var pointerEventsNone = import_styled_components17.css`
  pointer-events: none !important;
`;
	var PrevOrNextButton = (0, import_styled_components17.default)(Button2)`
  color: ${(props) => props.available ? nextPrevCursorsTheme.onColor : nextPrevCursorsTheme.offColor};

  ${(props) => props.available ? pointerEventsAutoInNormalMode : pointerEventsNone};
`;
	var Prev = (0, import_styled_components17.default)(PrevOrNextButton)`
  transform: translateX(2px);
  ${Container10}:hover & {
    transform: translateX(-7px);
  }
`;
	var Next = (0, import_styled_components17.default)(PrevOrNextButton)`
  transform: translateX(-2px);

  ${Container10}:hover & {
    transform: translateX(7px);
  }
`;
	var Icons;
	(function(Icons2) {
	  const Chevron_Group = import_styled_components17.default.g`
    stroke-width: 1;
    ${PrevOrNextButton}:hover & path {
      stroke-width: 3;
    }
  `;
	  Icons2.Prev = () => /* @__PURE__ */ import_react56.default.createElement("svg", {
	    width: "12",
	    height: "12",
	    viewBox: "0 0 12 12",
	    fill: "none",
	    xmlns: "http://www.w3.org/2000/svg"
	  }, /* @__PURE__ */ import_react56.default.createElement(Chevron_Group, {
	    transform: `translate(6 3)`
	  }, /* @__PURE__ */ import_react56.default.createElement("path", {
	    d: "M4 1L1 4L4 7",
	    stroke: "currentColor"
	  })));
	  Icons2.Next = () => /* @__PURE__ */ import_react56.default.createElement("svg", {
	    width: "12",
	    height: "12",
	    viewBox: "0 0 12 12",
	    fill: "none",
	    xmlns: "http://www.w3.org/2000/svg"
	  }, /* @__PURE__ */ import_react56.default.createElement(Chevron_Group, {
	    transform: `translate(1 3)`
	  }, /* @__PURE__ */ import_react56.default.createElement("path", {
	    d: "M1 1L4 4L1 7",
	    stroke: "currentColor"
	  })));
	  const Cur_Group = import_styled_components17.default.g`
    stroke-width: 0;
    ${CurButton}:hover & path {
      stroke: currentColor;
      stroke-width: 2;
    }
  `;
	  Icons2.Cur = () => /* @__PURE__ */ import_react56.default.createElement("svg", {
	    width: "8",
	    height: "12",
	    viewBox: "0 0 8 12",
	    fill: "none",
	    xmlns: "http://www.w3.org/2000/svg"
	  }, /* @__PURE__ */ import_react56.default.createElement(Cur_Group, {
	    transform: "translate(1 4)"
	  }, /* @__PURE__ */ import_react56.default.createElement("path", {
	    d: "M3 0L6 3L3 6L0 3L3 0Z",
	    fill: "currentColor"
	  })));
	})(Icons || (Icons = {}));
	var NextPrevKeyframeCursors = (props) => {
	  return /* @__PURE__ */ import_react56.default.createElement(Container10, null, /* @__PURE__ */ import_react56.default.createElement(Prev, {
	    available: !!props.prev,
	    onClick: () => {
	      if (props.prev) {
	        props.jumpToPosition(props.prev.position);
	      }
	    }
	  }, /* @__PURE__ */ import_react56.default.createElement(Icons.Prev, null)), /* @__PURE__ */ import_react56.default.createElement(CurButton, {
	    isOn: !!props.cur,
	    onClick: () => {
	      props.toggleKeyframeOnCurrentPosition();
	    }
	  }, /* @__PURE__ */ import_react56.default.createElement(Icons.Cur, null)), /* @__PURE__ */ import_react56.default.createElement(Next, {
	    available: !!props.next,
	    onClick: () => {
	      if (props.next) {
	        props.jumpToPosition(props.next.position);
	      }
	    }
	  }, /* @__PURE__ */ import_react56.default.createElement(Icons.Next, null)));
	};
	var NextPrevKeyframeCursors_default = NextPrevKeyframeCursors;

	// studio/src/panels/DetailPanel/propEditors/utils/useEditingToolsForPrimitiveProp.tsx
	function useEditingToolsForPrimitiveProp(pointerToProp, obj, propConfig) {
	  return usePrism(() => {
	    var _a;
	    const pathToProp = (0, import_dataverse11.getPointerParts)(pointerToProp).path;
	    const final = obj.getValueByPointer(pointerToProp);
	    const callbacks = import_dataverse11.prism.memo("callbacks", () => {
	      let currentScrub = null;
	      return {
	        temporarilySetValue(v2) {
	          if (!currentScrub) {
	            currentScrub = getStudio().scrub();
	          }
	          currentScrub.capture((api) => {
	            api.set(pointerToProp, v2);
	          });
	        },
	        discardTemporaryValue() {
	          if (currentScrub) {
	            currentScrub.discard();
	            currentScrub = null;
	          }
	        },
	        permenantlySetValue(v2) {
	          if (currentScrub) {
	            currentScrub.capture((api) => {
	              api.set(pointerToProp, v2);
	            });
	            currentScrub.commit();
	            currentScrub = null;
	          } else {
	            getStudio().transaction((api) => {
	              api.set(pointerToProp, v2);
	            });
	          }
	        }
	      };
	    }, []);
	    const beingScrubbed = (0, import_dataverse11.val)(get_default(getStudio().atomP.ephemeral.projects.stateByProjectId[obj.address.projectId].stateBySheetId[obj.address.sheetId].stateByObjectKey[obj.address.objectKey].valuesBeingScrubbed, (0, import_dataverse11.getPointerParts)(pointerToProp).path)) === true;
	    const contextMenuItems = [];
	    const common = __spreadProps(__spreadValues({}, callbacks), {
	      value: final,
	      beingScrubbed,
	      contextMenuItems,
	      controlIndicators: /* @__PURE__ */ import_react58.default.createElement(import_react58.default.Fragment, null)
	    });
	    const isSequencable = isPropConfSequencable(propConfig);
	    if (isSequencable) {
	      const validSequencedTracks = (0, import_dataverse11.val)(obj.template.getMapOfValidSequenceTracks_forStudio());
	      const possibleSequenceTrackId = getDeep(validSequencedTracks, pathToProp);
	      const isSequenced = typeof possibleSequenceTrackId === "string";
	      if (isSequenced) {
	        contextMenuItems.push({
	          label: "Make static",
	          callback: () => {
	            getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	              const propAddress = __spreadProps(__spreadValues({}, obj.address), { pathToProp });
	              stateEditors2.coreByProject.historic.sheetsById.sequence.setPrimitivePropAsStatic(__spreadProps(__spreadValues({}, propAddress), {
	                value: obj.getValueByPointer(pointerToProp)
	              }));
	            });
	          }
	        });
	        const sequenceTrcackId = possibleSequenceTrackId;
	        const nearbyKeyframes = import_dataverse11.prism.sub("lcr", () => {
	          const track = (0, import_dataverse11.val)(obj.template.project.pointers.historic.sheetsById[obj.address.sheetId].sequence.tracksByObject[obj.address.objectKey].trackData[sequenceTrcackId]);
	          if (!track || track.keyframes.length === 0)
	            return {};
	          const pos = (0, import_dataverse11.val)(obj.sheet.getSequence().positionDerivation);
	          const i2 = track.keyframes.findIndex((kf) => kf.position >= pos);
	          if (i2 === -1)
	            return {
	              prev: last_default(track.keyframes)
	            };
	          const k2 = track.keyframes[i2];
	          if (k2.position === pos) {
	            return {
	              prev: i2 > 0 ? track.keyframes[i2 - 1] : void 0,
	              cur: k2,
	              next: i2 === track.keyframes.length - 1 ? void 0 : track.keyframes[i2 + 1]
	            };
	          } else {
	            return {
	              next: k2,
	              prev: i2 > 0 ? track.keyframes[i2 - 1] : void 0
	            };
	          }
	        }, [sequenceTrcackId]);
	        let shade;
	        if (common.beingScrubbed) {
	          shade = "Sequenced_OnKeyframe_BeingScrubbed";
	        } else {
	          if (nearbyKeyframes.cur) {
	            shade = "Sequenced_OnKeyframe";
	          } else if (((_a = nearbyKeyframes.prev) == null ? void 0 : _a.connectedRight) === true) {
	            shade = "Sequenced_BeingInterpolated";
	          } else {
	            shade = "Sequened_NotBeingInterpolated";
	          }
	        }
	        const nextPrevKeyframeCursors = /* @__PURE__ */ import_react58.default.createElement(NextPrevKeyframeCursors_default, __spreadProps(__spreadValues({}, nearbyKeyframes), {
	          jumpToPosition: (position2) => {
	            obj.sheet.getSequence().position = position2;
	          },
	          toggleKeyframeOnCurrentPosition: () => {
	            if (nearbyKeyframes.cur) {
	              getStudio().transaction((api) => {
	                api.unset(pointerToProp);
	              });
	            } else {
	              getStudio().transaction((api) => {
	                api.set(pointerToProp, common.value);
	              });
	            }
	          }
	        }));
	        const ret2 = __spreadProps(__spreadValues({}, common), {
	          type: "Sequenced",
	          shade,
	          nearbyKeyframes,
	          controlIndicators: nextPrevKeyframeCursors
	        });
	        return ret2;
	      }
	    }
	    contextMenuItems.push({
	      label: "Reset to default",
	      callback: () => {
	        getStudio().transaction(({ unset }) => {
	          unset(pointerToProp);
	        });
	      }
	    });
	    if (isSequencable) {
	      contextMenuItems.push({
	        label: "Sequence",
	        callback: () => {
	          getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	            const propAddress = __spreadProps(__spreadValues({}, obj.address), { pathToProp });
	            stateEditors2.coreByProject.historic.sheetsById.sequence.setPrimitivePropAsSequenced(propAddress);
	          });
	        }
	      });
	    }
	    const statics = (0, import_dataverse11.val)(obj.template.getStaticValues());
	    if (typeof getDeep(statics, pathToProp) !== "undefined") {
	      const ret2 = __spreadProps(__spreadValues({}, common), {
	        type: "Static",
	        shade: common.beingScrubbed ? "Static_BeingScrubbed" : "Static",
	        controlIndicators: /* @__PURE__ */ import_react58.default.createElement(DefaultValueIndicator_default, {
	          hasStaticOverride: true
	        })
	      });
	      return ret2;
	    }
	    const ret = __spreadProps(__spreadValues({}, common), {
	      type: "Default",
	      shade: "Default",
	      controlIndicators: /* @__PURE__ */ import_react58.default.createElement(DefaultValueIndicator_default, {
	        hasStaticOverride: false
	      })
	    });
	    return ret;
	  }, []);
	}
	var shadeToColor = {
	  Default: "#222",
	  Static: "#333",
	  Static_BeingScrubbed: "#91a100",
	  Sequenced_OnKeyframe: "#700202",
	  Sequenced_OnKeyframe_BeingScrubbed: "#c50000",
	  Sequenced_BeingInterpolated: "#0387a8",
	  Sequened_NotBeingInterpolated: "#004c5f"
	};
	function isPropConfSequencable(conf) {
	  return conf.type === "number";
	}

	// studio/src/panels/DetailPanel/propEditors/utils/SingleRowPropEditor.tsx
	var import_dataverse12 = __toModule(dist$1);

	// studio/src/uiComponents/simpleContextMenu/useContextMenu.tsx
	var import_react64 = __toModule(react.exports);

	// studio/src/uiComponents/simpleContextMenu/RightClickMenu/RightClickMenu.tsx
	var import_transparentize = __toModule(require_transparentize());
	var import_react61 = __toModule(react.exports);
	var import_react62 = __toModule(react.exports);
	var import_react_dom5 = __toModule(reactDom.exports);
	var import_styled_components19 = __toModule(require$$3);

	// studio/src/uiComponents/simpleContextMenu/RightClickMenu/Item.tsx
	var import_react59 = __toModule(react.exports);
	var import_styled_components18 = __toModule(require$$3);
	var height = 26;
	var Container11 = import_styled_components18.default.li`
  height: ${height}px;
  padding: 0 12px;
  margin: 0;
  display: flex;
  align-items: center;
  font-size: 11px;
  font-weight: 400;
  position: relative;
  pointer-events: ${(props) => props.enabled ? "auto" : "none"};
  color: ${(props) => props.enabled ? "white" : "#AAA"};

  &:after {
    position: absolute;
    inset: 2px 1px;
    display: block;
    content: ' ';
    pointer-events: none;
    z-index: -1;
    border-radius: 3px;
  }

  &:hover:after {
    background-color: rgba(63, 174, 191, 0.75);
  }
`;
	var Label = import_styled_components18.default.span``;
	var Item = (props) => {
	  return /* @__PURE__ */ import_react59.default.createElement(Container11, {
	    onClick: props.enabled ? props.onClick : noop_default2,
	    enabled: props.enabled
	  }, /* @__PURE__ */ import_react59.default.createElement(Label, null, props.label));
	};
	var Item_default = Item;

	// studio/src/uiComponents/useOnKeyDown.ts
	var import_react60 = __toModule(react.exports);
	function useOnKeyDown(callback) {
	  const ref = (0, import_react60.useRef)(callback);
	  ref.current = callback;
	  (0, import_react60.useEffect)(() => {
	    const onKeyDown = (ev) => ref.current(ev);
	    window.addEventListener("keydown", onKeyDown);
	    return () => {
	      window.removeEventListener("keydown", onKeyDown);
	    };
	  }, []);
	}

	// studio/src/uiComponents/simpleContextMenu/RightClickMenu/RightClickMenu.tsx
	var minWidth = 190;
	var pointerDistanceThreshold = 20;
	var Container12 = import_styled_components19.default.ul`
  position: absolute;
  min-width: ${minWidth}px;
  z-index: 10000;
  background: ${(0, import_transparentize.default)(0.2, "#111")};
  backdrop-filter: blur(2px);
  color: white;
  list-style-type: none;
  padding: 2px 0;
  margin: 0;
  border-radius: 1px;
  cursor: default;
  ${pointerEventsAutoInNormalMode};
  border-radius: 3px;
`;
	var RightClickMenu = (props) => {
	  const [container, setContainer] = (0, import_react62.useState)(null);
	  const rect = useBoundingClientRect(container);
	  const windowSize = useWindowSize_default();
	  (0, import_react62.useLayoutEffect)(() => {
	    if (!rect || !container)
	      return;
	    const preferredAnchorPoint = {
	      left: rect.width / 2,
	      top: height / 2
	    };
	    const pos = {
	      left: props.rightClickPoint.clientX - preferredAnchorPoint.left,
	      top: props.rightClickPoint.clientY - preferredAnchorPoint.top
	    };
	    if (pos.left < 0) {
	      pos.left = 0;
	    } else if (pos.left + rect.width > windowSize.width) {
	      pos.left = windowSize.width - rect.width;
	    }
	    if (pos.top < 0) {
	      pos.top = 0;
	    } else if (pos.top + rect.height > windowSize.height) {
	      pos.top = windowSize.height - rect.height;
	    }
	    container.style.left = pos.left + "px";
	    container.style.top = pos.top + "px";
	    const onMouseMove = (e) => {
	      if (e.clientX < pos.left - pointerDistanceThreshold || e.clientX > pos.left + rect.width + pointerDistanceThreshold || e.clientY < pos.top - pointerDistanceThreshold || e.clientY > pos.top + rect.height + pointerDistanceThreshold) {
	        props.onRequestClose();
	      }
	    };
	    window.addEventListener("mousemove", onMouseMove);
	    return () => {
	      window.removeEventListener("mousemove", onMouseMove);
	    };
	  }, [rect, container, props.rightClickPoint, windowSize, props.onRequestClose]);
	  const portalLayer = (0, import_react61.useContext)(PortalContext);
	  useOnKeyDown((ev) => {
	    if (ev.key === "Escape")
	      props.onRequestClose();
	  });
	  const items = Array.isArray(props.items) ? props.items : props.items();
	  return (0, import_react_dom5.createPortal)(/* @__PURE__ */ import_react62.default.createElement(Container12, {
	    ref: setContainer
	  }, items.map((item, i2) => /* @__PURE__ */ import_react62.default.createElement(Item_default, {
	    key: `item-${i2}`,
	    label: item.label,
	    enabled: item.enabled === false ? false : true,
	    onClick: (e) => {
	      if (item.callback) {
	        item.callback(e);
	      }
	      props.onRequestClose();
	    }
	  }))), portalLayer);
	};
	var RightClickMenu_default = RightClickMenu;

	// studio/src/uiComponents/simpleContextMenu/useRequestContextMenu.ts
	var import_react63 = __toModule(react.exports);
	var useRequestContextMenu = (target) => {
	  const [state, setState] = (0, import_react63.useState)({ isOpen: false });
	  const close = (0, import_react63.useCallback)(() => setState({ isOpen: false }), []);
	  (0, import_react63.useEffect)(() => {
	    if (!target) {
	      setState({ isOpen: false });
	      return;
	    }
	    const onContextMenu = (event) => {
	      setState({ isOpen: true, event });
	      event.preventDefault();
	      event.stopPropagation();
	    };
	    target.addEventListener("contextmenu", onContextMenu);
	    return () => {
	      target.removeEventListener("contextmenu", onContextMenu);
	    };
	  }, [target]);
	  return [state, close];
	};
	var useRequestContextMenu_default = useRequestContextMenu;

	// studio/src/uiComponents/simpleContextMenu/useContextMenu.tsx
	var emptyNode = /* @__PURE__ */ import_react64.default.createElement(import_react64.default.Fragment, null);
	function useContextMenu(target, props) {
	  const [status, close] = useRequestContextMenu_default(target);
	  const node = !status.isOpen ? emptyNode : /* @__PURE__ */ import_react64.default.createElement(RightClickMenu_default, {
	    items: props.items,
	    rightClickPoint: status.event,
	    onRequestClose: close
	  });
	  return [node, close, status.isOpen];
	}

	// studio/src/panels/DetailPanel/propEditors/utils/SingleRowPropEditor.tsx
	var import_react65 = __toModule(react.exports);
	var import_styled_components20 = __toModule(require$$3);
	var indentationFormula = `calc(var(--left-pad) + var(--depth) * var(--step))`;
	var rowBgColor = curriedTransparentize(0.05, "#282b2f");
	var rowBg = import_styled_components20.css`
  &:after,
  &:before {
    position: absolute;
    display: block;
    content: ' ';
    z-index: -1;
    box-sizing: content-box;
  }

  &:after {
    inset: 0px 0 1px calc(-2px + var(--left-pad) + var(--depth) * var(--step));
    background-color: ${rowBgColor};
  }

  &:before {
    height: 2px;
    right: 0;
    bottom: 0px;
    left: calc(-2px + var(--left-pad) + var(--depth) * var(--step));
    background-color: ${curriedTransparentize(0.2, rowBgColor)};
  }
`;
	var propNameText = import_styled_components20.css`
  font-weight: 300;
  font-size: 11px;
  color: #9a9a9a;
  text-shadow: 0.5px 0.5px 2px rgba(0, 0, 0, 0.3);
`;
	var Row = import_styled_components20.default.div`
  display: flex;
  height: 30px;
  justify-content: flex-start;
  align-items: stretch;
  --right-width: 60%;
  position: relative;
  ${pointerEventsAutoInNormalMode};

  ${rowBg};
`;
	var Left = import_styled_components20.default.div`
  box-sizing: border-box;
  padding-left: ${indentationFormula};
  padding-right: 4px;
  display: flex;
  flex-direction: row;
  justify-content: flex-start;
  align-items: stretch;
  gap: 4px;
  flex-grow: 0;
  flex-shrink: 0;
  width: calc(100% - var(--right-width));
`;
	var PropNameContainer = import_styled_components20.default.div`
  text-align: left;
  flex: 1 0;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  display: flex;
  align-items: center;
  user-select: none;
  cursor: default;

  ${propNameText};
  &:hover {
    color: white;
  }
`;
	var ControlsContainer = import_styled_components20.default.div`
  flex-basis: 8px;
  flex: 0 0;
  display: flex;
  align-items: center;
`;
	var InputContainer = import_styled_components20.default.div`
  display: flex;
  align-items: center;
  justify-content: stretch;
  padding: 0 8px 0 2px;
  box-sizing: border-box;
  height: 100%;
  width: var(--right-width);
  flex-shrink: 0;
  flex-grow: 0;
`;
	var SingleRowPropEditor = ({ propConfig, pointerToProp, stuff, children }) => {
	  var _a;
	  const label = (_a = propConfig.label) != null ? _a : last_default((0, import_dataverse12.getPointerParts)(pointerToProp).path);
	  const [propNameContainerRef, propNameContainer] = useRefAndState(null);
	  const [contextMenu] = useContextMenu(propNameContainer, {
	    items: stuff.contextMenuItems
	  });
	  shadeToColor[stuff.shade];
	  return /* @__PURE__ */ import_react65.default.createElement(Row, null, contextMenu, /* @__PURE__ */ import_react65.default.createElement(Left, null, /* @__PURE__ */ import_react65.default.createElement(ControlsContainer, null, stuff.controlIndicators), /* @__PURE__ */ import_react65.default.createElement(PropNameContainer, {
	    ref: propNameContainerRef,
	    title: ["obj", "props", ...(0, import_dataverse12.getPointerParts)(pointerToProp).path].join(".")
	  }, label)), /* @__PURE__ */ import_react65.default.createElement(InputContainer, null, children));
	};

	// studio/src/panels/DetailPanel/propEditors/BooleanPropEditor.tsx
	var import_styled_components22 = __toModule(require$$3);

	// studio/src/uiComponents/form/BasicCheckbox.tsx
	var import_styled_components21 = __toModule(require$$3);
	var BasicCheckbox = import_styled_components21.default.input.attrs({ type: "checkbox" })`
  outline: none;
`;
	var BasicCheckbox_default = BasicCheckbox;

	// studio/src/panels/DetailPanel/propEditors/BooleanPropEditor.tsx
	var Input = (0, import_styled_components22.default)(BasicCheckbox_default)`
  margin-left: 6px;
`;
	var BooleanPropEditor = ({ propConfig, pointerToProp, obj }) => {
	  const stuff = useEditingToolsForPrimitiveProp(pointerToProp, obj, propConfig);
	  const onChange = (0, import_react66.useCallback)((el) => {
	    stuff.permenantlySetValue(Boolean(el.target.checked));
	  }, [propConfig, pointerToProp, obj]);
	  return /* @__PURE__ */ import_react66.default.createElement(SingleRowPropEditor, __spreadValues({}, { stuff, propConfig, pointerToProp }), /* @__PURE__ */ import_react66.default.createElement(Input, {
	    checked: stuff.value,
	    onChange
	  }));
	};
	var BooleanPropEditor_default = BooleanPropEditor;

	// shared/src/propTypes/utils.ts
	function isPropConfigComposite(c2) {
	  return c2.type === "compound" || c2.type === "enum";
	}

	// studio/src/panels/DetailPanel/propEditors/CompoundPropEditor.tsx
	var import_dataverse13 = __toModule(dist$1);
	var import_react67 = __toModule(react.exports);
	var import_styled_components23 = __toModule(require$$3);
	var Container13 = import_styled_components23.default.div`
  --step: 8px;
  --left-pad: 0px;
  ${pointerEventsAutoInNormalMode};
`;
	var Header2 = import_styled_components23.default.div`
  height: 30px;
  display: flex;
  align-items: stretch;
  position: relative;

  ${rowBg};
`;
	var Padding = import_styled_components23.default.div`
  padding-left: ${indentationFormula};
  display: flex;
  align-items: center;
`;
	var PropName = import_styled_components23.default.div`
  margin-left: 4px;
  cursor: default;
  height: 100%;
  display: flex;
  align-items: center;
  user-select: none;
  &:hover {
    /* color: white; */
  }

  ${() => propNameText};
`;
	var color = curriedTransparentize(0.05, `#282b2f`);
	var SubProps = import_styled_components23.default.div`
  /* background: ${({ depth }) => curriedDarken(depth * 0.03, color)}; */
  /* padding: ${(props) => props.lastSubIsComposite ? 0 : "4px"} 0; */
`;
	var CompoundPropEditor = ({ pointerToProp, obj, propConfig, depth }) => {
	  var _a;
	  const propName = (_a = propConfig.label) != null ? _a : last_default((0, import_dataverse13.getPointerParts)(pointerToProp).path);
	  const allSubs = Object.entries(propConfig.props);
	  const compositeSubs = allSubs.filter(([_2, conf]) => isPropConfigComposite(conf));
	  const nonCompositeSubs = allSubs.filter(([_2, conf]) => !isPropConfigComposite(conf));
	  const [propNameContainerRef, propNameContainer] = useRefAndState(null);
	  const lastSubPropIsComposite = compositeSubs.length > 0;
	  return /* @__PURE__ */ import_react67.default.createElement(Container13, null, /* @__PURE__ */ import_react67.default.createElement(Header2, {
	    style: { "--depth": depth - 1 }
	  }, /* @__PURE__ */ import_react67.default.createElement(Padding, null, /* @__PURE__ */ import_react67.default.createElement(DefaultValueIndicator_default, {
	    hasStaticOverride: false
	  }), /* @__PURE__ */ import_react67.default.createElement(PropName, {
	    ref: propNameContainerRef
	  }, propName || "Props"))), /* @__PURE__ */ import_react67.default.createElement(SubProps, {
	    style: { "--depth": depth },
	    depth,
	    lastSubIsComposite: lastSubPropIsComposite
	  }, [...nonCompositeSubs, ...compositeSubs].map(([subPropKey, subPropConfig]) => {
	    return /* @__PURE__ */ import_react67.default.createElement(DeterminePropEditor_default, {
	      key: "prop-" + subPropKey,
	      propConfig: subPropConfig,
	      pointerToProp: pointerToProp[subPropKey],
	      obj,
	      depth: depth + 1
	    });
	  })));
	};
	var CompoundPropEditor_default = CompoundPropEditor;

	// studio/src/uiComponents/form/BasicNumberInput.tsx
	var import_react69 = __toModule(react.exports);
	var import_styled_components24 = __toModule(require$$3);

	// shared/src/utils/index.ts
	var voidFn = () => {
	};
	var emptyArray = [];

	// studio/src/uiComponents/DraggableArea.tsx
	var import_react68 = __toModule(react.exports);
	function createCursorLock(cursor) {
	  const el = document.createElement("div");
	  el.style.cssText = `
    position: fixed;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    z-index: 9999999;`;
	  el.style.cursor = cursor;
	  document.body.appendChild(el);
	  const relinquish = () => {
	    document.body.removeChild(el);
	  };
	  return relinquish;
	}
	var DraggableArea = class extends import_react68.default.PureComponent {
	  constructor(props) {
	    super(props);
	    __publicField(this, "s");
	    __publicField(this, "mode", "notDragging");
	    __publicField(this, "getDeltas");
	    __publicField(this, "relinquishCursorLock", voidFn);
	    __publicField(this, "disableUnwantedClick", (event) => {
	      if (this.s.dragHappened) {
	        if (!this.props.dontBlockMouseDown && this.mode !== "notDragging") {
	          event.stopPropagation();
	          event.preventDefault();
	        }
	        this.s.dragHappened = false;
	      }
	    });
	    __publicField(this, "dragStartHandler", (event) => {
	      if (event.button !== 0)
	        return;
	      const resultOfStart = this.props.onDragStart && this.props.onDragStart(event);
	      if (resultOfStart === false)
	        return;
	      if (!this.props.dontBlockMouseDown) {
	        event.stopPropagation();
	        event.preventDefault();
	      }
	      this.mode = "dragStartCalled";
	      const { screenX, screenY } = event;
	      this.s.startPos = { x: screenX, y: screenY };
	      this.s.dragHappened = false;
	      this.addDragListeners();
	    });
	    __publicField(this, "dragEndHandler", () => {
	      this.removeDragListeners();
	      this.mode = "notDragging";
	      this.props.onDragEnd && this.props.onDragEnd(this.s.dragHappened);
	      this.relinquishCursorLock();
	      this.relinquishCursorLock = voidFn;
	    });
	    __publicField(this, "dragHandler", (event) => {
	      if (!this.s.dragHappened && this.props.lockCursorTo) {
	        this.relinquishCursorLock = createCursorLock(this.props.lockCursorTo);
	      }
	      if (!this.s.dragHappened)
	        this.s.dragHappened = true;
	      this.mode = "dragging";
	      const deltas = this.getDeltas(event);
	      this.props.onDrag(deltas[0], deltas[1], event);
	    });
	    this.s = {
	      dragHappened: false,
	      startPos: {
	        x: 0,
	        y: 0
	      }
	    };
	    if (props.shouldReturnMovement) {
	      this.getDeltas = this.getMovements;
	    } else {
	      this.getDeltas = this.getDistances;
	    }
	  }
	  render() {
	    const shouldRegisterEvents = this.props.enabled !== false;
	    const children = shouldRegisterEvents ? import_react68.default.cloneElement(this.props.children, {
	      onMouseDown: this.dragStartHandler,
	      onClickCapture: this.disableUnwantedClick
	    }) : this.props.children;
	    return children;
	  }
	  addDragListeners() {
	    document.addEventListener("mousemove", this.dragHandler);
	    document.addEventListener("mouseup", this.dragEndHandler);
	  }
	  removeDragListeners() {
	    document.removeEventListener("mousemove", this.dragHandler);
	    document.removeEventListener("mouseup", this.dragEndHandler);
	  }
	  UNSAFE_componentWillReceiveProps(newProps) {
	    if (newProps.lockCursorTo !== this.props.lockCursorTo && this.s.dragHappened) {
	      this.relinquishCursorLock();
	      this.relinquishCursorLock = voidFn;
	      if (newProps.lockCursorTo) {
	        this.relinquishCursorLock = createCursorLock(newProps.lockCursorTo);
	      }
	    }
	  }
	  getDistances(event) {
	    const { startPos } = this.s;
	    return [event.screenX - startPos.x, event.screenY - startPos.y];
	  }
	  getMovements(event) {
	    return [event.movementX, event.movementY];
	  }
	  componentWillUnmount() {
	    if (this.mode !== "notDragging") {
	      this.relinquishCursorLock();
	      this.relinquishCursorLock = voidFn;
	      this.removeDragListeners();
	      this.props.onDragEnd && this.props.onDragEnd(this.mode === "dragging");
	      this.mode = "notDragging";
	    }
	  }
	};
	var DraggableArea_default = DraggableArea;

	// studio/src/uiComponents/form/BasicNumberInput.tsx
	var Container14 = import_styled_components24.default.div`
  height: 100%;
  width: 100%;
  position: relative;
  z-index: 0;
  box-sizing: border-box;
  display: flex;
  align-items: center;

  &:after {
    position: absolute;
    inset: 1px 0 2px;
    display: block;
    content: ' ';
    background-color: transparent;
    border: 1px solid transparent;
    z-index: -2;
    box-sizing: border-box;
    border-radius: 1px;
  }

  &:hover,
  &.dragging,
  &.editingViaKeyboard {
    &:after {
      background-color: #10101042;
      border-color: #00000059;
    }
  }
`;
	var Input2 = import_styled_components24.default.input`
  background: transparent;
  border: 1px solid transparent;
  color: rgba(255, 255, 255, 0.9);
  padding: 1px 6px;
  font: inherit;
  outline: none;
  cursor: ew-resize;
  text-align: left;
  width: 100%;
  height: calc(100% - 4px);
  border-radius: 2px;

  &:focus {
    cursor: text;
  }
`;
	var FillIndicator = import_styled_components24.default.div`
  position: absolute;
  inset: 3px 2px 4px;
  transform: scale(var(--percentage), 1);
  transform-origin: top left;
  background-color: #2d5561;
  z-index: -1;
  border-radius: 2px;
  pointer-events: none;

  ${Container14}.dragging &, ${Container14}.noFocus:hover & {
    background-color: #338198;
  }
`;
	var alwaysValid = (v2) => true;
	var BasicNumberInput = (propsA) => {
	  var _a;
	  const [stateA, setState] = (0, import_react69.useState)({ mode: "noFocus" });
	  const isValid = (_a = propsA.isValid) != null ? _a : alwaysValid;
	  const refs = (0, import_react69.useRef)({ state: stateA, props: propsA });
	  refs.current = { state: stateA, props: propsA };
	  const inputRef = (0, import_react69.useRef)(null);
	  const bodyCursorBeforeDrag = (0, import_react69.useRef)(null);
	  const callbacks = (0, import_react69.useMemo)(() => {
	    const inputChange = (e) => {
	      const target = e.target;
	      const { value: value2 } = target;
	      const curState = refs.current.state;
	      setState(__spreadProps(__spreadValues({}, curState), { currentEditedValueInString: value2 }));
	      const valInFloat = parseFloat(value2);
	      if (!isFinite(valInFloat) || !isValid(valInFloat))
	        return;
	      refs.current.props.temporarilySetValue(valInFloat);
	    };
	    const onBlur = () => {
	      if (refs.current.state.mode === "editingViaKeyboard") {
	        commitKeyboardInput();
	        setState({ mode: "noFocus" });
	      }
	      if (propsA.onBlur)
	        propsA.onBlur();
	    };
	    const commitKeyboardInput = () => {
	      const curState = refs.current.state;
	      const value2 = parseFloat(curState.currentEditedValueInString);
	      if (!isFinite(value2) || !isValid(value2)) {
	        refs.current.props.discardTemporaryValue();
	      } else {
	        if (curState.valueBeforeEditing === value2) {
	          refs.current.props.discardTemporaryValue();
	        } else {
	          refs.current.props.permenantlySetValue(value2);
	        }
	      }
	    };
	    const onInputKeyDown = (e) => {
	      if (e.key === "Escape") {
	        refs.current.props.discardTemporaryValue();
	        inputRef.current.blur();
	      } else if (e.key === "Enter" || e.key === "Tab") {
	        commitKeyboardInput();
	        inputRef.current.blur();
	      }
	    };
	    const onClick = (e) => {
	      if (refs.current.state.mode === "noFocus") {
	        const c2 = inputRef.current;
	        c2.focus();
	        e.preventDefault();
	        e.stopPropagation();
	      } else {
	        e.stopPropagation();
	      }
	    };
	    const onFocus = () => {
	      if (refs.current.state.mode === "noFocus") {
	        transitionToEditingViaKeyboardMode();
	      } else if (refs.current.state.mode === "editingViaKeyboard") ;
	    };
	    const transitionToEditingViaKeyboardMode = () => {
	      const curValue = refs.current.props.value;
	      setState({
	        mode: "editingViaKeyboard",
	        currentEditedValueInString: String(curValue),
	        valueBeforeEditing: curValue
	      });
	      setTimeout(() => {
	        inputRef.current.focus();
	        inputRef.current.setSelectionRange(0, 100);
	      });
	    };
	    let inputWidth;
	    const transitionToDraggingMode = () => {
	      var _a2;
	      const curValue = refs.current.props.value;
	      inputWidth = (_a2 = inputRef.current) == null ? void 0 : _a2.getBoundingClientRect().width;
	      setState({
	        mode: "dragging",
	        valueBeforeDragging: curValue,
	        currentDraggingValue: curValue
	      });
	      bodyCursorBeforeDrag.current = document.body.style.cursor;
	    };
	    const onDragEnd = (happened) => {
	      if (!happened) {
	        refs.current.props.discardTemporaryValue();
	        setState({ mode: "noFocus" });
	        inputRef.current.focus();
	        inputRef.current.setSelectionRange(0, 100);
	      } else {
	        const curState = refs.current.state;
	        const value2 = curState.currentDraggingValue;
	        if (curState.valueBeforeDragging === value2) {
	          refs.current.props.discardTemporaryValue();
	        } else {
	          refs.current.props.permenantlySetValue(value2);
	        }
	        setState({ mode: "noFocus" });
	      }
	    };
	    const onDrag = (deltaX, _dy) => {
	      const curState = refs.current.state;
	      let newValue = curState.valueBeforeDragging + propsA.nudge({
	        deltaX,
	        deltaFraction: deltaX / inputWidth,
	        magnitude: 1
	      });
	      if (propsA.range) {
	        newValue = clamp_default(newValue, propsA.range[0], propsA.range[1]);
	      }
	      setState(__spreadProps(__spreadValues({}, curState), {
	        currentDraggingValue: newValue
	      }));
	      refs.current.props.temporarilySetValue(newValue);
	    };
	    return {
	      inputChange,
	      onBlur,
	      transitionToDraggingMode,
	      onInputKeyDown,
	      onClick,
	      onFocus,
	      onDragEnd,
	      onDrag
	    };
	  }, [refs, setState, inputRef]);
	  let value = stateA.mode !== "editingViaKeyboard" ? format2(propsA.value) : stateA.currentEditedValueInString;
	  if (typeof value === "number" && isNaN(value)) {
	    value = "NaN";
	  }
	  const _refs = [inputRef];
	  if (propsA.inputRef)
	    _refs.push(propsA.inputRef);
	  const theInput = /* @__PURE__ */ import_react69.default.createElement(Input2, {
	    key: "input",
	    type: "text",
	    onChange: callbacks.inputChange,
	    value,
	    onBlur: callbacks.onBlur,
	    onKeyDown: callbacks.onInputKeyDown,
	    onClick: callbacks.onClick,
	    onFocus: callbacks.onFocus,
	    ref: react_merge_refs_esm_default(_refs),
	    onMouseDown: (e) => {
	      e.stopPropagation();
	    },
	    onDoubleClick: (e) => {
	      e.preventDefault();
	      e.stopPropagation();
	    }
	  });
	  const { range } = propsA;
	  const num = parseFloat(value);
	  const fillIndicator = range ? /* @__PURE__ */ import_react69.default.createElement(FillIndicator, {
	    style: {
	      "--percentage": clamp_default((num - range[0]) / (range[1] - range[0]), 0, 1)
	    }
	  }) : null;
	  return /* @__PURE__ */ import_react69.default.createElement(Container14, {
	    className: propsA.className + " " + refs.current.state.mode
	  }, /* @__PURE__ */ import_react69.default.createElement(DraggableArea_default, {
	    key: "draggableArea",
	    onDragStart: callbacks.transitionToDraggingMode,
	    onDragEnd: callbacks.onDragEnd,
	    onDrag: callbacks.onDrag,
	    enabled: refs.current.state.mode !== "editingViaKeyboard",
	    lockCursorTo: "ew-resize"
	  }, theInput), fillIndicator);
	};
	function format2(v2) {
	  return isNaN(v2) ? "NaN" : isInteger_default(v2) ? v2.toFixed(0) : round_default(v2, 3).toString();
	}
	var BasicNumberInput_default = BasicNumberInput;

	// studio/src/panels/DetailPanel/propEditors/NumberPropEditor.tsx
	var import_react70 = __toModule(react.exports);
	var NumberPropEditor = ({ propConfig, pointerToProp, obj }) => {
	  const stuff = useEditingToolsForPrimitiveProp(pointerToProp, obj, propConfig);
	  const nudge2 = (0, import_react70.useCallback)((params) => {
	    return propConfig.nudgeFn(__spreadProps(__spreadValues({}, params), { config: propConfig }));
	  }, [propConfig]);
	  return /* @__PURE__ */ import_react70.default.createElement(SingleRowPropEditor, __spreadValues({}, { stuff, propConfig, pointerToProp }), /* @__PURE__ */ import_react70.default.createElement(BasicNumberInput_default, {
	    value: stuff.value,
	    temporarilySetValue: stuff.temporarilySetValue,
	    discardTemporaryValue: stuff.discardTemporaryValue,
	    permenantlySetValue: stuff.permenantlySetValue,
	    range: propConfig.range,
	    nudge: nudge2
	  }));
	};
	var NumberPropEditor_default = NumberPropEditor;

	// studio/src/panels/DetailPanel/propEditors/StringLiteralPropEditor.tsx
	var import_react73 = __toModule(react.exports);

	// studio/src/uiComponents/form/BasicSwitch.tsx
	var import_react71 = __toModule(react.exports);
	var import_styled_components25 = __toModule(require$$3);
	var Container15 = import_styled_components25.default.form`
  display: flex;
  flex-direction: row;
  align-items: stretch;
  vertical-align: middle;
  justify-content: stretch;
  height: 24px;
  width: 100%;
`;
	var Label2 = import_styled_components25.default.label`
  padding: 0 0.5em;
  background: transparent;
  /* background: #373748; */
  display: flex;
  align-items: center;
  justify-content: center;
  flex-grow: 1;
  color: #a7a7a7;
  border: 1px solid transparent;
  box-sizing: border-box;
  border-right-width: 0px;

  & + &:last-child {
    border-right-width: 1px;
  }

  ${Container15}:hover > & {
    border-color: #1c2123;
    /* background-color: #373748; */
    /* color: ${curriedDarken(0.1, "white")}; */
  }

  &&:hover {
    background-color: #464654;
  }

  &&[data-checked='true'] {
    color: white;
    background: #3f3f4c;
  }
`;
	var Input3 = import_styled_components25.default.input`
  position: absolute;
  opacity: 0;
  pointer-events: none;
  width: 0;
  height: 0;
`;
	var BasicSwitch = ({ value, onChange, options }) => {
	  const _onChange = (0, import_react71.useCallback)((el) => {
	    onChange(String(el.target.value));
	  }, [onChange]);
	  return /* @__PURE__ */ import_react71.default.createElement(Container15, {
	    role: "radiogroup"
	  }, Object.keys(options).map((key, i2) => /* @__PURE__ */ import_react71.default.createElement(Label2, {
	    key: "label-" + i2,
	    "data-checked": value === key
	  }, options[key], /* @__PURE__ */ import_react71.default.createElement(Input3, {
	    type: "radio",
	    checked: value === key,
	    value: key,
	    onChange: _onChange,
	    name: "switchbox"
	  }))));
	};
	var BasicSwitch_default = BasicSwitch;

	// studio/src/uiComponents/form/BasicSelect.tsx
	var import_react72 = __toModule(react.exports);
	var import_styled_components26 = __toModule(require$$3);
	var Container16 = import_styled_components26.default.div`
  width: 100%;
  position: relative;
`;
	var IconContainer = import_styled_components26.default.div`
  position: absolute;
  right: 0px;
  top: 0;
  bottom: 0;
  width: 1.5em;
  font-size: 14px;
  display: flex;
  align-items: center;
  color: #6b7280;
  pointer-events: none;
`;
	var Select = import_styled_components26.default.select`
  background-color: transparent;
  box-sizing: border-box;
  border: 1px solid transparent;
  color: rgba(255, 255, 255, 0.85);
  padding: 1px 6px;
  font: inherit;
  outline: none;
  text-align: left;
  width: 100%;
  height: calc(100% - 4px);
  border-radius: 2px;

  color-adjust: exact;
  appearance: none;

  &:hover,
  &:focus {
    background-color: #10101042;
    border-color: #00000059;
  }
`;
	var BasicSelect = ({ value, onChange, options, className }) => {
	  const _onChange = (0, import_react72.useCallback)((el) => {
	    onChange(String(el.target.value));
	  }, [onChange]);
	  return /* @__PURE__ */ import_react72.default.createElement(Container16, null, /* @__PURE__ */ import_react72.default.createElement(Select, {
	    className,
	    value,
	    onChange: _onChange
	  }, Object.keys(options).map((key, i2) => /* @__PURE__ */ import_react72.default.createElement("option", {
	    key: "option-" + i2,
	    value: key
	  }, options[key]))), /* @__PURE__ */ import_react72.default.createElement(IconContainer, null, /* @__PURE__ */ import_react72.default.createElement(CgSelect, null)));
	};
	var BasicSelect_default = BasicSelect;

	// studio/src/panels/DetailPanel/propEditors/StringLiteralPropEditor.tsx
	var StringLiteralPropEditor = ({ propConfig, pointerToProp, obj }) => {
	  const stuff = useEditingToolsForPrimitiveProp(pointerToProp, obj, propConfig);
	  const onChange = (0, import_react73.useCallback)((val39) => {
	    stuff.permenantlySetValue(val39);
	  }, [propConfig, pointerToProp, obj]);
	  return /* @__PURE__ */ import_react73.default.createElement(SingleRowPropEditor, __spreadValues({}, { stuff, propConfig, pointerToProp }), propConfig.as === "menu" ? /* @__PURE__ */ import_react73.default.createElement(BasicSelect_default, {
	    value: stuff.value,
	    onChange,
	    options: propConfig.options
	  }) : /* @__PURE__ */ import_react73.default.createElement(BasicSwitch_default, {
	    value: stuff.value,
	    onChange,
	    options: propConfig.options
	  }));
	};
	var StringLiteralPropEditor_default = StringLiteralPropEditor;

	// studio/src/panels/DetailPanel/propEditors/StringPropEditor.tsx
	var import_react75 = __toModule(react.exports);

	// studio/src/uiComponents/form/BasicStringInput.tsx
	var import_styled_components27 = __toModule(require$$3);
	var import_react74 = __toModule(react.exports);
	var Input4 = import_styled_components27.default.input.attrs({ type: "text" })`
  background: transparent;
  border: 1px solid transparent;
  color: rgba(255, 255, 255, 0.9);
  padding: 1px 6px;
  font: inherit;
  outline: none;
  cursor: text;
  text-align: left;
  width: 100%;
  height: calc(100% - 4px);
  border-radius: 2px;
  border: 1px solid transparent;
  box-sizing: border-box;

  &:hover {
    background-color: #10101042;
    border-color: #00000059;
  }

  &:hover,
  &:focus {
    cursor: text;
    background-color: #10101042;
    border-color: #00000059;
  }
`;
	var alwaysValid2 = (v2) => true;
	var BasicStringInput = (propsA) => {
	  var _a;
	  const [stateA, setState] = (0, import_react74.useState)({ mode: "noFocus" });
	  const isValid = (_a = propsA.isValid) != null ? _a : alwaysValid2;
	  const refs = (0, import_react74.useRef)({ state: stateA, props: propsA });
	  refs.current = { state: stateA, props: propsA };
	  const inputRef = (0, import_react74.useRef)(null);
	  const callbacks = (0, import_react74.useMemo)(() => {
	    const inputChange = (e) => {
	      const target = e.target;
	      const { value: value2 } = target;
	      const curState = refs.current.state;
	      setState(__spreadProps(__spreadValues({}, curState), { currentEditedValueInString: value2 }));
	      if (!isValid(value2))
	        return;
	      refs.current.props.temporarilySetValue(value2);
	    };
	    const onBlur = () => {
	      if (refs.current.state.mode === "editingViaKeyboard") {
	        commitKeyboardInput();
	        setState({ mode: "noFocus" });
	      }
	      if (propsA.onBlur)
	        propsA.onBlur();
	    };
	    const commitKeyboardInput = () => {
	      const curState = refs.current.state;
	      const value2 = curState.currentEditedValueInString;
	      if (!isValid(value2)) {
	        refs.current.props.discardTemporaryValue();
	      } else {
	        if (curState.valueBeforeEditing === value2) {
	          refs.current.props.discardTemporaryValue();
	        } else {
	          refs.current.props.permenantlySetValue(value2);
	        }
	      }
	    };
	    const onInputKeyDown = (e) => {
	      if (e.key === "Escape") {
	        refs.current.props.discardTemporaryValue();
	        inputRef.current.blur();
	      } else if (e.key === "Enter" || e.key === "Tab") {
	        commitKeyboardInput();
	        inputRef.current.blur();
	      }
	    };
	    const onClick = (e) => {
	      if (refs.current.state.mode === "noFocus") {
	        const c2 = inputRef.current;
	        c2.focus();
	        e.preventDefault();
	        e.stopPropagation();
	      } else {
	        e.stopPropagation();
	      }
	    };
	    const onFocus = () => {
	      if (refs.current.state.mode === "noFocus") {
	        transitionToEditingViaKeyboardMode();
	      } else if (refs.current.state.mode === "editingViaKeyboard") ;
	    };
	    const transitionToEditingViaKeyboardMode = () => {
	      const curValue = refs.current.props.value;
	      setState({
	        mode: "editingViaKeyboard",
	        currentEditedValueInString: String(curValue),
	        valueBeforeEditing: curValue
	      });
	      setTimeout(() => {
	        inputRef.current.focus();
	      });
	    };
	    return {
	      inputChange,
	      onBlur,
	      onInputKeyDown,
	      onClick,
	      onFocus
	    };
	  }, [refs, setState, inputRef]);
	  let value = stateA.mode !== "editingViaKeyboard" ? format3(propsA.value) : stateA.currentEditedValueInString;
	  const _refs = [inputRef];
	  if (propsA.inputRef)
	    _refs.push(propsA.inputRef);
	  const theInput = /* @__PURE__ */ import_react74.default.createElement(Input4, {
	    key: "input",
	    type: "text",
	    onChange: callbacks.inputChange,
	    value,
	    onBlur: callbacks.onBlur,
	    onKeyDown: callbacks.onInputKeyDown,
	    onClick: callbacks.onClick,
	    onFocus: callbacks.onFocus,
	    ref: react_merge_refs_esm_default(_refs),
	    onMouseDown: (e) => {
	      e.stopPropagation();
	    },
	    onDoubleClick: (e) => {
	      e.preventDefault();
	      e.stopPropagation();
	    }
	  });
	  return theInput;
	};
	function format3(v2) {
	  return v2;
	}
	var BasicStringInput_default = BasicStringInput;

	// studio/src/panels/DetailPanel/propEditors/StringPropEditor.tsx
	var StringPropEditor = ({ propConfig, pointerToProp, obj }) => {
	  const stuff = useEditingToolsForPrimitiveProp(pointerToProp, obj, propConfig);
	  return /* @__PURE__ */ import_react75.default.createElement(SingleRowPropEditor, __spreadValues({}, { stuff, propConfig, pointerToProp }), /* @__PURE__ */ import_react75.default.createElement(BasicStringInput_default, {
	    value: stuff.value,
	    temporarilySetValue: stuff.temporarilySetValue,
	    discardTemporaryValue: stuff.discardTemporaryValue,
	    permenantlySetValue: stuff.permenantlySetValue
	  }));
	};
	var StringPropEditor_default = StringPropEditor;

	// studio/src/panels/DetailPanel/propEditors/DeterminePropEditor.tsx
	var getPropTypeByPointer = (pointerToProp, obj) => {
	  const rootConf = obj.template.config.props;
	  const p2 = (0, import_dataverse14.getPointerParts)(pointerToProp).path;
	  let conf = rootConf;
	  while (p2.length !== 0) {
	    const key = p2.shift();
	    if (typeof key === "string") {
	      if (conf.type === "compound") {
	        conf = conf.props[key];
	        if (!conf) {
	          throw new Error(`getPropTypeConfigByPath() is called with an invalid path.`);
	        }
	      } else if (conf.type === "enum") {
	        conf = conf.cases[key];
	        if (!conf) {
	          throw new Error(`getPropTypeConfigByPath() is called with an invalid path.`);
	        }
	      } else {
	        throw new Error(`getPropTypeConfigByPath() is called with an invalid path.`);
	      }
	    } else if (typeof key === "number") {
	      throw new Error(`Number indexes are not implemented yet. @todo`);
	    } else {
	      throw new Error(`getPropTypeConfigByPath() is called with an invalid path.`);
	    }
	  }
	  return conf;
	};
	var propEditorByPropType = {
	  compound: CompoundPropEditor_default,
	  number: NumberPropEditor_default,
	  string: StringPropEditor_default,
	  enum: () => /* @__PURE__ */ import_react76.default.createElement(import_react76.default.Fragment, null),
	  boolean: BooleanPropEditor_default,
	  stringLiteral: StringLiteralPropEditor_default
	};
	var DeterminePropEditor = (p2) => {
	  var _a;
	  const propConfig = (_a = p2.propConfig) != null ? _a : getPropTypeByPointer(p2.pointerToProp, p2.obj);
	  const PropEditor = propEditorByPropType[propConfig.type];
	  return /* @__PURE__ */ import_react76.default.createElement(PropEditor, {
	    obj: p2.obj,
	    depth: p2.depth,
	    pointerToProp: p2.pointerToProp,
	    propConfig
	  });
	};
	var DeterminePropEditor_default = DeterminePropEditor;

	// studio/src/panels/DetailPanel/ObjectDetails.tsx
	var ObjectDetails = ({ objects }) => {
	  const obj = objects[0];
	  const key = (0, import_react77.useMemo)(() => JSON.stringify(obj.address), [obj]);
	  return /* @__PURE__ */ import_react77.default.createElement(DeterminePropEditor_default, {
	    key,
	    obj,
	    pointerToProp: obj.propsP,
	    propConfig: obj.template.config,
	    depth: 1
	  });
	};
	var ObjectDetails_default = ObjectDetails;

	// studio/src/uiComponents/Popover/usePopover.tsx
	var import_react78 = __toModule(react.exports);
	var import_react_dom6 = __toModule(reactDom.exports);
	function usePopover(opts, render) {
	  const [state, setState] = (0, import_react78.useState)({
	    isOpen: false
	  });
	  const open = (0, import_react78.useCallback)((e, target) => {
	    setState({
	      isOpen: true,
	      clickPoint: { clientX: e.clientX, clientY: e.clientY },
	      target
	    });
	  }, []);
	  const close = (0, import_react78.useCallback)(() => {
	    setState({ isOpen: false });
	  }, []);
	  const onClickOutside = (0, import_react78.useCallback)(() => {
	    if (opts.closeOnClickOutside !== false) {
	      close();
	    }
	  }, [opts.closeOnClickOutside]);
	  const portalLayer = (0, import_react78.useContext)(PortalContext);
	  const onPointerOutside2 = (0, import_react78.useMemo)(() => {
	    var _a;
	    if (opts.closeWhenPointerIsDistant === false)
	      return void 0;
	    return {
	      threshold: (_a = opts.pointerDistanceThreshold) != null ? _a : 100,
	      callback: close
	    };
	  }, [opts.closeWhenPointerIsDistant]);
	  const node = state.isOpen ? (0, import_react_dom6.createPortal)(/* @__PURE__ */ import_react78.default.createElement(TooltipWrapper_default, {
	    children: render,
	    target: state.target,
	    onClickOutside,
	    onPointerOutside: onPointerOutside2
	  }), portalLayer) : /* @__PURE__ */ import_react78.default.createElement(import_react78.default.Fragment, null);
	  return [node, open, close, state.isOpen];
	}

	// studio/src/panels/DetailPanel/ProjectDetails/ProjectDetails.tsx
	var import_react81 = __toModule(react.exports);
	var import_styled_components30 = __toModule(require$$3);

	// studio/src/panels/DetailPanel/ProjectDetails/StateConflictRow.tsx
	var import_react80 = __toModule(react.exports);
	var import_styled_components29 = __toModule(require$$3);
	var nanoid = (size = 21) => {
	  let id = "";
	  let bytes = crypto.getRandomValues(new Uint8Array(size));
	  while (size--) {
	    let byte = bytes[size] & 63;
	    if (byte < 36) {
	      id += byte.toString(36);
	    } else if (byte < 62) {
	      id += (byte - 26).toString(36).toUpperCase();
	    } else if (byte < 63) {
	      id += "_";
	    } else {
	      id += "-";
	    }
	  }
	  return id;
	};

	// studio/src/StudioStore/generateDiskStateRevision.ts
	function generateDiskStateRevision() {
	  return nanoid(16);
	}

	// studio/src/uiComponents/DetailPanelButton.tsx
	var import_styled_components28 = __toModule(require$$3);
	var DetailPanelButton = import_styled_components28.default.button`
  text-align: center;
  padding: 8px;
  border-radius: 2px;
  border: 1px solid #627b7b87;
  background-color: #4b787d3d;
  color: #eaeaea;
  font-weight: 400;
  display: block;
  appearance: none;
  flex-grow: 1;
  cursor: ${(props) => props.disabled ? "none" : "pointer"};
  opacity: ${(props) => props.disabled ? 0.4 : 1};

  &:hover {
    background-color: #7dc1c878;
    border-color: #9ebcbf;
  }
`;
	var DetailPanelButton_default = DetailPanelButton;

	// studio/src/panels/DetailPanel/ProjectDetails/StateConflictRow.tsx
	var Container17 = import_styled_components29.default.div`
  padding: 8px 10px;
  position: relative;
  background-color: #6d232352;
  &:before {
    position: absolute;
    content: ' ';
    display: block;
    left: 0;
    top: 0;
    bottom: 0;
    width: 2px;
    background-color: #ff000070;
  }
`;
	var Message = import_styled_components29.default.div`
  margin-bottom: 1em;
  & a {
    color: inherit;
  }
`;
	var ChooseStateRow = import_styled_components29.default.div`
  display: flex;
  gap: 8px;
`;
	var StateConflictRow = ({ projectId }) => {
	  const loadingState = useVal(getStudio().atomP.ephemeral.coreByProject[projectId].loadingState);
	  if (!loadingState)
	    return null;
	  if (loadingState.type === "browserStateIsNotBasedOnDiskState") {
	    return /* @__PURE__ */ import_react80.default.createElement(InConflict, {
	      loadingState,
	      projectId
	    });
	  } else {
	    return null;
	  }
	};
	var InConflict = ({ projectId, loadingState }) => {
	  const useBrowserState = () => {
	    getStudio().transaction(({ drafts: drafts2, stateEditors: stateEditors2 }) => {
	      stateEditors2.coreByProject.historic.revisionHistory.add({
	        projectId,
	        revision: loadingState.onDiskState.revisionHistory[0]
	      });
	      stateEditors2.coreByProject.historic.revisionHistory.add({
	        projectId,
	        revision: generateDiskStateRevision()
	      });
	      drafts2.ephemeral.coreByProject[projectId].loadingState = {
	        type: "loaded"
	      };
	    });
	  };
	  const useOnDiskState = () => {
	    getStudio().transaction(({ drafts: drafts2 }) => {
	      drafts2.historic.coreByProject[projectId] = loadingState.onDiskState;
	      drafts2.ephemeral.coreByProject[projectId].loadingState = {
	        type: "loaded"
	      };
	    });
	  };
	  const [browserStateNode, browserStateRef] = useTooltip({}, () => /* @__PURE__ */ import_react80.default.createElement(BasicTooltip_default, null, "The browser's state will override the disk state."));
	  const [diskStateNode, diskStateRef] = useTooltip({}, () => /* @__PURE__ */ import_react80.default.createElement(BasicTooltip_default, null, "The disk's state will override the browser's state."));
	  return /* @__PURE__ */ import_react80.default.createElement(Container17, null, /* @__PURE__ */ import_react80.default.createElement(Message, null, "Browser state is not based on disk state.", " ", /* @__PURE__ */ import_react80.default.createElement("a", {
	    href: "https://docs.theatrejs.com/in-depth/#exporting",
	    target: "_blank"
	  }, "Learn more.")), /* @__PURE__ */ import_react80.default.createElement(ChooseStateRow, null, browserStateNode, /* @__PURE__ */ import_react80.default.createElement(DetailPanelButton_default, {
	    onClick: useBrowserState,
	    ref: browserStateRef
	  }, "Use browser's state"), diskStateNode, /* @__PURE__ */ import_react80.default.createElement(DetailPanelButton_default, {
	    onClick: useOnDiskState,
	    ref: diskStateRef
	  }, "Use disk state")));
	};
	var StateConflictRow_default = StateConflictRow;

	// studio/src/panels/DetailPanel/ProjectDetails/ProjectDetails.tsx
	var Container18 = import_styled_components30.default.div`
  background-color: ${rowBgColor};
`;
	var TheExportRow = import_styled_components30.default.div`
  padding: 8px 10px;
  display: flex;
  flex-direction: column;
  align-items: stretch;
`;
	var ExportTooltip = (0, import_styled_components30.default)(BasicPopover_default)`
  width: 280px;
  padding: 1em;
`;
	var ProjectDetails = ({ projects }) => {
	  const project = projects[0];
	  const projectId = project.address.projectId;
	  const [downloaded, setDownloaded] = (0, import_react81.useState)(false);
	  const exportProject = (0, import_react81.useCallback)(() => {
	    const str = JSON.stringify(getStudio().createContentOfSaveFile(project.address.projectId), null, 2);
	    const file = new File([str], "state.json", { type: "application/json" });
	    const objUrl = URL.createObjectURL(file);
	    const a2 = document.createElement("a");
	    a2.href = objUrl;
	    a2.target = "_blank";
	    a2.setAttribute("download", "state.json");
	    a2.rel = "noopener";
	    a2.click();
	    setDownloaded(true);
	    setTimeout(() => {
	      setDownloaded(false);
	    }, 2e3);
	    setTimeout(() => {
	      URL.revokeObjectURL(objUrl);
	    }, 4e4);
	  }, []);
	  const [tooltip, openExportTooltip] = usePopover({ pointerDistanceThreshold: 50 }, () => /* @__PURE__ */ import_react81.default.createElement(ExportTooltip, null, "This will create a JSON file with the state of your project. You can commit this file to your git repo and include it in your production bundle.", /* @__PURE__ */ import_react81.default.createElement("a", {
	    href: "https://docs.theatrejs.com/in-depth/#exporting",
	    target: "_blank"
	  }, "Here is a quick guide on how to export to production.")));
	  return /* @__PURE__ */ import_react81.default.createElement(import_react81.default.Fragment, null, tooltip, /* @__PURE__ */ import_react81.default.createElement(Container18, null, /* @__PURE__ */ import_react81.default.createElement(StateConflictRow_default, {
	    projectId
	  }), /* @__PURE__ */ import_react81.default.createElement(TheExportRow, null, /* @__PURE__ */ import_react81.default.createElement(DetailPanelButton_default, {
	    onMouseEnter: (e) => openExportTooltip(e, e.target),
	    onClick: !downloaded ? exportProject : void 0,
	    disabled: downloaded
	  }, downloaded ? "(Exported)" : `Export ${projectId} to JSON`))));
	};
	var ProjectDetails_default = ProjectDetails;

	// studio/src/panels/DetailPanel/DetailPanel.tsx
	var Container19 = import_styled_components31.default.div`
  background-color: transparent;
  pointer-events: none;
  position: fixed;
  left: 0;
  right: 0;
  top: 12px;
  bottom: 0px;
  z-index: ${panelZIndexes.propsPanel};

  &:before {
    display: block;
    content: ' ';
    position: absolute;
    top: 0;
    bottom: 0;
    right: 0;
    width: 20px;
    ${pointerEventsAutoInNormalMode};
  }
`;
	var Content2 = import_styled_components31.default.div`
  position: absolute;
  top: 0;
  right: 0;
  width: 260px;
  bottom: 0;
  /* transform: translateX(100%); */
  /* pointer-events: none; */

  ${Container19}:hover & {
    transform: translateX(0);
  }
`;
	var Title2 = import_styled_components31.default.div`
  margin: 0 10px;
  color: #ffffffc2;
  font-weight: 500;
  font-size: 10px;
  user-select: none;
  ${pointerEventsAutoInNormalMode};
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
`;
	var headerHeight2 = `32px`;
	var Header3 = import_styled_components31.default.div`
  height: ${headerHeight2};
  display: flex;
  align-items: center;
  position: absolute;
  top: 0;
  left: 0;
  right: 0;

  &:after {
    position: absolute;
    inset: 1px 0px;
    display: block;
    content: ' ';
    pointer-events: none;
    z-index: -1;
    background-color: #262c2dd1;
    /* border-radius: 2px 0 0 2px; */
  }
`;
	var Body4 = import_styled_components31.default.div`
  ${pointerEventsAutoInNormalMode};
  position: absolute;
  top: ${headerHeight2};
  left: 0;
  right: 0;
  height: auto;
  max-height: calc(100% - ${headerHeight2});
  overflow-y: scroll;
  padding: 0;
  user-select: none;
`;
	var DetailPanel = (props) => {
	  return usePrism(() => {
	    const selection = getOutlineSelection();
	    const obj = selection.find(isSheetObject);
	    if (obj) {
	      return /* @__PURE__ */ import_react83.default.createElement(Container19, null, /* @__PURE__ */ import_react83.default.createElement(Content2, null, /* @__PURE__ */ import_react83.default.createElement(Header3, null, /* @__PURE__ */ import_react83.default.createElement(Title2, {
	        title: `${obj.sheet.address.sheetId}: ${obj.sheet.address.sheetInstanceId} > ${obj.address.objectKey}`
	      }, /* @__PURE__ */ import_react83.default.createElement(TitleBar_Piece, null, obj.sheet.address.sheetId, " "), /* @__PURE__ */ import_react83.default.createElement(TitleBar_Punctuation, null, ":", "\xA0"), /* @__PURE__ */ import_react83.default.createElement(TitleBar_Piece, null, obj.sheet.address.sheetInstanceId, " "), /* @__PURE__ */ import_react83.default.createElement(TitleBar_Punctuation, null, "\xA0", ">", "\xA0"), /* @__PURE__ */ import_react83.default.createElement(TitleBar_Piece, null, obj.address.objectKey))), /* @__PURE__ */ import_react83.default.createElement(Body4, null, /* @__PURE__ */ import_react83.default.createElement(ObjectDetails_default, {
	        objects: [obj]
	      }))));
	    }
	    const project = selection.find(isProject);
	    if (project) {
	      return /* @__PURE__ */ import_react83.default.createElement(Container19, null, /* @__PURE__ */ import_react83.default.createElement(Content2, null, /* @__PURE__ */ import_react83.default.createElement(Header3, null, /* @__PURE__ */ import_react83.default.createElement(Title2, {
	        title: `${project.address.projectId}`
	      }, /* @__PURE__ */ import_react83.default.createElement(TitleBar_Piece, null, project.address.projectId, " "))), /* @__PURE__ */ import_react83.default.createElement(Body4, null, /* @__PURE__ */ import_react83.default.createElement(ProjectDetails_default, {
	        projects: [project]
	      }))));
	    }
	    return /* @__PURE__ */ import_react83.default.createElement(import_react83.default.Fragment, null);
	  }, []);
	};
	var DetailPanel_default = DetailPanel;

	// studio/src/UIRoot/PanelsRoot.tsx
	var import_react165 = __toModule(react.exports);

	// studio/src/panels/BasePanel/PaneWrapper.tsx
	var import_react93 = __toModule(react.exports);
	var import_styled_components37 = __toModule(require$$3);

	// studio/src/panels/BasePanel/BasePanel.tsx
	var import_dataverse15 = __toModule(dist$1);

	// studio/src/uiComponents/useLockSet.ts
	var import_react84 = __toModule(react.exports);
	function useLockSet() {
	  const [isLocked, _setIsLocked] = (0, import_react84.useState)(false);
	  const addLock = (0, import_react84.useMemo)(() => {
	    const locks = new Set();
	    return () => {
	      const unlock = () => {
	        locks.delete(unlock);
	        _setIsLocked(locks.size > 0);
	      };
	      locks.add(unlock);
	      _setIsLocked(true);
	      return unlock;
	    };
	  }, []);
	  return [isLocked, addLock];
	}

	// studio/src/panels/BasePanel/BasePanel.tsx
	var import_react86 = __toModule(react.exports);
	var panelDimsToPanelPosition = (dims2, windowDims) => {
	  const left = dims2.left / windowDims.width;
	  const right = (dims2.left + dims2.width) / windowDims.width;
	  const top = dims2.top / windowDims.height;
	  const bottom = (dims2.height + dims2.top) / windowDims.height;
	  const position2 = {
	    edges: {
	      left: left <= 0.5 ? { from: "screenLeft", distance: left } : { from: "screenRight", distance: 1 - left },
	      right: right <= 0.5 ? { from: "screenLeft", distance: right } : { from: "screenRight", distance: 1 - right },
	      top: top <= 0.5 ? { from: "screenTop", distance: top } : { from: "screenBottom", distance: 1 - top },
	      bottom: bottom <= 0.5 ? { from: "screenTop", distance: bottom } : { from: "screenBottom", distance: 1 - bottom }
	    }
	  };
	  return position2;
	};
	var PanelContext = import_react86.default.createContext(null);
	var usePanel = () => (0, import_react86.useContext)(PanelContext);
	var BasePanel = ({ panelId, children, defaultPosition: defaultPosition3, minDims: minDims3 }) => {
	  const windowSize = useWindowSize_default(800, 200);
	  const [boundsHighlighted, addBoundsHighlightLock] = useLockSet();
	  const { stuff } = usePrism(() => {
	    var _a;
	    const { edges } = (_a = (0, import_dataverse15.val)(getStudio().atomP.historic.panelPositions[panelId])) != null ? _a : defaultPosition3;
	    const left = Math.floor(windowSize.width * (edges.left.from === "screenLeft" ? edges.left.distance : 1 - edges.left.distance));
	    const right = Math.floor(windowSize.width * (edges.right.from === "screenLeft" ? edges.right.distance : 1 - edges.right.distance));
	    const top = Math.floor(windowSize.height * (edges.top.from === "screenTop" ? edges.top.distance : 1 - edges.top.distance));
	    const bottom = Math.floor(windowSize.height * (edges.bottom.from === "screenTop" ? edges.bottom.distance : 1 - edges.bottom.distance));
	    const width = Math.max(right - left, minDims3.width);
	    const height2 = Math.max(bottom - top, minDims3.height);
	    const stuff2 = {
	      dims: {
	        width,
	        left,
	        top,
	        height: height2
	      },
	      panelId,
	      minDims: minDims3,
	      boundsHighlighted,
	      addBoundsHighlightLock
	    };
	    return { stuff: stuff2 };
	  }, [panelId, windowSize, boundsHighlighted, addBoundsHighlightLock]);
	  return /* @__PURE__ */ import_react86.default.createElement(PanelContext.Provider, {
	    value: stuff
	  }, children);
	};
	var BasePanel_default = BasePanel;

	// studio/src/uiComponents/useDrag.ts
	var import_react88 = __toModule(react.exports);

	// studio/src/uiComponents/PointerEventsHandler.tsx
	var import_react87 = __toModule(react.exports);
	var import_styled_components32 = __toModule(require$$3);
	var elementId = "pointer-root";
	var Container20 = import_styled_components32.default.div`
  pointer-events: auto;
  &.normal {
    pointer-events: none;
  }
`;
	var CursorOverride = import_styled_components32.default.div`
  position: absolute;
  inset: 0;
  pointer-events: none;

  #pointer-root:not(.normal) > & {
    pointer-events: auto;
  }
`;
	var context = (0, import_react87.createContext)({});
	var PointerEventsHandler = (props) => {
	  var _a, _b, _c, _d;
	  const [locks, setLocks] = (0, import_react87.useState)([]);
	  const contextValue = (0, import_react87.useMemo)(() => {
	    const getLock = (className, cursor) => {
	      const lock = { className, cursor };
	      setLocks((s2) => [...s2, lock]);
	      const unlock = () => {
	        setLocks((s2) => s2.filter((l2) => l2 !== lock));
	      };
	      return unlock;
	    };
	    return {
	      getLock
	    };
	  }, []);
	  return /* @__PURE__ */ import_react87.default.createElement(context.Provider, {
	    value: contextValue
	  }, /* @__PURE__ */ import_react87.default.createElement(Container20, {
	    id: elementId,
	    className: ((_b = (_a = locks[0]) == null ? void 0 : _a.className) != null ? _b : "normal") + " " + props.className
	  }, /* @__PURE__ */ import_react87.default.createElement(CursorOverride, {
	    style: { cursor: (_d = (_c = locks[0]) == null ? void 0 : _c.cursor) != null ? _d : "" }
	  }, props.children)));
	};
	var useCursorLock = (enabled, className, cursor) => {
	  const ctx3 = (0, import_react87.useContext)(context);
	  (0, import_react87.useLayoutEffect)(() => {
	    if (!enabled)
	      return;
	    return ctx3.getLock(className, cursor);
	  }, [enabled, className, cursor]);
	};
	var PointerEventsHandler_default = PointerEventsHandler;

	// studio/src/uiComponents/useDrag.ts
	function useDrag(target, opts) {
	  const optsRef = (0, import_react88.useRef)(opts);
	  optsRef.current = opts;
	  const [modeRef, mode] = useRefAndState("notDragging");
	  useCursorLock(mode === "dragging" && typeof opts.lockCursorTo === "string", "dragging", opts.lockCursorTo);
	  const stateRef = (0, import_react88.useRef)({ dragHappened: false, startPos: { x: 0, y: 0 } });
	  (0, import_react88.useLayoutEffect)(() => {
	    if (!target)
	      return;
	    const getDistances = (event) => {
	      const { startPos } = stateRef.current;
	      return [event.screenX - startPos.x, event.screenY - startPos.y];
	    };
	    const dragHandler = (event) => {
	      if (!stateRef.current.dragHappened)
	        stateRef.current.dragHappened = true;
	      modeRef.current = "dragging";
	      const deltas = getDistances(event);
	      optsRef.current.onDrag(deltas[0], deltas[1], event);
	    };
	    const dragEndHandler = () => {
	      removeDragListeners();
	      modeRef.current = "notDragging";
	      optsRef.current.onDragEnd && optsRef.current.onDragEnd(stateRef.current.dragHappened);
	    };
	    const addDragListeners = () => {
	      document.addEventListener("mousemove", dragHandler);
	      document.addEventListener("mouseup", dragEndHandler);
	    };
	    const removeDragListeners = () => {
	      document.removeEventListener("mousemove", dragHandler);
	      document.removeEventListener("mouseup", dragEndHandler);
	    };
	    const preventUnwantedClick = (event) => {
	      if (optsRef.current.disabled)
	        return;
	      if (stateRef.current.dragHappened) {
	        if (!optsRef.current.dontBlockMouseDown && modeRef.current !== "notDragging") {
	          event.stopPropagation();
	          event.preventDefault();
	        }
	        stateRef.current.dragHappened = false;
	      }
	    };
	    const dragStartHandler = (event) => {
	      const opts2 = optsRef.current;
	      if (opts2.disabled === true)
	        return;
	      if (event.button !== 0)
	        return;
	      const resultOfStart = opts2.onDragStart && opts2.onDragStart(event);
	      if (resultOfStart === false)
	        return;
	      if (!opts2.dontBlockMouseDown) {
	        event.stopPropagation();
	        event.preventDefault();
	      }
	      modeRef.current = "dragStartCalled";
	      const { screenX, screenY } = event;
	      stateRef.current.startPos = { x: screenX, y: screenY };
	      stateRef.current.dragHappened = false;
	      addDragListeners();
	    };
	    const onMouseDown = (e) => {
	      dragStartHandler(e);
	    };
	    target.addEventListener("mousedown", onMouseDown);
	    target.addEventListener("click", preventUnwantedClick);
	    return () => {
	      removeDragListeners();
	      target.removeEventListener("mousedown", onMouseDown);
	      target.removeEventListener("click", preventUnwantedClick);
	      if (modeRef.current !== "notDragging") {
	        optsRef.current.onDragEnd && optsRef.current.onDragEnd(modeRef.current === "dragging");
	      }
	      modeRef.current = "notDragging";
	    };
	  }, [target]);
	  return [mode === "dragging"];
	}

	// studio/src/panels/BasePanel/PanelDragZone.tsx
	var import_react89 = __toModule(react.exports);
	var import_styled_components33 = __toModule(require$$3);
	var Container21 = import_styled_components33.default.div`
  cursor: move;
`;
	var PanelDragZone = (props) => {
	  const panelStuff = usePanel();
	  const panelStuffRef = (0, import_react89.useRef)(panelStuff);
	  panelStuffRef.current = panelStuff;
	  const [ref, node] = useRefAndState(null);
	  const dragOpts = (0, import_react89.useMemo)(() => {
	    let stuffBeforeDrag = panelStuffRef.current;
	    let tempTransaction;
	    let unlock;
	    return {
	      lockCursorTo: "move",
	      onDragStart() {
	        stuffBeforeDrag = panelStuffRef.current;
	        if (unlock) {
	          const u2 = unlock;
	          unlock = void 0;
	          u2();
	        }
	        unlock = panelStuff.addBoundsHighlightLock();
	      },
	      onDrag(dx, dy) {
	        const newDims = __spreadProps(__spreadValues({}, stuffBeforeDrag.dims), {
	          top: stuffBeforeDrag.dims.top + dy,
	          left: stuffBeforeDrag.dims.left + dx
	        });
	        const position2 = panelDimsToPanelPosition(newDims, {
	          width: window.innerWidth,
	          height: window.innerHeight
	        });
	        tempTransaction == null ? void 0 : tempTransaction.discard();
	        tempTransaction = getStudio().tempTransaction(({ stateEditors: stateEditors2 }) => {
	          stateEditors2.studio.historic.panelPositions.setPanelPosition({
	            position: position2,
	            panelId: stuffBeforeDrag.panelId
	          });
	        });
	      },
	      onDragEnd(dragHappened) {
	        if (unlock) {
	          const u2 = unlock;
	          unlock = void 0;
	          u2();
	        }
	        if (dragHappened) {
	          tempTransaction == null ? void 0 : tempTransaction.commit();
	        } else {
	          tempTransaction == null ? void 0 : tempTransaction.discard();
	        }
	        tempTransaction = void 0;
	      }
	    };
	  }, []);
	  useDrag(node, dragOpts);
	  const [onMouseEnter, onMouseLeave] = (0, import_react89.useMemo)(() => {
	    let unlock;
	    return [
	      function onMouseEnter2() {
	        if (unlock) {
	          const u2 = unlock;
	          unlock = void 0;
	          u2();
	        }
	        unlock = panelStuff.addBoundsHighlightLock();
	      },
	      function onMouseLeave2() {
	        if (unlock) {
	          const u2 = unlock;
	          unlock = void 0;
	          u2();
	        }
	      }
	    ];
	  }, []);
	  return /* @__PURE__ */ import_react89.default.createElement(Container21, __spreadProps(__spreadValues({}, props), {
	    ref,
	    onMouseEnter,
	    onMouseLeave
	  }));
	};
	var PanelDragZone_default = PanelDragZone;

	// studio/src/panels/BasePanel/PanelWrapper.tsx
	var import_react92 = __toModule(react.exports);
	var import_styled_components36 = __toModule(require$$3);

	// studio/src/panels/BasePanel/PanelResizers.tsx
	var import_react91 = __toModule(react.exports);
	var import_styled_components35 = __toModule(require$$3);

	// studio/src/panels/BasePanel/PanelResizeHandle.tsx
	var import_react90 = __toModule(react.exports);
	var import_styled_components34 = __toModule(require$$3);
	var Base = import_styled_components34.default.div`
  position: absolute;
  z-index: 10;
  ${pointerEventsAutoInNormalMode};
  &:after {
    position: absolute;
    top: -2px;
    right: -2px;
    bottom: -2px;
    left: -2px;
    display: block;
    content: ' ';
  }

  opacity: 0;
  background-color: #478698;

  &.isHighlighted {
    opacity: 0.7;
  }

  &.isDragging {
    opacity: 1;
    /* background-color: ${curriedLighten(0.2, "#478698")}; */
  }

  &:hover {
    opacity: 1;
  }
`;
	var Horizontal = (0, import_styled_components34.default)(Base)`
  left: 0;
  right: 0;
  height: 1px;
`;
	var Top = (0, import_styled_components34.default)(Horizontal)`
  top: 0;
`;
	var Bottom = (0, import_styled_components34.default)(Horizontal)`
  bottom: 0;
`;
	var Vertical = (0, import_styled_components34.default)(Base)`
  top: 0;
  bottom: 0;
  width: 1px;
`;
	var Left2 = (0, import_styled_components34.default)(Vertical)`
  left: 0;
`;
	var Right = (0, import_styled_components34.default)(Vertical)`
  right: 0;
`;
	var Square = (0, import_styled_components34.default)(Base)`
  width: 8px;
  height: 8px;
`;
	var TopLeft = (0, import_styled_components34.default)(Square)`
  top: 0;
  left: 0;
`;
	var TopRight = (0, import_styled_components34.default)(Square)`
  top: 0;
  right: 0;
`;
	var BottomLeft = (0, import_styled_components34.default)(Square)`
  bottom: 0;
  left: 0;
`;
	var BottomRight = (0, import_styled_components34.default)(Square)`
  bottom: 0;
  right: 0;
`;
	var els = {
	  Top,
	  TopLeft,
	  TopRight,
	  Bottom,
	  BottomLeft,
	  BottomRight,
	  Left: Left2,
	  Right
	};
	var cursors = {
	  Top: "ns-resize",
	  Bottom: "ns-resize",
	  Left: "ew-resize",
	  Right: "ew-resize",
	  TopLeft: "nw-resize",
	  TopRight: "ne-resize",
	  BottomLeft: "sw-resize",
	  BottomRight: "se-resize"
	};
	var PanelResizeHandle = ({ which }) => {
	  const panelStuff = usePanel();
	  const panelStuffRef = (0, import_react90.useRef)(panelStuff);
	  panelStuffRef.current = panelStuff;
	  const [isDragging, setIsDragging] = (0, import_react90.useState)(false);
	  const [ref, node] = useRefAndState(null);
	  const dragOpts = (0, import_react90.useMemo)(() => {
	    let stuffBeforeDrag = panelStuffRef.current;
	    let tempTransaction;
	    let unlock;
	    return {
	      lockCursorTo: cursors[which],
	      onDragStart() {
	        stuffBeforeDrag = panelStuffRef.current;
	        setIsDragging(true);
	        if (unlock) {
	          const u2 = unlock;
	          unlock = void 0;
	          u2();
	        }
	        unlock = panelStuff.addBoundsHighlightLock();
	      },
	      onDrag(dx, dy) {
	        const newDims = __spreadValues({}, stuffBeforeDrag.dims);
	        if (which.startsWith("Bottom")) {
	          newDims.height = Math.max(newDims.height + dy, stuffBeforeDrag.minDims.height);
	        } else if (which.startsWith("Top")) {
	          const bottom = newDims.top + newDims.height;
	          const top = Math.min(bottom - stuffBeforeDrag.minDims.height, newDims.top + dy);
	          const height2 = bottom - top;
	          newDims.height = height2;
	          newDims.top = top;
	        }
	        if (which.endsWith("Left")) {
	          const right = newDims.left + newDims.width;
	          const left = Math.min(right - stuffBeforeDrag.minDims.width, newDims.left + dx);
	          const width = right - left;
	          newDims.width = width;
	          newDims.left = left;
	        } else if (which.endsWith("Right")) {
	          newDims.width = Math.max(newDims.width + dx, stuffBeforeDrag.minDims.width);
	        }
	        const position2 = panelDimsToPanelPosition(newDims, {
	          width: window.innerWidth,
	          height: window.innerHeight
	        });
	        tempTransaction == null ? void 0 : tempTransaction.discard();
	        tempTransaction = getStudio().tempTransaction(({ stateEditors: stateEditors2 }) => {
	          stateEditors2.studio.historic.panelPositions.setPanelPosition({
	            position: position2,
	            panelId: stuffBeforeDrag.panelId
	          });
	        });
	      },
	      onDragEnd(dragHappened) {
	        if (unlock) {
	          const u2 = unlock;
	          unlock = void 0;
	          u2();
	        }
	        setIsDragging(false);
	        if (dragHappened) {
	          tempTransaction == null ? void 0 : tempTransaction.commit();
	        } else {
	          tempTransaction == null ? void 0 : tempTransaction.discard();
	        }
	        tempTransaction = void 0;
	      }
	    };
	  }, [which]);
	  useDrag(node, dragOpts);
	  const Comp = els[which];
	  const isOnCorner = which.length <= 6;
	  return /* @__PURE__ */ import_react90.default.createElement(Comp, {
	    ref,
	    className: [
	      isDragging ? "isDragging" : "",
	      panelStuff.boundsHighlighted && isOnCorner ? "isHighlighted" : ""
	    ].join(" "),
	    style: { cursor: cursors[which] }
	  });
	};
	var PanelResizeHandle_default = PanelResizeHandle;

	// studio/src/panels/BasePanel/PanelResizers.tsx
	import_styled_components35.default.div``;
	var PanelResizers = (props) => {
	  return /* @__PURE__ */ import_react91.default.createElement(import_react91.default.Fragment, null, /* @__PURE__ */ import_react91.default.createElement(PanelResizeHandle_default, {
	    which: "Bottom"
	  }), /* @__PURE__ */ import_react91.default.createElement(PanelResizeHandle_default, {
	    which: "Top"
	  }), /* @__PURE__ */ import_react91.default.createElement(PanelResizeHandle_default, {
	    which: "Left"
	  }), /* @__PURE__ */ import_react91.default.createElement(PanelResizeHandle_default, {
	    which: "Right"
	  }), /* @__PURE__ */ import_react91.default.createElement(PanelResizeHandle_default, {
	    which: "TopLeft"
	  }), /* @__PURE__ */ import_react91.default.createElement(PanelResizeHandle_default, {
	    which: "TopRight"
	  }), /* @__PURE__ */ import_react91.default.createElement(PanelResizeHandle_default, {
	    which: "BottomLeft"
	  }), /* @__PURE__ */ import_react91.default.createElement(PanelResizeHandle_default, {
	    which: "BottomRight"
	  }));
	};
	var PanelResizers_default = PanelResizers;

	// studio/src/panels/BasePanel/PanelWrapper.tsx
	var Container23 = import_styled_components36.default.div`
  position: absolute;
  user-select: none;
  box-sizing: border-box;
  ${pointerEventsAutoInNormalMode};
  /* box-shadow: 1px 2px 10px -5px black; */

  z-index: 1000;
`;
	var PanelWrapper = import_react92.default.forwardRef((props, ref) => {
	  const stuff = usePanel();
	  const _a = props, { style, children } = _a, otherProps = __objRest(_a, ["style", "children"]);
	  return /* @__PURE__ */ import_react92.default.createElement(Container23, __spreadProps(__spreadValues({
	    ref
	  }, otherProps), {
	    style: __spreadValues({
	      width: stuff.dims.width + "px",
	      height: stuff.dims.height + "px",
	      top: stuff.dims.top + "px",
	      left: stuff.dims.left + "px"
	    }, style != null ? style : {})
	  }), /* @__PURE__ */ import_react92.default.createElement(PanelResizers_default, null), children);
	});
	var PanelWrapper_default = PanelWrapper;

	// studio/src/panels/BasePanel/PaneWrapper.tsx
	var import_react_error_boundary = __toModule(require_react_error_boundary_umd());
	var defaultPosition = {
	  edges: {
	    left: { from: "screenLeft", distance: 0.3 },
	    right: { from: "screenRight", distance: 0.3 },
	    top: { from: "screenTop", distance: 0.3 },
	    bottom: { from: "screenBottom", distance: 0.3 }
	  }
	};
	var minDims = { width: 300, height: 300 };
	var PaneWrapper = ({ paneInstance }) => {
	  return /* @__PURE__ */ import_react93.default.createElement(BasePanel_default, {
	    panelId: `pane-${paneInstance.instanceId}`,
	    defaultPosition,
	    minDims
	  }, /* @__PURE__ */ import_react93.default.createElement(Content3, {
	    paneInstance
	  }));
	};
	var Container24 = (0, import_styled_components37.default)(PanelWrapper_default)`
  overflow-y: hidden;
  display: flex;
  flex-direction: column;

  box-shadow: 0px 5px 12px -4px rgb(0 0 0 / 22%);
  z-index: ${panelZIndexes.pluginPanes};
`;
	var Title3 = import_styled_components37.default.div`
  width: 100%;
`;
	var PaneTools = import_styled_components37.default.div`
  display: flex;
  align-items: center;
  opacity: 1;
  position: absolute;
  right: 4px;
  top: 0;
  bottom: 0;
`;
	var ClosePanelButton = import_styled_components37.default.button`
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 2px;
  font-size: 11px;
  height: 10px;
  width: 18px;
  color: #adadadb3;
  background: transparent;
  border: none;
  cursor: pointer;
  &:hover {
    color: white;
  }
`;
	var F22 = (0, import_styled_components37.default)(F2)`
  position: relative;
  overflow: hidden;

  &:after {
    z-index: 10;
    position: absolute;
    inset: 0;
    display: block;
    content: ' ';
    pointer-events: none;

    #pointer-root:not(.normal) & {
      pointer-events: auto;
    }
  }
`;
	var ErrorContainer = import_styled_components37.default.div`
  padding: 12px;

  & > pre {
    border: 1px solid #ff62624f;
    background-color: rgb(255 0 0 / 5%);
    margin: 8px 0;
    padding: 8px;
    font-family: monospace;
    overflow: scroll;
    color: #ff9896;
  }
`;
	var ErrorFallback = (props) => {
	  return /* @__PURE__ */ import_react93.default.createElement(ErrorContainer, null, "An Error occured rendering this pane. Open the console for more info.", /* @__PURE__ */ import_react93.default.createElement("pre", null, JSON.stringify({ message: props.error.message, stack: props.error.stack }, null, 2)));
	};
	var Content3 = ({
	  paneInstance
	}) => {
	  const Comp = paneInstance.definition.component;
	  const closePane = (0, import_react93.useCallback)(() => {
	    getStudio().paneManager.destroyPane(paneInstance.instanceId);
	  }, [paneInstance]);
	  return /* @__PURE__ */ import_react93.default.createElement(Container24, null, /* @__PURE__ */ import_react93.default.createElement(PanelDragZone_default, null, /* @__PURE__ */ import_react93.default.createElement(TitleBar, null, /* @__PURE__ */ import_react93.default.createElement(PaneTools, null, /* @__PURE__ */ import_react93.default.createElement(ClosePanelButton, {
	    onClick: closePane,
	    title: "Close Pane"
	  }, /* @__PURE__ */ import_react93.default.createElement(IoClose, null))), /* @__PURE__ */ import_react93.default.createElement(Title3, null, paneInstance.instanceId))), /* @__PURE__ */ import_react93.default.createElement(F22, null, /* @__PURE__ */ import_react93.default.createElement(import_react_error_boundary.ErrorBoundary, {
	    FallbackComponent: ErrorFallback
	  }, /* @__PURE__ */ import_react93.default.createElement(Comp, {
	    paneId: paneInstance.instanceId
	  }))));
	};
	var PaneWrapper_default = PaneWrapper;

	// shared/src/utils/valToAtom.ts
	var import_dataverse16 = __toModule(dist$1);
	var valToAtom = (key, vals) => {
	  const a2 = import_dataverse16.prism.memo(key, () => new import_dataverse16.Atom(vals), []);
	  a2.setState(vals);
	  return a2;
	};

	// studio/src/panels/SequenceEditorPanel/SequenceEditorPanel.tsx
	var import_dataverse46 = __toModule(dist$1);
	var import_react164 = __toModule(react.exports);
	var import_styled_components76 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/DopeSheet.tsx
	var import_react144 = __toModule(react.exports);
	var import_styled_components65 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Left/Left.tsx
	var import_dataverse35 = __toModule(dist$1);
	var import_react140 = __toModule(react.exports);
	var import_styled_components63 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Left/SheetRow.tsx
	var import_react138 = __toModule(react.exports);
	var import_styled_components62 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Left/SheetObjectRow.tsx
	var import_react136 = __toModule(react.exports);
	var import_styled_components61 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Left/AnyCompositeRow.tsx
	var import_react94 = __toModule(react.exports);
	var import_styled_components38 = __toModule(require$$3);
	var Container25 = import_styled_components38.default.li`
  --depth: ${(props) => props.depth};
  margin: 0;
  padding: 0;
  list-style: none;
`;
	var BaseHeader2 = import_styled_components38.default.div`
  border-bottom: 1px solid #7695b705;
`;
	var Header4 = (0, import_styled_components38.default)(BaseHeader2)`
  padding-left: calc(16px + var(--depth) * 20px);

  display: flex;
  align-items: stretch;
  color: ${theme.panel.body.compoudThing.label.color};

  box-sizing: border-box;

  ${(props) => props.isSelected && `background: blue`};
`;
	var Head_Label2 = import_styled_components38.default.span`
  ${propNameText};
  overflow-x: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  padding-right: 4px;
  line-height: 26px;
  flex-wrap: nowrap;
`;
	var Head_Icon = import_styled_components38.default.span`
  width: 12px;
  margin-right: 8px;
  font-size: 9px;
  display: flex;
  align-items: center;

  transform: rotateZ(${(props) => props.isOpen ? 90 : 0}deg);
`;
	var Children = import_styled_components38.default.ul`
  margin: 0;
  padding: 0;
  list-style: none;
`;
	var AnyCompositeRow = ({ leaf, label, children, isSelectable, isSelected, toggleSelect }) => {
	  const hasChildren = Array.isArray(children) && children.length > 0;
	  return /* @__PURE__ */ import_react94.default.createElement(Container25, {
	    depth: leaf.depth
	  }, /* @__PURE__ */ import_react94.default.createElement(Header4, {
	    style: {
	      height: leaf.nodeHeight + "px"
	    },
	    isSelectable: isSelectable === true,
	    isSelected: isSelected === true,
	    onClick: toggleSelect,
	    isEven: leaf.n % 2 === 0
	  }, /* @__PURE__ */ import_react94.default.createElement(Head_Icon, {
	    isOpen: true
	  }, /* @__PURE__ */ import_react94.default.createElement(HiOutlineChevronRight, null)), /* @__PURE__ */ import_react94.default.createElement(Head_Label2, null, label)), hasChildren && /* @__PURE__ */ import_react94.default.createElement(Children, null, children));
	};
	var AnyCompositeRow_default = AnyCompositeRow;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Left/PropWithChildrenRow.tsx
	var import_react134 = __toModule(react.exports);
	var import_styled_components60 = __toModule(require$$3);

	// shared/src/utils/addresses.ts
	var encodePathToProp = (p2) => JSON.stringify(p2);
	var decodePathToProp = (s2) => JSON.parse(s2);

	// shared/src/utils/pointerDeep.ts
	function pointerDeep(base, toAppend) {
	  let p2 = base;
	  for (const k2 of toAppend) {
	    p2 = p2[k2];
	  }
	  return p2;
	}

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Left/PrimitivePropRow.tsx
	var import_dataverse34 = __toModule(dist$1);
	var import_react132 = __toModule(react.exports);
	var import_styled_components59 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/GraphEditor/GraphEditor.tsx
	var import_dataverse33 = __toModule(dist$1);
	var import_react130 = __toModule(react.exports);
	var import_styled_components58 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/Right.tsx
	var import_dataverse27 = __toModule(dist$1);
	var import_react120 = __toModule(react.exports);
	var import_styled_components50 = __toModule(require$$3);

	// studio/src/uiComponents/useKeyDown.ts
	var import_react96 = __toModule(react.exports);

	// studio/src/uiComponents/useKeyDownCallback.tsx
	var import_react95 = __toModule(react.exports);
	function useKeyDownCallback(combo, listener) {
	  const refs = (0, import_react95.useRef)({ combo, listener });
	  refs.current = { combo, listener };
	  (0, import_react95.useEffect)(() => {
	    function onKeyDown(event) {
	      if (event.key === refs.current.combo) {
	        refs.current.listener({ down: true, event });
	      }
	    }
	    function onKeyUp(event) {
	      if (event.key === refs.current.combo) {
	        refs.current.listener({ down: false, event });
	      }
	    }
	    function onBlur(event) {
	      refs.current.listener({ down: false, event: void 0 });
	    }
	    document.addEventListener("keydown", onKeyDown);
	    document.addEventListener("keyup", onKeyUp);
	    window.addEventListener("blur", onBlur);
	    return () => {
	      document.removeEventListener("keydown", onKeyDown);
	      document.removeEventListener("keyup", onKeyUp);
	      window.removeEventListener("blur", onBlur);
	    };
	  }, []);
	}

	// studio/src/uiComponents/useKeyDown.ts
	function useKeyDown(combo) {
	  const [state, setState] = (0, import_react96.useState)(false);
	  useKeyDownCallback(combo, ({ down }) => {
	    setState(down);
	  });
	  return state;
	}

	// studio/src/uiComponents/useValToAtom.ts
	var import_dataverse17 = __toModule(dist$1);
	var import_react97 = __toModule(react.exports);
	function useValToAtom(val39) {
	  const atom = (0, import_react97.useMemo)(() => {
	    return new import_dataverse17.Atom(val39);
	  }, []);
	  (0, import_react97.useLayoutEffect)(() => {
	    atom.setState(val39);
	  }, [val39]);
	  return atom;
	}

	// shared/src/utils/mutableSetDeep.ts
	var import_dataverse18 = __toModule(dist$1);
	function mutableSetDeep(obj, getPath, val39) {
	  const path = (0, import_dataverse18.getPointerParts)(getPath((0, import_dataverse18.pointer)({ root: {}, path: [] }))).path;
	  set_default(obj, path, val39);
	}

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/DopeSheetSelectionView.tsx
	var import_dataverse19 = __toModule(dist$1);
	var import_react99 = __toModule(react.exports);
	var import_styled_components39 = __toModule(require$$3);
	var Container26 = import_styled_components39.default.div`
  cursor: ${(props) => props.isShiftDown ? "cell" : "default"};
`;
	var DopeSheetSelectionView = ({ layoutP, children }) => {
	  const [containerRef, containerNode] = useRefAndState(null);
	  const isShiftDown = useKeyDown("Shift");
	  const selectionBounds = useCaptureSelection(layoutP, containerNode);
	  const selectionBoundsRef = (0, import_react99.useRef)(selectionBounds);
	  selectionBoundsRef.current = selectionBounds;
	  return /* @__PURE__ */ import_react99.default.createElement(Container26, {
	    ref: containerRef,
	    isShiftDown
	  }, selectionBounds && /* @__PURE__ */ import_react99.default.createElement(SelectionRectangle, {
	    state: selectionBounds,
	    layoutP
	  }), children);
	};
	function useCaptureSelection(layoutP, containerNode) {
	  const [ref, state] = useRefAndState(null);
	  useDrag(containerNode, (0, import_react99.useMemo)(() => {
	    return {
	      dontBlockMouseDown: true,
	      lockCursorTo: "cell",
	      onDragStart(event) {
	        if (!event.shiftKey || event.target instanceof HTMLInputElement) {
	          return false;
	        }
	        const rect = containerNode.getBoundingClientRect();
	        const posInScaledSpace = event.clientX - rect.left;
	        const posInUnitSpace = (0, import_dataverse19.val)(layoutP.scaledSpace.toUnitSpace)(posInScaledSpace);
	        ref.current = {
	          positions: [posInUnitSpace, posInUnitSpace],
	          ys: [event.clientY - rect.top, event.clientY - rect.top]
	        };
	        (0, import_dataverse19.val)(layoutP.selectionAtom).setState({ current: void 0 });
	      },
	      onDrag(dx, dy, event) {
	        ref.current;
	        const rect = containerNode.getBoundingClientRect();
	        const posInScaledSpace = event.clientX - rect.left;
	        const posInUnitSpace = (0, import_dataverse19.val)(layoutP.scaledSpace.toUnitSpace)(posInScaledSpace);
	        ref.current = {
	          positions: [ref.current.positions[0], posInUnitSpace],
	          ys: [ref.current.ys[0], event.clientY - rect.top]
	        };
	        const selection = utils.boundsToSelection(layoutP, ref.current);
	        (0, import_dataverse19.val)(layoutP.selectionAtom).setState({ current: selection });
	      },
	      onDragEnd(dragHappened) {
	        ref.current = null;
	      }
	    };
	  }, [layoutP, containerNode, ref]));
	  return state;
	}
	var utils;
	(function(utils2) {
	  const collectorByLeafType = {
	    primitiveProp(layoutP, leaf, bounds, selection) {
	      const { sheetObject, trackId } = leaf;
	      const trackData = (0, import_dataverse19.val)(getStudio().atomP.historic.coreByProject[sheetObject.address.projectId].sheetsById[sheetObject.address.sheetId].sequence.tracksByObject[sheetObject.address.objectKey].trackData[trackId]);
	      trackData.keyframes.filter((kf) => kf.position >= bounds.positions[0] && kf.position <= bounds.positions[1]);
	      for (const kf of trackData.keyframes) {
	        if (kf.position <= bounds.positions[0])
	          continue;
	        if (kf.position >= bounds.positions[1])
	          break;
	        mutableSetDeep(selection, (p2) => p2.byObjectKey[sheetObject.address.objectKey].byTrackId[trackId].byKeyframeId[kf.id], true);
	      }
	    }
	  };
	  const collectChildren = (layoutP, leaf, bounds, selection) => {
	    if ("children" in leaf) {
	      for (const sub of leaf.children) {
	        collectFromAnyLeaf(layoutP, sub, bounds, selection);
	      }
	    }
	  };
	  function collectFromAnyLeaf(layoutP, leaf, bounds, selection) {
	    if (bounds.ys[0] > leaf.top + leaf.heightIncludingChildren || leaf.top > bounds.ys[1]) {
	      return;
	    }
	    const collector = collectorByLeafType[leaf.type];
	    if (collector) {
	      collector(layoutP, leaf, bounds, selection);
	    } else {
	      collectChildren(layoutP, leaf, bounds, selection);
	    }
	  }
	  function boundsToSelection(layoutP, bounds) {
	    const sheet = (0, import_dataverse19.val)(layoutP.tree.sheet);
	    const selection = {
	      type: "DopeSheetSelection",
	      byObjectKey: {},
	      getDragHandlers(origin) {
	        let tempTransaction;
	        let toUnitSpace;
	        return {
	          onDragStart() {
	            toUnitSpace = (0, import_dataverse19.val)(layoutP.scaledSpace.toUnitSpace);
	          },
	          onDrag(dx, _2, event) {
	            let delta = toUnitSpace(dx);
	            if (tempTransaction) {
	              tempTransaction.discard();
	              tempTransaction = void 0;
	            }
	            const snapTarget = event.composedPath().find((el) => el instanceof Element && el !== origin.domNode && el.hasAttribute("data-pos"));
	            if (snapTarget) {
	              const snapPos = parseFloat(snapTarget.getAttribute("data-pos"));
	              if (isFinite(snapPos)) {
	                delta = snapPos - origin.positionAtStartOfDrag;
	              }
	            }
	            tempTransaction = getStudio().tempTransaction(({ stateEditors: stateEditors2 }) => {
	              const transformKeyframes = stateEditors2.coreByProject.historic.sheetsById.sequence.transformKeyframes;
	              for (const objectKey of Object.keys(selection.byObjectKey)) {
	                const { byTrackId } = selection.byObjectKey[objectKey];
	                for (const trackId of Object.keys(byTrackId)) {
	                  const { byKeyframeId } = byTrackId[trackId];
	                  transformKeyframes({
	                    trackId,
	                    keyframeIds: Object.keys(byKeyframeId),
	                    translate: delta,
	                    scale: 1,
	                    origin: 0,
	                    snappingFunction: sheet.getSequence().closestGridPosition,
	                    objectKey,
	                    projectId: origin.projectId,
	                    sheetId: origin.sheetId
	                  });
	                }
	              }
	            });
	          },
	          onDragEnd(dragHappened) {
	            if (dragHappened) {
	              if (tempTransaction) {
	                tempTransaction.commit();
	              }
	            } else {
	              if (tempTransaction) {
	                tempTransaction.discard();
	              }
	            }
	            tempTransaction = void 0;
	          }
	        };
	      },
	      delete() {
	        getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	          const deleteKeyframes = stateEditors2.coreByProject.historic.sheetsById.sequence.deleteKeyframes;
	          for (const objectKey of Object.keys(selection.byObjectKey)) {
	            const { byTrackId } = selection.byObjectKey[objectKey];
	            for (const trackId of Object.keys(byTrackId)) {
	              const { byKeyframeId } = byTrackId[trackId];
	              deleteKeyframes(__spreadProps(__spreadValues({}, sheet.address), {
	                objectKey,
	                trackId,
	                keyframeIds: Object.keys(byKeyframeId)
	              }));
	            }
	          }
	        });
	      }
	    };
	    bounds = sortBounds(bounds);
	    const tree = (0, import_dataverse19.val)(layoutP.tree);
	    collectFromAnyLeaf(layoutP, tree, bounds, selection);
	    return selection;
	  }
	  utils2.boundsToSelection = boundsToSelection;
	})(utils || (utils = {}));
	var SelectionRectangleDiv = import_styled_components39.default.div`
  position: absolute;
  background: rgba(255, 255, 255, 0.1);
  border: 1px dashed rgba(255, 255, 255, 0.4);
  box-size: border-box;
`;
	var sortBounds = (b2) => {
	  return {
	    positions: [...b2.positions].sort((a2, b3) => a2 - b3),
	    ys: [...b2.ys].sort((a2, b3) => a2 - b3)
	  };
	};
	var SelectionRectangle = ({ state, layoutP }) => {
	  const atom = useValToAtom(state);
	  return usePrism(() => {
	    const state2 = (0, import_dataverse19.val)(atom.pointer);
	    const sorted = sortBounds(state2);
	    const unitSpaceToScaledSpace = (0, import_dataverse19.val)(layoutP.scaledSpace.fromUnitSpace);
	    const positionsInScaledSpace = sorted.positions.map(unitSpaceToScaledSpace);
	    const top = sorted.ys[0];
	    const height2 = sorted.ys[1] - sorted.ys[0];
	    const left = positionsInScaledSpace[0];
	    const width = positionsInScaledSpace[1] - positionsInScaledSpace[0];
	    return /* @__PURE__ */ import_react99.default.createElement(SelectionRectangleDiv, {
	      style: {
	        top: top + "px",
	        height: height2 + "px",
	        left: left + "px",
	        width: width + "px"
	      }
	    });
	  }, [layoutP, atom]);
	};
	var DopeSheetSelectionView_default = DopeSheetSelectionView;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/HorizontallyScrollableArea.tsx
	var import_dataverse20 = __toModule(dist$1);
	var import_react102 = __toModule(react.exports);
	var import_styled_components41 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/VerticalScrollContainer.tsx
	var import_react100 = __toModule(react.exports);
	var import_styled_components40 = __toModule(require$$3);
	var Container27 = import_styled_components40.default.div`
  position: absolute;
  top: 0;
  right: 0;
  left: 0;
  bottom: 0;
  overflow-x: hidden;
  overflow-y: scroll;
  z-index: ${() => zIndexes.scrollableArea};

  &::-webkit-scrollbar {
    display: none;
  }
`;
	var ctx2 = (0, import_react100.createContext)(voidFn);
	var useReceiveVerticalWheelEvent = () => (0, import_react100.useContext)(ctx2);
	var VerticalScrollContainer = (props) => {
	  const ref = (0, import_react100.useRef)(null);
	  const receiveVerticalWheelEvent = (0, import_react100.useCallback)((event) => {
	  }, []);
	  return /* @__PURE__ */ import_react100.default.createElement(ctx2.Provider, {
	    value: receiveVerticalWheelEvent
	  }, /* @__PURE__ */ import_react100.default.createElement(Container27, {
	    ref
	  }, props.children));
	};
	var VerticalScrollContainer_default = VerticalScrollContainer;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/HorizontallyScrollableArea.tsx
	var Container28 = import_styled_components41.default.div`
  position: absolute;

  right: 0;
  overflow-x: scroll;
  overflow-y: hidden;
  ${pointerEventsAutoInNormalMode};

  // hide the scrollbar on Gecko
  scrollbar-width: none;

  // hide the scrollbar on Webkit/Blink
  &::-webkit-scrollbar {
    display: none;
  }
`;
	var ShiftRight = import_styled_components41.default.div`
  position: absolute;
`;
	var HorizontallyScrollableArea = import_react102.default.memo(({ layoutP, children, height: height2 }) => {
	  const { width, unitSpaceToScaledSpaceMultiplier } = usePrism(() => ({
	    width: (0, import_dataverse20.val)(layoutP.rightDims.width),
	    unitSpaceToScaledSpaceMultiplier: (0, import_dataverse20.val)(layoutP.scaledSpace.fromUnitSpace)(1)
	  }), [layoutP]);
	  const [containerRef, containerNode] = useRefAndState(null);
	  useHandlePanAndZoom(layoutP, containerNode);
	  useDragHandlers(layoutP, containerNode);
	  useUpdateScrollFromClippedSpaceRange(layoutP, containerNode);
	  return /* @__PURE__ */ import_react102.default.createElement(Container28, {
	    ref: containerRef,
	    style: {
	      width: width + "px",
	      height: height2 + "px",
	      "--unitSpaceToScaledSpaceMultiplier": unitSpaceToScaledSpaceMultiplier
	    }
	  }, /* @__PURE__ */ import_react102.default.createElement(ShiftRight, {
	    style: {
	      left: (0, import_dataverse20.val)(layoutP.scaledSpace.leftPadding) + "px"
	    }
	  }, children));
	});
	var HorizontallyScrollableArea_default = HorizontallyScrollableArea;
	function useDragHandlers(layoutP, containerEl) {
	  const handlers = (0, import_react102.useMemo)(() => {
	    let posBeforeSeek = 0;
	    let sequence;
	    let scaledSpaceToUnitSpace;
	    const setIsSeeking = (0, import_dataverse20.val)(layoutP.seeker.setIsSeeking);
	    return {
	      onDrag(dx, _2, event) {
	        const deltaPos = scaledSpaceToUnitSpace(dx);
	        const unsnappedPos = clamp_default(posBeforeSeek + deltaPos, 0, sequence.length);
	        let newPosition = unsnappedPos;
	        const snapTarget = event.composedPath().find((el) => el instanceof Element && el.hasAttribute("data-pos"));
	        if (snapTarget) {
	          const snapPos = parseFloat(snapTarget.getAttribute("data-pos"));
	          if (isFinite(snapPos)) {
	            newPosition = snapPos;
	          }
	        }
	        sequence.position = newPosition;
	      },
	      onDragStart(event) {
	        if (event.target instanceof HTMLInputElement)
	          return false;
	        if (event.shiftKey || event.altKey || event.ctrlKey || event.metaKey) {
	          return false;
	        }
	        if (event.composedPath().some((el) => el instanceof HTMLElement && el.draggable === true)) {
	          return false;
	        }
	        const initialPositionInClippedSpace = event.clientX - containerEl.getBoundingClientRect().left;
	        const initialPositionInUnitSpace = clamp_default((0, import_dataverse20.val)(layoutP.clippedSpace.toUnitSpace)(initialPositionInClippedSpace), 0, Infinity);
	        sequence = (0, import_dataverse20.val)(layoutP.sheet).getSequence();
	        sequence.position = initialPositionInUnitSpace;
	        posBeforeSeek = initialPositionInUnitSpace;
	        scaledSpaceToUnitSpace = (0, import_dataverse20.val)(layoutP.scaledSpace.toUnitSpace);
	        setIsSeeking(true);
	      },
	      onDragEnd() {
	        setIsSeeking(false);
	      }
	    };
	  }, [layoutP, containerEl]);
	  const [isDragigng] = useDrag(containerEl, handlers);
	  useCursorLock(isDragigng, "draggingPositionInSequenceEditor", "ew-resize");
	}
	function useHandlePanAndZoom(layoutP, node) {
	  useReceiveVerticalWheelEvent();
	  (0, import_react102.useLayoutEffect)(() => {
	    if (!node)
	      return;
	    const receiveWheelEvent = (event) => {
	      if (Math.abs(event.deltaY) < Math.abs(event.deltaX)) {
	        event.preventDefault();
	        event.stopPropagation();
	        const scaledSpaceToUnitSpace = (0, import_dataverse20.val)(layoutP.scaledSpace.toUnitSpace);
	        const deltaPos = scaledSpaceToUnitSpace(event.deltaX * 1);
	        const oldRange = (0, import_dataverse20.val)(layoutP.clippedSpace.range);
	        const newRange = mapValues_default(oldRange, (p2) => p2 + deltaPos);
	        const setRange = (0, import_dataverse20.val)(layoutP.clippedSpace.setRange);
	        setRange(newRange);
	        return;
	      }
	      if (event.ctrlKey) {
	        event.preventDefault();
	        event.stopPropagation();
	        const pivotPointInClippedSpace = event.clientX - node.getBoundingClientRect().left;
	        const pivotPointInUnitSpace = (0, import_dataverse20.val)(layoutP.clippedSpace.toUnitSpace)(pivotPointInClippedSpace);
	        const oldRange = (0, import_dataverse20.val)(layoutP.clippedSpace.range);
	        const delta = normalize(event.deltaY, [-50, 50]);
	        const scaleFactor = 1 + delta * 0.03;
	        const newRange = mapValues_default(oldRange, (originalPos) => {
	          return (originalPos - pivotPointInUnitSpace) * scaleFactor + pivotPointInUnitSpace;
	        });
	        const sequenceLength = (0, import_dataverse20.val)(layoutP.sheet).getSequence().length;
	        const maxEnd = sequenceLength + sequenceLength * 0.25;
	        (0, import_dataverse20.val)(layoutP.clippedSpace.setRange)(normalizeRange(newRange, [0, maxEnd]));
	      } else if (event.shiftKey) {
	        event.preventDefault();
	        event.stopPropagation();
	        const sequenceLength = (0, import_dataverse20.val)(layoutP.sheet).getSequence().length;
	        const oldRange = (0, import_dataverse20.val)(layoutP.clippedSpace.range);
	        const windowSize = oldRange.end - oldRange.start;
	        const speed = windowSize / sequenceLength;
	        const delta = normalize(event.deltaY, [-50, 50]);
	        const scaleFactor = delta * 0.05 * speed;
	        const newRange = mapValues_default(oldRange, (originalPos) => originalPos + scaleFactor);
	        (0, import_dataverse20.val)(layoutP.clippedSpace.setRange)(newRange);
	      }
	    };
	    const listenerOptions = {
	      capture: true,
	      passive: false
	    };
	    node.addEventListener("wheel", receiveWheelEvent, listenerOptions);
	    return () => {
	      node.removeEventListener("wheel", receiveWheelEvent, listenerOptions);
	    };
	  }, [node, layoutP]);
	}
	function normalize(value, [min, max]) {
	  return Math.max(Math.min(value, max), min);
	}
	function normalizeRange(range, minMax) {
	  return mapValues_default(range, (pos) => normalize(pos, minMax));
	}
	function useUpdateScrollFromClippedSpaceRange(layoutP, node) {
	  (0, import_react102.useLayoutEffect)(() => {
	    if (!node)
	      return;
	    const d2 = (0, import_dataverse20.prism)(() => {
	      const range = (0, import_dataverse20.val)(layoutP.clippedSpace.range);
	      const rangeStartInScaledSpace = (0, import_dataverse20.val)(layoutP.scaledSpace.fromUnitSpace)(range.start);
	      return rangeStartInScaledSpace;
	    });
	    const update = () => {
	      const rangeStartInScaledSpace = d2.getValue();
	      node.scrollLeft = rangeStartInScaledSpace;
	    };
	    const untap = d2.changesWithoutValues().tap(update);
	    update();
	    const timeout = setTimeout(update, 100);
	    return () => {
	      clearTimeout(timeout);
	      untap();
	    };
	  }, [layoutP, node]);
	}

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/SheetRow.tsx
	var import_react118 = __toModule(react.exports);
	var import_styled_components49 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/SheetObjectRow.tsx
	var import_react116 = __toModule(react.exports);
	var import_styled_components48 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/PropWithChildrenRow.tsx
	var import_react114 = __toModule(react.exports);
	var import_styled_components47 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/PrimitivePropRow.tsx
	var import_dataverse26 = __toModule(dist$1);
	var import_react112 = __toModule(react.exports);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/BasicKeyframedTrack/BasicKeyframedTrack.tsx
	var import_dataverse25 = __toModule(dist$1);
	var import_react109 = __toModule(react.exports);
	var import_styled_components45 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/BasicKeyframedTrack/KeyframeEditor/KeyframeEditor.tsx
	var import_react107 = __toModule(react.exports);
	var import_styled_components44 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/BasicKeyframedTrack/KeyframeEditor/Connector.tsx
	var import_dataverse24 = __toModule(dist$1);
	var import_react105 = __toModule(react.exports);
	var import_react106 = __toModule(react.exports);
	var import_styled_components43 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/BasicKeyframedTrack/KeyframeEditor/Dot.tsx
	var import_dataverse23 = __toModule(dist$1);
	var import_react104 = __toModule(react.exports);
	var import_styled_components42 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/FrameStampPositionProvider.tsx
	var import_dataverse22 = __toModule(dist$1);

	// studio/src/utils/mousePositionD.ts
	var import_dataverse21 = __toModule(dist$1);
	var mousePositionD = (0, import_dataverse21.prism)(() => {
	  const [pos, setPos] = import_dataverse21.prism.state("pos", null);
	  import_dataverse21.prism.effect("setupListeners", () => {
	    const handleMouseMove = (e) => {
	      setPos(e);
	    };
	    document.addEventListener("mousemove", handleMouseMove);
	    return () => {
	      document.removeEventListener("mousemove", handleMouseMove);
	    };
	  }, []);
	  return pos;
	});
	var mousePositionD_default = mousePositionD;

	// studio/src/panels/SequenceEditorPanel/FrameStampPositionProvider.tsx
	var import_react103 = __toModule(react.exports);
	var FrameStampPositionType;
	(function(FrameStampPositionType2) {
	  FrameStampPositionType2[FrameStampPositionType2["hidden"] = 0] = "hidden";
	  FrameStampPositionType2[FrameStampPositionType2["locked"] = 1] = "locked";
	  FrameStampPositionType2[FrameStampPositionType2["snapped"] = 2] = "snapped";
	  FrameStampPositionType2[FrameStampPositionType2["free"] = 3] = "free";
	})(FrameStampPositionType || (FrameStampPositionType = {}));
	var context2 = (0, import_react103.createContext)(null);
	var lastLockId = 0;
	var FrameStampPositionProvider = ({ children, layoutP }) => {
	  const locksAtom = (0, import_react103.useMemo)(() => new import_dataverse22.Atom({ list: [] }), []);
	  const currentD = (0, import_react103.useMemo)(() => (0, import_dataverse22.prism)(() => {
	    const pointerPos = import_dataverse22.prism.memo("p", () => pointerPositionInUnitSpace(layoutP), [layoutP]).getValue();
	    const locks = (0, import_dataverse22.val)(locksAtom.pointer.list);
	    if (locks.length > 0) {
	      return last_default(locks).position;
	    } else {
	      return pointerPos;
	    }
	  }), [layoutP]);
	  const getLock = (0, import_react103.useCallback)(() => {
	    const id = lastLockId++;
	    locksAtom.reduceState(["list"], (list) => [
	      ...list,
	      {
	        id,
	        position: [-1, 0]
	      }
	    ]);
	    const unlock = () => {
	      locksAtom.reduceState(["list"], (list) => list.filter((lock) => lock.id !== id));
	    };
	    const set2 = (posInUnitSpace) => {
	      locksAtom.reduceState(["list"], (list) => {
	        const index = list.findIndex((lock) => lock.id === id);
	        if (index === -1) {
	          console.warn(`Lock is already freed. This is a bug.`);
	          return list;
	        }
	        const newList = [...list];
	        newList.splice(index, 1, {
	          id,
	          position: [
	            posInUnitSpace,
	            posInUnitSpace === -1 ? 0 : 1
	          ]
	        });
	        return newList;
	      });
	    };
	    return {
	      set: set2,
	      unlock
	    };
	  }, []);
	  const value = {
	    currentD,
	    getLock
	  };
	  return /* @__PURE__ */ import_react103.default.createElement(context2.Provider, {
	    value
	  }, children);
	};
	var useFrameStampPositionD = () => (0, import_react103.useContext)(context2).currentD;
	var useLockFrameStampPosition = (shouldLock, val39) => {
	  const { getLock } = (0, import_react103.useContext)(context2);
	  const lockRef = (0, import_react103.useRef)();
	  (0, import_react103.useLayoutEffect)(() => {
	    if (!shouldLock)
	      return;
	    lockRef.current = getLock();
	    return () => {
	      lockRef.current.unlock();
	    };
	  }, [shouldLock]);
	  (0, import_react103.useLayoutEffect)(() => {
	    if (shouldLock) {
	      lockRef.current.set(val39);
	    }
	  }, [val39]);
	};
	var attributeNameThatLocksFramestamp = "data-theatre-lock-framestamp-to";
	var pointerPositionInUnitSpace = (layoutP) => {
	  return (0, import_dataverse22.prism)(() => {
	    const rightDims = (0, import_dataverse22.val)(layoutP.rightDims);
	    const clippedSpaceToUnitSpace = (0, import_dataverse22.val)(layoutP.clippedSpace.toUnitSpace);
	    (0, import_dataverse22.val)(layoutP.scaledSpace.leftPadding);
	    const mousePos = (0, import_dataverse22.val)(mousePositionD_default);
	    if (!mousePos)
	      return [-1, 0];
	    for (const el of mousePos.composedPath()) {
	      if (!(el instanceof HTMLElement || el instanceof SVGElement))
	        break;
	      if (el.hasAttribute(attributeNameThatLocksFramestamp)) {
	        const val39 = el.getAttribute(attributeNameThatLocksFramestamp);
	        if (typeof val39 !== "string")
	          continue;
	        if (val39 === "hide")
	          return [-1, 0];
	        const double = parseFloat(val39);
	        if (isFinite(double) && double >= 0)
	          return [double, 2];
	      }
	    }
	    const { clientX, clientY } = mousePos;
	    const { screenX: x2, screenY: y2, width: rightWidth, height: height2 } = rightDims;
	    if (inRange_default(clientX, x2, x2 + rightWidth) && inRange_default(clientY, y2, y2 + height2)) {
	      const posInRightDims = clientX - x2;
	      const posInUnitSpace = clippedSpaceToUnitSpace(posInRightDims);
	      return [posInUnitSpace, 3];
	    } else {
	      return [-1, 0];
	    }
	  });
	};
	var FrameStampPositionProvider_default = FrameStampPositionProvider;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/BasicKeyframedTrack/KeyframeEditor/SnapCursor.svg
	var SnapCursor_default = "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMzQiIGhlaWdodD0iMzQiIHZpZXdCb3g9IjAgMCAzNCAzNCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICA8cGF0aCBkPSJNMSA3VjFINyIgc3Ryb2tlPSIjNzRGRkRFIiBzdHJva2Utd2lkdGg9IjAuMjUiIC8+CiAgPHBhdGggZD0iTTcgMzNIMUwxIDI3IiBzdHJva2U9IiM3NEZGREUiIHN0cm9rZS13aWR0aD0iMC4yNSIgLz4KICA8cGF0aCBkPSJNMzMgMjdWMzNIMjciIHN0cm9rZT0iIzc0RkZERSIgc3Ryb2tlLXdpZHRoPSIwLjI1IiAvPgogIDxwYXRoIGQ9Ik0yNyAxTDMzIDFWNyIgc3Ryb2tlPSIjNzRGRkRFIiBzdHJva2Utd2lkdGg9IjAuMjUiIC8+Cjwvc3ZnPg==";

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/BasicKeyframedTrack/KeyframeEditor/Dot.tsx
	var dotSize = 6;
	var hitZoneSize = 12;
	var snapCursorSize = 34;
	var dims = (size) => `
  left: ${-size / 2}px;
  top: ${-size / 2}px;
  width: ${size}px;
  height: ${size}px;
`;
	var dotTheme = {
	  normalColor: "#40AAA4",
	  get selectedColor() {
	    return curriedLighten(0.35, dotTheme.normalColor);
	  }
	};
	var Square2 = import_styled_components42.default.div`
  position: absolute;
  background: ${(props) => props.isSelected ? dotTheme.selectedColor : dotTheme.normalColor};
  transform: rotateZ(45deg);

  z-index: 1;
  pointer-events: none;
  ${(props) => dims(props.isSelected ? dotSize : dotSize)}
`;
	var HitZone = import_styled_components42.default.div`
  position: absolute;
  ${dims(hitZoneSize)};

  z-index: 1;

  cursor: ew-resize;

  #pointer-root.draggingPositionInSequenceEditor & {
    pointer-events: auto;
    &:hover:after {
      position: absolute;
      top: calc(50% - ${snapCursorSize / 2}px);
      left: calc(50% - ${snapCursorSize / 2}px);
      width: ${snapCursorSize}px;
      height: ${snapCursorSize}px;
      display: block;
      content: ' ';
      background: url(${SnapCursor_default}) no-repeat 100% 100%;
      // This icon might also fit: GiConvergenceTarget
    }
  }

  &.beingDragged {
    pointer-events: none !important;
  }

  &:hover + ${Square2}, &.beingDragged + ${Square2} {
    ${dims(dotSize + 5)}
  }
`;
	var Dot = (props) => {
	  const [ref, node] = useRefAndState(null);
	  const [contextMenu] = useKeyframeContextMenu(node, props);
	  const [isDragging] = useDragKeyframe(node, props);
	  return /* @__PURE__ */ import_react104.default.createElement(import_react104.default.Fragment, null, /* @__PURE__ */ import_react104.default.createElement(HitZone, __spreadProps(__spreadValues({
	    ref,
	    "data-pos": props.keyframe.position.toFixed(3)
	  }, {
	    [attributeNameThatLocksFramestamp]: props.keyframe.position.toFixed(3)
	  }), {
	    className: isDragging ? "beingDragged" : ""
	  })), /* @__PURE__ */ import_react104.default.createElement(Square2, {
	    isSelected: !!props.selection
	  }), contextMenu);
	};
	var Dot_default = Dot;
	function useKeyframeContextMenu(node, props) {
	  return useContextMenu(node, {
	    items: () => {
	      return [
	        {
	          label: props.selection ? "Delete Selection" : "Delete Keyframe",
	          callback: () => {
	            if (props.selection) {
	              props.selection.delete();
	            } else {
	              getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	                stateEditors2.coreByProject.historic.sheetsById.sequence.deleteKeyframes(__spreadProps(__spreadValues({}, props.leaf.sheetObject.address), {
	                  keyframeIds: [props.keyframe.id],
	                  trackId: props.leaf.trackId
	                }));
	              });
	            }
	          }
	        }
	      ];
	    }
	  });
	}
	function useDragKeyframe(node, props) {
	  const [isDragging, setIsDragging] = (0, import_react104.useState)(false);
	  useLockFrameStampPosition(isDragging, props.keyframe.position);
	  const propsRef = (0, import_react104.useRef)(props);
	  propsRef.current = props;
	  const gestureHandlers = (0, import_react104.useMemo)(() => {
	    let toUnitSpace;
	    let tempTransaction;
	    let propsAtStartOfDrag;
	    let selectionDragHandlers;
	    return {
	      onDragStart(event) {
	        var _a;
	        setIsDragging(true);
	        const props2 = propsRef.current;
	        if (props2.selection) {
	          const { selection, leaf } = props2;
	          const { sheetObject } = leaf;
	          selectionDragHandlers = selection.getDragHandlers(__spreadProps(__spreadValues({}, sheetObject.address), {
	            pathToProp: leaf.pathToProp,
	            trackId: leaf.trackId,
	            keyframeId: props2.keyframe.id,
	            domNode: node,
	            positionAtStartOfDrag: props2.trackData.keyframes[props2.index].position
	          }));
	          (_a = selectionDragHandlers.onDragStart) == null ? void 0 : _a.call(selectionDragHandlers, event);
	          return;
	        }
	        propsAtStartOfDrag = props2;
	        toUnitSpace = (0, import_dataverse23.val)(propsAtStartOfDrag.layoutP.scaledSpace.toUnitSpace);
	      },
	      onDrag(dx, dy, event) {
	        if (selectionDragHandlers) {
	          selectionDragHandlers.onDrag(dx, dy, event);
	          return;
	        }
	        const original = propsAtStartOfDrag.trackData.keyframes[propsAtStartOfDrag.index];
	        const deltaPos = toUnitSpace(dx);
	        const newPosBeforeSnapping = Math.max(original.position + deltaPos, 0);
	        let newPosition = newPosBeforeSnapping;
	        const snapTarget = event.composedPath().find((el) => el instanceof Element && el !== node && el.hasAttribute("data-pos"));
	        if (snapTarget) {
	          const snapPos = parseFloat(snapTarget.getAttribute("data-pos"));
	          if (isFinite(snapPos)) {
	            newPosition = snapPos;
	          }
	        }
	        if (tempTransaction) {
	          tempTransaction.discard();
	          tempTransaction = void 0;
	        }
	        tempTransaction = getStudio().tempTransaction(({ stateEditors: stateEditors2 }) => {
	          stateEditors2.coreByProject.historic.sheetsById.sequence.replaceKeyframes(__spreadProps(__spreadValues({}, propsAtStartOfDrag.leaf.sheetObject.address), {
	            trackId: propsAtStartOfDrag.leaf.trackId,
	            keyframes: [__spreadProps(__spreadValues({}, original), { position: newPosition })],
	            snappingFunction: (0, import_dataverse23.val)(propsAtStartOfDrag.layoutP.sheet).getSequence().closestGridPosition
	          }));
	        });
	      },
	      onDragEnd(dragHappened) {
	        var _a;
	        setIsDragging(false);
	        if (selectionDragHandlers) {
	          (_a = selectionDragHandlers.onDragEnd) == null ? void 0 : _a.call(selectionDragHandlers, dragHappened);
	          selectionDragHandlers = void 0;
	        }
	        if (dragHappened) {
	          if (tempTransaction) {
	            tempTransaction.commit();
	          }
	        } else {
	          if (tempTransaction) {
	            tempTransaction.discard();
	          }
	        }
	        tempTransaction = void 0;
	      }
	    };
	  }, []);
	  useDrag(node, gestureHandlers);
	  useCursorLock(isDragging, "draggingPositionInSequenceEditor", "ew-resize");
	  return [isDragging];
	}

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/BasicKeyframedTrack/KeyframeEditor/Connector.tsx
	var connectorHeight = dotSize / 2 + 1;
	var connectorWidthUnscaled = 1e3;
	var connectorTheme = {
	  normalColor: `#365b59`,
	  get hoverColor() {
	    return curriedLighten(0.1, connectorTheme.normalColor);
	  },
	  get selectedColor() {
	    return curriedLighten(0.2, connectorTheme.normalColor);
	  },
	  get selectedHoverColor() {
	    return curriedLighten(0.4, connectorTheme.normalColor);
	  }
	};
	var Container29 = import_styled_components43.default.div`
  position: absolute;
  background: ${(props) => props.isSelected ? connectorTheme.selectedColor : connectorTheme.normalColor};
  height: ${connectorHeight}px;
  width: ${connectorWidthUnscaled}px;

  left: 0;
  top: -${connectorHeight / 2}px;
  transform-origin: top left;
  z-index: 0;
  cursor: ew-resize;

  &:hover {
    background: ${(props) => props.isSelected ? connectorTheme.selectedHoverColor : connectorTheme.hoverColor};
  }
`;
	var Connector = (props) => {
	  const { index, trackData } = props;
	  const cur = trackData.keyframes[index];
	  const next = trackData.keyframes[index + 1];
	  const connectorLengthInUnitSpace = next.position - cur.position;
	  const [nodeRef, node] = useRefAndState(null);
	  const [contextMenu] = useContextMenu(node, {
	    items: () => {
	      return [
	        {
	          label: props.selection ? "Delete Selection" : "Delete both Keyframes",
	          callback: () => {
	            if (props.selection) {
	              props.selection.delete();
	            } else {
	              getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	                stateEditors2.coreByProject.historic.sheetsById.sequence.deleteKeyframes(__spreadProps(__spreadValues({}, props.leaf.sheetObject.address), {
	                  keyframeIds: [cur.id, next.id],
	                  trackId: props.leaf.trackId
	                }));
	              });
	            }
	          }
	        }
	      ];
	    }
	  });
	  useDragKeyframe2(node, props);
	  return /* @__PURE__ */ import_react105.default.createElement(Container29, {
	    isSelected: !!props.selection,
	    ref: nodeRef,
	    onClick: (event) => {
	      if (event.button !== 0)
	        return;
	      const orig = JSON.stringify([
	        cur.handles[2],
	        cur.handles[3],
	        next.handles[0],
	        next.handles[1]
	      ]);
	      const modifiedS = orig;
	      if (modifiedS && modifiedS !== orig) {
	        return;
	      }
	    },
	    style: {
	      transform: `scale3d(calc(var(--unitSpaceToScaledSpaceMultiplier) * ${connectorLengthInUnitSpace / connectorWidthUnscaled}), 1, 1)`
	    }
	  }, contextMenu);
	};
	var Connector_default = Connector;
	function useDragKeyframe2(node, props) {
	  const propsRef = (0, import_react106.useRef)(props);
	  propsRef.current = props;
	  const gestureHandlers = (0, import_react106.useMemo)(() => {
	    let toUnitSpace;
	    let tempTransaction;
	    let propsAtStartOfDrag;
	    let selectionDragHandlers;
	    let sequence;
	    return {
	      lockCursorTo: "ew-resize",
	      onDragStart(event) {
	        var _a;
	        const props2 = propsRef.current;
	        if (props2.selection) {
	          const { selection, leaf } = props2;
	          const { sheetObject } = leaf;
	          selectionDragHandlers = selection.getDragHandlers(__spreadProps(__spreadValues({}, sheetObject.address), {
	            pathToProp: leaf.pathToProp,
	            trackId: leaf.trackId,
	            keyframeId: props2.keyframe.id,
	            domNode: node,
	            positionAtStartOfDrag: props2.trackData.keyframes[props2.index].position
	          }));
	          (_a = selectionDragHandlers.onDragStart) == null ? void 0 : _a.call(selectionDragHandlers, event);
	          return;
	        }
	        propsAtStartOfDrag = props2;
	        sequence = (0, import_dataverse24.val)(propsAtStartOfDrag.layoutP.sheet).getSequence();
	        toUnitSpace = (0, import_dataverse24.val)(propsAtStartOfDrag.layoutP.scaledSpace.toUnitSpace);
	      },
	      onDrag(dx, dy, event) {
	        if (selectionDragHandlers) {
	          selectionDragHandlers.onDrag(dx, dy, event);
	          return;
	        }
	        const delta = toUnitSpace(dx);
	        if (tempTransaction) {
	          tempTransaction.discard();
	          tempTransaction = void 0;
	        }
	        tempTransaction = getStudio().tempTransaction(({ stateEditors: stateEditors2 }) => {
	          stateEditors2.coreByProject.historic.sheetsById.sequence.transformKeyframes(__spreadProps(__spreadValues({}, propsAtStartOfDrag.leaf.sheetObject.address), {
	            trackId: propsAtStartOfDrag.leaf.trackId,
	            keyframeIds: [
	              propsAtStartOfDrag.keyframe.id,
	              propsAtStartOfDrag.trackData.keyframes[propsAtStartOfDrag.index + 1].id
	            ],
	            translate: delta,
	            scale: 1,
	            origin: 0,
	            snappingFunction: sequence.closestGridPosition
	          }));
	        });
	      },
	      onDragEnd(dragHappened) {
	        var _a;
	        if (selectionDragHandlers) {
	          (_a = selectionDragHandlers.onDragEnd) == null ? void 0 : _a.call(selectionDragHandlers, dragHappened);
	          selectionDragHandlers = void 0;
	        }
	        if (dragHappened) {
	          if (tempTransaction) {
	            tempTransaction.commit();
	          }
	        } else {
	          if (tempTransaction) {
	            tempTransaction.discard();
	          }
	        }
	        tempTransaction = void 0;
	      }
	    };
	  }, []);
	  useDrag(node, gestureHandlers);
	}

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/BasicKeyframedTrack/KeyframeEditor/KeyframeEditor.tsx
	var Container30 = import_styled_components44.default.div`
  position: absolute;
`;
	var noConnector = /* @__PURE__ */ import_react107.default.createElement(import_react107.default.Fragment, null);
	var KeyframeEditor = (props) => {
	  const { index, trackData } = props;
	  const cur = trackData.keyframes[index];
	  const next = trackData.keyframes[index + 1];
	  const connected = cur.connectedRight && !!next;
	  return /* @__PURE__ */ import_react107.default.createElement(Container30, {
	    style: {
	      top: `${props.leaf.nodeHeight / 2}px`,
	      left: `calc(var(--unitSpaceToScaledSpaceMultiplier) * ${cur.position}px)`
	    }
	  }, /* @__PURE__ */ import_react107.default.createElement(Dot_default, __spreadValues({}, props)), connected ? /* @__PURE__ */ import_react107.default.createElement(Connector_default, __spreadValues({}, props)) : noConnector);
	};
	var KeyframeEditor_default = KeyframeEditor;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/BasicKeyframedTrack/BasicKeyframedTrack.tsx
	import_styled_components45.default.div``;
	var BasicKeyframedTrack = import_react109.default.memo(({ layoutP, trackData, leaf }) => {
	  const { selectedKeyframeIds, selection } = usePrism(() => {
	    const selectionAtom = (0, import_dataverse25.val)(layoutP.selectionAtom);
	    const selectedKeyframeIds2 = (0, import_dataverse25.val)(selectionAtom.pointer.current.byObjectKey[leaf.sheetObject.address.objectKey].byTrackId[leaf.trackId].byKeyframeId);
	    if (selectedKeyframeIds2) {
	      return {
	        selectedKeyframeIds: selectedKeyframeIds2,
	        selection: (0, import_dataverse25.val)(selectionAtom.pointer.current)
	      };
	    } else {
	      return { selectedKeyframeIds: {}, selection: void 0 };
	    }
	  }, [layoutP, leaf.trackId]);
	  const keyframeEditors = trackData.keyframes.map((kf, index) => /* @__PURE__ */ import_react109.default.createElement(KeyframeEditor_default, {
	    keyframe: kf,
	    index,
	    trackData,
	    layoutP,
	    leaf,
	    key: "keyframe-" + kf.id,
	    selection: selectedKeyframeIds[kf.id] === true ? selection : void 0
	  }));
	  return /* @__PURE__ */ import_react109.default.createElement(import_react109.default.Fragment, null, keyframeEditors);
	});
	var BasicKeyframedTrack_default = BasicKeyframedTrack;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/Row.tsx
	var import_react110 = __toModule(react.exports);
	var import_styled_components46 = __toModule(require$$3);
	var Container32 = import_styled_components46.default.li`
  margin: 0;
  padding: 0;
  list-style: none;
  box-sizing: border-box;
  position: relative;
`;
	var NodeWrapper = import_styled_components46.default.div`
  box-sizing: border-box;
  width: 100%;
  position: relative;

  &:before {
    position: absolute;
    display: block;
    content: ' ';
    left: -40px;
    top: 0;
    bottom: 0;
    right: 0;
    box-sizing: border-box;
    border-bottom: 1px solid #252b3869;
    background: ${(props) => props.isEven ? "transparent" : "#6b8fb505"};
  }
`;
	var Children2 = import_styled_components46.default.ul`
  margin: 0;
  padding: 0;
  list-style: none;
`;
	var Row2 = ({ leaf, children, node }) => {
	  const hasChildren = Array.isArray(children) && children.length > 0;
	  return /* @__PURE__ */ import_react110.default.createElement(Container32, null, /* @__PURE__ */ import_react110.default.createElement(NodeWrapper, {
	    style: { height: leaf.nodeHeight + "px" },
	    isEven: leaf.n % 2 === 0
	  }, node), hasChildren && /* @__PURE__ */ import_react110.default.createElement(Children2, null, children));
	};
	var Row_default = Row2;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/PrimitivePropRow.tsx
	var PrimitivePropRow = ({ leaf, layoutP }) => {
	  return usePrism(() => {
	    const { sheetObject } = leaf;
	    const { trackId } = leaf;
	    const trackData = (0, import_dataverse26.val)(getStudio().atomP.historic.coreByProject[sheetObject.address.projectId].sheetsById[sheetObject.address.sheetId].sequence.tracksByObject[sheetObject.address.objectKey].trackData[trackId]);
	    if ((trackData == null ? void 0 : trackData.type) !== "BasicKeyframedTrack") {
	      console.error(`trackData type ${trackData == null ? void 0 : trackData.type} is not yet supported on the sequence editor`);
	      return /* @__PURE__ */ import_react112.default.createElement(Row_default, {
	        leaf,
	        node: /* @__PURE__ */ import_react112.default.createElement("div", null)
	      });
	    } else {
	      const node = /* @__PURE__ */ import_react112.default.createElement(BasicKeyframedTrack_default, {
	        layoutP,
	        trackData,
	        leaf
	      });
	      return /* @__PURE__ */ import_react112.default.createElement(Row_default, {
	        leaf,
	        node
	      });
	    }
	  }, [leaf, layoutP]);
	};
	var PrimitivePropRow_default = PrimitivePropRow;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/PropWithChildrenRow.tsx
	var decideRowByPropType = (leaf, layoutP) => leaf.type === "propWithChildren" ? /* @__PURE__ */ import_react114.default.createElement(PropWithChildrenRow, {
	  layoutP,
	  leaf,
	  key: "prop" + leaf.pathToProp[leaf.pathToProp.length - 1]
	}) : /* @__PURE__ */ import_react114.default.createElement(PrimitivePropRow_default, {
	  layoutP,
	  leaf,
	  key: "prop" + leaf.pathToProp[leaf.pathToProp.length - 1]
	});
	import_styled_components47.default.div``;
	var PropWithChildrenRow = ({ leaf, layoutP }) => {
	  return usePrism(() => {
	    const node = /* @__PURE__ */ import_react114.default.createElement("div", null);
	    return /* @__PURE__ */ import_react114.default.createElement(Row_default, {
	      leaf,
	      node
	    }, leaf.children.map((propLeaf) => decideRowByPropType(propLeaf, layoutP)));
	  }, [leaf, layoutP]);
	};

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/SheetObjectRow.tsx
	import_styled_components48.default.div``;
	var SheetObjectRow = ({ leaf, layoutP }) => {
	  return usePrism(() => {
	    const node = /* @__PURE__ */ import_react116.default.createElement("div", null);
	    return /* @__PURE__ */ import_react116.default.createElement(Row_default, {
	      leaf,
	      node
	    }, leaf.children.map((leaf2) => decideRowByPropType(leaf2, layoutP)));
	  }, [leaf, layoutP]);
	};
	var SheetObjectRow_default = SheetObjectRow;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/SheetRow.tsx
	import_styled_components49.default.div``;
	var SheetRow = ({ leaf, layoutP }) => {
	  return usePrism(() => {
	    return /* @__PURE__ */ import_react118.default.createElement(import_react118.default.Fragment, null, leaf.children.map((sheetObjectLeaf) => /* @__PURE__ */ import_react118.default.createElement(SheetObjectRow_default, {
	      layoutP,
	      key: "sheetObject-" + sheetObjectLeaf.sheetObject.address.objectKey,
	      leaf: sheetObjectLeaf
	    })));
	  }, [leaf, layoutP]);
	};
	var SheetRow_default = SheetRow;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/Right.tsx
	var contentWidth = 1e6;
	var ListContainer = import_styled_components50.default.ul`
  margin: 0;
  padding: 0;
  list-style: none;
  position: absolute;
  left: 0;
  width: ${contentWidth}px;
`;
	import_styled_components50.default.div`
  position: absolute;
  top: 0;
  right: 0;
  width: ${(props) => props.width};
  bottom: 0;
  z-index: ${() => zIndexes.rightBackground};
  overflow: hidden;
  background: ${curriedDarken(1 * 0.03, theme.panel.bg)};
`;
	var Right2 = ({ layoutP }) => {
	  return usePrism(() => {
	    const tree = (0, import_dataverse27.val)(layoutP.tree);
	    const height2 = (0, import_dataverse27.val)(layoutP.tree.top) + Math.max((0, import_dataverse27.val)(layoutP.tree.heightIncludingChildren), (0, import_dataverse27.val)(layoutP.dopeSheetDims.height));
	    return /* @__PURE__ */ import_react120.default.createElement(import_react120.default.Fragment, null, /* @__PURE__ */ import_react120.default.createElement(HorizontallyScrollableArea_default, {
	      layoutP,
	      height: height2
	    }, /* @__PURE__ */ import_react120.default.createElement(DopeSheetSelectionView_default, {
	      layoutP
	    }, /* @__PURE__ */ import_react120.default.createElement(ListContainer, {
	      style: { top: tree.top + "px" }
	    }, /* @__PURE__ */ import_react120.default.createElement(SheetRow_default, {
	      leaf: tree,
	      layoutP
	    })))));
	  }, [layoutP]);
	};
	var Right_default = Right2;

	// studio/src/panels/SequenceEditorPanel/GraphEditor/PrimitivePropGraph.tsx
	var import_dataverse30 = __toModule(dist$1);
	var import_react127 = __toModule(react.exports);
	var import_styled_components56 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/GraphEditor/BasicKeyframedTrack/BasicKeyframedTrack.tsx
	var import_react125 = __toModule(react.exports);
	var import_styled_components55 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/GraphEditor/BasicKeyframedTrack/KeyframeEditor/KeyframeEditor.tsx
	var import_react124 = __toModule(react.exports);
	var import_styled_components54 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/GraphEditor/BasicKeyframedTrack/KeyframeEditor/Curve.tsx
	var import_react121 = __toModule(react.exports);
	var import_styled_components51 = __toModule(require$$3);
	var SVGPath = import_styled_components51.default.path`
  stroke-width: 2;
  stroke: var(--main-color);
  fill: none;
  vector-effect: non-scaling-stroke;
`;
	var Curve = (props) => {
	  const { index, trackData } = props;
	  const cur = trackData.keyframes[index];
	  const next = trackData.keyframes[index + 1];
	  [
	    cur.handles[2],
	    cur.handles[3],
	    next.handles[0],
	    next.handles[1]
	  ];
	  const connectorLengthInUnitSpace = next.position - cur.position;
	  const [nodeRef, node] = useRefAndState(null);
	  const [contextMenu] = useConnectorContextMenu(node, props);
	  const leftYInExtremumSpace = props.extremumSpace.fromValueSpace(cur.value);
	  const rightYInExtremumSpace = props.extremumSpace.fromValueSpace(next.value);
	  const heightInExtremumSpace = rightYInExtremumSpace - leftYInExtremumSpace;
	  const transform = transformBox(cur.position, leftYInExtremumSpace, connectorLengthInUnitSpace, heightInExtremumSpace);
	  const x1 = cur.handles[2];
	  const y1 = cur.handles[3];
	  const x2 = next.handles[0];
	  const y2 = next.handles[1];
	  const pathD = `M 0 0 C ${x1} ${y1} ${x2} ${y2} 1 1`;
	  return /* @__PURE__ */ import_react121.default.createElement(import_react121.default.Fragment, null, /* @__PURE__ */ import_react121.default.createElement(SVGPath, {
	    ref: nodeRef,
	    d: pathD,
	    style: {
	      transform
	    }
	  }), contextMenu);
	};
	function transformBox(xInUnitSpace, yInExtremumSpace, widthInUnitSpace, heightInExtremumSpace) {
	  const translateX = `calc(var(--unitSpaceToScaledSpaceMultiplier) * ${xInUnitSpace}px)`;
	  const translateY = `calc((var(--graphEditorVerticalSpace) - var(--graphEditorVerticalSpace) * ${yInExtremumSpace}) * 1px)`;
	  if (widthInUnitSpace === 0) {
	    widthInUnitSpace = 1e-4;
	  }
	  const scaleX = `calc(var(--unitSpaceToScaledSpaceMultiplier) * ${widthInUnitSpace})`;
	  if (heightInExtremumSpace === 0) {
	    heightInExtremumSpace = 1e-3;
	  }
	  const scaleY = `calc(var(--graphEditorVerticalSpace) * ${heightInExtremumSpace * -1})`;
	  return `translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`;
	}
	var Curve_default = Curve;
	function useConnectorContextMenu(node, props) {
	  const { index, trackData } = props;
	  const cur = trackData.keyframes[index];
	  const next = trackData.keyframes[index + 1];
	  return useContextMenu(node, {
	    items: () => {
	      return [
	        {
	          label: "Delete",
	          callback: () => {
	            getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	              const { deleteKeyframes } = stateEditors2.coreByProject.historic.sheetsById.sequence;
	              deleteKeyframes(__spreadProps(__spreadValues({}, props.sheetObject.address), {
	                trackId: props.trackId,
	                keyframeIds: [cur.id, next.id]
	              }));
	            });
	          }
	        }
	      ];
	    }
	  });
	}

	// studio/src/panels/SequenceEditorPanel/GraphEditor/BasicKeyframedTrack/KeyframeEditor/CurveHandle.tsx
	var import_dataverse28 = __toModule(dist$1);
	var import_react122 = __toModule(react.exports);
	var import_styled_components52 = __toModule(require$$3);
	var Circle = import_styled_components52.default.circle`
  stroke-width: 1px;
  vector-effect: non-scaling-stroke;
  fill: var(--main-color);
  r: 2px;
  pointer-events: none;
`;
	var HitZone2 = import_styled_components52.default.circle`
  stroke-width: 6px;
  vector-effect: non-scaling-stroke;
  r: 6px;
  fill: transparent;
  cursor: move;
  ${pointerEventsAutoInNormalMode};
  &:hover {
  }
  &:hover + ${Circle} {
    r: 6px;
  }
`;
	var Line = import_styled_components52.default.path`
  stroke-width: 1;
  stroke: var(--main-color);
  /* stroke: gray; */
  fill: none;
  vector-effect: non-scaling-stroke;
`;
	var CurveHandle = (props) => {
	  const [ref, node] = useRefAndState(null);
	  const { index, trackData } = props;
	  const cur = trackData.keyframes[index];
	  const next = trackData.keyframes[index + 1];
	  const [contextMenu] = useOurContextMenu(node, props);
	  useOurDrags(node, props);
	  const posInDiffSpace = props.which === "left" ? cur.handles[2] : next.handles[0];
	  const posInUnitSpace = cur.position + (next.position - cur.position) * posInDiffSpace;
	  const valInDiffSpace = props.which === "left" ? cur.handles[3] : next.handles[1];
	  const value = cur.value + (next.value - cur.value) * valInDiffSpace;
	  const valInExtremumSpace = props.extremumSpace.fromValueSpace(value);
	  const heightInExtremumSpace = valInExtremumSpace - props.extremumSpace.fromValueSpace(props.which === "left" ? cur.value : next.value);
	  const lineTransform = transformBox(props.which === "left" ? cur.position : next.position, props.extremumSpace.fromValueSpace(props.which === "left" ? cur.value : next.value), posInUnitSpace - (props.which === "left" ? cur.position : next.position), heightInExtremumSpace);
	  return /* @__PURE__ */ import_react122.default.createElement("g", null, /* @__PURE__ */ import_react122.default.createElement(HitZone2, {
	    ref,
	    style: {
	      cx: `calc(var(--unitSpaceToScaledSpaceMultiplier) * ${posInUnitSpace} * 1px)`,
	      cy: `calc((var(--graphEditorVerticalSpace) - var(--graphEditorVerticalSpace) * ${valInExtremumSpace}) * 1px)`
	    }
	  }), /* @__PURE__ */ import_react122.default.createElement(Circle, {
	    style: {
	      cx: `calc(var(--unitSpaceToScaledSpaceMultiplier) * ${posInUnitSpace} * 1px)`,
	      cy: `calc((var(--graphEditorVerticalSpace) - var(--graphEditorVerticalSpace) * ${valInExtremumSpace}) * 1px)`
	    }
	  }), /* @__PURE__ */ import_react122.default.createElement(Line, {
	    d: "M 0 0 L 1 1",
	    style: {
	      transform: lineTransform
	    }
	  }), contextMenu);
	};
	var CurveHandle_default = CurveHandle;
	function useOurDrags(node, props) {
	  const propsRef = (0, import_react122.useRef)(props);
	  propsRef.current = props;
	  const handlers = (0, import_react122.useMemo)(() => {
	    let scaledToUnitSpace;
	    let verticalToExtremumSpace;
	    let propsAtStartOfDrag;
	    let tempTransaction;
	    let unlockExtremums;
	    return {
	      lockCursorTo: "move",
	      onDragStart() {
	        propsAtStartOfDrag = propsRef.current;
	        scaledToUnitSpace = (0, import_dataverse28.val)(propsAtStartOfDrag.layoutP.scaledSpace.toUnitSpace);
	        verticalToExtremumSpace = (0, import_dataverse28.val)(propsAtStartOfDrag.layoutP.graphEditorVerticalSpace.toExtremumSpace);
	        unlockExtremums = propsAtStartOfDrag.extremumSpace.lock();
	      },
	      onDrag(dxInScaledSpace, dy) {
	        if (tempTransaction) {
	          tempTransaction.discard();
	          tempTransaction = void 0;
	        }
	        const { index, trackData } = propsAtStartOfDrag;
	        const cur = trackData.keyframes[index];
	        const next = trackData.keyframes[index + 1];
	        const dPosInUnitSpace = scaledToUnitSpace(dxInScaledSpace);
	        let dPosInKeyframeDiffSpace = dPosInUnitSpace / (next.position - cur.position);
	        const dyInVerticalSpace = -dy;
	        const dYInExtremumSpace = verticalToExtremumSpace(dyInVerticalSpace);
	        const dYInValueSpace = propsAtStartOfDrag.extremumSpace.deltaToValueSpace(dYInExtremumSpace);
	        const dyInKeyframeDiffSpace = dYInValueSpace / (next.value - cur.value);
	        if (propsAtStartOfDrag.which === "left") {
	          const handleX = clamp_default(cur.handles[2] + dPosInKeyframeDiffSpace, 0, 1);
	          const handleY = cur.handles[3] + dyInKeyframeDiffSpace;
	          tempTransaction = getStudio().tempTransaction(({ stateEditors: stateEditors2 }) => {
	            stateEditors2.coreByProject.historic.sheetsById.sequence.replaceKeyframes(__spreadProps(__spreadValues({}, propsAtStartOfDrag.sheetObject.address), {
	              snappingFunction: (0, import_dataverse28.val)(propsAtStartOfDrag.layoutP.sheet).getSequence().closestGridPosition,
	              trackId: propsAtStartOfDrag.trackId,
	              keyframes: [
	                __spreadProps(__spreadValues({}, cur), {
	                  handles: [cur.handles[0], cur.handles[1], handleX, handleY]
	                })
	              ]
	            }));
	          });
	        } else {
	          const handleX = clamp_default(next.handles[0] + dPosInKeyframeDiffSpace, 0, 1);
	          const handleY = next.handles[1] + dyInKeyframeDiffSpace;
	          tempTransaction = getStudio().tempTransaction(({ stateEditors: stateEditors2 }) => {
	            stateEditors2.coreByProject.historic.sheetsById.sequence.replaceKeyframes(__spreadProps(__spreadValues({}, propsAtStartOfDrag.sheetObject.address), {
	              trackId: propsAtStartOfDrag.trackId,
	              snappingFunction: (0, import_dataverse28.val)(propsAtStartOfDrag.layoutP.sheet).getSequence().closestGridPosition,
	              keyframes: [
	                __spreadProps(__spreadValues({}, next), {
	                  handles: [
	                    handleX,
	                    handleY,
	                    next.handles[2],
	                    next.handles[3]
	                  ]
	                })
	              ]
	            }));
	          });
	        }
	      },
	      onDragEnd(dragHappened) {
	        if (unlockExtremums) {
	          const unlock = unlockExtremums;
	          unlockExtremums = void 0;
	          unlock();
	        }
	        if (dragHappened) {
	          if (tempTransaction) {
	            tempTransaction.commit();
	          }
	        } else {
	          if (tempTransaction) {
	            tempTransaction.discard();
	          }
	        }
	        tempTransaction = void 0;
	      }
	    };
	  }, []);
	  useDrag(node, handlers);
	}
	function useOurContextMenu(node, props) {
	  return useContextMenu(node, {
	    items: () => {
	      return [
	        {
	          label: "Delete",
	          callback: () => {
	            getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	              stateEditors2.coreByProject.historic.sheetsById.sequence.deleteKeyframes(__spreadProps(__spreadValues({}, props.sheetObject.address), {
	                keyframeIds: [props.keyframe.id],
	                trackId: props.trackId
	              }));
	            });
	          }
	        }
	      ];
	    }
	  });
	}

	// studio/src/panels/SequenceEditorPanel/GraphEditor/BasicKeyframedTrack/KeyframeEditor/Dot.tsx
	var import_dataverse29 = __toModule(dist$1);
	var import_react123 = __toModule(react.exports);
	var import_styled_components53 = __toModule(require$$3);
	var Circle2 = import_styled_components53.default.circle`
  fill: var(--main-color);
  stroke-width: 1px;
  vector-effect: non-scaling-stroke;

  r: 2px;
`;
	var HitZone3 = import_styled_components53.default.circle`
  stroke-width: 6px;
  vector-effect: non-scaling-stroke;
  r: 6px;
  fill: transparent;
  ${pointerEventsAutoInNormalMode};

  &:hover + ${Circle2} {
    r: 6px;
  }

  #pointer-root.normal & {
    cursor: move;
  }

  #pointer-root.draggingPositionInSequenceEditor & {
    pointer-events: auto;
  }

  &.beingDragged {
    pointer-events: none !important;
  }
`;
	var Dot2 = (props) => {
	  const [ref, node] = useRefAndState(null);
	  const { index, trackData } = props;
	  const cur = trackData.keyframes[index];
	  trackData.keyframes[index + 1];
	  const [contextMenu] = useKeyframeContextMenu2(node, props);
	  const isDragging = useDragKeyframe3(node, props);
	  const cyInExtremumSpace = props.extremumSpace.fromValueSpace(cur.value);
	  return /* @__PURE__ */ import_react123.default.createElement(import_react123.default.Fragment, null, /* @__PURE__ */ import_react123.default.createElement(HitZone3, __spreadProps(__spreadValues({
	    ref,
	    style: {
	      cx: `calc(var(--unitSpaceToScaledSpaceMultiplier) * ${cur.position} * 1px)`,
	      cy: `calc((var(--graphEditorVerticalSpace) - var(--graphEditorVerticalSpace) * ${cyInExtremumSpace}) * 1px)`
	    }
	  }, {
	    [attributeNameThatLocksFramestamp]: cur.position.toFixed(3)
	  }), {
	    "data-pos": cur.position.toFixed(3),
	    className: isDragging ? "beingDragged" : ""
	  })), /* @__PURE__ */ import_react123.default.createElement(Circle2, {
	    style: {
	      cx: `calc(var(--unitSpaceToScaledSpaceMultiplier) * ${cur.position} * 1px)`,
	      cy: `calc((var(--graphEditorVerticalSpace) - var(--graphEditorVerticalSpace) * ${cyInExtremumSpace}) * 1px)`
	    }
	  }), contextMenu);
	};
	var Dot_default2 = Dot2;
	function useDragKeyframe3(node, _props) {
	  const [isDragging, setIsDragging] = (0, import_react123.useState)(false);
	  useLockFrameStampPosition(isDragging, _props.keyframe.position);
	  const propsRef = (0, import_react123.useRef)(_props);
	  propsRef.current = _props;
	  const gestureHandlers = (0, import_react123.useMemo)(() => {
	    let toUnitSpace;
	    let propsAtStartOfDrag;
	    let tempTransaction;
	    let verticalToExtremumSpace;
	    let unlockExtremums;
	    let keepSpeeds = false;
	    return {
	      lockCursorTo: "move",
	      onDragStart(event) {
	        setIsDragging(true);
	        keepSpeeds = !!event.altKey;
	        propsAtStartOfDrag = propsRef.current;
	        toUnitSpace = (0, import_dataverse29.val)(propsAtStartOfDrag.layoutP.scaledSpace.toUnitSpace);
	        verticalToExtremumSpace = (0, import_dataverse29.val)(propsAtStartOfDrag.layoutP.graphEditorVerticalSpace.toExtremumSpace);
	        unlockExtremums = propsAtStartOfDrag.extremumSpace.lock();
	      },
	      onDrag(dx, dy) {
	        const original = propsAtStartOfDrag.trackData.keyframes[propsAtStartOfDrag.index];
	        const deltaPos = toUnitSpace(dx);
	        const dyInVerticalSpace = -dy;
	        const dYInExtremumSpace = verticalToExtremumSpace(dyInVerticalSpace);
	        const dYInValueSpace = propsAtStartOfDrag.extremumSpace.deltaToValueSpace(dYInExtremumSpace);
	        const updatedKeyframes = [];
	        const cur = __spreadProps(__spreadValues({}, original), {
	          position: original.position + deltaPos,
	          value: original.value + dYInValueSpace,
	          handles: [...original.handles]
	        });
	        updatedKeyframes.push(cur);
	        if (keepSpeeds) {
	          const prev = propsAtStartOfDrag.trackData.keyframes[propsAtStartOfDrag.index - 1];
	          if (prev && Math.abs(original.value - prev.value) > 0) {
	            const newPrev = __spreadProps(__spreadValues({}, prev), { handles: [...prev.handles] });
	            updatedKeyframes.push(newPrev);
	            newPrev.handles[3] = preserveRightHandle(prev.handles[3], prev.value, prev.value, original.value, cur.value);
	          }
	          const next = propsAtStartOfDrag.trackData.keyframes[propsAtStartOfDrag.index + 1];
	          if (next && Math.abs(original.value - next.value) > 0) {
	            const newNext = __spreadProps(__spreadValues({}, next), { handles: [...next.handles] });
	            updatedKeyframes.push(newNext);
	            newNext.handles[1] = preserveLeftHandle(newNext.handles[1], newNext.value, newNext.value, original.value, cur.value);
	          }
	        }
	        tempTransaction == null ? void 0 : tempTransaction.discard();
	        tempTransaction = getStudio().tempTransaction(({ stateEditors: stateEditors2 }) => {
	          stateEditors2.coreByProject.historic.sheetsById.sequence.replaceKeyframes(__spreadProps(__spreadValues({}, propsAtStartOfDrag.sheetObject.address), {
	            trackId: propsAtStartOfDrag.trackId,
	            keyframes: updatedKeyframes,
	            snappingFunction: (0, import_dataverse29.val)(propsAtStartOfDrag.layoutP.sheet).getSequence().closestGridPosition
	          }));
	        });
	      },
	      onDragEnd(dragHappened) {
	        setIsDragging(false);
	        if (unlockExtremums) {
	          const unlock = unlockExtremums;
	          unlockExtremums = void 0;
	          unlock();
	        }
	        if (dragHappened) {
	          tempTransaction == null ? void 0 : tempTransaction.commit();
	        } else {
	          tempTransaction == null ? void 0 : tempTransaction.discard();
	        }
	        tempTransaction = void 0;
	      }
	    };
	  }, []);
	  useDrag(node, gestureHandlers);
	  useCursorLock(isDragging, "draggingPositionInSequenceEditor", "move");
	  return isDragging;
	}
	function useKeyframeContextMenu2(node, props) {
	  return useContextMenu(node, {
	    items: () => {
	      return [
	        {
	          label: "Delete",
	          callback: () => {
	            getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	              stateEditors2.coreByProject.historic.sheetsById.sequence.deleteKeyframes(__spreadProps(__spreadValues({}, props.sheetObject.address), {
	                keyframeIds: [props.keyframe.id],
	                trackId: props.trackId
	              }));
	            });
	          }
	        }
	      ];
	    }
	  });
	}
	function preserveRightHandle(rightHandleInKeyframeDeltaSpace, originalValueOfMovedKeyframe, newValueOfMovedKeyframe, originalValueOfNeighbouringKeyframe, newValueOfNeighbouringKeyframe) {
	  const diffOfHandleYToMovingKeyframeInValueSpace = (originalValueOfNeighbouringKeyframe - originalValueOfMovedKeyframe) * rightHandleInKeyframeDeltaSpace;
	  const newHandleYInKeyframeDeltaSpace = diffOfHandleYToMovingKeyframeInValueSpace / (newValueOfNeighbouringKeyframe - newValueOfMovedKeyframe);
	  return newHandleYInKeyframeDeltaSpace;
	}
	function preserveLeftHandle(leftHandleInKeyframeDeltaSpace, originalValueOfMovedKeyframe, newValueOfMovedKeyframe, originalValueOfNeighbouringKeyframe, newValueOfNeighbouringKeyframe) {
	  const handleYInValueSpace = (originalValueOfMovedKeyframe - originalValueOfNeighbouringKeyframe) * leftHandleInKeyframeDeltaSpace + originalValueOfNeighbouringKeyframe;
	  const diffOfHandleYToMovingKeyframeInValueSpace = handleYInValueSpace - originalValueOfMovedKeyframe;
	  const newHandleYInValueSpace = diffOfHandleYToMovingKeyframeInValueSpace + newValueOfMovedKeyframe;
	  const diffOfNewHandleYToNeighbouringKeyframe = newHandleYInValueSpace - newValueOfNeighbouringKeyframe;
	  const newHandleYInKeyframeDeltaSpace = diffOfNewHandleYToNeighbouringKeyframe / (newValueOfMovedKeyframe - newValueOfNeighbouringKeyframe);
	  return newHandleYInKeyframeDeltaSpace;
	}

	// studio/src/panels/SequenceEditorPanel/GraphEditor/BasicKeyframedTrack/KeyframeEditor/KeyframeEditor.tsx
	var Container36 = import_styled_components54.default.g`
  /* position: absolute; */
`;
	var noConnector2 = /* @__PURE__ */ import_react124.default.createElement(import_react124.default.Fragment, null);
	var KeyframeEditor2 = (props) => {
	  const { index, trackData } = props;
	  const cur = trackData.keyframes[index];
	  const next = trackData.keyframes[index + 1];
	  const connected = cur.connectedRight && !!next;
	  const shouldShowCurve = connected && next.value - cur.value !== 0;
	  return /* @__PURE__ */ import_react124.default.createElement(Container36, null, shouldShowCurve ? /* @__PURE__ */ import_react124.default.createElement(import_react124.default.Fragment, null, /* @__PURE__ */ import_react124.default.createElement(Curve_default, __spreadValues({}, props)), /* @__PURE__ */ import_react124.default.createElement(CurveHandle_default, __spreadProps(__spreadValues({}, props), {
	    which: "left"
	  })), /* @__PURE__ */ import_react124.default.createElement(CurveHandle_default, __spreadProps(__spreadValues({}, props), {
	    which: "right"
	  }))) : noConnector2, /* @__PURE__ */ import_react124.default.createElement(Dot_default2, __spreadValues({}, props)));
	};
	var KeyframeEditor_default2 = KeyframeEditor2;

	// studio/src/panels/SequenceEditorPanel/GraphEditor/BasicKeyframedTrack/BasicKeyframedTrack.tsx
	import_styled_components55.default.div``;
	var BasicKeyframedTrack2 = import_react125.default.memo(({ layoutP, trackData, sheetObject, trackId, color: color2 }) => {
	  const [areExtremumsLocked, setAreExtremumsLocked] = (0, import_react125.useState)(false);
	  const lockExtremums = (0, import_react125.useMemo)(() => {
	    const locks = new Set();
	    return function lockExtremums2() {
	      const shouldLock = locks.size === 0;
	      locks.add(unlock);
	      if (shouldLock)
	        setAreExtremumsLocked(true);
	      function unlock() {
	        const wasLocked = locks.size > 0;
	        locks.delete(unlock);
	        if (wasLocked && locks.size === 0)
	          setAreExtremumsLocked(false);
	      }
	      return unlock;
	    };
	  }, []);
	  const extremumSpace = (0, import_react125.useMemo)(() => {
	    const extremums = calculateExtremums(trackData.keyframes);
	    const fromValueSpace = (val39) => (val39 - extremums[0]) / (extremums[1] - extremums[0]);
	    const toValueSpace = (ex) => extremums[0] + deltaToValueSpace(ex);
	    const deltaToValueSpace = (ex) => ex * (extremums[1] - extremums[0]);
	    return {
	      fromValueSpace,
	      toValueSpace,
	      deltaToValueSpace,
	      lock: lockExtremums
	    };
	  }, [trackData.keyframes]);
	  const cachedExtremumSpace = (0, import_react125.useRef)(void 0);
	  if (!areExtremumsLocked) {
	    cachedExtremumSpace.current = extremumSpace;
	  }
	  const keyframeEditors = trackData.keyframes.map((kf, index) => /* @__PURE__ */ import_react125.default.createElement(KeyframeEditor_default2, {
	    keyframe: kf,
	    index,
	    trackData,
	    layoutP,
	    sheetObject,
	    trackId,
	    key: "keyframe-" + kf.id,
	    extremumSpace: cachedExtremumSpace.current,
	    color: color2
	  }));
	  return /* @__PURE__ */ import_react125.default.createElement("g", {
	    style: {
	      "--main-color": graphEditorColors[color2].iconColor
	    }
	  }, keyframeEditors);
	});
	var BasicKeyframedTrack_default2 = BasicKeyframedTrack2;
	function calculateExtremums(keyframes) {
	  let min = Infinity, max = -Infinity;
	  function check(n2) {
	    min = Math.min(n2, min);
	    max = Math.max(n2, max);
	  }
	  keyframes.forEach((cur, i2) => {
	    check(cur.value);
	    if (!cur.connectedRight)
	      return;
	    const next = keyframes[i2 + 1];
	    if (!next)
	      return;
	    const diff = next.value - cur.value;
	    check(cur.value + cur.handles[3] * diff);
	    check(cur.value + next.handles[1] * diff);
	  });
	  return [min, max];
	}

	// studio/src/panels/SequenceEditorPanel/GraphEditor/PrimitivePropGraph.tsx
	import_styled_components56.default.div``;
	var PrimitivePropGraph = (props) => {
	  return usePrism(() => {
	    const { sheetObject, trackId, pathToProp } = props;
	    const trackData = (0, import_dataverse30.val)(getStudio().atomP.historic.coreByProject[sheetObject.address.projectId].sheetsById[sheetObject.address.sheetId].sequence.tracksByObject[sheetObject.address.objectKey].trackData[trackId]);
	    if ((trackData == null ? void 0 : trackData.type) !== "BasicKeyframedTrack") {
	      console.error(`trackData type ${trackData == null ? void 0 : trackData.type} is not yet supported on the graph editor`);
	      return /* @__PURE__ */ import_react127.default.createElement(import_react127.default.Fragment, null);
	    } else {
	      return /* @__PURE__ */ import_react127.default.createElement(BasicKeyframedTrack_default2, __spreadProps(__spreadValues({}, props), {
	        trackData
	      }));
	    }
	  }, [props.trackId, props.layoutP]);
	};
	var PrimitivePropGraph_default = PrimitivePropGraph;

	// studio/src/panels/SequenceEditorPanel/FrameGrid/FrameGrid.tsx
	var import_dataverse32 = __toModule(dist$1);
	var import_react128 = __toModule(react.exports);
	var import_styled_components57 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/FrameGrid/createGrid.ts
	var getFactorsOfNumber = memoize_default((divisionsPerUnit) => {
	  const factors = [];
	  for (let i2 = 1; i2 <= divisionsPerUnit; i2++) {
	    if (divisionsPerUnit % i2 === 0) {
	      factors.push(i2);
	    }
	  }
	  return factors;
	});
	function createGrid({
	  clippedSpaceRange,
	  clippedSpaceWidth,
	  fps,
	  gapWidth = 120
	}, cb) {
	  const frameLengthInSeconeds = 1 / fps;
	  const clippedSpaceLengthInSeconds = clippedSpaceRange.end - clippedSpaceRange.start;
	  const frameWidthInScreenSpace = clippedSpaceWidth / (fps * clippedSpaceLengthInSeconds);
	  const numberOfFramesFittingInMinimumCellWidth = Math.floor(gapWidth / frameWidthInScreenSpace);
	  const numberOfFramesPerCell = numberOfFramesFittingInMinimumCellWidth < fps ? getFactorsOfNumber(fps).find((factor) => factor >= numberOfFramesFittingInMinimumCellWidth) : fps * Math.floor(numberOfFramesFittingInMinimumCellWidth / fps);
	  const cellLengthInSeconds = numberOfFramesPerCell * frameLengthInSeconeds;
	  const startCell = Math.floor(clippedSpaceRange.start / cellLengthInSeconds);
	  const endCell = Math.ceil(clippedSpaceRange.end / cellLengthInSeconds);
	  for (let cell = startCell; cell <= endCell; cell++) {
	    const posInUnitSpace = cell * cellLengthInSeconds;
	    const isFullSecond = posInUnitSpace % 1 === 0;
	    cb(posInUnitSpace, isFullSecond);
	  }
	}

	// studio/src/studioTicker.ts
	var import_dataverse31 = __toModule(dist$1);
	var studioTicker = new import_dataverse31.Ticker();
	var studioTicker_default = studioTicker;
	var onAnimationFrame = (t2) => {
	  studioTicker.tick(t2);
	  window.requestAnimationFrame(onAnimationFrame);
	};
	window.requestAnimationFrame(onAnimationFrame);

	// studio/src/panels/SequenceEditorPanel/FrameGrid/FrameGrid.tsx
	var Container39 = import_styled_components57.default.div`
  position: absolute;
  top: 0;
  left: 0;
  height: 100%;
  pointer-events: none;
`;
	var TheCanvas = import_styled_components57.default.canvas`
  position: relative;
  left: 0;
`;
	var getBackingStoreRatio = (ctx3) => {
	  const _ctx = ctx3;
	  return _ctx.webkitBackingStorePixelRatio || _ctx.mozBackingStorePixelRatio || _ctx.msBackingStorePixelRatio || _ctx.oBackingStorePixelRatio || _ctx.backingStorePixelRatio || 1;
	};
	var getDevicePixelRatio = () => window.devicePixelRatio || 1;
	var getRatio = (ctx3) => {
	  return getDevicePixelRatio() / getBackingStoreRatio(ctx3);
	};
	var FrameGrid = ({ layoutP, width, height: height2 }) => {
	  const containerRef = (0, import_react128.useRef)(null);
	  const [canvas, canvasRef] = (0, import_react128.useState)(null);
	  const { ctx: ctx3, ratio } = (0, import_react128.useMemo)(() => {
	    if (!canvas)
	      return {};
	    const ctx4 = canvas.getContext("2d");
	    const ratio2 = getRatio(ctx4);
	    return { ctx: ctx4, ratio: ratio2 };
	  }, [canvas]);
	  (0, import_react128.useLayoutEffect)(() => {
	    if (!ctx3)
	      return;
	    canvas.width = width * ratio;
	    canvas.height = height2 * ratio;
	    const untap = (0, import_dataverse32.prism)(() => {
	      const sequence = (0, import_dataverse32.val)(layoutP.sheet).getSequence();
	      return {
	        ctx: ctx3,
	        clippedSpaceRange: (0, import_dataverse32.val)(layoutP.clippedSpace.range),
	        clippedSpaceWidth: (0, import_dataverse32.val)(layoutP.clippedSpace.width),
	        unitSpaceToClippedSpace: (0, import_dataverse32.val)(layoutP.clippedSpace.fromUnitSpace),
	        height: height2,
	        leftPadding: (0, import_dataverse32.val)(layoutP.scaledSpace.leftPadding),
	        fps: sequence.subUnitsPerUnit,
	        snapToGrid: (n2) => sequence.closestGridPosition(n2)
	      };
	    }).tapImmediate(studioTicker_default, (p2) => {
	      ctx3.save();
	      ctx3.scale(ratio, ratio);
	      drawGrid(p2);
	      ctx3.restore();
	    });
	    return () => {
	      untap();
	    };
	  }, [ctx3, width, height2, layoutP]);
	  return /* @__PURE__ */ import_react128.default.createElement(Container39, {
	    ref: containerRef,
	    style: { width: width + "px" }
	  }, /* @__PURE__ */ import_react128.default.createElement(TheCanvas, {
	    ref: canvasRef,
	    style: {
	      width: width + "px",
	      height: height2 + "px"
	    }
	  }));
	};
	var FrameGrid_default = FrameGrid;
	function drawGrid(opts) {
	  const { clippedSpaceWidth, height: height2, ctx: ctx3, unitSpaceToClippedSpace, snapToGrid } = opts;
	  ctx3.clearRect(0, 0, clippedSpaceWidth, height2);
	  createGrid(opts, (_posInUnitSpace, isFullSecond) => {
	    const posInUnitSpace = snapToGrid(_posInUnitSpace);
	    const posInClippedSpace = Math.floor(unitSpaceToClippedSpace(posInUnitSpace));
	    ctx3.strokeStyle = isFullSecond ? "rgba(225, 225, 225, 0.04)" : "rgba(255, 255, 255, 0.01)";
	    ctx3.beginPath();
	    ctx3.moveTo(posInClippedSpace, 0);
	    ctx3.lineTo(posInClippedSpace, height2);
	    ctx3.stroke();
	    ctx3.closePath();
	  });
	}

	// studio/src/panels/SequenceEditorPanel/GraphEditor/GraphEditor.tsx
	var graphEditorColors = {
	  "1": { iconColor: "#b98b08" },
	  "2": { iconColor: "#70a904" },
	  "3": { iconColor: "#2e928a" },
	  "4": { iconColor: "#a943bb" },
	  "5": { iconColor: "#b90808" },
	  "6": { iconColor: "#b4bf0e" }
	};
	var Container40 = import_styled_components58.default.div`
  position: absolute;
  right: 0;
  bottom: 0;
  background: ${curriedTransparentize(0.03, "#1a1c1e")};
`;
	var SVGContainer = import_styled_components58.default.svg`
  position: absolute;
  top: 0;
  left: 0;
  margin: 0;
  pointer-events: none;
`;
	var GraphEditor = ({ layoutP }) => {
	  return usePrism(() => {
	    const sheet = (0, import_dataverse33.val)(layoutP.sheet);
	    const selectedPropsByObject = (0, import_dataverse33.val)(getStudio().atomP.historic.projects.stateByProjectId[sheet.address.projectId].stateBySheetId[sheet.address.sheetId].sequenceEditor.selectedPropsByObject);
	    const height2 = (0, import_dataverse33.val)(layoutP.graphEditorDims.height);
	    const unitSpaceToScaledSpaceMultiplier = (0, import_dataverse33.val)(layoutP.scaledSpace.fromUnitSpace)(1);
	    const graphs = [];
	    if (selectedPropsByObject) {
	      for (const [objectKey, props] of Object.entries(selectedPropsByObject)) {
	        const sheetObject = sheet.getObject(objectKey);
	        if (!sheetObject)
	          continue;
	        const validSequenceTracks = (0, import_dataverse33.val)(sheetObject.template.getMapOfValidSequenceTracks_forStudio());
	        for (const [encodedPathToProp, graphEditorColor] of Object.entries(props)) {
	          const pathToProp = decodePathToProp(encodedPathToProp);
	          const possibleSequenceTrackId = getDeep(validSequenceTracks, pathToProp);
	          if (!possibleSequenceTrackId)
	            continue;
	          graphs.push(/* @__PURE__ */ import_react130.default.createElement(PrimitivePropGraph_default, {
	            key: `graph-${objectKey}-${encodedPathToProp}`,
	            sheetObject,
	            pathToProp,
	            layoutP,
	            trackId: possibleSequenceTrackId,
	            color: graphEditorColor
	          }));
	        }
	      }
	    }
	    const width = (0, import_dataverse33.val)(layoutP.rightDims.width);
	    return /* @__PURE__ */ import_react130.default.createElement(Container40, {
	      style: {
	        width: width + "px",
	        height: height2 + "px",
	        "--unitSpaceToScaledSpaceMultiplier": unitSpaceToScaledSpaceMultiplier,
	        "--graphEditorVerticalSpace": `${(0, import_dataverse33.val)(layoutP.graphEditorVerticalSpace.space)}`
	      }
	    }, /* @__PURE__ */ import_react130.default.createElement(FrameGrid_default, {
	      layoutP,
	      width,
	      height: height2
	    }), /* @__PURE__ */ import_react130.default.createElement(HorizontallyScrollableArea_default, {
	      layoutP,
	      height: height2
	    }, /* @__PURE__ */ import_react130.default.createElement(SVGContainer, {
	      width: contentWidth,
	      height: height2,
	      viewBox: `0 0 ${contentWidth} ${height2}`
	    }, /* @__PURE__ */ import_react130.default.createElement("g", {
	      style: {
	        transform: `translate(0, ${(0, import_dataverse33.val)(layoutP.graphEditorDims.padding.top)}px)`
	      }
	    }, graphs))));
	  }, [layoutP]);
	};
	var GraphEditor_default = GraphEditor;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Left/PrimitivePropRow.tsx
	var theme3 = {
	  label: {
	    color: `#9a9a9a`
	  }
	};
	var Container41 = (0, import_styled_components59.default)(Container25)``;
	var Head3 = (0, import_styled_components59.default)(BaseHeader2)`
  display: flex;
  color: ${theme3.label.color};
  padding-right: 12px;
  align-items: center;
  justify-content: flex-end;
  box-sizing: border-box;
`;
	var IconContainer2 = import_styled_components59.default.button`
  background: none;
  border: none;
  outline: none;
  display: flex;
  box-sizing: border-box;
  font-size: 14px;
  align-items: center;
  height: 100%;
  margin-left: 12px;
  color: ${(props) => props.isSelected ? graphEditorColors[props.graphEditorColor].iconColor : nextPrevCursorsTheme.offColor};

  &:hover {
    color: white;
  }
`;
	var GraphIcon = () => /* @__PURE__ */ import_react132.default.createElement("svg", {
	  xmlns: "http://www.w3.org/2000/svg",
	  width: "10",
	  height: "12",
	  viewBox: "0 0 640 512"
	}, /* @__PURE__ */ import_react132.default.createElement("g", {
	  transform: "translate(0 100)"
	}, /* @__PURE__ */ import_react132.default.createElement("path", {
	  fill: "currentColor",
	  d: "M368 32h-96c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h96c17.67 0 32-14.33 32-32V64c0-17.67-14.33-32-32-32zM208 88h-84.75C113.75 64.56 90.84 48 64 48 28.66 48 0 76.65 0 112s28.66 64 64 64c26.84 0 49.75-16.56 59.25-40h79.73c-55.37 32.52-95.86 87.32-109.54 152h49.4c11.3-41.61 36.77-77.21 71.04-101.56-3.7-8.08-5.88-16.99-5.88-26.44V88zm-48 232H64c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h96c17.67 0 32-14.33 32-32v-96c0-17.67-14.33-32-32-32zM576 48c-26.84 0-49.75 16.56-59.25 40H432v72c0 9.45-2.19 18.36-5.88 26.44 34.27 24.35 59.74 59.95 71.04 101.56h49.4c-13.68-64.68-54.17-119.48-109.54-152h79.73c9.5 23.44 32.41 40 59.25 40 35.34 0 64-28.65 64-64s-28.66-64-64-64zm0 272h-96c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h96c17.67 0 32-14.33 32-32v-96c0-17.67-14.33-32-32-32z"
	})));
	var Head_Label3 = import_styled_components59.default.span`
  margin-right: 4px;
  ${propNameText};
`;
	var PrimitivePropRow2 = ({ leaf }) => {
	  const pointerToProp = pointerDeep(leaf.sheetObject.propsP, leaf.pathToProp);
	  const obj = leaf.sheetObject;
	  const { controlIndicators } = useEditingToolsForPrimitiveProp(pointerToProp, obj, leaf.propConf);
	  const possibleColor = usePrism(() => {
	    const c2 = leaf.sheetObject.address;
	    const encodedPathToProp = encodePathToProp(leaf.pathToProp);
	    return (0, import_dataverse34.val)(getStudio().atomP.historic.projects.stateByProjectId[c2.projectId].stateBySheetId[c2.sheetId].sequenceEditor.selectedPropsByObject[c2.objectKey][encodedPathToProp]);
	  }, [leaf]);
	  const isSelectedRef = (0, import_react132.useRef)(false);
	  const isSelected = typeof possibleColor === "string";
	  isSelectedRef.current = isSelected;
	  const toggleSelect = (0, import_react132.useCallback)(() => {
	    const c2 = leaf.sheetObject.address;
	    getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	      if (isSelectedRef.current) {
	        stateEditors2.studio.historic.projects.stateByProjectId.stateBySheetId.sequenceEditor.removePropFromGraphEditor(__spreadProps(__spreadValues({}, c2), { pathToProp: leaf.pathToProp }));
	      } else {
	        stateEditors2.studio.historic.projects.stateByProjectId.stateBySheetId.sequenceEditor.addPropToGraphEditor(__spreadProps(__spreadValues({}, c2), { pathToProp: leaf.pathToProp }));
	        stateEditors2.studio.historic.panels.sequenceEditor.graphEditor.setIsOpen({
	          isOpen: true
	        });
	      }
	    });
	  }, [leaf]);
	  const label = leaf.pathToProp[leaf.pathToProp.length - 1];
	  return /* @__PURE__ */ import_react132.default.createElement(Container41, {
	    depth: leaf.depth
	  }, /* @__PURE__ */ import_react132.default.createElement(Head3, {
	    isEven: leaf.n % 2 === 0,
	    style: {
	      height: leaf.nodeHeight + "px"
	    },
	    isSelected: isSelected === true
	  }, /* @__PURE__ */ import_react132.default.createElement(Head_Label3, null, label), controlIndicators, /* @__PURE__ */ import_react132.default.createElement(IconContainer2, {
	    onClick: toggleSelect,
	    isSelected: isSelected === true,
	    graphEditorColor: possibleColor != null ? possibleColor : "1"
	  }, /* @__PURE__ */ import_react132.default.createElement(GraphIcon, null))));
	};
	var PrimitivePropRow_default2 = PrimitivePropRow2;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Left/PropWithChildrenRow.tsx
	var decideRowByPropType2 = (leaf) => leaf.type === "propWithChildren" ? /* @__PURE__ */ import_react134.default.createElement(PropWithChildrenRow2, {
	  leaf,
	  key: "prop" + leaf.pathToProp[leaf.pathToProp.length - 1]
	}) : /* @__PURE__ */ import_react134.default.createElement(PrimitivePropRow_default2, {
	  leaf,
	  key: "prop" + leaf.pathToProp[leaf.pathToProp.length - 1]
	});
	import_styled_components60.default.div``;
	var PropWithChildrenRow2 = ({ leaf }) => {
	  return usePrism(() => {
	    return /* @__PURE__ */ import_react134.default.createElement(AnyCompositeRow_default, {
	      leaf,
	      label: leaf.pathToProp[leaf.pathToProp.length - 1]
	    }, leaf.children.map((propLeaf) => decideRowByPropType2(propLeaf)));
	  }, [leaf]);
	};

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Left/SheetObjectRow.tsx
	import_styled_components61.default.div``;
	var SheetObjectRow2 = ({ leaf }) => {
	  return usePrism(() => {
	    return /* @__PURE__ */ import_react136.default.createElement(AnyCompositeRow_default, {
	      leaf,
	      label: leaf.sheetObject.address.objectKey
	    }, leaf.children.map((leaf2) => decideRowByPropType2(leaf2)));
	  }, [leaf]);
	};
	var SheetObjectRow_default2 = SheetObjectRow2;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Left/SheetRow.tsx
	import_styled_components62.default.div``;
	var SheetRow2 = ({ leaf }) => {
	  return usePrism(() => {
	    return /* @__PURE__ */ import_react138.default.createElement(import_react138.default.Fragment, null, leaf.children.map((sheetObjectLeaf) => /* @__PURE__ */ import_react138.default.createElement(SheetObjectRow_default2, {
	      key: "sheetObject-" + sheetObjectLeaf.sheetObject.address.objectKey,
	      leaf: sheetObjectLeaf
	    })));
	  }, [leaf]);
	};
	var SheetRow_default2 = SheetRow2;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Left/Left.tsx
	var Container45 = import_styled_components63.default.div`
  position: absolute;
  left: 0;
  overflow-x: visible;
`;
	var ListContainer2 = import_styled_components63.default.ul`
  margin: 0;
  padding: 0;
  list-style: none;
`;
	var Left3 = ({ layoutP }) => {
	  return usePrism(() => {
	    const tree = (0, import_dataverse35.val)(layoutP.tree);
	    const width = (0, import_dataverse35.val)(layoutP.leftDims.width);
	    return /* @__PURE__ */ import_react140.default.createElement(Container45, {
	      style: { width: width + "px", top: tree.top + "px" }
	    }, /* @__PURE__ */ import_react140.default.createElement(ListContainer2, null, /* @__PURE__ */ import_react140.default.createElement(SheetRow_default2, {
	      leaf: tree
	    })));
	  }, [layoutP]);
	};
	var Left_default = Left3;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/DopeSheetBackground.tsx
	var import_react142 = __toModule(react.exports);
	var import_styled_components64 = __toModule(require$$3);
	var Container46 = import_styled_components64.default.div`
  position: absolute;
  top: 0;
  right: 0;
  bottom: 0;
  z-index: ${() => zIndexes.rightBackground};
  overflow: hidden;
  background: ${curriedTransparentize(0.01, curriedDarken(1 * 0.03, theme.panel.bg))};
  pointer-events: none;
`;
	var DopeSheetBackground = ({ layoutP }) => {
	  const width = useVal(layoutP.rightDims.width);
	  const height2 = useVal(layoutP.panelDims.height);
	  return /* @__PURE__ */ import_react142.default.createElement(Container46, {
	    style: { width: width + "px" }
	  }, /* @__PURE__ */ import_react142.default.createElement(FrameGrid_default, {
	    width,
	    height: height2,
	    layoutP
	  }));
	};
	var DopeSheetBackground_default = DopeSheetBackground;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/DopeSheet.tsx
	var Container47 = import_styled_components65.default.div`
  position: absolute;
  left: 0;
  right: 0;
`;
	var DopeSheet = ({
	  layoutP
	}) => {
	  const height2 = useVal(layoutP.dopeSheetDims.height);
	  return /* @__PURE__ */ import_react144.default.createElement(Container47, {
	    style: { height: height2 + "px" }
	  }, /* @__PURE__ */ import_react144.default.createElement(DopeSheetBackground_default, {
	    layoutP
	  }), /* @__PURE__ */ import_react144.default.createElement(VerticalScrollContainer_default, null, /* @__PURE__ */ import_react144.default.createElement(Left_default, {
	    layoutP
	  }), /* @__PURE__ */ import_react144.default.createElement(Right_default, {
	    layoutP
	  })));
	};
	var DopeSheet_default = DopeSheet;

	// shared/src/utils/subPrism.ts
	var import_dataverse36 = __toModule(dist$1);
	function subPrism(key, fn2, deps) {
	  const m = import_dataverse36.prism.memo(key, () => (0, import_dataverse36.prism)(fn2), deps);
	  return m.getValue();
	}

	// studio/src/panels/SequenceEditorPanel/layout/layout.ts
	var import_dataverse38 = __toModule(dist$1);

	// studio/src/panels/SequenceEditorPanel/layout/tree.ts
	var import_dataverse37 = __toModule(dist$1);
	var heightOfAnyTitle = 28;
	var calculateSequenceEditorTree = (sheet) => {
	  import_dataverse37.prism.ensurePrism();
	  let topSoFar = titleBarHeight;
	  let nSoFar = 0;
	  const tree = {
	    type: "sheet",
	    sheet,
	    children: [],
	    top: topSoFar,
	    depth: -1,
	    n: nSoFar,
	    nodeHeight: 0,
	    heightIncludingChildren: -1
	  };
	  topSoFar += tree.nodeHeight;
	  nSoFar += 1;
	  for (const [_2, sheetObject] of Object.entries((0, import_dataverse37.val)(sheet.objectsP))) {
	    addObject(sheetObject, tree.children, tree.depth + 1);
	  }
	  tree.heightIncludingChildren = topSoFar - tree.top;
	  function addObject(sheetObject, arrayOfChildren, level) {
	    const trackSetups = (0, import_dataverse37.val)(sheetObject.template.getMapOfValidSequenceTracks_forStudio());
	    if (Object.keys(trackSetups).length === 0)
	      return;
	    const row = {
	      type: "sheetObject",
	      top: topSoFar,
	      children: [],
	      depth: level,
	      n: nSoFar,
	      sheetObject,
	      nodeHeight: heightOfAnyTitle,
	      heightIncludingChildren: -1
	    };
	    arrayOfChildren.push(row);
	    nSoFar += 1;
	    topSoFar += heightOfAnyTitle;
	    addProps(sheetObject, trackSetups, [], sheetObject.template.config, row.children, level + 1);
	    row.heightIncludingChildren = topSoFar - row.top;
	  }
	  function addProps(sheetObject, trackSetups, pathSoFar, parentPropConfig, arrayOfChildren, level) {
	    for (const [propKey, setupOrSetups] of Object.entries(trackSetups)) {
	      const propConfig = parentPropConfig.props[propKey];
	      if (isPropConfigComposite(propConfig))
	        continue;
	      addProp(sheetObject, setupOrSetups, [...pathSoFar, propKey], propConfig, arrayOfChildren, level);
	    }
	    for (const [propKey, setupOrSetups] of Object.entries(trackSetups)) {
	      const propConfig = parentPropConfig.props[propKey];
	      if (!isPropConfigComposite(propConfig))
	        continue;
	      addProp(sheetObject, setupOrSetups, [...pathSoFar, propKey], propConfig, arrayOfChildren, level);
	    }
	  }
	  function addProp(sheetObject, trackIdOrMapping, pathToProp, conf, arrayOfChildren, level) {
	    if (conf.type === "compound") {
	      const trackMapping = trackIdOrMapping;
	      addProp_compound(sheetObject, trackMapping, pathToProp, conf, arrayOfChildren, level);
	    } else if (conf.type === "enum") {
	      logger_default.warn("Prop type enum is not yet supported in the sequence editor");
	    } else {
	      const trackId = trackIdOrMapping;
	      addProp_primitive(sheetObject, trackId, pathToProp, conf, arrayOfChildren, level);
	    }
	  }
	  function addProp_compound(sheetObject, trackMapping, pathToProp, conf, arrayOfChildren, level) {
	    const row = {
	      type: "propWithChildren",
	      pathToProp,
	      sheetObject,
	      top: topSoFar,
	      children: [],
	      nodeHeight: heightOfAnyTitle,
	      heightIncludingChildren: -1,
	      depth: level,
	      trackMapping,
	      n: nSoFar
	    };
	    topSoFar += heightOfAnyTitle;
	    nSoFar += 1;
	    arrayOfChildren.push(row);
	    addProps(sheetObject, trackMapping, pathToProp, conf, row.children, level + 1);
	    row.heightIncludingChildren = topSoFar - row.top;
	  }
	  function addProp_primitive(sheetObject, trackId, pathToProp, propConf, arrayOfChildren, level) {
	    const row = {
	      type: "primitiveProp",
	      propConf,
	      depth: level,
	      sheetObject,
	      pathToProp,
	      top: topSoFar,
	      nodeHeight: heightOfAnyTitle,
	      heightIncludingChildren: heightOfAnyTitle,
	      trackId,
	      n: nSoFar
	    };
	    arrayOfChildren.push(row);
	    nSoFar += 1;
	    topSoFar += heightOfAnyTitle;
	  }
	  return tree;
	};

	// studio/src/panels/SequenceEditorPanel/layout/layout.ts
	var panelSplitRatio = 0.2;
	var initialClippedSpaceRange = { start: 0, end: 10 };
	function sequenceEditorPanelLayout(sheet, panelDimsP) {
	  const studio3 = getStudio();
	  const ahistoricStateP = studio3.atomP.ahistoric.projects.stateByProjectId[sheet.address.projectId].stateBySheetId[sheet.address.sheetId];
	  const historicStateP = studio3.atomP.historic.projects.stateByProjectId[sheet.address.projectId].stateBySheetId[sheet.address.sheetId];
	  return (0, import_dataverse38.prism)(() => {
	    var _a;
	    const tree = subPrism("tree", () => calculateSequenceEditorTree(sheet), []);
	    const panelDims = (0, import_dataverse38.val)(panelDimsP);
	    const graphEditorState = (0, import_dataverse38.val)(studio3.atomP.historic.panels.sequenceEditor.graphEditor);
	    const selectedPropsByObject = (0, import_dataverse38.val)(historicStateP.sequenceEditor.selectedPropsByObject);
	    const graphEditorAvailable = !!selectedPropsByObject && Object.keys(selectedPropsByObject).length > 0;
	    const {
	      leftDims,
	      rightDims,
	      graphEditorDims,
	      dopeSheetDims,
	      horizontalScrollbarDims
	    } = import_dataverse38.prism.memo("leftDims", () => {
	      var _a2;
	      const leftDims2 = {
	        width: Math.floor(panelDims.width * panelSplitRatio),
	        height: panelDims.height,
	        screenX: panelDims.screenX,
	        screenY: panelDims.screenY
	      };
	      const rightDims2 = {
	        width: panelDims.width - leftDims2.width,
	        height: panelDims.height,
	        screenX: panelDims.screenX + leftDims2.width,
	        screenY: panelDims.screenY
	      };
	      const graphEditorOpen = graphEditorAvailable && (graphEditorState == null ? void 0 : graphEditorState.isOpen) === true;
	      const graphEditorHeight = Math.floor((graphEditorOpen ? clamp_default((_a2 = graphEditorState == null ? void 0 : graphEditorState.height) != null ? _a2 : 0.5, 0.1, 0.7) : 0) * panelDims.heightWithoutBorder);
	      const bottomHeight = 0 + graphEditorHeight;
	      const dopeSheetHeight = panelDims.height - bottomHeight;
	      const dopeSheetDims2 = {
	        width: panelDims.width,
	        height: dopeSheetHeight,
	        screenX: panelDims.screenX,
	        screenY: panelDims.screenY
	      };
	      const graphEditorDims2 = {
	        isAvailable: graphEditorAvailable,
	        isOpen: graphEditorOpen,
	        width: rightDims2.width,
	        height: graphEditorHeight,
	        screenX: panelDims.screenX,
	        screenY: panelDims.screenY + dopeSheetHeight,
	        padding: {
	          top: 20,
	          bottom: 20
	        }
	      };
	      const horizontalScrollbarDims2 = {
	        bottom: graphEditorOpen ? 0 : 0
	      };
	      return {
	        leftDims: leftDims2,
	        rightDims: rightDims2,
	        graphEditorDims: graphEditorDims2,
	        dopeSheetDims: dopeSheetDims2,
	        horizontalScrollbarDims: horizontalScrollbarDims2
	      };
	    }, [panelDims, graphEditorState, graphEditorAvailable]);
	    const graphEditorVerticalSpace = import_dataverse38.prism.memo("graphEditorVerticalSpace", () => {
	      const space = graphEditorDims.height - graphEditorDims.padding.top - graphEditorDims.padding.bottom;
	      return {
	        space,
	        fromExtremumSpace(ex) {
	          return ex * space;
	        },
	        toExtremumSpace(s2) {
	          return s2 / space;
	        }
	      };
	    }, [graphEditorDims]);
	    const [isSeeking, setIsSeeking] = import_dataverse38.prism.state("isSeeking", false);
	    const seeker = {
	      isSeeking,
	      setIsSeeking
	    };
	    const unitSpace = {};
	    const clippedSpaceRange = (_a = (0, import_dataverse38.val)(ahistoricStateP.sequence.clippedSpaceRange)) != null ? _a : initialClippedSpaceRange;
	    const scaledSpace = import_dataverse38.prism.memo("scaledSpace", () => {
	      const unitsShownInClippedSpace = clippedSpaceRange.end - clippedSpaceRange.start;
	      const pixelsShownInClippedSpace = rightDims.width;
	      const unitToPixelRatio = unitsShownInClippedSpace / pixelsShownInClippedSpace;
	      const pixelToUnitRatio = pixelsShownInClippedSpace / unitsShownInClippedSpace;
	      return {
	        fromUnitSpace(u2) {
	          return u2 * pixelToUnitRatio;
	        },
	        toUnitSpace(s2) {
	          return s2 * unitToPixelRatio;
	        },
	        leftPadding: 10
	      };
	    }, [clippedSpaceRange, rightDims.width]);
	    const setClippedSpaceRange = import_dataverse38.prism.memo("setClippedSpaceRange", () => {
	      return function setClippedSpaceRange2(_range) {
	        studio3.transaction(({ stateEditors: stateEditors2 }) => {
	          const range = __spreadValues({}, _range);
	          if (range.end <= range.start) {
	            range.end = range.start + 1;
	          }
	          if (range.start < 0) {
	            const length = range.end - range.start;
	            range.start = 0;
	            range.end = length;
	          }
	          stateEditors2.studio.ahistoric.projects.stateByProjectId.stateBySheetId.sequence.clippedSpaceRange.set(__spreadProps(__spreadValues({}, sheet.address), { range }));
	        });
	      };
	    }, []);
	    const clippedSpace = import_dataverse38.prism.memo("clippedSpace", () => {
	      return {
	        range: clippedSpaceRange,
	        width: rightDims.width,
	        fromUnitSpace(u2) {
	          return scaledSpace.fromUnitSpace(u2 - clippedSpaceRange.start) + scaledSpace.leftPadding;
	        },
	        toUnitSpace(c2) {
	          return scaledSpace.toUnitSpace(c2 - scaledSpace.leftPadding) + clippedSpaceRange.start;
	        },
	        setRange: setClippedSpaceRange
	      };
	    }, [clippedSpaceRange, rightDims.width, scaledSpace, setClippedSpaceRange]);
	    const selectionAtom = import_dataverse38.prism.memo("selection.current", () => {
	      return new import_dataverse38.Atom({});
	    }, []);
	    const finalAtom = valToAtom("finalAtom", {
	      sheet,
	      tree,
	      panelDims,
	      leftDims,
	      rightDims,
	      dopeSheetDims,
	      horizontalScrollbarDims,
	      seeker,
	      unitSpace,
	      scaledSpace,
	      clippedSpace,
	      graphEditorDims,
	      graphEditorVerticalSpace,
	      selectionAtom
	    });
	    return finalAtom.pointer;
	  });
	}

	// studio/src/panels/SequenceEditorPanel/RightOverlay/RightOverlay.tsx
	var import_dataverse44 = __toModule(dist$1);
	var import_react160 = __toModule(react.exports);
	var import_styled_components74 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/LengthIndicator/LengthIndicator.tsx
	var import_dataverse40 = __toModule(dist$1);
	var import_react151 = __toModule(react.exports);
	var import_styled_components69 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/RightOverlay/TopStrip.tsx
	var import_react147 = __toModule(react.exports);
	var import_styled_components67 = __toModule(require$$3);

	// studio/src/panels/SequenceEditorPanel/FrameGrid/StampsGrid.tsx
	var import_dataverse39 = __toModule(dist$1);
	var import_react145 = __toModule(react.exports);
	var import_styled_components66 = __toModule(require$$3);
	var Container48 = import_styled_components66.default.div`
  position: absolute;
  top: 0;
  left: 0;
  height: 100%;
  pointer-events: none;
`;
	var stampsGridTheme = {
	  fullUnitStampColor: `#6a6a6a`,
	  stampFontSize: "10px",
	  get subUnitStampColor() {
	    return curriedDarken(0.2, stampsGridTheme.fullUnitStampColor);
	  }
	};
	var TheStamps = import_styled_components66.default.div`
  position: absolute;
  top: 0;
  height: 100%;
  left: 0;
  overflow: hidden;
  /* z-index: 2; */
  will-change: transform;
  pointer-events: none;
`;
	var FullSecondStampsContainer = import_styled_components66.default.div`
  position: absolute;
  top: 0;
  left: 0;

  & > span {
    position: absolute;
    display: block;
    top: 9px;
    left: -10px;
    color: ${stampsGridTheme.fullUnitStampColor};
    text-align: center;
    font-size: ${stampsGridTheme.stampFontSize};
    width: 20px;

    &.full-unit {
      color: ${stampsGridTheme.fullUnitStampColor};
    }

    &.sub-unit {
      color: ${stampsGridTheme.subUnitStampColor};
    }
  }

  pointer-events: none;
`;
	var StampsGrid = ({ layoutP, width }) => {
	  const containerRef = (0, import_react145.useRef)(null);
	  const [fullSecondStampsContainer, fullSecondStampsContainerRef] = (0, import_react145.useState)(null);
	  (0, import_react145.useLayoutEffect)(() => {
	    if (!fullSecondStampsContainer)
	      return;
	    return (0, import_dataverse39.prism)(() => {
	      const sequence = (0, import_dataverse39.val)(layoutP.sheet).getSequence();
	      return {
	        fullSecondStampsContainer,
	        clippedSpaceRange: (0, import_dataverse39.val)(layoutP.clippedSpace.range),
	        clippedSpaceWidth: (0, import_dataverse39.val)(layoutP.clippedSpace.width),
	        unitSpaceToClippedSpace: (0, import_dataverse39.val)(layoutP.clippedSpace.fromUnitSpace),
	        leftPadding: (0, import_dataverse39.val)(layoutP.scaledSpace.leftPadding),
	        fps: sequence.subUnitsPerUnit,
	        sequencePositionFormatter: sequence.positionFormatter,
	        snapToGrid: (n2) => sequence.closestGridPosition(n2)
	      };
	    }).tapImmediate(studioTicker_default, drawStamps);
	  }, [fullSecondStampsContainer, width, layoutP]);
	  return /* @__PURE__ */ import_react145.default.createElement(Container48, {
	    ref: containerRef,
	    style: { width: width + "px" }
	  }, /* @__PURE__ */ import_react145.default.createElement(TheStamps, {
	    style: { width: width + "px" }
	  }, /* @__PURE__ */ import_react145.default.createElement(FullSecondStampsContainer, {
	    ref: fullSecondStampsContainerRef
	  })));
	};
	var StampsGrid_default = StampsGrid;
	function drawStamps(opts) {
	  const {
	    fullSecondStampsContainer,
	    sequencePositionFormatter,
	    snapToGrid,
	    unitSpaceToClippedSpace
	  } = opts;
	  let innerHTML = "";
	  createGrid(opts, (_posInUnitSpace, isFullUnit) => {
	    const posInUnitSpace = snapToGrid(_posInUnitSpace);
	    const posInClippedSpace = unitSpaceToClippedSpace(posInUnitSpace);
	    if (isFullUnit) {
	      innerHTML += createStampClass(sequencePositionFormatter.formatFullUnitForGrid(posInUnitSpace), posInClippedSpace, "full-unit");
	    } else {
	      innerHTML += createStampClass(sequencePositionFormatter.formatSubUnitForGrid(posInUnitSpace), posInClippedSpace, "sub-unit");
	    }
	  });
	  fullSecondStampsContainer.innerHTML = innerHTML;
	}
	function createStampClass(pos, x2, type) {
	  return `<span class="${type}" style="transform: translate3d(${x2.toFixed(1)}px, -50%, 0);">${pos}</span>`;
	}

	// studio/src/panels/SequenceEditorPanel/RightOverlay/TopStrip.tsx
	var topStripHeight = 20;
	var topStripTheme = {
	  backgroundColor: `#1f2120eb`,
	  borderColor: `#1c1e21`
	};
	var Container49 = (0, import_styled_components67.default)(PanelDragZone_default)`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  height: ${topStripHeight}px;
  box-sizing: border-box;
  background: ${topStripTheme.backgroundColor};
  border-bottom: 1px solid ${topStripTheme.borderColor};
  ${pointerEventsAutoInNormalMode};
`;
	var TopStrip = ({
	  layoutP
	}) => {
	  const width = useVal(layoutP.rightDims.width);
	  return /* @__PURE__ */ import_react147.default.createElement(Container49, __spreadValues({}, { [attributeNameThatLocksFramestamp]: "hide" }), /* @__PURE__ */ import_react147.default.createElement(StampsGrid_default, {
	    layoutP,
	    width,
	    height: topStripHeight
	  }));
	};
	var TopStrip_default = TopStrip;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/LengthIndicator/LengthEditorPopover.tsx
	var import_react148 = __toModule(react.exports);
	var import_styled_components68 = __toModule(require$$3);
	var greaterThanZero = (v2) => isFinite(v2) && v2 > 0;
	var Container50 = import_styled_components68.default.div`
  display: flex;
  gap: 8px;
  padding: 4px 8px;
  height: 28px;
  align-items: center;
`;
	var Label3 = import_styled_components68.default.div`
  ${propNameText};
  white-space: nowrap;
`;
	var nudge = ({ deltaX }) => deltaX * 0.25;
	var LengthEditorPopover = ({ layoutP, onRequestClose }) => {
	  const sheet = useVal(layoutP.sheet);
	  const fns = (0, import_react148.useMemo)(() => {
	    let tempTransaction;
	    return {
	      temporarilySetValue(newLength) {
	        if (tempTransaction) {
	          tempTransaction.discard();
	          tempTransaction = void 0;
	        }
	        tempTransaction = getStudio().tempTransaction(({ stateEditors: stateEditors2 }) => {
	          stateEditors2.coreByProject.historic.sheetsById.sequence.setLength(__spreadProps(__spreadValues({}, sheet.address), {
	            length: newLength
	          }));
	        });
	      },
	      discardTemporaryValue() {
	        if (tempTransaction) {
	          tempTransaction.discard();
	          tempTransaction = void 0;
	        }
	      },
	      permenantlySetValue(newLength) {
	        if (tempTransaction) {
	          tempTransaction.discard();
	          tempTransaction = void 0;
	        }
	        getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	          stateEditors2.coreByProject.historic.sheetsById.sequence.setLength(__spreadProps(__spreadValues({}, sheet.address), {
	            length: newLength
	          }));
	        });
	      }
	    };
	  }, [layoutP, sheet]);
	  const inputRef = (0, import_react148.useRef)(null);
	  (0, import_react148.useLayoutEffect)(() => {
	    inputRef.current.focus();
	  }, []);
	  return usePrism(() => {
	    const sequence = sheet.getSequence();
	    const sequenceLength = sequence.length;
	    return /* @__PURE__ */ import_react148.default.createElement(Container50, null, /* @__PURE__ */ import_react148.default.createElement(Label3, null, "Sequence length"), /* @__PURE__ */ import_react148.default.createElement(BasicNumberInput_default, __spreadProps(__spreadValues({
	      value: sequenceLength
	    }, fns), {
	      isValid: greaterThanZero,
	      inputRef,
	      onBlur: onRequestClose,
	      nudge
	    })));
	  }, [sheet, fns, inputRef]);
	};
	var LengthEditorPopover_default = LengthEditorPopover;

	// studio/src/panels/SequenceEditorPanel/DopeSheet/Right/LengthIndicator/LengthIndicator.tsx
	var coverWidth = 1e3;
	var colors = {
	  stripNormal: `#0000006c`,
	  stripActive: `#000000`
	};
	var Strip = import_styled_components69.default.div`
  position: absolute;
  top: 0;
  left: 0;
  width: 4px;
  z-index: ${() => zIndexes.lengthIndicatorStrip};
  pointer-events: none;

  &:after {
    display: block;
    content: ' ';
    position: absolute;
    /* top: ${topStripHeight}px; */
    top: 0;
    bottom: 0;
    left: -1px;
    width: 1px;
    background-color: ${colors.stripNormal};
  }

  &:hover:after,
  &.dragging:after {
    background-color: ${colors.stripActive};
  }
`;
	var ThumbContainer = import_styled_components69.default.div`
  position: absolute;
  top: ${topStripHeight - 15}px;
  width: 100px;
  left: -50px;
  pointer-events: none;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  z-index: 1;
`;
	var Tooltip = import_styled_components69.default.div`
  margin-top: 8px;
  font-size: 10px;
  white-space: nowrap;
  padding: 2px 8px;
  border-radius: 2px;
  ${pointerEventsAutoInNormalMode};
  cursor: ew-resize;
  color: #464646;
  background-color: #0000004d;
  display: none;

  ${Strip}:hover &, ${Strip}.dragging & {
    display: block;
    color: white;
    background-color: ${colors.stripActive};
  }
`;
	var Tumb = import_styled_components69.default.div`
  font-size: 10px;
  white-space: nowrap;
  padding: 1px 2px;
  border-radius: 2px;
  ${pointerEventsAutoInNormalMode};
  justify-content: center;
  align-items: center;
  cursor: ew-resize;
  color: #5d5d5d;
  background-color: #191919;

  ${Strip}:hover &, ${Strip}.dragging & {
    color: white;
    background-color: ${colors.stripActive};

    & > svg:first-child {
      margin-right: -1px;
    }
  }

  & > svg:first-child {
    margin-right: -4px;
  }
`;
	var Cover = import_styled_components69.default.div`
  position: absolute;
  top: 0;
  left: 0;
  background-color: rgb(23 23 23 / 43%);
  width: ${coverWidth}px;
  z-index: ${() => zIndexes.lengthIndicatorCover};
  transform-origin: left top;

  ${Strip}.dragging ~ &, ${Strip}:hover ~ & {
    background-color: rgb(23 23 23 / 60%);
  }
`;
	var LengthIndicator = ({ layoutP }) => {
	  const [nodeRef, node] = useRefAndState(null);
	  const [isDraggingD] = useDragBulge(node, { layoutP });
	  const [popoverNode, openPopover, closePopover, isPopoverOpen] = usePopover({}, () => {
	    return /* @__PURE__ */ import_react151.default.createElement(BasicPopover_default, null, /* @__PURE__ */ import_react151.default.createElement(LengthEditorPopover_default, {
	      layoutP,
	      onRequestClose: closePopover
	    }));
	  });
	  return usePrism(() => {
	    const sheet = (0, import_dataverse40.val)(layoutP.sheet);
	    const height2 = (0, import_dataverse40.val)(layoutP.rightDims.height);
	    const sequence = sheet.getSequence();
	    const sequenceLength = sequence.length;
	    const startInUnitSpace = sequenceLength;
	    let startX = (0, import_dataverse40.val)(layoutP.clippedSpace.fromUnitSpace)(startInUnitSpace);
	    let endX = (0, import_dataverse40.val)(layoutP.clippedSpace.width);
	    let scaleX, translateX;
	    if (startX > endX) {
	      translateX = 0;
	      scaleX = 0;
	    } else {
	      if (startX < 0) {
	        startX = 0;
	      }
	      translateX = startX;
	      scaleX = (endX - startX) / coverWidth;
	    }
	    return /* @__PURE__ */ import_react151.default.createElement(import_react151.default.Fragment, null, popoverNode, /* @__PURE__ */ import_react151.default.createElement(Strip, {
	      style: {
	        height: height2 + "px",
	        transform: `translateX(${translateX === 0 ? -1e3 : translateX}px)`
	      },
	      className: (0, import_dataverse40.val)(isDraggingD) ? "dragging" : ""
	    }, /* @__PURE__ */ import_react151.default.createElement(ThumbContainer, null, /* @__PURE__ */ import_react151.default.createElement(Tumb, __spreadValues({
	      ref: nodeRef,
	      onClick: (e) => {
	        openPopover(e, node);
	      }
	    }, { [attributeNameThatLocksFramestamp]: "hide" }), /* @__PURE__ */ import_react151.default.createElement(GoChevronLeft, null), /* @__PURE__ */ import_react151.default.createElement(GoChevronRight, null)), /* @__PURE__ */ import_react151.default.createElement(Tooltip, null, "Sequence length:", " ", sequence.positionFormatter.formatBasic(sequenceLength)))), /* @__PURE__ */ import_react151.default.createElement(Cover, {
	      title: "Length",
	      style: {
	        height: height2 + "px",
	        transform: `translateX(${translateX}px) scale(${scaleX}, 1)`
	      }
	    }));
	  }, [layoutP, nodeRef, isDraggingD, popoverNode]);
	};
	function useDragBulge(node, props) {
	  const propsRef = (0, import_react151.useRef)(props);
	  propsRef.current = props;
	  const [isDragging, setIsDragging] = (0, import_react151.useState)(false);
	  useLockFrameStampPosition(isDragging, -1);
	  const gestureHandlers = (0, import_react151.useMemo)(() => {
	    let toUnitSpace;
	    let tempTransaction;
	    let propsAtStartOfDrag;
	    let sheet;
	    let initialLength;
	    return {
	      lockCursorTo: "ew-resize",
	      onDragStart(event) {
	        setIsDragging(true);
	        propsAtStartOfDrag = propsRef.current;
	        sheet = (0, import_dataverse40.val)(propsRef.current.layoutP.sheet);
	        initialLength = sheet.getSequence().length;
	        toUnitSpace = (0, import_dataverse40.val)(propsAtStartOfDrag.layoutP.scaledSpace.toUnitSpace);
	      },
	      onDrag(dx, dy, event) {
	        const delta = toUnitSpace(dx);
	        if (tempTransaction) {
	          tempTransaction.discard();
	          tempTransaction = void 0;
	        }
	        tempTransaction = getStudio().tempTransaction(({ stateEditors: stateEditors2 }) => {
	          stateEditors2.coreByProject.historic.sheetsById.sequence.setLength(__spreadProps(__spreadValues({}, sheet.address), {
	            length: initialLength + delta
	          }));
	        });
	      },
	      onDragEnd(dragHappened) {
	        setIsDragging(false);
	        if (dragHappened) {
	          if (tempTransaction) {
	            tempTransaction.commit();
	          }
	        } else {
	          if (tempTransaction) {
	            tempTransaction.discard();
	          }
	        }
	        tempTransaction = void 0;
	      }
	    };
	  }, []);
	  useDrag(node, gestureHandlers);
	  return [isDragging];
	}
	var LengthIndicator_default = LengthIndicator;

	// studio/src/panels/SequenceEditorPanel/RightOverlay/FrameStamp.tsx
	var import_dataverse41 = __toModule(dist$1);
	var import_react153 = __toModule(react.exports);
	var import_styled_components70 = __toModule(require$$3);
	var Label4 = import_styled_components70.default.div`
  position: absolute;
  top: 16px;
  font-size: ${stampsGridTheme.stampFontSize};
  color: ${stampsGridTheme.fullUnitStampColor};
  text-align: center;
  transform: translateX(-50%);
  background: ${topStripTheme.backgroundColor};
  padding: 1px 8px;
  font-variant-numeric: tabular-nums;
  pointer-events: none;
  z-index: ${() => zIndexes.currentFrameStamp};
`;
	var Line2 = import_styled_components70.default.div`
  position: absolute;
  top: 5px;
  left: -0px;
  bottom: 0;
  width: 0.5px;
  background: rgba(100, 100, 100, 0.2);
  pointer-events: none;
`;
	var FrameStamp = import_react153.default.memo(({ layoutP }) => {
	  const [posInUnitSpace, posType] = useVal(useFrameStampPositionD());
	  const unitSpaceToClippedSpace = useVal(layoutP.clippedSpace.fromUnitSpace);
	  const { sequence, formatter, clippedSpaceWidth } = usePrism(() => {
	    const sequence2 = (0, import_dataverse41.val)(layoutP.sheet).getSequence();
	    const clippedSpaceWidth2 = (0, import_dataverse41.val)(layoutP.clippedSpace.width);
	    return { sequence: sequence2, formatter: sequence2.positionFormatter, clippedSpaceWidth: clippedSpaceWidth2 };
	  }, [layoutP]);
	  if (posInUnitSpace == -1) {
	    return /* @__PURE__ */ import_react153.default.createElement(import_react153.default.Fragment, null);
	  }
	  const snappedPosInUnitSpace = posType === FrameStampPositionType.free ? sequence.closestGridPosition(posInUnitSpace) : posInUnitSpace;
	  const posInClippedSpace = unitSpaceToClippedSpace(snappedPosInUnitSpace);
	  const isVisible2 = posInClippedSpace >= 0 && posInClippedSpace <= clippedSpaceWidth;
	  return /* @__PURE__ */ import_react153.default.createElement(import_react153.default.Fragment, null, /* @__PURE__ */ import_react153.default.createElement(Label4, {
	    style: {
	      opacity: isVisible2 ? 1 : 0,
	      transform: `translate3d(calc(${posInClippedSpace}px - 50%), 0, 0)`
	    }
	  }, formatter.formatForPlayhead(snappedPosInUnitSpace)), /* @__PURE__ */ import_react153.default.createElement(Line2, {
	    posType,
	    style: {
	      opacity: isVisible2 ? 1 : 0,
	      transform: `translate3d(${posInClippedSpace}px, 0, 0)`
	    }
	  }));
	});
	var FrameStamp_default = FrameStamp;

	// studio/src/panels/SequenceEditorPanel/RightOverlay/HorizontalScrollbar.tsx
	var import_dataverse42 = __toModule(dist$1);
	var import_react155 = __toModule(react.exports);
	var import_styled_components71 = __toModule(require$$3);
	var Container51 = import_styled_components71.default.div`
  --threadHeight: 6px;
  --bg-inactive: #32353b;
  --bg-active: #5b5c5d;
  position: absolute;
  height: 0;
  width: 100%;
  left: 12px;
  /* bottom: 8px; */
  ${pointerEventsAutoInNormalMode};
  z-index: ${() => zIndexes.horizontalScrollbar};
`;
	var TimeThread = import_styled_components71.default.div`
  position: relative;
  top: 0;
  left: 0;
  width: 100%;
  height: var(--threadHeight);
`;
	var RangeBar = import_styled_components71.default.div`
  position: absolute;
  height: 5px;
  background: var(--bg-inactive);
  cursor: ew-resize;
  z-index: 2;

  &:hover,
  &:active {
    background: var(--bg-active);
  }

  &:after {
    ${position("absolute", "-4px")};
    display: block;
    content: ' ';
  }
`;
	var RangeHandle = import_styled_components71.default.div`
  position: absolute;
  height: 5px;
  width: 7px;
  left: 0;
  z-index: 2;
  top: 0;
  bottom: 0;
  display: block;

  &:hover:before {
    background: var(--bg-active);
  }

  &:before {
    ${position("absolute", "0")};
    display: block;
    content: ' ';
    background: var(--bg-inactive);
    border-radius: 0 2px 2px 0;
  }

  &:after {
    ${position("absolute", "-4px")};
    display: block;
    content: ' ';
  }
`;
	var RangeStartHandle = (0, import_styled_components71.default)(RangeHandle)`
  left: calc(-1 * 7px);
  cursor: w-resize;
  &:before {
    transform: scaleX(-1);
  }
`;
	var RangeEndHandle = (0, import_styled_components71.default)(RangeHandle)`
  cursor: e-resize;
  left: 0px;
`;
	var Tooltip2 = import_styled_components71.default.div`
  display: ${(props) => props.active ? "block" : "none"};
  position: absolute;
  top: -20px;
  left: 4px;
  padding: 0 4px;
  transform: translateX(-50%);
  background: #131d1f;
  border-radius: 4px;
  color: #fff;
  font-size: 10px;
  line-height: 18px;
  text-align: center;

  ${RangeStartHandle}:hover &,
  ${RangeEndHandle}:hover &,
  ${RangeBar}:hover ~ ${RangeStartHandle} &,
  ${RangeBar}:hover ~ ${RangeEndHandle} & {
    display: block;
  }
`;
	var HorizontalScrollbar = ({ layoutP }) => {
	  const unitPosToHumanReadablePos = (0, import_react155.useCallback)((n2) => n2.toFixed(2), []);
	  const relevantValuesD = (0, import_react155.useMemo)(() => (0, import_dataverse42.prism)(() => {
	    const rightWidth = (0, import_dataverse42.val)(layoutP.rightDims.width) - 25;
	    const clippedSpaceRange2 = (0, import_dataverse42.val)(layoutP.clippedSpace.range);
	    const sequenceLength = (0, import_dataverse42.val)(layoutP.sheet).getSequence().length;
	    const assumedLengthOfSequence = Math.max(clippedSpaceRange2.end, sequenceLength);
	    const rangeStartX2 = clippedSpaceRange2.start / assumedLengthOfSequence * rightWidth;
	    const rangeEndX2 = clippedSpaceRange2.end / assumedLengthOfSequence * rightWidth;
	    return {
	      rightWidth,
	      clippedSpaceRange: clippedSpaceRange2,
	      sequenceLength,
	      assumedLengthOfSequence,
	      rangeStartX: rangeStartX2,
	      rangeEndX: rangeEndX2,
	      bottom: (0, import_dataverse42.val)(layoutP.horizontalScrollbarDims.bottom)
	    };
	  }), [layoutP]);
	  const { rangeStartX, rangeEndX, clippedSpaceRange, bottom } = useVal(relevantValuesD);
	  const [beingDragged, setBeingDragged] = (0, import_react155.useState)("nothing");
	  const handles = (0, import_react155.useMemo)(() => {
	    let valuesBeforeDrag = (0, import_dataverse42.val)(relevantValuesD);
	    let noteValuesBeforeDrag = () => {
	      valuesBeforeDrag = (0, import_dataverse42.val)(relevantValuesD);
	    };
	    const deltaXToDeltaPos = (dx) => {
	      const asAFractionOfRightWidth = dx / valuesBeforeDrag.rightWidth;
	      return asAFractionOfRightWidth * valuesBeforeDrag.assumedLengthOfSequence;
	    };
	    const self2 = {
	      onDragStart() {
	        noteValuesBeforeDrag();
	      },
	      onDragEnd() {
	        setBeingDragged("nothing");
	      },
	      dragRange: (dx) => {
	        setBeingDragged("both");
	        const deltaPosInUnitSpace = deltaXToDeltaPos(dx);
	        const newRange = mapValues_default(valuesBeforeDrag.clippedSpaceRange, (p2) => p2 + deltaPosInUnitSpace);
	        (0, import_dataverse42.val)(layoutP.clippedSpace.setRange)(newRange);
	      },
	      dragRangeStart: (dx) => {
	        setBeingDragged("start");
	        const deltaPosInUnitSpace = deltaXToDeltaPos(dx);
	        const newRange = {
	          start: valuesBeforeDrag.clippedSpaceRange.start + deltaPosInUnitSpace,
	          end: valuesBeforeDrag.clippedSpaceRange.end
	        };
	        if (newRange.start > newRange.end - 1) {
	          newRange.start = newRange.end - 1;
	        }
	        if (newRange.start <= 0) {
	          newRange.start = 0;
	        }
	        (0, import_dataverse42.val)(layoutP.clippedSpace.setRange)(newRange);
	      },
	      dragRangeEnd: (dx) => {
	        setBeingDragged("end");
	        const deltaPosInUnitSpace = deltaXToDeltaPos(dx);
	        const newRange = {
	          start: valuesBeforeDrag.clippedSpaceRange.start,
	          end: valuesBeforeDrag.clippedSpaceRange.end + deltaPosInUnitSpace
	        };
	        if (newRange.end < newRange.start + 1) {
	          newRange.end = newRange.start + 1;
	        }
	        if (newRange.end >= valuesBeforeDrag.assumedLengthOfSequence) {
	          newRange.end = valuesBeforeDrag.assumedLengthOfSequence;
	        }
	        (0, import_dataverse42.val)(layoutP.clippedSpace.setRange)(newRange);
	      }
	    };
	    return self2;
	  }, [layoutP, relevantValuesD]);
	  return /* @__PURE__ */ import_react155.default.createElement(Container51, __spreadValues({
	    style: { bottom: bottom + 8 + "px" }
	  }, { [attributeNameThatLocksFramestamp]: "hide" }), /* @__PURE__ */ import_react155.default.createElement(TimeThread, null, /* @__PURE__ */ import_react155.default.createElement(DraggableArea_default, {
	    onDragStart: handles.onDragStart,
	    onDragEnd: handles.onDragEnd,
	    onDrag: handles.dragRange,
	    lockCursorTo: "ew-resize"
	  }, /* @__PURE__ */ import_react155.default.createElement(RangeBar, {
	    style: {
	      width: `${rangeEndX - rangeStartX}px`,
	      transform: `translate3d(${rangeStartX}px, 0, 0)`
	    }
	  })), /* @__PURE__ */ import_react155.default.createElement(DraggableArea_default, {
	    onDragStart: handles.onDragStart,
	    onDrag: handles.dragRangeStart,
	    lockCursorTo: "w-resize"
	  }, /* @__PURE__ */ import_react155.default.createElement(RangeStartHandle, {
	    style: { transform: `translate3d(${rangeStartX}px, 0, 0)` }
	  }, /* @__PURE__ */ import_react155.default.createElement(Tooltip2, {
	    active: beingDragged === "both" || beingDragged === "start"
	  }, unitPosToHumanReadablePos(clippedSpaceRange.start)))), /* @__PURE__ */ import_react155.default.createElement(DraggableArea_default, {
	    onDragStart: handles.onDragStart,
	    onDrag: handles.dragRangeEnd,
	    lockCursorTo: "e-resize"
	  }, /* @__PURE__ */ import_react155.default.createElement(RangeEndHandle, {
	    style: { transform: `translate3d(${rangeEndX}px, 0, 0)` }
	  }, /* @__PURE__ */ import_react155.default.createElement(Tooltip2, {
	    active: beingDragged === "both" || beingDragged === "end"
	  }, unitPosToHumanReadablePos(clippedSpaceRange.end))))));
	};
	var HorizontalScrollbar_default = HorizontalScrollbar;

	// studio/src/uiComponents/RoomToClick.tsx
	var import_react156 = __toModule(react.exports);
	var import_styled_components72 = __toModule(require$$3);
	var Container52 = import_styled_components72.default.div`
  position: absolute;
  inset: ${(props) => props.room * -1}px;
`;
	var RoomToClick = (props) => {
	  return /* @__PURE__ */ import_react156.default.createElement(Container52, {
	    room: props.room
	  });
	};
	var RoomToClick_default = RoomToClick;

	// studio/src/panels/SequenceEditorPanel/RightOverlay/Playhead.tsx
	var import_dataverse43 = __toModule(dist$1);
	var import_react158 = __toModule(react.exports);
	var import_styled_components73 = __toModule(require$$3);
	var Container53 = import_styled_components73.default.div`
  --thumbColor: #00e0ff;
  position: absolute;
  top: 0;
  left: 0;
  width: 5px;
  height: 100%;
  z-index: ${() => zIndexes.playhead};
  pointer-events: none;

  display: ${(props) => props.isVisible ? "block" : "none"};
`;
	var Rod = import_styled_components73.default.div`
  position: absolute;
  top: 8px;
  width: 0;
  height: calc(100% - 8px);
  border-left: 1px solid #27e0fd;
  z-index: 10;

  #pointer-root.draggingPositionInSequenceEditor &:not(.seeking) {
    pointer-events: auto;

    &:after {
      position: absolute;
      inset: -8px;
      display: block;
      content: ' ';
    }
  }
`;
	var Thumb = import_styled_components73.default.div`
  background-color: var(--thumbColor);
  position: absolute;
  width: 5px;
  height: 13px;
  top: -4px;
  left: -2px;
  z-index: 11;
  cursor: ew-resize;
  ${pointerEventsAutoInNormalMode};

  #pointer-root.draggingPositionInSequenceEditor &:not(.seeking) {
    pointer-events: auto;
  }

  &:before {
    position: absolute;
    display: block;
    content: ' ';
    left: -2px;
    width: 0;
    height: 0;
    border-bottom: 4px solid #1f2b2b;
    border-left: 2px solid transparent;
  }

  &:after {
    position: absolute;
    display: block;
    content: ' ';
    right: -2px;
    width: 0;
    height: 0;
    border-bottom: 4px solid #1f2b2b;
    border-right: 2px solid transparent;
  }
`;
	var Squinch = import_styled_components73.default.div`
  position: absolute;
  left: 1px;
  right: 1px;
  top: 13px;
  border-top: 3px solid var(--thumbColor);
  border-right: 1px solid transparent;
  border-left: 1px solid transparent;
  pointer-events: none;

  &:before {
    position: absolute;
    display: block;
    content: ' ';
    top: -4px;
    left: -2px;
    height: 8px;
    width: 2px;
    background: none;
    border-radius: 0 100% 0 0;
    border-top: 1px solid var(--thumbColor);
    border-right: 1px solid var(--thumbColor);
  }

  &:after {
    position: absolute;
    display: block;
    content: ' ';
    top: -4px;
    right: -2px;
    height: 8px;
    width: 2px;
    background: none;
    border-radius: 100% 0 0 0;
    border-top: 1px solid var(--thumbColor);
    border-left: 1px solid var(--thumbColor);
  }
`;
	var Tooltip3 = import_styled_components73.default.div`
  display: none;
  position: absolute;
  top: -20px;
  left: 4px;
  padding: 0 2px;
  transform: translateX(-50%);
  background: #1a1a1a;
  border-radius: 4px;
  color: #fff;
  font-size: 10px;
  line-height: 18px;
  text-align: center;
  ${Thumb}:hover &, ${Container53}.seeking & {
    display: block;
  }
`;
	var Playhead = ({
	  layoutP
	}) => {
	  const [thumbRef, thumbNode] = useRefAndState(null);
	  const gestureHandlers = (0, import_react158.useMemo)(() => {
	    const setIsSeeking = (0, import_dataverse43.val)(layoutP.seeker.setIsSeeking);
	    let posBeforeSeek = 0;
	    let sequence;
	    let scaledSpaceToUnitSpace;
	    return {
	      onDragStart() {
	        sequence = (0, import_dataverse43.val)(layoutP.sheet).getSequence();
	        posBeforeSeek = sequence.position;
	        scaledSpaceToUnitSpace = (0, import_dataverse43.val)(layoutP.scaledSpace.toUnitSpace);
	        setIsSeeking(true);
	      },
	      onDrag(dx, _2, event) {
	        const deltaPos = scaledSpaceToUnitSpace(dx);
	        const unsnappedPos = clamp_default(posBeforeSeek + deltaPos, 0, sequence.length);
	        let newPosition = unsnappedPos;
	        const snapTarget = event.composedPath().find((el) => el instanceof Element && el !== thumbNode && el.hasAttribute("data-pos"));
	        if (snapTarget) {
	          const snapPos = parseFloat(snapTarget.getAttribute("data-pos"));
	          if (isFinite(snapPos)) {
	            newPosition = snapPos;
	          }
	        }
	        sequence.position = newPosition;
	      },
	      onDragEnd() {
	        setIsSeeking(false);
	      },
	      lockCursorTo: "ew-resize"
	    };
	  }, []);
	  useDrag(thumbNode, gestureHandlers);
	  useLockFrameStampPosition(useVal(layoutP.seeker.isSeeking), -1);
	  return usePrism(() => {
	    const isSeeking = (0, import_dataverse43.val)(layoutP.seeker.isSeeking);
	    const sequence = (0, import_dataverse43.val)(layoutP.sheet).getSequence();
	    const posInUnitSpace = sequence.positionDerivation.getValue();
	    const posInClippedSpace = (0, import_dataverse43.val)(layoutP.clippedSpace.fromUnitSpace)(posInUnitSpace);
	    const isVisible2 = posInClippedSpace >= 0 && posInClippedSpace <= (0, import_dataverse43.val)(layoutP.clippedSpace.width);
	    return /* @__PURE__ */ import_react158.default.createElement(Container53, __spreadValues({
	      isVisible: isVisible2,
	      style: { transform: `translate3d(${posInClippedSpace}px, 0, 0)` },
	      className: isSeeking ? "seeking" : ""
	    }, { [attributeNameThatLocksFramestamp]: "hide" }), /* @__PURE__ */ import_react158.default.createElement(Thumb, {
	      ref: thumbRef,
	      "data-pos": posInUnitSpace.toFixed(3)
	    }, /* @__PURE__ */ import_react158.default.createElement(RoomToClick_default, {
	      room: 8
	    }), /* @__PURE__ */ import_react158.default.createElement(Squinch, null), /* @__PURE__ */ import_react158.default.createElement(Tooltip3, null, sequence.positionFormatter.formatForPlayhead(sequence.closestGridPosition(posInUnitSpace)))), /* @__PURE__ */ import_react158.default.createElement(Rod, {
	      "data-pos": posInUnitSpace.toFixed(3),
	      className: isSeeking ? "seeking" : ""
	    }));
	  }, [layoutP]);
	};
	var Playhead_default = Playhead;

	// studio/src/panels/SequenceEditorPanel/RightOverlay/RightOverlay.tsx
	var Container54 = import_styled_components74.default.div`
  position: absolute;
  top: 0;
  right: 0;
  bottom: 0;
  z-index: ${() => zIndexes.rightOverlay};
  overflow: visible;
  pointer-events: none;
`;
	var RightOverlay = ({ layoutP }) => {
	  return usePrism(() => {
	    const width = (0, import_dataverse44.val)(layoutP.rightDims.width);
	    return /* @__PURE__ */ import_react160.default.createElement(Container54, {
	      style: { width: width + "px" }
	    }, /* @__PURE__ */ import_react160.default.createElement(Playhead_default, {
	      layoutP
	    }), /* @__PURE__ */ import_react160.default.createElement(HorizontalScrollbar_default, {
	      layoutP
	    }), /* @__PURE__ */ import_react160.default.createElement(FrameStamp_default, {
	      layoutP
	    }), /* @__PURE__ */ import_react160.default.createElement(TopStrip_default, {
	      layoutP
	    }), /* @__PURE__ */ import_react160.default.createElement(LengthIndicator_default, {
	      layoutP
	    }));
	  }, [layoutP]);
	};
	var RightOverlay_default = RightOverlay;

	// studio/src/panels/SequenceEditorPanel/GraphEditorToggle.tsx
	var import_dataverse45 = __toModule(dist$1);
	var import_react162 = __toModule(react.exports);
	var import_styled_components75 = __toModule(require$$3);
	var Container55 = import_styled_components75.default.button`
  outline: none;
  background-color: #1c1d21;
  border: 1px solid #191919;
  border-radius: 2px;
  display: flex;
  bottom: 14px;
  right: 8px;
  z-index: 1;
  position: absolute;

  padding: 4px 8px;
  display: flex;
  color: #656d77;
  line-height: 20px;
  font-size: 10px;

  &:hover {
    color: white;
  }

  & > svg {
    transition: transform 0.3s;
    transform: rotateZ(0deg);
  }

  &:hover > svg {
    transform: rotateZ(-20deg);
  }

  &.open > svg {
    transform: rotateZ(-180deg);
  }

  &.open:hover > svg {
    transform: rotateZ(-160deg);
  }
`;
	var GraphEditorToggle = ({ layoutP }) => {
	  const isOpen = useVal(layoutP.graphEditorDims.isOpen);
	  const toggle = (0, import_react162.useCallback)(() => {
	    (0, import_dataverse45.val)(layoutP.sheet);
	    const isOpen2 = (0, import_dataverse45.val)(layoutP.graphEditorDims.isOpen);
	    getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	      stateEditors2.studio.historic.panels.sequenceEditor.graphEditor.setIsOpen({
	        isOpen: !isOpen2
	      });
	    });
	  }, [layoutP]);
	  return /* @__PURE__ */ import_react162.default.createElement(Container55, __spreadValues({
	    onClick: toggle,
	    title: "Toggle graph editor",
	    className: isOpen ? "open" : ""
	  }, { [attributeNameThatLocksFramestamp]: "hide" }), /* @__PURE__ */ import_react162.default.createElement(VscTriangleUp, null));
	};
	var GraphEditorToggle_default = GraphEditorToggle;

	// studio/src/panels/SequenceEditorPanel/SequenceEditorPanel.tsx
	var Container56 = (0, import_styled_components76.default)(PanelWrapper_default)`
  z-index: ${panelZIndexes.sequenceEditorPanel};
  box-shadow: 2px 2px 0 rgb(0 0 0 / 11%);
`;
	var LeftBackground = import_styled_components76.default.div`
  background-color: rgba(40, 43, 47, 0.99);
  position: absolute;
  left: 0;
  top: 0;
  bottom: 0;
  z-index: -1;
  pointer-events: none;
`;
	var zIndexes = (() => {
	  const s2 = {
	    rightBackground: 0,
	    scrollableArea: 0,
	    rightOverlay: 0,
	    lengthIndicatorCover: 0,
	    lengthIndicatorStrip: 0,
	    playhead: 0,
	    currentFrameStamp: 0,
	    horizontalScrollbar: 0
	  };
	  let i2 = -1;
	  for (const key of Object.keys(s2)) {
	    s2[key] = i2;
	    i2++;
	  }
	  return s2;
	})();
	var Header_Container = (0, import_styled_components76.default)(PanelDragZone_default)`
  position: absolute;
  left: 0;
  top: 0;
  z-index: 1;
`;
	var defaultPosition2 = {
	  edges: {
	    left: { from: "screenLeft", distance: 0.1 },
	    right: { from: "screenRight", distance: 0.2 },
	    top: { from: "screenBottom", distance: 0.4 },
	    bottom: { from: "screenBottom", distance: 0.01 }
	  }
	};
	var minDims2 = { width: 800, height: 200 };
	var SequenceEditorPanel = (props) => {
	  return /* @__PURE__ */ import_react164.default.createElement(BasePanel_default, {
	    panelId: "sequenceEditor",
	    defaultPosition: defaultPosition2,
	    minDims: minDims2
	  }, /* @__PURE__ */ import_react164.default.createElement(Content4, null));
	};
	var Content4 = () => {
	  const { dims: dims2 } = usePanel();
	  return usePrism(() => {
	    const panelSize = import_dataverse46.prism.memo("panelSize", () => {
	      const width = dims2.width;
	      const height2 = dims2.height;
	      return {
	        width,
	        height: height2,
	        widthWithoutBorder: width - 2,
	        heightWithoutBorder: height2 - 4,
	        screenX: dims2.left,
	        screenY: dims2.top
	      };
	    }, [dims2]);
	    const selectedSheets = uniq_default(getOutlineSelection().filter((s2) => isSheet(s2) || isSheetObject(s2)).map((s2) => isSheetObject(s2) ? s2.sheet : s2));
	    const selectedTemplates = uniq_default(selectedSheets.map((s2) => s2.template));
	    if (selectedTemplates.length !== 1)
	      return /* @__PURE__ */ import_react164.default.createElement(import_react164.default.Fragment, null);
	    const sheet = selectedSheets[0];
	    if (!sheet)
	      return /* @__PURE__ */ import_react164.default.createElement(import_react164.default.Fragment, null);
	    const panelSizeP = valToAtom("panelSizeP", panelSize).pointer;
	    const key = import_dataverse46.prism.memo("key", () => JSON.stringify(sheet.address), [sheet]);
	    const layoutP = import_dataverse46.prism.memo("layout", () => {
	      return sequenceEditorPanelLayout(sheet, panelSizeP);
	    }, [sheet, panelSizeP]).getValue();
	    if ((0, import_dataverse46.val)(layoutP.tree.children).length === 0)
	      return /* @__PURE__ */ import_react164.default.createElement(import_react164.default.Fragment, null);
	    const containerRef = import_dataverse46.prism.memo("containerRef", preventHorizontalWheelEvents, []);
	    const graphEditorAvailable = (0, import_dataverse46.val)(layoutP.graphEditorDims.isAvailable);
	    const graphEditorOpen = (0, import_dataverse46.val)(layoutP.graphEditorDims.isOpen);
	    return /* @__PURE__ */ import_react164.default.createElement(Container56, {
	      ref: containerRef
	    }, /* @__PURE__ */ import_react164.default.createElement(LeftBackground, {
	      style: { width: `${(0, import_dataverse46.val)(layoutP.leftDims.width)}px` }
	    }), /* @__PURE__ */ import_react164.default.createElement(FrameStampPositionProvider_default, {
	      layoutP
	    }, /* @__PURE__ */ import_react164.default.createElement(Header5, {
	      layoutP
	    }), /* @__PURE__ */ import_react164.default.createElement(DopeSheet_default, {
	      key: key + "-dopeSheet",
	      layoutP
	    }), graphEditorOpen && /* @__PURE__ */ import_react164.default.createElement(GraphEditor_default, {
	      key: key + "-graphEditor",
	      layoutP
	    }), graphEditorAvailable && /* @__PURE__ */ import_react164.default.createElement(GraphEditorToggle_default, {
	      layoutP
	    }), /* @__PURE__ */ import_react164.default.createElement(RightOverlay_default, {
	      layoutP
	    })));
	  }, [dims2]);
	};
	var Header5 = ({
	  layoutP
	}) => {
	  return usePrism(() => {
	    const sheet = (0, import_dataverse46.val)(layoutP.sheet);
	    return /* @__PURE__ */ import_react164.default.createElement(Header_Container, {
	      style: {
	        width: (0, import_dataverse46.val)(layoutP.leftDims.width)
	      }
	    }, /* @__PURE__ */ import_react164.default.createElement(TitleBar, null, /* @__PURE__ */ import_react164.default.createElement(TitleBar_Piece, null, sheet.address.sheetId, " "), /* @__PURE__ */ import_react164.default.createElement(TitleBar_Punctuation, null, ":", "\xA0"), /* @__PURE__ */ import_react164.default.createElement(TitleBar_Piece, null, sheet.address.sheetInstanceId, " "), /* @__PURE__ */ import_react164.default.createElement(TitleBar_Punctuation, null, "\xA0", ">", "\xA0"), /* @__PURE__ */ import_react164.default.createElement(TitleBar_Piece, null, "Sequence")));
	  }, [layoutP]);
	};
	var SequenceEditorPanel_default = SequenceEditorPanel;
	var preventHorizontalWheelEvents = () => {
	  let lastNode = null;
	  const listenerOptions = {
	    passive: false,
	    capture: false
	  };
	  const receiveWheelEvent = (event) => {
	    if (Math.abs(event.deltaY) < Math.abs(event.deltaX)) {
	      event.preventDefault();
	      event.stopPropagation();
	    }
	  };
	  return (node) => {
	    if (lastNode !== node && lastNode) {
	      lastNode.removeEventListener("wheel", receiveWheelEvent, listenerOptions);
	    }
	    lastNode = node;
	    if (node) {
	      node.addEventListener("wheel", receiveWheelEvent, listenerOptions);
	    }
	  };
	};

	// studio/src/UIRoot/PanelsRoot.tsx
	var PanelsRoot = () => {
	  const panes = useVal(getStudio().paneManager.allPanesD);
	  const paneEls = Object.entries(panes).map(([instanceId, paneInstance]) => {
	    return /* @__PURE__ */ import_react165.default.createElement(PaneWrapper_default, {
	      key: `pane-${instanceId}`,
	      paneInstance
	    });
	  });
	  return /* @__PURE__ */ import_react165.default.createElement(import_react165.default.Fragment, null, paneEls, /* @__PURE__ */ import_react165.default.createElement(OutlinePanel_default, null), /* @__PURE__ */ import_react165.default.createElement(DetailPanel_default, null), /* @__PURE__ */ import_react165.default.createElement(SequenceEditorPanel_default, null));
	};
	var PanelsRoot_default = PanelsRoot;

	// studio/src/UIRoot/ProvideTheme.tsx
	var import_react167 = __toModule(react.exports);
	var import_styled_components77 = __toModule(require$$3);
	var Container57 = import_styled_components77.default.div`
  --colors-panel-1: red;
`;
	var ProvideTheme = (props) => {
	  return /* @__PURE__ */ import_react167.default.createElement(Container57, null, props.children);
	};
	var ProvideTheme_default = ProvideTheme;

	// studio/src/toolbars/GlobalToolbar/GlobalToolbar.tsx
	var import_react169 = __toModule(react.exports);
	var import_styled_components78 = __toModule(require$$3);
	var Container58 = import_styled_components78.default.div`
  position: fixed;
  z-index: ${panelZIndexes.toolbar};

  top: 12px;
  right: 12px;
  left: 12px;
  height: 36px;
  pointer-events: none;

  display: flex;
  gap: 1rem;
  justify-content: center;
`;
	var Bg = import_styled_components78.default.div`
  display: flex;
  align-items: center;
  gap: 1rem;

  border-radius: 4px;
  padding: 6px 6px;

  ${pointerEventsAutoInNormalMode};

  &:hover {
    background-color: rgba(0, 0, 0, 0.15);
    backdrop-filter: blur(4px);
  }
`;
	var GlobalToolbar = (props) => {
	  const groups = [];
	  const extensionsById = useVal(getStudio().atomP.ephemeral.extensions.byId);
	  for (const [, extension] of Object.entries(extensionsById)) {
	    if (!extension)
	      continue;
	    if (extension.globalToolbar) {
	      groups.push(/* @__PURE__ */ import_react169.default.createElement(extension.globalToolbar.component, {
	        key: "extensionToolbar-" + extension.id
	      }));
	    }
	  }
	  if (groups.length === 0)
	    return null;
	  return /* @__PURE__ */ import_react169.default.createElement(Container58, null, /* @__PURE__ */ import_react169.default.createElement(Bg, null, groups));
	};
	var GlobalToolbar_default = GlobalToolbar;

	// studio/src/UIRoot/useKeyboardShortcuts.ts
	var import_react170 = __toModule(react.exports);

	// studio/src/utils/isMac.ts
	var isMac = navigator && navigator.platform.toUpperCase().indexOf("MAC") >= 0;

	// studio/src/utils/keyboardUtils.ts
	var cmdIsDown = (e) => {
	  if (isMac) {
	    return e.metaKey === true;
	  } else {
	    return e.ctrlKey === true;
	  }
	};

	// studio/src/UIRoot/useKeyboardShortcuts.ts
	function useKeyboardShortcuts() {
	  const studio3 = getStudio();
	  (0, import_react170.useEffect)(() => {
	    const handleKeyDown = (e) => {
	      const target = e.composedPath()[0];
	      if (target && (target.tagName === "INPUT" || target.tagName === "TEXTAREA")) {
	        return;
	      }
	      if (e.key === "z" || e.key === "Z" || e.code === "KeyZ") {
	        if (cmdIsDown(e)) {
	          if (e.shiftKey === true) {
	            studio3.redo();
	          } else {
	            studio3.undo();
	          }
	        } else {
	          return;
	        }
	      } else if (e.key === " " && !e.shiftKey && !e.metaKey && !e.altKey && !e.ctrlKey) {
	        const seq = getSelectedSequence();
	        if (seq) {
	          if (seq.playing) {
	            seq.pause();
	          } else {
	            seq.play({ iterationCount: 1e3 });
	          }
	        } else {
	          return;
	        }
	      } else if (e.altKey && (e.key === "\\" || e.code === "Backslash" || e.code === "IntlBackslash")) {
	        studio3.transaction(({ stateEditors: stateEditors2, drafts: drafts2 }) => {
	          stateEditors2.studio.ahistoric.setVisibilityState(drafts2.ahistoric.visibilityState === "everythingIsHidden" ? "everythingIsVisible" : "everythingIsHidden");
	        });
	      } else {
	        return;
	      }
	      e.preventDefault();
	      e.stopPropagation();
	    };
	    window.addEventListener("keydown", handleKeyDown);
	    return () => {
	      window.removeEventListener("keydown", handleKeyDown);
	    };
	  }, []);
	}

	// studio/src/UIRoot/UIRoot.tsx
	var GlobalStyle = import_styled_components79.createGlobalStyle`
  :host {
    contain: strict;
    all: initial;
    color: white;
    font: 11px -apple-system, BlinkMacSystemFont, Segoe WPC, Segoe Editor,
      HelveticaNeue-Light, Ubuntu, Droid Sans, sans-serif;
  }

  * {
    padding: 0;
    margin: 0;
    font-size: 100%;
    font: inherit;
    vertical-align: baseline;
    list-style: none;
  }
`;
	var Container59 = (0, import_styled_components79.default)(PointerEventsHandler_default)`
  z-index: 50;
  position: fixed;
  top: 0px;
  right: 0px;
  bottom: 0px;
  left: 0px;

  &.invisible {
    pointer-events: none !important;
    opacity: 0;
    transform: translateX(1000000px);
  }
`;
	var PortalLayer = import_styled_components79.default.div`
  z-index: 51;
  position: fixed;
  top: 0px;
  right: 0px;
  bottom: 0px;
  left: 0px;
  pointer-events: none;
`;
	function UIRoot() {
	  const studio3 = getStudio();
	  const [portalLayerRef, portalLayer] = useRefAndState(void 0);
	  useRefAndState(void 0);
	  useKeyboardShortcuts();
	  const visiblityState = useVal(studio3.atomP.ahistoric.visibilityState);
	  (0, import_react172.useEffect)(() => {
	    if (visiblityState === "everythingIsHidden") {
	      console.warn(`Theatre Studio is hidden. Use the keyboard shortcut 'alt + \\' to restore the studio, or call studio.ui.restore().`);
	    }
	    return () => {
	    };
	  }, [visiblityState]);
	  const inside = usePrism(() => {
	    const visiblityState2 = (0, import_dataverse47.val)(studio3.atomP.ahistoric.visibilityState);
	    const initialised = (0, import_dataverse47.val)(studio3.atomP.ephemeral.initialised);
	    return !initialised ? null : /* @__PURE__ */ import_react172.default.createElement(import_styled_components79.StyleSheetManager, {
	      disableVendorPrefixes: true,
	      target: getStudio().ui.containerShadow
	    }, /* @__PURE__ */ import_react172.default.createElement(import_react172.default.Fragment, null, /* @__PURE__ */ import_react172.default.createElement(GlobalStyle, null), /* @__PURE__ */ import_react172.default.createElement(ProvideTheme_default, null, /* @__PURE__ */ import_react172.default.createElement(PortalContext.Provider, {
	      value: portalLayer
	    }, /* @__PURE__ */ import_react172.default.createElement(TooltipContext_default, null, /* @__PURE__ */ import_react172.default.createElement(Container59, {
	      className: visiblityState2 === "everythingIsHidden" ? "invisible" : ""
	    }, /* @__PURE__ */ import_react172.default.createElement(PortalLayer, {
	      ref: portalLayerRef
	    }), /* @__PURE__ */ import_react172.default.createElement(GlobalToolbar_default, null), /* @__PURE__ */ import_react172.default.createElement(PanelsRoot_default, null)))))));
	  }, [studio3, portalLayerRef, portalLayer]);
	  return inside;
	}

	// studio/src/UI.ts
	var import_react173 = __toModule(react.exports);
	var import_react_dom7 = __toModule(reactDom.exports);
	var import_dataverse48 = __toModule(dist$1);
	var UI = class {
	  constructor(studio3) {
	    this.studio = studio3;
	    __publicField(this, "containerEl", document.createElement("div"));
	    __publicField(this, "_rendered", false);
	    __publicField(this, "_renderTimeout");
	    __publicField(this, "_documentBodyUIIsRenderedIn");
	    __publicField(this, "containerShadow");
	    this.containerEl.id = "theatrejs-studio-root";
	    this.containerEl.style.cssText = `
      position: fixed;
      top: 0;
      right: 0;
      bottom: 0;
      left: 0;
      pointer-events: none;
      z-index: 100;
    `;
	    this.containerShadow = this.containerEl.attachShadow({
	      mode: "open"
	    });
	  }
	  render() {
	    if (this._rendered) {
	      return;
	    }
	    this._rendered = true;
	    this._render();
	  }
	  _render() {
	    const renderCallback = () => {
	      if (!document.body) {
	        this._renderTimeout = setTimeout(renderCallback, 5);
	        return;
	      }
	      this._renderTimeout = void 0;
	      this._documentBodyUIIsRenderedIn = document.body;
	      this._documentBodyUIIsRenderedIn.appendChild(this.containerEl);
	      import_react_dom7.default.render(import_react173.default.createElement(UIRoot), this.containerShadow);
	    };
	    this._renderTimeout = setTimeout(renderCallback, 10);
	  }
	  hide() {
	    this.studio.transaction(({ drafts: drafts2 }) => {
	      drafts2.ahistoric.visibilityState = "everythingIsHidden";
	    });
	  }
	  restore() {
	    this.render();
	    this.studio.transaction(({ drafts: drafts2 }) => {
	      drafts2.ahistoric.visibilityState = "everythingIsVisible";
	    });
	  }
	  get isHidden() {
	    return (0, import_dataverse48.val)(this.studio.atomP.ahistoric.visibilityState) === "everythingIsHidden";
	  }
	};

	// studio/src/Studio.ts
	var import_dataverse53 = __toModule(dist$1);

	// shared/src/utils/identity.ts
	function identity2(a2) {
	  return a2;
	}

	// studio/src/utils/redux/actionCreator.ts
	var actionCreator = (actionType, transformer = identity2) => {
	  const originalActionCreator = (payload) => ({ type: actionType, payload: transformer(payload) });
	  originalActionCreator.type = actionType;
	  originalActionCreator.is = (o2) => o2 && o2.type && o2.type === actionType;
	  return originalActionCreator;
	};
	var actionCreator_default = actionCreator;

	// studio/src/utils/redux/withHistory/withHistory.ts
	var import_jiff = __toModule(require_jiff());
	var import_json_touch_patch = __toModule(require_lib());

	// node_modules/uuid/dist/esm-browser/rng.js
	var getRandomValues;
	var rnds8 = new Uint8Array(16);
	function rng() {
	  if (!getRandomValues) {
	    getRandomValues = typeof crypto !== "undefined" && crypto.getRandomValues && crypto.getRandomValues.bind(crypto) || typeof msCrypto !== "undefined" && typeof msCrypto.getRandomValues === "function" && msCrypto.getRandomValues.bind(msCrypto);
	    if (!getRandomValues) {
	      throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");
	    }
	  }
	  return getRandomValues(rnds8);
	}

	// node_modules/uuid/dist/esm-browser/regex.js
	var regex_default = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;

	// node_modules/uuid/dist/esm-browser/validate.js
	function validate(uuid) {
	  return typeof uuid === "string" && regex_default.test(uuid);
	}
	var validate_default = validate;

	// node_modules/uuid/dist/esm-browser/stringify.js
	var byteToHex = [];
	for (var i2 = 0; i2 < 256; ++i2) {
	  byteToHex.push((i2 + 256).toString(16).substr(1));
	}
	function stringify(arr) {
	  var offset = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 0;
	  var uuid = (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + "-" + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + "-" + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + "-" + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + "-" + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase();
	  if (!validate_default(uuid)) {
	    throw TypeError("Stringified UUID is invalid");
	  }
	  return uuid;
	}
	var stringify_default = stringify;

	// node_modules/uuid/dist/esm-browser/v4.js
	function v4(options, buf, offset) {
	  options = options || {};
	  var rnds = options.random || (options.rng || rng)();
	  rnds[6] = rnds[6] & 15 | 64;
	  rnds[8] = rnds[8] & 63 | 128;
	  if (buf) {
	    offset = offset || 0;
	    for (var i2 = 0; i2 < 16; ++i2) {
	      buf[offset + i2] = rnds[i2];
	    }
	    return buf;
	  }
	  return stringify_default(rnds);
	}
	var v4_default = v4;

	// studio/src/utils/redux/withHistory/withHistory.ts
	var historicActions = {
	  replaceHistory: actionCreator_default("@history/replaceHistory"),
	  startHistoryFromScratch: actionCreator_default("@history/startHistoryFromScratch"),
	  undo: actionCreator_default("@history/undo"),
	  redo: actionCreator_default("@history/redo")
	};
	var unknownAction = { type: "@history/unknownAction", payload: "" };
	var defaultConfig = {
	  maxNumberOfCommits: 100
	};
	var withHistory = (innerReducer, config = defaultConfig) => {
	  const cachedEmptyHistory = createEmptyHistory(innerReducer(void 0, unknownAction));
	  return function historicReducer(state, action) {
	    if (historicActions.startHistoryFromScratch.is(action)) {
	      return createEmptyHistory(innerReducer(void 0, action.payload));
	    } else if (historicActions.replaceHistory.is(action)) {
	      return action.payload;
	    } else {
	      if (historicActions.undo.is(action)) {
	        return state ? undo(state) : cachedEmptyHistory;
	      } else if (historicActions.redo.is(action)) {
	        return state ? redo(state) : cachedEmptyHistory;
	      } else {
	        if (state) {
	          return pushCommit(state, innerReducer(state.innerState, action), config);
	        } else {
	          return createEmptyHistory(innerReducer(void 0, action));
	        }
	      }
	    }
	  };
	};
	function createEmptyHistory(innerState) {
	  return {
	    currentCommitHash: void 0,
	    commitsByHash: {},
	    listOfCommitHashes: [],
	    innerState
	  };
	}
	function pushCommit(prevHistory, newInnerState, config) {
	  if (newInnerState === prevHistory.innerState)
	    return prevHistory;
	  const commit = createCommit(prevHistory.innerState, newInnerState);
	  if (commit.forwardDiff.length === 0) {
	    return prevHistory;
	  }
	  const prevLastCommitHash = last_default(prevHistory.listOfCommitHashes);
	  const newHistory = {
	    currentCommitHash: commit.hash,
	    commitsByHash: __spreadValues({}, prevHistory.commitsByHash),
	    listOfCommitHashes: [...prevHistory.listOfCommitHashes],
	    innerState: newInnerState
	  };
	  if (prevHistory.currentCommitHash !== prevLastCommitHash) {
	    const indexOfCurrentCommitHash = prevHistory.listOfCommitHashes.findIndex((v2) => v2 === prevHistory.currentCommitHash);
	    const listOfCommitHashesToDiscard = prevHistory.listOfCommitHashes.slice(indexOfCurrentCommitHash + 1);
	    listOfCommitHashesToDiscard.forEach((hash) => {
	      delete newHistory.commitsByHash[hash];
	    });
	    newHistory.listOfCommitHashes.splice(indexOfCurrentCommitHash + 1, newHistory.listOfCommitHashes.length);
	  }
	  newHistory.listOfCommitHashes.push(commit.hash);
	  newHistory.commitsByHash[commit.hash] = commit;
	  if (newHistory.listOfCommitHashes.length > config.maxNumberOfCommits) {
	    const numberOfCommitsToDiscard = newHistory.listOfCommitHashes.length - config.maxNumberOfCommits;
	    const listOfCommitHashesToDiscard = newHistory.listOfCommitHashes.slice(0, numberOfCommitsToDiscard);
	    listOfCommitHashesToDiscard.forEach((hash) => {
	      delete newHistory.commitsByHash[hash];
	    });
	    newHistory.listOfCommitHashes.splice(0, numberOfCommitsToDiscard);
	  }
	  return newHistory;
	}
	function createCommit(oldSnapshot, newSnapshot) {
	  const forwardDiff = import_jiff.default.diff(oldSnapshot, newSnapshot, { invertible: false });
	  const backwardDiff = import_jiff.default.diff(newSnapshot, oldSnapshot, { invertible: false });
	  const timestamp = Date.now();
	  const commitHash = v4_default();
	  const commit = {
	    forwardDiff,
	    backwardDiff,
	    timestamp,
	    hash: commitHash
	  };
	  return commit;
	}
	function undo(prevHistory) {
	  if (prevHistory.currentCommitHash === void 0) {
	    return prevHistory;
	  }
	  const indexOfCurrentCommitHash = prevHistory.listOfCommitHashes.findIndex((v2) => v2 === prevHistory.currentCommitHash);
	  if (indexOfCurrentCommitHash === -1) {
	    throw new Error("This should never happen");
	  }
	  const currentCommit = prevHistory.commitsByHash[prevHistory.currentCommitHash];
	  const newInnerState = (0, import_json_touch_patch.default)(prevHistory.innerState, currentCommit.backwardDiff);
	  const indexOfNewCommitHash = indexOfCurrentCommitHash - 1;
	  const newCommitHash = indexOfNewCommitHash === -1 ? void 0 : prevHistory.listOfCommitHashes[indexOfNewCommitHash];
	  const newHistory = __spreadProps(__spreadValues({}, prevHistory), {
	    currentCommitHash: newCommitHash,
	    innerState: newInnerState
	  });
	  return newHistory;
	}
	function redo(prevHistory) {
	  if (prevHistory.listOfCommitHashes.length === 0) {
	    return prevHistory;
	  }
	  const indexOfCurrentCommitHash = prevHistory.listOfCommitHashes.findIndex((v2) => v2 === prevHistory.currentCommitHash);
	  if (indexOfCurrentCommitHash === prevHistory.listOfCommitHashes.length - 1) {
	    return prevHistory;
	  }
	  const indexOfNewCommitHash = indexOfCurrentCommitHash + 1;
	  const newCommitHash = prevHistory.listOfCommitHashes[indexOfNewCommitHash];
	  const currentCommit = prevHistory.commitsByHash[newCommitHash];
	  const newInnerState = (0, import_json_touch_patch.default)(prevHistory.innerState, currentCommit.forwardDiff);
	  const newHistory = __spreadProps(__spreadValues({}, prevHistory), {
	    currentCommitHash: newCommitHash,
	    innerState: newInnerState
	  });
	  return newHistory;
	}

	// studio/src/store/index.ts
	var initialState = {
	  ahistoric: {
	    visibilityState: "everythingIsVisible",
	    theTrigger: {
	      position: {
	        closestCorner: "bottomLeft",
	        distanceFromHorizontalEdge: 0.02,
	        distanceFromVerticalEdge: 0.02
	      }
	    },
	    coreByProject: {},
	    projects: {
	      stateByProjectId: {}
	    }
	  },
	  historic: {
	    projects: {
	      stateByProjectId: {}
	    },
	    autoKey: true,
	    coreByProject: {},
	    panelInstanceDesceriptors: {}
	  },
	  ephemeral: {
	    initialised: false,
	    coreByProject: {},
	    projects: {
	      stateByProjectId: {}
	    },
	    extensions: {
	      byId: {},
	      paneClasses: {}
	    }
	  }
	};
	var replacePersistentState = actionCreator_default("@storeBundle/replacePersistentState", (s2) => s2);
	var reduceParts = actionCreator_default("@storeBundle/reduceParts", (fn2) => fn2);
	var studioActions = {
	  historic: historicActions,
	  replacePersistentState,
	  reduceParts
	};
	var setInnerHistoricState = actionCreator_default("@storeBundle/setInnerHistoricState", (s2) => s2);
	var historicInnerReducer = (s2 = initialState.historic, action) => {
	  if (setInnerHistoricState.is(action)) {
	    return action.payload;
	  } else {
	    return s2;
	  }
	};
	var historicWrappedReducer = withHistory(historicInnerReducer);
	var permanentReducer = (prevState, action) => {
	  if (replacePersistentState.is(action)) {
	    const { historic, ahistoric } = action.payload;
	    const ephemeral = (prevState == null ? void 0 : prevState.ephemeral) || initialState.ephemeral;
	    return {
	      $persistent: { historic, ahistoric },
	      ephemeral
	    };
	  } else if (!prevState) {
	    const historic = historicWrappedReducer(void 0, {});
	    const ahistoric = initialState.ahistoric;
	    const ephemeral = initialState.ephemeral;
	    return {
	      $persistent: { historic, ahistoric },
	      ephemeral
	    };
	  } else {
	    let { historic, ahistoric } = prevState.$persistent;
	    let { ephemeral } = prevState;
	    if (reduceParts.is(action)) {
	      const wholeState = {
	        historic: prevState.$persistent.historic.innerState,
	        ahistoric: prevState.$persistent.ahistoric,
	        ephemeral: prevState.ephemeral
	      };
	      const reduced = action.payload(wholeState);
	      if (reduced === wholeState)
	        return prevState;
	      if (historic.innerState !== reduced.historic) {
	        historic = historicWrappedReducer(historic, setInnerHistoricState(reduced.historic));
	      }
	      ahistoric = reduced.ahistoric;
	      ephemeral = reduced.ephemeral;
	    } else {
	      const newHistoric = historicWrappedReducer(historic, action);
	      if (newHistoric === historic)
	        return prevState;
	      historic = newHistoric;
	    }
	    const persistent = historic === prevState.$persistent.historic && ahistoric === prevState.$persistent.ahistoric ? prevState.$persistent : { historic, ahistoric };
	    return {
	      $persistent: persistent,
	      ephemeral
	    };
	  }
	};
	var _pushTemporaryAction = actionCreator_default("@history/pushTempAction", (input) => input);
	var _discardTemporaryAction = actionCreator_default("@history/discardTempAction", (id) => id);
	var _commitTemporaryAction = actionCreator_default("@history/commitTempAction", (id) => id);
	var lastTempActionGroupId = 0;
	var tempActionGroup = () => {
	  const id = lastTempActionGroupId++;
	  const push = (originalAction) => _pushTemporaryAction({
	    id,
	    originalAction
	  });
	  const discard = () => _discardTemporaryAction(id);
	  const commit = () => _commitTemporaryAction(id);
	  return {
	    push,
	    discard,
	    commit
	  };
	};
	var studioReducer = (prevState, action) => {
	  if (!prevState) {
	    const permanent = permanentReducer(void 0, action);
	    return {
	      $temps: {
	        permanent,
	        tempActions: []
	      },
	      $persistent: permanent.$persistent,
	      historic: permanent.$persistent.historic.innerState,
	      ahistoric: permanent.$persistent.ahistoric,
	      ephemeral: permanent.ephemeral
	    };
	  } else {
	    let { tempActions, permanent } = prevState.$temps;
	    let actionToPassInToPermanentReducer = void 0;
	    if (_pushTemporaryAction.is(action)) {
	      tempActions = [...tempActions, action];
	    } else if (_commitTemporaryAction.is(action)) {
	      const toCommit = tempActions.find((a2) => a2.payload.id === action.payload);
	      if (!toCommit) {
	        logger_default.error(`Comitting temp action group ${action.payload} isn't possible as this group doesn't exist`);
	      } else {
	        actionToPassInToPermanentReducer = toCommit.payload.originalAction;
	        tempActions = tempActions.filter((a2) => a2.payload.id !== action.payload);
	      }
	    } else if (_discardTemporaryAction.is(action)) {
	      tempActions = tempActions.filter((a2) => a2.payload.id !== action.payload);
	    } else {
	      actionToPassInToPermanentReducer = action;
	    }
	    if (actionToPassInToPermanentReducer) {
	      permanent = permanentReducer(prevState.$temps.permanent, actionToPassInToPermanentReducer);
	    }
	    let surface = {
	      historic: permanent.$persistent.historic.innerState,
	      ahistoric: permanent.$persistent.ahistoric,
	      ephemeral: permanent.ephemeral
	    };
	    for (const tempAction of tempActions) {
	      const orig = tempAction.payload.originalAction;
	      surface = orig.payload(surface);
	    }
	    return __spreadValues({
	      $temps: {
	        tempActions,
	        permanent
	      },
	      $persistent: permanent.$persistent
	    }, surface);
	  }
	};

	// ../node_modules/nanoid/non-secure/index.js
	var urlAlphabet2 = "ModuleSymbhasOwnPr-0123456789ABCDEFGHNRVfgctiUvz_KqYTJkLxpZXIjQW";
	var nanoid2 = (size = 21) => {
	  let id = "";
	  let i2 = size;
	  while (i2--) {
	    id += urlAlphabet2[Math.random() * 64 | 0];
	  }
	  return id;
	};

	// shared/src/utils/ids.ts
	function generateKeyframeId() {
	  return nanoid2(10);
	}
	function generateSequenceTrackId() {
	  return nanoid2(10);
	}

	// shared/src/utils/removePathFromObject.ts
	function removePathFromObject(base, path) {
	  if (typeof base !== "object" || base === null)
	    return;
	  if (path.length === 0) {
	    const keys2 = Object.keys(base);
	    for (const key of keys2) {
	      delete base[key];
	    }
	    return;
	  }
	  const keysUpToLastKey = path.slice(0, path.length - 1);
	  let cur = base;
	  const childToParentMapping = new WeakMap();
	  for (const key of keysUpToLastKey) {
	    const parent = cur;
	    const child = parent[key];
	    if (typeof child !== "object" || child === null) {
	      return;
	    } else {
	      childToParentMapping.set(child, parent);
	      cur = child;
	    }
	  }
	  const keysReversed = path.slice().reverse();
	  for (const key of keysReversed) {
	    delete cur[key];
	    if (Object.keys(cur).length === 0) {
	      cur = childToParentMapping.get(cur);
	      continue;
	    } else {
	      return;
	    }
	  }
	}

	// shared/src/utils/transformNumber.ts
	function transformNumber(initialPos, {
	  scale,
	  origin,
	  translate
	}) {
	  const scaled = origin + (initialPos - origin) * scale;
	  return translate + scaled;
	}

	// ../node_modules/immer/dist/immer.esm.js
	function n(n2) {
	  for (var t2 = arguments.length, r2 = Array(t2 > 1 ? t2 - 1 : 0), e = 1; e < t2; e++)
	    r2[e - 1] = arguments[e];
	  {
	    var i2 = Y[n2], o2 = i2 ? typeof i2 == "function" ? i2.apply(null, r2) : i2 : "unknown error nr: " + n2;
	    throw Error("[Immer] " + o2);
	  }
	}
	function t(n2) {
	  return !!n2 && !!n2[Q];
	}
	function r(n2) {
	  return !!n2 && (function(n3) {
	    if (!n3 || typeof n3 != "object")
	      return false;
	    var t2 = Object.getPrototypeOf(n3);
	    if (t2 === null)
	      return true;
	    var r2 = Object.hasOwnProperty.call(t2, "constructor") && t2.constructor;
	    return r2 === Object || typeof r2 == "function" && Function.toString.call(r2) === Z;
	  }(n2) || Array.isArray(n2) || !!n2[L] || !!n2.constructor[L] || s(n2) || v(n2));
	}
	function i(n2, t2, r2) {
	  r2 === void 0 && (r2 = false), o(n2) === 0 ? (r2 ? Object.keys : nn)(n2).forEach(function(e) {
	    r2 && typeof e == "symbol" || t2(e, n2[e], n2);
	  }) : n2.forEach(function(r3, e) {
	    return t2(e, r3, n2);
	  });
	}
	function o(n2) {
	  var t2 = n2[Q];
	  return t2 ? t2.i > 3 ? t2.i - 4 : t2.i : Array.isArray(n2) ? 1 : s(n2) ? 2 : v(n2) ? 3 : 0;
	}
	function u(n2, t2) {
	  return o(n2) === 2 ? n2.has(t2) : Object.prototype.hasOwnProperty.call(n2, t2);
	}
	function a(n2, t2) {
	  return o(n2) === 2 ? n2.get(t2) : n2[t2];
	}
	function f(n2, t2, r2) {
	  var e = o(n2);
	  e === 2 ? n2.set(t2, r2) : e === 3 ? (n2.delete(t2), n2.add(r2)) : n2[t2] = r2;
	}
	function c(n2, t2) {
	  return n2 === t2 ? n2 !== 0 || 1 / n2 == 1 / t2 : n2 != n2 && t2 != t2;
	}
	function s(n2) {
	  return X && n2 instanceof Map;
	}
	function v(n2) {
	  return q && n2 instanceof Set;
	}
	function p(n2) {
	  return n2.o || n2.t;
	}
	function l(n2) {
	  if (Array.isArray(n2))
	    return Array.prototype.slice.call(n2);
	  var t2 = tn(n2);
	  delete t2[Q];
	  for (var r2 = nn(t2), e = 0; e < r2.length; e++) {
	    var i2 = r2[e], o2 = t2[i2];
	    o2.writable === false && (o2.writable = true, o2.configurable = true), (o2.get || o2.set) && (t2[i2] = { configurable: true, writable: true, enumerable: o2.enumerable, value: n2[i2] });
	  }
	  return Object.create(Object.getPrototypeOf(n2), t2);
	}
	function d(n2, e) {
	  return e === void 0 && (e = false), y(n2) || t(n2) || !r(n2) ? n2 : (o(n2) > 1 && (n2.set = n2.add = n2.clear = n2.delete = h), Object.freeze(n2), e && i(n2, function(n3, t2) {
	    return d(t2, true);
	  }, true), n2);
	}
	function h() {
	  n(2);
	}
	function y(n2) {
	  return n2 == null || typeof n2 != "object" || Object.isFrozen(n2);
	}
	function b(t2) {
	  var r2 = rn[t2];
	  return r2 || n(18, t2), r2;
	}
	function _() {
	  return U || n(0), U;
	}
	function j(n2, t2) {
	  t2 && (b("Patches"), n2.u = [], n2.s = [], n2.v = t2);
	}
	function O(n2) {
	  g(n2), n2.p.forEach(S), n2.p = null;
	}
	function g(n2) {
	  n2 === U && (U = n2.l);
	}
	function w(n2) {
	  return U = { p: [], l: U, h: n2, m: true, _: 0 };
	}
	function S(n2) {
	  var t2 = n2[Q];
	  t2.i === 0 || t2.i === 1 ? t2.j() : t2.O = true;
	}
	function P(t2, e) {
	  e._ = e.p.length;
	  var i2 = e.p[0], o2 = t2 !== void 0 && t2 !== i2;
	  return e.h.g || b("ES5").S(e, t2, o2), o2 ? (i2[Q].P && (O(e), n(4)), r(t2) && (t2 = M(e, t2), e.l || x(e, t2)), e.u && b("Patches").M(i2[Q], t2, e.u, e.s)) : t2 = M(e, i2, []), O(e), e.u && e.v(e.u, e.s), t2 !== H ? t2 : void 0;
	}
	function M(n2, t2, r2) {
	  if (y(t2))
	    return t2;
	  var e = t2[Q];
	  if (!e)
	    return i(t2, function(i2, o3) {
	      return A(n2, e, t2, i2, o3, r2);
	    }, true), t2;
	  if (e.A !== n2)
	    return t2;
	  if (!e.P)
	    return x(n2, e.t, true), e.t;
	  if (!e.I) {
	    e.I = true, e.A._--;
	    var o2 = e.i === 4 || e.i === 5 ? e.o = l(e.k) : e.o;
	    i(e.i === 3 ? new Set(o2) : o2, function(t3, i2) {
	      return A(n2, e, o2, t3, i2, r2);
	    }), x(n2, o2, false), r2 && n2.u && b("Patches").R(e, r2, n2.u, n2.s);
	  }
	  return e.o;
	}
	function A(e, i2, o2, a2, c2, s2) {
	  if (c2 === o2 && n(5), t(c2)) {
	    var v2 = M(e, c2, s2 && i2 && i2.i !== 3 && !u(i2.D, a2) ? s2.concat(a2) : void 0);
	    if (f(o2, a2, v2), !t(v2))
	      return;
	    e.m = false;
	  }
	  if (r(c2) && !y(c2)) {
	    if (!e.h.F && e._ < 1)
	      return;
	    M(e, c2), i2 && i2.A.l || x(e, c2);
	  }
	}
	function x(n2, t2, r2) {
	  r2 === void 0 && (r2 = false), n2.h.F && n2.m && d(t2, r2);
	}
	function z(n2, t2) {
	  var r2 = n2[Q];
	  return (r2 ? p(r2) : n2)[t2];
	}
	function I(n2, t2) {
	  if (t2 in n2)
	    for (var r2 = Object.getPrototypeOf(n2); r2; ) {
	      var e = Object.getOwnPropertyDescriptor(r2, t2);
	      if (e)
	        return e;
	      r2 = Object.getPrototypeOf(r2);
	    }
	}
	function k(n2) {
	  n2.P || (n2.P = true, n2.l && k(n2.l));
	}
	function E(n2) {
	  n2.o || (n2.o = l(n2.t));
	}
	function R(n2, t2, r2) {
	  var e = s(t2) ? b("MapSet").N(t2, r2) : v(t2) ? b("MapSet").T(t2, r2) : n2.g ? function(n3, t3) {
	    var r3 = Array.isArray(n3), e2 = { i: r3 ? 1 : 0, A: t3 ? t3.A : _(), P: false, I: false, D: {}, l: t3, t: n3, k: null, o: null, j: null, C: false }, i2 = e2, o2 = en;
	    r3 && (i2 = [e2], o2 = on2);
	    var u2 = Proxy.revocable(i2, o2), a2 = u2.revoke, f2 = u2.proxy;
	    return e2.k = f2, e2.j = a2, f2;
	  }(t2, r2) : b("ES5").J(t2, r2);
	  return (r2 ? r2.A : _()).p.push(e), e;
	}
	function D(e) {
	  return t(e) || n(22, e), function n2(t2) {
	    if (!r(t2))
	      return t2;
	    var e2, u2 = t2[Q], c2 = o(t2);
	    if (u2) {
	      if (!u2.P && (u2.i < 4 || !b("ES5").K(u2)))
	        return u2.t;
	      u2.I = true, e2 = F(t2, c2), u2.I = false;
	    } else
	      e2 = F(t2, c2);
	    return i(e2, function(t3, r2) {
	      u2 && a(u2.t, t3) === r2 || f(e2, t3, n2(r2));
	    }), c2 === 3 ? new Set(e2) : e2;
	  }(e);
	}
	function F(n2, t2) {
	  switch (t2) {
	    case 2:
	      return new Map(n2);
	    case 3:
	      return Array.from(n2);
	  }
	  return l(n2);
	}
	var G;
	var U;
	var W = typeof Symbol != "undefined" && typeof Symbol("x") == "symbol";
	var X = typeof Map != "undefined";
	var q = typeof Set != "undefined";
	var B = typeof Proxy != "undefined" && Proxy.revocable !== void 0 && typeof Reflect != "undefined";
	var H = W ? Symbol.for("immer-nothing") : ((G = {})["immer-nothing"] = true, G);
	var L = W ? Symbol.for("immer-draftable") : "__$immer_draftable";
	var Q = W ? Symbol.for("immer-state") : "__$immer_state";
	var Y = { 0: "Illegal state", 1: "Immer drafts cannot have computed properties", 2: "This object has been frozen and should not be mutated", 3: function(n2) {
	  return "Cannot use a proxy that has been revoked. Did you pass an object from inside an immer function to an async process? " + n2;
	}, 4: "An immer producer returned a new value *and* modified its draft. Either return a new value *or* modify the draft.", 5: "Immer forbids circular references", 6: "The first or second argument to `produce` must be a function", 7: "The third argument to `produce` must be a function or undefined", 8: "First argument to `createDraft` must be a plain object, an array, or an immerable object", 9: "First argument to `finishDraft` must be a draft returned by `createDraft`", 10: "The given draft is already finalized", 11: "Object.defineProperty() cannot be used on an Immer draft", 12: "Object.setPrototypeOf() cannot be used on an Immer draft", 13: "Immer only supports deleting array indices", 14: "Immer only supports setting array indices and the 'length' property", 15: function(n2) {
	  return "Cannot apply patch, path doesn't resolve: " + n2;
	}, 16: 'Sets cannot have "replace" patches.', 17: function(n2) {
	  return "Unsupported patch operation: " + n2;
	}, 18: function(n2) {
	  return "The plugin for '" + n2 + "' has not been loaded into Immer. To enable the plugin, import and call `enable" + n2 + "()` when initializing your application.";
	}, 20: "Cannot use proxies if Proxy, Proxy.revocable or Reflect are not available", 21: function(n2) {
	  return "produce can only be called on things that are draftable: plain objects, arrays, Map, Set or classes that are marked with '[immerable]: true'. Got '" + n2 + "'";
	}, 22: function(n2) {
	  return "'current' expects a draft, got: " + n2;
	}, 23: function(n2) {
	  return "'original' expects a draft, got: " + n2;
	}, 24: "Patching reserved attributes like __proto__, prototype and constructor is not allowed" };
	var Z = "" + Object.prototype.constructor;
	var nn = typeof Reflect != "undefined" && Reflect.ownKeys ? Reflect.ownKeys : Object.getOwnPropertySymbols !== void 0 ? function(n2) {
	  return Object.getOwnPropertyNames(n2).concat(Object.getOwnPropertySymbols(n2));
	} : Object.getOwnPropertyNames;
	var tn = Object.getOwnPropertyDescriptors || function(n2) {
	  var t2 = {};
	  return nn(n2).forEach(function(r2) {
	    t2[r2] = Object.getOwnPropertyDescriptor(n2, r2);
	  }), t2;
	};
	var rn = {};
	var en = { get: function(n2, t2) {
	  if (t2 === Q)
	    return n2;
	  var e = p(n2);
	  if (!u(e, t2))
	    return function(n3, t3, r2) {
	      var e2, i3 = I(t3, r2);
	      return i3 ? "value" in i3 ? i3.value : (e2 = i3.get) === null || e2 === void 0 ? void 0 : e2.call(n3.k) : void 0;
	    }(n2, e, t2);
	  var i2 = e[t2];
	  return n2.I || !r(i2) ? i2 : i2 === z(n2.t, t2) ? (E(n2), n2.o[t2] = R(n2.A.h, i2, n2)) : i2;
	}, has: function(n2, t2) {
	  return t2 in p(n2);
	}, ownKeys: function(n2) {
	  return Reflect.ownKeys(p(n2));
	}, set: function(n2, t2, r2) {
	  var e = I(p(n2), t2);
	  if (e == null ? void 0 : e.set)
	    return e.set.call(n2.k, r2), true;
	  if (!n2.P) {
	    var i2 = z(p(n2), t2), o2 = i2 == null ? void 0 : i2[Q];
	    if (o2 && o2.t === r2)
	      return n2.o[t2] = r2, n2.D[t2] = false, true;
	    if (c(r2, i2) && (r2 !== void 0 || u(n2.t, t2)))
	      return true;
	    E(n2), k(n2);
	  }
	  return n2.o[t2] === r2 && typeof r2 != "number" && (r2 !== void 0 || t2 in n2.o) || (n2.o[t2] = r2, n2.D[t2] = true, true);
	}, deleteProperty: function(n2, t2) {
	  return z(n2.t, t2) !== void 0 || t2 in n2.t ? (n2.D[t2] = false, E(n2), k(n2)) : delete n2.D[t2], n2.o && delete n2.o[t2], true;
	}, getOwnPropertyDescriptor: function(n2, t2) {
	  var r2 = p(n2), e = Reflect.getOwnPropertyDescriptor(r2, t2);
	  return e ? { writable: true, configurable: n2.i !== 1 || t2 !== "length", enumerable: e.enumerable, value: r2[t2] } : e;
	}, defineProperty: function() {
	  n(11);
	}, getPrototypeOf: function(n2) {
	  return Object.getPrototypeOf(n2.t);
	}, setPrototypeOf: function() {
	  n(12);
	} };
	var on2 = {};
	i(en, function(n2, t2) {
	  on2[n2] = function() {
	    return arguments[0] = arguments[0][0], t2.apply(this, arguments);
	  };
	}), on2.deleteProperty = function(t2, r2) {
	  return isNaN(parseInt(r2)) && n(13), en.deleteProperty.call(this, t2[0], r2);
	}, on2.set = function(t2, r2, e) {
	  return r2 !== "length" && isNaN(parseInt(r2)) && n(14), en.set.call(this, t2[0], r2, e, t2[0]);
	};
	var un = function() {
	  function e(t2) {
	    var e2 = this;
	    this.g = B, this.F = true, this.produce = function(t3, i3, o2) {
	      if (typeof t3 == "function" && typeof i3 != "function") {
	        var u2 = i3;
	        i3 = t3;
	        var a2 = e2;
	        return function(n2) {
	          var t4 = this;
	          n2 === void 0 && (n2 = u2);
	          for (var r2 = arguments.length, e3 = Array(r2 > 1 ? r2 - 1 : 0), o3 = 1; o3 < r2; o3++)
	            e3[o3 - 1] = arguments[o3];
	          return a2.produce(n2, function(n3) {
	            var r3;
	            return (r3 = i3).call.apply(r3, [t4, n3].concat(e3));
	          });
	        };
	      }
	      var f2;
	      if (typeof i3 != "function" && n(6), o2 !== void 0 && typeof o2 != "function" && n(7), r(t3)) {
	        var c2 = w(e2), s2 = R(e2, t3, void 0), v2 = true;
	        try {
	          f2 = i3(s2), v2 = false;
	        } finally {
	          v2 ? O(c2) : g(c2);
	        }
	        return typeof Promise != "undefined" && f2 instanceof Promise ? f2.then(function(n2) {
	          return j(c2, o2), P(n2, c2);
	        }, function(n2) {
	          throw O(c2), n2;
	        }) : (j(c2, o2), P(f2, c2));
	      }
	      if (!t3 || typeof t3 != "object") {
	        if ((f2 = i3(t3)) === H)
	          return;
	        return f2 === void 0 && (f2 = t3), e2.F && d(f2, true), f2;
	      }
	      n(21, t3);
	    }, this.produceWithPatches = function(n2, t3) {
	      return typeof n2 == "function" ? function(t4) {
	        for (var r3 = arguments.length, i4 = Array(r3 > 1 ? r3 - 1 : 0), o2 = 1; o2 < r3; o2++)
	          i4[o2 - 1] = arguments[o2];
	        return e2.produceWithPatches(t4, function(t5) {
	          return n2.apply(void 0, [t5].concat(i4));
	        });
	      } : [e2.produce(n2, t3, function(n3, t4) {
	        r2 = n3, i3 = t4;
	      }), r2, i3];
	      var r2, i3;
	    }, typeof (t2 == null ? void 0 : t2.useProxies) == "boolean" && this.setUseProxies(t2.useProxies), typeof (t2 == null ? void 0 : t2.autoFreeze) == "boolean" && this.setAutoFreeze(t2.autoFreeze);
	  }
	  var i2 = e.prototype;
	  return i2.createDraft = function(e2) {
	    r(e2) || n(8), t(e2) && (e2 = D(e2));
	    var i3 = w(this), o2 = R(this, e2, void 0);
	    return o2[Q].C = true, g(i3), o2;
	  }, i2.finishDraft = function(t2, r2) {
	    var e2 = t2 && t2[Q];
	    e2 && e2.C || n(9), e2.I && n(10);
	    var i3 = e2.A;
	    return j(i3, r2), P(void 0, i3);
	  }, i2.setAutoFreeze = function(n2) {
	    this.F = n2;
	  }, i2.setUseProxies = function(t2) {
	    t2 && !B && n(20), this.g = t2;
	  }, i2.applyPatches = function(n2, r2) {
	    var e2;
	    for (e2 = r2.length - 1; e2 >= 0; e2--) {
	      var i3 = r2[e2];
	      if (i3.path.length === 0 && i3.op === "replace") {
	        n2 = i3.value;
	        break;
	      }
	    }
	    var o2 = b("Patches").$;
	    return t(n2) ? o2(n2, r2) : this.produce(n2, function(n3) {
	      return o2(n3, r2.slice(e2 + 1));
	    });
	  }, e;
	}();
	var an = new un();
	an.produce;
	an.produceWithPatches.bind(an);
	an.setAutoFreeze.bind(an);
	an.setUseProxies.bind(an);
	an.applyPatches.bind(an);
	var ln = an.createDraft.bind(an);
	var dn = an.finishDraft.bind(an);

	// studio/src/store/stateEditors.ts
	var setDrafts__onlyMeantToBeCalledByTransaction = (drafts2) => {
	  currentDrafts = drafts2;
	  return stateEditors;
	};
	var currentDrafts;
	var drafts = () => {
	  if (typeof currentDrafts === "undefined") {
	    throw new Error(`Calling stateEditors outside of a transaction is not allowed.`);
	  }
	  return currentDrafts;
	};
	var stateEditors;
	(function(stateEditors2) {
	  (function(studio4) {
	    (function(historic2) {
	      (function(panelPositions2) {
	        function setPanelPosition(p2) {
	          var _a;
	          const h2 = drafts().historic;
	          (_a = h2.panelPositions) != null ? _a : h2.panelPositions = {};
	          h2.panelPositions[p2.panelId] = p2.position;
	        }
	        panelPositions2.setPanelPosition = setPanelPosition;
	      })(historic2.panelPositions || (historic2.panelPositions = {}));
	      (function(panels2) {
	        function _ensure() {
	          var _a, _b;
	          (_b = (_a = drafts().historic).panels) != null ? _b : _a.panels = {};
	          return drafts().historic.panels;
	        }
	        panels2._ensure = _ensure;
	        (function(outline2) {
	          function _ensure2() {
	            var _a;
	            const panels3 = stateEditors2.studio.historic.panels._ensure();
	            (_a = panels3.outlinePanel) != null ? _a : panels3.outlinePanel = {};
	            return panels3.outlinePanel;
	          }
	          outline2._ensure = _ensure2;
	          (function(selection2) {
	            function set2(selection3) {
	              const newSelectionState = [];
	              for (const item of uniq_default(selection3)) {
	                if (isProject(item)) {
	                  newSelectionState.push(__spreadValues({ type: "Project" }, item.address));
	                } else if (isSheet(item)) {
	                  newSelectionState.push(__spreadValues({
	                    type: "Sheet"
	                  }, item.template.address));
	                  stateEditors2.studio.historic.projects.stateByProjectId.stateBySheetId.setSelectedInstanceId(item.address);
	                } else if (isSheetTemplate(item)) {
	                  newSelectionState.push(__spreadValues({ type: "Sheet" }, item.address));
	                } else if (isSheetObject(item)) {
	                  newSelectionState.push(__spreadValues({
	                    type: "SheetObject"
	                  }, item.template.address));
	                  stateEditors2.studio.historic.projects.stateByProjectId.stateBySheetId.setSelectedInstanceId(item.sheet.address);
	                } else if (isSheetObjectTemplate(item)) {
	                  newSelectionState.push(__spreadValues({ type: "SheetObject" }, item.address));
	                }
	              }
	              outline2._ensure().selection = newSelectionState;
	            }
	            selection2.set = set2;
	            function unset() {
	              outline2._ensure().selection = [];
	            }
	            selection2.unset = unset;
	          })(outline2.selection || (outline2.selection = {}));
	        })(panels2.outline || (panels2.outline = {}));
	        (function(sequenceEditor2) {
	          function _ensure2() {
	            var _a;
	            const panels3 = stateEditors2.studio.historic.panels._ensure();
	            (_a = panels3.sequenceEditor) != null ? _a : panels3.sequenceEditor = {};
	            return panels3.sequenceEditor;
	          }
	          sequenceEditor2._ensure = _ensure2;
	          (function(graphEditor2) {
	            function _ensure3() {
	              var _a;
	              const s2 = sequenceEditor2._ensure();
	              (_a = s2.graphEditor) != null ? _a : s2.graphEditor = { height: 0.5, isOpen: false };
	              return s2.graphEditor;
	            }
	            function setIsOpen(p2) {
	              _ensure3().isOpen = p2.isOpen;
	            }
	            graphEditor2.setIsOpen = setIsOpen;
	          })(sequenceEditor2.graphEditor || (sequenceEditor2.graphEditor = {}));
	        })(panels2.sequenceEditor || (panels2.sequenceEditor = {}));
	      })(historic2.panels || (historic2.panels = {}));
	      (function(projects2) {
	        (function(stateByProjectId2) {
	          function _ensure(p2) {
	            const s2 = drafts().historic;
	            if (!s2.projects.stateByProjectId[p2.projectId]) {
	              s2.projects.stateByProjectId[p2.projectId] = {
	                stateBySheetId: {}
	              };
	            }
	            return s2.projects.stateByProjectId[p2.projectId];
	          }
	          stateByProjectId2._ensure = _ensure;
	          (function(stateBySheetId2) {
	            function _ensure2(p2) {
	              const projectState = stateEditors2.studio.historic.projects.stateByProjectId._ensure(p2);
	              if (!projectState.stateBySheetId[p2.sheetId]) {
	                projectState.stateBySheetId[p2.sheetId] = {
	                  selectedInstanceId: void 0,
	                  sequenceEditor: {
	                    selectedPropsByObject: {}
	                  }
	                };
	              }
	              return projectState.stateBySheetId[p2.sheetId];
	            }
	            stateBySheetId2._ensure = _ensure2;
	            function setSelectedInstanceId(p2) {
	              stateEditors2.studio.historic.projects.stateByProjectId.stateBySheetId._ensure(p2).selectedInstanceId = p2.sheetInstanceId;
	            }
	            stateBySheetId2.setSelectedInstanceId = setSelectedInstanceId;
	            (function(sequenceEditor2) {
	              function addPropToGraphEditor(p2) {
	                const { selectedPropsByObject } = stateBySheetId2._ensure(p2).sequenceEditor;
	                if (!selectedPropsByObject[p2.objectKey]) {
	                  selectedPropsByObject[p2.objectKey] = {};
	                }
	                const selectedProps = selectedPropsByObject[p2.objectKey];
	                const path = encodePathToProp(p2.pathToProp);
	                const possibleColors = new Set(Object.keys(graphEditorColors));
	                for (const [_2, selectedProps2] of Object.entries(D(selectedPropsByObject))) {
	                  for (const [_3, takenColor] of Object.entries(selectedProps2)) {
	                    possibleColors.delete(takenColor);
	                  }
	                }
	                const color2 = possibleColors.size > 0 ? possibleColors.values().next().value : Object.keys(graphEditorColors)[0];
	                selectedProps[path] = color2;
	              }
	              sequenceEditor2.addPropToGraphEditor = addPropToGraphEditor;
	              function removePropFromGraphEditor(p2) {
	                const { selectedPropsByObject } = stateBySheetId2._ensure(p2).sequenceEditor;
	                if (!selectedPropsByObject[p2.objectKey]) {
	                  return;
	                }
	                const selectedProps = selectedPropsByObject[p2.objectKey];
	                const path = encodePathToProp(p2.pathToProp);
	                if (selectedProps[path]) {
	                  removePathFromObject(selectedPropsByObject, [
	                    p2.objectKey,
	                    path
	                  ]);
	                }
	              }
	              sequenceEditor2.removePropFromGraphEditor = removePropFromGraphEditor;
	            })(stateBySheetId2.sequenceEditor || (stateBySheetId2.sequenceEditor = {}));
	          })(stateByProjectId2.stateBySheetId || (stateByProjectId2.stateBySheetId = {}));
	        })(projects2.stateByProjectId || (projects2.stateByProjectId = {}));
	      })(historic2.projects || (historic2.projects = {}));
	    })(studio4.historic || (studio4.historic = {}));
	    (function(ephemeral2) {
	      (function(projects2) {
	        (function(stateByProjectId2) {
	          function _ensure(p2) {
	            const s2 = drafts().ephemeral;
	            if (!s2.projects.stateByProjectId[p2.projectId]) {
	              s2.projects.stateByProjectId[p2.projectId] = {
	                stateBySheetId: {}
	              };
	            }
	            return s2.projects.stateByProjectId[p2.projectId];
	          }
	          stateByProjectId2._ensure = _ensure;
	          (function(stateBySheetId2) {
	            function _ensure2(p2) {
	              const projectState = stateEditors2.studio.ephemeral.projects.stateByProjectId._ensure(p2);
	              if (!projectState.stateBySheetId[p2.sheetId]) {
	                projectState.stateBySheetId[p2.sheetId] = {
	                  stateByObjectKey: {}
	                };
	              }
	              return projectState.stateBySheetId[p2.sheetId];
	            }
	            stateBySheetId2._ensure = _ensure2;
	            (function(stateByObjectKey2) {
	              function _ensure3(p2) {
	                var _a, _b;
	                const s2 = stateEditors2.studio.ephemeral.projects.stateByProjectId.stateBySheetId._ensure(p2).stateByObjectKey;
	                (_b = s2[_a = p2.objectKey]) != null ? _b : s2[_a] = {};
	                return s2[p2.objectKey];
	              }
	              stateByObjectKey2._ensure = _ensure3;
	              (function(propsBeingScrubbed2) {
	                function _ensure4(p2) {
	                  var _a;
	                  const s2 = stateEditors2.studio.ephemeral.projects.stateByProjectId.stateBySheetId.stateByObjectKey._ensure(p2);
	                  (_a = s2.valuesBeingScrubbed) != null ? _a : s2.valuesBeingScrubbed = {};
	                  return s2.valuesBeingScrubbed;
	                }
	                propsBeingScrubbed2._ensure = _ensure4;
	                function flag(p2) {
	                  set_default(_ensure4(p2), p2.pathToProp, true);
	                }
	                propsBeingScrubbed2.flag = flag;
	              })(stateByObjectKey2.propsBeingScrubbed || (stateByObjectKey2.propsBeingScrubbed = {}));
	            })(stateBySheetId2.stateByObjectKey || (stateBySheetId2.stateByObjectKey = {}));
	          })(stateByProjectId2.stateBySheetId || (stateByProjectId2.stateBySheetId = {}));
	        })(projects2.stateByProjectId || (projects2.stateByProjectId = {}));
	      })(ephemeral2.projects || (ephemeral2.projects = {}));
	    })(studio4.ephemeral || (studio4.ephemeral = {}));
	    (function(ahistoric2) {
	      function setVisibilityState(visibilityState) {
	        drafts().ahistoric.visibilityState = visibilityState;
	      }
	      ahistoric2.setVisibilityState = setVisibilityState;
	      (function(projects2) {
	        (function(stateByProjectId2) {
	          function _ensure(p2) {
	            const s2 = drafts().ahistoric;
	            if (!s2.projects.stateByProjectId[p2.projectId]) {
	              s2.projects.stateByProjectId[p2.projectId] = {
	                stateBySheetId: {}
	              };
	            }
	            return s2.projects.stateByProjectId[p2.projectId];
	          }
	          stateByProjectId2._ensure = _ensure;
	          (function(stateBySheetId2) {
	            function _ensure2(p2) {
	              const projectState = stateEditors2.studio.ahistoric.projects.stateByProjectId._ensure(p2);
	              if (!projectState.stateBySheetId[p2.sheetId]) {
	                projectState.stateBySheetId[p2.sheetId] = {};
	              }
	              return projectState.stateBySheetId[p2.sheetId];
	            }
	            stateBySheetId2._ensure = _ensure2;
	            (function(sequence2) {
	              function _ensure3(p2) {
	                const sheetState = stateEditors2.studio.ahistoric.projects.stateByProjectId.stateBySheetId._ensure(p2);
	                if (!sheetState.sequence) {
	                  sheetState.sequence = {};
	                }
	                return sheetState.sequence;
	              }
	              sequence2._ensure = _ensure3;
	              (function(clippedSpaceRange2) {
	                function set2(p2) {
	                  stateEditors2.studio.ahistoric.projects.stateByProjectId.stateBySheetId.sequence._ensure(p2).clippedSpaceRange = __spreadValues({}, p2.range);
	                }
	                clippedSpaceRange2.set = set2;
	              })(sequence2.clippedSpaceRange || (sequence2.clippedSpaceRange = {}));
	            })(stateBySheetId2.sequence || (stateBySheetId2.sequence = {}));
	          })(stateByProjectId2.stateBySheetId || (stateByProjectId2.stateBySheetId = {}));
	        })(projects2.stateByProjectId || (projects2.stateByProjectId = {}));
	      })(ahistoric2.projects || (ahistoric2.projects = {}));
	    })(studio4.ahistoric || (studio4.ahistoric = {}));
	  })(stateEditors2.studio || (stateEditors2.studio = {}));
	  (function(coreByProject2) {
	    (function(historic2) {
	      (function(revisionHistory2) {
	        function add(p2) {
	          const revisionHistory3 = drafts().historic.coreByProject[p2.projectId].revisionHistory;
	          const maxNumOfRevisionsToKeep = 50;
	          revisionHistory3.unshift(p2.revision);
	          if (revisionHistory3.length > maxNumOfRevisionsToKeep) {
	            revisionHistory3.length = maxNumOfRevisionsToKeep;
	          }
	        }
	        revisionHistory2.add = add;
	      })(historic2.revisionHistory || (historic2.revisionHistory = {}));
	      (function(sheetsById2) {
	        function _ensure(p2) {
	          const sheetsById3 = drafts().historic.coreByProject[p2.projectId].sheetsById;
	          if (!sheetsById3[p2.sheetId]) {
	            sheetsById3[p2.sheetId] = { staticOverrides: { byObject: {} } };
	          }
	          return sheetsById3[p2.sheetId];
	        }
	        sheetsById2._ensure = _ensure;
	        (function(sequence2) {
	          function _ensure2(p2) {
	            var _a;
	            const s2 = stateEditors2.coreByProject.historic.sheetsById._ensure(p2);
	            (_a = s2.sequence) != null ? _a : s2.sequence = {
	              subUnitsPerUnit: 30,
	              length: 10,
	              type: "PositionalSequence",
	              tracksByObject: {}
	            };
	            return s2.sequence;
	          }
	          sequence2._ensure = _ensure2;
	          function setLength(p2) {
	            _ensure2(p2).length = parseFloat(p2.length.toFixed(2));
	          }
	          sequence2.setLength = setLength;
	          function _ensureTracksOfObject(p2) {
	            var _a, _b;
	            const s2 = stateEditors2.coreByProject.historic.sheetsById.sequence._ensure(p2).tracksByObject;
	            (_b = s2[_a = p2.objectKey]) != null ? _b : s2[_a] = { trackData: {}, trackIdByPropPath: {} };
	            return s2[p2.objectKey];
	          }
	          function setPrimitivePropAsSequenced(p2) {
	            const tracks = _ensureTracksOfObject(p2);
	            const pathEncoded = encodePathToProp(p2.pathToProp);
	            const possibleTrackId = tracks.trackIdByPropPath[pathEncoded];
	            if (typeof possibleTrackId === "string")
	              return;
	            const trackId = generateSequenceTrackId();
	            tracks.trackData[trackId] = {
	              type: "BasicKeyframedTrack",
	              keyframes: []
	            };
	            tracks.trackIdByPropPath[pathEncoded] = trackId;
	          }
	          sequence2.setPrimitivePropAsSequenced = setPrimitivePropAsSequenced;
	          function setPrimitivePropAsStatic(p2) {
	            const tracks = _ensureTracksOfObject(p2);
	            const encodedPropPath = JSON.stringify(p2.pathToProp);
	            const trackId = tracks.trackIdByPropPath[encodedPropPath];
	            if (typeof trackId !== "string")
	              return;
	            delete tracks.trackIdByPropPath[encodedPropPath];
	            delete tracks.trackData[trackId];
	            stateEditors2.coreByProject.historic.sheetsById.staticOverrides.byObject.setValueOfPrimitiveProp(p2);
	          }
	          sequence2.setPrimitivePropAsStatic = setPrimitivePropAsStatic;
	          function setCompoundPropAsStatic(p2) {
	            const tracks = _ensureTracksOfObject(p2);
	            for (const encodedPropPath of Object.keys(tracks.trackIdByPropPath)) {
	              const propPath = JSON.parse(encodedPropPath);
	              const isSubOfTargetPath = p2.pathToProp.every((key, i2) => propPath[i2] === key);
	              if (isSubOfTargetPath) {
	                const trackId = tracks.trackIdByPropPath[encodedPropPath];
	                if (typeof trackId !== "string")
	                  continue;
	                delete tracks.trackIdByPropPath[encodedPropPath];
	                delete tracks.trackData[trackId];
	              }
	            }
	            stateEditors2.coreByProject.historic.sheetsById.staticOverrides.byObject.setValueOfCompoundProp(p2);
	          }
	          sequence2.setCompoundPropAsStatic = setCompoundPropAsStatic;
	          function _getTrack(p2) {
	            return _ensureTracksOfObject(p2).trackData[p2.trackId];
	          }
	          function setKeyframeAtPosition(p2) {
	            const position2 = p2.snappingFunction(p2.position);
	            const track = _getTrack(p2);
	            if (!track)
	              return;
	            const { keyframes } = track;
	            const existingKeyframeIndex = keyframes.findIndex((kf) => kf.position === position2);
	            if (existingKeyframeIndex !== -1) {
	              const kf = keyframes[existingKeyframeIndex];
	              kf.value = p2.value;
	              return;
	            }
	            const indexOfLeftKeyframe = findLastIndex_default(keyframes, (kf) => kf.position < position2);
	            if (indexOfLeftKeyframe === -1) {
	              keyframes.unshift({
	                id: generateKeyframeId(),
	                position: position2,
	                connectedRight: true,
	                handles: [0.5, 1, 0.5, 0],
	                value: p2.value
	              });
	              return;
	            }
	            const leftKeyframe = keyframes[indexOfLeftKeyframe];
	            keyframes.splice(indexOfLeftKeyframe + 1, 0, {
	              id: generateKeyframeId(),
	              position: position2,
	              connectedRight: leftKeyframe.connectedRight,
	              handles: [0.5, 1, 0.5, 0],
	              value: p2.value
	            });
	          }
	          sequence2.setKeyframeAtPosition = setKeyframeAtPosition;
	          function unsetKeyframeAtPosition(p2) {
	            const track = _getTrack(p2);
	            if (!track)
	              return;
	            const { keyframes } = track;
	            const index = keyframes.findIndex((kf) => kf.position === p2.position);
	            if (index === -1)
	              return;
	            keyframes.splice(index, 1);
	          }
	          sequence2.unsetKeyframeAtPosition = unsetKeyframeAtPosition;
	          function transformKeyframes(p2) {
	            const track = _getTrack(p2);
	            if (!track)
	              return;
	            const initialKeyframes = D(track.keyframes);
	            const selectedKeyframes = initialKeyframes.filter((kf) => p2.keyframeIds.indexOf(kf.id) !== -1);
	            const transformed = selectedKeyframes.map((untransformedKf) => {
	              const oldPosition = untransformedKf.position;
	              const newPosition = p2.snappingFunction(transformNumber(oldPosition, p2));
	              return __spreadProps(__spreadValues({}, untransformedKf), { position: newPosition });
	            });
	            replaceKeyframes(__spreadProps(__spreadValues({}, p2), { keyframes: transformed }));
	          }
	          sequence2.transformKeyframes = transformKeyframes;
	          function deleteKeyframes(p2) {
	            const track = _getTrack(p2);
	            if (!track)
	              return;
	            track.keyframes = track.keyframes.filter((kf) => p2.keyframeIds.indexOf(kf.id) === -1);
	          }
	          sequence2.deleteKeyframes = deleteKeyframes;
	          function replaceKeyframes(p2) {
	            const track = _getTrack(p2);
	            if (!track)
	              return;
	            const initialKeyframes = D(track.keyframes);
	            const sanitizedKeyframes = p2.keyframes.filter((kf) => {
	              if (!isFinite(kf.value))
	                return false;
	              if (!kf.handles.every((handleValue) => isFinite(handleValue)))
	                return false;
	              return true;
	            }).map((kf) => __spreadProps(__spreadValues({}, kf), { position: p2.snappingFunction(kf.position) }));
	            const newKeyframesById = keyBy_default(sanitizedKeyframes, "id");
	            const unselected = initialKeyframes.filter((kf) => !newKeyframesById[kf.id]);
	            const unselectedByPosition = keyBy_default(unselected, "position");
	            sanitizedKeyframes.forEach(({ position: position2 }) => {
	              const existingKeyframeAtThisPosition = unselectedByPosition[position2];
	              if (existingKeyframeAtThisPosition) {
	                pull_default(unselected, existingKeyframeAtThisPosition);
	              }
	            });
	            const sorted = sortBy_default([...unselected, ...sanitizedKeyframes], "position");
	            track.keyframes = sorted;
	          }
	          sequence2.replaceKeyframes = replaceKeyframes;
	        })(sheetsById2.sequence || (sheetsById2.sequence = {}));
	        (function(staticOverrides2) {
	          (function(byObject2) {
	            function _ensure2(p2) {
	              var _a, _b;
	              const byObject3 = stateEditors2.coreByProject.historic.sheetsById._ensure(p2).staticOverrides.byObject;
	              (_b = byObject3[_a = p2.objectKey]) != null ? _b : byObject3[_a] = {};
	              return byObject3[p2.objectKey];
	            }
	            function setValueOfCompoundProp(p2) {
	              const existingOverrides = _ensure2(p2);
	              set_default(existingOverrides, p2.pathToProp, p2.value);
	            }
	            byObject2.setValueOfCompoundProp = setValueOfCompoundProp;
	            function setValueOfPrimitiveProp(p2) {
	              const existingOverrides = _ensure2(p2);
	              set_default(existingOverrides, p2.pathToProp, p2.value);
	            }
	            byObject2.setValueOfPrimitiveProp = setValueOfPrimitiveProp;
	            function unsetValueOfPrimitiveProp(p2) {
	              const existingStaticOverrides = stateEditors2.coreByProject.historic.sheetsById._ensure(p2).staticOverrides.byObject[p2.objectKey];
	              if (!existingStaticOverrides)
	                return;
	              removePathFromObject(existingStaticOverrides, p2.pathToProp);
	            }
	            byObject2.unsetValueOfPrimitiveProp = unsetValueOfPrimitiveProp;
	          })(staticOverrides2.byObject || (staticOverrides2.byObject = {}));
	        })(sheetsById2.staticOverrides || (sheetsById2.staticOverrides = {}));
	      })(historic2.sheetsById || (historic2.sheetsById = {}));
	    })(coreByProject2.historic || (coreByProject2.historic = {}));
	  })(stateEditors2.coreByProject || (stateEditors2.coreByProject = {}));
	})(stateEditors || (stateEditors = {}));

	// shared/src/utils/defer.ts
	function defer() {
	  let resolve;
	  let reject;
	  const promise = new Promise((rs, rj) => {
	    resolve = (v2) => {
	      rs(v2);
	      deferred.status = "resolved";
	    };
	    reject = (v2) => {
	      rj(v2);
	      deferred.status = "rejected";
	    };
	  });
	  const deferred = {
	    resolve,
	    reject,
	    promise,
	    status: "pending"
	  };
	  return deferred;
	}

	// studio/src/utils/redux/atomFromReduxStore.ts
	var import_dataverse49 = __toModule(dist$1);
	function atomFromReduxStore(store) {
	  let lastState = store.getState();
	  const a2 = new import_dataverse49.Atom(lastState);
	  store.subscribe(() => {
	    const newState = store.getState();
	    a2.setState(newState);
	    lastState = newState;
	  });
	  return a2;
	}

	// ../node_modules/symbol-observable/es/ponyfill.js
	function symbolObservablePonyfill(root3) {
	  var result2;
	  var Symbol3 = root3.Symbol;
	  if (typeof Symbol3 === "function") {
	    if (Symbol3.observable) {
	      result2 = Symbol3.observable;
	    } else {
	      result2 = Symbol3("observable");
	      Symbol3.observable = result2;
	    }
	  } else {
	    result2 = "@@observable";
	  }
	  return result2;
	}

	// ../node_modules/symbol-observable/es/index.js
	var root2;
	if (typeof self !== "undefined") {
	  root2 = self;
	} else if (typeof window !== "undefined") {
	  root2 = window;
	} else if (typeof window !== "undefined") {
	  root2 = window;
	} else {
	  root2 = module;
	}
	var result = symbolObservablePonyfill(root2);
	var es_default = result;

	// ../node_modules/redux/es/createStore.js
	var ActionTypes = {
	  INIT: "@@redux/INIT"
	};
	function createStore(reducer, preloadedState, enhancer) {
	  var _ref2;
	  if (typeof preloadedState === "function" && typeof enhancer === "undefined") {
	    enhancer = preloadedState;
	    preloadedState = void 0;
	  }
	  if (typeof enhancer !== "undefined") {
	    if (typeof enhancer !== "function") {
	      throw new Error("Expected the enhancer to be a function.");
	    }
	    return enhancer(createStore)(reducer, preloadedState);
	  }
	  if (typeof reducer !== "function") {
	    throw new Error("Expected the reducer to be a function.");
	  }
	  var currentReducer = reducer;
	  var currentState = preloadedState;
	  var currentListeners = [];
	  var nextListeners = currentListeners;
	  var isDispatching = false;
	  function ensureCanMutateNextListeners() {
	    if (nextListeners === currentListeners) {
	      nextListeners = currentListeners.slice();
	    }
	  }
	  function getState() {
	    return currentState;
	  }
	  function subscribe(listener) {
	    if (typeof listener !== "function") {
	      throw new Error("Expected listener to be a function.");
	    }
	    var isSubscribed = true;
	    ensureCanMutateNextListeners();
	    nextListeners.push(listener);
	    return function unsubscribe() {
	      if (!isSubscribed) {
	        return;
	      }
	      isSubscribed = false;
	      ensureCanMutateNextListeners();
	      var index = nextListeners.indexOf(listener);
	      nextListeners.splice(index, 1);
	    };
	  }
	  function dispatch(action) {
	    if (!isPlainObject_default(action)) {
	      throw new Error("Actions must be plain objects. Use custom middleware for async actions.");
	    }
	    if (typeof action.type === "undefined") {
	      throw new Error('Actions may not have an undefined "type" property. Have you misspelled a constant?');
	    }
	    if (isDispatching) {
	      throw new Error("Reducers may not dispatch actions.");
	    }
	    try {
	      isDispatching = true;
	      currentState = currentReducer(currentState, action);
	    } finally {
	      isDispatching = false;
	    }
	    var listeners = currentListeners = nextListeners;
	    for (var i2 = 0; i2 < listeners.length; i2++) {
	      var listener = listeners[i2];
	      listener();
	    }
	    return action;
	  }
	  function replaceReducer(nextReducer) {
	    if (typeof nextReducer !== "function") {
	      throw new Error("Expected the nextReducer to be a function.");
	    }
	    currentReducer = nextReducer;
	    dispatch({ type: ActionTypes.INIT });
	  }
	  function observable() {
	    var _ref;
	    var outerSubscribe = subscribe;
	    return _ref = {
	      subscribe: function subscribe2(observer) {
	        if (typeof observer !== "object") {
	          throw new TypeError("Expected the observer to be an object.");
	        }
	        function observeState() {
	          if (observer.next) {
	            observer.next(getState());
	          }
	        }
	        observeState();
	        var unsubscribe = outerSubscribe(observeState);
	        return { unsubscribe };
	      }
	    }, _ref[es_default] = function() {
	      return this;
	    }, _ref;
	  }
	  dispatch({ type: ActionTypes.INIT });
	  return _ref2 = {
	    dispatch,
	    subscribe,
	    getState,
	    replaceReducer
	  }, _ref2[es_default] = observable, _ref2;
	}

	// ../node_modules/redux/es/utils/warning.js
	function warning2(message) {
	  if (typeof console !== "undefined" && typeof console.error === "function") {
	    console.error(message);
	  }
	  try {
	    throw new Error(message);
	  } catch (e) {
	  }
	}

	// ../node_modules/redux/es/compose.js
	function compose() {
	  for (var _len = arguments.length, funcs = Array(_len), _key = 0; _key < _len; _key++) {
	    funcs[_key] = arguments[_key];
	  }
	  if (funcs.length === 0) {
	    return function(arg) {
	      return arg;
	    };
	  }
	  if (funcs.length === 1) {
	    return funcs[0];
	  }
	  return funcs.reduce(function(a2, b2) {
	    return function() {
	      return a2(b2.apply(void 0, arguments));
	    };
	  });
	}

	// ../node_modules/redux/es/index.js
	function isCrushed() {
	}
	if (typeof isCrushed.name === "string" && isCrushed.name !== "isCrushed") {
	  warning2("You are currently using minified code outside of NODE_ENV === 'production'. This means that you are running a slower development build of Redux. You can use loose-envify (https://github.com/zertosh/loose-envify) for browserify or DefinePlugin for webpack (http://stackoverflow.com/questions/30030031) to ensure you have the correct code for your production build.");
	}

	// studio/src/utils/redux/configureStore.ts
	function configureStore(conf) {
	  const enhancers = [];
	  {
	    const devtoolsEnhancer = typeof window === "object" && window.__REDUX_DEVTOOLS_EXTENSION__ ? window.__REDUX_DEVTOOLS_EXTENSION__(conf.devtoolsOptions) : identity_default;
	    enhancers.push(devtoolsEnhancer);
	  }
	  const enhancer = compose(...enhancers);
	  const store = createStore(conf.rootReducer, void 0, enhancer);
	  return store;
	}

	// studio/src/StudioStore/StudioStore.ts
	var import_dataverse50 = __toModule(dist$1);

	// studio/src/StudioStore/persistStateOfStudio.ts
	var persistStateOfStudio = (reduxStore, onInitialize, localStoragePrefix) => {
	  const loadState = (s2) => {
	    reduxStore.dispatch(studioActions.replacePersistentState(s2));
	  };
	  const storageKey = localStoragePrefix + ".persistent";
	  const getState = () => reduxStore.getState().$persistent;
	  loadFromPersistentStorage();
	  let lastState = getState();
	  const persist = () => {
	    const newState = getState();
	    if (newState === lastState)
	      return;
	    lastState = newState;
	    localStorage.setItem(storageKey, JSON.stringify(newState));
	  };
	  reduxStore.subscribe(debounce_default(persist, 1e3));
	  if (window) {
	    window.addEventListener("beforeunload", persist);
	  }
	  function loadFromPersistentStorage() {
	    const persistedS = localStorage.getItem(storageKey);
	    if (persistedS) {
	      let persistedObj;
	      let errored = true;
	      try {
	        persistedObj = JSON.parse(persistedS);
	        errored = false;
	      } catch (e) {
	        logger_default.warn(`Could not parse Theatre's persisted state. This must be a bug. Please report it.`);
	      } finally {
	        if (!errored) {
	          loadState(persistedObj);
	        }
	        onInitialize();
	      }
	    } else {
	      onInitialize();
	    }
	  }
	};

	// studio/src/StudioStore/StudioStore.ts
	var StudioStore = class {
	  constructor() {
	    __publicField(this, "_reduxStore");
	    __publicField(this, "_atom");
	    __publicField(this, "atomP");
	    this._reduxStore = configureStore({
	      rootReducer: studioReducer,
	      devtoolsOptions: { name: "Theatre.js Studio" }
	    });
	    this._atom = atomFromReduxStore(this._reduxStore);
	    this.atomP = this._atom.pointer;
	  }
	  initialize(opts) {
	    const d2 = defer();
	    if (opts.usePersistentStorage === true) {
	      persistStateOfStudio(this._reduxStore, () => {
	        this.tempTransaction(({ drafts: drafts2 }) => {
	          drafts2.ephemeral.initialised = true;
	        }).commit();
	        d2.resolve();
	      }, opts.persistenceKey);
	    } else {
	      this.tempTransaction(({ drafts: drafts2 }) => {
	        drafts2.ephemeral.initialised = true;
	      }).commit();
	      d2.resolve();
	    }
	    return d2.promise;
	  }
	  getState() {
	    return this._reduxStore.getState();
	  }
	  __dev_startHistoryFromScratch(newHistoricPart) {
	    this._reduxStore.dispatch(studioActions.historic.startHistoryFromScratch(studioActions.reduceParts((s2) => __spreadProps(__spreadValues({}, s2), { historic: newHistoricPart }))));
	  }
	  tempTransaction(fn2) {
	    const group = tempActionGroup();
	    let errorDuringTransaction;
	    const action = group.push(studioActions.reduceParts((wholeState) => {
	      const drafts2 = {
	        historic: ln(wholeState.historic),
	        ahistoric: ln(wholeState.ahistoric),
	        ephemeral: ln(wholeState.ephemeral)
	      };
	      let running = true;
	      let ensureRunning = () => {
	        if (!running) {
	          throw new Error(`You seem to have called the transaction api after studio.transaction() has finished running`);
	        }
	      };
	      const api = {
	        set: (pointer2, value) => {
	          ensureRunning();
	          const { root: root3 } = (0, import_dataverse50.getPointerParts)(pointer2);
	          if (isSheetObject(root3)) {
	            root3.validateValue(pointer2, value);
	            const sequenceTracksTree = (0, import_dataverse50.val)(root3.template.getMapOfValidSequenceTracks_forStudio().getValue());
	            forEachDeep(value, (v2, pathToProp) => {
	              if (typeof v2 === "undefined" || v2 === null) {
	                return;
	              }
	              const propAddress = __spreadProps(__spreadValues({}, root3.address), { pathToProp });
	              const trackId = get_default(sequenceTracksTree, pathToProp);
	              if (typeof trackId === "string") {
	                const seq = root3.sheet.getSequence();
	                seq.position = seq.closestGridPosition(seq.position);
	                stateEditors2.coreByProject.historic.sheetsById.sequence.setKeyframeAtPosition(__spreadProps(__spreadValues({}, propAddress), {
	                  trackId,
	                  position: seq.position,
	                  value: v2,
	                  snappingFunction: seq.closestGridPosition
	                }));
	              } else {
	                stateEditors2.coreByProject.historic.sheetsById.staticOverrides.byObject.setValueOfPrimitiveProp(__spreadProps(__spreadValues({}, propAddress), { value: v2 }));
	              }
	            }, (0, import_dataverse50.getPointerParts)(pointer2).path);
	          } else {
	            throw new Error("Only setting props of SheetObject-s is supported in a transaction so far");
	          }
	        },
	        unset: (pointer2) => {
	          ensureRunning();
	          const { root: root3, path } = (0, import_dataverse50.getPointerParts)(pointer2);
	          if (isSheetObject(root3)) {
	            const sequenceTracksTree = (0, import_dataverse50.val)(root3.template.getMapOfValidSequenceTracks_forStudio().getValue());
	            const defaultValue = getDeep(root3.template.getDefaultValues().getValue(), path);
	            forEachDeep(defaultValue, (v2, pathToProp) => {
	              const propAddress = __spreadProps(__spreadValues({}, root3.address), { pathToProp });
	              const trackId = get_default(sequenceTracksTree, pathToProp);
	              if (typeof trackId === "string") {
	                stateEditors2.coreByProject.historic.sheetsById.sequence.unsetKeyframeAtPosition(__spreadProps(__spreadValues({}, propAddress), {
	                  trackId,
	                  position: root3.sheet.getSequence().positionSnappedToGrid
	                }));
	              } else {
	                stateEditors2.coreByProject.historic.sheetsById.staticOverrides.byObject.unsetValueOfPrimitiveProp(propAddress);
	              }
	            }, (0, import_dataverse50.getPointerParts)(pointer2).path);
	          } else {
	            throw new Error("Only setting props of SheetObject-s is supported in a transaction so far");
	          }
	        },
	        get drafts() {
	          ensureRunning();
	          return drafts2;
	        },
	        get stateEditors() {
	          return stateEditors2;
	        }
	      };
	      const stateEditors2 = setDrafts__onlyMeantToBeCalledByTransaction(drafts2);
	      try {
	        fn2(api);
	        running = false;
	        return {
	          historic: dn(drafts2.historic),
	          ahistoric: dn(drafts2.ahistoric),
	          ephemeral: dn(drafts2.ephemeral)
	        };
	      } catch (err) {
	        errorDuringTransaction = err;
	        return wholeState;
	      } finally {
	        setDrafts__onlyMeantToBeCalledByTransaction(void 0);
	      }
	    }));
	    this._reduxStore.dispatch(action);
	    if (errorDuringTransaction) {
	      this._reduxStore.dispatch(group.discard());
	      throw errorDuringTransaction;
	    }
	    return {
	      commit: () => {
	        this._reduxStore.dispatch(group.commit());
	      },
	      discard: () => {
	        this._reduxStore.dispatch(group.discard());
	      }
	    };
	  }
	  undo() {
	    this._reduxStore.dispatch(studioActions.historic.undo());
	  }
	  redo() {
	    this._reduxStore.dispatch(studioActions.historic.redo());
	  }
	  createContentOfSaveFile(projectId) {
	    const projectState = this._reduxStore.getState().$persistent.historic.innerState.coreByProject[projectId];
	    if (!projectState) {
	      throw new Error(`Project ${projectId} has not been initialized.`);
	    }
	    const revision = generateDiskStateRevision();
	    this.tempTransaction(({ stateEditors: stateEditors2 }) => {
	      stateEditors2.coreByProject.historic.revisionHistory.add({
	        projectId,
	        revision
	      });
	    }).commit();
	    const projectHistoricState = this._reduxStore.getState().$persistent.historic.innerState.coreByProject[projectId];
	    const generatedOnDiskState = __spreadValues({}, projectHistoricState);
	    return generatedOnDiskState;
	  }
	};

	// studio/src/TheatreStudio.ts
	var import_dataverse51 = __toModule(dist$1);

	// shared/src/utils/SimpleCache.ts
	var SimpleCache = class {
	  constructor() {
	    __publicField(this, "_values", {});
	  }
	  get(key, producer) {
	    if (this.has(key)) {
	      return this._values[key];
	    } else {
	      const cachedValue = producer();
	      this._values[key] = cachedValue;
	      return cachedValue;
	    }
	  }
	  has(key) {
	    return this._values.hasOwnProperty(key);
	  }
	};

	// studio/src/TheatreStudio.ts
	var TheatreStudio = class {
	  constructor(internals) {
	    __publicField(this, "ui", {
	      hide() {
	        getStudio().ui.hide();
	      },
	      get isHidden() {
	        return getStudio().ui.isHidden;
	      },
	      restore() {
	        getStudio().ui.restore();
	      }
	    });
	    __publicField(this, "_cache", new SimpleCache());
	  }
	  initialize(opts) {
	    const studio3 = getStudio();
	    return studio3.initialize(opts);
	  }
	  extend(extension) {
	    getStudio().extend(extension);
	  }
	  transaction(fn2) {
	    return getStudio().transaction(({ set: set2, unset }) => {
	      return fn2({ set: set2, unset });
	    });
	  }
	  _getSelectionDerivation() {
	    return this._cache.get("_getStateDerivation()", () => (0, import_dataverse51.prism)(() => {
	      return getOutlineSelection().filter((s2) => s2.type === "Theatre_SheetObject" || s2.type === "Theatre_Sheet").map((s2) => s2.publicApi);
	    }));
	  }
	  _getSelection() {
	    return this._getSelectionDerivation().getValue();
	  }
	  setSelection(selection) {
	    const sanitizedSelection = [...selection].filter((s2) => isSheetObjectPublicAPI(s2) || isSheetPublicAPI(s2)).map((s2) => getStudio().corePrivateAPI(s2));
	    getStudio().transaction(({ stateEditors: stateEditors2 }) => {
	      stateEditors2.studio.historic.panels.outline.selection.set(sanitizedSelection);
	    });
	  }
	  onSelectionChange(fn2) {
	    return this._getSelectionDerivation().tapImmediate(studioTicker_default, fn2);
	  }
	  get selection() {
	    return this._getSelection();
	  }
	  scrub() {
	    return getStudio().scrub();
	  }
	  getStudioProject() {
	    const core = getStudio().core;
	    if (!core) {
	      throw new Error(`You're calling studio.getStudioProject() before \`@theatre/core\` is loaded. To fix this:
1. Check if \`@theatre/core\` is import/required in your bundle.
2. Check the stack trace of this error and make sure the funciton that calls getStudioProject() is run after \`@theatre/core\` is loaded.`);
	    }
	    return getStudio().getStudioProject(core);
	  }
	  debouncedScrub(threshold = 1e3) {
	    let currentScrub;
	    const scheduleCommit = debounce_default(() => {
	      const s2 = currentScrub;
	      if (!s2)
	        return;
	      currentScrub = void 0;
	      s2.commit();
	    }, threshold);
	    const capture = (arg) => {
	      if (!currentScrub) {
	        currentScrub = this.scrub();
	      }
	      let errored = true;
	      try {
	        currentScrub.capture(arg);
	        errored = false;
	      } finally {
	        if (errored) {
	          const s2 = currentScrub;
	          currentScrub = void 0;
	          s2.discard();
	        } else {
	          scheduleCommit();
	        }
	      }
	    };
	    return { capture };
	  }
	  createPane(paneClass) {
	    return getStudio().paneManager.createPane(paneClass);
	  }
	  destroyPane(paneId) {
	    return getStudio().paneManager.destroyPane(paneId);
	  }
	  createContentOfSaveFile(projectId) {
	    return getStudio().createContentOfSaveFile(projectId);
	  }
	};

	// studio/src/PaneManager.ts
	var import_dataverse52 = __toModule(dist$1);
	var PaneManager = class {
	  constructor(_studio) {
	    this._studio = _studio;
	    __publicField(this, "_cache", new SimpleCache());
	    this._instantiatePanesAsTheyComeIn();
	  }
	  _instantiatePanesAsTheyComeIn() {
	    const allPanesD = this._getAllPanes();
	    allPanesD.changesWithoutValues().tap(() => {
	      allPanesD.getValue();
	    });
	  }
	  _getAllPanes() {
	    return this._cache.get("_getAllPanels()", () => (0, import_dataverse52.prism)(() => {
	      const core = (0, import_dataverse52.val)(this._studio.coreP);
	      if (!core)
	        return {};
	      const instanceDescriptors = (0, import_dataverse52.val)(this._studio.atomP.historic.panelInstanceDesceriptors);
	      const paneClasses = (0, import_dataverse52.val)(this._studio.atomP.ephemeral.extensions.paneClasses);
	      const instances = {};
	      for (const [, instanceDescriptor] of Object.entries(instanceDescriptors)) {
	        const panelClass = paneClasses[instanceDescriptor.paneClass];
	        if (!panelClass)
	          continue;
	        const { instanceId } = instanceDescriptor;
	        const { extensionId, classDefinition: definition } = panelClass;
	        const instance = import_dataverse52.prism.memo(`instance-${instanceDescriptor.instanceId}`, () => {
	          const inst = {
	            extensionId,
	            instanceId,
	            definition
	          };
	          return inst;
	        }, emptyArray);
	        instances[instanceId] = instance;
	      }
	      return instances;
	    }));
	  }
	  get allPanesD() {
	    return this._getAllPanes();
	  }
	  createPane(paneClass) {
	    const core = this._studio.core;
	    if (!core) {
	      throw new Error(`Can't create a pane because @theatre/core is not yet loaded`);
	    }
	    const extensionId = (0, import_dataverse52.val)(this._studio.atomP.ephemeral.extensions.paneClasses[paneClass].extensionId);
	    const allPaneInstances = (0, import_dataverse52.val)(this._studio.atomP.historic.panelInstanceDesceriptors);
	    let instanceId;
	    for (let i2 = 1; i2 < 1e3; i2++) {
	      instanceId = `${paneClass} #${i2}`;
	      if (!allPaneInstances[instanceId])
	        break;
	    }
	    if (!extensionId) {
	      throw new Error(`Pance class "${paneClass}" is not registered.`);
	    }
	    this._studio.transaction(({ drafts: drafts2 }) => {
	      drafts2.historic.panelInstanceDesceriptors[instanceId] = {
	        instanceId,
	        paneClass
	      };
	    });
	    return this._getAllPanes().getValue()[instanceId];
	  }
	  destroyPane(instanceId) {
	    const core = this._studio.core;
	    if (!core) {
	      throw new Error(`Can't do this yet because @theatre/core is not yet loaded`);
	    }
	    this._studio.transaction(({ drafts: drafts2 }) => {
	      delete drafts2.historic.panelInstanceDesceriptors[instanceId];
	    });
	  }
	};

	// studio/src/Studio.ts
	var Studio = class {
	  constructor() {
	    __publicField(this, "ui");
	    __publicField(this, "publicApi");
	    __publicField(this, "address");
	    __publicField(this, "_projectsProxy", new import_dataverse53.PointerProxy(new import_dataverse53.Atom({}).pointer));
	    __publicField(this, "projectsP", this._projectsProxy.pointer);
	    __publicField(this, "_store", new StudioStore());
	    __publicField(this, "_corePrivateApi");
	    __publicField(this, "_cache", new SimpleCache());
	    __publicField(this, "paneManager");
	    __publicField(this, "_coreAtom", new import_dataverse53.Atom({}));
	    __publicField(this, "_initializedDeferred", defer());
	    __publicField(this, "_initializeFnCalled", false);
	    this.address = { studioId: nanoid2(10) };
	    this.publicApi = new TheatreStudio(this);
	    {
	      this.ui = new UI(this);
	    }
	    this._attachToIncomingProjects();
	    this.paneManager = new PaneManager(this);
	  }
	  get atomP() {
	    return this._store.atomP;
	  }
	  initialize(opts) {
	    return __async(this, null, function* () {
	      if (this._initializeFnCalled) {
	        return this._initializedDeferred.promise;
	      }
	      const storeOpts = {
	        persistenceKey: "theatre-0.4",
	        usePersistentStorage: true
	      };
	      if (typeof (opts == null ? void 0 : opts.persistenceKey) === "string") {
	        storeOpts.persistenceKey = opts.persistenceKey;
	      }
	      if ((opts == null ? void 0 : opts.usePersistentStorage) === false) {
	        storeOpts.usePersistentStorage = false;
	      }
	      try {
	        yield this._store.initialize(storeOpts);
	      } catch (e) {
	        this._initializedDeferred.reject(e);
	        return;
	      }
	      this._initializedDeferred.resolve();
	      {
	        this.ui.render();
	      }
	    });
	  }
	  get initialized() {
	    return this._initializedDeferred.promise;
	  }
	  _attachToIncomingProjects() {
	    const projectsD = (0, import_dataverse53.valueDerivation)(this.projectsP);
	    const attachToProjects = (projects) => {
	      for (const project of Object.values(projects)) {
	        if (!project.isAttachedToStudio) {
	          project.attachToStudio(this);
	        }
	      }
	    };
	    projectsD.changesWithoutValues().tap(() => {
	      attachToProjects(projectsD.getValue());
	    });
	    attachToProjects(projectsD.getValue());
	  }
	  setCoreBits(coreBits) {
	    this._corePrivateApi = coreBits.privateAPI;
	    this._coreAtom.setIn(["core"], coreBits.coreExports);
	    this._setProjectsP(coreBits.projectsP);
	  }
	  _setProjectsP(projectsP) {
	    this._projectsProxy.setPointer(projectsP);
	  }
	  scrub() {
	    return new Scrub(this);
	  }
	  tempTransaction(fn2) {
	    return this._store.tempTransaction(fn2);
	  }
	  transaction(fn2) {
	    return this.tempTransaction(fn2).commit();
	  }
	  __dev_startHistoryFromScratch(newHistoricPart) {
	    return this._store.__dev_startHistoryFromScratch(newHistoricPart);
	  }
	  get corePrivateAPI() {
	    return this._corePrivateApi;
	  }
	  get core() {
	    return this._coreAtom.getState().core;
	  }
	  get coreP() {
	    return this._coreAtom.pointer.core;
	  }
	  extend(extension) {
	    if (!extension || typeof extension !== "object") {
	      throw new Error(`Extensions must be JS objects`);
	    }
	    if (typeof extension.id !== "string") {
	      throw new Error(`extension.id must be a string`);
	    }
	    this.transaction(({ drafts: drafts2 }) => {
	      var _a;
	      if (drafts2.ephemeral.extensions.byId[extension.id]) {
	        throw new Error(`Extension id "${extension.id}" is already defined`);
	      }
	      drafts2.ephemeral.extensions.byId[extension.id] = extension;
	      const allPaneClasses = drafts2.ephemeral.extensions.paneClasses;
	      (_a = extension.panes) == null ? void 0 : _a.forEach((classDefinition) => {
	        if (typeof classDefinition.class !== "string") {
	          throw new Error(`pane.class must be a string`);
	        }
	        if (classDefinition.class.length < 3) {
	          throw new Error(`pane.class should be a string with 3 or more characters`);
	        }
	        const existing = allPaneClasses[classDefinition.class];
	        if (existing) {
	          throw new Error(`Pane class "${classDefinition.class}" already exists and is supplied by extension ${existing}`);
	        }
	        allPaneClasses[classDefinition.class] = {
	          extensionId: extension.id,
	          classDefinition
	        };
	      });
	    });
	  }
	  getStudioProject(core) {
	    return this._cache.get("getStudioProject", () => core.getProject("Studio"));
	  }
	  getExtensionSheet(extensionId, core) {
	    return this._cache.get("extensionSheet-" + extensionId, () => this.getStudioProject(core).sheet("Extension " + extensionId));
	  }
	  undo() {
	    this._store.undo();
	  }
	  redo() {
	    this._store.redo();
	  }
	  createContentOfSaveFile(projectId) {
	    return this._store.createContentOfSaveFile(projectId);
	  }
	};

	// shared/src/globalVariableNames.ts
	var studioBundle = "__TheatreJS_StudioBundle";
	var coreBundle = "__TheatreJS_CoreBundle";

	// studio/src/StudioBundle.ts
	var StudioBundle = class {
	  constructor(_studio) {
	    this._studio = _studio;
	    __publicField(this, "_coreBundle");
	  }
	  get type() {
	    return "Theatre_StudioBundle";
	  }
	  registerCoreBundle(coreBundle2) {
	    if (this._coreBundle) {
	      throw new Error(`StudioBundle.coreBundle is already registered. This is a bug.`);
	    }
	    this._coreBundle = coreBundle2;
	    let coreBits;
	    coreBundle2.getBitsForStudio(this._studio, (bits) => {
	      coreBits = bits;
	    });
	    this._studio.setCoreBits(coreBits);
	  }
	};

	// studio/src/uiComponents/toolbar/ToolbarSwitchSelect.tsx
	var import_react174 = __toModule(react.exports);
	var import_styled_components80 = __toModule(require$$3);
	var Opt = (0, import_styled_components80.default)(ToolbarIconButton_default)``;
	function OptionButton({
	  value,
	  label,
	  icon,
	  onClick,
	  isSelected
	}) {
	  return /* @__PURE__ */ import_react174.default.createElement(import_react174.default.Fragment, null, /* @__PURE__ */ import_react174.default.createElement(Opt, {
	    forwardedAs: Button,
	    className: isSelected ? "selected" : void 0,
	    "aria-label": label,
	    onClick,
	    title: label
	  }, icon));
	}
	var Container60 = (0, import_styled_components80.default)(Group)`
  display: flex;
  gap: 5px;
`;
	var ToolbarSwitchSelect = ({
	  value: valueOfSwitch,
	  onChange,
	  options
	}) => {
	  return /* @__PURE__ */ import_react174.default.createElement(Container60, null, options.map(({ label, icon, value: optionValue }) => /* @__PURE__ */ import_react174.default.createElement(OptionButton, {
	    key: optionValue,
	    value: optionValue,
	    isSelected: valueOfSwitch === optionValue,
	    label,
	    icon,
	    onClick: () => onChange(optionValue)
	  })));
	};
	var ToolbarSwitchSelect_default = ToolbarSwitchSelect;

	// studio/src/uiComponents/toolbar/ToolbarDropdownSelect.tsx
	var import_react175 = __toModule(react.exports);
	var import_styled_components81 = __toModule(require$$3);
	var Container61 = import_styled_components81.default.div``;
	var ToolbarDropdownSelect = (props) => {
	  return /* @__PURE__ */ import_react175.default.createElement(Container61, null);
	};
	var ToolbarDropdownSelect_default = ToolbarDropdownSelect;

	// studio/src/index.ts
	var studioPrivateAPI = new Studio();
	setStudio(studioPrivateAPI);
	var studio2 = studioPrivateAPI.publicApi;
	var src_default = studio2;
	registerStudioBundle();
	function registerStudioBundle() {
	  if (typeof window == "undefined")
	    return;
	  const existingStudioBundle = window[studioBundle];
	  if (typeof existingStudioBundle !== "undefined") {
	    if (typeof existingStudioBundle === "object" && existingStudioBundle && typeof existingStudioBundle.version === "string") {
	      throw new Error(`It seems that the module '@theatre/studio' is loaded more than once. This could have two possible causes:
1. You might have two separate versions of theatre in node_modules.
2. Or this might be a bundling misconfiguration, in case you're using a bundler like Webpack/ESBuild/Rollup.

Note that it **is okay** to import '@theatre/studio' multiple times. But those imports should point to the same module.`);
	    } else {
	      throw new Error(`The variable window.${studioBundle} seems to be already set by a module other than @theatre/core.`);
	    }
	  }
	  const studioBundle2 = new StudioBundle(studioPrivateAPI);
	  window[studioBundle] = studioBundle2;
	  const possibleCoreBundle = window[coreBundle];
	  if (possibleCoreBundle && possibleCoreBundle !== null && possibleCoreBundle.type === "Theatre_CoreBundle") {
	    studioBundle2.registerCoreBundle(possibleCoreBundle);
	  }
	}
	/*! queue-microtask. MIT License. Feross Aboukhadijeh <https://feross.org/opensource> */
	/**
	 * @license
	 * Lodash (Custom Build) <https://lodash.com/>
	 * Build: `lodash modularize exports="es" -o ./`
	 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
	 * Released under MIT license <https://lodash.com/license>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 */
	/** @license MIT License (c) copyright 2010-2014 original author or authors */

	}(dist, dist.exports));

	var studio = /*@__PURE__*/getDefaultExportFromCjs(dist.exports);

	window.getProject = dist$2.getProject;
	window.studio = studio;
	window.t = dist$2.types;

})();
