// ------------- sound-trigger‑2.js ----------------
var SoundTrigger2 = pc.createScript('soundTrigger2');

// Attributs
SoundTrigger2.attributes.add('camera',       { type: 'entity', title: 'Caméra' });
SoundTrigger2.attributes.add('targetEntity', { type: 'entity', title: 'Entité Cible' });
SoundTrigger2.attributes.add('maxDistance',  { type: 'number', default: 10, title: 'Distance Max' });
SoundTrigger2.attributes.add('soundAsset',   { type: 'asset',  assetType: 'audio', title: 'Son' });

SoundTrigger2.prototype.initialize = function () {
    this.soundPlayed = false;

    // Ajoute le composant Sound si besoin
    if (!this.entity.sound) {
        this.entity.addComponent('sound', { positional: false, volume: 0.8 });
    }

    // Slot unique « slotTrigger »
    if (!this.entity.sound.slot('slotTrigger')) {
        this.entity.sound.addSlot('slotTrigger', { asset: this.soundAsset, loop: false, volume: 0.8 });
    }
};

SoundTrigger2.prototype.update = function (dt) {
    if (this.soundPlayed) return;
    if (!this.camera || !this.targetEntity) return;

    var camPos    = this.camera.getPosition();
    var targetPos = this.targetEntity.getPosition();
    var distance  = targetPos.clone().sub(camPos).length();

    if (distance > this.maxDistance) return;

    var screenPos = new pc.Vec3();
    this.camera.camera.worldToScreen(targetPos, screenPos);
    var w = this.app.graphicsDevice.width,
        h = this.app.graphicsDevice.height;

    if (screenPos.z < 0 || screenPos.x < 0 || screenPos.x > w || screenPos.y < 0 || screenPos.y > h) return;

    // Lecture
    this.entity.sound.play('slotTrigger');
    this.soundPlayed = true;
};
