/* eslint-disable no-undef */
var Animator2 = pc.createScript('animator2');

/*─────────────────────────────────────────────
 * ATTRIBUTS
 *─────────────────────────────────────────────*/
Animator2.attributes.add('entitiesToAnimate', {
    type: 'entity',
    array: true,
    title: 'Entities To Animate'
});
Animator2.attributes.add('triggerEvent', {
    type: 'string',
    default: 'anim:start',
    title: 'PlayCanvas Event'
});
Animator2.attributes.add('playFromStart', {
    type: 'boolean',
    default: true,
    title: 'Restart From 0'
});
Animator2.attributes.add('cameraToDisableName', {
    type: 'string',
    default: 'cam1',
    title: 'Camera To Disable'
});
Animator2.attributes.add('cameraToEnableName', {
    type: 'string',
    default: 'animator_cam1',
    title: 'Camera To Enable'
});

/*─────────────────────────────────────────────
 * INITIALISATION
 *─────────────────────────────────────────────*/
Animator2.prototype.initialize = function () {

    /* rotation helper */
    this.quat = new pc.Quat();
    const toEuler = (q) => { const v = new pc.Vec3(); q.getEulerAngles(v); return v; };

    /* TheatreJS : chargement du NOUVEAU fichier */
   studio.initialize();
 studio.ui.hide();
// -- TheatreJS
//studio.initialize();

// Laisser une frame à Studio pour se monter,
// puis demander explicitement l’affichage
//requestAnimationFrame(() => studio.ui.restore());
    const state = this.app.assets.find('animation2.json')?.resource; // ← nouveau nom
    const proj  = getProject('anim2', { state });                    // ← nouveau projet
    this.sheet  = proj.sheet('Main');

    const num = (v, p = 0.01) => t.number(v, { nudgeMultiplier: p });

    /* objets Theatre */
    this.entitiesToAnimate.forEach((ent) => {
        if (!ent) return;

        const pos = ent.getLocalPosition();
        const scl = ent.getLocalScale();
        const rot = toEuler(ent.getLocalRotation());

        const obj = this.sheet.object(`Entity:${ent.name}`, {
            position: { x: num(pos.x), y: num(pos.y), z: num(pos.z) },
            rotation: { x: num(rot.x), y: num(rot.y), z: num(rot.z) },
            scale:    { x: num(scl.x), y: num(scl.y), z: num(scl.z) },
            visible:  true
        });

        obj.onValuesChange((v) => this._applyTransform(ent, v));
    });

    /* déclencheur + raccourcis */
    this.app.on(this.triggerEvent, this._playSequence, this);
    this.app.keyboard.on(pc.EVENT_KEYDOWN, this.onKeyDown, this);
};

Animator2.prototype.destroy = function () {
    this.app.off(this.triggerEvent, this._playSequence, this);
};

/*─────────────────────────────────────────────
 * LANCE LA SÉQUENCE + switch caméras
 *─────────────────────────────────────────────*/
Animator2.prototype._playSequence = function () {
    this._switchCameras();
    if (this.playFromStart) this.sheet.sequence.position = 0;
    this.sheet.sequence.play();
};

Animator2.prototype._switchCameras = function () {
    const allCams = this.app.root.findComponents('camera');
    let offOK = false, onOK = false;

    allCams.forEach((c) => {
        const e = c.entity;
        if (e.name === this.cameraToDisableName) {
            e.enabled = true; c.enabled = true; c.priority = 0;
            offOK = true;
        }
        if (e.name === this.cameraToEnableName) {
            e.enabled = true; c.enabled = true; c.priority = 9999;
            onOK = true;
        }
    });

    if (!offOK) console.warn(`Camera “${this.cameraToDisableName}” not found.`);
    if (!onOK)  console.warn(`Camera “${this.cameraToEnableName}” not found.`);
};

/* appli‑transformations */
Animator2.prototype._applyTransform = function (ent, v) {

    const m = ent.model;
    if (m) v.visible ? m.show() : m.hide();

    ent.setLocalPosition(v.position.x, v.position.y, v.position.z);
    ent.setLocalScale   (v.scale.x,    v.scale.y,    v.scale.z);

    if (ent.camera) {
        ent.setEulerAngles(v.rotation.x, v.rotation.y, v.rotation.z);
    } else {
        this.quat.setFromEulerAngles(v.rotation.x, v.rotation.y, v.rotation.z);
        ent.setLocalRotation(this.quat);
    }
};

/* toggle flyCamera actif — touche F */
Animator2.prototype._toggleFlyCamera = function () {
    const cams = this.app.root.findComponents('camera');
    for (let i = 0; i < cams.length; i++) {
        const e = cams[i].entity;
        if (!e.camera.enabled) continue;
        const fly = e.script && e.script.flyCamera;
        if (!fly) return;
        fly.enabled = !fly.enabled;
        console.log('flyCamera', fly.enabled ? 'enabled' : 'disabled');
        return;
    }
};

/* bascule l’UI Theatre — touche X */
Animator2.prototype._toggleStudioUI = function () {
    if (studio.ui.isHidden) {
        if (this.app.mouse && this.app.mouse.disablePointerLock)
            this.app.mouse.disablePointerLock();
        if (document.pointerLockElement)
            document.exitPointerLock();
        studio.ui.restore();
    } else {
        studio.ui.hide();
    }
};

/*─────────────────────────────────────────────
 * RACCOURCIS
 *─────────────────────────────────────────────*/
Animator2.prototype.onKeyDown = function (e) {

    switch (e.key) {

        case pc.KEY_SPACE:
            this.sheet.sequence.position = 0;
            this.sheet.sequence.play();
            break;

        case pc.KEY_V:
            const json = studio.createContentOfSaveFile('scene1');
            navigator.clipboard.writeText(JSON.stringify(json));
            alert('JSON copied to clipboard!');
            break;

        case pc.KEY_F:
            this._toggleFlyCamera();
            break;

        case pc.KEY_X:
            this._toggleStudioUI();
            break;
    }
};
