#pragma once

#define _DISABLE_STRING_ANNOTATION
#define _DISABLE_VECTOR_ANNOTATION

#define DISTRIB

// #define DEMO_NAME "Passage"
#define DEMO_NAME "Chuliau"

#ifdef DISTRIB
	#define RES_PICKER
	#undef TRACY_ENABLE
	// #define EDITOR
	// #define GL_DEBUG_ENABLED
#else
#ifdef RELEASE
	// #define TRACY_ENABLE
	#define GL_DEBUG_ENABLED
	#define EDITOR
	#define LIVEPP_ENABLED
	#define DBG_PRINT
#else
	// #define TRACY_ENABLE
	#define GL_DEBUG_ENABLED
	#define EDITOR
	#define DBG_PRINT
	#define LIVEPP_ENABLED
	// #undef EDITOR
#endif
#endif

#ifdef TRACY_ENABLE
	// #define JPH_DISABLE_CUSTOM_ALLOCATOR
#endif

#define SPDLOG_NO_EXCEPTIONS


#define wlog_info(...) Globals::log->log_info(__LINE__, __FILE__, __VA_ARGS__);
#define wlog_warn(...) Globals::log->log_warn(__LINE__, __FILE__, __VA_ARGS__);
#define wlog_err(...) Globals::log->log_err(__LINE__, __FILE__, __VA_ARGS__);

// #include "engine/WLog.h"
// void* operator new(std::size_t size);
// void operator delete(void* ptr) noexcept;

//#include <LivePP/API/x64/LPP_API.h>

#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#define VC_LEANMEAN
#define VC_EXTRALEAN

class Framebuffer;
class Engine;
class WLog;

class Globals {
 public:
  static Globals* global;
  static Engine* engine;
  static WLog* log;
  static void* lppAgent;
};

#define WEngine Globals::engine

#define slf this auto&& self

#define XRES 1280
#define YRES 720

// #define XRES 900
// #define YRES 1000

// #define XRES 1080
// #define YRES 720

// #define XRES 720
// #define YRES 1080

// #define XRES 1920
// #define YRES 1080

constexpr float pi = 3.14159265358979323846;
constexpr float tau = 2.0 * 3.14159265358979323846;
constexpr int kilobyte_in_bytes = 1024;
constexpr int megabyte_in_bytes = kilobyte_in_bytes * 1024;
constexpr int gigabyte_in_bytes = megabyte_in_bytes * 1024;

#include "glew.h"
#include "GL/gl.h"
#include "glext.h"
#include "wglext.h"

// declare this symbol if your code uses floating point types
// extern "C" int _fltused;

// #pragma data_seg(".pixelfmt")
// static const PIXELFORMATDESCRIPTOR pfd = {
// #if BREAK_COMPATIBILITY
// 	#if POST_PASS
// 			0, 0, PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER, PFD_TYPE_RGBA,
// 			0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, PFD_MAIN_PLANE, 0, 0, 0, 0
// 	#else
// 			0, 0, PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER, PFD_TYPE_RGBA,
// 			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, PFD_MAIN_PLANE, 0, 0, 0, 0
// 	#endif
// #else
// 	sizeof(pfd), 1, PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER, PFD_TYPE_RGBA,
// 	32, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 32, 0, 0, PFD_MAIN_PLANE, 0, 0, 0, 0
// #endif
// };
//
// #pragma data_seg(".screensettings")
// static DEVMODE screenSettings = { 
// 	{0}, 0, 0, sizeof(screenSettings), 0, DM_PELSWIDTH|DM_PELSHEIGHT,
// 	{0}, 0, 0, 0, 0, 0, {0}, 0, 0, XRES, YRES, 0, 0,
// 	#if(WINVER >= 0x0400)
// 		0, 0, 0, 0, 0, 0,
// 			#if (WINVER >= 0x0500) || (_WIN32_WINNT >= 0x0400)
// 			0, 0
// 		#endif
// 	#endif
// };
//


// currently unused definitions
#ifdef EDITOR
	#define FAIL_KILL false
	#define PID_QUALIFIER


#else
	#define FAIL_KILL true
	#define PID_QUALIFIER const
#endif


