﻿#pragma once

// #include "math/Math.h"

#include "engine/model/ModelNode.h"
// #include "engine/model/Mesh.h"

class Buffer;
class Texture;
class Model;

class Mesh;

class Model;



class Model {
	public:
		std::vector<Mesh*> meshes;
		std::vector<Mesh*> mesh_outlines;
		std::vector<Texture*> textures;

		std::vector<aiLight> lights;

		std::vector<ModelNode> nodes;

		int generation;
		int alloc_slot;

		ModelNode* parent_node;
		smallvec<ModelNode*, 100> parse_node(aiNode* parent_node, ModelNode* curr_model_node);

		Buffer* buff_tex_coords;
		Buffer* buff_normals;
		Buffer* buff_vert_indices;
		Buffer* buff_verts;

		const aiScene* ai_scene = nullptr;
		const aiScene* scene_non_triangulated = nullptr;

		bool outlines = true;

		std::string path;
		std::atomic<long> last_change_timestamp;
		// Assimp::Importer importer;

		Model(std::string path);
		void re_create();
};



