in vec2 uv;

out vec4 C;

uniform float u_t;
uniform int tex_drawing;

#include scene_jyrevis25/common.glsl

float box(vec2 p){vec2 q=abs(p); return max(q.x,q.y);}

void main() {
    vec2 UV=vec2(uv.x*R.x/R.y, uv.y);

    vec3 col = c_blue;

    vec2 TR = UV-vec2(16.0/9.0, 1.0);
    col = mix(col, c_beige, step(length(TR),0.6));
    
    vec2 polar = vec2((atan(TR.y, TR.x)+PI)/TAU, length(TR));
    polar.x = fract(polar.x*32.0+u_t);

    col = mix(col, c_beige, step(abs(polar.x-0.5),0.15/polar.y)*step(0.8,length(TR)));

    col = mix(col, c_beige, step(box((UV-vec2(-1.0,-0.5))*3.0),1.0));
    col = mix(col, c_beige, step(box((UV-vec2(-0.6,-0.1))*rot(PI/4.0)*5.0),1.0));

    col = mix(col, c_yellow, step(0.5,texture(textures[tex_drawing],uv*vec2(R.x/R.y,1.0)*0.1-vec2(0.8,0.4)).r));

    C = vec4(col, 1.0);
}
