// struct Vert{
//     vec2 pos;
//     float weight;
//     float duration; ?
// };

uniform vec4* vert_buff;
uniform mat4 trans;
uniform vec2 dim;

out vec2 out_pos;

#define perp mat2(0.0,-1.0,1.0,0.0)

void main() {
    int ind = gl_VertexID/6;
    int edge = gl_VertexID%6;
    vec2 pa = (trans*vec4(vert_buff[ind].xy,0,1)).xy;
    vec2 pb = (trans*vec4(vert_buff[ind+1].xy,0,1)).xy;

    float width = vert_buff[ind].z;
    // float width = 0.01;

    vec2 edges[6];
    if(ind==0) {
        edges[0] = pa+normalize(pb-pa)*perp*width;
        edges[1] = pa-normalize(pb-pa)*perp*width;
    } else {
        vec2 pp = (trans*vec4(vert_buff[ind-1].xy,0,1)).xy;
        edges[0] = pa+normalize(pa-pp)*perp*vert_buff[ind-1].z;
        edges[1] = pa-normalize(pa-pp)*perp*vert_buff[ind-1].z;
    }
    
    edges[2] = pb+normalize(pb-pa)*perp*width;
    edges[3] = edges[1];
    edges[4] = edges[2];
    edges[5] = pb-normalize(pb-pa)*perp*width;

    out_pos = edges[edge] * vec2(dim.y/dim.x,1.0);
    
    gl_Position = vec4(out_pos,0.0,1.0);
}
