
out vec2 uv;
out vec3 norm;

uniform bool is_shadow;
uniform int curr_rendering_light;
uniform int spot_sublight_idx;

out vec3 ws_pos;
out float DD;

out vec4 cs_pos;
out vec4 cs_pos_prev;

out flat int draw_id;

//uniform int potato;

//uniform int* indices_buff;
//uniform vec3* verts_buff;
//uniform vec3* normals_buff;
//uniform vec2* texcoords_buff;

//uniform mat4 mat;
//uniform mat4 prev_mat;
//uniform mat4 rot_mat;
//uniform bool has_texcoords;
//uniform bool has_albedo_tex;
//
//uniform int buff_normals_offs;
//uniform int buff_tex_coords_offs;
//uniform int buff_vert_indices_offs;
//uniform int buff_verts_offs;


struct MDIUniforms{
	mat4 rot_mat;
	mat4 mat;
	mat4 prev_mat;

	int buff_normals_offs;
	int buff_tex_coords_offs;
	int buff_vert_indices_offs;
	int buff_verts_offs;


	int tex_albedo;
	int has_albedo_tex;
	int g;
	int h;
};

uniform MDIUniforms* mdi_uniforms_buff;

//mat4 get_view(vec3 ro, vec3 rd){
//	vec3 dir = normalize(-cam_dir);
//	vec3 right = normalize(cross(vec3(0,1,0), dir));
//	vec3 up = normalize(cross(dir, right));
//
//	mat4 m = mat4(1);
//
//	m = mat4(
//		1,0,0,0,
//		0,1,0,0,
//		0,0,1,0,
//		-cam_pos.x,-cam_pos.y,-cam_pos.z,1
//	);
//	m = V * m;
//
//	return m;
//}

void main_test();

void main(){

	main_test();

	
}

void main_test(){
//	if(is_shadow){
//		print(gl_VertexID);
//	}
	float quant_dist = 0.01;

	MDIUniforms un = mdi_uniforms_buff[gl_DrawID];
	draw_id = gl_DrawID;

	int vert_idx = indices_buff[un.buff_vert_indices_offs + gl_VertexID];
	vec3 vert = verts_buff[un.buff_verts_offs + vert_idx];

	norm = normals_buff[un.buff_normals_offs + vert_idx];
	norm = ((un.rot_mat) * vec4(norm,1.0)).xyz;

	vec4 pos = vec4(vert,1);
	pos = un.mat * pos;

	if(is_shadow){
//		if(gl_DrawID < 4 && gl_VertexID < 2){
//			print(gl_VertexID);
//		}
//		print(gl_VertexID);
		Light light = lights[curr_rendering_light];

		mat4 view_mat = light.view_mat;
		mat4 proj_mat = light.proj_mat;

		if(light.type == LIGHT_TYPE_POINT){
			view_mat = light.view_mats_point[spot_sublight_idx];

//			gl_FragDepth = length(out_pos - lights[curr_rendering_light].pos) / lights[curr_rendering_light].far;
		}

//		gl_Position = proj_mat * view_mat * vec4(pos.xyz,1.0);

		ws_pos = (un.mat * vec4(vert.xyz,1)).xyz;

		DD = length(ws_pos - lights[curr_rendering_light].pos) / lights[curr_rendering_light].far;

		gl_Position = proj_mat * view_mat * vec4(ws_pos.xyz,1.0);

//		gl_Position = proj_mat * view_mat * (un.mat * vec4(vert.xyz,1));
//		gl_Position = ((un.mat * vec4(vert.xyz,1)) * view_mat * proj_mat);

//		gl_Position = vec4(0);
	} else {
		if(un.has_albedo_tex > 0){
			vec2 tex_coord = texcoords_buff[un.buff_tex_coords_offs + vert_idx];
			uv = tex_coord;
			uv = 1-uv;
			uv.y = 1-uv.y;
		} else {
			uv = vec2(0.5);
		}

		ws_pos = (un.mat * vec4(vert.xyz,1)).xyz;
		cs_pos = (P * V * un.mat * vec4(vert.xyz,1));
		cs_pos_prev = (P_prev * V_prev * un.prev_mat * vec4(vert.xyz,1));

		pos = V * pos;
		pos = P * pos;
		gl_Position = pos;
	}


//	vert = floor(vert/quant_dist)*quant_dist;

//	if(u.has_texcoords > 0){
	#ifdef SHADOW_MAP
//		ws_pos *= 0.5;
//		is_shadow = true;
	#else
		if(false){
//			float depth = pos.z;

//			if(is_shadow){
//				//		pos.z += 0.02;
//			}
//			pos.xy = (pos.xy + vec2(1.0, 1.0)) * R * 0.5;
//			quant_dist = 5.01*(1 + pow(abs(depth)/cam_far,2.0) * 240*1.0);
//			if(!is_shadow){
//				pos.xy = round(pos.xy/quant_dist)*quant_dist;
//			} else {
//			}
//			pos.xy = pos.xy * 2.0 / R - 1.0;

		}
		//	pos.w = 1.0;
		//	pos.xyz = floor(pos.xyz/quant_dist)*quant_dist;
	#endif
}
