// The position, normal vector and color of the currently processed vertex.
in vec4 p3d_Vertex;
in vec3 p3d_Normal;
in vec4 p3d_Color;

// The texture coordinates associated with the Nth texture.
in vec2 p3d_MultiTexCoord0;
in vec2 p3d_MultiTexCoord1;
in vec2 p3d_MultiTexCoord2;

// These are the tangent and binormal vectors, if present.  If an index is appended,
// it will use the set of binormals and tangents associated with the Nth texture.
in vec3 p3d_Binormal;
in vec3 p3d_Binormal0;
in vec3 p3d_Binormal1;
in vec3 p3d_Tangent;
in vec3 p3d_Tangent0;
in vec3 p3d_Tangent1;

// Some models, such as those loaded from glTF, only have a 4-component tangent
// vector and no binormal.  In this case, the binormal is derived as follows:
//   binormal = cross(p3d_Normal, p3d_Tangent.xyz) * p3d_Tangent.w
//in vec4 p3d_Tangent;

// A vertex column named "anything".  The number of components should match up with
// that of the vertex array.  "uvec" and "ivec" variants are allowed for integer
// vertex arrays to access un-normalized data.
in vec4 anything;

// These two attributes will be present when hardware skinning is enabled.
// transform_index contains indices into the p3d_TransformTable array for the four
// most influential joints, and transform_weight the corresponding weights.
in vec4 transform_weight;
//in uvec4 transform_index;  // Temporary workaround for a bug in the GLSL compiler