#version 410

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;  // Combined model-view-projection matrix

// Vertex inputs
in vec4 p3d_Vertex;  // Vertex position in model space
in vec2 p3d_MultiTexCoord0;  // Texture coordinates

// Output to fragment shader
out vec2 vertMultiTexCoord0;  // Texture coordinates to be passed to the fragment shader
out vec4 vertPosition;

void main() {
    // Transform the vertex position by the model-view-projection matrix
    gl_Position = p3d_ModelViewProjectionMatrix * p3d_Vertex;

    // Pass the texture coordinates to the fragment shader
    vertMultiTexCoord0 = p3d_MultiTexCoord0;
    vertPosition = p3d_Vertex;
}
