  .macro padto label size fill=0xff
  .skip (\size + \label - .), \fill
  .endm

# silence warning
.global _start

.section .text

ehdr:
  .byte 0x7f           # ei_mag0
  .ascii "ELF"         # ei_mag3

_block0:
  li a0, -100   # +4
  li a2, 2      # +2
  ecall         # +4
  j _block3     # +2
  padto ehdr, 16

# 02 00        c.slli x0, 64 (hint nop)
# f3 00 xx xx  hypervisor VM load/store
  .2byte 2             # e_type EXEC
  .2byte 0xf3          # e_machine RISC-V

_block1:
  li a7, 56   # +4
  padto _block1, 4

# with .text @ 0xb7ed1000
# 28 10        c.addi4spn a0, 40
# ed b7        c.j -22 (_block0)
# 00 00        illegal (x2)
  .8byte _start        # e_entry
  .8byte phdr_off      # e_phoff

_start:
_block2:
  jal a1, _block1

fb_path:
  .asciz "/dev/fb0"
  padto _block2, 14, 0

# 38 00        c.addi4spn x14/a4, 8
# 01 00        c.nop
  .2byte 0x38          # e_phentsize
# .2byte 1             # e_phnum

phdr:
# 01 00        c.nop
# 00 00        illegal
  .4byte 1             # p_type LOAD
  .byte 5              # p_flag RWX
  .skip 3

  .8byte 0             # p_offset
  .8byte ehdr          # p_vaddr

_block3:
  mv a4, a0   # +2
  li a3, 1    # +2
  li a2, 3    # +2
  j _block4   # +2
  padto _block3, 8

  .8byte file_size     # p_filesz
  .8byte file_size     # p_memsz

  .set phdr_off, phdr - ehdr

_block4:
  .incbin "payload.bin"

file_end:
  .set file_size, file_end - ehdr
