struct Uniforms {
    scale: f32,
    move: vec2<f32>,
    tex_start: vec2<f32>,
    tex_size: vec2<f32>,
}

@group(0) @binding(0) var<uniform> uniforms: Uniforms;

struct VertexInput {
    @location(0) position: vec3<f32>,
    @location(1) normal: vec3<f32>,
    @location(2) tangent: vec3<f32>,
    @location(3) uv: vec2<f32>,
}

struct VertexOutput {
    @builtin(position) position: vec4<f32>,
    @location(0) uv: vec2<f32>,
}

@vertex
fn main(input: VertexInput) -> VertexOutput {
    let c = vec2<f32>(input.position.x, -input.position.z);
    let pos = c * uniforms.tex_size * uniforms.scale + uniforms.move;
    
    var output: VertexOutput;
    output.position = vec4<f32>(pos, 0.0, 1.0);
    output.uv = input.uv * uniforms.tex_size + uniforms.tex_start;
    return output;
}