; Christmas computing challenge
; Ken Willmott 2025-12-07
; writes a snowflake to the terminal

; hardware equates

ACIAC   EQU   $EB00          ; ACIA Control
ACIAD   EQU   ACIAC+1        ; ACIA Data

; other equates

SPACE	equ ' '
STAR	equ '*'
ANSI_CSI	equ ($1b<<8) | '['


; program base
	org	$0

START:
; initialization

	lda   #$03           ; Reset the ACIA
        sta   ACIAC
        lda   #$15           ; Configure the ACIA
        sta   ACIAC

; main
	ldx #ANSI_CLS
	jsr PUT_STR	; clear screen
	
; **********************
; place 19x19 cross

	ldb #-9
	pshs b		; preserve loop counter
crossloop:
	
	ldb ,s		; modify B for x coordinate line
	addb XCENTER
	lda YCENTER
	pshs b,a
	jsr ansiXY
	leas 2,s
	lda #STAR
	jsr serPut
	
	lda ,s		; modify A for y coordinate line
	adda YCENTER
	ldb XCENTER
	pshs b,a
	jsr ansiXY
	leas 2,s
	lda #STAR
	jsr serPut
	
	lda ,s
	adda #1
	sta ,s
	cmpa	#10
	bne crossloop
	puls b	
	
; **************************
; copy pattern buffer to output

; initialize loop counters
	lda #1
	sta PATY
; point X to pattern buffer
	ldx #lines	

YLOOP:
	lda #1
	sta PATX

	lda ,x
XLOOP:
	bita #$80	; examine high bit
	beq pat2	; skip if zero

; do lower right quadrant
	pshs a,x
	
	ldb PATX
	addb XCENTER
	lda PATY
	adda YCENTER
	pshs a,b
	bsr ansiXY
	leas 2,s
	lda #STAR
	jsr serPut
	
	ldb PATX
	addb XCENTER
	lda PATY
	nega
	adda YCENTER
	pshs a,b
	bsr ansiXY
	leas 2,s
	lda #STAR
	jsr serPut

	ldb PATX
	negb
	addb XCENTER
	lda PATY
	adda YCENTER
	pshs a,b
	bsr ansiXY
	leas 2,s
	lda #STAR
	jsr serPut

	ldb PATX
	negb
	addb XCENTER
	lda PATY
	nega
	adda YCENTER
	pshs a,b
	bsr ansiXY
	leas 2,s
	lda #STAR
	jsr serPut
	
	puls a,x
pat2:

; finalize inner loop
	lsla	
	ldb PATX
	incb
	stb PATX
	cmpb #9
	bne XLOOP

; finalize outer loop
	leax 1,x
	ldb PATY
	incb
	stb PATY
	cmpb #9
	lbne YLOOP

; exit at home position

stop:	ldd #$0101
	pshs b,a
	bsr ansiXY
	leas 2,s
	
; back to OS
	rts

; ***************************************************************
; send ANSI string that contains x,y position
; parameters on stack
; Ypos	S+2
; Xpos	S+3
; but in this case we're just pulling them off the stack,
; push order is x,y
; so using CPU push order A=y, B=x

ansiXY:	
	ldb 2,s		; convert y value to decimal
	cmpb #25
	bhs range
	bsr toDec
	std YPOSD
	ldb 3,s		; convert x value to decimal
	cmpb #80
	bhs range
	bsr toDec
	std XPOSD
	ldx #ANSI_CUP
	bsr PUT_STR
range:	rts

; binary byte to decimal
; helper routine
; value passed in B
; two ASCII digits returned in D

toDec:
	clra		; 10's count in A
toD1:	cmpb #10
	bcs toD2	; branch if less than 10	
	inca		; else first digit is 0
	subb #10
	bra toD1
toD2:	addd #$3030	; convert both nybbles to ASCII
	rts

; ***************
; write string pointed to by X to output

PUT_STR:
ans0:	lda	,x+
	beq	ans1
	bsr	serPut
	bne	ans0
	
ans1:	rts

; ****************************
; output char in A to MC6850 UART
; uses only A

serPut:	pshs b
ser1:	ldb	ACIAC
	lsrb
	lsrb
	bcc	ser1
	sta	ACIAD
	puls b
	rts

; data section

; constants
lines:
	fcb %10010010
	fcb %01001001
	fcb %00100000
	fcb %10010000
	fcb %01001110
	fcb %00001100
	fcb %10001010
	fcb %01000000
		
; variables
val	rmb 2
Xvalue	rmb 1
term1	rmb 1

PATX	rmb 1
PATY	rmb 1

XCENTER fcb 40
YCENTER	fcb 12

; ANSI sequences
;

; ANSI clear screen string

ANSI_CLS	fdb ANSI_CSI
		fcc "2J"
		fcb 0

; ANSI position cursor command string

ANSI_CUP	fdb ANSI_CSI
YPOSD		rmb 2
		fcb ';'
XPOSD		rmb 2
		fcb 'H'
		fcb 0

PROG_SIZE	 equ *-START

