
#version 430 core
out vec4 FragColor;

uniform sampler2D source;
uniform vec4 radius;
uniform vec4 iResolution;


void main()
{
    int           N = 13;
    float z = ceil(max(0.,log2(radius.x*iResolution.y/float(N))));
    vec2 U = gl_FragCoord.xy / iResolution.y;
    vec2 D = vec2(0, 1);  

    vec4  O = vec4(0);
    float r = float(N-1)/2., g, t=0., x;
    for( int k=0; k<N; k++ ) {
        x = float(k)/r-1.;
        t += g = exp(-2.*x*x );
        O += g * textureLod(source, (U+radius.x*x*D) *iResolution.y/iResolution.xy, z );
    }
    FragColor = O/t;                                                             \
}