/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common.tricks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import org.kd.common.tricks.TravellingLogo;

public class TwoMovingBackgrounds {
    private final TravellingLogo rearBackground;
    private final TravellingLogo frontBackground;
    private final float screenWidth;
    private final float screenHeight;

    public TwoMovingBackgrounds(String rearBackgroundPath, String frontBackgroundPath, float screenWidth, float screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        Texture rearBackgroundTxt = new Texture(rearBackgroundPath);
        Texture frontBackgroundTxt = new Texture(frontBackgroundPath);
        this.rearBackground = new TravellingLogo(rearBackgroundTxt, screenWidth, 0.0f, (float)rearBackgroundTxt.getWidth() * 2.0f, rearBackgroundTxt.getHeight());
        this.frontBackground = new TravellingLogo(frontBackgroundTxt, screenWidth, 80.0f, frontBackgroundTxt.getWidth(), frontBackgroundTxt.getHeight());
        this.rearBackground.spriteSpeed = 43.0f;
        this.frontBackground.spriteSpeed = 12.0f;
    }

    public void update() {
        float delta = Gdx.graphics.getDeltaTime();
        long frame = Gdx.graphics.getFrameId();
        this.rearBackground.move(delta, Math.round(this.screenWidth));
        this.frontBackground.move(delta, Math.round(this.screenWidth));
        float y = (float)(80.0 + 30.0 * Math.sin((double)frame / Math.PI / 100.0));
        System.out.println("y " + y);
        this.frontBackground.sprite.setY(y);
    }

    public void draw(SpriteBatch batch) {
        this.rearBackground.draw(batch, Math.round(this.screenWidth), Math.round(this.screenHeight));
        this.frontBackground.draw(batch, Math.round(this.screenWidth), Math.round(this.screenHeight));
    }
}

