/*
 * Decompiled with CFR 0.152.
 */
package org.kd.game.duel;

import org.kd.game.common.Roll;
import org.kd.game.duel.Board;
import org.kd.game.duel.Dice;
import org.kd.game.duel.Godzilla;
import org.kd.game.duel.Monster;
import org.kd.game.duel.TRex;

public class Game {
    public Monster currentPlayer;
    private final Board board = new Board();
    private final Monster godzilla = new Godzilla();
    private final Monster trex = new TRex();
    private Roll roll;

    public Game() {
        this.currentPlayer = this.godzilla;
        this.roll = new Roll(6);
    }

    public void executeRoll() {
        long hits = this.roll.getDiceList().stream().filter(d -> d.equals(Dice.HIT)).count();
        this.getOppositePlayer().hp = (int)((long)this.getOppositePlayer().hp - hits);
        long heals = this.roll.getDiceList().stream().filter(d -> d.equals(Dice.REGENERATE)).count();
        this.currentPlayer.hp = (int)((long)this.currentPlayer.hp + heals);
        int direction = this.currentPlayer.equals(this.godzilla) ? 1 : -1;
        long stars = this.roll.getDiceList().stream().filter(d -> d.equals(Dice.STAR_FAME)).count() - 2L;
        this.board.fameMarker.position = (int)((long)this.board.fameMarker.position + (long)direction * Math.max(0L, stars));
        long demolish = this.roll.getDiceList().stream().filter(d -> d.equals(Dice.DEMOLISH_FEAR)).count() - 2L;
        this.board.fearMarker.position = (int)((long)this.board.fearMarker.position + (long)direction * Math.max(0L, demolish));
    }

    public void printLog() {
        System.out.println("Godzilla HP = " + this.godzilla.hp + "T-Rex HP = " + this.trex.hp);
        System.out.println("Star/Fame marker pos = " + this.board.fameMarker.position + " Demolish/fear marker pos = " + this.board.fearMarker.position);
        System.out.println();
    }

    private Monster getOppositePlayer() {
        return this.currentPlayer.equals(this.godzilla) ? this.trex : this.godzilla;
    }
}

