/*
 * Decompiled with CFR 0.152.
 */
package org.kd.kickass;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import java.util.Arrays;
import org.kd.common.tricks.Rosette;
import org.kd.kickass.lib.BootAlphabetScroll;

public class Scene1KickScroll
implements Screen {
    private Sound fok;
    private Sound whatchaLookinAt;
    private Texture tuffGuy;
    private Sprite kick;
    private Sprite boot;
    private Sprite bigBoot;
    private SpriteBatch batch;
    private int W;
    private int H;
    private BootAlphabetScroll scroll;
    private Rosette rosette;
    private ShapeRenderer shapeRenderer;

    @Override
    public void show() {
        this.W = Gdx.graphics.getWidth();
        this.H = Gdx.graphics.getHeight();
        this.batch = new SpriteBatch();
        this.fok = Gdx.audio.newSound(Gdx.files.internal("kickass/audio/fok.mp3"));
        this.whatchaLookinAt = Gdx.audio.newSound(Gdx.files.internal("kickass/audio/WhatAreYouLookingAt.mp3"));
        Arrays.asList(this.fok, this.whatchaLookinAt).forEach(sound -> {
            sound.setLooping(1L, false);
            sound.setVolume(1L, 1.0f);
        });
        this.tuffGuy = new Texture("kickass/wb.png");
        this.boot = new Sprite(new Texture("kickass/boot.png"));
        this.kick = new Sprite(new Texture("kickass/kick.png"));
        this.kick.setPosition((float)this.W * 0.5f - this.kick.getWidth() / 2.0f, 0.1f * (float)this.H);
        this.boot.setPosition(this.kick.getX(), this.kick.getY());
        this.bigBoot = new Sprite(new Texture("kickass/leftboot.png"));
        this.bigBoot.setScale(1.3f);
        this.bigBoot.setPosition((float)this.W / 2.0f - this.bigBoot.getWidth() / 2.0f, 1.2f * (float)this.H);
        String scrollText = "Welcome to this ass kicking demo     In the beginning I would like to send greetings to Pan Areczek of Komoda and Amiga PLUS            Respect for publishing a great magazine and releasing games     Hope to see you soon   ";
        this.scroll = new BootAlphabetScroll(scrollText.toLowerCase(), 480L);
        this.shapeRenderer = new ShapeRenderer();
        this.rosette = new Rosette(3300L, Color.BLACK);
    }

    public void update() {
        long frame = Gdx.graphics.getFrameId();
        if (frame == 200L) {
            Gdx.input.setCursorPosition(this.W, this.H);
            this.whatchaLookinAt.play();
        } else if (frame == 370L) {
            this.fok.play();
        } else if (frame > 370L) {
            this.scroll.update();
        }
        if (frame > 3050L && this.bigBoot.getY() > 85.0f) {
            float y = this.bigBoot.getY() - 4.0f;
            if (frame > 3060L) {
                y -= 2.0f;
            }
            if (frame > 3120L) {
                y -= 5.0f;
                float newScale = this.kick.getScaleY() * 0.985f;
                this.kick.setScale(1.0f, newScale);
                this.kick.setY(this.kick.getY() - 3.0f);
                this.boot.setY(this.boot.getY() - 6.6f);
            }
            this.bigBoot.setY(y);
        }
    }

    @Override
    public void render(float v) {
        this.update();
        Gdx.gl.glClear(16384);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        float frame = v;
        this.batch.begin();
        if (200.0f < frame && frame < 420.0f) {
            this.batch.draw(this.tuffGuy, (float)this.W * 0.5f - (float)this.tuffGuy.getWidth() / 2.0f, 0.1f * (float)this.H);
        }
        if (frame > 420.0f) {
            this.kick.draw(this.batch);
            this.scroll.render(this.batch);
            if (frame > 530.0f && this.kick.getColor().a > 0.2f) {
                float a = this.kick.getColor().a - 0.005f;
                this.kick.setAlpha(a);
            }
            this.boot.draw(this.batch);
            if (frame > 1200.0f) {
                this.bigBoot.draw(this.batch);
            }
        }
        this.batch.end();
        if (frame > (float)this.rosette.getStartFrame()) {
            this.rosette.render(this.shapeRenderer);
        }
    }

    @Override
    public void resize(int i, int i1) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }
}

