/*
 * Decompiled with CFR 0.152.
 */
package org.kd.tricks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;

public class GradientLines {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final Color color;
    private final ShapeRenderer shapeRenderer;

    public GradientLines(ShapeRenderer shapeRenderer, int x, int y, int width, int height, Color startingColor) {
        this.shapeRenderer = shapeRenderer;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = startingColor;
    }

    private void update(boolean r, boolean g, boolean b) {
        if (r) {
            this.color.r = this.adaptColorValue(this.color.r);
        }
        if (g) {
            this.color.g = this.adaptColorValue(this.color.g);
        }
        if (b) {
            this.color.b = this.adaptColorValue(this.color.b);
        }
    }

    private float adaptColorValue(float rgb) {
        float value = Math.min(1.0f, rgb + 0.01f);
        if (value >= 1.0f) {
            value = 0.0f;
        }
        return value;
    }

    public void draw(int frameSkip) {
        if (Gdx.graphics.getFrameId() % (long)frameSkip != 0L) {
            return;
        }
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        for (float y = (float)this.y; y < (float)(this.y + this.height); y += (float)this.height / 255.0f) {
            this.update(false, false, true);
            this.shapeRenderer.setColor(this.color);
            this.shapeRenderer.rect(this.x, y, this.x + this.width, (float)this.height / 255.0f);
        }
        this.shapeRenderer.end();
    }
}

