/*
 * Decompiled with CFR 0.152.
 */
package org.kd.tricks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;

public class GradientRectangleTrick {
    public SpriteBatch batch2;
    protected long initialFrame;
    protected final int x1;
    protected final int y1;
    protected final int x2;
    protected final int y2;
    protected ShapeRenderer shapeRenderer;
    protected Color topColor = new Color(0.0f, 0.0f, 0.5f, 1.0f);
    protected Color bottomColor = new Color(0.4f, 0.7f, 1.0f, 1.0f);
    private float frequency;

    public GradientRectangleTrick(int x1, int y1, int x2, int y2, SpriteBatch batch2, ShapeRenderer shapeRenderer) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.shapeRenderer = shapeRenderer;
        this.frequency = 1000.0f;
        this.initialFrame = Gdx.graphics.getFrameId();
    }

    public void update(boolean r, boolean g, boolean b) {
        long frame = Gdx.graphics.getFrameId() - this.initialFrame;
        System.out.print(" fr=" + frame + " ");
        double x = (double)((float)(frame + 400L) / this.frequency) * 3.14;
        if (r) {
            this.topColor.r = (float)Math.abs(Math.sin(x));
        }
        if (g) {
            this.topColor.g = (float)Math.abs(Math.sin(x));
        }
        if (b) {
            this.topColor.b = (float)Math.abs(Math.sin(x));
        }
    }

    public void drawGradientRectangle() {
        int w = Math.abs(this.x2 - this.x1);
        int h = Math.abs(this.y2 - this.y1);
        this.drawGradientRectangle(this.x1, this.y1, w, h);
    }

    public void drawGradientRectangle(int x, int y, int width, int height) {
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.rect(x, y, width, height, this.topColor, this.topColor, this.bottomColor, this.bottomColor);
        this.shapeRenderer.end();
    }

    public void setFrequency(float frequency) {
        this.frequency = frequency;
    }

    public void setInitialFrame(long initialFrame) {
        this.initialFrame = initialFrame;
    }
}

