/*
 * Decompiled with CFR 0.152.
 */
package org.kd.tricks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;

public class HorizontalGradientTrick {
    private final Color color;
    private final int period;
    private final float x;
    private final float y;
    private final float width;
    private final float height;
    private long startingFrame;

    public HorizontalGradientTrick(float x, float y, float width, float height, Color startingColor, int period) {
        this.color = startingColor;
        this.period = Math.max(1, period);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.startingFrame = -1L;
    }

    public void start() {
        this.startingFrame = Gdx.graphics.getFrameId();
    }

    public void update() {
        if (this.startingFrame < 0L) {
            System.err.println(HorizontalGradientTrick.class.getSimpleName() + " not started. Call start() method.");
            return;
        }
        long frame = Gdx.graphics.getFrameId() - this.startingFrame;
        if (frame % (long)this.period > 0L) {
            return;
        }
        this.color.r = Math.min(1.0f, this.color.r + 0.01f);
        this.color.g = Math.min(1.0f, this.color.g + 0.01f);
        this.color.b = Math.min(1.0f, this.color.b + 0.01f);
    }

    public void draw(ShapeRenderer shapeRenderer) {
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        int i = 0;
        while ((float)i <= this.height) {
            float interpolationFactor = (float)i / this.height;
            float r = this.color.r + interpolationFactor * (1.0f - this.color.r);
            float g = this.color.g + interpolationFactor * (1.0f - this.color.g);
            float b = this.color.b + interpolationFactor * (1.0f - this.color.b);
            shapeRenderer.setColor(r, g, b, 1.0f);
            shapeRenderer.line(this.x, this.y + (float)i, this.x + this.width, this.y + (float)i);
            ++i;
        }
        shapeRenderer.end();
    }
}

